/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var join = require( 'path' ).join;
var readFileSync = require( '@stdlib/fs/read-file' ).sync;
var CLI = require( './../lib' );
var main = require( './fixtures/main.js' );

// Load help text:
var fopts = {
	'encoding': 'utf8'
};
var help = readFileSync( join( __dirname, 'fixtures', 'usage.txt' ), fopts );

// Set the command-line interface options:
var opts = {
	'pkg': require( './../package.json' ),
	'options': require( './fixtures/opts.json' ),
	'help': help,
	'title': true,
	'updates': true
};

// Create a new command-line interface:
var cli = new CLI( opts );

// Run main:
main( 'beep' );

// Close:
cli.close( 0 );
