## Usage

```js
const hasOwnDeep = require('{%= name %}');
const obj = { a: { b: { c: 'd' } } };

console.log(hasOwnDeep(obj, 'a'));     //=> true
console.log(hasOwnDeep(obj, 'a.b'));   //=> true
console.log(hasOwnDeep(obj, 'a.b.c')); //=> true

console.log(hasOwnDeep(obj, 'c'));     //=> false
console.log(hasOwnDeep(obj, 'a.c'));   //=> false
console.log(hasOwnDeep(obj, 'a.b.d')); //=> false
```

## Keys with dots

Should correctly detect deeply nested keys that have dots in them.

```js
console.log(hasOwnDeep({ 'a.b.c': 'd' }, 'a.b.c'));      //=> true
console.log(hasOwnDeep({ 'a.b': { c: 'd' } }, 'a.b.c')); //=> true
console.log(hasOwnDeep({ a: { 'b.c': 'd' } }, 'a.b.c')); //=> true
```
