//start of PostLh1Encoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PostLh1Encoder.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

//import exceptions
import java.io.IOException;
import java.lang.NullPointerException;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;

/**
 * -lh1- kp PostLzssEncoderB <br>
 * 
 * <pre>
 * -- revision history --
 * $Log: PostLh1Encoder.java,v $
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/07/31 00:00:00  dangan
 * add to version control
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PostLh1Encoder implements PostLzssEncoder{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 4096;

    /** őv */
    private static final int MaxMatch       = 60;

    /** ŏv */
    private static final int Threshold      = 3;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private BitOutputStream out
    //------------------------------------------------------------------
    /**
     * -lh1- `̈kf[^̏o͐ rbgo̓Xg[
     */
    private BitOutputStream out;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  dynamic huffman tree
    //------------------------------------------------------------------
    //  private DynamicHuffman huffman
    //------------------------------------------------------------------
    /**
     * CodekpKInt}
     */
    private DynamicHuffman huffman;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  static huffman list
    //------------------------------------------------------------------
    //  private int[] offHiCode
    //  private int[] offHiLen
    //------------------------------------------------------------------
    /**
     * offset̏6bitkpnt}̕\
     */
    private int[] offHiCode;

    /**
     * offset̏6bitkpnt}̕\
     */
    private int[] offHiLen;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private PostLh1Encoder()
    //  public PostLh1Encoder( OutputStream out )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private PostLh1Encoder(){   }

    /**
     * -lh1- kp PostLzssEncoder \zB
     * 
     * @param out kf[^󂯎o̓Xg[
     */
    public PostLh1Encoder( OutputStream out ){
        if( out != null ){
            if( out instanceof BitOutputStream ){
                this.out   = (BitOutputStream)out;
            }else{
                this.out   = new BitOutputStream( out );
            }
            this.huffman   = new DynamicHuffman( 314 );
            this.offHiLen  = PostLh1Encoder.createLenList();
            try{
                this.offHiCode = StaticHuffman.LenListToCodeList( this.offHiLen );
            }catch( BadHuffmanTableException exception ){
            }
        }else{
            throw new NullPointerException( "out" );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void writeCode( int code )
    //  public void writeOffset( int offset )
    //------------------------------------------------------------------
    /**
     * 1byte  LZSSk̃f[^́A
     * LZSS ňkꂽkR[ĥvށB<br>
     * 
     * @param code 1byte  LZSSk̃f[^́A
     *             LZSS ňkꂽkR[ĥv
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeCode( int code ) throws IOException {
        int node  = this.huffman.codeToNode( code );
        int hcode = 0;
        int hlen  = 0;
        do{
            hcode >>>= 1;
            hlen++;
            if( ( node & 1 ) != 0 ) hcode |= 0x80000000;

            node = this.huffman.parentNode( node );
        }while( node != DynamicHuffman.ROOT );

        this.out.writeBits( hlen, hcode >> ( 32 - hlen ) );                     //throws IOException
        this.huffman.update( code );
    }

    /**
     * LZSS ňkꂽkR[ĥvʒuށB<br>
     * 
     * @param offset LZSS ňkꂽkR[ĥvʒu
     */
    public void writeOffset( int offset ) throws IOException {
        int offHi = ( offset >> 6 );
        this.out.writeBits( this.offHiLen[offHi], this.offHiCode[offHi] );      //throws IOException
        this.out.writeBits( 6, offset );                                        //throws IOException
    }


    //------------------------------------------------------------------
    //  method jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     *  PostLzssEncoder Ƀobt@OĂ
     * SĂ 8rbgPʂ̃f[^o͐ OutputStream ɏo͂A
     * o͐ OutputStream  flush() B<br>
     * ̃\bh͈kωȂB
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PostLzssEncoder#flush()
     * @see BitOutputStream#flush()
     */
    public void flush() throws IOException {
        this.out.flush();                                                       //throws IOException
    }

    /**
     * ̏o̓Xg[ƁAڑꂽo̓Xg[A
     * gpĂ\[XB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.out.close();                                                       //throws IOException

        this.out       = null;
        this.huffman   = null;
        this.offHiLen  = null;
        this.offHiCode = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lh1-` LZSS̃TCY𓾂B
     * 
     * @return -lh1-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PostLh1Encoder.DictionarySize;
    }

    /**
     * -lh1-` LZSS̍őv𓾂B
     * 
     * @return -lz5-` LZSS̍őv
     */
    public int getMaxMatch(){
        return PostLh1Encoder.MaxMatch;
    }

    /**
     * -lh1-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lh1-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PostLh1Encoder.Threshold;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private static int[] createLenList()
    //------------------------------------------------------------------
    /**
     * -lh1-  offsetfR[hpStaticHuffman
     * nt}Xg𐶐B
     * 
     * @return -lh1-  offsetfR[hpStaticHuffman
     *         nt}Xg
     */
    private static int[] createLenList(){
        final int length = 64;
        final int[] list = { 3, 0x01, 0x04, 0x0C, 0x18, 0x30, 0 };

        int[] LenList = new int[ length ];
        int index = 0;
        int len = list[ index++ ];

        for( int i = 0 ; i < length ; i++ ){
            if( list[index] == i ){
                len++;
                index++;
            }
            LenList[i] = len;
        }
        return LenList;
    }

}
//end of PostLh1Encoder.java
