/* proto.h - Common protocol functions and structures */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */
 

#ifndef PROTO_H
#define PROTO_H

#include <linux/atmsap.h>
#include <linux/atmsvc.h>

#include "atmd.h"


typedef enum { /* formatting aligned with state_map and others */
	ss_invalid,	ss_null,	ss_listening,	ss_connecting,
	ss_connected,	ss_indicated,	ss_accepting,	ss_zombie,
	ss_hold,	ss_wait_rel,	ss_wait_close,	ss_rel_req,
	ss_rel_ind
} STATE;

typedef enum { qs_null,qs_call_init,qs_out_proc = 3,qs_conn_req = 8,
  qs_in_proc,qs_active,qs_rel_req,qs_rel_ind } Q2931_STATE;

typedef struct _socket {
    STATE state;
    struct sockaddr_atmpvc pvc;
    /* --- socket layer information ---------------------------------------- */
    unsigned long id;
    struct sockaddr_atmsvc *local; /* local SAP */
    struct sockaddr_atmsvc *remote; /* remote SAP */
    int error; /* error code for close */
    /* --- Q.93B/Q.2931 information ---------------------------------------- */
    Q2931_STATE q2931_state;
    unsigned long call_ref; /* bit 24 like when sending */
    TIMER *conn_timer; /* current connection timer */
    /* --- some meta-information ------------------------------------------- */
    struct _socket *listen; /* to pending connections, also used for "more" */
    struct _socket *next; /* next socket */
} SOCKET;

/*
 * SOCKET uses a horrible linked list structure. Lists should be at least
 * doubly-linked and there should be a few hashes (by id and by call_ref) for
 * reasonable fast lookup. All this will have to wait till that version is
 * stable enough to be useful to test the "real" thing against it.
 */


extern const Q2931_STATE state_map[];
extern const char *state_name[],*qs_name[],*as_name[];

extern SOCKET *sockets;
extern unsigned char q_buffer[];

extern int net;
extern int pretty;


#define msg2bllis(s) (((int) (s)-(int) sizeof(struct atmsvc_msg))/ \
  (int) sizeof(struct atm_blli)+1)
#define bllis2msg(n) (sizeof(struct atmsvc_msg)+sizeof(struct atm_blli)*((n)-1))

#define SEND_ERROR(vcc,code) send_kernel(vcc,0L,as_close,code,NULL,NULL,NULL)


void from_kernel(struct atmsvc_msg *msg,int size);
void itf_load(int itf);

void to_q2931(void *msg,int size);
void send_kernel(unsigned long vcc,unsigned long listen_vcc,
  enum atmsvc_msg_type type,int reply,struct sockaddr_atmpvc *pvc,
  struct sockaddr_atmsvc *svc,struct sockaddr_atmsvc *local);
void from_net(void *msg,int size);
void to_signaling(void *msg,int size);
void saal_failure(void);
void saal_okay(void);
void clear_all_calls_on_T309(void);

SOCKET *new_sock(unsigned long id);
void free_sock(SOCKET *sock);
void new_state(SOCKET *sock,STATE state);
SOCKET *lookup_sap(struct sockaddr_atmsvc *sap,struct sockaddr_atmsvc **res);
void send_release(SOCKET *sock,unsigned char reason,...);
void send_release_complete(unsigned long call_ref,unsigned char cause);

const char *mid2name(unsigned char mid);

void set_error(SOCKET *sock,int code);
void send_close(SOCKET *sock);

void enter_vpci(int vpci,int itf);
int get_itf(int *vpci);
void init_addr(void);

#endif
