/* io.h - I/O operations */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */
 

#ifndef IO_H
#define IO_H

#include <sys/socket.h> /* for struct sockaddr */
#include <linux/atm.h> /* for struct sockaddr_atmsvc */


void open_all(void);
void close_all(void);
int do_close(int fd);
void poll_loop(void);
int connect_vcc(struct sockaddr *remote,int timeout);
int set_ip(int fd,int ip);
int set_encap(int fd,int mode);
void send_packet(int fd,void *data,int length);
int ip_itf_info(int number,unsigned long *ip,unsigned long *netmask);
int atm_itf_info(struct sockaddr_atmsvc *addr);

#endif
