/* timer.h - Timer support */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

#ifndef TIMER_H
#define TIMER_H

#include <sys/time.h>


typedef struct _timer {
    struct timeval expiration;
    void (*callback)(void *user);
    void *user;
    struct _timer *prev,*next;
} TIMER;

TIMER *start_timer(long usec,void (*callback)(void *user),void *user);
void stop_timer(TIMER *timer);
struct timeval *next_timer(void);
void pop_timer(TIMER *timer);
void expire_timers(void);

#endif
