/* io.h - I/O operations */
 
/* Written 1995-1998 by Werner Almesberger, EPFL-LRC/ICA */
 

#ifndef IO_H
#define IO_H

#include <stdint.h>
#include <sys/socket.h> /* for struct sockaddr */
#include <linux/atm.h> /* for struct sockaddr_atmsvc */


void open_all(void);
void close_all(void);
int do_close(int fd);
void poll_loop(void);
int connect_vcc(struct sockaddr *remote,const struct atm_qos *qos,int timeout);
int set_ip(int fd,int ip);
int set_encap(int fd,int mode);
void send_packet(int fd,void *data,int length);
int ip_itf_info(int number,uint32_t *ip,uint32_t *netmask,int *mtu);
int get_local(int fd,struct sockaddr_atmsvc *addr);

#endif
