/* proto.h - Common protocol functions and structures */
 
/* Written 1997-1998 by Roman Pletka, EPFL SSC */
/* Modified 1998 by Werner Almesberger, EPFL ICA */

#ifndef PROTO_H
#define PROTO_H

#define CALLER 0                /* We add this to the call pointer. It     */
#define CALLED 1                /* helps us to find out the source of the  */
#define RM     2                /* message.                                */

#include <linux/atmsvc.h>

#include "atmsap.h"
#include "atmd.h"


typedef enum { /* call states */
	cs_invalid,         cs_null,            cs_listening,
	cs_connected,       cs_indicated,	cs_called_accepted,
	cs_rm_accepted,     cs_rm_accepted2,    cs_caller_error,
	cs_rejected,        cs_rejected2,       cs_caller_closing,
	cs_called_closed,   cs_called_closed2,  cs_free_rm,
        cs_rejecting,       cs_will_close,      cs_call_indicated,
	cs_caller_closed
    
} STATE;

typedef struct _party {
  unsigned long id;
  struct sockaddr_atmpvc pvc;		/* itf and CI */
  struct sockaddr_atmsvc svc;		/* remote address */
  struct atm_qos qos;			/* QOS parameters */
} PARTY;

typedef struct _call {
  STATE state;
  unsigned long caller_id,called_id;	/* file descriptors to pipes    */
  PARTY in;				/* caller data */
  PARTY out;				/* called data */

  struct atm_sap sap;			/* SAP (BHLI and BLLI) */

  int error;				/* error code for close */
  /* --- switch fabric control data -------------------------------------- */
  void *fab;
  /* --- some meta-information ------------------------------------------- */
  struct _call *next;			/* next call (for debugging)    */
  struct _call *listen;			/* pointer to corresponding listening
					   "call" (more like a socket) */
} CALL;

/*
 * Note that the linked list is not properly maintained and serves mainly
 * debugging purposes.
 */


#define SEND_ERROR(vcc,code) \
  send_sigd(vcc,0L,as_error,code,NULL,NULL,NULL,NULL,NULL)

void send_sigd(unsigned long vcc,unsigned long listen_vcc,
  enum atmsvc_msg_type type,int reply,const struct sockaddr_atmpvc *pvc,
  const struct sockaddr_atmsvc *svc,const struct sockaddr_atmsvc *local,
  const struct atm_sap *sap,const struct atm_qos *qos);
void send_identify(CALL *call);
void send_listen(void);
void send_connect(CALL *call);
void send_reject(CALL *call, int err_code);
void send_reject_not_id(CALL *call, int err_code);
void send_close(CALL *call,int dest);
void send_accept(CALL *call);

CALL *new_call(unsigned long id);
void free_call(CALL *call);
void new_state(CALL *call,STATE state);

void send_free_rm(long id, CALL *call);

CALL *demux_in(unsigned long *srce, struct atmsvc_msg *msg);

/* some debugging functions */
void print_msg(struct atmsvc_msg *msg, CALL *call,unsigned long source);
void print_state(CALL *call);
void print_call(CALL *call);

#endif
