/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   af_lane.h
*   
* Overview:
*
* Authors:
*   TLR - Theodore L. Ross
*
* Modification History:
*   Date       Name  Description 
*   13-Dec-94  TLR   Created.
*
* Dependencies:
*
* Description:
*
*/

#ifndef _AF_LANE_H_
#define _AF_LANE_H_

#include "lane_atm.h"

#define  LE_CTRL_MARKER          0xff00
#define  LE_CTRL_PROTOCOL        1
#define  LE_CTRL_VERSION         1

/*
 * Control Frame Flag Definitions
 */
#define  LE_FLAG_REMOTE_ADDR     0x0001
#define  LE_FLAG_PROXY           0x0080
#define  LE_FLAG_TOPOLOGY_CHANGE 0x0100

/*
 * Control Frame Status Definitions
 */
#define  LE_STATUS_SUCCESS                0
#define  LE_STATUS_VERSION_NOT_SUPPORTED  1
#define  LE_STATUS_INVALID_PARAMS         2
#define  LE_STATUS_DUP_LAN_DST            4
#define  LE_STATUS_DUP_ATM_ADDR           5
#define  LE_STATUS_RESOURCES              6
#define  LE_STATUS_ACCESS_DENIED          7
#define  LE_STATUS_INVALID_REQ_ID         8
#define  LE_STATUS_INVALID_LAN_DEST       9
#define  LE_STATUS_INVALID_ATM_ADDR      10
#define  LE_STATUS_NO_CONFIG             20
#define  LE_STATUS_LE_CONFIG_ERROR       21
#define  LE_STATUS_INSUFFICIENT_INFO     22

/*
 * Control Frame Op-Codes
 */
#define  LE_CONFIG_REQ     0x0001
#define  LE_CONFIG_RSP     0x0101
#define  LE_JOIN_REQ       0x0002
#define  LE_JOIN_RSP       0x0102
#define  READY_QUERY       0x0003
#define  READY_IND         0x0103
#define  LE_REGISTER_REQ   0x0004
#define  LE_REGISTER_RSP   0x0104
#define  LE_UNREGISTER_REQ 0x0005
#define  LE_UNREGISTER_RSP 0x0105
#define  LE_ARP_REQ        0x0006
#define  LE_ARP_RSP        0x0106
#define  LE_FLUSH_REQ      0x0007
#define  LE_FLUSH_RSP      0x0107
#define  LE_NARP_REQ       0x0008
#define  LE_TOPOLOGY_REQ   0x0009

/*
 * TLV Types
 */
#define  TLV_CTRL_TIMEOUT              0x00a03e01
#define  TLV_MAX_UNKNOWN_COUNT         0x00a03e02
#define  TLV_MAX_UNKNOWN_TIME          0x00a03e03
#define  TLV_VCC_TIMEOUT               0x00a03e04
#define  TLV_MAX_RETRY                 0x00a03e05
#define  TLV_AGING_TIME                0x00a03e06
#define  TLV_FORW_DELAY_TIME           0x00a03e07
#define  TLV_ARP_RSP_TIME              0x00a03e08
#define  TLV_FLUSH_TIMEOUT             0x00a03e09
#define  TLV_PATH_SWITCH_DELAY         0x00a03e0a
#define  TLV_LOCAL_SEG_ID              0x00a03e0b
#define  TLV_MCAST_VCC_TYPE            0x00a03e0c
#define  TLV_MCAST_VCC_AVG_RATE        0x00a03e0d
#define  TLV_MCAST_VCC_PEAK_RATE       0x00a03e0e
#define  TLV_CONNECT_COMPLETION_TIMER  0x00a03e0f

/* Definitions for BLLI codepoint values in signaled VCCs. */

#define BLLI_CONTROL       1
#define BLLI_DIRECT_802_3  2
#define BLLI_DIRECT_802_5  3
#define BLLI_BUS_802_3     4
#define BLLI_BUS_802_5     5


typedef enum
   {
   LEC_DIRECT,
   LEC_MCAST,
   LEC_CTRL
   } LEC_CONN_TYPE;

/* LEC_CONN_CONTEXT
 */
typedef struct
   {
   HANDLE         ld_elan_handle;
   HANDLE         lc_elan_handle;
   LEC_CONN_TYPE  conn_type;
   } LEC_CONN_CONTEXT;


typedef struct
   {
   UINT16   le_hdr;
   ADDR_48  dst_addr;
   ADDR_48  src_addr;
   } HDR_802_3;

typedef struct
   {
   UINT16   le_hdr;
   UINT8    ac_pad;
   UINT8    fc;
   ADDR_48  dst_addr;
   ADDR_48  src_addr;
   } HDR_802_5;

/*
 * Packet Formats
 */
typedef struct
   {
   UINT16   marker;
   UINT8    protocol;
   UINT8    version;
   UINT16   op_code;
   UINT16   status;
   UINT32   tran_id;
   UINT16   req_lec_id;
   UINT16   flags;
   } LE_CTRL_HDR;

#define TAG_NOT_PRESENT    0
#define TAG_MAC_ADDR       1
#define TAG_ROUTE_DESC     2

typedef struct
   {
   UINT16   tag;
/*
   union
      {
*/
      ESI  mac_addr;
/*
      struct
         {
         UINT32   reserved;
         UINT16   route_descr;
         };
      };
*/
   } LE_LAN_DST;

typedef struct
   {
   LE_CTRL_HDR    hdr;
   LE_LAN_DST     src_lan_dst;
   LE_LAN_DST     target_lan_dst;
   ADDR_ATM       src_atm_addr;
   UINT8          lan_type;
   UINT8          max_frame_size;
   UINT8          tlv_count;
   UINT8          elan_name_size;
   ADDR_ATM       target_atm_addr;
   char           elan_name[32];
   } LE_CONFIG_FRAME;

typedef struct
   {
   LE_CTRL_HDR    hdr;
   LE_LAN_DST     src_lan_dst;
   LE_LAN_DST     target_lan_dst;
   ADDR_ATM       src_atm_addr;
   UINT8          lan_type;
   UINT8          max_frame_size;
   UINT8          tlv_count;
   UINT8          elan_name_size;
   ADDR_ATM       target_atm_addr;
   char           elan_name[32];
   } LE_JOIN_FRAME;

typedef struct
   {
   LE_CTRL_HDR    hdr;
   LE_LAN_DST     src_lan_dst;
   LE_LAN_DST     target_lan_dst;
   ADDR_ATM       src_atm_addr;
   UINT32         reserved[14];
   } LE_REG_FRAME;

typedef struct
   {
   LE_CTRL_HDR    hdr;
   LE_LAN_DST     src_lan_dst;
   LE_LAN_DST     target_lan_dst;
   ADDR_ATM       src_atm_addr;
   UINT32         reserved1;
   ADDR_ATM       target_atm_addr;
   UINT32         reserved2[8];
   } LE_ARP_FRAME;

typedef struct
   {
   LE_CTRL_HDR    hdr;
   UINT32         reserved[23];
   } LE_TOPOLOGY_FRAME;

typedef struct
   {
   UINT16   marker;
   UINT8    protocol;
   UINT8    version;
   UINT16   op_code;
   } LE_READY_HDR;

typedef struct
   {
   LE_READY_HDR   hdr;
   } LE_READY_FRAME;

typedef struct
   {
   LE_CTRL_HDR    hdr;
   LE_LAN_DST     src_lan_dst;
   LE_LAN_DST     target_lan_dst;
   ADDR_ATM       src_atm_addr;
   UINT32         reserved1;
   ADDR_ATM       target_atm_addr;
   UINT32         reserved2[8];
   } LE_FLUSH_FRAME;

#endif
