/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   atm.h
*   
* Abstract:
*   This module defines ATM specific types and constants.
*
* Authors:
*   TLR - Theodore L. Ross
*
* Modification History:
*   Date       Name  Description 
*   16-Sep-94  TLR   Created.
*   31-Oct-94  DMW   Use INT8 instead of UCHAR, add definition for PREFIX.
*                    Change definition for ADDR_ATM to use basic types and 
*                    to not have selector be an array.   
*   10-Jan-95  TLR   Added address copy and compare methods.
*   08-Sep-95  TLR   Updated QOS definitions and removed buggy atm_is_greater.
*
* Description:
*   Only ATM specific types should be defined here.
--*/
#ifndef ATM_H
#define ATM_H

/* General address related definitions. */

typedef UINT8 ADDR_48[6];  /* MAC Address.          */
typedef UINT8 ESI[6];      /* End System Identifier */
typedef UINT8 PREFIX[13];  /* Network Prefix.       */

/* Type for ATM Address. */

typedef struct
   {
   PREFIX   prefix;  /* Network Prefix set by the switch. */
   ESI      esi;     /* ESI or MAC Addr                   */
   UINT8    sel;     /* Selector                          */
   } ADDR_ATM;

typedef union
   {
   struct
      {
      UINT8    cpcs_uu;
      UINT8    clp;
      } aal5_data;
   } AAL_DATA;

#define ESI_COPY(from, to) \
   {                       \
   (to)[0] = (from)[0];    \
   (to)[1] = (from)[1];    \
   (to)[2] = (from)[2];    \
   (to)[3] = (from)[3];    \
   (to)[4] = (from)[4];    \
   (to)[5] = (from)[5];    \
   }

#define ESI_IS_BCAST(esi)  (((esi)[0] == 0xff) && \
                            ((esi)[1] == 0xff) && \
                            ((esi)[2] == 0xff) && \
                            ((esi)[3] == 0xff) && \
                            ((esi)[4] == 0xff) && \
                            ((esi)[5] == 0xff))

#define ATM_COPY(from, to)               \
	{                                     \
	(to).prefix[0]  = (from).prefix[0];   \
	(to).prefix[1]  = (from).prefix[1];   \
	(to).prefix[2]  = (from).prefix[2];   \
	(to).prefix[3]  = (from).prefix[3];   \
	(to).prefix[4]  = (from).prefix[4];   \
	(to).prefix[5]  = (from).prefix[5];   \
	(to).prefix[6]  = (from).prefix[6];   \
	(to).prefix[7]  = (from).prefix[7];   \
	(to).prefix[8]  = (from).prefix[8];   \
	(to).prefix[9]  = (from).prefix[9];   \
	(to).prefix[10] = (from).prefix[10];  \
	(to).prefix[11] = (from).prefix[11];  \
	(to).prefix[12] = (from).prefix[12];  \
	(to).esi[0]     = (from).esi[0];      \
	(to).esi[1]     = (from).esi[1];      \
	(to).esi[2]     = (from).esi[2];      \
	(to).esi[3]     = (from).esi[3];      \
	(to).esi[4]     = (from).esi[4];      \
	(to).esi[5]     = (from).esi[5];      \
	(to).sel        = (from).sel;         \
	}

#define ATM_COPY_NULL(to)                \
	{                                     \
	(to).prefix[0]  = 0;                  \
	(to).prefix[1]  = 0;                  \
	(to).prefix[2]  = 0;                  \
	(to).prefix[3]  = 0;                  \
	(to).prefix[4]  = 0;                  \
	(to).prefix[5]  = 0;                  \
	(to).prefix[6]  = 0;                  \
	(to).prefix[7]  = 0;                  \
	(to).prefix[8]  = 0;                  \
	(to).prefix[9]  = 0;                  \
	(to).prefix[10] = 0;                  \
	(to).prefix[11] = 0;                  \
	(to).prefix[12] = 0;                  \
	(to).esi[0]     = 0;                  \
	(to).esi[1]     = 0;                  \
	(to).esi[2]     = 0;                  \
	(to).esi[3]     = 0;                  \
	(to).esi[4]     = 0;                  \
	(to).esi[5]     = 0;                  \
	(to).sel        = 0;                  \
	}

#define ATM_EQUAL(a1, a2) (((a1).sel        == (a2).sel) &&         \
                           ((a1).esi[5]     == (a2).esi[5]) &&      \
                           ((a1).esi[4]     == (a2).esi[4]) &&      \
                           ((a1).esi[3]     == (a2).esi[3]) &&      \
                           ((a1).esi[2]     == (a2).esi[2]) &&      \
                           ((a1).esi[1]     == (a2).esi[1]) &&      \
                           ((a1).esi[0]     == (a2).esi[0]) &&      \
                           ((a1).prefix[12] == (a2).prefix[12]) &&  \
                           ((a1).prefix[11] == (a2).prefix[11]) &&  \
                           ((a1).prefix[10] == (a2).prefix[10]) &&  \
                           ((a1).prefix[9]  == (a2).prefix[9]) &&   \
                           ((a1).prefix[8]  == (a2).prefix[8]) &&   \
                           ((a1).prefix[7]  == (a2).prefix[7]) &&   \
                           ((a1).prefix[6]  == (a2).prefix[6]) &&   \
                           ((a1).prefix[5]  == (a2).prefix[5]) &&   \
                           ((a1).prefix[4]  == (a2).prefix[4]) &&   \
                           ((a1).prefix[3]  == (a2).prefix[3]) &&   \
                           ((a1).prefix[2]  == (a2).prefix[2]) &&   \
                           ((a1).prefix[1]  == (a2).prefix[1]) &&   \
                           ((a1).prefix[0]  == (a2).prefix[0]))

#define ATM_EQUAL_NULL(a1) (((a1).sel       == 0) &&  \
									((a1).esi[5]     == 0) &&  \
									((a1).esi[4]     == 0) &&  \
									((a1).esi[3]     == 0) &&  \
									((a1).esi[2]     == 0) &&  \
									((a1).esi[1]     == 0) &&  \
									((a1).esi[0]     == 0) &&  \
									((a1).prefix[12] == 0) &&  \
									((a1).prefix[11] == 0) &&  \
									((a1).prefix[10] == 0) &&  \
									((a1).prefix[9]  == 0) &&  \
									((a1).prefix[8]  == 0) &&  \
									((a1).prefix[7]  == 0) &&  \
									((a1).prefix[6]  == 0) &&  \
									((a1).prefix[5]  == 0) &&  \
									((a1).prefix[4]  == 0) &&  \
									((a1).prefix[3]  == 0) &&  \
									((a1).prefix[2]  == 0) &&  \
									((a1).prefix[1]  == 0) &&  \
									((a1).prefix[0]  == 0))

#endif /* ATM_H */
