/*
 * util.h - Various utility procedures
 *
 * Written by Scott W. Shumate
 * 
 * Copyright (c) 1995 Telecommunications & Information
 * Sciences Laboratory, The University of Kansas 
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TISL ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 * Telecommunications & Information Science Lab
 * 2291, Irving Hill Road Lawrence, KS 66046
 * (913)-864-7757
 * http://www.tisl.ukans.edu
 * 
 * The development of this software was generously
 * supported by research grants from Sprint corporation,
 * and we would like to express our thanks.
 */

#ifndef UTIL_H
#define UTIL_H

#include "asn_incl.h"
#include "rfc1155_smi.h"
#include "rfc1157_snmp.h"
#include "atmd.h"

#define AsnOidCompare(o1, o2) ((o1)->octetLen < (o2)->octetLen ? \
			       (memcmp((o1)->octs, (o2)->octs, (o1)->octetLen) > 0 ? 1 : -1) : \
			       (memcmp((o1)->octs, (o2)->octs, (o2)->octetLen)))

#define AsnOidGreater(o1, o2) ((o1)->octetLen < (o2)->octetLen ? \
			       memcmp((o1)->octs, (o2)->octs, (o1)->octetLen) > 0 : \
			       memcmp((o1)->octs, (o2)->octs, (o2)->octetLen) >= 0)

#define AsnOidLess(o1, o2) ((o1)->octetLen < (o2)->octetLen ? \
			    memcmp((o1)->octs, (o2)->octs, (o1)->octetLen) <= 0 : \
			    memcmp((o1)->octs, (o2)->octs, (o2)->octetLen) < 0)

#define AsnOidEqual(o1,o2) ((o1)->octetLen == (o2)->octetLen ? \
			    memcmp((o1)->octs, (o2)->octs, (o1)->octetLen) == 0 : 0)
			    
#define AsnOidNext(o1, o2) ((o1)->octetLen < (o2)->octetLen ? \
			    memcmp((o1)->octs, (o2)->octs, (o1)->octetLen) < 0 : \
			    memcmp((o1)->octs, (o2)->octs, (o2)->octetLen) < 0)

#define AsnOidMember(o1,o2) ((o1)->octetLen < (o2)->octetLen ? \
			     0 : memcmp((o1)->octs, (o2)->octs, (o2)->octetLen) == 0)

#define AsnOidCopy(o1, o2) ({memcpy((o1)->octs, (o2)->octs, (o1)->octetLen = (o2)->octetLen);})

#define AsnOidAppend(o1, o2) ({memcpy(&(o1)->octs[(o1)->octetLen], (o2)->octs, (o2)->octetLen); \
                              (o1)->octetLen += (o2)->octetLen;})

int AsnOidSize(AsnOid *oid);

VarBind *AppendVarBind(VarBindList *list);

void AppendListNode(VarBindList *list, AsnListNode *node);

#endif
