/* arequipa.c - AREQUIPA support functions */
 
/* Written 1996 by Jean-Michel Pittet and Werner Almesberger, EPFL-LRC */


#include <unistd.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/arequipa.h>
#include <linux/atm.h>
#include <linux/atmclip.h>

#include "atmsap.h"
#include "arequipa.h"


static int arequipa_attach(int upper,int lower)
{
    if (ioctl(lower,AREQUIPA_PRESET,upper) < 0) {
	(void) close(lower);
	return -1;
    }
    (void) close(lower);
    return 0;
}


int arequipa_preset(int sd,const struct sockaddr_atmsvc *addr,
  const struct atm_qos *qos)
{
    struct sockaddr_atmsvc a;
    struct atm_qos q;
    struct atm_blli blli;
    int s;

    if ((s = socket(addr->sas_family,SOCK_DGRAM,ATM_AAL5)) < 0) return -1;
    q = *qos;
    if (!q.txtp.max_sdu) q.txtp.max_sdu = RFC1626_MTU+RFC1483LLC_LEN;
    if (!q.rxtp.max_sdu) q.rxtp.max_sdu = RFC1626_MTU+RFC1483LLC_LEN;
    if (setsockopt(s,SOL_ATM,SO_ATMQOS,&q,sizeof(q)) < 0) {
	(void) close(s);
	return -1;
    }
    a = *addr;
    if (a.sas_family == AF_ATMSVC) {
	a.sas_addr.bhli.hl_type = ATM_HL_VENDOR;
	a.sas_addr.bhli.hl_length = 7;
	memcpy(a.sas_addr.bhli.hl_info,AREQUIPA_HLT_VS_ID,7);
	a.sas_addr.blli = &blli;
	blli.l2_proto = ATM_L2_ISO8802;
	blli.l3_proto = ATM_L3_NONE;
	blli.next = NULL;
    }
    if (connect(s,(struct sockaddr *) &a,a.sas_family == AF_ATMSVC ? sizeof(a)
      : sizeof(struct sockaddr_atmpvc)) < 0) {
	(void) close (s);
	return -1;
    }
    return arequipa_attach(sd,s);
}


int arequipa_expect(int sd,int on)
{
    return ioctl(sd,AREQUIPA_EXPECT,on);
}


int arequipa_close(int sd)
{
    return ioctl(sd,AREQUIPA_CLOSE,0);
}
