/* q2931.h - Various Q.2931 constants */

/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */

/*
 * Note: some values don't appear in UNI 3.0 or 3.1 but are taken from Q.2931
 */

#ifndef Q2931_H
#define Q2931_H

/* Maximum message size */

#define MAX_Q_MSG 500

/* Protocol discriminator */

#define Q2931_PROTO_DSC		9 /* Q.2931 user-network call/connection
				     control message */

/* Coding Standards */

#define Q2931_CS_ITU		0	/* ITU-T standardized */
#define Q2931_CS_NET		3	/* Standard defined for the network */

/* Message types */

#define QMSG_SETUP		0x05	/* SETUP */
#define QMSG_CALL_PROC		0x02	/* CALL PROCEEDING */
#define QMSG_CONNECT		0x07	/* CONNECT */
#define QMSG_CONN_ACK		0x0f	/* CONNECT ACKNOWLEDGE */
#define QMSG_RELEASE		0x4d	/* RELEASE */
#define QMSG_REL_COMP		0x5a	/* RELEASE COMPLETE */
#define QMSG_RESTART		0x46	/* RESTART */
#define QMSG_REST_ACK		0x4e	/* RESTART ACKNOWLEDGE */
#define QMSG_STATUS		0x7d	/* STATUS */
#define QMSG_STATUS_ENQ		0x75	/* STATUS ENQUIRY */
#define QMSG_ADD_PARTY		0x80	/* ADD PARTY */
#define QMSG_ADD_PARTY_ACK	0x81	/* ADD PARTY ACKNOWLEDGE */
#define QMSG_ADD_PARTY_REJ	0x82	/* ADD PART REJECT */
#define QMSG_DROP_PARTY		0x83	/* DROP PARTY */
#define QMSG_DROP_PARTY_ACK	0x84	/* DROP PARTY ACKNOWLEDGE */

/* Information element identifiers */

#define ATM_IE_CAUSE		0x08 /* Cause */
#define ATM_IE_CALL_STATE	0x14 /* Call state */
#define ATM_IE_EPR		0x54 /* Endpoint reference */
#define ATM_IE_EP_STATE		0x55 /* Endpoint state */
#define ATM_IE_AAL		0x58 /* ATM adaption layer parameters */
#define ATM_IE_TD		0x59 /* ATM traffic descriptor */
#define ATM_IE_CONN_ID		0x5a /* Connection identifier */
#define ATM_IE_QOS		0x5c /* Quality of service parameter */
#define ATM_IE_BHLI		0x5d /* Broadband high layer information */
#define ATM_IE_BBCAP		0x5e /* Broadband bearer capability */
#define ATM_IE_BLLI		0x5f /* Broadband low-layer information */
#define ATM_IE_BBS_COMP		0x62 /* Broadband sending complete */
#define ATM_IE_BBREP		0x63 /* Broadband repeat indicator */
#define ATM_IE_CGPN		0x6c /* Calling party number */
#define ATM_IE_CGPS		0x6d /* Calling party subaddress */
#define ATM_IE_CDPN		0x70 /* Called party number */
#define ATM_IE_CDPS		0x71 /* Called party subaddress */
#define ATM_IE_TNS		0x78 /* Transit network selection */
#define ATM_IE_RESTART		0x79 /* Restart indicator */


/* Cause: Location */

#define ATM_LOC_USER		  0 /* user */
#define ATM_LOC_PRV_LOC		  1 /* private network serving the local user */
#define ATM_LOC_PUB_LOC		  2 /* public network serving the local user */
#define ATM_LOC_TRANS_NET	  3 /* transit network */
#define ATM_LOC_PRV_RMT		  4 /* public network serving the remote user */
#define ATM_LOC_PUB_RMT		  5 /* private network serving the remote
				       user */
#define ATM_LOC_INT_NET		  7 /* international network */
#define ATM_LOC_BEYOND_IWP	 10 /* network beyond interworking point */

/* Cause: Cause values */

/* ----------------------------------- normal event */
#define ATM_CV_UNALLOC		  1 /* unallocated (unassigned) number */
#define ATM_CV_NO_ROUTE_TNS	  2 /* no route to specified transit network */
#define ATM_CV_NO_ROUTE_DEST	  3 /* no route to destination */
#ifdef UNI30
#define ATM_CV_CI_UNACC		 10 /* VPCI/VCI unacceptable */
#endif
#ifdef UNI31
#define ATM_CV_NORMAL_CLEAR	 16 /* normal call clearing */
#endif
#define ATM_CV_USER_BUSY	 17 /* user busy */
#define ATM_CV_NO_USER_RESP	 18 /* no user responding */
#define ATM_CV_CALL_REJ		 21 /* call rejected */
#define ATM_CV_NUM_CHANGED	 22 /* number changed */
#define ATM_CV_REJ_CLIR		 23 /* user rejects all calls with calling
				       line identification restriction (CLIR)*/
#define ATM_CV_DEST_OOO		 27 /* destination out of order */
#define ATM_CV_INV_NUM_FMT	 28 /* invalid number format (address
				        incomplete) */
#define ATM_CV_RESP_STAT_ENQ	 30 /* response to STATUS ENQUIRY */
#define ATM_CV_NORMAL_UNSPEC	 31 /* normal, unspecified */
/* ----------------------------------- resource unavailable */
#define ATM_CV_CI_UNAVAIL	 35 /* requested VPCI/VCI unavailable */
#ifdef UNI31
#define ATM_CV_CI_FAIL		 36 /* VPCI/VCI assignment failure */
#define ATM_CV_UCR_UNAVAIL	 37 /* user cell rate not available */
#endif
#define ATM_CV_CI_NET_OOO	 38 /* network out of order - unused */
#define ATM_CV_CI_TEMP_FAIL	 41 /* temporary failure */
#define ATM_CV_CI_ACC_INF_DISC	 43 /* access information discarded */
#define ATM_CV_NO_CI		 45 /* no VPCI/VCI available */
#define ATM_CV_RES_UNAVAIL	 47 /* resource unavailable, unspecified */
/* ----------------------------------- service or option not available */
#define ATM_CV_QOS_UNAVAIL	 49 /* Quality of Service unavailable */
#ifdef UNI30
#define ATM_CV_UCR_UNAVAIL	 51 /* user cell rate not available */
#endif
#define ATM_CV_BBCAP_NOT_AUTH	 57 /* bearer capability not authorized */
#define ATM_CV_BBCAP_UNAVAIL	 58 /* bearer capability not presently
				       available */
#define ATM_CV_UNAVAILABLE	 63 /* service or option not available,
				       unspecified */
/* ----------------------------------- service or option not implemented */
#define ATM_CV_BBCAP_NOT_IMPL	 65 /* bearer capability not implemented */
#define ATM_CV_UNSUPP_TRAF_PRM	 73 /* unsupported combination of traffic
				       parameters */
#ifdef UNI31
#define ATM_CV_AAL_UNSUPP	 78 /* AAL parameters cannot be supported */
#endif
/* ----------------------------------- invalid message */
#define ATM_CV_INV_CR		 81 /* invalid call reference value */
#define ATM_CV_NO_SUCH_CHAN	 82 /* identified channel does not exist */
#define ATM_CV_INCOMP_DEST	 88 /* incompatible destination */
#define ATM_CV_INV_EPR		 89 /* invalid endpoint reference */
#define ATM_CV_INV_TNS		 91 /* invalid transit network selection */
#define ATM_CV_TOO_MANY_APR	 92 /* too many pending add party requests */
#ifdef UNI30
#define ATM_CV_AAL_UNSUPP	 93 /* AAL parameters cannot be supported */
#endif
/* ----------------------------------- protocol error */
#define ATM_CV_MAND_IE_MISSING	 96 /* mandatory information element is
				       missing */
#define ATM_CV_UNKNOWN_MSG_TYPE  97 /* message type non-existent or not
				       implemented */
#define ATM_CV_UNKNOWN_IE	 99 /* information element non-existent or not
				       implemented */
#define ATM_CV_INVALID_IE	100 /* invalid information element contents */
#define ATM_CV_INCOMP_MSG	101 /* message not compatible with call state*/
#define ATM_CV_TIMER_EXP	102 /* recovery on timer expiry */
#define ATM_CV_BAD_MSG_LEN	104 /* incorrect message length */
#define ATM_CV_PROTOCOL_ERROR	111 /* protocol error, unspecified */

/* Cause: P-U values */

#define ATM_PU_PROVIDER		0   /* Network service - Provider */
#define ATM_PU_USER		1   /* Network service - User */

/* Cause: N-A values */

#define ATM_NA_NORMAL		0   /* Normal */
#define ATM_NA_ABNORMAL		1   /* Abnormal */

/* Cause: Condition */

#define ATM_COND_UNKNOWN	0 /* Unknown */
#define ATM_COND_PERMANENT	1 /* Permanent */
#define ATM_COND_TRANSIENT	2 /* Transient */

/* Cause: Reject reason */

#define ATM_RSN_USER		0 /* User specific */
#define ATM_RSN_IE_MISS		1 /* Information element missing */
#define ATM_RSN_IE_INSUFF	2 /* Information element contents are not
				     sufficient */
/* Restart Indicator class values */

#define ATM_RST_IND_VC		0 /* Indicated virtual channel */
#define ATM_RST_ALL_VC		2 /* All virtual channels controlled by the
				     Layer 3 entity which sends the RESTART
				     message */

/* Action Indicator for messages */

#define ATM_AI_MSG_CLEAR	0 /* clear call */
#define ATM_AI_MSG_DSC_IGN	1 /* discard and ignore */
#define ATM_AI_MSG_DSC_STAT	2 /* discard and report status */
#define ATM_AI_MSG_RSV		3 /* reserved */

/* Action Indicator for IEs */

#define ATM_AI_IE_CLEAR		0 /* clear call */
#define ATM_AI_IE_DSCIE_PRC	1 /* discard IE and proceed */
#define ATM_AI_IE_DSCIE_STAT	2 /* discard IE, procees, and report status */
#define ATM_AI_IE_DSCMSG_IGN	5 /* discard message, and ignore */
#define ATM_AI_IE_DSCMSG_STAT	6 /* discard message, and report status */

/* Type of number */

#define ATM_TON_UNKNOWN		0 /* unknown */
#define ATM_TON_INTRNTNL	1 /* international number */
#define ATM_TON_NATIONAL	2 /* national number */
#define ATM_TON_NETWORK		3 /* network specific number */
#define ATM_TON_SUBSCRIBER	4 /* subscriber number */
#define ATM_TON_ABBRV		6 /* abbreviated number */

/* Numbering/addressing plan */

#define ATM_NP_UNKNOWN		0 /* unknown */
#define ATM_NP_E164		1 /* ISDN numbering plan (E.164) */
#define ATM_NP_NSAP		2 /* NSAP addressing (ISO/IEC 8348) */
#define ATM_NP_PRIVATE		9 /* private numbering plan */

/* Type of sub-address */

#define ATM_SAT_NSAP		0 /* NSAP (Rec. X.213 ISO/IEC 8348) */
#define ATM_SAT_USER_AES	1 /* user-specified ATM endsystem address */
#define ATM_SAT_USER		2 /* user-specified */

/* Presentation indicator */

#define ATM_PRS_ALLOW		0 /* presentation allowed */
#define ATM_PRS_RESTRICT	1 /* presentation restricted */
#define ATM_PRS_NOTAVL		2 /* number not available */

/* Screening indicator */

#define ATM_SCRN_UP_NS		0 /* user-provided, not screened */
#define ATM_SCRN_UP_VP		1 /* user-provided, verified and passed */
#define ATM_SCRN_UP_VF		2 /* user-provided, verified and failed */
#define ATM_SCRN_NP		3 /* network provided */

/* VP-associated signalling */

#define ATM_VPA_VPA		0 /* VP-associated signalling */
#define ATM_VPA_EXPL		1 /* explicit indication of VPCI */

/* Preferred/exclusive */

#define ATM_POE_EXC_EXC		0 /* exclusive VPCI; exclusive VCI */
#define ATM_POE_EXC_ANY		1 /* exclusive VPCI; any VCI */

/* Traffic descriptor tags */

#define ATM_TD_FW_PCR_0		0x82 /* Forward peak cell rate (CLP=0) */
#define ATM_TD_BW_PCR_0		0x83 /* Backward peak cell rate (CLP=0) */
#define ATM_TD_FW_PCR_01	0x84 /* Forward peak cell rate (CLP=0+1) */
#define ATM_TD_BW_PCR_01	0x85 /* Backward peak cell rate (CLP=0+1) */
#define ATM_TD_FW_SCR_0		0x88 /* Forward sustained cell rate (CLP=0) */
#define ATM_TD_BW_SCR_0		0x89 /* Backward sustained cell rate (CLP=0) */
#define ATM_TD_FW_SCR_01	0x90 /* Forward sustained cell rate (CLP=0+1) */
#define ATM_TD_BW_SCR_01	0x91 /* Backward sustained cell rate (CLP=0+1)*/
#define ATM_TD_FW_MBS_0		0xa0 /* Forward maximum burst size (CLP=0) */
#define ATM_TD_BW_MBS_0		0xa1 /* Backward maximum  burst size (CLP=0) */
#define ATM_TD_FW_MBS_01	0xb0 /* Forward maximum burst size (CLP=0+1) */
#define ATM_TD_BW_MBS_01	0xb1 /* Backward maximum burst size (CLP=0+1) */
#define ATM_TD_BEST_EFFORT	0xbe /* Best effort indicator */
#define ATM_TD_TM_OPT		0xbf /* Traffic management options */

/* Tagging forward/backward */

#define ATM_TAG_NO		0 /* Tagging not requested */
#define ATM_TAG_YES		1 /* Tagging requested */

/* Bearer class */

#define ATM_BC_BCOB_A		1 /* BCOB-A */
#define ATM_BC_BCOB_C		3 /* BCOB-C */
#define ATM_BC_BCOB_X		16 /* BCOB-X */

/* Traffic type */

#define ATM_TT_NO_IND		0 /* no indication */
#define ATM_TT_CBR		1 /* constant bit rate */
#define ATM_TT_VBR		2 /* variable bit rate */

/* Timing requirements */

#define ATM_TR_NO_IND		0 /* no indication */
#define ATM_TR_E2E_REQ		1 /* end-to-end timing required */
#define ATM_TR_E2E_NRQ		2 /* end-to-end timing not required */

/* Susceptibility to clipping */

#define ATM_STC_NO		0 /* not susceptible to clipping */
#define ATM_STC_YES		1 /* susceptible to clipping */

/* User-plane connection configuration */

#define ATM_UPCC_P2P		0 /* point-to-point */
#define ATM_UPCC_P2M		1 /* point-to-multipoint */

/* Instruction field flags */

#define ATM_FLAG_NO		0 /* instruction field not significant */
#define ATM_FLAG_YES		1 /* follow explicit instructions */

/* AAL parameter tags */

#define ATM_AALP_FW_MAX_SDU	0x8c /* Forward maximum CPCS-SDU size */
#define ATM_AALP_BW_MAX_SDU	0x81 /* Backward maximum CPCS-SDU size */
#define ATM_AALP_AAL_MODE	0x83 /* AAL mode (UNI 3.0 only) */
#define ATM_AALP_SSCS		0x84 /* SSCS type */

#endif
