%{
/* cfg.l - configuration language */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <linux/atm.h>

#include "atm.h"

#include "y.tab.h"


static int lineno = 1;


void yyerror(const char *s);

%}

%%

level			return TOK_LEVEL;
debug			|
debugging		return TOK_DEBUG;
info			|
information		|
informational		return TOK_INFO;
warn			|
warning			return TOK_WARN;
error			return TOK_ERROR;
fatal			return TOK_FATAL;
sig			|
signaling		|
signalling		return TOK_SIG;
uni30			return TOK_UNI30;
uni31			return TOK_UNI31;
net			|
network			return TOK_NET;
saal			return TOK_SAAL;
vc			|
svc			return TOK_SVC;
io			return TOK_IO;
itf			|
interface		return TOK_ITF;
vpci			return TOK_VPCI;
[0-9]+			{ char *end;
			  yylval.num = strtoul(yytext,&end,10);
			  if (*end) yyerror("invalid number");
			  return TOK_NUMBER; }
[0-9]+\.[0-9]+(\.[0-9]+)? {
			  if (text2atm(yytext,(struct sockaddr *) &yylval.pvc,
			    sizeof(yylval.pvc),T2A_PVC) < 0)
			      yyerror("invalid signaling channel");
			  return TOK_PVC;
			}
\n?[\t ]*		lineno += *yytext && *yytext == '\n';
#[^\n]*\n		lineno++;
.			return *yytext;

%%

void yyerror(const char *s)
{
    fprintf(stderr,"line %d: %s near \"%s\"\n",lineno,s,yytext);
    exit(1);
}
