/* clip.c - CLassical IP over ATM control (to be replaced by ATMARP) */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/atm.h>
#include <linux/atmclip.h>
#include <atm.h>


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ -0 ] [itf.]vpi.vci [ pcr ]\n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    struct sockaddr_atmpvc addr;
    struct atm_qos qos;
    const char *name;
    int s,null;

    name = argv[0];
    null = 0;
    if (argc > 1 && *argv[1] == '-')
	if (strcmp(argv[1],"-0")) usage(name);
	else {
	    null = 1;
	    argc--;
	    argv++;
	}
    if (argc != 2 && argc != 3) usage(name);
    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,ATM_AAL5)) < 0) {
	perror("socket");
	return 1;
    }
    if (ioctl(s,CLIP_PVC,0) < 0) {
	perror("ioctl CLIP_PVC");
	return 1;
    }
    memset(&addr,0,sizeof(addr));
    if (text2atm(argv[1],(struct sockaddr *) &addr,sizeof(addr),T2A_PVC) < 0)
	usage(argv[0]);
    memset(&qos,0,sizeof(qos));
    if (argc != 3) qos.txtp.class = ATM_UBR;
    else {
	qos.txtp.class = ATM_CBR;
	qos.txtp.min_pcr = atoi(argv[2]);
	qos.txtp.max_sdu = RFC1626_MTU;
    }
    qos.rxtp.class = ATM_UBR;
    qos.rxtp.max_sdu = RFC1626_MTU;
    if (setsockopt(s,SOL_ATM,SO_ATMQOS,&qos,sizeof(qos)) < 0) {
	perror("setsockopt SO_ATMQOS");
	return 1;
    }
    if (bind(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    if (null)
	if (ioctl(s,CLIP_NULENCAP,0) < 0) {
	    perror("ioctl CLIP_NULENCAP");
	    return 1;
	}
    return 0;
}
