/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*++
* Module Name:
*   line_up.h
*
* Abstract:
*   This file is the interface to the line-up functionality.  Line-up is when
*   both ends of a link agree to the values to use on the link.
*
* Authors:
*   DMW - Douglas M. Washabaugh
*   TLR - Theodore L. Ross
*
* Modification History:
*   Date       Name  Description
*   10-Feb-95  DMW   Created.
*   15-May-95  TLR   Added Event Reporting Support.
*    3-Aug-95  TLR   Added uni-version call.
*
* Description:
*   The line-up process starts as soon as this module receives a link-up 
*   notification from the ilmi_io module.  Line-up uses ILMI to read remote MIB
*   attributes (DEC MIB and ATM MIB) and cache their values.  Basically, 
*   this module is a database that initializes itself when the link comes up.  
*
*   Once this is complete, the connection manager is called to notify it that
*   line-up is complete.  The connection manager propagates this line-up 
*   indication to all interested parties.
*
*   When the interested parties receive the line-up indication, they
*   can either use the dec_mib or atm_mib routines to read remote objects, 
*   or they can directly call this module.  However, since this module requires
*   SNMP names, the indirect calls to dec_mib and atm_mib are simpler.
*
*   The values which are used on the link depend upon the values on the local
*   side and the remote side of the link.  For instance, Digital FLOWmaster
*   flow-control is used only if both sides can support it.  It is up to 
*   each entity to determine the actual value used on the link.  It is also 
*   the responsibility of the entity to verify the correctness of the values.
*
*   If the link goes down, then no values are available until the line-up
*   has run and completed.
*
* Call Sequence:
*   - line_up_create
*      - line_up_event_mask_set
*      - line_up_get
*      - line_up_destroy
*
* Call Scenario:
*
*   - line_up_create ............... Driver calls this to create an instance.
*
*   - line_up_link_status_change ... Called by ilmi_io to notify that the link
*                                    is now available.
*
*   - <call to connection mgr>   ... The link up process has completed, and now
*                                    line-up calls the connection manager.
*                                    The connection manager notifies all 
*                                    interested parties.
*
*   - line_up_get .................. Interested parties call to get values.
*   -  : : : : : : : : : :  ........ Other values.
*   - line_up_get  ................. Last value.
*
*
*   - line_up_destroy .............. The device/adapter is no longer being used.
*
* Issues:
*   none
--*/

/*++
* ===========================
* = line_up_uni_version_get =
* ===========================
*
* Overview:
*   This function returns the UNI version that is being used on the physical
*   port.
*
* Arguments:
*   line_up_handle  - (IN)  The handle returned by line_up_create.
*   p_uni_version   - (OUT) The version number of the UNI supported.
*                           (see defines below)
*
* Returns:
*   STATUS_K_SUCCESS           - Refer to postconditions.
*   STATUS_K_FAILURE           - UNI Version is unknown (not 3.0).
*   STATUS_K_NOT_READY         - Line-up has not yet completed.
*
* Preconditions:
*   none
*
* Postconditions:
*   The uni version is returned.
--*/                                              
#define UNI_3_0   0x30
#define UNI_3_1   0x31
#define UNI_4_0   0x40

STATUS line_up_uni_version_get (HANDLE  line_up_handle,
                                UINT8  *p_uni_version);

