%{
/* ql.y - Q.2931 data structures description language */

/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>

#include "common.h"
#include "qgen.h"
#include "file.h"


typedef struct _macro {
    const char *id;
    FIELD *block;
    int repeated;
    struct _macro *next;
} MACRO;


FIELD *def = NULL;
static MACRO *macros = NULL;
static int repeated = 0; /* current macro contains repeatitions */
static int repeating = 0; /* ancestor is repeated */

%}

%union {
    const char *str;
    int num;
    FIELD *field;
    VALUE *value;
    VALUE_LIST *list;
    TAG *tag;
};

%token		TOK_BREAK TOK_CASE TOK_DEF TOK_DEFAULT TOK_LENGTH TOK_MULTI
%token <str>	TOK_ID TOK_INCLUDE

%type <field>	rep_block block fields field field_cont
%type <num>	repetition opt_break opt_pos decimal opt_more
%type <value>	opt_val value
%type <tag>	tags rep_tags
%type <list>	list
%type <str>	opt_id

%%

all:
    includes macros block
	{
	    MACRO *walk;

	    def = $3;
	    for (walk = macros; walk; walk = walk->next)
		fprintf(stderr,"unused macro: %s\n",walk->id);
	}
    ;

includes:
    | TOK_INCLUDE includes
	{
	    to_c("#%s\n",$1);
	    to_test("#%s\n",$1);
	    if (dump) to_dump("#%s\n",$1);
	}
    ;

macros:
    | macros macro
    ;

macro:
    TOK_DEF TOK_ID '=' block
	{
	    MACRO *n;

	    n = alloc_t(MACRO);
	    n->id = $2;
	    n->block = $4;
	    n->repeated = repeated;
	    n->next = macros;
	    macros = n;
	    repeated = 0;
	}
    ;

rep_block:
    repetition
	{
	    if ($1 > 1) {
		if (repeating) yyerror("can't nest repetitions");
		repeating = repeated = 1;
	    }
	}
      block
	{
	    repeating = 0;
	    $$ = $3;
	    if ($$) $$->repetitions = $1;
	}
    ;

repetition:
	{
	    $$ = 1;
	}
    | '[' decimal ']'
	{
	    $$ = $2;
	    if ($2 < 1) yyerror("invalid repetition count");
	}
    ;

block:
    TOK_ID
	{
	    MACRO **walk,*next;

	    for (walk = &macros; *walk; walk = &(*walk)->next)
		if ((*walk)->id == $1) break;
	    if (!*walk) yyerror("no such macro");
	    $$ = (*walk)->block;
	    if ((*walk)->repeated) {
		if (repeating) yyerror("can't nest repetitions");
		repeated = 1;
	    }
	    next = (*walk)->next;
	    free(*walk);
	    *walk = next;
	}
    | '{' fields '}'
	{
	    $$ = $2;
	}
    ;

fields:
	{
	    $$ = NULL;
	}
    | field fields
	{
	    $$ = $1;
	    $1->next = $2;
	}
    ;

field:
    opt_break TOK_ID '<' field_cont
	{
	    TAG *walk;

	    $$ = $4;
	    $$->brk = $1;
	    $$->id = $2;
	    if ($$->var_len == -2) {
		if (*$$->id == '_') yyerror("val-len field must be named");
	    }
	    else if (*$$->id == '_' && !$$->value)
		    yyerror("unnamed fields must have value");
	    if (*$$->id == '_' && $$->value && $$->value->type == vt_case)
		for (walk = $$->value->tags; walk; walk = walk->next)
		    if (walk->more)
			yyerror("value list only allowed in named case "
			  "selections");
	}
    ;

opt_break:
	{
	    $$ = 0;
	}
    | TOK_BREAK
	{
	    $$ = 1;
	}
    ;

field_cont:
     '-' decimal '>'
	{
	    $$ = alloc_t(FIELD);
	    $$->size = $2;
	    $$->var_len = -2; /* hack */
	    if ($2 & 7) yyerror("var-len field must have integral size");
	    $$->pos = 0;
	    $$->flush = 1;
	    $$->value = NULL;
	    $$->next = NULL;
	}
     | decimal opt_pos opt_more '>' opt_val
	{
	    $$ = alloc_t(FIELD);
	    $$->size = $1;
	    $$->var_len = -1;
	    $$->pos = $2;
	    $$->flush = !$3;
	    if ($$->pos == -1)
		if ($$->size & 7)
		    yyerror("position required for small fields");
		else $$->pos = 0;
	    $$->value = $5;
	    $$->next = NULL;
	}
    ;

opt_pos:
	{
	    $$ = -1;
	}
    | '@' decimal
	{
	    $$ = $2-1;
	    if ($$ < 0 || $$ > 7) yyerror("invalid position");
	}
    ;

decimal:
    TOK_ID
	{
	    char *end;

	    $$ = strtoul($1,&end,10);
	    if (*end) yyerror("no a decimal number");
	}
    ;

opt_more:
	{
	    $$ = 0;
	}
    | ',' TOK_ID
	{
	    if (strcmp($2,"more")) yyerror("\"more\" expected");
	    $$ = 1;
	}
    ;

opt_val:
	{
	    $$ = NULL;
	}
    | '=' value
	{
	    $$ = $2;
	}
    ;

value:
    TOK_ID
	{
	    $$ = alloc_t(VALUE);
	    $$->type = vt_id;
	    $$->id = $1;
	}
    | TOK_CASE '{' tags '}'
	{
	    $$ = alloc_t(VALUE);
	    $$->type = vt_case;
	    $$->id = NULL;
	    $$->tags = $3;
	}
    | TOK_MULTI '{' rep_tags '}'
	{
	    $$ = alloc_t(VALUE);
	    $$->type = vt_multi;
	    $$->tags = $3;
	}
    | TOK_LENGTH block
	{
	    $$ = alloc_t(VALUE);
	    $$->type = vt_length;
	    $$->block = $2;
	}
    ;

tags:
	{
	    $$ = NULL;
	}
    | TOK_DEFAULT TOK_ID opt_id list block
	{
	    $$ = alloc_t(TAG);
	    $$->deflt = 1;
	    if ($3) {
		$$->id = $2;
		$$->value = $3;
	    }
	    else {
		$$->id = NULL;
		$$->value = $2;
	    }
	    $$->more = $4;
	    $$->block = $5;
	    $$->next = NULL;
	}
    | TOK_ID opt_id list block tags
	{
	    $$ = alloc_t(TAG);
	    $$->deflt = 0;
	    if ($2) {
		$$->id = $1;
		$$->value = $2;
	    }
	    else {
		$$->id = NULL;
		$$->value = $1;
	    }
	    $$->more = $3;
	    $$->block = $4;
	    $$->next = $5;
	}
    ;

rep_tags:
	{
	    $$ = NULL;
	}
    | TOK_DEFAULT TOK_ID opt_id list rep_block
	{
	    $$ = alloc_t(TAG);
	    $$->deflt = 1;
	    if ($3) {
		$$->id = $2;
		$$->value = $3;
	    }
	    else {
		$$->id = NULL;
		$$->value = $2;
	    }
	    $$->more = $4;
	    $$->block = $5;
	    $$->next = NULL;
	}
    | TOK_ID opt_id list rep_block rep_tags
	{
	    $$ = alloc_t(TAG);
	    $$->deflt = 0;
	    if ($2) {
		$$->id = $1;
		$$->value = $2;
	    }
	    else {
		$$->id = NULL;
		$$->value = $1;
	    }
	    $$->more = $3;
	    $$->block = $4;
	    $$->next = $5;
	}
    ;

opt_id:
	{
	    $$ = NULL;
	}
    | ':' TOK_ID
	{
	    $$ = $2;
	}
    ;

list:
	{
	    $$ = NULL;
	}
    | ',' TOK_ID list
	{
	    $$ = alloc_t(VALUE_LIST);
	    $$->value = $2;
	    $$->next = $3;
	}
    ;
