%!CairoScript
% The data for this test case was provided by Gary Nicholson
% <gary@imapping.co.nz> who originally created an interactive SVG map
% of the world as can be seen here:
%
%	http://www.wherearewe.co.nz/svg.html
%
% The data is used here by permission from Gary given on 2006-11-08:
%
%	Thanks for asking, I don't need any attribution if you are
%	only using the vectors and not the entire map with
%	interactivity etc. So feel free to do what you wish with
%	the data.

/N {
  2 index
  .75 .75 .75 set-source-rgb fill+
  .5 .5 .5 set-source-rgb stroke
  pop
  m
} bind def

% simpler if these had been expressed in relative coords...
/H {
    exch /current-point get exch pop % x cr y
    3 -1 roll exch l
} bind def

/V {
    exch /current-point get pop % y cr x
    3 -1 roll l
} bind def

dict
  /width  800 set
  /height 400 set
  surface context

.68 .85 .90 set-source-rgb paint
.2 set-line-width

413.519 90.071 N .136 -.348 L -.31 -.204 L -.017 -.327 L .213 -.322 L .245 -.147 L .142 -.08 L .225 .072 L .062 .301 L .41 .312 L .466 .096 L -.044 .288 L -.248 .144 L .074 .353 L -.145 -.063 L -.568 -.011 L -.642 -.063 L
421.683 94.397 N .193 .336 L -.266 .274 L .214 .288 L -.09 .192 L .622 .062 L .008 .144 L .55 .242 L .579 -.332 L .215 .117 L -.029 .171 L -.126 .309 L .112 .212 L -.038 .192 L -.315 -.051 L -.176 -.162 L -.283 .091 L -.081 .273 L .244 .131 L -.228 .415 L -.244 -.333 L -.469 .05 L -.071 .122 L -.216 .03 L -.23 -.142 L -.143 -.354 L -.371 .081 L .019 .333 L -.425 .384 L -.018 .535 L -.285 .151 L -.385 -.312 L .098 -.182 L -.311 -.071 L -.534 -.363 L -.016 -.415 L -.777 .404 L .103 .212 L -.349 .432 L -.275 .16 L -.629 -.168 L -.627 .204 L -.599 -.062 L -.102 -.424 L -.312 -.806 L -.616 .147 L -.854 .668 L -.369 -.111 L .238 -.226 L .013 -.322 L -.08 -.137 L .089 -.294 L .718 -.418 L -.038 -.315 L .575 -.24 L .012 -.076 L .528 -.494 L .173 -.035 L -.116 -.089 L -.153 -.028 L .221 -.302 L .446 .007 L -.005 .096 L .473 .007 L .385 -.309 L .271 .089 L .272 -.117 L .271 .096 L .567 -.158 L .278 .11 L .354 -.021 L -.179 -.199 L .709 -.199 L .017 .151 L .199 -.014 L .149 .089 L .852 .007 L .664 .261 L
421.394 104.558 N .104 .175 L .04 .256 L -.06 .475 L .118 .054 L .062 .333 L -.076 .795 L -.211 .327 L -.118 .724 L -.292 .501 L -.298 -.043 L -.057 -.196 L -.41 -.076 L -.227 -.152 L .284 -.207 L -.07 -.076 L -.437 -.098 L .257 -.332 L -.11 -.071 L -.291 .071 L -.053 -.147 L .115 -.022 L .175 -.158 L -.094 -.153 L -.257 -.082 L .015 -.164 L .247 -.12 L -.284 -.218 L .241 -.284 L .6 -.305 L .27 -.022 L .04 -.125 L .292 -.043 L .195 .104 L .096 -.142 L -.022 -.344 L .072 -.224 L .143 -.011 L h 396.323 103.853 m .375 -.122 L .411 -.365 L .549 -2.299 L .397 -.091 L -.21 -.29 L -.226 .259 L .125 -1.144 L .223 -.826 L .115 .153 L .496 .306 L .191 .382 L .191 .229 L -.281 -.673 L -.63 -.582 L -.242 -.233 L .024 -.249 L .359 -.477 L -.202 -.375 L -.2 -.274 L -.326 -.216 L -.685 -.1 L -.515 -.571 L -.416 -.323 L .278 -.426 L -.233 -.181 L -.343 -.131 L -.511 -.142 L -.184 -.173 L .247 -.376 L -.329 -.173 L -.509 .179 L -.489 -.249 L -.824 -.251 L -.619 -.181 L -.325 .014 L -.215 -.25 L -.91 .167 L -.059 -.25 L -.265 -.125 L -.367 -.042 L -.056 -.104 L .861 -.083 L -.085 -.229 L -.526 -.104 L .442 -.104 L .086 -.205 L -.275 .017 L -.263 -.021 L -.417 .083 L .04 -.438 L .303 .012 L .305 -.146 L .526 -.088 L .562 -.174 L .215 .188 L .18 -.167 L .474 .063 L .112 -.26 L .272 -.059 L .764 -.078 L .393 .366 L .275 .26 L .342 .083 L .652 -.271 L .317 .167 L .276 -.127 L .457 -.124 L .029 .23 L .591 -.065 L .3 -.103 L -.265 -.188 L -.028 -.251 L .056 -.345 L -.037 -.428 L -.131 .021 L -.562 -.682 L -.11 -.407 L .927 .126 L .607 -.105 L -.084 .397 L .248 .419 L .342 -.146 L 1.241 .104 L .501 .146 L .079 -.014 L .525 -.093 L .662 -.27 L -.534 -.124 L .055 -.204 L .166 -.175 L .753 -.322 L .756 -.181 L .902 -.215 L .314 -.235 L .302 -.264 L -.053 -.775 L .135 -.542 L .521 -.25 L .46 -.16 L .916 -.092 L .177 -.096 L .208 .447 L .311 .335 L .266 .127 L .141 -.071 L .41 -.208 L .153 .17 L .202 .458 L .194 .133 L .518 -.012 L .159 .301 L .259 -.012 L .576 .048 L .375 .168 L -.159 .241 L .091 .175 L -.072 .198 L .285 .122 L .406 -.075 L .446 -.035 L .193 -.313 L .245 -.072 L -.119 .373 L .146 .18 L -.039 .228 L .529 .048 L .341 .192 L .371 .204 L .127 .228 L .694 -.174 L .079 .114 L .642 .063 L .568 .011 L .145 .063 L .428 .319 L .337 .277 L .395 -.055 L .045 .145 L .689 -.062 L .072 -.048 L .233 .007 L .095 .186 L .456 .09 L .479 -.014 L .605 .193 L -.954 .806 L -.054 .213 L -.054 .358 L -.321 .372 L -.075 .295 L .091 .076 L -.216 .701 L .135 .233 L -.385 .309 L -.473 -.007 L .005 -.096 L 415.96 94.5 l -.221 .302 L .153 .028 L .116 .089 L -.173 .035 L -.528 .494 L -.012 .076 L -.575 .24 L .038 .315 L -.718 .418 L -.089 .294 L .08 .137 L -.013 .322 L -.238 .226 L .369 .111 L .854 -.668 L .616 -.147 L .312 .806 L .102 .424 L -.624 .301 L .532 .344 L .025 .292 L .43 .192 L -.199 .272 L -.541 .353 L -.183 -.111 L -.437 .186 L .352 .358 L .616 .191 L .135 .331 L -.175 .01 L -.315 .371 L .193 .442 L .754 .391 L .849 -.07 L .062 .281 L -.146 .469 L -.346 .23 L -.221 .215 L -.833 .488 L -.889 .659 L -.427 .087 L -.318 .043 L -.798 .159 L -.405 -.028 L -.471 -.156 L -.851 -.499 L -.315 -.085 L -.354 .029 L -.231 .072 L -.511 -.056 L -.752 -.313 L -.602 .044 L -.731 .345 L -.357 .258 L -.555 .559 L -.147 .386 L .099 .514 L .091 .379 L -.334 -.091 L -.75 .137 L -.039 .136 L -.485 -.015 L -.427 -.197 L -.395 .167 L -.261 -.015 L -.036 -.152 L -.335 -.091 L -.206 .03 L -.374 .076 L -.187 -.076 L -.035 -.289 L -.091 -.213 L -1.252 -.304 L -.355 0 L .017 .319 L -.542 -.015 L -.337 .061 L -.037 -.122 L -.767 .03 L -.084 -.114 L -.028 -.038 L -.431 -.152 L -.131 .076 L -.262 -.03 L -.056 .076 L -.507 -.395 L -.15 .061 L -1.088 -.334 L -.112 .106 L -.15 -.03 L -.094 -.106 L .205 -.243 L -.058 -.122 L -.469 .03 L -.472 -.243 L
681.312 116.395 N .235 -.171 L .283 -.256 L .633 -.738 L .315 -.157 L .595 .011 L .579 .068 L .511 .096 L .309 -.115 L .571 -.678 L .682 .621 L 1.178 1.611 L .329 .495 L .269 .664 L .002 .75 L -.034 .947 L -.129 .637 L .143 .113 L .5 -.043 L -.121 .41 L -.282 .523 L -.5 .75 L -.316 .312 L -.243 .043 L -.567 -.211 L -.256 .1 L -.607 .58 L -.431 -.083 L -.289 -.225 L -.544 .1 L -.526 .199 L -1.188 .835 L -.462 .043 L -.46 .312 L -.055 -.564 L -.056 -.324 L -.163 -.705 L -.137 -.395 L .167 -.453 L .499 -.468 L 0 -.353 L .226 -.425 L -.044 -.141 L -.378 -.311 L -.095 -.296 L .015 -.467 L -.087 -.339 L -.289 -.126 L -.603 -.084 L .654 -.411 L .303 -.114 L .654 .268 L .254 -.241 L -.029 -.283 L -.764 -.89 L -.113 -.311 L -.137 -.105 L
475.646 121.847 N -.018 .175 L .338 .391 L -.295 -.009 L -.132 .108 L -.104 -.059 L -.327 -.021 L -.121 .33 L -.783 .257 L -.384 .046 L -.099 .053 L 0 .21 L -.217 .006 L -.072 -.192 L -.402 .023 L -.547 -.146 L -.191 -.087 L 0 -.21 L -.161 -.105 L -.122 -.403 L .082 -.035 L .12 .1 L .147 -.006 L .405 -.304 L .253 -.006 L .328 .092 L .077 -.086 L .088 -.286 L -.053 -.175 L .627 .093 L .658 .027 L .367 -.056 L .818 -.233 L .689 -.304 L .535 -.158 L -.475 .295 L -.436 .231 L -.596 .444 L
704.404 117.274 N .197 -.099 L 1.108 -.271 L .057 .354 L -.481 .284 L -.232 .241 L -.068 .453 L .139 .367 L .291 .056 L .221 -.114 L .418 -.354 L .24 -.085 L 1.656 -.697 L .389 -.213 L .46 -.326 L .349 -.638 L .76 -.412 L .347 -.327 L .191 -.269 L .142 -.51 L .538 -.582 L -.01 -.142 L .344 -.567 L .159 -.468 L .139 -.609 L -.043 -.467 L -.33 -.198 L -.128 -.24 L .234 -.213 L .166 -.284 L -.155 -1.023 L .544 -.343 L .176 -.242 L .327 -.328 L .192 0 L .21 .355 L .199 .227 L .303 -.058 L .799 -.257 L -.169 -.526 L -.311 -.028 L -.36 -.312 L .694 -.415 L .441 .156 L .336 .227 L .025 .199 L -.016 .868 L .058 .611 L .22 .127 L .243 .312 L .717 1.432 L .001 .496 L -.246 .709 L -.709 .766 L -.226 .439 L .064 .368 L -.15 .071 L -.737 .285 L -.161 .113 L -.164 .199 L -.174 .453 L .02 .396 L .094 .254 L .131 .792 L -.04 .693 L -.686 .751 L -.242 .736 L .02 .707 L .198 .296 L .422 .353 L -.617 .298 L -.193 .127 L -.166 .17 L -.174 .834 L -1.081 .439 L -.094 -.282 L .294 -.665 L .184 -.523 L -.198 -.126 L -.514 .241 L -.578 .623 L -.476 .001 L -.346 .312 L -.066 .748 L -.354 .269 L -.188 -.028 L -.066 -.155 L .003 -.606 L -.149 -.155 L -.211 .042 L -.309 .156 L -.344 .311 L -.325 .523 L -.866 -.055 L -.505 .057 L -.631 .1 L -.458 -.549 L -.685 -.323 L -.26 .254 L -.067 .184 L -.177 .353 L .037 .056 L .417 .197 L .416 .323 L -.293 .198 L -.829 .129 L -.433 .241 L -.463 .622 L -.522 .847 L -.688 -.365 L -.565 -.21 L -.285 -.197 L -.014 -.169 L -.194 -.818 L .099 -.155 L .495 -.325 L .179 -.269 L -.067 -.282 L -.18 -.042 L -.601 .17 L -.341 -.028 L -.789 -.167 L -.475 .128 L -.427 .227 L -.437 .184 L -.269 -.098 L -.256 -.027 L -1.647 .398 L -.814 .298 L -.21 -.31 L -.452 -.042 L -.413 .438 L -.006 .635 L -.756 -.238 L -.579 -.055 L -1.1 .073 L -.267 -.14 L .072 -.339 L .179 -.283 L .483 .013 L .499 -.114 L .751 -.467 L 2.201 -1.953 L .28 -.015 L .427 -.128 L .056 .424 L .495 -.128 L 1.278 -.257 L .933 -.058 L 1.183 -.172 L .892 -.256 L .068 .452 L .377 .268 L .167 -.085 L .654 -.199 L .446 -.34 L -.003 -.353 L .114 -.467 L .465 -.51 L .698 -.581 L .371 -.453 L -.062 -1.117 L .182 -.213 L h 695.464 127.756 m -.292 -.197 L -.223 -.268 L -.101 -.381 L -.177 -.395 L -.492 -.535 L .731 -.382 L .287 -.269 L .456 -.593 L .409 .253 L .615 -.015 L .483 -.185 L .311 -.339 L .451 -.311 L .454 -.029 L .316 .169 L .862 .224 L .153 .254 L -.1 .127 L -.102 .423 L -.292 .24 L -.864 .876 L -.181 -.211 L -.424 -.295 L -.467 -.042 L -.612 .213 L -.193 .184 L -.245 .495 L -.165 .508 L -.153 .212 L -.448 .269 L h 691.12 131.448 m -.366 -.042 L -.056 -.141 L .268 -.537 L .128 -.593 L -.334 -.112 L -.239 .198 L -.155 .466 L -.381 .452 L -.326 -.211 L -.059 -.211 L .322 -.466 L .032 -.296 L -.356 -.917 L .169 -.113 L .687 -.58 L .083 -.141 L .034 -.466 L -.532 -.789 L -.333 -.042 L -.162 .269 L -.419 .495 L -.249 -.112 L -.23 -.508 L -.376 -.267 L -.261 -.366 L .41 -.325 L .733 .083 L .706 -.171 L .315 -.466 L .241 -.283 L .484 -.058 L .478 .056 L .249 .38 L .27 .168 L .43 .084 L .628 -.213 L .225 .395 L -.569 .438 L .405 .239 L .443 .437 L .079 .254 L -.596 .58 L -.242 .41 L -.104 .367 L -.085 .621 L -.109 .649 L -.242 .353 L -.194 .099 L -.165 .071 L -.197 .184 L -.479 .678 L h 711.938 108.369 m -.222 -.241 L -.077 -.271 L .325 -.642 L -.055 -.342 L -.549 -.198 L -.168 -.171 L -.146 -.812 L .583 -.386 L .522 -.172 L .646 -.373 L .037 -.356 L -.318 -.285 L .277 -.3 L .224 -.015 L .661 .427 L .373 .085 L .532 -.201 L -.004 -1.186 L .455 -.187 L .45 -.244 L .074 -.743 L .007 -.844 L -.398 -.758 L -.098 -.473 L .166 -.216 L .618 -.346 L .063 .072 L .507 .43 L .904 .816 L 1.07 .842 L 1.083 .684 L .627 .285 L .528 .17 L 1.02 .198 L .282 .042 L .304 -.086 L .866 -.66 L .461 -.144 L .002 .1 L -.308 .358 L -.335 .558 L .198 .414 L .469 .599 L .197 .356 L -.561 .272 L -.447 .244 L -.534 .158 L -.365 .015 L -.488 -.199 L -.453 .015 L -.363 .144 L -.345 .229 L -.754 .786 L -.396 .5 L -.26 .599 L -.4 -.07 L -.425 -.241 L -2.031 -.965 L -.461 -.085 L -.72 .044 L -1.038 .587 L -.153 -.299 L -.372 -.356 L -.339 .029 L -.266 .115 L -.439 .272 L .049 .299 L 1.16 .497 L .56 .298 L .302 .27 L -.391 .214 L -.303 .029 L -.305 -.128 L -.261 .043 L -.324 .314 L -.388 .471 L -.347 .114 L
597.917 139.685 N 1.251 -1.545 L .609 -.539 L .348 -.239 L .149 -.103 L .417 -.016 L .309 .294 L .479 .208 L 1.659 .047 L .371 .041 L .312 .209 L .329 .619 L -.07 .156 L .042 .24 L .326 .294 L .313 .069 L .258 .238 L .017 .282 L -.217 .58 L -.624 .06 L -1.036 .062 L -1.238 -.063 L -.335 -.125 L -.301 -.055 L -.531 .313 L -.544 .074 L -.085 -.021 L -.869 -.214 L -.559 -.081 L -.637 -.18 L -.235 -.493 L .092 -.113 L
362.764 152.723 N .072 -.625 L .395 -.876 L .52 -.552 L .488 -.566 L .244 -.509 L 1.175 -2.559 L .238 -.241 L 1.404 -1.175 L .345 -.495 L .051 -.918 L .305 -1.088 L .651 -1.075 L .399 -.34 L .404 -.198 L .838 -.51 L .361 -.495 L .334 -.777 L .428 -.851 L 1.635 -.04 L 2.511 0 L 2.677 -.001 L 1.718 .004 L 1.42 -.008 L .027 .876 L -.03 1.752 L .002 .65 L -.104 .396 L -.56 -.011 L -6.005 -.022 L -.557 .074 L -.047 .509 L -.07 2.261 L -.099 2.6 L -.144 .128 L -.809 .287 L -.726 .315 L -.575 .427 L -.249 .383 L -.01 .707 L .164 1.539 L .051 1.102 L -.212 -.027 L -.732 .033 L -2.396 -.014 L -5.055 -.056 L -.474 -.013 L
514.551 145.841 N -.374 .027 L -.336 -.083 L -.008 -.615 L -.153 -.437 L -.108 -.791 L .187 -.607 L .188 -.11 L -.059 -.187 L .177 -.607 L .33 -.269 L .312 .083 L .069 .315 L .26 .093 L .063 .199 L .116 .326 L -.106 .42 L .031 .708 L .118 .254 L -.104 .381 L -.327 .467 L -.275 .433 L
514.177 145.868 N .374 -.027 L .008 .288 L .361 .14 L .153 .128 L .186 -.093 L -.046 .443 L .397 .001 L .402 .127 L .687 -.093 L .103 -.21 L .183 -.058 L .218 .117 L .424 -.042 L .595 .112 L .224 -.035 L .079 -.105 L 1.358 .222 L .732 -.14 L -.022 -.292 L .225 .175 L .375 -.016 L .157 -.099 L .312 -.422 L .232 -.073 L .267 -.495 L .131 -.297 L .711 -.637 L .813 -.889 L .163 .105 L .229 -.178 L .85 -.708 L .313 -.433 L .15 .161 L -.248 .42 L -.107 .299 L -.004 .176 L .099 .064 L .121 -.024 L .454 .042 L .09 .324 L .001 .508 L -.003 .358 L -.49 .034 L -.401 -.083 L -.107 .396 L .073 1.326 L -.199 .34 L -.536 .596 L .003 .946 L .024 2.075 L .063 .183 L -.152 .057 L -.584 .469 L -.839 -.108 L -3.387 -.446 L -3.362 -.375 L -.261 -.902 L -.548 -1.154 L -1.043 -2.198 L
668.627 151.365 N -.102 -.056 L -.107 -.325 L -.922 -1.212 L -.332 -.987 L -.03 -.438 L .156 -.749 L .546 -.792 L 1.312 -1.852 L .259 -.184 L .425 -.128 L .229 -.184 L .358 -.227 L .228 .127 L .554 .394 L -.334 .424 L -.084 .142 L .023 .31 L -.067 .622 L -.203 .296 L -.182 .354 L -.065 .692 L -.1 .494 L -.317 .805 L -.473 .707 L -.417 .833 L -.014 .353 L -.114 .438 L -.228 .142 L
389.765 144.543 N .1 .084 L .895 .531 L 2.054 1.344 L .811 .575 L 3.283 2.241 L 1.924 1.26 L 1.292 .824 L .397 .253 L 2.472 1.469 L .181 .253 L -.096 .396 L .082 .183 L .393 .28 L 1.111 1.039 L .229 .027 L .47 -.314 L .588 .562 L .375 .167 L .748 .024 L .309 .111 L .277 .352 L .099 .522 L -.161 .679 L .146 .564 L 2.176 -.408 L .064 1.017 L .034 2.203 L .001 .96 L -.08 .89 L -.145 .919 L -.434 1.246 L -.596 .794 L -.339 .271 L -.29 .129 L -2.533 .085 L -1.808 .124 L -.209 .072 L -.562 .427 L -.579 .272 L -.678 -.053 L -.581 -.081 L -1.062 -.173 L -.36 -.059 L -.356 -.125 L -.37 .073 L -1.22 .713 L -.947 .458 L -.304 .228 L -.314 .793 L -.274 -.027 L -.324 -.182 L -.518 -.209 L -.272 .101 L -.638 .625 L -.492 .667 L -.393 .822 L -.174 .227 L -.45 .102 L -.551 -.364 L -.293 -.281 L -.273 .058 L -.397 .384 L -.355 1.217 L -.292 1.047 L -.317 .369 L -.543 .271 L -.448 .158 L -.257 .016 L -.141 .255 L .058 .749 L -.133 .876 L -.261 .92 L -.172 .326 L -.046 .156 L -.08 .043 L -.159 .1 L -.604 .399 L -.352 .059 L -.148 -.239 L -.117 -.381 L -.004 -.297 L -.147 -.211 L -.257 -.041 L -.239 .114 L -.571 .483 L -.362 .469 L -.35 .228 L -.455 -.436 L -.566 -.321 L -.352 .059 L -.522 .54 L -.559 -.901 L -.194 -1.143 L -.349 -.718 L -.474 -.478 L -.265 -.451 L -.271 -.832 L -.022 -.339 L -.246 -.281 L -.323 -.055 L -.684 .428 L -.3 .327 L -.43 .243 L -.565 -.152 L -.356 -.153 L -.338 -.026 L -.475 .413 L -.252 .256 L -.536 -.265 L -.882 -.715 L -.18 -.183 L -.113 -.028 L .062 -.142 L .004 -.565 L -.082 -.833 L -.265 -.337 L -.554 -.322 L -.181 -.197 L -.22 -.479 L -.144 -.663 L -.251 -1.1 L .057 -.339 L .506 -.399 L .332 -.284 L .018 -.607 L .181 -.552 L .252 -.256 L .402 -.073 L .261 .111 L .568 .83 L .214 .168 L .454 .082 L .107 -.269 L -.055 -.296 L .06 -.212 L .535 .124 L .713 .137 L .485 .054 L .387 -.031 L .945 -.344 L 1.953 -.026 L 6.457 -.01 L .379 -1.613 L -.724 -.787 L -.186 -1.468 L -.202 -2.386 L -.325 -2.753 L -.178 -1.736 L -.19 -1.468 L -.908 -7.962 L -.049 -.776 L 3.231 -.089 L .523 -.13 L
525.37 142.384 N .312 -.429 L .155 -.17 L .084 .833 L -.423 .707 L -.118 .156 L -.121 .024 L -.099 -.064 L .004 -.176 L .107 -.299 L .248 -.42 L -.15 -.161 L h 525.923 144.712 m 0 .22 L .456 .762 L .408 .465 L .782 .634 L .677 .394 L 1.008 .52 L .392 .154 L .277 .014 L .576 -.029 L .364 .112 L .873 .973 L .518 .648 L .46 .422 L .81 .365 L .025 .212 L -.67 1.06 L -.615 .721 L -.883 .807 L -.776 1.541 L -.242 .142 L -.562 -.083 L -.235 -.084 L -.252 .071 L -.278 .509 L -.062 1.115 L .001 .791 L .134 .621 L -.403 .142 L -1.046 .073 L -.627 .27 L -.367 .283 L -.29 .495 L -.131 .551 L -.204 .283 L -.444 .255 L -.544 .1 L -.292 0 L -.386 -.042 L -.326 .029 L -.382 .283 L -.22 .297 L -.125 .508 L .003 .353 L -.091 .311 L -.631 .396 L -.344 .043 L -.776 -.21 L -.717 .058 L -.896 .27 L -.768 .298 L -.283 .099 L -.416 .145 L -.241 -.306 L -.483 -.689 L .006 -.296 L -.127 -.253 L -.933 -1.364 L -.604 -.971 L -.226 -.634 L -.092 -.663 L 1.691 -.815 L 2.35 -1.213 L 5.346 -2.982 L -.155 -1.453 L -.581 -.914 L -.063 -.183 L -.024 -2.075 L -.003 -.946 L .536 -.596 L .199 -.34 L -.073 -1.326 L .107 -.396 L .401 .083 L .49 -.034 L
405.733 173.04 N -.568 -.971 L -.562 -.025 L -.37 .044 L -.516 -.181 L -.97 -.757 L -.114 -.226 L .335 -.439 L -.018 -.212 L -.179 -.268 L -.502 -.42 L -.389 -.266 L -.422 -.492 L -.426 -.93 L -.019 -.396 L .173 -.665 L .581 .081 L .678 .053 L .579 -.272 L .562 -.427 L .209 -.072 L 1.808 -.124 L 2.533 -.085 L .29 -.129 L .339 -.271 L .596 -.794 L .434 -1.246 L .145 -.919 L .08 -.89 L -.001 -.96 L -.034 -2.203 L -.064 -1.017 L 1.672 -.321 L 1.82 -.364 L 3.084 -2.617 L .834 -.655 L 2.308 -1.454 L 1.607 -.956 L 4.012 -2.241 L 1.632 -.843 L .265 -.186 L .832 .137 L 1.646 .442 L 1.008 .333 L .258 .182 L 1.192 .911 L .231 -.157 L 1.519 -.729 L .364 2.145 L .169 1.298 L .42 1.028 L .554 .802 L .703 .604 L -.388 .722 L -.265 .99 L -.168 1.088 L -.084 .989 L .022 .537 L -.062 .707 L -.019 1.045 L -.034 1.088 L -.056 .466 L -2.43 2.613 L -.591 .78 L -.87 1.333 L -.572 .794 L -.007 .678 L .123 .719 L .014 .269 L -.951 .034 L -.437 .2 L -.453 .299 L -.761 .697 L -.259 .058 L -.609 -.208 L -.724 -.193 L -.884 -.221 L -.531 -.04 L -.709 .047 L -.628 .103 L -.774 .287 L -.403 .327 L -.629 .399 L -.273 .059 L -.934 .005 L -.965 -.277 L -1.173 -.742 L -.354 -.083 L -.467 .116 L -1.337 .544 L -.37 .002 L -.209 -.098 L -1.095 -1.223 L -.821 -.277 L -1.111 -.121 L -1.174 .108 L -1.064 .188 L -.676 .4 L -.687 1.614 L -.353 .482 L -.158 .849 L -.092 .961 L -.902 -.503 L -.727 -.589 L -.339 -.28 L -.321 .073 L -.577 .3 L
431.763 171.063 N -.351 -.407 L -.575 -.52 L -.173 -.394 L -.014 -.269 L -.123 -.719 L .007 -.678 L .572 -.794 L .87 -1.333 L .591 -.78 L 2.43 -2.613 L .056 -.466 L .034 -1.088 L .019 -1.045 L .062 -.707 L -.022 -.537 L .084 -.989 L .168 -1.088 L .265 -.99 L .388 -.722 L -.703 -.604 L -.554 -.802 L -.42 -1.028 L -.169 -1.298 L -.364 -2.145 L 1.818 -.858 L .41 -.059 L 5.231 2.554 L 4.941 2.372 L 5.577 2.792 L 1.981 .963 L -.02 1.045 L -.016 .946 L -.036 .636 L .085 2.5 L -.038 .749 L .036 1.002 L .031 1.229 L -.04 .283 L -.839 -.009 L -1.245 .05 L -.229 .143 L -.417 1.245 L -.583 .809 L -.122 .438 L .131 .677 L -.149 .212 L -.718 .428 L -.053 .24 L .342 .662 L -.087 .34 L -.542 .596 L -.316 .609 L .219 .352 L .517 -.088 L .338 .012 L .141 .225 L .221 1.228 L .137 .522 L .155 .295 L .444 .407 L .266 .465 L .026 .367 L -.15 .425 L -.559 -.208 L -.321 -.012 L -.322 .086 L -.939 .613 L -.372 .228 L -.165 .382 L -.005 .41 L -.196 .284 L -2.649 2.275 L -.386 .087 L -2.181 .055 L -.434 .059 L -.209 .199 L -.117 .806 L -.646 1.176 L -.258 .143 L -.368 .031 L -.881 -.009 L -.818 .273 L -.754 .386 L -.466 .271 L -.224 .03 L -.225 -.069 L -.494 -.661 L -1.363 .686 L -.449 .158 L -.24 -.027 L -.096 -.084 L -.208 -.183 L -.382 -1.057 L -.638 -1.07 L -1.343 -1.179 L -1.088 -1.067 L .323 -.539 L .29 -.312 L .24 -.1 L .481 .082 L 1.187 .191 L .674 -.032 L .225 -.143 L -.047 -.127 L -.208 -.21 L -.381 -.633 L -.205 -.578 L -.169 -1.228 L .134 -.651 L -.119 -1.2 L -.395 -.887 L -.923 -1.238 L -.208 -.083 L -.627 -.109 L
627.173 150.012 N .483 -.229 L .515 -.13 L .341 .012 L .597 .392 L .325 .097 L .584 -.413 L .332 -.115 L 1.595 -.052 L .807 -.117 L .341 -.157 L .696 -.554 L .521 -.328 L .298 -.101 L .623 .575 L .771 .235 L .66 .053 L .777 -.047 L .237 .21 L .056 .38 L -.472 .75 L .096 .521 L .273 .365 L .943 .615 L .621 .166 L .909 .107 L .197 .143 L -.19 .132 L -.826 .482 L .106 .465 L -.203 .212 L -1.261 -.054 L -.136 .198 L .057 .395 L -.283 .382 L -.585 .792 L -.221 .142 L -.533 .241 L -.171 .127 L -.27 .396 L -.303 .932 L -.388 .975 L .268 .225 L .469 .563 L 1.112 1.071 L .023 .24 L .042 .522 L .087 .254 L .42 .493 L 1.096 .83 L 1.282 1.296 L .26 .197 L .636 .069 L .313 .38 L .282 1.016 L .302 .578 L .638 .605 L .293 .663 L .341 1.382 L .524 2.809 L -.295 .438 L -.235 .495 L .05 .819 L -.095 .41 L .056 .664 L -.027 .099 L -.364 .551 L -.447 .439 L -.254 .127 L -.509 .1 L -.419 .17 L -.501 .354 L -.591 .622 L -.579 .354 L -.325 .043 L -.512 -.197 L -.404 -.31 L -.179 -.141 L -.153 .424 L .051 .494 L .048 .353 L -.205 .721 L -.388 .424 L -.326 .071 L -.235 -.07 L -.246 .481 L -.427 .326 L -.523 .142 L -.417 .213 L -.459 .565 L -.196 .269 L -.406 .297 L -.264 .099 L -.365 -.042 L .078 -.861 L .1 -1.313 L .151 -.494 L .215 -.283 L -.02 -.353 L -.475 -.437 L -.749 -.238 L -.091 -.066 L .3 -.289 L .646 -.229 L .915 -.528 L .599 -.229 L .497 .011 L .688 .194 L .17 -.27 L -.03 -.197 L -.568 -.435 L -.216 -.422 L .234 -.425 L .99 -.571 L .521 -.229 L .932 -.443 L .599 -.187 L .385 -.285 L .217 -.509 L -.054 -1.073 L .05 -.424 L .076 -.367 L -.455 -1.014 L -.029 -.663 L .215 -.905 L .155 -.918 L -.064 -.578 L -.214 -.437 L -.529 -.477 L -.072 -.282 L .226 -.439 L -.136 -.395 L -.358 -.308 L -.685 -.391 L -.471 -.52 L -.57 -.914 L -1.683 -2.121 L -.698 -.772 L -.637 -.646 L -.632 -.476 L -1.234 -.741 L -.162 -.098 L -.043 -.494 L .277 -.369 L .311 -.101 L .476 .068 L .287 -.058 L .261 -.185 L .255 -.326 L -.009 -.508 L -.87 -.968 L -.434 -.675 L -.262 -.083 L -.39 .171 L -.509 .483 L -.287 .058 L -.47 -.195 L -.607 -.434 L -.334 -.689 L -.338 -.929 L -.543 -.604 L -.613 -.575 L -.45 -.745 L
217.961 150.385 N .304 -.043 L .84 -.27 L -.17 -.254 L -.312 -.112 L -.369 -.056 L -.651 .016 L -.497 -.042 L -.645 .157 L -1.193 .92 L -.371 .029 L -.653 .001 L -.211 .113 L -.189 .452 L -.396 .284 L -.32 .043 L -.786 .086 L .259 -.325 L .473 -.312 L -.128 -.593 L .282 -.382 L .114 -.099 L 1.258 -.61 L 1.625 -.47 L 1.164 -.087 L .842 -.157 L .825 .041 L .566 -.044 L .73 .168 L .848 .083 L .603 .197 L .557 .112 L .477 .013 L .499 .268 L .573 .536 L .382 .253 L .581 .168 L .768 .111 L 1.229 .351 L 1.02 .492 L .453 .31 L .374 .55 L .33 .141 L .479 .041 L 1.704 .519 L 1.018 .167 L .327 .239 L -.344 .58 L .233 .155 L .559 .042 L .756 -.072 L .495 .168 L .507 .38 L .591 .281 L .381 .296 L -.233 .085 L -.981 .087 L -1.15 .398 L -.626 .058 L -1.054 -.209 L -.9 -.041 L -.934 .186 L -.943 .115 L -.484 .029 L -.449 -.07 L .353 -.382 L .728 -.623 L .173 -.396 L 229 154.204 l -.181 -.127 L -.622 -.14 L -.7 .001 L -.603 -.112 L -.651 -.338 L -.141 -.748 L -.258 -.536 L -.218 -.155 L -.396 -.027 L -1.005 .044 L -.836 -.139 L -.621 -.225 L -.956 -.493 L -.739 -.238 L -.615 -.069 L -1.154 -.068 L -.489 -.098 L -.855 -.352 L
634.036 168.444 N .808 -.64 L .121 -.438 L -.002 -.945 L -.157 -.507 L -.419 -.703 L -.979 -1.279 L -.255 -.464 L -.107 -.366 L -.058 -1.524 L -.435 -.632 L -.688 -.659 L -.285 -.535 L -.052 -.282 L -.266 -.153 L -.893 -.192 L -.403 -.012 L -.286 .453 L -.2 .538 L -.543 .257 L -.223 .072 L -.59 -.265 L -.835 -.348 L -.346 .03 L -1.173 1.178 L -.37 .411 L -.481 -.138 L -.145 -.324 L .027 -.494 L .117 -.438 L .528 -1.569 L .085 -.41 L -.249 -1.311 L -.045 -.113 L -.414 .045 L -.489 .2 L -.423 .003 L -.186 -.154 L -.066 -.367 L .106 -.805 L -.01 -.423 L -.118 -.168 L -.295 -.182 L -.541 -.166 L .193 -.185 L .582 -.455 L .442 -.581 L .53 -.61 L .502 -.355 L .178 .196 L .321 .21 L .769 .08 L .266 -.213 L .109 -.339 L -.119 -.521 L -.228 -.366 L -.138 -.592 L .043 -.325 L .24 -.241 L .679 -.314 L .45 .745 L .613 .575 L .543 .604 L .338 .929 L .334 .689 L .607 .434 L .47 .195 L .287 -.058 L .509 -.483 L .39 -.171 L .262 .083 L .434 .675 L .87 .968 L .009 .508 L -.255 .326 L -.261 .185 L -.287 .058 L -.476 -.068 L -.311 .101 L -.277 .369 L .043 .494 L .162 .098 L 1.234 .741 L .632 .476 L .637 .646 L .698 .772 L 1.683 2.121 L .57 .914 L .471 .52 L .685 .391 L .358 .308 L .136 .395 L -.226 .439 L .072 .282 L .529 .477 L .214 .437 L .064 .578 L -.155 .918 L -.209 .114 L -.975 .429 L -.3 .072 L -.373 -.351 L -.444 -.181 L -.476 .186 L -.392 .285 L .107 .296 L .187 .182 L .103 .211 L -.095 .24 L -.248 .058 L -.469 -.251 L -.341 -.111 L -.736 -.165 L -.533 -.251 L
60.074 72.607 N -.099 .228 L -.491 .472 L -.395 .183 L -.462 .062 L 58 73.461 l -.961 -.362 L -.153 -.197 L .169 -.289 L .54 -.274 L .341 -.32 L .716 .364 L .3 .091 L .465 -.26 L .215 -.213 L .064 -.366 L .485 -.047 L 1.107 .135 L .536 .334 L .133 .213 L -.756 .062 L -.429 0 L -.59 .184 L -.11 .092 L h 40.092 77.571 m -.729 -.029 L -.097 -.24 L .011 -.3 L .802 -.243 L .326 -.211 L .593 -.423 L .448 -.137 L .646 -.077 L 1.427 .253 L .711 .24 L -.079 .211 L -.303 .046 L -.754 -.074 L -.496 .031 L -1.077 .183 L -.269 .226 L -1.161 .543 L h 38.426 77.979 m -.515 -.209 L -.139 -.285 L .381 -.227 L .674 .27 L .093 .195 L -.122 .15 L -.372 .105 L h 37.896 78.449 m -.256 .084 L -.558 .151 L -1.109 -.058 L -.387 .135 L -.398 .434 L -.31 .15 L -.854 -.207 L -.135 -.224 L .497 -.359 L .5 -.315 L .955 -.166 L .863 -.346 L .39 .089 L .461 .224 L .341 .409 L h 29.628 81.29 m -.168 -.594 L -.324 -.476 L .839 -.136 L .424 .088 L .436 .238 L -.244 .268 L -.26 .06 L -.073 .297 L -.22 .09 L -.412 .164 L h 27.543 81.591 m -.39 .031 L -.741 .165 L -.311 -.133 L -.088 -.178 L .104 -.119 L .336 -.268 L .294 -.09 L .584 .222 L .212 .371 L h 54.394 157.986 m -.559 -.356 L -.044 -.884 L -.243 -.677 L .482 -.402 L -.035 -.2 L -.156 -.26 L .052 -.149 L .173 -.046 L .354 .158 L .652 .279 L .593 .425 L -.015 .275 L .238 .046 L .12 .287 L .306 .149 L -.062 .161 L 56 156.933 l -.172 .204 L -.766 .195 L -.374 .23 L -.295 .425 L h 23.015 59.92 m -1.613 -.646 L -.75 -.205 L -.792 -.062 L -.9 .065 L -.291 -.095 L -.431 -.222 L .179 -.287 L .516 -.049 L 1.135 .221 L .579 -.001 L .543 -.081 L .538 -.001 L .828 .285 L 1.725 .362 L .429 .237 L .046 .111 L -.569 -.03 L -.646 .033 L -.527 .365 L h 99.855 70.993 m .467 .929 L -.071 .167 L -.879 -.272 L -.621 -.075 L .067 .441 L -.056 .228 L -.935 -.607 L 97.03 71.41 l .396 -.458 L .263 -.153 L .612 -.078 L .784 .38 L .771 -.108 L h 100.975 73.606 m .128 .272 L -.086 .273 L -.318 .483 L -.559 -.815 L -.597 -.909 L -.04 -.228 L .095 -.213 L .407 .029 L .568 .197 L .402 .91 L h 106.858 78.207 m -1.872 -1.166 L -.566 -.555 L .01 -.467 L -.559 -.843 L .071 -.106 L .456 .06 L .274 .256 L 1.165 .48 L .086 .196 L -.059 .136 L -.149 .226 L .296 .436 L .839 .374 L .007 .974 L h 140.191 127.819 m -.043 -.094 L -.198 -.36 L -.049 -.067 L -.032 .042 L -.028 .05 L -.04 -.092 L .002 -.664 L -.331 -.604 L -.472 -.451 L -.661 -.451 L -.512 -.197 L -.114 -.052 L -.145 .034 L .002 .092 L -.088 .025 L -.1 -.042 L -.146 -.143 L .076 -.076 L -.073 -.202 L -.228 -.252 L -.283 -.025 L -.312 .084 L -.932 -.336 L -.286 -.328 L -.428 -.244 L -.383 .042 L -.932 -.16 L -.721 .051 L -.12 -.185 L -.234 -.067 L -.046 -.177 L .094 -.117 L -.157 -.504 L .133 -.464 L -.227 -.096 L -.127 .008 L -.249 -.134 L 0 -.101 L .075 -.093 L -.029 -.219 L -.347 -.185 L -.254 -.286 L -.415 -.219 L -.391 -.623 L -.202 -.076 L -.203 -.311 L -.409 -.219 L -.156 -.529 L -.002 -.227 L .178 .007 L .147 -.164 L .029 -.326 L -.208 -.251 L -.192 -.045 L -.22 .037 L -.303 -.126 L -.535 -.514 L .078 -.21 L -.091 -.312 L -.129 -.067 L -.044 -.463 L .058 -.152 L .119 -.025 L .099 .067 L .073 .076 L -.086 .101 L .153 .202 L .285 .126 L .116 .118 L .203 .017 L -.385 -.564 L -.183 -.144 L -.021 -.236 L -.184 -.109 L -.051 -.344 L -.13 .006 L -.011 .144 L .048 .446 L -.093 .017 L -.293 -.194 L -.119 .042 L -.516 -.404 L -.136 -.363 L -.377 -.514 L -.531 -.379 L -.624 -.583 L -.123 -.142 L .114 -.101 L -.327 -.751 L .161 -.43 L -.254 -.479 L -.22 -.355 L -.738 -.782 L -.104 -.299 L .099 -.627 L .252 -.628 L .166 -.357 L .059 -.856 L -.215 -.785 L -.692 -1.486 L -.153 -.916 L .096 -.287 L .231 -.244 L .402 -.201 L .365 -.717 L -.365 -.573 L -.066 -.33 L .424 -1.593 L .153 -.575 L .061 -.634 L .091 -.778 L .019 -.179 L -.153 -.16 L .08 -.231 L -.103 -.167 L .157 -.077 L -.03 -.186 L -.046 -.186 L -.031 -.103 L -.004 -.058 L .322 .096 L .209 -.019 L .062 -.097 L -.211 .006 L -.614 -.122 L .062 -.707 L -.103 -.328 L .017 -.277 L .587 -.225 L -.345 -.019 L -.16 -.142 L -.129 0 L -.053 .045 L .042 .116 L -.12 .052 L -.133 -.979 L -.927 -1.463 L -.017 -.465 L .129 -.131 L .544 .086 L .632 .217 L .785 .114 L .641 .028 L .546 -.044 L .415 .086 L .547 .318 L .039 .435 L -.42 .407 L -.413 .347 L .532 .146 L .184 .188 L .251 .169 L .029 -.228 L .161 -.232 L .393 -.305 L .21 -.581 L .102 -.465 L -.064 -.421 L -.356 -.958 L -.158 -.305 L -.655 -.516 L .194 .013 L 2.579 .001 L 1.335 .022 L 4.588 -.025 L 3.938 .008 L 2.87 -.001 L 1.687 .006 L 5.117 -.028 L .74 .011 L 4.13 .021 L 1.089 -.035 L 3.821 .023 L .875 -.005 L 3.617 -.004 L 4.84 .018 L .601 -.003 L 2.935 .014 L 2.131 -.012 L 2.781 .029 L 2.915 -.016 L 2.105 .003 L 1.348 -.007 L 2.798 .029 L 2.687 -.029 L .68 .003 L -.387 -.588 L -.131 -.347 L .501 -.036 L .896 .748 L .279 .371 L .468 .46 L .833 .451 L .518 -.076 L 1.425 .208 L .02 .185 L .271 -.012 L .338 .48 L .16 -.247 L .502 .013 L .241 .271 L .469 .086 L .064 .185 L .506 .098 L .573 -.141 L .219 -.06 L .412 -.191 L .373 -.075 L .028 .282 L .197 .116 L .855 -.083 L .474 .041 L .156 .115 L .196 .144 L .542 -.049 L .707 .074 L 1.469 -.592 L .805 -.189 L .797 .227 L .977 .386 L 3.975 1.576 L 2.15 1.061 L .101 .429 L .46 .465 L .628 -.024 L .178 .135 L .184 .294 L .916 .181 L .307 .235 L -.11 .318 L .26 .33 L 2.529 1.05 L .876 3.16 L .054 .545 L -.028 .746 L -.377 .576 L -.294 .544 L -.264 .433 L -.414 .294 L -.707 .525 L -.044 .218 L .012 .33 L .371 .427 L .497 .169 L .573 .068 L .524 -.117 L .925 -.506 L .939 -.478 L .88 -.262 L .919 -.062 L .944 -.163 L 1.464 -.452 L .875 -.427 L -.047 -.362 L -.16 -.471 L -.018 -.319 L .162 -.375 L .47 -.203 L .93 -.091 L 1.123 .01 L 1.305 .138 L 1.156 -.197 L .44 -.275 L .163 -.512 L .146 -.434 L .545 -.164 L 1.754 -.814 L .534 -.305 L .968 -.523 L 1.76 -.009 L 2.508 .029 L 1.855 .004 L 1.093 .095 L .174 -.375 L .363 -.435 L .402 -.06 L 1.161 .124 L 1.139 -1.45 L 1.139 -2.22 L .514 -.626 L .632 -.526 L .273 .085 L .505 .36 L .381 .085 L .41 -.176 L .771 .025 L .488 .288 L .174 .274 L .31 2.819 L -.077 .229 L .606 .231 L .224 0 L .042 .154 L -.143 .069 L .02 .256 L -.192 .077 L .16 .291 L .188 -.153 L .349 .495 L -.268 .281 L .299 -.04 L .171 .093 L -.511 .374 L -.509 .093 L -.297 -.12 L -.013 .253 L -.138 .067 L -.077 -.107 L -.231 -.08 L -.277 .133 L -.101 .28 L -.171 -.013 L -.15 .16 L -.175 -.347 L -.746 .28 L -.204 -.093 L .12 .413 L -.666 -.213 L .199 -.48 L -.149 -.04 L -.364 .52 L -.332 .56 L -.342 .333 L -.324 -.227 L -.249 .439 L -.346 -.08 L .122 -.307 L -.325 .253 L .165 .16 L -.326 .293 L -.318 -.133 L .105 -.226 L -.654 .253 L .065 .359 L -.264 .04 L -.161 .373 L -.352 .106 L -.333 .679 L -.404 .505 L .173 .146 L .068 .212 L .168 .053 L .083 -.08 L .169 .013 L -.122 .146 L -.547 .106 L .053 .093 L -.392 .292 L -.068 .159 L .337 .027 L .282 .093 L .599 .704 L .055 .398 L .399 .106 L .691 -.239 L -.022 -.186 L -.14 -.027 L -.254 -.279 L -.097 -.04 L -.009 -.066 L .196 0 L .23 .133 L .218 .358 L .031 .425 L -1.599 .292 L -.032 -.385 L -.124 -.066 L -.109 .226 L -.164 .04 L -.03 .093 L -.105 -.106 L -.159 .266 L -.164 .04 L -.294 .04 L -.045 -.332 L .198 -.332 L -.443 .119 L -.154 -.146 L -.082 .252 L -.087 .664 L -1.429 .132 L -1.694 .159 L -1.182 .345 L -.787 .358 L -.097 .212 L -.32 .053 L -.144 .172 L -.032 -.04 L .308 -.756 L .024 -.106 L -.071 .027 L -.41 .994 L -.079 -.08 L -.406 .292 L .218 .318 L .553 .093 L -.46 1.515 L -.302 .429 L -.259 -.092 L .043 .251 L -.062 .185 L -.237 .145 L -.462 .501 L -.292 .304 L -.167 .026 L -.075 -.119 L .177 -.31 L -.113 -.178 L -.43 .013 L -.447 -.343 L -.148 -.053 L -.329 -.541 L .315 -.257 L .151 -.245 L -.271 .119 L -.362 .37 L .489 .845 L .033 .356 L .387 .581 L .28 .066 L .104 .765 L -.101 .238 L -.151 .23 L -.125 -.013 L -.487 .666 L -.396 .798 L .034 .053 L -.13 .132 L -.107 -.125 L -.374 .725 L .026 .125 L -.226 .04 L -.137 -.263 L .342 -.864 L .195 -.29 L .247 -.119 L .061 -.237 L -.093 -.059 L -.374 .119 L .226 -.383 L -.218 .04 L -.176 -.093 L .012 -.191 L .242 -.04 L -.077 -.33 L -.439 .296 L -.241 -.204 L -.157 .053 L -.23 -.396 L .355 -.171 L .357 -.053 L -.005 -.06 L -.604 -.316 L -.092 .165 L -.072 0 L .107 -.323 L .089 -.02 L .21 .159 L .131 -.06 L -.098 -.224 L -.353 -.066 L -.065 -.112 L .096 -.112 L .336 .02 L .193 -.284 L -.281 .046 L -.158 -.059 L .241 -.37 L .652 -.152 L -.328 -.06 L .146 -.409 L -.28 .093 L -.096 .132 L .11 .079 L -.315 .191 L -.035 -.224 L -.093 .053 L .051 .224 L -.081 .086 L -.051 -.158 L -.097 -.066 L -.103 .416 L -.447 -.079 L .402 .501 L -.294 .666 L .07 .237 L .272 .488 L -.055 .139 L -.466 -.317 L -.1 -.211 L .026 .205 L .174 .218 L .421 .237 L .132 .508 L -.631 -.402 L -.354 -.007 L -.118 -.283 L -.155 -.053 L .066 .25 L -.541 -.323 L -.33 .04 L .015 -.29 L .427 -.323 L -.428 .079 L -.19 .468 L .204 .231 L .457 .046 L .202 .25 L .954 .297 L -.047 .092 L .554 .165 L .158 .132 L -.22 .468 L -.227 .06 L -1.042 -.804 L .708 .811 L .626 .171 L -.248 .092 L .323 .079 L -.045 .079 L .061 .06 L -.034 .25 L -.312 -.191 L -.071 .073 L .104 .211 L -.216 .02 L -.656 -.56 L -.023 .026 L .419 .475 L .309 .158 L .182 -.026 L .191 .21 L .018 .31 L -.298 .059 L -.492 -.534 L -.474 -.198 L -.199 .16 L .046 .044 L .44 .145 L .488 .382 L -.047 .237 L .442 -.033 L .031 -.119 L .748 .119 L .151 .382 L .406 1.212 L .448 .803 L -.14 -.092 L -.262 -.349 L -.059 -.132 L -.359 -1.172 L -.147 -.277 L -.056 .31 L .135 0 L .034 .198 L -.292 -.066 L .173 .283 L .144 .099 L .228 .58 L -.144 -.053 L -.211 -.382 L .002 .224 L -.52 -.303 L -.06 .059 L .266 .303 L -.247 .119 L -.526 -.204 L .225 .204 L -.375 .211 L -.173 -.02 L -.251 -.21 L -.024 -.217 L .083 -.158 L -.081 -.053 L -.091 .204 L .044 .23 L .116 .211 L -.107 .158 L .894 .02 L .571 -.145 L .125 .165 L -.113 .191 L -.072 .369 L .14 .066 L .092 -.257 L .135 -.369 L .18 -.105 L .266 .31 L .047 .296 L -.166 .25 L -.163 -.013 L -.063 -.099 L -.316 .474 L -.254 .197 L -.483 -.053 L -.203 -.065 L -.147 -.066 L -.136 -.245 L -.151 .014 L .141 .244 L -.075 .013 L -.538 -.125 L -.436 -.151 L .162 .185 L .269 .026 L .833 .335 L -.034 .119 L -.396 .145 L .247 .007 L -.19 .25 L -.281 .138 L -.149 0 L -.481 -.375 L .242 .395 L .43 .164 L .302 -.171 L .292 .026 L .11 -.204 L .04 .178 L .217 .04 L .048 .079 L -.428 .322 L -.013 .085 L -.261 .072 L -1.498 .214 L -.865 .895 L -.487 .609 L -.13 .127 L -.935 .143 L -.528 .128 L -.617 .241 L -.678 .539 L -.225 .424 L -.096 .354 L -.819 .694 L -.693 .383 L -.429 .199 L -.797 .086 L -.35 .58 L -.177 .198 L -.809 1.125 L -.273 .781 L -.459 1.249 L .236 1.455 L .387 .925 L .456 .873 L .934 1.562 L .352 1.746 L .486 1.194 L -.075 .092 L .287 .276 L .123 .333 L .062 .827 L -.301 1.536 L -.064 .278 L -.31 .415 L .108 .424 L -.02 .252 L -.393 .551 L -.017 -.092 L .129 -.241 L -.025 -.138 L -.256 .035 L -.38 .137 L -.291 -.126 L -.509 .138 L -.12 -.329 L .014 -.233 L -.567 -1.068 L -.764 -.138 L -.204 -.352 L -.113 -.819 L -.423 -.229 L -.144 -.702 L -.373 .093 L -.608 -1.08 L -.375 -.482 L .296 0 L .375 -.438 L .048 -.226 L -.167 -.226 L -.471 .407 L -.277 -.208 L .126 -.573 L .147 -.758 L .158 -1.043 L -.293 -.452 L -.258 -.169 L -.496 -.126 L -.832 -.987 L -.875 -.804 L -.528 -.168 L -.43 .072 L -.536 .298 L -.456 .354 L -1.202 .299 L -.273 -.213 L -.131 -.62 L -.253 -.254 L -.264 -.113 L -.752 -.069 L -.516 -.296 L -.22 -.233 L -.504 .138 L -1.052 .115 L -.653 -.184 L -.047 .298 L -.64 .099 L -.183 0 L -.578 -.926 L -.238 .781 L -.447 -.135 L -.65 .001 L -1.328 -.04 L -.672 .439 L -.39 .055 L -1 -.459 L -.096 .009 L -.142 .014 L -.362 .528 L .201 .229 L .303 0 L .211 0 L .537 -.207 L .406 .092 L .676 .482 L -.68 .373 L .02 .254 L .263 .353 L .593 .146 L .229 .217 L .35 .334 L -.533 .136 L -.503 -.084 L -.276 -.419 L -.79 -.271 L -.224 -.211 L -.265 -.056 L -.013 .02 L -.209 .32 L .209 .154 L .248 .183 L -.248 .179 L -.069 .05 L -.447 -.459 L -.476 .192 L -.287 .291 L -1.025 -.472 L -.419 -.494 L -1.16 -.642 L -.615 .066 L .554 .393 L -.307 .187 L -1.17 -.083 L -.886 -.252 L -.896 -.168 L -1.547 .173 L -.632 .328 L -.392 -.015 L -.433 -.031 L -.135 -.49 L -.333 .057 L -.112 .184 L .474 .731 L -.877 .64 L -.808 .577 L -.915 .317 L -.419 .043 L -.414 -.056 L -.728 -.111 L -.126 .198 L .437 .437 L -.239 .396 L -.327 .199 L -.631 .114 L -.737 .27 L -.268 .17 L .558 .352 L .111 .169 L -.659 .694 L -.154 .297 L -.012 .848 L .144 .636 L .271 .762 L .425 .903 L -.347 -.119 L -.816 -.377 L -.296 .001 L -.416 .116 L -.264 -.069 L -1.029 -.56 L -.921 -.32 L -.375 -.365 L -.336 -.592 L -.332 -.932 L -.078 -.467 L -.268 -.253 L -.657 -.576 L -.845 -1.042 L -.744 -1.227 L -.663 -1.029 L -.363 -.366 L -.412 -.252 L -.783 -.321 L -.475 -.082 L -.643 .018 L -.468 .201 L -.576 .541 L -.418 .413 L -.283 .37 L -.416 .158 L -.501 -.011 L -.337 -.069 L -1.104 -.503 L -1.092 -.659 L -.445 -.549 L -.318 -.847 L -.284 -.678 L -.179 -.226 L -.708 -.491 L -.837 -.519 L -.766 -.632 L -.631 -.662 L -.209 -.112 L -1.892 -.046 L -1.858 -.003 L -.096 .892 L -.213 .101 L -1.867 .011 L -.966 -.037 L -1.544 -.02 L -1.662 -.019 L -.338 -.055 L -3.516 -1.112 L -2.811 -.933 L -1.186 -.39 L -.267 -.154 L -.316 -.31 L -2.381 .084 L -2.367 .155 L -.34 .017 L h 49.818 152.776 m -.122 .086 L -.279 .03 L -.111 -.131 L -.177 -.005 L -.324 .051 L -.304 -.39 L -.071 -.263 L .339 -.01 L .299 -.253 L .188 .218 L .106 .294 L .223 .096 L .233 .279 L h 52.785 154.312 m -.155 -.081 L -.085 -.356 L -.461 -.321 L .095 -.229 L .143 -.058 L .366 .209 L .344 .055 L .616 .356 L -.005 .172 L -.294 .184 L -.563 .069 L h 111.683 77.224 m -.138 .415 L -.45 .067 L -.324 .113 L -.295 .247 L -.321 -.137 L -.185 -.21 L .087 -.443 L .086 -.443 L -.438 -.675 L -.463 -.319 L -.199 -.271 L -1.281 .055 L -.437 .098 L -.153 .161 L -.496 .097 L -.019 -.193 L -.034 -.432 L .212 -.272 L .184 -.212 L -.378 -.347 L -.641 -.438 L -.693 -.696 L -.723 -.317 L -.453 -.136 L .132 -.35 L -.569 -.592 L -.099 -.213 L .371 -.229 L -.068 -.122 L -.301 -.152 L -.445 -.076 L -.392 -.274 L -.237 -.259 L -.57 -.305 L -1 -.411 L -.479 -.765 L -.217 -.583 L -.367 -.399 L -.357 .016 L -.101 .814 L .42 .873 L .104 .306 L -.047 .153 L -.701 -.136 L -.272 -.076 L -.511 -.504 L -.4 -.459 L -.537 .139 L -1.219 -.228 L 1.263 .718 L .032 .214 L -1.62 .171 L -1.093 -.35 L -1.388 -.948 L -.543 -.292 L -.664 -.043 L -.079 0 L -.933 -.213 L -1.3 -.536 L .928 -.248 L .135 -.169 L 90.8 67.129 l -.384 -.153 L -.792 .156 L -.454 .14 L -.656 .017 L -1.058 -.06 L -1.068 -.245 L .027 -.247 L -.148 -.186 L -.325 -.108 L -.359 .016 L -.47 .202 L -1.036 .049 L -1.465 -.122 L 80.46 66.64 l -.786 -.091 L -.248 -.108 L -.651 -.387 L -.427 -.527 L -.301 .218 L -.788 .157 L -.89 -.293 L -.234 -.326 L -.417 -.139 L -.872 -.248 L -1.538 -.23 L -.817 -.248 L -.671 -.342 L -.553 .235 L -.675 .079 L .06 .437 L -.193 .062 L -.389 .25 L -.249 .405 L 1.119 .293 L .174 .294 L -.096 .388 L -.428 .449 L -.458 .001 L -.804 -.214 L -.586 -.061 L -.568 .094 L -.978 .603 L -1.066 .217 L -.936 .448 L -1.035 .448 L -1.095 .109 L .178 -.308 L .063 -.123 L .72 -.401 L -.093 -.385 L -.655 -.523 L .004 -.108 L 64.1 66.19 l .411 -.482 L .157 -.42 L .736 -.312 L .87 -.235 L 1.165 -.018 L 1.085 .123 L .239 -.156 L -1.239 -.466 L -.971 -.389 L -1.043 .049 L -.226 .219 L -.449 .095 L -.573 .438 L -.865 .375 L -1.019 .282 L 61.553 65.9 l -.406 .094 L -.298 .14 L .131 .325 L -.177 .526 L -.563 .34 L -.564 .078 L 59 67.544 l -.592 .278 L -.681 .601 L -.035 .292 L .38 .168 L .36 .03 L .667 .106 L .465 .229 L -.075 .184 L -.43 .338 L -.625 .2 L -.557 .277 L -.423 .398 L -.544 .383 L -.675 .093 L -1.434 .308 L -.678 .397 L -1.036 .337 L -.7 .367 L .52 .5 L -.1 .167 L -1.106 .412 L -.897 .153 L -.778 .168 L 49.51 74.19 l -1.214 .456 L 48.1 74.828 l -.274 .394 L -.753 .439 L -1.193 .229 L -1.234 .184 L -.973 -.345 L .001 -.181 L .332 -.348 L .763 -.273 L .306 -.212 L .445 -.364 L 1.171 -.441 L 1.403 .073 L -.12 -.212 L .02 -.516 L .47 -.304 L .725 -.291 L .754 -.366 L .266 -.214 L .002 -.731 L .246 -.749 L .693 -.49 L .194 -.398 L .034 -.412 L -.633 .122 L -1.251 .186 L -.676 -.029 L -.5 -.597 L -.266 .062 L -.613 .216 L -.136 .23 L .239 .352 L .021 .352 L -.169 .046 L 47 70.115 l -.567 -.32 L -.487 -.397 L -.509 -.291 L -.56 -.03 L -.812 -.106 L -.91 .094 L .028 .138 L -.644 .338 L -1.175 .14 L -.649 -.09 L -.064 -.123 L -.082 -.107 L -.125 -1.028 L .3 -.508 L -.142 -.431 L -.864 -1.002 L -1.43 .437 L -.738 .078 L -.406 .202 L -1.091 .094 L -.4 -.23 L -.394 -.355 L -.466 -.325 L -1.007 -.463 L -.179 -.28 L .292 -.171 L .337 -.437 L .704 .139 L 1.312 .309 L .69 .03 L .238 -.234 L -.375 -.482 L -.458 -.264 L -.363 0 L -.541 .22 L -.528 -.015 L -1.342 -.513 L -.623 -.186 L -.197 .016 L -.858 -.029 L -.024 -.078 L -.623 -.985 L .79 -.19 L .071 -.456 L .495 -.221 L .102 -.299 L .227 -.347 L .893 -.491 L .337 -.38 L .386 -.301 L .527 -.476 L .39 -.175 L .719 .109 L .98 .268 L .485 .094 L .752 -.144 L .427 -.254 L .675 -.429 L 1.252 -.257 L .774 -.033 L .955 -.049 L .354 -.175 L .187 -.478 L -.259 -.669 L -.814 -.686 L .026 -.096 L .927 -.034 L .343 -.256 L -.25 -.384 L -.497 -.256 L -.367 -.08 L -1.88 .389 L 39.33 56.53 l -.534 .289 L -.496 .065 L -1.907 -.333 L -.848 -.031 L 34.8 56.49 l -1.27 .162 L -1.265 -.029 L -1.349 -.174 L -.53 -.207 L -.183 -.788 L .144 -.146 L .636 -.033 L 1.008 -.002 L .446 -.179 L -1.057 -.241 L -1.912 -.304 L 28.13 54.31 l -1.285 -.208 L .219 -.114 L .781 -.262 L 1.568 -.214 L 1.325 -.328 L .958 -.214 L 1.058 -.361 L .953 -.23 L 1.399 -.281 L 1.513 .128 L -.158 .523 L .023 .277 L 1.051 .161 L 1.359 .095 L 1.074 -.019 L .657 -.099 L .784 -.246 L .55 -.295 L .262 -.083 L .752 .064 L .751 .113 L 1.021 -.051 L .2 -.327 L .007 -.18 L -.689 -.064 L -1.946 -.292 L -1.283 -.047 L -.312 -.755 L -1.473 -.162 L -.96 -.031 L -1.573 -.096 L -.194 -.511 L -.484 -.312 L -1.042 -.461 L -.512 -.148 L -2.66 -.659 L -2.008 -.545 L .317 -.167 L .812 -.402 L .086 -.485 L 2.136 -.054 L .99 -.069 L 1.829 -.288 L .784 -.354 L .452 -.623 L .788 -.575 L .616 -.525 L .818 -.41 L .742 -.224 L 1.066 -.104 L 1.133 -.241 L 1.047 -.036 L 1.804 .065 L .146 -.188 L -.156 -.205 L 44.47 42.83 l .018 -.206 L 1.936 -.089 L 1.143 .032 L .974 -.054 L 1.344 -.14 L 1.098 -.416 L .918 -.417 L .957 -.019 L .282 .051 L .675 .241 L .156 .172 L -.383 .139 L .017 .344 L 1.049 .136 L .424 .034 L .536 -.293 L .297 -.208 L 1.419 .187 L 1.534 .049 L 1.062 .049 L .715 .033 L .711 .257 L .359 .274 L .783 .358 L .494 .085 L .421 -.086 L 1.292 .117 L 1.124 .015 L 1.556 -.054 L 1.449 -.088 L 1.213 .1 L 1.377 .254 L .883 .118 L 3.424 .13 L 1.279 .168 L .743 .169 L 2.027 -.038 L 2.339 -.141 L 1.123 .236 L 2.441 .791 L 1.206 .301 L .227 .008 L .102 .483 L -.003 2.855 L .039 2.259 L .052 2.335 L .129 2.796 L -.026 2.183 L -.043 4.334 L .026 2.167 L .089 1.046 L .196 .279 L .84 .074 L 2.424 -.122 L .739 .059 L .332 .388 L .173 .387 L .348 .292 L 2.162 1.318 L .945 .673 L .238 -.325 L .848 -.205 L 1.225 -.67 L .731 -.498 L .495 -.126 L .832 .073 L .316 .199 L .371 .492 L .35 .322 L 2.048 1.175 L .814 .58 L 1.769 1.768 L 1.67 1.882 L .512 .393 L .189 .029 L .98 .314 L 2.025 .763 L .402 .255 L -.163 .788 L .393 .777 L
643.755 159.873 N -1.092 -.52 L -.637 -.337 L -.203 -1.284 L .036 -.282 L .24 -.241 L .42 -.241 L .721 -.623 L .493 .056 L .049 -.17 L .24 -.396 L .239 .028 L .573 .225 L .321 -.312 L .439 -.001 L .798 -.171 L .596 .69 L -.163 .17 L -.443 .354 L -.412 .538 L -.285 .734 L .14 .296 L -.22 .311 L -.292 .085 L -1.026 .383 L -.532 .707 L h 627.173 150.012 m -.679 .314 L -.24 .241 L -.043 .325 L .138 .592 L .228 .366 L .119 .521 L -.109 .339 L -.266 .213 L -.769 -.08 L -.321 -.21 L -.178 -.196 L -.153 -.239 L -.111 -.38 L -.628 .413 L -.647 .159 L -.246 -.083 L -.378 -.266 L -.341 -.746 L -.291 -.379 L -.481 .045 L -.507 .003 L -.228 -.098 L -.117 -.352 L .729 -1.584 L -.033 -.268 L -.521 -.096 L -.554 .074 L -.202 -.324 L -.277 -1.762 L -.156 -.126 L -.479 .017 L -.771 .089 L -.819 .442 L -.312 .086 L -.216 -.069 L 0 -.268 L .224 -.58 L -.163 -.705 L -.075 -.465 L .617 -.85 L .191 -.198 L .487 -.271 L .611 -.525 L .429 -.722 L .353 -.862 L -.02 -.875 L -.195 -1.649 L -.146 -.14 L -.504 .031 L -.287 -.041 L -.217 -.309 L -.243 -.901 L -.397 -.435 L -.504 -.279 L -.277 .044 L -.306 .34 L -.001 .127 L -.624 -.081 L -.73 -.179 L -.657 -.081 L -.3 -.055 L -.102 -.056 L .138 -.269 L .354 -.454 L -.046 -.38 L -.716 -.715 L -.455 -.392 L -1.377 .84 L -.377 .044 L -.975 -.319 L -.286 -.167 L -.355 .087 L -.546 .299 L -1.105 .726 L -.829 .258 L -.543 .37 L -1.123 1.107 L -.397 .27 L -.714 .216 L -.784 .033 L -.189 .1 L -.329 -.619 L -.312 -.209 L -.371 -.041 L -1.659 -.047 L 601 137.538 l -.309 -.294 L -.417 .016 L -.149 .103 L -.348 .239 L -.609 .539 L -1.251 1.545 L -.212 -.662 L .052 -.861 L -.139 -.183 L -.231 -.069 L -.471 .102 L -.345 .129 L -.655 -.159 L -.339 .281 L -.341 -.116 L -.849 .066 L -.319 -.364 L -.63 -.281 L -.407 0 L -.08 .331 L -.271 .083 L -.685 -.38 L .01 .364 L -.237 .099 L -.141 -.463 L -.54 -.496 L -.365 .066 L -.935 -.066 L -.014 -.265 L .175 -.396 L -.326 -.017 L -.333 .248 L -1.451 -.893 L .069 -.281 L -.178 -.38 L -.289 -.166 L -.71 .116 L -.158 .166 L -.657 -.794 L -.454 -.281 L -.15 .132 L -.472 -.215 L -.726 -.595 L -.867 -.264 L -.132 -.612 L -1.079 -.199 L -.186 .182 L -.275 -.066 L -.134 .513 L -.276 .314 L -.299 -.05 L -.24 -.43 L -.859 -.596 L -.154 .066 L -.756 -.248 L .116 -.364 L -1.078 -.579 L -.363 .116 L -.772 -.843 L -.383 -.248 L -.477 .314 L -.198 -.066 L -.099 -.43 L .215 -.215 L -.272 -.364 L .104 -.446 L -.579 -.595 L -.157 -.694 L .785 -.198 L .033 .364 L .337 .264 L .368 -.049 L .376 -.281 L .578 -.364 L -.367 -.694 L .104 -.414 L -.68 -.099 L -.044 -.182 L -.092 -.078 L -.718 -.096 L -.294 -.221 L -.037 -.552 L -.073 -.589 L .184 -.184 L .331 -.221 L -.221 -.258 L -.441 -.405 L -.81 -.11 L -.221 -.515 L -.441 -1.03 L 0 -.515 L -.502 .152 L -.147 -.126 L -.305 -.111 L -1.337 -.104 L -.565 -.436 L -.178 -.09 L -.104 -.199 L -.239 0 L -.52 .196 L -.252 -.281 L -.198 -.218 L -.301 -.07 L .312 -.516 L -.007 -.501 L -.213 -.247 L -.373 -.323 L -.625 .009 L -.282 .128 L -.004 -.456 L -.554 -.117 L -.296 -.047 L -.281 .21 L -.105 -.112 L -.313 -.14 L -.048 -.088 L -.236 -.012 L -.01 -.269 L .574 .059 L .192 -.145 L .354 -.136 L .08 -.249 L .181 -.185 L -.2 -.163 L .152 -.36 L -.245 -.237 L .126 -.428 L -.049 -.123 L -.152 -.012 L -.028 -.246 L .009 -.284 L -.295 -.494 L -.273 -.154 L -.692 -.039 L -.22 -.06 L -.229 .162 L -.463 .045 L -.325 -.394 L -.077 -.305 L .207 -.223 L -.023 -1.031 L .011 -.069 L .139 -.739 L .129 -.213 L .274 -.186 L 1.422 -.704 L 1.737 -.734 L .359 -.03 L .06 .071 L .183 .567 L .344 .055 L .507 -.145 L .885 -.132 L .268 -.243 L .463 -.784 L .467 -.472 L .238 -.03 L 1.248 .235 L .459 -.017 L .478 -.102 L .646 -.345 L .638 -.701 L .405 -.301 L .445 -.145 L 1.338 -.349 L .97 -.219 L .325 -.187 L .051 -.157 L -.031 -.194 L -.139 -.86 L .02 -.399 L .32 -.401 L .705 -.546 L .222 -.33 L -.119 -.47 L -.29 -.441 L -.345 -.627 L -.03 -1.357 L -.483 -.141 L -.366 .06 L -.232 -.185 L .068 -.215 L .215 -.302 L .393 -.188 L 1.799 -.254 L 1.082 -.207 L .35 -.06 L .5 .184 L 1.133 .238 L .394 -.074 L .231 -.145 L .156 -.245 L -.126 -.286 L -.622 -.514 L .137 -.418 L .286 -.605 L .438 -.794 L .516 -1.141 L .427 -.507 L 1.096 .254 L .721 .141 L .594 .141 L 1.402 .079 L .718 -.062 L .417 -.103 L .444 -.392 L .157 -.39 L -.213 -.707 L -.097 -.75 L .34 -.581 L .428 -.277 L 1.199 -.093 L .289 -.06 L .306 -.219 L .035 -.478 L .011 -.275 L .279 -.262 L .542 -.148 L .551 -.034 L .228 -.014 L .569 -.003 L .244 -.074 L .062 .145 L .131 .405 L .24 .563 L .371 .433 L 1.301 .745 L .834 .415 L .614 .069 L .731 .167 L .633 .144 L .354 .143 L .568 .618 L 1.07 1.451 L .401 .66 L -.215 .447 L -.237 .75 L -.214 .389 L -.369 .347 L -.035 .129 L .105 .43 L .233 .229 L .724 .312 L 1.062 .181 L 1.505 .021 L .995 .038 L .668 .083 L .998 .224 L .632 .268 L 1.645 .806 L .839 .31 L .744 .096 L .105 .542 L 1.571 2.161 L .467 .439 L .444 .254 L 1.979 .018 L 1.241 .207 L .802 .109 L 1.165 .022 L 2.861 -.059 L .937 .023 L 1.164 .022 L 1.69 .119 L .521 .168 L .815 .551 L 1.006 .365 L 1.599 .433 L .929 .123 L .663 -.061 L .61 .067 L .253 .297 L .433 .197 L .481 -.017 L .686 -.289 L 1.44 -.534 L .303 -.101 L .736 -.274 L .816 -.289 L 1.204 -.349 L 1.339 -.007 L 1.514 -.065 L .987 .08 L .651 -.061 L 1.941 -.737 L .265 -.172 L 1.111 -1.046 L .67 -.389 L 1.265 -.292 L .326 -.259 L .123 -.271 L -.188 -.228 L -.599 -.411 L -.389 -.569 L -.003 -.343 L .214 -.401 L .539 -.589 L .457 -.231 L .316 -.073 L .718 .154 L .668 .382 L .592 .125 L .982 -.005 L .744 -.047 L .742 -.433 L 1.192 -.91 L .224 .013 L .438 .012 L .624 .054 L .896 -.134 L .638 -.248 L .347 -.188 L .241 -.216 L .312 -.82 L .363 -.333 L .47 -.204 L .464 -.045 L .483 .127 L .353 -.189 L .831 -.278 L .539 -.146 L .937 -.221 L .854 -.033 L .432 .099 L 1.074 .008 L .464 .127 L .414 -.218 L .107 -.217 L -.048 -.273 L -.599 -.501 L -.879 -.99 L -.797 -.5 L -.538 -.199 L -.928 -.212 L -.438 .002 L -1.191 .786 L -.292 -.07 L -.431 -.416 L -.317 -.085 L -.576 .018 L -.754 .062 L -.929 .395 L -.342 .045 L -.051 -.029 L -.269 -.836 L .381 -.58 L 1.224 -1.959 L .687 -1.207 L .295 -.31 L .046 .018 L .452 .172 L 1.126 .574 L .343 -.016 L .438 -.089 L 2.44 -.752 L .779 -.339 L .123 -.233 L -.056 -.306 L -.35 -.348 L -.062 -.146 L .103 -.249 L .422 -.426 L .416 -.543 L .667 -.779 L .599 -.545 L 1.371 -.608 L .167 -.794 L -.107 -.249 L -.465 -.306 L -.558 -.026 L -.822 .078 L .119 -.25 L .375 -.282 L 1.193 -.787 L .478 -.165 L .602 -.136 L 1.854 -.143 L .836 -.123 L 1.203 -.109 L .917 -.049 L 1.148 .215 L 1.037 .481 L .683 .188 L 1.386 -.125 L .539 .026 L .763 .467 L .742 .952 L 1.087 2.384 L .94 1.588 L .927 1.903 L .436 .389 L .507 .2 L 1.247 .341 L 1.523 .253 L 2.659 .839 L .205 .144 L .297 .866 L .44 1.283 L .261 .446 L .68 -.033 L .649 -.018 L 1.657 -.052 L .604 -.22 L .953 -.308 L 1.357 -.31 L 1.181 -.208 L .902 -.034 L .246 .114 L .064 .259 L .116 .389 L .017 .504 L -.566 .407 L -.66 .393 L -.291 .707 L -.278 .893 L -.538 1.066 L -.627 1.08 L -.329 .432 L -.551 .69 L -.47 .347 L -.547 -.098 L -.679 -.225 L -.685 -.24 L -.396 -.041 L -1.664 .982 L -.048 .557 L .332 .897 L .062 .656 L -.006 .613 L -.025 .385 L -.097 .128 L .112 .299 L -.156 .329 L -.511 .43 L -1.252 .462 L -.111 .058 L -.579 -.68 L -.247 .001 L -.253 .129 L -.383 .358 L -.23 .713 L -.955 .532 L -.62 .259 L -.538 .017 L -.452 -.054 L -.333 -.126 L -.392 .059 L -.273 .243 L -.025 .342 L .508 .765 L .046 .113 L -.527 .159 L -.975 .048 L -.508 -.153 L -.493 -.253 L -.273 -.396 L -.448 .017 L -.386 .13 L -.686 1.027 L -.636 .543 L -1.032 .545 L -1.533 .604 L -.52 .329 L -.415 .442 L -.379 .528 L -.066 -.092 L -.417 .171 L -1.222 .13 L -.728 .171 L -2.248 .925 L -.632 .37 L -.566 .469 L -.604 .271 L -.336 .015 L .13 -.255 L .862 -.682 L .33 -.354 L -.47 -.113 L -.37 .072 L -.153 -.297 L .058 -.156 L .953 -.781 L .269 -.384 L .55 -.413 L .159 -.2 L -.057 -.298 L -.73 -.553 L -.727 -.283 L -.131 -.014 L -.628 .03 L -.166 .015 L -.494 .371 L -1.146 1.183 L -.355 .157 L -.643 .086 L -.613 .243 L -.36 .199 L 665.49 112 l -.136 .411 L -.131 .255 L -.251 .255 L -.437 .128 L -.493 -.013 L -.326 .27 L -.307 .114 L -.455 -.565 L -.355 -.014 L -.349 .128 L -.396 .638 L -.301 .694 L .088 .34 L .245 .368 L .558 .268 L .8 .268 L 1.21 -.045 L .29 .254 L -.019 .538 L -.123 .581 L .057 .538 L .261 .283 L .733 .069 L .698 -.157 L .76 -.525 L .509 -.497 L .552 -.228 L .534 -.128 L .287 .07 L .895 .621 L .543 .197 L 1.023 -.087 L .361 .027 L .471 .141 L .274 0 L -.248 .708 L -.057 .552 L -.612 -.197 L -.297 -.084 L -.525 .058 L -1.677 .555 L -.707 .44 L -.072 .735 L -.522 .157 L -.146 -.113 L -.017 -.269 L -.127 -.084 L -.501 .114 L .138 .466 L -.152 .368 L -.485 .496 L -1.397 1.119 L -.126 .226 L .039 .55 L .62 .225 L .712 .492 L .785 .521 L .391 .535 L .424 1.241 L .668 .647 L .175 .437 L -.13 .677 L .172 .183 L .694 .295 L .399 .592 L .562 .253 L .272 .268 L .087 .31 L -.049 .155 L -.789 .369 L .088 .07 L .425 .31 L .314 .79 L -.019 .296 L -.141 .184 L -.534 .043 L -.651 .213 L -.948 .552 L -.849 .213 L -.629 .297 L .72 .21 L .378 .056 L .944 -.425 L .488 -.058 L .162 .056 L .524 .592 L .387 .168 L .456 .027 L .009 .155 L -.231 .311 L -.382 .227 L -.304 .241 L .11 .155 L .326 -.029 L .202 .084 L -.184 .325 L -.298 .749 L -.192 .649 L .028 .353 L -.22 .452 L -.209 .127 L -.35 -.338 L -.146 .142 L -.569 .763 L -.401 .622 L -.215 .622 L -.127 .296 L -.595 .425 L -.251 .438 L -.254 .184 L -.569 .029 L -.382 .227 L .279 .719 L -.264 .508 L .076 .593 L -.093 .269 L -.207 .269 L -.532 .199 L -.161 .282 L -.174 .396 L -.294 .636 L -.626 .354 L -.412 .495 L -.492 -.14 L -.443 -.069 L -.142 .113 L -.145 .198 L .118 .833 L -.213 .142 L -.772 .651 L -.356 .127 L -.628 .171 L -.563 .467 L -.571 .213 L -.107 .113 L -.008 .48 L -.133 .156 L -.568 .058 L -.5 .114 L -.341 .438 L -.364 -.126 L -.52 -.168 L -.274 .057 L -.315 .326 L -.435 .198 L -.643 .1 L -.047 -.465 L -.52 .057 L -.699 .213 L -.32 .198 L -.285 -.042 L -.401 -.493 L -.163 -.155 L -.191 .283 L .095 .169 L -.045 .212 L -.047 .691 L -.209 .297 L -.416 .114 L -.501 -.182 L -.123 .282 L -.001 .24 L -.146 .155 L -.615 .058 L -.366 .114 L -.596 .043 L -.463 -.211 L -.217 .1 L -.439 .48 L -.227 .071 L -.774 -.041 L -.747 .227 L -.406 .326 L -.451 -.027 L -.277 -.084 L -.011 .057 L -.069 .353 L -.29 .396 L .011 .113 L .48 .634 L .269 .126 L .043 .198 L -.36 .269 L -.763 .157 L -.481 -.719 L -.241 -.691 L .012 -.395 L .396 -.777 L -.015 -.169 L -.587 -.253 L -.226 .071 L -.206 .297 L -.454 .072 L -.676 -.21 L -.574 -.733 L -.196 .085 L -.017 .169 L -.159 .396 L -.27 .128 L -.332 -.056 L -.481 .043 L -.055 .038 L -.197 -.143 L -.909 -.107 L -.621 -.166 L -.943 -.615 L -.273 -.365 L -.096 -.521 L .472 -.75 L -.056 -.38 L -.237 -.21 L -.777 .047 L -.66 -.053 L -.771 -.235 L -.623 -.575 L -.298 .101 L -.521 .328 L -.696 .554 L -.341 .157 L -.807 .117 L -1.595 .052 L -.332 .115 L -.584 .413 L -.325 -.097 L -.597 -.392 L -.341 -.012 L -.515 .13 L -.483 .229 L
241.073 156.152 N .017 .52 L .098 1.215 L .012 .212 L -.379 .455 L -.011 .17 L .485 1.358 L -.669 -.577 L -.445 -.056 L -.761 .143 L -.877 -.012 L -.666 -.14 L -.574 -.056 L -.474 .1 L -.378 .354 L -.135 -.042 L -.993 -.549 L -.171 -.325 L .04 -.198 L .269 -.184 L 1.051 .097 L .631 .111 L 1.125 .167 L .654 .041 L .61 -.185 L .386 -.156 L -.198 -.155 L -.692 -.464 L -.136 -.296 L .184 -.707 L -.202 -.296 L -.394 -.154 L -.913 -.14 L -.305 -.211 L .04 -.184 L .119 -.085 L .344 -.1 L .724 -.058 L .781 .125 L 1.081 .294 L .576 .056 L .147 -.089 L
241.295 160.082 N -.485 -1.358 L .011 -.17 L .379 -.455 L -.012 -.212 L -.098 -1.215 L -.017 -.52 L .503 -.279 L .393 .14 L .342 0 L .384 -.17 L .369 -.043 L .14 .198 L .177 .112 L 1 .309 L .657 -.072 L .213 .395 L .335 .338 L .528 .324 L .335 .084 L .643 .21 L .916 .45 L .399 .352 L .231 .311 L -.191 .17 L -.144 .297 L -.314 .368 L -.238 -.098 L -.476 -.592 L -.378 -.042 L -.788 .058 L -.288 -.098 L -.373 0 L -.329 .1 L -.763 .539 L -.396 -.056 L -.319 -.494 L -.166 -.028 L -.155 .057 L -.658 .326 L -.344 .778 L -.41 .65 L -.289 -.112 L -.325 -.551 L
668.053 167.796 N -.131 -.099 L -.74 -.732 L -.444 -1.255 L .037 -.424 L .054 -.706 L -.292 -.465 L .18 -.382 L .978 .704 L .202 -.424 L .023 -.41 L -.101 -.438 L -.026 -.579 L .145 -.438 L .025 -.664 L .082 -.861 L .074 -.636 L .38 -.862 L .188 -.127 L .337 -.142 L .523 .055 L 1.21 .52 L .576 .042 L .188 -.212 L .277 -.17 L .199 .141 L .018 .396 L -.266 .438 L -.045 .48 L .14 .79 L .541 .394 L .182 .325 L -.427 1.271 L -.31 .467 L -.834 .608 L -.555 .312 L -.082 .099 L .003 .268 L -.078 .565 L -.28 .424 L .127 .211 L .35 .733 L .345 1.101 L .26 .62 L .093 .028 L .451 .324 L .296 .07 L .161 -.325 L .485 -.537 L .197 -.029 L .418 .112 L .226 .211 L .179 .635 L .286 .353 L .326 .084 L .505 -.58 L .621 .267 L .141 .028 L .078 .127 L -.168 .156 L -.378 .156 L -.208 .212 L .936 1.226 L -.315 .184 L -.568 -.196 L -.404 -.098 L -.094 -.48 L -.229 -.31 L -.599 -.535 L -.753 -.577 L -.258 0 L -.099 .226 L .371 .776 L -.218 .283 L -.727 -.775 L -.982 -.548 L -.309 .015 L -.344 .142 L -.182 .255 L -.14 .071 L -.395 .057 L -.322 -.225 L -.591 -.366 L -.195 -.423 L .64 -.608 L .323 .211 L .358 .084 L .4 -.199 L -.151 -.169 L -.713 -.295 L -.422 -.395 L -.522 -.168 L -.239 .607 L h 669.676 172.974 m -.452 -.366 L -.349 -.408 L -.051 -.226 L -.364 -1.114 L -.459 -.521 L .685 -.058 L .868 .012 L .314 .169 L .274 .451 L .028 .861 L -.097 .48 L -.214 .283 L -.185 .438 L h 679.073 175.368 m -.562 -.267 L -.178 -.254 L -.237 -.169 L -.064 -.127 L .139 -.339 L -.091 -.423 L -.55 -.352 L -.662 -.479 L -.147 -.466 L .513 -.1 L 1.017 -.143 L .371 .112 L .283 .409 L .069 .818 L .123 .805 L .257 .79 L -.112 .127 L -.167 .057 L h 671.406 176.824 m .022 -.353 L .186 -1.342 L .061 -1.172 L .482 .395 L .576 .281 L .366 .028 L .634 -.185 L .027 .438 L -.079 .396 L -.24 .269 L -.184 .198 L -.908 .651 L -.943 .397 L h 664.721 177.812 m -.366 -.027 L .127 -.297 L .202 -.099 L .314 -.396 L .265 -.523 L .082 -.607 L .138 -.509 L .326 -.184 L .14 .183 L -.16 .283 L .276 .55 L .212 .564 L -.108 .113 L -.664 .354 L -.406 .368 L -.377 .227 L h 673.781 179.981 m -.385 -.366 L -.828 -.591 L -.206 -.38 L .099 -.368 L .565 -.213 L .22 -.269 L .487 -1.822 L .438 -.185 L .271 .028 L .113 .126 L .049 .282 L -.373 .905 L -.089 .226 L -.315 1.413 L .165 .296 L .214 .465 L -.213 .41 L -.212 .043 L h 661.179 181.308 m -.317 -.042 L .215 -.48 L .343 -.467 L .35 -.34 L .592 -.354 L .636 -.496 L .933 -1.089 L .11 .55 L -.118 .424 L -.267 .297 L -.24 .184 L -.516 .213 L -.172 .127 L -.244 .622 L -.327 .269 L -.591 .171 L -.386 .41 L h 680.678 185.402 m -.201 -.098 L -.098 -.438 L -.361 -.748 L -.297 -.112 L -.381 .608 L -.361 .82 L .246 .38 L .166 .395 L .148 .677 L -.158 .495 L -.383 .509 L -.305 -.253 L -.176 -.268 L .201 -.41 L -.076 -.325 L -.363 -.07 L -.361 .665 L -.173 -.056 L -1.114 -.619 L -.557 -.549 L -.206 -.508 L -.037 -.635 L .466 -.905 L -.108 -.479 L -.466 -.409 L -.778 -.295 L -.292 .043 L -.062 .17 L -.129 .226 L -.5 .255 L -.661 .058 L -.027 -.494 L -.174 -.24 L -.399 .199 L -.504 .961 L -.525 .863 L -.219 -.084 L -.119 -.127 L -.034 -.197 L .054 -.311 L .359 -.749 L .185 -.537 L .263 -.283 L .383 -.184 L .564 -.044 L .219 -.127 L .134 -.466 L .205 -.156 L .549 -.241 L .777 -.101 L .292 .353 L .102 .72 L .317 -.156 L .485 -.058 L .207 -.184 L .207 -.565 L .358 -.255 L .479 .21 L .186 .084 L .158 -1.087 L .29 -.015 L .264 .465 L .315 -.481 L .205 -.142 L .392 .098 L .133 -.227 L -.048 -.706 L -.172 -.564 L .146 -.353 L .413 .549 L .711 .803 L .229 .48 L .083 .324 L -.336 .735 L .237 .226 L .537 -.1 L .076 .423 L -.114 .424 L .056 .692 L .207 .437 L -.002 .438 L -.111 .424 L -.283 .579 L -.332 .622 L
251.898 160.229 N -.547 -.112 L -.073 -.212 L .051 -.551 L -.109 -.24 L .11 -.17 L .235 -.071 L .543 .069 L .404 -.015 L 1.505 .11 L .393 .168 L .113 .141 L -.188 .354 L -.07 .099 L -.283 .227 L -.335 .043 L -.739 -.083 L -.657 .072 L -.354 .17 L
228.82 160.519 N -.299 -.056 L -.693 -.224 L -.229 -.268 L -.47 -.366 L -.465 -.084 L -.142 -.211 L .53 -.284 L .704 -.072 L 1.364 .251 L .97 .351 L .651 .267 L .279 .282 L -.04 .198 L -.332 .071 L -.751 -.295 L -.543 .058 L -.227 .255 L -.308 .128 L
400.72 175.499 N -.595 -.119 L -.161 -.032 L -.976 .458 L -1.429 -.006 L -.867 -.037 L -2.119 .041 L -.271 .157 L -.125 .34 L .261 1.934 L .02 .41 L -.191 .17 L -.63 -.434 L -.644 -.166 L -.769 .075 L -.608 .159 L -.446 .257 L -.368 .115 L -.354 -.083 L -.452 -.223 L -.52 -.562 L -.15 -.465 L -.308 -.252 L -.545 .003 L -.259 -.168 L .08 -.043 L .046 -.156 L .172 -.326 L .261 -.92 L .133 -.876 L -.058 -.749 L .141 -.255 L .257 -.016 L .448 -.158 L .543 -.271 L .317 -.369 L .292 -1.047 L .355 -1.217 L .397 -.384 L .273 -.058 L .293 .281 L .551 .364 L .45 -.102 L .174 -.227 L .393 -.822 L .492 -.667 L .638 -.625 L .272 -.101 L .518 .209 L .324 .182 L .274 .027 L .314 -.793 L .304 -.228 L .947 -.458 L 1.22 -.713 L .37 -.073 L .356 .125 L .36 .059 L 1.062 .173 L -.173 .665 L .019 .396 L .426 .93 L .422 .492 L .389 .266 L .502 .42 L .179 .268 L .018 .212 L -.335 .439 L .114 .226 L .97 .757 L .516 .181 L .37 -.044 L .562 .025 L .568 .971 L .131 .367 L -.237 .764 L -.415 .468 L -.337 .158 L -.739 -.095 L -.418 .045 L -.415 .271 L -.366 .553 L -.24 .157 L -.062 .142 L -.29 -.041 L -.611 -.166 L -1.013 -.163 L
209.823 175.47 N -.388 -.645 L -.932 -.888 L -1.003 -1.085 L -.837 -.817 L -.723 -.464 L -.196 -.183 L -.023 -.226 L .625 -.03 L 1.001 -.125 L .29 -.143 L .293 -.412 L .005 -.961 L .882 -.034 L .513 -.583 L .725 .42 L 1.207 -.997 L .503 -.794 L .294 -.242 L .259 .013 L .328 .182 L .463 .097 L .248 -.086 L .424 -.229 L 1.425 -.486 L .23 .519 L .038 .339 L -.057 .509 L -.214 .707 L -.543 .806 L -.1 .749 L .042 .904 L -.245 1.13 L -.188 .735 L -.101 1.385 L .031 .55 L .184 .466 L .188 .363 L -.281 .274 L -.767 -.149 L -.241 -.46 L -.285 .077 L -.394 -.107 L -.603 .25 L -1.651 -.599 L -.43 .271 L
634.036 168.444 N .533 .251 L .736 .165 L .341 .111 L .469 .251 L .248 -.058 L .095 -.24 L -.103 -.211 L -.187 -.182 L -.107 -.296 L .392 -.285 L .476 -.186 L .444 .181 L .373 .351 L .3 -.072 L .975 -.429 L .209 -.114 L -.215 .905 L .029 .663 L .455 1.014 L -.076 .367 L -.05 .424 L .054 1.073 L -.217 .509 L -.385 .285 L -.599 .187 L -.932 .443 L -.521 .229 L -.99 .571 L -.234 .425 L .216 .422 L .568 .435 L .03 .197 L -.17 .27 L -.688 -.194 L -.497 -.011 L -.599 .229 L -.915 .528 L -.646 .229 L -.3 .289 L -.256 -.188 L -.248 -.268 L -.35 -.042 L -.382 .142 L -.205 -.042 L -.293 .043 L -.183 -.113 L .142 -.311 L .182 -.226 L -.04 -.254 L -.283 -.395 L -.277 .043 L -.462 .298 L -.339 .015 L -.171 -1.044 L -.649 -1.488 L .146 -.176 L -.16 -.479 L -.487 -.717 L -.219 -.648 L -.026 -.635 L .076 -.382 L .146 -.297 L .92 -1.233 L .521 -.441 L .383 -.101 L 1.172 -.091 L .798 .066 L .558 -.074 L .575 .039 L .599 .109 L .301 .167 L
214.474 175.913 N .821 .884 L .385 .623 L .314 .322 L .225 .046 L .465 .645 L .441 .352 L -.014 .006 L -.074 .123 L -.478 -.184 L -.219 .205 L -.014 .321 L 0 .58 L .507 .307 L -.396 .368 L .125 .532 L -.374 .369 L .243 .184 L -.204 .609 L .003 -.466 L -.296 -.307 L .01 -.568 L -.377 -.148 L -.238 -.102 L -.111 .082 L .325 .41 L .084 .225 L -.113 .062 L -.726 -.299 L -.13 -.282 L .251 -.339 L .04 -.382 L -.182 -.338 L -.486 -.324 L -.695 -.287 L -.079 -.144 L -.689 -.103 L -.316 -.327 L .007 -.421 L -.146 -.255 L -.249 -.098 L -.576 -.353 L -.416 -.266 L .225 .512 L .086 .222 L .422 .044 L .181 .266 L -.544 .573 L -.144 -.262 L -.356 -.282 L -.561 -.211 L -.323 -.239 L -.147 -.24 L -.104 -.494 L .128 -.421 L .332 -.225 L -.008 -.389 L -.554 -.225 L .363 -.123 L -.057 -.227 L -.238 .017 L .43 -.271 L 1.651 .599 L .603 -.25 L .394 .107 L .285 -.077 L .241 .46 L .767 .149 L .281 -.274 L
436.304 195.359 N -.209 -.451 L -.194 -.804 L -.498 -.802 L -1.217 -1.236 L -.112 -.324 L -.064 -.791 L -.432 -.605 L -.4 -.661 L -.207 -.592 L -.273 -1.185 L -.112 -.776 L .064 -.424 L .144 -.198 L .528 -.399 L .4 -.511 L .866 -1.743 L .354 -.327 L .208 -.114 L .096 .084 L .24 .027 L .449 -.158 L 1.363 -.686 L .494 .661 L .225 .069 L .224 -.03 L .466 -.271 L .754 -.386 L .818 -.273 L .881 .009 L .368 -.031 L .258 -.143 L .646 -1.176 L .117 -.806 L .209 -.199 L .434 -.059 L 2.181 -.055 L .386 -.087 L 2.649 -2.275 L .196 -.284 L .005 -.41 L .165 -.382 L .372 -.228 L .939 -.613 L .322 -.086 L .321 .012 L .559 .208 L 1.342 1.673 L .347 .549 L .122 .536 L -.416 1.472 L .01 .664 L .158 .211 L .802 -.019 L .272 -.001 L .207 .126 L .252 .493 L .223 .225 L .797 .447 L .799 .235 L .351 .196 L .223 .267 L -.148 .481 L .173 .395 L .445 .351 L .558 .378 L .717 .434 L .207 .168 L .206 .366 L .059 .72 L .285 .436 L .367 .224 L .814 .165 L .558 .477 L .157 .352 L -.083 .679 L .031 .07 L -.496 .145 L -.962 .344 L -.319 -.026 L -.287 -.167 L -.687 -.264 L -1.15 -.361 L -.4 .13 L -.082 .551 L -.13 .241 L -.256 .058 L -.399 -.026 L -.862 -.207 L -.593 .102 L -.93 .373 L -.93 .486 L -.271 .016 L -.559 -.35 L -.383 -.153 L -.353 .186 L -.677 1.36 L -.176 .157 L -.591 -.067 L -1.934 -.511 L -1.422 -.189 L -.512 -.322 L -.159 -.239 L -.334 -.394 L -.75 -.518 L -.432 -.167 L -.479 .06 L -.529 .3 L -.353 .341 L -.785 .979 L -.097 .297 L .096 .452 L -.017 .353 L -.063 .594 L -.16 .058 L -.751 .287 L -.895 -.093 L -.624 -.138 L -.367 -.054 L -.975 .175 L -.479 .102 L -.255 .228 L -.222 1.287 L -.158 .523 L -.365 .497 L -.303 .312 L
371.324 180.419 N 1.088 -1.235 L .643 -.866 L .238 -.157 L .594 .039 L 1.137 -.148 L .466 .04 L .42 .224 L .456 .421 L .475 .619 L .252 .761 L .165 1.369 L .26 .656 L -.259 .502 L -1.184 1.151 L -.63 .724 L -.285 .256 L -.061 .103 L -.631 -.523 L -.661 -.408 L -.483 -.196 L -.033 -.141 L .061 -.297 L -.05 -.184 L -.531 -.21 L -.792 -.549 L -.389 -.366 L -.375 -.465 L .494 -.241 L .174 -.227 L -.034 -.155 L -.484 -.211 L -.065 -.113 L .022 -.173 L
579.606 186.906 N -.493 -.083 L -.265 -.197 L -.21 -.353 L -.246 -.621 L -.361 -1.256 L -.034 -.649 L .005 -.763 L -.02 -.904 L -.24 -.696 L .188 -.513 L -.298 -.35 L .068 -.28 L .423 .023 L .349 -.43 L .053 -.367 L .226 -.369 L -.152 -.537 L .529 .48 L .699 .38 L .234 .395 L .549 .776 L .175 .324 L -.099 .339 L .024 .141 L .592 .338 L .266 .733 L .798 1.368 L .136 .508 L -.193 .735 L -.397 .679 L -.369 .396 L -.514 .425 L -.78 .284 L -.642 .043 L
217.111 178.792 N .52 .307 L .195 .512 L .02 .374 L .363 .155 L .628 .024 L .244 -.205 L .398 .43 L .726 .082 L .458 -.083 L 1.348 -.751 L .514 -.046 L 1.387 -.921 L .373 .144 L .742 .069 L .071 .156 L .789 -.017 L .767 .21 L .666 .38 L .644 .563 L .406 .666 L .084 .327 L .228 .149 L .509 1.038 L -.322 .062 L -.094 .43 L -.584 .409 L -.085 -.307 L -.19 -.082 L .045 .45 L -.228 .082 L -.256 .753 L -.378 -.825 L -.441 -.762 L -.137 -.452 L .179 -.24 L .22 -.085 L .786 .125 L -.336 -.193 L -.125 -.164 L -.096 -.471 L -.309 .307 L -.439 .041 L -.244 -.378 L -.031 -.269 L -.193 -.282 L -.132 .151 L -.226 -.287 L -.11 .102 L -.132 -.266 L -.456 -.192 L -.562 -.013 L -.499 .241 L -.382 .108 L -.07 .359 L .081 .234 L -.529 .318 L -.374 .184 L -.335 .029 L -.345 .41 L .049 .296 L .316 .297 L .464 .43 L .178 .386 L -.011 .146 L -.281 .081 L -.243 -.042 L -.431 .391 L -.568 .105 L -.339 -.042 L -.189 -.146 L .108 -.164 L -.349 -.833 L -.244 -.353 L -.177 .674 L -.812 -.409 L -.227 -.757 L -.207 .041 L -.96 -.123 L -.434 -.266 L -.599 0 L -.314 .113 L -.361 .495 L .204 -.609 L -.243 -.184 L .374 -.369 L -.125 -.532 L .396 -.368 L -.507 -.307 L 0 -.58 L .014 -.321 L .219 -.205 L .478 .184 L .074 -.123 L
266.015 188.956 N -.503 -.647 L -.732 -.745 L -.324 -.521 L .071 -.212 L .395 -.539 L -.008 -.58 L .061 -.452 L 1.032 -.19 L .41 -.144 L .308 -.299 L -.141 -.282 L -.62 -.604 L -.074 -.212 L .101 -.255 L 1.655 -1.239 L .061 -.41 L -.095 -.296 L .072 .049 L .496 .338 L .856 .521 L .695 .521 L .587 .663 L .128 .409 L -.036 .734 L .148 .945 L .298 -.593 L .22 -.099 L .6 .182 L .101 .127 L .507 .295 L .708 .549 L .401 .493 L .374 .649 L -.015 .339 L -.142 .496 L -.082 .862 L -.183 .27 L -1.131 .091 L -.169 .17 L .078 .777 L -.095 .467 L -.328 .694 L .571 .831 L .532 .675 L .561 .067 L .185 .295 L .246 .832 L .49 1.127 L .332 .563 L -.06 .212 L -.943 -.022 L -.934 .429 L -1 .331 L -.505 .314 L -.694 .513 L -.686 .075 L -.613 -.392 L -1.103 -.897 L -.15 -.296 L -.008 -.396 L .072 -.354 L -.167 -.31 L -.281 -.394 L -.156 -.465 L .213 -.962 L .547 -1.416 L .179 -.368 L -.435 -.958 L -.533 -.138 L -.304 .001 L .452 -1.09 L -.04 -.212 L -.26 -.111 L -.516 -.124 L -.302 .058 L -.375 .257 L
377.518 182.142 N .193 -.376 L .252 -.242 L .367 -.143 L .528 -.046 L .338 .097 L .165 .366 L .22 .846 L .009 .65 L -.044 .283 L .277 .323 L .404 .322 L .321 .026 L .756 -.922 L .143 -.086 L .337 .097 L .339 .224 L -.062 .17 L .119 .55 L -.059 .438 L -.501 .865 L .05 .183 L .194 .183 L .369 .097 L .592 -.032 L 1.264 1.334 L .131 .282 L -.059 .452 L -.247 .849 L -.105 .565 L -.041 .919 L -1.513 -.643 L -1.221 -.619 L -1.012 -.562 L -.403 -.423 L -1.129 -1.113 L -1.111 -.76 L -.723 -.337 L -.901 -.535 L -.66 -.548 L .061 -.103 L .285 -.256 L .63 -.724 L 1.184 -1.151 L .259 -.502 L
429.505 210.684 N .484 .336 L .177 .013 L .443 -.271 L .327 -.581 L 1.495 -.532 L .054 .424 L .042 .664 L .147 .211 L .57 -.328 L .554 -.399 L .931 -.811 L .364 -.229 L 1.025 -.938 L .086 -.706 L -.122 -.72 L .074 -.396 L .193 -1.159 L .343 -.751 L .47 -.836 L .41 -.454 L .809 -.599 L .525 -.229 L .459 -.427 L .139 -.523 L .169 -.708 L .115 -.61 L .254 -1.342 L .196 -2.021 L .156 -.764 L .094 -.551 L .349 -.821 L .558 -.837 L .398 -1.203 L .031 -.156 L -.128 -.197 L .16 -.058 L .063 -.594 L .017 -.353 L -.096 -.452 L .097 -.297 L .785 -.979 L .353 -.341 L .529 -.3 L .479 -.06 L .432 .167 L .75 .518 L .334 .394 L .159 .239 L .512 .322 L 1.422 .189 L 1.934 .511 L .591 .067 L .176 -.157 L .677 -1.36 L .353 -.186 L .383 .153 L .559 .35 L .271 -.016 L .93 -.486 L .93 -.373 L .593 -.102 L .862 .207 L .399 .026 L .256 -.058 L .13 -.241 L .082 -.551 L .4 -.13 L 1.15 .361 L .687 .264 L .287 .167 L .319 .026 L .962 -.344 L .496 -.145 L .143 .239 L .795 .772 L .348 .493 L .525 .477 L .366 .195 L .352 -.016 L .258 -.242 L .529 -.37 L .384 .012 L .684 .631 L .16 -.1 L .436 -.582 L .258 -.157 L .207 .083 L 1.032 .926 L 1.288 1.32 L .063 .028 L .159 .183 L -.018 .424 L -.26 1.88 L .128 .253 L .191 .027 L .479 .04 L .271 .182 L .111 .31 L -.191 .453 L -1.195 1.066 L -1.241 .996 L -.255 .284 L -.395 .681 L -.217 1.02 L -.107 .507 L .021 .593 L -.025 .734 L .057 .748 L -.076 .27 L -.188 .298 L -.426 .412 L -.301 .171 L -.269 .256 L -.122 .425 L -.49 1.358 L .197 .338 L .689 .999 L .087 .381 L -.04 .438 L .014 .636 L .237 .634 L .017 1.329 L -.064 .762 L .425 1.439 L -.102 .848 L .122 .693 L .486 .631 L .936 .898 L .428 .78 L .689 1.804 L -.563 .068 L -3.015 .499 L -.347 .214 L -.154 .198 L -.797 1.276 L -.029 .622 L .372 2.088 L -.377 1.175 L -.3 1.02 L .043 .296 L .456 .605 L .837 .843 L .445 .279 L .515 .012 L .448 -.455 L .362 -.186 L .136 .183 L .032 .791 L .028 1.427 L -.041 .551 L -.371 -.012 L -1.355 -.091 L -.348 -.21 L -.381 -.647 L -.561 -.731 L -.416 -.351 L -.477 -.252 L -.895 -.263 L -.38 -.28 L -.728 -1.423 L -.212 .354 L -.522 .682 L -.366 .087 L -.325 -.111 L -.922 -.164 L -.925 -.249 L -.489 -.194 L -.58 -1.014 L -.175 .071 L -1.146 .289 L -.195 -.056 L -.172 -.352 L -.365 -.379 L -.678 -.096 L -1.24 -.147 L -.991 .146 L -.859 .26 L -.61 .004 L -.199 -.197 L -.007 -.254 L .198 -.905 L .003 -.466 L -.306 -.62 L -.844 -.998 L -.117 -.211 L -.021 -.212 L .296 -1.033 L .07 -1.06 L -.109 -.607 L -.303 -.605 L .057 -.354 L .177 -.693 L -.052 -.183 L -.322 -.098 L -1.231 .093 L -.88 .019 L -.212 -.168 L .055 -.48 L -.181 -.225 L -2.016 .082 L -.112 .001 L -.089 .354 L .027 .593 L -.286 .892 L -.184 .411 L -.993 .006 L -.899 -.122 L -1.021 .246 L -.88 .034 L -.292 -.168 L -.64 -.787 L -.597 -1.07 L -.537 -1.409 L -.059 -.579 L -.121 -.521 L -.082 -.127 L -.321 -.111 L -.385 -.012 L -1.104 -.008 L -.88 .034 L -.624 .003 L -1.312 -.048 L -.945 -.052 L -.783 .02 L -.432 .03 L -.318 .101 L -.896 .062 L -.699 .314 L -.56 .06 L -.112 -.013 L -.322 -.922 L .012 -.053 L .74 -.3 L -.017 -.085 L .1 -.89 L .094 -.143 L .317 -.199 L .583 -.568 L
468.568 202.653 N 1.277 -.05 L 4.659 0 L 1.448 -.033 L 4.663 2.568 L 3.553 1.984 L .137 .381 L -.116 .552 L .07 .239 L 2.427 1.752 L 1.067 .807 L -.237 .427 L -.419 1.329 L -.137 1.017 L .109 .551 L .665 .987 L .768 .577 L -.024 .282 L -.263 .354 L -.371 1.046 L .037 .17 L .306 .041 L .118 .226 L -.172 .692 L -.019 .946 L .411 1.793 L .18 .564 L .401 .465 L .823 .55 L .396 .268 L .177 .228 L -1.157 .836 L -.515 .342 L -1.218 .402 L -1.243 .559 L -.448 .031 L -.646 -.42 L -.276 -.083 L -.21 .326 L -.543 .766 L -.396 .144 L -.42 -.054 L -.964 .006 L -.963 .02 L -.512 -.294 L -.323 -.394 L -.229 -.083 L -.123 .128 L -.643 .356 L -.526 .088 L -1.019 -.149 L -.898 -.018 L -.196 -.559 L -.135 -.766 L -.053 -.584 L -.135 -.946 L -.448 -.841 L -.663 -.538 L -1.014 -.107 L -.223 .016 L -.385 -.407 L -.732 -.349 L -1.574 -.57 L -1.269 -.6 L -.729 -.265 L -.263 -.21 L -.703 -.641 L -.689 -1.804 L -.428 -.78 L -.936 -.898 L -.486 -.631 L -.122 -.693 L .102 -.848 L -.425 -1.439 L .064 -.762 L 1.252 -.348 L .388 -.539 L .645 -1.204 L .687 -.853 L .346 -.271 L .044 -.212 L -.148 -.239 L -.273 -.125 L -.401 -.068 L -.211 -.211 L .158 -.976 L .304 -.016 L .396 -.158 L .142 -.17 L .104 -.481 L -.167 -.493 L -.364 -.888 L -.121 -.748 L
464.786 206.235 N -.197 -.338 L .49 -1.358 L .122 -.425 L .269 -.256 L .301 -.171 L .426 -.412 L .064 .042 L .546 .223 L .431 -.045 L .458 -.427 L .554 -.398 L .319 -.017 L .121 .748 L .364 .888 L .167 .493 L -.104 .481 L -.142 .17 L -.396 .158 L -.304 .016 L -.559 .031 L -.508 .159 L -.391 .567 L -.158 .085 L -.396 .13 L -.789 -.32 L -.688 -.024 L
465.79 210.652 N -.017 -1.329 L -.237 -.634 L -.014 -.636 L .04 -.438 L -.087 -.381 L -.689 -.999 L .688 .024 L .789 .32 L .396 -.13 L .158 -.085 L .391 -.567 L .508 -.159 L .559 -.031 L -.158 .976 L .211 .211 L .401 .068 L .273 .125 L .148 .239 L -.044 .212 L -.346 .271 L -.687 .853 L -.645 1.204 L -.388 .539 L -1.252 .348 L
427.243 211.207 N .536 -.414 L .68 -.513 L .351 -.13 L .695 .533 L -.583 .568 L -.317 .199 L -.094 .143 L -.1 .89 L .017 .085 L -.74 .3 L .143 -.625 L -.082 -.24 L -.505 -.796 L h 427.998 213.843 m .112 .013 L .56 -.06 L .699 -.314 L .896 -.062 L .318 -.101 L .432 -.03 L .783 -.02 L .945 .052 L 1.312 .048 L .624 -.003 L .88 -.034 L 1.104 .008 L .385 .012 L .321 .111 L .082 .127 L .121 .521 L .059 .579 L .537 1.409 L .597 1.07 L .64 .787 L .292 .168 L .88 -.034 L 1.021 -.246 L .899 .122 L .993 -.006 L .184 -.411 L .286 -.892 L -.027 -.593 L .089 -.354 L .112 -.001 L 2.016 -.082 L .181 .225 L -.055 .48 L .212 .168 L .88 -.019 L 1.231 -.093 L .322 .098 L .052 .183 L -.177 .693 L -.057 .354 L .303 .605 L .109 .607 L -.07 1.06 L -.296 1.033 L .021 .212 L .117 .211 L .844 .998 L .306 .62 L -.003 .466 L -.198 .905 L .007 .254 L .199 .197 L .61 -.004 L .859 -.26 L .991 -.146 L 1.24 .147 L -.214 1.344 L .195 1.059 L .269 .323 L .089 .254 L -.132 .368 L -.436 .44 L -.124 .594 L -.125 .086 L -.517 -.04 L -3.408 .091 L -.051 .877 L .015 1.342 L -.024 3.249 L .017 .848 L .023 .594 L .099 .438 L .308 .394 L .471 .436 L 1.354 1.391 L .611 .632 L -.93 .218 L -1.96 .379 L -1.044 .203 L -.717 -.08 L -1.164 .063 L -.408 -.083 L -.349 -.21 L -2.024 .026 L -.697 -.024 L -.622 -.151 L -.401 -.322 L -.305 -.366 L -.408 -.096 L -.989 -.023 L -2.59 .016 L -1.636 -.019 L -.631 -.011 L -1.296 -.006 L -2.201 .013 L -.636 -.151 L -.463 -.309 L -.45 -.478 L -.294 -.083 L -.499 .088 L -.591 .286 L -.778 .513 L -.758 -.462 L -.352 .144 L -.248 .197 L .048 -1.809 L -.017 -.805 L -.029 -.649 L .397 -.34 L .221 -.269 L .26 -.707 L .163 -.734 L .184 -1.398 L .239 -.976 L .321 -.918 L .584 -.665 L .183 -.565 L .268 -.354 L .64 -.228 L .268 -.325 L .423 -.679 L .364 -1.201 L .053 -.664 L -.046 -.848 L -.191 -.959 L -.201 -.536 L -.492 -.705 L -.476 -.776 L -.268 -.775 L .139 -.495 L .476 -.382 L .158 -.156 L .107 -.424 L -.006 -.479 L -.199 -.579 L -.489 -.69 L -.441 -.733 L -.203 -1.031 L -.181 -.423 L -.276 -.366 L -.666 -.974 L -.072 -.15 L
452.198 239.34 N -.611 -.632 L -1.354 -1.391 L -.471 -.436 L -.308 -.394 L -.099 -.438 L -.023 -.594 L -.017 -.848 L .024 -3.249 L -.015 -1.342 L .051 -.877 L 3.408 -.091 L .517 .04 L .125 -.086 L .124 -.594 L .436 -.44 L .132 -.368 L -.089 -.254 L -.269 -.323 L -.195 -1.059 L .214 -1.344 L .678 .096 L .365 .379 L .172 .352 L .195 .056 L 1.146 -.289 L .175 -.071 L .58 1.014 L .489 .194 L .925 .249 L .922 .164 L .325 .111 L .366 -.087 L .522 -.682 L .212 -.354 L .728 1.423 L .38 .28 L .895 .263 L .477 .252 L .416 .351 L .561 .731 L .381 .647 L .348 .21 L 1.355 .091 L .371 .012 L .041 -.551 L -.028 -1.427 L -.032 -.791 L -.136 -.183 L -.362 .186 L -.448 .455 L -.515 -.012 L -.445 -.279 L -.837 -.843 L -.456 -.605 L -.043 -.296 L .3 -1.02 L .377 -1.175 L -.372 -2.088 L .029 -.622 L .797 -1.276 L .154 -.198 L .347 -.214 L 3.015 -.499 L .563 -.068 L .703 .641 L .263 .21 L .729 .265 L 1.269 .6 L 1.574 .57 L .732 .349 L .385 .407 L .559 .887 L .434 .859 L .013 .324 L -.183 .27 L -.709 .344 L -.011 .127 L .04 .594 L -.091 1.682 L .08 .353 L .216 .168 L .511 .266 L .072 .197 L -.197 .241 L -.472 .258 L -.792 .259 L -.146 .34 L -.094 .764 L -.3 .807 L .2 .479 L .261 .408 L .394 .125 L -1.264 .53 L -1.696 .575 L -.932 .4 L -2.165 .578 L -.187 .128 L -.009 .495 L .152 .465 L .087 .438 L -.505 -.096 L -.999 .049 L -.794 .259 L -.636 .54 L -.312 .539 L -.019 .579 L -.168 .199 L -.285 .114 L -.999 .062 L -.621 .202 L -.306 .341 L -.777 .937 L -.562 .738 L -.825 .951 L -.354 .045 L -.803 -.165 L -.421 -.309 L -.334 .129 L -.521 .286 L -.404 .017 L -.594 -.209 L -.264 -.097 L -.154 -.169 L -.163 -.027 L -.187 -.154 L -.456 -.393 L -.294 -.055 L -1.089 -.093 L -.086 -.099 L -.165 -.056 L -1.845 .364 L
477.231 225.874 N -.224 1.184 L -.107 .48 L .252 .917 L .177 1.017 L .149 .408 L .238 .268 L .803 .588 L 1.189 1.166 L .454 .661 L .14 .48 L -.155 2.346 L -.04 .41 L -.214 .213 L -.432 .073 L -.322 .017 L -.229 .213 L -.076 .622 L .08 .509 L .029 .479 L -.096 .283 L -.185 -.111 L -.562 -.463 L -.763 -1.112 L -.484 -.548 L -.234 -.423 L .036 -.212 L .499 -.61 L .116 -.227 L .025 -.693 L -.1 -.96 L -.22 -.479 L -.261 -.056 L -.674 .061 L -.702 .132 L -.27 -.211 L -.343 -.407 L -.382 -.549 L -.195 -.041 L -.394 -.125 L -.261 -.408 L -.2 -.479 L .3 -.807 L .094 -.764 L .146 -.34 L .792 -.259 L .472 -.258 L .197 -.241 L -.072 -.197 L -.511 -.266 L -.216 -.168 L -.08 -.353 L .091 -1.682 L -.04 -.594 L .011 -.127 L .709 -.344 L .183 -.27 L -.013 -.324 L -.434 -.859 L -.559 -.887 L .223 -.016 L 1.014 .107 L .663 .538 L .448 .841 L .135 .946 L .053 .584 L .135 .766 L .196 .559 L
245.934 224.314 N .939 .136 L 1.122 .304 L .355 -.03 L .946 -.824 L .336 .026 L .48 .025 L .415 -.243 L 1.471 -1.109 L .874 -.485 L .36 -.158 L .934 -.076 L 1.283 .021 L .045 .748 L -.079 .621 L -.064 .622 L .036 .818 L .141 .635 L .335 .591 L .813 .928 L 1.1 .939 L .316 .097 L .787 .023 L .355 -.03 L .676 .25 L .688 .307 L .75 .603 L .3 .098 L .882 .037 L .096 .014 L .385 .774 L .398 .308 L .22 .084 L 1.148 -.077 L .636 .123 L .537 .166 L .403 .237 L .085 .169 L -.038 .565 L .203 1.029 L .03 .706 L .138 2.032 L .249 .944 L .153 .112 L .967 .036 L .5 .012 L 1.615 .019 L .693 .024 L .042 .296 L -.261 .835 L .067 .563 L .436 .407 L .73 .362 L .316 .479 L .307 .774 L .022 .494 L -.185 1.173 L -.238 .834 L -.38 .765 L -.421 .666 L -.089 -.084 L -1.952 -.991 L -.352 -.054 L -.928 .02 L -.843 -.01 L -.126 .128 L -1.076 .204 L -1.104 .162 L -.784 .202 L -.33 .044 L -.332 .383 L -.698 1.105 L -.278 .341 L -.133 .509 L .016 .635 L -.385 1.188 L -.395 1.104 L -.149 .325 L -.592 -.109 L -1.33 -.077 L -.686 .004 L -1.034 1.784 L -.416 -1.084 L -.341 -.309 L -.37 -.195 L -.531 -.067 L -.527 .045 L -.901 .034 L -.615 -.194 L -.193 -.169 L -.322 -.181 L -.292 .27 L -2.026 2.087 L -1.047 .006 L -.272 -.182 L -.397 -2.144 L -.278 -.973 L -.212 -.563 L -.769 -1.11 L -.249 -.676 L .04 -.354 L .437 -1.555 L -.017 -.282 L -.761 -.744 L -.25 -.521 L -.193 -1.213 L -.304 -.647 L -.555 -.745 L -.152 -.253 L -.018 -.142 L -.132 -.295 L -.049 -.48 L .12 -.227 L .723 -.61 L .285 -.439 L -.015 -.522 L -.604 -1.168 L -.022 -.48 L .159 -.34 L .21 -.368 L -.347 -.845 L .102 -.452 L .532 -.582 L .221 -.34 L .156 -.34 L -.236 -.902 L -.057 -.522 L .143 -.848 L .15 -.523 L .437 -.736 L -.08 -.24 L -.922 -1.646 L -1.109 -1.843 L
473.575 260.04 N -1.331 .011 L -.192 .058 L -.068 -.382 L -.261 -.889 L .071 -.495 L -.075 -.296 L -.095 -.324 L .03 -.806 L .057 -1.301 L -.072 -.763 L -.147 -.678 L -.33 -.944 L -.441 -.689 L -.181 -.946 L -.295 -1.199 L -.159 -.183 L .448 -.384 L .396 -.412 L 1.68 -1.706 L .114 -.227 L -.09 -.367 L .075 -.834 L .229 -.481 L .736 -.683 L .205 -.341 L .168 -.41 L -.594 -.845 L -.118 -.805 L -.113 -.494 L .128 -.283 L .448 -.596 L .201 -.411 L -.132 -.805 L -.086 -1.144 L -.031 -.791 L -.178 -.818 L -.441 -.379 L -.515 -.224 L -1.167 -.347 L -1.042 -.445 L -.658 -.223 L -1.438 -.006 L -.137 -.14 L -.025 -.495 L -.011 -.212 L -.087 -.438 L -.152 -.465 L .009 -.495 L .187 -.128 L 2.165 -.578 L .932 -.4 L 1.696 -.575 L 1.264 -.53 L .195 .041 L .382 .549 L .343 .407 L .27 .211 L .702 -.132 L .674 -.061 L .261 .056 L .22 .479 L .1 .96 L -.025 .693 L -.116 .227 L -.499 .61 L -.036 .212 L .234 .423 L .484 .548 L .763 1.112 L .562 .463 L .185 .111 L .096 -.283 L -.029 -.479 L -.08 -.509 L .076 -.622 L .229 -.213 L .322 -.017 L .432 -.073 L .214 -.213 L .04 -.41 L .155 -2.346 L -.14 -.48 L -.454 -.661 L -1.189 -1.166 L -.803 -.588 L -.238 -.268 L -.149 -.408 L -.177 -1.017 L -.252 -.917 L .107 -.48 L .224 -1.184 L .898 .018 L 1.019 .149 L .526 -.088 L .643 -.356 L .123 -.128 L .229 .083 L .323 .394 L .512 .294 L .963 -.02 L .964 -.006 L .42 .054 L .396 -.144 L .543 -.766 L .21 -.326 L .276 .083 L .646 .42 L .448 -.031 L 1.243 -.559 L 1.218 -.402 L .515 -.342 L 1.157 -.836 L .128 .167 L .212 .479 L -.185 .579 L -.302 .453 L -.198 .255 L .181 .451 L .129 .72 L -.012 .466 L .182 1.115 L -.101 .58 L -.258 .325 L .374 .705 L .154 .494 L -.006 1.115 L -.004 .819 L .043 .184 L .185 .127 L .327 .084 L .015 .269 L -.165 .494 L -.563 .58 L .184 .381 L -.08 .283 L -.418 .565 L -.802 .906 L -.512 .622 L -.72 .651 L -1.36 .751 L -1.48 .653 L -.73 .228 L -1.308 .582 L -.852 .637 L -1.286 1.443 L -.886 .85 L -1.193 .878 L -1.181 .836 L -.268 .128 L -.035 .96 L -.083 .495 L .058 .127 L .719 .535 L .188 .381 L -.166 .452 L -.085 .184 L .461 1.511 L .071 .564 L .06 .155 L .246 .014 L .171 -.128 L .141 -.085 L .043 .607 L -.234 2.218 L -.284 .82 L .325 .196 L .152 .057 L -.025 .325 L -.157 .311 L -.516 .566 L -.699 .538 L -.664 .34 L -1.266 .412 L -.796 .312 L -.688 .228 L -.895 .524 L -.652 .665 L -.337 .51 L .292 .338 L .589 .338 L .045 .325 L -.149 1.022 L
499.85 236.166 N .544 -.071 L .622 -.369 L .18 .028 L .346 .098 L .269 -.085 L .396 -.368 L .911 -.143 L .311 .281 L .305 -.028 L .101 -.185 L -.171 -.366 L .771 -.539 L .423 -.198 L .322 .226 L .389 -.213 L -.308 -.494 L .207 -.282 L .505 -.425 L .229 .296 L .229 .056 L .558 -.594 L -.158 -.197 L -.253 -.409 L .094 -.297 L .243 .014 L .27 -.071 L .172 -.34 L -.297 -.875 L .06 -.339 L .255 -.043 L .117 .07 L .253 .438 L .28 .099 L .2 -.41 L .692 -.524 L .235 -.367 L .134 -.452 L .168 -.692 L -.133 -.354 L .003 -.226 L .537 -.468 L .356 .324 L .455 .648 L .612 .281 L .141 .198 L .213 .847 L .294 1.821 L .093 .663 L .231 .791 L .391 .733 L .163 .466 L -.038 .367 L -.069 .155 L -.058 .099 L -.537 .807 L -.22 -.127 L -.189 -.366 L -.555 -.748 L -.297 .143 L -.05 .424 L .193 .875 L .396 .521 L .079 .396 L -.307 .636 L -.746 1.005 L -.045 .452 L .041 .89 L -.18 .946 L -.709 2.12 L -.825 2.572 L -1.254 3.788 L -1.324 4.48 L -.518 1.568 L -.188 .255 L -.508 .637 L -.2 .113 L -1.369 .102 L -.999 .327 L -.474 .468 L -.813 .086 L -.363 -.465 L -.196 -.142 L -.546 -.182 L -.37 .071 L -.269 -.057 L -.863 -.718 L -.104 -.24 L -.02 -.565 L -.104 -.239 L -.46 -.366 L -.124 -.282 L .001 -.721 L .345 -1.088 L -.094 -.325 L -.287 -.479 L -.62 -.931 L -.189 -.494 L .075 -.664 L .391 -1.37 L .228 -.213 L .474 -.185 L .768 -1.371 L .686 -1.174 L .104 -.325 L .151 -1.103 L -.11 -.353 L -.278 -.226 L -.354 -.366 L .066 -.184 L .252 -.509 L -.521 -.861 L -.117 -.677 L -.069 -.494 L -.231 -.721 L .024 -.112 L .517 -.693 L .362 -.594 L .163 -.438 L .007 -1.073 L .484 -.016 L
468.138 234.908 N .011 .212 L .025 .495 L .137 .14 L 1.438 .006 L .658 .223 L 1.042 .445 L 1.167 .347 L .515 .224 L .441 .379 L .178 .818 L .031 .791 L .086 1.144 L .132 .805 L -.201 .411 L -.448 .596 L -.128 .283 L .113 .494 L .118 .805 L .594 .845 L -.168 .41 L -.205 .341 L -.736 .683 L -.229 .481 L -.075 .834 L .09 .367 L -.114 .227 L -1.68 1.706 L -.396 .412 L -.448 .384 L -.342 -.225 L -.547 -.124 L -.442 -.025 L -.529 .145 L -.31 .016 L -.99 -.403 L -.597 -.139 L -.72 -.023 L -.067 -.042 L -.186 -.098 L -.306 -.451 L -.479 -.35 L -.549 -.167 L -.938 -.136 L -.352 -.153 L -.524 -.873 L -.163 -.564 L .032 -.565 L -.127 -.239 L -.78 .019 L -.201 -.098 L -.109 -.211 L .051 -.537 L -.106 -.169 L -.552 -.266 L -.533 -.223 L -.57 -.321 L -.563 -.491 L -.377 -.662 L -.246 -.96 L -.469 -.604 L -.43 -.478 L -.267 -.451 L .103 -.227 L .594 .209 L .404 -.017 L .521 -.286 L .334 -.129 L .421 .309 L .803 .165 L .354 -.045 L .825 -.951 L .562 -.738 L .777 -.937 L .306 -.341 L .621 -.202 L .999 -.062 L .285 -.114 L .168 -.199 L .019 -.579 L .312 -.539 L .636 -.54 L .794 -.259 L .999 -.049 L .505 .096 L
444.673 255.519 N -.006 3.434 L .031 1.894 L .025 2.246 L -.057 .205 L -.454 .318 L -.545 .302 L -.581 .498 L -.427 .034 L -.581 -.166 L -.745 -.042 L -.892 .048 L -.517 -.039 L -.296 -.212 L -.055 -.528 L -.042 -.345 L -.193 -.222 L -.637 -.348 L -.329 -.127 L -.335 .116 L -.109 .217 L -.317 .416 L -.584 .27 L -.152 .068 L -.458 -.491 L -1.041 -1.001 L -.458 -.606 L -.359 -1.03 L -.345 -.72 L -.136 -.493 L .12 -.269 L .053 -.34 L -.458 -.719 L -.231 -.861 L .148 -.861 L -.002 -.48 L -.537 -1.326 L -.496 -2.244 L .772 -.02 L .04 -.678 L -.077 -.749 L -.456 -.006 L .016 -.06 L -.099 -.522 L -.26 -.508 L -1.018 -1.283 L -.343 -.55 L -1.102 -2.158 L -.841 -1.623 L -.9 -1.509 L -.988 -1.269 L -.511 -1.044 L -.122 -.396 L -.045 -.551 L .015 -.578 L .248 -.197 L .352 -.144 L .758 .462 L .778 -.513 L .591 -.286 L .499 -.088 L .294 .083 L .45 .478 L .463 .309 L .636 .151 L 2.201 -.013 L 1.296 .006 L .631 .011 L 1.636 .019 L 2.59 -.016 L .989 .023 L .408 .096 L .305 .366 L .401 .322 L .622 .151 L .697 .024 L 2.024 -.026 L .349 .21 L .408 .083 L 1.164 -.063 L .717 .08 L 1.044 -.203 L 1.96 -.379 L .93 -.218 L 1.845 -.364 L .165 .056 L .086 .099 L 1.089 .093 L .294 .055 L .456 .393 L -.811 .315 L -.891 .02 L -.284 .143 L -.993 .938 L -.209 .029 L -.62 -.773 L -1.048 .134 L -2.962 .47 L -1.183 .021 L .005 1.215 L -.007 1.286 L -.025 .876 L -.043 1.201 L .002 3.561 L -.586 .046 L -1.564 .052 L -.146 .028 L -.106 2.657 L -.009 1.201 L .013 1.624 L .007 .806 L
248.453 316.576 N -.306 .101 L -.892 -.087 L -.538 -.293 L -.236 -.015 L -.311 .163 L -.418 .398 L -.498 .192 L -1.156 .091 L -.349 .09 L -.358 .207 L -.267 .621 L -.114 .341 L .06 .532 L -.163 .622 L -.104 .148 L -.453 .031 L -.534 .104 L -.956 -.413 L .667 -.639 L .326 -.444 L .582 -.4 L .025 -.147 L -.372 -.177 L -.273 -.117 L -1.353 .534 L -1.01 -.013 L -.545 .163 L -.202 -.339 L .128 -.192 L .959 -.268 L .266 .028 L .792 -.208 L .441 -.118 L -.605 -.162 L -.582 .002 L -.77 .001 L -.014 -.413 L .265 -.31 L -.007 -.191 L -.446 -.073 L -.356 -.44 L -.66 .384 L -.669 -.175 L .292 -.53 L .041 -.177 L -.378 .045 L -.361 .147 L -.416 -.396 L -.215 -.117 L .413 -.279 L .114 -.177 L -.091 -.278 L -.053 -.073 L -.351 .03 L -.773 -.424 L -.135 -.059 L .844 -.192 L .253 -.161 L .1 -.294 L .396 -.366 L .049 -.234 L -.641 .06 L -.257 .104 L -.312 -.073 L -.256 -.672 L .573 -.395 L -.565 -.378 L -.12 -.421 L .757 -.452 L -.14 -.421 L -.686 .422 L -.091 -1.523 L .399 -.596 L -.185 -.825 L .013 -.218 L .593 .014 L .41 .245 L .711 .071 L .171 -.246 L .002 -.159 L -.896 -.447 L -.867 .146 L -.317 -.173 L -.536 .059 L -.017 -.231 L .339 -.333 L .025 -.246 L -.067 -.087 L .186 -.202 L .536 .014 L .229 -.377 L .01 -.216 L -.722 -.389 L -.354 -.129 L -.886 .045 L -.332 -.101 L -.024 -.49 L -.939 .16 L -.115 -.101 L .122 -.145 L 1.032 -.521 L .251 -.116 L .4 -.404 L .266 -.389 L .833 -.06 L .268 .201 L .059 .346 L -.648 .202 L -.323 .274 L .11 .505 L .117 .058 L .191 -.102 L .268 -.39 L .183 -.087 L .242 .101 L -.037 .317 L .057 .504 L .886 -.996 L .161 -.678 L .056 -.647 L .237 -.375 L .079 -.058 L .631 -.217 L -.201 -.071 L -.438 -.143 L -.056 -.158 L .101 -.273 L .246 -.072 L .571 -.245 L .599 -.431 L .271 -.459 L -.061 -.229 L -.394 -.157 L -.662 -.399 L -.053 -.372 L .139 -.243 L .105 -.458 L -.06 -.828 L .366 -.33 L .676 -.272 L -.431 -.585 L -.053 -.784 L .133 -.158 L .554 -.157 L .054 -.314 L -.116 -.285 L -.317 -.085 L -.272 -.198 L .233 -.329 L .087 -.313 L -.401 -.185 L -.274 -.014 L -.161 .101 L -.476 .414 L -.548 .058 L -.087 .001 L -.289 -.199 L -.16 -.484 L -.399 -.726 L -.133 -.697 L .188 -.911 L .137 -.413 L .722 -.739 L .535 -.767 L -.006 -.326 L -.544 -1.757 L .001 -.608 L .088 -.567 L -.076 -.438 L -.528 -.891 L -.04 -.298 L .236 -.198 L .499 .098 L .182 -.085 L .2 -.142 L .097 -.143 L .41 -1.288 L .252 -.481 L .304 -.935 L .18 -.65 L .664 -.808 L .363 -.722 L .201 -.636 L .252 -.946 L .311 -.691 L .187 -.128 L .273 -.382 L .013 -.296 L -.312 -.847 L .082 -.184 L .455 -.452 L .206 -.339 L .028 -.24 L -.093 -.226 L -.166 -.805 L -.292 -2.088 L -.098 -.86 L .031 -.565 L .412 -.565 L .37 -.537 L .207 -.564 L .007 -.734 L -.339 -.521 L -.098 -.409 L .295 -.96 L .218 -.941 L .127 -.556 L .461 -.594 L .171 -.918 L .243 -.975 L .126 -.805 L .082 -.565 L -.063 -1.087 L .422 -.664 L .211 -.494 L -.221 -.932 L -.048 -.833 L .148 -.24 L -.022 -.917 L .229 -.607 L -.124 -.297 L -.365 -.084 L .06 -.324 L -.046 -.396 L .223 -.198 L .402 -.198 L .137 -.424 L -.008 -.819 L .093 -.593 L .182 -.918 L -.004 -2.344 L -.172 -2.074 L -.042 -1.539 L -.194 -.974 L -.15 -.387 L .852 -.275 L .259 -.298 L .228 -.933 L .15 -.199 L .586 -.187 L .152 .253 L .555 .745 L .304 .647 L .193 1.213 L .25 .521 L .761 .744 L .017 .282 L -.437 1.555 L -.04 .354 L .249 .676 L .769 1.11 L .212 .563 L .278 .973 L .397 2.144 L .272 .182 L 1.047 -.006 L .107 .056 L .212 .14 L .161 .154 L -.093 .636 L -.541 1.457 L -.36 .256 L -1.346 .53 L -.819 .372 L -.204 .312 L .25 .817 L -.421 .722 L -.007 .579 L .113 .437 L .34 .449 L .03 .226 L -.273 .369 L -.161 .382 L .114 .507 L .53 .477 L .011 .227 L -.152 .311 L -.333 .017 L -.791 .089 L -.329 .835 L -.464 .835 L -.608 .694 L -.282 .439 L -.823 1.839 L .167 1.466 L .054 .762 L -.124 .185 L -.492 .271 L -.292 .34 L -.388 1.201 L -.156 .961 L .285 .633 L .408 1.154 L .784 2.816 L .055 .69 L -.075 .41 L -1.083 1.854 L -.319 .595 L .088 .409 L .189 1.06 L -.078 .325 L -1.334 1.11 L -.231 .312 L -.142 1.075 L .014 1.16 L .249 1.103 L .437 .932 L -.202 .143 L -.951 .529 L -.126 .17 L -.053 .312 L -.511 2.427 L -.316 .541 L -.1 .37 L .123 1.835 L .231 .867 L .012 .427 L -.596 .317 L -.172 .172 L -.106 .271 L .094 1.226 L .125 .128 L .555 .111 L .088 .655 L -.191 1.458 L .252 .585 L .26 .185 L .789 .11 L .302 .17 L -.007 .186 L -.245 .202 L -.322 .13 L -.726 .033 L -.757 .146 L .176 .171 L .586 .298 L .552 .385 L .017 .216 L -.767 .794 L -.059 1.094 L .158 1.035 L -.216 .896 L -.212 .434 L -.226 .262 L -.598 .161 L -.28 .219 L -.249 .781 L .446 .648 L -.069 .188 L -.296 1.218 L -.307 .263 L -1.729 1.01 L -.271 .292 L -.037 .45 L .28 1.309 L .508 1.123 L .218 .043 L .961 -.283 L .654 -.121 L .187 .248 L .231 2.285 L .778 .568 L .669 .041 L 1.41 -.052 L 2.827 .132 L .841 .217 L 1.385 .36 L .286 .039 L h 236.642 296.773 m -.394 -.113 L -.43 -.028 L -.21 -.171 L -.133 -.229 L .21 -.457 L .15 -.657 L -.087 -.514 L .011 -.414 L .364 -.728 L .817 -.116 L .36 .327 L .044 .328 L -.688 .443 L -.146 .229 L .493 .771 L -.194 1.058 L -.167 .271 L h 238.177 317.937 m -.445 -.177 L .083 -.842 L -.849 .075 L -.073 -.368 L .218 -.354 L .823 .102 L .508 -.207 L .205 .103 L .054 .812 L -.267 .34 L -.257 .518 L h 247.801 322.062 m -1.033 .102 L -.467 -.118 L -.55 -.237 L -.42 .001 L -.481 .104 L -.935 .226 L -.496 .03 L .125 -.343 L .202 -.312 L -.104 -.312 L .906 -.15 L 1.434 .058 L .433 .323 L .706 -.007 L -.622 -.689 L -.307 -.163 L -.56 -.117 L -.178 -.089 L -.188 .03 L -.338 -.341 L -.229 -.4 L 1.611 -.581 L -.044 -.296 L -.165 -.147 L -1.819 .285 L -.292 -.222 L .263 -.474 L .146 -.163 L 1.074 -.52 L .868 -.637 L .414 .28 L 1.153 .062 L -.008 1.144 L -.098 3.675 L
456.133 239.67 N .187 .154 L .163 .027 L .154 .169 L .264 .097 L -.103 .227 L .267 .451 L .43 .478 L .469 .604 L .246 .96 L .377 .662 L .563 .491 L .57 .321 L .533 .223 L .552 .266 L .106 .169 L -.051 .537 L .109 .211 L .201 .098 L .78 -.019 L .127 .239 L -.032 .565 L .163 .564 L .524 .873 L .352 .153 L .938 .136 L .549 .167 L .479 .35 L .306 .451 L .186 .098 L -.317 .411 L -.388 .327 L -.507 .243 L -.747 .075 L -.304 .115 L -.7 .823 L -.586 .583 L -.362 .229 L -.747 .357 L -.388 .355 L -.107 .636 L -.222 .666 L -.247 .241 L -.634 .357 L -.98 .33 L -.249 .214 L -.217 .708 L -.345 .963 L -.288 .354 L -.237 .129 L -.584 .116 L -.43 -.026 L -.473 .06 L -.511 -.011 L -.819 -.193 L -.744 -.32 L -.979 -.645 L -.545 -.039 L -.333 .186 L -.084 .24 L -.585 1.134 L -.382 .469 L -.651 .625 L -.632 .428 L -.8 .372 L -.823 .033 L -.854 .047 L -.368 -.097 L -.11 -.183 L .003 -.48 L .243 -.609 L .166 -.538 L -.21 -.762 L -.547 -.943 L -.716 -.787 L -.528 -.067 L -.007 -.806 L -.013 -1.624 L .009 -1.201 L .106 -2.657 L .146 -.028 L 1.564 -.052 L .586 -.046 L -.002 -3.561 L .043 -1.201 L .025 -.876 L .007 -1.286 L -.005 -1.215 L 1.183 -.021 L 2.962 -.47 L 1.048 -.134 L .62 .773 L .209 -.029 L .993 -.938 L .284 -.143 L .891 -.02 L .811 -.315 L
279.288 257.295 N .02 .239 L -.544 1.57 L -.375 .468 L -1.007 .74 L -.301 .27 L -.352 .51 L -.609 -.363 L -.35 -.097 L -.235 .029 L -.387 .172 L -.745 .131 L -.71 .005 L -.564 -.096 L -.992 -.333 L -.607 -.025 L -1.187 .332 L -.19 -.056 L .064 -.212 L .425 -.426 L .486 -.398 L .11 -.198 L -.21 -.619 L .048 -.227 L .625 -.851 L .617 -1.203 L .018 -.268 L -.939 -.503 L -.65 -.18 L -1.448 -.697 L -1.632 -1.106 L -.671 -.307 L -1.173 -.204 L -.498 -.237 L -.835 -.588 L -.576 -.562 L -1.271 -1.376 L -.782 -.913 L -.225 -.337 L -.19 -.056 L .149 -.325 L .395 -1.104 L .385 -1.188 L -.016 -.635 L .133 -.509 L .278 -.341 L .698 -1.105 L .332 -.383 L .33 -.044 L .784 -.202 L 1.104 -.162 L 1.076 -.204 L .126 -.128 L .843 .01 L .928 -.02 L .352 .054 L 1.952 .991 L .089 .084 L .253 .408 L .084 .663 L .521 .872 L .104 .959 L -.132 .862 L -.086 .721 L -.006 .72 L .372 .04 L .818 .15 L .925 .221 L .346 -.03 L .709 -.413 L .115 -.001 L .724 .278 L .843 .404 L .121 .437 L .487 2.524 L .254 .563 L .224 .055 L 1.29 -.445 L .234 .112 L .491 .336 L .019 .141 L -.321 .75 L -.298 .835 L -.222 .819 L -.027 .777 L .063 .423 L
444.673 255.519 N .528 .067 L .716 .787 L .547 .943 L .21 .762 L -.166 .538 L -.243 .609 L -.003 .48 L .11 .183 L .368 .097 L .854 -.047 L .823 -.033 L .8 -.372 L .632 -.428 L .651 -.625 L .382 -.469 L .585 -1.134 L .084 -.24 L .333 -.186 L .545 .039 L .979 .645 L .744 .32 L .819 .193 L .511 .011 L .473 -.06 L .43 .026 L .584 -.116 L .237 -.129 L .288 -.354 L .345 -.963 L .217 -.708 L .249 -.214 L .98 -.33 L .634 -.357 L .247 -.241 L .222 -.666 L .107 -.636 L .388 -.355 L .747 -.357 L .362 -.229 L .586 -.583 L .7 -.823 L .304 -.115 L .747 -.075 L .507 -.243 L .388 -.327 L .317 -.411 L .067 .042 L .72 .023 L .597 .139 L .99 .403 L .31 -.016 L .529 -.145 L .442 .025 L .547 .124 L .342 .225 L .159 .183 L .295 1.199 L .181 .946 L .441 .689 L .33 .944 L .147 .678 L .072 .763 L -.057 1.301 L -.03 .806 L .095 .324 L -1.449 -.585 L -.279 .199 L -.657 .979 L -.28 .567 L -.005 .325 L .39 .676 L .307 .465 L .458 .322 L .671 .109 L .595 -.004 L .076 -.594 L .064 -.198 L .312 -.186 L .131 -.015 L .192 -.058 L 1.331 -.011 L -.182 1.195 L -.352 .849 L -.182 .184 L -.404 .1 L -.093 .24 L .199 .536 L -.104 .467 L -.248 .354 L -.569 .453 L -.923 .581 L -.591 .75 L -1.383 1.98 L -.631 .834 L -1.242 1.373 L -1.193 1.062 L -.829 .863 L -1.434 1.034 L -1.379 1.091 L -.552 .382 L -.989 .638 L -.676 .298 L -.782 .101 L -.98 -.012 L -.549 .071 L -.132 .354 L .013 .127 L -.109 .085 L -.449 -.098 L -.553 -.126 L -.303 .015 L -.25 .198 L -.272 .312 L -.226 .113 L -.36 -.056 L -.768 -.408 L -.759 -.168 L -.542 -.013 L -.31 .113 L -.38 .27 L -.482 -.099 L -.645 -.21 L -.295 .1 L -.638 .043 L -.589 .214 L -.729 .538 L -.72 .086 L -.44 -.013 L -.667 -.084 L -.738 .072 L -.575 .199 L -.827 .82 L -1.251 -.576 L -.092 -.509 L -.218 -.183 L -.479 -.056 L -.28 .085 L -.257 -.479 L -.343 -.056 L -.149 .255 L -.035 .197 L -.312 -.112 L -.119 -.226 L .267 -.495 L .103 -.424 L -.857 -1.354 L -.323 -.282 L -.134 -.226 L .173 -.17 L .636 -.044 L .172 -.424 L .06 -.819 L -.163 -.663 L -.186 -.522 L -.61 -1.143 L -.75 -1.029 L -.472 -.903 L -.612 -1.383 L -.646 -1.467 L -.573 -.818 L -.436 -.467 L .152 -.068 L .584 -.27 L .317 -.416 L .109 -.217 L .335 -.116 L .329 .127 L .637 .348 L .193 .222 L .042 .345 L .055 .528 L .296 .212 L .517 .039 L .892 -.048 L .745 .042 L .581 .166 L .427 -.034 L .581 -.498 L .545 -.302 L .454 -.318 L .057 -.205 L -.025 -2.246 L -.031 -1.894 L .006 -3.434 L h 462.462 268.501 m .412 -.044 L .194 -.553 L .633 -.343 L 1.035 -.303 L .263 -.199 L .582 -1.007 L .268 -.326 L .143 -.241 L -.104 -.226 L -.967 -.744 L -.33 -.337 L -.422 -.266 L -.308 .086 L -.995 .359 L -.65 .329 L -.513 .567 L -.275 .44 L -.691 .611 L .12 .409 L .582 .858 L .285 .366 L .739 .561 L h 432.955 250.661 m .456 .006 L .077 .749 L -.04 .678 L -.772 .02 L -.078 -.354 L -.028 -.396 L .285 -.297 L .101 -.406 L
471.719 258.047 N .075 .296 L -.071 .495 L .261 .889 L .068 .382 L -.131 .015 L -.312 .186 L -.064 .198 L -.076 .594 L -.595 .004 L -.671 -.109 L -.458 -.322 L -.307 -.465 L -.39 -.676 L .005 -.325 L .28 -.567 L .657 -.979 L .279 -.199 L 1.449 .585 L
462.462 268.501 N -.739 -.561 L -.285 -.366 L -.582 -.858 L -.12 -.409 L .691 -.611 L .275 -.44 L .513 -.567 L .65 -.329 L .995 -.359 L .308 -.086 L .422 .266 L .33 .337 L .967 .744 L .104 .226 L -.143 .241 L -.268 .326 L -.582 1.007 L -.263 .199 L -1.035 .303 L -.633 .343 L -.194 .553 L -.412 .044 L
790.15 283.022 N .738 .197 L .008 -.227 L -.242 -.524 L .052 -.284 L .233 .014 L .389 .17 L .37 .751 L .277 .964 L .48 .17 L 1.753 .691 L .506 .113 L .37 -.072 L .699 -.483 L .885 -.343 L .4 .027 L .329 .17 L .066 .454 L -.022 .198 L -.402 1.236 L -.283 .072 L -.761 .058 L -.035 .683 L -.124 .156 L -.424 .029 L -.746 .016 L -.432 .2 L -.271 .284 L .041 .384 L .254 .525 L -.002 .213 L -.151 .199 L -.646 .515 L -.898 1.129 L -.847 1.058 L -.756 .587 L -.68 .316 L -.337 -.171 L -.47 -.313 L -.237 -.328 L .056 -.314 L .288 -.386 L .307 -.671 L .398 -.5 L -.031 -.343 L -.271 -.128 L -.761 -.582 L -.421 -.185 L -.593 -.184 L -.98 -.452 L -.306 -.256 L -.11 -.17 L .081 -.128 L .419 -.157 L 1.389 -.685 L .209 -.512 L -.078 -.695 L .087 -.312 L .396 -.441 L .032 -.383 L -.482 -.837 L .081 -.567 L -.156 -.311 L -.479 -.655 L -.574 -.678 L .102 -.164 L -.145 -.304 L -.291 -.351 L -.336 -.188 L -.29 -.163 L .117 .233 L .497 .515 L .049 .141 L -.169 0 L -.211 -.281 L -.525 -.631 L -.622 -.771 L -.518 -.561 L .001 -.117 L -.268 -.257 L .04 -.141 L .013 -.14 L -.048 -.188 L -.197 -.396 L -.379 -.42 L -.347 -.257 L .163 -.046 L .205 .093 L .358 -.047 L .131 -.093 L .084 .28 L -.149 .187 L .186 .303 L .177 .21 L .167 .116 L .228 .164 L .041 -.141 L .269 .023 L .519 .257 L .42 .117 L .274 .07 L .128 .257 L -.011 .141 L .185 .023 L .146 -.188 L .185 .023 L -.022 .164 L .227 .351 L .249 .187 L .233 .28 L -.18 .023 L -.076 .164 L .093 .163 L -.242 -.023 L -.175 -.047 L .143 .117 L .251 .188 L .23 .233 L .352 .28 L .063 .234 L .019 .21 L -.261 -.047 L .096 .164 L .239 .351 L .256 .188 L -.292 .023 L -.226 0 L -.205 -.047 L -.006 .141 L .306 .14 L .324 .164 L -.09 .211 L .205 .046 L .265 -.023 L .226 0 L .223 .141 L -.114 .07 L -.031 .141 L .025 .141 L .136 .06 L h 782.939 297.694 m -.088 .158 L -.558 .13 L -.309 .288 L -.322 .101 L -.246 .244 L -.692 -.242 L -.16 .086 L .15 .216 L .429 .415 L -.141 .173 L .02 .259 L -.064 .431 L -.218 -.071 L -.976 -.099 L .418 .229 L .449 .244 L -.278 .49 L -.427 .896 L -.212 .549 L -.418 .318 L -.673 .349 L -.171 .246 L -.259 .145 L -.581 .233 L -.593 .406 L -.398 .015 L -1.156 -.258 L -.628 .112 L -.585 -.442 L -.812 -.158 L -.373 -.066 L -.162 -.308 L -.467 -.098 L -.24 .142 L -.062 .168 L -.78 .095 L -.214 -.166 L -.515 -.095 L -.146 -.286 L .432 -.089 L -.223 -.216 L .328 -.116 L .322 -.001 L -.452 -.482 L .82 .266 L -.464 -.576 L .121 -.145 L .946 .156 L .082 -.13 L -.141 -.173 L -.201 -.216 L -.06 -.288 L .283 -.303 L .569 -.246 L .328 -.374 L .561 -.375 L .102 -.302 L .998 -.575 L 1.106 -.275 L .713 -.331 L .544 -.36 L .377 -.101 L .685 -.575 L .066 -.272 L .48 -.302 L .373 -.015 L .787 -.331 L .664 -.402 L .126 -.215 L -.008 -.172 L .266 -.144 L .448 -.302 L -.109 -.501 L .076 -.214 L .166 -.44 L .306 .048 L .066 -.152 L .58 -.259 L .444 -.272 L .137 -.285 L .131 -1.187 L .512 -.647 L .372 .047 L .365 .165 L .032 .259 L .337 .06 L .187 .186 L .231 .799 L .312 .242 L .973 -.645 L .426 -.029 L .367 .113 L .222 .5 L -.197 .399 L .299 .429 L .066 .271 L -.611 .659 L -.261 .401 L -.476 .358 L -.868 .746 L -.578 .359 L -.295 .13 L -.236 .258 L -.389 .159 L -.271 .258 L .416 .407 L .428 .047 L .421 .289 L -.276 .113 L -.484 .07 L -.503 -.296 L -.488 .131 L -.352 .158 L
247.899 318.387 N .008 -1.144 L .821 .289 L .06 .206 L -.354 .312 L -.534 .337 L h 248.453 316.576 m -.286 -.039 L -1.385 -.36 L -.841 -.217 L -2.827 -.132 L -1.41 .052 L -.669 -.041 L -.778 -.568 L -.231 -2.285 L -.187 -.248 L -.654 .121 L -.961 .283 L -.218 -.043 L -.508 -1.123 L -.28 -1.309 L .037 -.45 L .271 -.292 L 1.729 -1.01 L .307 -.263 L .296 -1.218 L .069 -.188 L -.446 -.648 L .249 -.781 L .28 -.219 L .598 -.161 L .226 -.262 L .212 -.434 L .216 -.896 L -.158 -1.035 L .059 -1.094 L .767 -.794 L -.017 -.216 L -.552 -.385 L -.586 -.298 L -.176 -.171 L .757 -.146 L .726 -.033 L .322 -.13 L .245 -.202 L .007 -.186 L -.302 -.17 L -.789 -.11 L -.26 -.185 L -.252 -.585 L .191 -1.458 L -.088 -.655 L -.555 -.111 L -.125 -.128 L -.094 -1.226 L .106 -.271 L .172 -.172 L .596 -.317 L -.012 -.427 L -.231 -.867 L -.123 -1.835 L .1 -.37 L .316 -.541 L .511 -2.427 L .053 -.312 L .126 -.17 L .951 -.529 L .202 -.143 L -.437 -.932 L -.249 -1.103 L -.014 -1.16 L .142 -1.075 L .231 -.312 L 1.334 -1.11 L .078 -.325 L -.189 -1.06 L -.088 -.409 L .319 -.595 L 1.083 -1.854 L .075 -.41 L -.055 -.69 L -.784 -2.816 L -.408 -1.154 L -.285 -.633 L .156 -.961 L .388 -1.201 L .292 -.34 L .492 -.271 L .124 -.185 L -.054 -.762 L -.167 -1.466 L .823 -1.839 L .282 -.439 L .608 -.694 L .464 -.835 L .329 -.835 L .791 -.089 L .333 -.017 L .152 -.311 L -.011 -.227 L -.53 -.477 L -.114 -.507 L .161 -.382 L .273 -.369 L -.03 -.226 L -.34 -.449 L -.113 -.437 L .007 -.579 L .421 -.722 L -.25 -.817 L .204 -.312 L .819 -.372 L 1.346 -.53 L .36 -.256 L .541 -1.457 L .093 -.636 L -.161 -.154 L -.212 -.14 L -.107 -.056 L 2.026 -2.087 L .292 -.27 L .322 .181 L .193 .169 L .615 .194 L .901 -.034 L .527 -.045 L .531 .067 L .37 .195 L .341 .309 L .416 1.084 L 1.034 -1.784 L .686 -.004 L 1.33 .077 L .592 .109 L .19 .056 L .225 .337 L .782 .913 L 1.271 1.376 L .576 .562 L .835 .588 L .498 .237 L 1.173 .204 L .671 .307 L 1.632 1.106 L 1.448 .697 L .65 .18 L .939 .503 L -.018 .268 L -.617 1.203 L -.625 .851 L -.048 .227 L .21 .619 L -.11 .198 L -.486 .398 L -.425 .426 L -.064 .212 L .19 .056 L 1.187 -.332 L .607 .025 L .992 .333 L .564 .096 L .71 -.005 L .745 -.131 L .387 -.172 L .235 -.029 L .35 .097 L .609 .363 L .352 -.51 L .301 -.27 L 1.007 -.74 L .375 -.468 L .544 -1.57 L -.02 -.239 L .957 -.161 L .462 -.017 L .206 .196 L .517 1.154 L -.094 1.638 L -.161 .467 L -.521 .313 L -1.754 .744 L -.348 .242 L -1.633 1.448 L -1.435 1.363 L -1.805 1.816 L -.833 .88 L -.214 .27 L -.443 .524 L -.065 .452 L -.595 2.359 L -.103 .522 L .049 .847 L .168 .986 L -.118 .325 L -.48 .524 L -.24 .495 L -.011 .522 L .194 .577 L -.054 .338 L -.162 .273 L -.26 .325 L .015 .226 L .924 .831 L .68 .281 L .715 .281 L .283 .169 L .281 .325 L -.025 .325 L -.362 .523 L -.043 .396 L .105 .339 L .174 .269 L .466 .325 L .522 .168 L .109 .113 L .226 .892 L -.308 .481 L -.75 .937 L -.729 .766 L -.313 .737 L -.368 .284 L -.832 .342 L -1.04 .342 L -1.92 .401 L -1.795 .188 L -1.361 .116 L -.945 .044 L -1.175 -.11 L -.934 -.226 L -.128 .199 L .036 .808 L .322 .312 L .308 .184 L -.09 .298 L -.381 .624 L -.345 .498 L -.069 .385 L .392 .682 L .066 .285 L -.208 .214 L -.105 .057 L -1.251 .473 L -1.137 .116 L -.814 -.069 L -.967 -.34 L -1.47 -.396 L -.246 .057 L -.23 .271 L .041 .598 L .429 .684 L .037 .398 L -.242 .643 L .092 .385 L .773 .54 L .796 .084 L .369 -.2 L -.387 -.398 L .872 -.188 L .383 -.043 L .234 1.041 L .052 .3 L -.144 .157 L -.299 .101 L -.448 .072 L -.261 -.157 L -.104 -.299 L -.115 -.071 L -1.046 .073 L -.67 .201 L -.212 .101 L .151 .214 L .591 .07 L .47 .113 L .452 .113 L .06 .028 L -.864 .388 L -.776 .287 L -.577 .602 L .003 .414 L .161 .787 L -.081 .258 L -.815 .817 L .022 .215 L .423 .371 L -.491 .116 L -1.194 .088 L -.48 .087 L -.632 .246 L -.619 .389 L -.56 .548 L -.549 .821 L -.052 .389 L .061 .375 L .312 .591 L .48 .446 L .98 .633 L .657 .244 L .97 .143 L .362 .086 L .14 .274 L -.151 .796 L -.128 .348 L -.342 .464 L -.189 .145 L -1.08 .524 L -1.541 .814 L -.712 .698 L -.179 .276 L -.093 .45 L .111 .523 L -.169 .451 L -.239 .32 L -.97 .454 L -.969 .25 L -.421 .221 L -.323 .396 L -.226 .791 L -.054 .514 L .2 .777 L .547 .896 L .699 .779 L .235 .339 L -.101 .032 L h 247.899 318.387 m .18 .182 L .148 .073 L .607 -.075 L .344 .133 L .648 .725 L .908 .665 L .993 .756 L .525 .222 L .73 .37 L .246 .074 L .42 -.001 L .483 .163 L 1.283 .027 L .142 -.016 L -.006 .224 L -.19 .209 L -.492 .06 L -1.198 .092 L -.777 .196 L -.364 0 L -1.179 -.355 L -.753 -.088 L -1.15 -.027 L -.814 -.014 L -.831 .081 L .098 -3.675 L
346.758 54.457 N .127 -.162 L .42 -.179 L .894 .015 L .674 -.098 L -.354 -.227 L -.405 -.34 L .317 -.342 L .277 0 L .956 .42 L .67 .048 L .3 -.163 L -.191 -.26 L -.625 -.373 L .366 -.245 L 1.037 .226 L .957 .08 L .746 .275 L .446 .551 L -.119 .405 L -.441 .292 L .922 .806 L .553 -.356 L .352 -.13 L .63 -.114 L .49 -.179 L .061 -.21 L -.169 -.778 L .542 -.245 L .501 .454 L .426 .307 L .489 .209 L .215 .016 L .185 -.13 L -.264 -.454 L .243 -.163 L .27 -.033 L .817 -.164 L .683 .438 L .536 .242 L .542 .063 L .05 -.178 L -.358 -.535 L 1.006 .145 L 1.439 .079 L .787 -.115 L .427 -.229 L -.021 -.716 L 1.167 .08 L .635 .471 L 1.118 .323 L .683 .015 L .273 .243 L -.252 .552 L .786 .29 L 1.674 .159 L .127 .145 L .143 .548 L -.07 .387 L -.152 .256 L -.152 .256 L -.443 .129 L -.815 .018 L -.195 .096 L -.04 .431 L -.515 .463 L -.497 .16 L -.568 -.031 L -.422 -.159 L -.817 .495 L -.539 .144 L -1.46 .463 L -.853 .113 L -.726 .001 L -.771 .097 L -.784 .587 L -.473 .127 L -1.078 .097 L -.709 -.03 L -1.316 -.171 L -.608 -.142 L -1.283 -.489 L -1.058 -.093 L -.443 .064 L -1.041 -.014 L -1.834 -.124 L -.297 -.206 L .434 -.191 L 1.127 -.352 L .701 -.59 L -.818 -.015 L -.51 -.126 L -.428 -.398 L -.253 -.095 L -.358 .081 L -1.564 .115 L -.557 .033 L -.37 -.223 L .141 -.192 L .388 -.129 L .669 -.097 L .794 -.017 L .729 -.114 L 1.049 -.098 L .376 -.194 L .178 -.322 L -.144 -.258 L -.358 -.177 L -.426 -.015 L -.478 -.145 L -1.005 -.047 L -.821 .099 L -.424 .162 L -.676 .082 L -1.041 -.272 L -.16 -.21 L
462.829 67.958 N .145 .053 L .16 .131 L -.043 .174 L -.175 .044 L -.189 0 L -.116 0 L -.088 .043 L -.058 .131 L -.175 .277 L -.219 .204 L -.319 .131 L -.204 .131 L -.088 .16 L .029 .16 L .131 .437 L .073 .189 L .029 .16 L -.175 .131 L 0 .175 L .175 .233 L .203 .087 L .088 .073 L 0 .073 L .015 .087 L .043 .146 L .175 .043 L .059 .059 L -.175 .073 L -.262 .043 L -.16 .058 L -.059 .102 L -.087 .116 L -.131 0 L 461.402 72 l -.015 .087 L -.116 .058 L .081 .106 L -.125 .025 L -.087 -.015 L -.306 -.043 L -.16 -.058 L -.175 -.073 L -.204 -.044 L -.131 .102 L -.204 -.029 L -.131 .044 L -.16 .087 L -.146 .014 L -.146 -.087 L -.116 -.029 L -.175 0 L -.204 -.117 L -.116 -.174 L -.203 -.117 L -.146 -.043 L -.072 -.117 L -.189 0 L -.247 -.043 L -.204 -.117 L -.029 0 L -.276 -.014 L -.102 -.102 L -.248 -.043 L -.116 -.102 L -.189 -.087 L 0 .073 L -.116 .087 L -.131 -.058 L -.015 -.073 L -.087 -.029 L -.103 0 L -.276 .117 L -.102 .029 L -.131 .015 L -.219 .015 L -.146 .043 L -.262 .029 L -.276 .087 L -.116 .102 L -.087 0 L .156 -.19 L -.003 -.351 L .183 -.238 L -.368 -.21 L -.605 .437 L -.334 -.251 L -.527 -.038 L .043 -.942 L -.396 .188 L -.336 -.415 L .158 -.202 L -.209 -.254 L .265 -.074 L -.092 -.252 L .344 -.042 L 1.026 -.084 L -.006 -.132 L .561 -.108 L .133 -.188 L .436 .101 L .074 -.113 L .317 .05 L .083 -.215 L 1.104 .193 L .446 -.294 L .091 .165 L .514 -.089 L 1.383 .029 L 1.152 .167 L .305 .12 L .592 -.045 L .971 .09 L .426 -.108 L .271 -.24 L -.006 -.009 L
461.353 72.251 N .37 -.004 L -.015 .116 L 0 .117 L .232 .073 L .204 .087 L .087 .073 L .204 .058 L -.015 .087 L -.029 .116 L -.015 .087 L -.102 .073 L -.087 .015 L -.103 .029 L .131 .087 L -.072 .131 L .029 .117 L -.073 .087 L -.102 .073 L -.044 .102 L .204 -.059 L .146 -.015 L .131 .073 L .087 .014 L .073 .044 L -.059 .087 L -.043 .073 L .116 .102 L .131 .058 L .029 .16 L .146 .102 L .16 .043 L -.059 .087 L .131 .117 L -.015 .189 L .088 .233 L -.044 .087 L -.015 .117 L -.061 .042 L -.241 .044 L -.24 .051 L -.12 .12 L -.223 .034 L -.137 .154 L -.137 .085 L -.069 .103 L -.068 .206 L -.188 .035 L -.239 -.035 L -.24 -.034 L -.325 -.034 L -.359 0 L -.172 .068 L -.103 .137 L -.223 .085 L -.154 0 L -.103 -.017 L -.086 .052 L -.377 -.035 L -.273 -.068 L -.154 -.171 L -.138 -.154 L -.325 -.137 L -.497 -.223 L -.342 -.24 L -.377 -.034 L -.583 -.035 L -.325 -.12 L -.291 -.188 L -.086 -.257 L -.188 .017 L -.171 .068 L -.36 .171 L -.394 .017 L -.24 0 L -.273 .085 L -.24 -.085 L -.309 -.103 L -.6 -.017 L -.291 .069 L -.359 -.069 L -.291 -.051 L -.154 .034 L -.274 .069 L -.103 -.052 L -.12 -.137 L -.154 0 L -.257 .068 L -.188 0 L -.754 -.017 L -.445 -.085 L -.754 .171 L -.599 .154 L -.429 .103 L -.257 .137 L -.052 .188 L -.526 .026 L -.065 -.059 L .073 -.837 L .035 -.302 L .127 -.167 L .672 -.379 L .034 -.717 L .267 -.162 L .267 -.273 L .217 -.203 L .296 -.026 L 1.056 -.199 L .166 -.046 L .162 -.066 L .29 0 L .049 .237 L .657 .388 L .422 .162 L .23 .473 L .091 .15 L .441 .196 L .785 .059 L .868 -.244 L .24 -.122 L .178 -.288 L -.052 -.394 L -.193 -.869 L .198 -.243 L .045 -.055 L .087 0 L .116 -.102 L .276 -.087 L .262 -.029 L .146 -.043 L .219 -.015 L .131 -.015 L .102 -.029 L .276 -.117 L .103 0 L .087 .029 L .015 .073 L .131 .058 L .116 -.087 L 0 -.073 L .189 .087 L .116 .102 L .248 .043 L .102 .102 L .276 .014 L .029 0 L .204 .117 L .247 .043 L .189 0 L .072 .117 L .146 .043 L .203 .117 L .116 .174 L .204 .117 L .175 0 L .116 .029 L .146 .087 L .146 -.014 L .16 -.087 L .131 -.044 L .204 .029 L .131 -.102 L .204 .044 L .175 .073 L .16 .058 L .306 .043 L .087 .015 L .125 -.025 L
451.02 79.165 N -.029 -.038 L -.034 -.137 L -.018 -.171 L .068 -.206 L .068 -.154 L .224 -.12 L -.052 -.12 L -.018 -.137 L -.171 -.069 L -.188 -.034 L -.103 -.103 L -.086 -.137 L -.223 .017 L -.257 0 L -.445 0 L -.223 .051 L -.086 -.103 L -.514 -.068 L -.257 -.069 L -.223 -.12 L -.24 0 L -.086 -.052 L -.051 -.154 L -.12 .034 L -.353 .096 L -.043 -.077 L .128 -.012 L .034 -.183 L -.439 -.646 L -.008 -.14 L -.042 -.727 L -.112 -.102 L .526 -.026 L .052 -.188 L .257 -.137 L .429 -.103 L .599 -.154 L .754 -.171 L .445 .085 L .754 .017 L .188 0 L .257 -.068 L .154 0 L .12 .137 L .103 .052 L .274 -.069 L .154 -.034 L .291 .051 L .359 .069 L .291 -.069 L .6 .017 L .309 .103 L .24 .085 L .273 -.085 L .24 0 L .394 -.017 L .36 -.171 L .171 -.068 L .188 -.017 L .086 .257 L .291 .188 L .325 .12 L .583 .035 L .377 .034 L .342 .24 L .497 .223 L .325 .137 L .138 .154 L .154 .171 L .273 .068 L .377 .035 L -.017 .171 L -.086 .154 L -.034 .12 L -.12 .137 L -.086 .137 L .343 .034 L .274 .052 L .085 .051 L -.119 .051 L -.086 0 L -.103 .154 L -.018 .154 L -.171 .017 L -.12 -.086 L -.12 .051 L -.239 -.034 L -.154 .034 L -.086 .154 L -.103 .154 L -.257 .068 L -.429 0 L -.137 .137 L -.12 .12 L -.034 .154 L -.086 .171 L .103 .171 L -.068 .137 L -.239 .154 L 0 .137 L -.068 .085 L -.069 .137 L .172 .034 L .205 0 L .138 .206 L -.086 .188 L -.274 .017 L -.223 -.068 L 0 -.154 L -.034 -.085 L -.086 -.069 L -.171 .051 L -.12 .086 L -.291 -.034 L -.068 .137 L -.24 .12 L -.154 0 L -.188 -.034 L -.273 .103 L .086 .171 L -.069 .12 L -.171 .034 L -.137 -.034 L -.206 .051 L -.377 .154 L -.291 0 L -.068 -.103 L -.12 -.051 L -.239 .051 L -.377 .017 L -.24 .034 L -.291 -.034 L -.154 .034 L -.093 -.035 L -.09 -.171 L -.016 -.029 L -.099 -.186 L -.284 -.487 L -.679 -.243 L -.04 -.014 L -.641 .021 L
452.867 80.273 N .093 .035 L .154 -.034 L .291 .034 L .24 -.034 L .377 -.017 L .239 -.051 L .12 .051 L .068 .103 L .291 0 L .377 -.154 L .206 -.051 L .137 .034 L .171 -.034 L .069 -.12 L -.086 -.171 L .273 -.103 L .188 .034 L .154 0 L .24 -.12 L .068 -.137 L .291 .034 L .12 -.086 L .171 -.051 L .086 .069 L .034 .085 L 0 .154 L .223 .068 L .274 -.017 L .086 -.188 L -.138 -.206 L -.205 0 L -.172 -.034 L .069 -.137 L .068 -.085 L 0 -.137 L .239 -.154 L .068 -.137 L -.103 -.171 L .086 -.171 L .034 -.154 L .12 -.12 L .137 -.137 L .429 0 L .257 -.068 L .103 -.154 L .086 -.154 L .154 -.034 L .239 .034 L .12 -.051 L .12 .086 L .171 -.017 L .018 -.154 L .103 -.154 L .086 0 L .119 -.051 L -.085 -.051 L -.274 -.052 L -.343 -.034 L .086 -.137 L .12 -.137 L .034 -.12 L .086 -.154 L .017 -.171 L .086 -.052 L .103 .017 L .154 0 L .223 -.085 L .103 -.137 L .172 -.068 L .359 0 L .325 .034 L .24 .034 L .239 .035 L .188 -.035 L .068 -.206 L .069 -.103 L .137 -.085 L .137 -.154 L .223 -.034 L .12 -.12 L .24 -.051 L .241 -.044 L .165 .147 L .229 .066 L .197 -.131 L .181 .016 L .312 .033 L .132 .148 L .082 .148 L .197 -.033 L .214 -.065 L .361 -.049 L .312 .049 L .296 .065 L .147 .017 L 0 .115 L -.164 .099 L -.017 .099 L .065 .148 L .164 .148 L .197 0 L .214 -.197 L .279 -.016 L .165 0 L .147 -.099 L .23 -.083 L .131 .049 L .099 .049 L .247 -.049 L .542 .115 L .132 .131 L .279 .099 L .099 .099 L .147 .099 L .165 .033 L .147 -.033 L .049 .115 L -.065 .115 L 0 .083 L -.033 .164 L -.131 .165 L .197 .247 L .147 .099 L .05 .164 L -.066 .131 L -.114 0 L 0 .083 L -.115 .082 L -.099 .049 L -.033 .165 L -.049 .147 L .345 .049 L .132 .181 L .082 .115 L .181 -.049 L .132 .033 L -.099 .115 L -.066 .131 L .017 .099 L .214 .017 L .164 .263 L .115 .23 L .443 .213 L .23 .066 L .279 .082 L .164 .099 L .066 .148 L -.099 .197 L -.066 .181 L .182 .066 L .361 -.066 L .378 .066 L .361 .099 L .263 .066 L -.032 .065 L -.066 .049 L -.082 .017 L .099 .181 L .296 .148 L .279 .066 L .033 .131 L -.065 .164 L -.296 0 L -.148 .083 L -.049 .065 L -.444 .247 L -.525 .099 L -.51 -.016 L -.197 -.132 L -.328 -.049 L -.362 .017 L -.131 .165 L -.099 .131 L .017 .164 L .279 .263 L .296 .164 L 0 .165 L -.132 .066 L .099 .148 L .147 .131 L -.082 .099 L .033 .164 L .033 .23 L -.033 .099 L .164 .082 L .082 .115 L .165 .066 L .002 .142 L -.519 -.005 L -.522 .056 L -.112 .131 L -.205 -.056 L -.187 -.037 L -.336 .075 L -.057 .13 L -.111 .112 L -.317 .187 L -.188 .261 L -.261 .224 L -.057 .206 L .243 .205 L .056 .149 L -.131 .206 L -.261 -.019 L -.149 -.056 L -.149 -.206 L -.112 -.056 L -.187 -.075 L -.224 -.037 L -.225 .037 L -.242 .075 L -.299 .019 L -.149 -.131 L -.224 .075 L -.188 .093 L -.316 .056 L -.188 -.056 L -.037 -.205 L -.112 -.131 L -.168 -.131 L -.13 .038 L -.131 .075 L -.168 0 L -.299 .149 L -.131 .149 L -.168 0 L -.094 -.187 L -.13 -.075 L -.206 0 L -.224 .112 L -.131 -.187 L -.224 -.093 L -.131 .112 L -.354 .056 L -.262 -.112 L -.112 0 L -.019 .205 L -.168 .093 L -.093 -.056 L .056 -.224 L -.243 -.038 L -.187 -.056 L -.541 .112 L 0 -.149 L -.187 0 L .019 -.224 L -.28 -.037 L -.242 .075 L -.523 -.112 L -.578 -.056 L -.075 -.056 L -.522 0 L -.205 -.168 L -.262 .019 L -.522 -.093 L -.467 .075 L -.485 0 L -.354 -.056 L -.355 .056 L -.354 .056 L -.485 -.038 L -.485 .019 L -.205 .187 L -.037 .168 L -.374 .168 L -.373 .206 L -.112 -.112 L -.261 0 L -.374 -.019 L -.037 .131 L 0 .045 L -.126 -.137 L .315 -.752 L -.013 -.25 L -.218 -.146 L -.149 -.176 L -.421 -.146 L -.289 -.012 L .128 -.292 L .291 -.328 L .571 -.244 L .44 -.03 L .263 -.208 L .023 -.236 L -.172 -.502 L -.615 -1.5 L -.16 -.302 L
400.125 81.146 N .633 .305 L .208 .207 L .208 .37 L -.038 .193 L -.545 .563 L .714 .176 L .396 -.311 L .527 -.119 L .602 .028 L .807 .176 L .467 .354 L .235 .752 L -.077 .221 L -.322 .414 L -1.068 .473 L -.767 .561 L -.96 .237 L 1.223 .167 L .501 .043 L .354 -.104 L .39 .117 L -.066 .516 L -.997 .308 L .005 .199 L -.479 -.084 L -1.068 .443 L -.879 -.142 L -.293 -.048 L -1.119 .211 L -.587 -.211 L -.598 .112 L -1.584 .141 L .137 .295 L -.907 -.168 L -.264 .168 L -.911 -.337 L -.334 .143 L -.913 .089 L -.093 .569 L -.337 .316 L -.37 .042 L -.272 -.252 L -.53 -.172 L -.135 .151 L -.527 -.077 L -.948 .324 L -.701 .552 L -.326 -.231 L -.775 -.147 L 1.2 -.472 L .492 -.476 L .447 -.097 L .468 -.388 L .118 -.485 L .242 .063 L .367 -.211 L -.008 -.274 L 1.013 -.105 L .76 .119 L .927 .007 L .073 -.338 L .308 -.142 L .321 -.556 L -.939 .394 L -.725 .016 L -1.467 -.482 L -1.866 -.055 L -.399 -.191 L -.156 -.162 L .417 -.325 L .983 -.194 L .721 -.237 L .38 -.384 L .066 -.827 L -.119 -.192 L -.713 .046 L -.34 -.044 L .288 -.355 L .387 -.223 L .802 -.253 L 1.394 -.062 L .922 -.076 L -.316 -.548 L .172 -.683 L .253 -.461 L -.045 -.312 L -.834 .061 L -.484 -.296 L -.2 -.312 L .309 -.507 L .617 -.433 L -.347 -.104 L -.596 -.088 L -.735 .3 L -.476 .061 L -.753 -.222 L -.088 .194 L -.222 .194 L -.672 -.103 L -.464 -.133 L .1 -.343 L .348 -.36 L .604 -.706 L -.293 -.134 L -.305 -.39 L .028 -.24 L .304 -.106 L .3 -.196 L -.194 -.496 L -.306 .076 L -.636 .453 L -.442 .031 L -.526 .287 L -.14 -.421 L .302 -.527 L .438 -.559 L .065 -.257 L -.417 -.195 L -.196 -.045 L -.218 .302 L -.394 .257 L -.493 -.165 L .299 -.575 L .54 -.455 L .09 -.136 L -.225 -.575 L .366 -.092 L .225 -.197 L -.672 -.515 L .432 -.351 L .752 .151 L .387 -.092 L -.645 -.759 L .975 -.169 L -.457 -.502 L .416 -.382 L .924 .365 L .824 -.093 L .686 -.139 L .867 -.047 L .612 .014 L .303 .259 L -.307 .29 L -1.726 .704 L -.46 .274 L -.218 .441 L .222 .182 L .784 .029 L .877 -.078 L .685 -.001 L .53 .075 L 1.563 -.064 L .458 .378 L -.363 .425 L -.212 .323 L .098 .112 L -.565 .66 L -.226 .111 L -.339 .437 L -.696 .261 L -.382 .038 L .451 .186 L .508 .167 L -.116 .015 L -.272 .19 L -.61 .052 L -.275 .196 L -1.337 -.025 L .404 .223 L .302 0 L .492 .093 L .432 -.006 L .519 -.223 L .413 -.025 L .449 .161 L .656 .164 L .673 .566 L .496 .228 L .118 .165 L -.067 .238 L .312 .78 L .371 .536 L .438 .189 L .714 .107 L .59 .549 L .688 .593 L .135 .52 L -.188 .49 L .257 .124 L h 387.915 77.13 m -.128 -.325 L .149 -.335 L .38 -.089 L .079 .501 L -.307 .251 L -.173 -.003 L h 386.786 80.184 m -.178 -.272 L -.967 .072 L .123 -.256 L -.364 -.15 L -.26 -.257 L -.335 -.107 L -.253 .364 L -.751 .257 L -.778 -.192 L -.401 -.278 L -.101 -.278 L .86 -.278 L -.483 -.257 L .817 -.107 L .385 -.484 L -.029 -.235 L .449 -.09 L .508 -.15 L .781 -.077 L .424 .044 L .389 .104 L .362 -.046 L .218 .149 L .519 .791 L .047 .179 L -.081 .298 L .308 .446 L -.155 .328 L -.402 .328 L -.354 .12 L -.299 .038 L
578.943 106.217 N -.41 -.375 L -.466 -.098 L -.663 0 L -.196 -.27 L -.27 -.147 L -.147 -.344 L -.564 .049 L -.981 -.246 L -.662 .074 L -1.35 -.024 L -.662 -.098 L -.712 -.221 L -.785 .147 L -.761 0 L -.858 .024 L -.441 .27 L -.54 -.098 L -.908 -.196 L -.735 -.246 L -.761 -.27 L -.589 -.074 L -.688 .123 L -.466 .368 L -.245 .736 L .024 .442 L -.344 -.123 L -.81 -.123 L -.688 -.196 L -.883 -.245 L -.883 -.147 L -.663 .098 L -.736 .123 L -.318 .368 L -.393 .442 L .044 .273 L -.322 .031 L -.377 .377 L -.283 -.126 L -.22 .063 L -.346 .283 L -.534 .471 L -.755 .189 L -.943 .377 L -.282 .188 L -.221 .472 L -.439 .188 L -.504 .44 L .157 .409 L -.125 .188 L -.66 0 L -.44 -.346 L .062 -.283 L -.062 -.283 L -.44 -.314 L -.346 0 L -1.006 .094 L -.691 .032 L -.503 -.063 L -.346 -1.069 L -.221 -.817 L -1.006 0 L -.031 -.754 L .188 -.409 L .031 -1.038 L -.66 .314 L -.66 -1.006 L -.597 -.22 L -.724 -.723 L -1.1 .409 L -2.767 -.188 L -2.578 .346 L -2.012 -1.666 L -5.722 -2.986 L -5.658 1.289 L -.056 8.174 L -.158 -.014 L -.341 .106 L -.489 .043 L -.447 -.255 L -.638 -.703 L -.256 -.511 L -.617 -.383 L -.681 -.383 L -.512 -.234 L -.979 .085 L -1.277 .298 L -.937 .532 L -.529 .453 L .092 -.399 L -.06 -.18 L -.12 -.12 L .14 -.26 L .2 -.2 L .14 -.32 L .04 -.3 L .18 -.2 L -.159 -.24 L -.4 -.16 L -.459 .06 L -.18 -.16 L -.3 .06 L -.2 .04 L -.199 -.18 L -.221 -.32 L -.319 -.28 L -.34 0 L -.359 .02 L 0 -.2 L .08 -.28 L -.2 -.379 L -.239 -.12 L -.2 -.24 L -.399 -.799 L -.08 -.28 L -.56 -.12 L -.699 -.08 L -.14 -.16 L .02 -.439 L .16 -.12 L .3 -.06 L .399 .02 L .34 .02 L .479 .14 L .539 .18 L .18 -.08 L .36 -.08 L -.2 -.16 L -.26 -.12 L -.399 -.2 L -.2 -.24 L .26 -.36 L .28 -.04 L .08 -.26 L .18 -.299 L .12 -.14 L .26 .04 L .319 -.08 L .16 -.1 L .339 .12 L .24 0 L 1.119 -.04 L .999 .14 L .499 .02 L -.159 -.08 L -.34 -.2 L -.479 -.12 L -.021 -.3 L .2 -.2 L .279 -.22 L .221 -.28 L .119 -.52 L .12 -.28 L -.16 -.24 L -.14 -.16 L .1 -.2 L .26 -.2 L -.119 -.12 L -.101 -.3 L -.359 -.12 L -.359 -.04 L -.68 -.1 L -.2 .16 L -.199 .08 L -.52 .08 L -.46 -.12 L -.319 -.26 L -.26 -.06 L -.68 -.12 L -.56 .06 L -.659 .319 L -.42 .02 L -.799 .5 L -.72 .28 L -.499 .06 L -.42 -.02 L -.279 .24 L -.213 .18 L -.616 -.19 L -.857 -.377 L -.068 -.308 L .343 -.103 L .309 .103 L .445 .103 L .138 -.103 L -.96 -1.131 L -.343 -.514 L -.479 -.206 L -.515 -.445 L -.514 -.034 L -.343 .034 L -.583 -.206 L -.103 .343 L -.514 -.514 L .068 -.309 L -.138 -.377 L -1.37 -.343 L .65 -1.165 L .446 -.274 L .239 -.206 L -.239 -.274 L -.343 -.171 L .205 -1.303 L .823 -.137 L .343 -.549 L .103 -.308 L .411 -.069 L .514 .24 L .48 .548 L .514 .411 L .651 0 L .411 -.24 L .068 -.446 L -.171 -.411 L -.068 -.445 L .479 -.206 L .891 -.411 L .172 -.24 L .309 -.309 L .514 -.171 L .549 -.068 L .788 -.377 L .548 -.343 L .515 -.309 L .651 .069 L .479 0 L .309 .274 L .651 -.137 L .273 -.137 L .617 -.24 L .411 .069 L .411 .514 L .788 .035 L .617 -.069 L .96 .171 L 0 .343 L .582 .206 L .789 .343 L .411 .274 L .068 .583 L .274 .137 L .239 -.274 L -.205 -.48 L -.034 -.24 L .72 .068 L .582 .548 L .686 .137 L .411 .24 L .686 -.171 L .274 -.274 L .377 -.343 L .514 -.377 L .823 .068 L .65 .035 L .651 .411 L .617 -.068 L .137 -.412 L 1.062 -.103 L .754 .103 L .274 .548 L .926 .309 L .754 .137 L .411 .171 L .651 -.343 L .171 -.309 L .24 0 L .343 .343 L .959 .034 L 1.577 -.411 L .137 -.309 L .138 -.686 L -.24 -.24 L -1.165 -.171 L -.274 -.308 L -.651 -.069 L -.377 -.137 L .068 -.171 L -.377 -.137 L -.239 0 L -.164 -.274 L .467 -.067 L .735 -.368 L .588 -.147 L .331 -.294 L -.441 -.478 L -.146 -.257 L .662 -.515 L .698 -.184 L 1.103 .147 L .515 -.073 L .11 -.257 L -.956 -.294 L -1.065 -.11 L 0 -.331 L .294 -.074 L -.294 -.221 L -.074 -.441 L .185 -.515 L .33 -.074 L 1.066 .147 L .515 0 L .772 0 L .368 -.184 L 1.396 -.405 L 1.029 -.037 L .735 -.11 L 1.545 -.11 L .588 -.073 L .331 .073 L .221 -.331 L .625 -.331 L 1.177 -.037 L 2.021 -.405 L 1.876 -.073 L .625 -.074 L .367 -.368 L 77.39 V .515 -.037 L .589 -.184 L .11 -.221 L .735 -.037 L .919 .147 L .515 .11 L .772 .257 L .625 -.11 L .882 -.037 L .368 .404 L -.037 .331 L .147 .221 L .515 .22 L -.11 .331 L -.147 .257 L .073 .331 L -.33 .037 L .184 .257 L .478 .074 L .295 -.147 L .44 .11 L .368 -.147 L .367 .074 L .331 -.221 L .294 .11 L .295 .368 L .367 .221 L .147 -.147 L .184 -.147 L .478 .037 L .405 .294 L .478 .11 L .441 -.221 L .367 0 L -.146 .294 L -.441 .184 L -.331 .441 L .331 .184 L .441 -.11 L .771 -.073 L .441 .037 L .552 .184 L .294 -.294 L .772 -.441 L 1.103 -.257 L .956 -.515 L .772 -.221 L .515 -.22 L .809 -.074 L 0 .441 L -.515 .11 L -.11 .368 L 1.104 .588 L .809 .294 L 1.287 .772 L 1.066 1.029 L 1.69 2.133 L .846 .882 L 1.104 1.434 L .515 -.257 L .331 -.257 L .367 -.515 L .92 0 L .367 .331 L 0 .368 L .478 0 L .258 .257 L .184 .184 L .589 0 L .992 0 L .993 -.221 L .771 -.221 L .993 -.037 L .698 .441 L .772 .588 L .331 .625 L .956 .147 L .588 .552 L .662 .699 L .882 .073 L .993 .074 L .478 -.368 L .625 -.184 L -.073 .331 L .441 .331 L .294 .478 L .589 0 L .064 .145 L -.551 .034 L -.542 .148 L -.279 .262 L -.011 .275 L -.035 .478 L -.306 .219 L -.289 .06 L -1.199 .093 L -.428 .277 L -.34 .581 L .097 .75 L .213 .707 L -.157 .39 L -.444 .392 L -.417 .103 L -.718 .062 L -1.402 -.079 L -.594 -.141 L -.721 -.141 L -1.096 -.254 L -.427 .507 L -.516 1.141 L 584.2 97.43 l -.286 .605 L -.137 .418 L .622 .514 L .126 .286 L -.156 .245 L -.231 .145 L -.394 .074 L -1.133 -.238 L -.5 -.184 L -.35 .06 L -1.082 .207 L -1.799 .254 L -.393 .188 L -.215 .302 L -.068 .215 L .232 .185 L .366 -.06 L .483 .141 L .03 1.357 L .345 .627 L .29 .441 L .119 .47 L -.222 .33 L -.705 .546 L -.32 .401 L -.02 .399 L .139 .86 L
386.786 80.184 N -.304 .038 L -.223 .09 L .241 .252 L .361 .771 L .287 1.213 L -.061 .281 L -.359 .341 L -.242 .414 L -.145 .473 L -.185 .044 L -.284 -.058 L -.616 .031 L -.15 .212 L -.913 .042 L -.84 .132 L -.247 .144 L -.661 .286 L -.903 .498 L -.628 .035 L -.879 .283 L -1.28 .084 L .053 -.378 L -.089 -.441 L -.848 .1 L -.171 -.487 L .734 -.254 L -1.186 -.021 L .062 -.233 L 1.286 .027 L .198 -.104 L .039 -.222 L .107 -.31 L .515 -.134 L .692 -.031 L .13 -.281 L -1.07 .099 L .387 -.437 L -.187 -.159 L .481 -.468 L .694 -.011 L .163 -.089 L -.174 -.311 L -.348 .177 L -.309 -.131 L -.319 .03 L -.391 -.177 L -.414 .001 L -.182 .106 L 378 81.478 l .309 -.306 L -.29 -.142 L .759 -.126 L -.139 -.301 L .391 -.235 L -.481 -.214 L -.59 .128 L 378 79.792 l .38 -.268 L .215 -.16 L .928 .187 L .336 -.075 L .527 .038 L 1.102 .123 L -.214 -.358 L 382.132 79 l .198 -.321 L -1.373 0 L .154 -.15 L .569 -.107 L .061 -.29 L .291 -.479 L .505 -.181 L .804 -.169 L .22 .302 L .354 .149 L .156 -.031 L .029 .235 L -.385 .484 L -.817 .107 L .483 .257 L -.86 .278 L .101 .278 L .401 .278 L .778 .192 L .751 -.257 L .253 -.364 L .335 .107 L .26 .257 L .364 .15 L -.123 .256 L .967 -.072 L .178 .272 L
452.998 85.535 N 85.49 V .037 -.131 L .374 .019 L .261 0 L .112 .112 L .373 -.206 L .374 -.168 L .037 -.168 L .205 -.187 L .485 -.019 L .485 .038 L .354 -.056 L .355 -.056 L .354 .056 L .485 0 L .467 -.075 L .522 .093 L .262 -.019 L .205 .168 L .522 0 L .075 .056 L .578 .056 L .523 .112 L .242 -.075 L .28 .037 L -.019 .224 L .187 0 L 0 .149 L .541 -.112 L .187 .056 L .243 .038 L -.056 .224 L .093 .056 L .168 -.093 L .019 -.205 L .112 0 L .262 .112 L .354 -.056 L .131 -.112 L .224 .093 L .131 .187 L .224 -.112 L .206 0 L .13 .075 L .094 .187 L .168 0 L .131 -.149 L .299 -.149 L .168 0 L .131 -.075 L .13 -.038 L .168 .131 L .112 .131 L .037 .205 L .188 .056 L .316 -.056 L .188 -.093 L .224 -.075 L .149 .131 L .299 -.019 L .242 -.075 L .225 -.037 L .224 .037 L .187 .075 L .112 .056 L .149 .206 L .149 .056 L .261 .019 L .131 -.206 L -.056 -.149 L -.243 -.205 L .057 -.206 L .261 -.224 L .188 -.261 L .317 -.187 L .111 -.112 L .057 -.13 L .336 -.075 L .187 .037 L .205 .056 L .112 -.131 L .522 -.056 L .519 .005 L .357 .089 L .469 .022 L .313 -.156 L .179 -.291 L .134 -.268 L .536 .246 L .536 -.022 L .67 -.223 L .692 .112 L .514 -.134 L .201 .268 L .312 .134 L .246 .335 L .134 .201 L .246 .156 L .312 .156 L 0 .268 L -.312 -.022 L -.312 .134 L .134 .291 L .111 .357 L .269 .29 L .647 0 L .156 .112 L .514 -.067 L .38 .022 L 0 .312 L .402 0 L 0 .357 L .224 .268 L .089 .246 L -.089 .179 L .089 .224 L .179 .089 L .291 .29 L .268 -.179 L .47 -.067 L .268 .067 L .469 .291 L .201 -.067 L .179 .022 L .179 .156 L .425 -.112 L .312 -.112 L .269 0 L .536 -.134 L .357 -.067 L .111 .156 L .268 .179 L 0 .134 L .201 .179 L .022 .134 L .402 .044 L .179 .179 L .224 .112 L .29 -.134 L .045 -.157 L .224 -.067 L .29 .268 L .425 .067 L .469 .112 L .268 .112 L .357 -.067 L .201 .179 L .291 .089 L .469 .022 L .111 .224 L .357 .156 L .269 0 L .134 -.044 L .201 -.089 L .156 .089 L -.089 .111 L -.022 .179 L .111 .089 L .09 .179 L -.045 .224 L -.201 .089 L -.156 .067 L -.357 .201 L -.312 .044 L .223 .246 L .269 .089 L .29 .044 L -.134 .156 L -.312 0 L -.246 0 L -.045 .179 L -.044 .224 L .156 .067 L .179 .067 L .044 .134 L .045 .179 L .09 .201 L .066 .067 L -.156 .491 L -.156 .291 L 0 .156 L -.335 .134 L -.805 -.157 L -.736 .045 L -.269 0 L -.022 .179 L -.223 .179 L -.38 .134 L -.357 .022 L -.224 .089 L -.09 .514 L 0 .224 L -.021 .112 L -.012 .126 L -.779 .104 L -.971 .06 L -.511 .405 L -.729 .189 L -1.135 .075 L -1.119 .248 L -.502 .318 L -.463 .059 L -.453 -.316 L -.369 .621 L -.31 .188 L -.477 .044 L -.438 -.057 L -.959 .031 L -.5 .16 L .641 .287 L 1.957 1.004 L .053 .172 L -.093 .188 L .163 .244 L .562 .042 L .511 -.13 L .675 -.146 L 1.052 .013 L .439 .114 L -.235 .259 L -.106 .245 L -.228 .144 L -.578 .116 L -.31 .029 L -.591 -.157 L -.473 .044 L -.71 .489 L -1.007 .045 L -.538 .188 L -.527 .488 L -.269 .101 L -.786 -.07 L -.588 -.171 L .364 -.746 L -.096 -.416 L -.264 -.287 L -.854 -.286 L -.193 -.014 L -.629 .016 L -.151 .043 L -.16 -.187 L .887 -.505 L .644 -.261 L .772 -.188 L .221 -.116 L -.246 -.46 L -.435 -.071 L -.799 .044 L -1.015 .045 L -.698 -.1 L -.195 -.101 L -.418 -.432 L .584 -.405 L -.528 -.605 L -.378 .361 L -.541 .001 L -1.001 .146 L -.565 .131 L -.694 .722 L -1.003 .867 L -.754 .203 L -.223 .044 L -.287 .504 L .079 .158 L .178 .093 L -.706 -.131 L -.665 .261 L -.457 0 L -.033 .189 L -.609 -.047 L -.398 -.166 L -.119 -.249 L -.15 .02 L .055 -.077 L .102 -.025 L .126 .013 L .113 .013 L .189 0 L .088 -.114 L 0 -.088 L -.063 -.113 L .025 -.113 L .126 -.063 L .051 -.063 L .075 -.013 L .089 -.025 L .088 -.063 L .089 -.088 L .024 -.126 L -.013 -.114 L .14 -.013 L .29 -.063 L .075 -.076 L -.025 -.088 L -.062 -.088 L .126 -.114 L .037 -.063 L -.012 -.088 L -.114 -.113 L .051 -.101 L -.088 -.151 L -.063 -.101 L .202 -.151 L .239 -.025 L .126 -.088 L .113 .025 L .013 .088 L -.013 .214 L .063 .013 L .113 0 L 96.92 V -.013 -.063 L .101 .038 L .063 .051 L .025 -.076 L .075 -.038 L .139 -.012 L 0 .075 L .089 .063 L .075 0 L .126 .164 L .076 -.076 L .075 -.076 L .013 -.05 L .101 -.025 L .177 0 L -.037 .189 L .176 .025 L .038 -.038 L .038 -.038 L .139 .013 L .227 0 L .038 -.025 L .075 -.076 L -.126 -.013 L -.164 -.126 L -.101 -.051 L -.075 -.05 L .013 -.038 L .101 -.063 L -.025 -.113 L .038 -.101 L -.013 -.126 L -.051 -.139 L -.101 -.063 L -.177 -.076 L -.075 0 L -.151 -.126 L -.151 -.063 L -.151 -.038 L .051 -.151 L .037 -.088 L -.037 -.051 L -.127 .038 L -.062 -.114 L .113 -.038 L -.013 -.189 L .089 -.075 L -.025 -.101 L -.038 -.088 L -.113 0 L -.102 .05 L -.088 .051 L -.113 -.088 L -.089 -.101 L -.188 -.101 L -.139 -.025 L -.102 -.139 L -.05 -.139 L .177 -.139 L 0 -.189 L .024 -.114 L .051 -.05 L -.126 -.063 L .164 -.151 L -.113 -.025 L -.076 -.063 L -.062 -.126 L -.14 -.013 L -.062 .101 L -.126 -.025 L -.215 -.025 L -.126 -.189 L -.05 -.189 L -.417 -.075 L -.277 .012 L -.062 .051 L -.076 .101 L -.062 -.05 L 0 -.076 L -.089 -.025 L -.101 .038 L .038 -.05 L .088 -.101 L -.025 -.063 L -.113 0 L -.177 .038 L -.126 -.025 L -.101 .013 L -.076 -.076 L -.05 -.063 L -.101 -.063 L -.151 -.013 L -.139 -.05 L -.14 -.126 L -.214 -.088 L -.038 -.013 L -.126 .025 L -.05 .025 L -.114 -.051 L -.088 -.025 L -.139 .025 L -.177 .051 L -.177 -.025 L -.062 .038 L -.126 .114 L -.202 0 L -.265 -.038 L -.126 .051 L -.315 -.114 L -.088 .101 L .012 .113 L -.126 0 L -.075 -.063 L -.126 .114 L -.06 .052 L -.634 .08 L -.151 .311 L -.278 .178 L -1.992 .191 L -.186 .215 L -.243 .119 L -.339 .06 L -.188 -.227 L -.327 .004 L -.025 -.231 L -.363 .045 L -1.115 -.066 L -.958 -.193 L -.241 .107 L -.787 -.121 L -.136 .085 L -.678 -.387 L -.554 -.2 L -.668 -.301 L -.166 .015 L 1.047 -1.471 L .653 .018 L -.349 -.383 L -.044 -.552 L .082 -.306 L 1.509 -1.218 L .599 -.398 L .286 -.181 L .429 -.013 L .255 -.24 L .009 -.314 L -.328 -.302 L .085 -.133 L .298 -.048 L -.316 -.193 L -.816 -.835 L .074 -.242 L -.161 -.175 L
660.044 89.132 N -.295 .31 L -.687 1.207 L -1.224 1.959 L -.381 .58 L .269 .836 L .051 .029 L .342 -.045 L .929 -.395 L .754 -.062 L .576 -.018 L .317 .085 L .431 .416 L .292 .07 L 1.191 -.786 L .438 -.002 L .928 .212 L .538 .199 L .797 .5 L .879 .99 L .599 .501 L .048 .273 L -.107 .217 L -.414 .218 L -.464 -.127 L -1.074 -.008 L -.432 -.099 L -.854 .033 L -.937 .221 L -.539 .146 L -.831 .278 L -.353 .189 L -.483 -.127 L -.464 .045 L -.47 .204 L -.363 .333 L -.312 .82 L -.241 .216 L -.347 .188 L -.638 .248 L -.896 .134 L -.624 -.054 L -.438 -.012 L -.224 -.013 L -1.192 .91 L -.742 .433 L -.744 .047 L -.982 .005 L -.592 -.125 L -.668 -.382 L -.718 -.154 L -.316 .073 L -.457 .231 L -.539 .589 L -.214 .401 L .003 .343 L .389 .569 L .599 .411 L .188 .228 L -.123 .271 L -.326 .259 L -1.265 .292 L -.67 .389 L -1.111 1.046 L -.265 .172 L -1.941 .737 L -.651 .061 L -.987 -.08 L -1.514 .065 L -1.339 .007 L -1.204 .349 L -.816 .289 L -.736 .274 L -.303 .101 L -1.44 .534 L -.686 .289 L -.481 .017 L -.433 -.197 L -.253 -.297 L -.61 -.067 L -.663 .061 L -.929 -.123 L -1.599 -.433 L -1.006 -.365 L -.815 -.551 L -.521 -.168 L -1.69 -.119 L -1.164 -.022 L -.937 -.023 L -2.861 .059 L -1.165 -.022 L -.802 -.109 L -1.241 -.207 L -1.979 -.018 L -.444 -.254 L -.467 -.439 L -1.571 -2.161 L -.105 -.542 L -.744 -.096 L -.839 -.31 L -1.645 -.806 L -.632 -.268 L -.998 -.224 L -.668 -.083 L -.995 -.038 L -1.505 -.021 L -1.062 -.181 L -.724 -.312 L -.233 -.229 L -.105 -.43 L .035 -.129 L .369 -.347 L .214 -.389 L .237 -.75 L .215 -.447 L -.401 -.66 L -1.07 -1.451 L -.568 -.618 L -.354 -.143 L -.633 -.144 L -.731 -.167 L -.614 -.069 L -.834 -.415 L -1.301 -.745 L -.371 -.433 L -.24 -.563 L -.131 -.405 L -.062 -.145 L .154 -.044 L .799 -.425 L .599 -.207 L 1.387 -.08 L .603 -.148 L .727 -.381 L .017 -.012 L .971 -.692 L .787 -.398 L 1.143 -.341 L 1.512 -.476 L .84 -.18 L .953 .097 L .932 .156 L 1.842 .122 L .831 .083 L .694 .755 L .393 .406 L .699 .113 L 1.458 -.008 L .719 .083 L .85 -.004 L .875 .068 L .312 .114 L .576 .186 L .562 -.018 L .755 -.28 L .31 -.162 L .744 -.572 L .163 -.526 L -.116 -.204 L -.396 -.304 L -.409 -.86 L .098 -.293 L .905 -.839 L 1.269 -.96 L .84 .201 L 1.028 .098 L 1.036 .185 L 1.748 .328 L .702 .231 L .989 .317 L .767 .143 L .145 .204 L .004 .541 L .182 .481 L .408 .451 L .421 .333 L 1.643 .531 L .673 .113 L 2.48 -.538 L .796 -.077 L 1.172 .037 L 1.423 .022 L .769 .229 L 1.333 .75 L .623 .331 L 1.132 .313 L .812 .373 L 1.318 .254 L .905 .241 L .984 .082 L .739 .039 L 1.602 -.11 L 1.018 -.063 L .532 -.075 L .867 -.106 L 1.147 -.136 L .526 -.163 L .604 -.264 L .447 -.394 L .755 -.498 L 1.165 -.487 L .333 -.002 L .609 -.047 L .74 .156 L .751 .506 L .34 .129 L .86 .169 L 1.228 -.297 L .622 -.018 L .431 .168 L
406.183 86.551 N 1.051 -.494 L .485 -.089 L .574 .087 L .465 -.016 L .209 -.147 L .477 .098 L .407 .042 L .52 -.034 L -.025 -.157 L .307 .012 L .307 0 L .267 -.182 L .313 .242 L .173 -.121 L .228 .061 L .292 .375 L .535 -.109 L .754 .375 L -.11 .423 L -.172 .097 L .001 .338 L .672 -.024 L .344 .177 L .282 .365 L .038 .468 L -.422 .376 L -.225 -.072 L -.142 .08 L -.245 .147 L -.213 .322 L .017 .327 L .31 .204 L -.136 .348 L -.079 -.114 L -.694 .174 L -.127 -.228 L -.371 -.204 L -.341 -.192 L -.529 -.048 L .039 -.228 L -.146 -.18 L .119 -.373 L -.245 .072 L -.193 .313 L -.446 .035 L -.406 .075 L -.285 -.122 L .072 -.198 L -.091 -.175 L .159 -.241 L -.375 -.168 L -.576 -.048 L -.259 .012 L -.159 -.301 L -.518 .012 L -.194 -.133 L -.202 -.458 L -.153 -.17 L -.41 .208 L -.141 .071 L -.266 -.127 L -.311 -.335 L -.208 -.447 L
438.22 91.952 N .039 -.044 L .065 -.105 L .014 -.131 L .092 -.066 L .146 -.119 L .026 -.04 L .171 -.053 L .093 -.026 L .092 .053 L .132 .053 L .158 0 L .065 -.026 L .093 0 L .065 .026 L .065 .026 L .093 -.026 L .145 -.04 L .132 0 L .118 -.053 L .079 -.053 L .066 -.026 L .105 -.026 L .039 0 L .053 -.079 L .04 -.092 L .079 -.079 L .092 .026 L .105 -.04 L .145 -.066 L .053 -.105 L .053 -.079 L .026 -.132 L .026 -.092 L .053 -.092 L .118 -.013 L .105 -.013 L .132 -.079 L .119 -.053 L .118 -.092 L .053 -.079 L .132 -.066 L .065 -.04 L 442 89.998 l .145 .013 L .105 .026 L .066 -.04 L .065 -.066 L .071 .012 L .285 .041 L .03 .228 L .43 -.048 L .183 -.24 L .193 .016 L .062 -.112 L .261 -.024 L .194 .24 L .073 .169 L .331 -.025 L .066 .18 L -.026 .083 L .003 .204 L .389 -.083 L .18 .12 L .149 -.135 L .104 -.177 L .558 -.204 L .168 .056 L .483 -.046 L .46 .254 L .373 -.18 L .073 -.137 L .508 .041 L .561 -.076 L .129 .13 L .703 .186 L .104 .216 L .424 .101 L .831 .33 L -1.047 1.471 L -.629 .076 L -.437 -.143 L -.534 -.359 L -1.062 .035 L -.717 .047 L -1.024 .759 L 444.857 93 l -.59 -.072 L -.499 .061 L -.761 .134 L -.255 .001 L -.334 .568 L -1.651 -.036 L -.414 -.027 L -.617 -.17 L -.399 -.172 L -.245 .146 L -.761 -.547 L -.155 -.26 L .097 -.581 L -.053 -.093 L
442.391 98.111 N -.589 .203 L -.433 .031 L -.668 .047 L -.58 -.098 L -1.116 -.671 L -1.412 -.612 L -.215 -.197 L -.364 -.333 L -.304 -.59 L .346 -.299 L .154 -.294 L -.204 -.188 L .04 -.375 L .409 -.062 L .157 -.206 L -.136 -.196 L -.452 -.063 L .223 -.197 L .325 0 L .164 .134 L .701 -.054 L .019 -.367 L .636 -.291 L .245 -.146 L .399 .172 L .617 .17 L .414 .027 L 1.651 .036 L .334 -.568 L .255 -.001 L .761 -.134 L .499 -.061 L .59 .072 L .427 -.063 L 1.024 -.759 L .717 -.047 L 1.062 -.035 L .534 .359 L .437 .143 L .629 -.076 L .166 -.015 L .668 .301 L .554 .2 L .678 .387 L -.45 .338 L -1.125 .267 L -.581 .408 L -.968 1.451 L -.63 .84 L -.753 .567 L -.361 .16 L -.724 .047 L -.264 .103 L -.176 -.002 L -.907 -.067 L -.889 .077 L -1.535 .529 L
459.717 92.836 N .06 -.052 L .126 -.114 L .075 .063 L .126 0 L -.012 -.113 L .088 -.101 L .315 .114 L .126 -.051 L .265 .038 L .202 0 L .126 -.114 L .062 -.038 L .177 .025 L .177 -.051 L .139 -.025 L .088 .025 L .114 .051 L .05 -.025 L .126 -.025 L .038 .013 L .214 .088 L .14 .126 L .139 .05 L .151 .013 L .101 .063 L .05 .063 L .076 .076 L .101 -.013 L .126 .025 L .177 -.038 L .113 0 L .025 .063 L -.088 .101 L -.038 .05 L .101 -.038 L .089 .025 L 0 .076 L .062 .05 L .076 -.101 L .062 -.051 L .277 -.012 L .417 .075 L .05 .189 L .126 .189 L .215 .025 L .126 .025 L .062 -.101 L .14 .013 L .062 .126 L .076 .063 L .113 .025 L -.164 .151 L .126 .063 L -.051 .05 L -.024 .114 L 0 .189 L -.177 .139 L .05 .139 L .102 .139 L .139 .025 L .188 .101 L .089 .101 L .113 .088 L .088 -.051 L .102 -.05 L .113 0 L .038 .088 L .025 .101 L -.089 .075 L .013 .189 L -.113 .038 L .062 .114 L .127 -.038 L .037 .051 L -.037 .088 L -.051 .151 L .151 .038 L .151 .063 L .151 .126 L .075 0 L .177 .076 L .101 .063 L .051 .139 L .013 .126 L -.038 .101 L .025 .113 L -.101 .063 L -.013 .038 L .075 .05 L .101 .051 L .164 .126 L .126 .013 L -.075 .076 L -.038 .025 L -.227 0 L -.139 -.013 L -.038 .038 L -.038 .038 L -.176 -.025 L .037 -.189 L -.177 0 L -.101 .025 L -.013 .05 L -.075 .076 L -.076 .076 L -.126 -.164 L -.075 0 L -.089 -.063 L 0 -.075 L -.139 .012 L -.075 .038 L -.025 .076 L -.063 -.051 L -.101 -.038 L .013 .063 L 0 .088 L -.113 0 L -.063 -.013 L .013 -.214 L -.013 -.088 L -.113 -.025 L -.126 .088 L -.239 .025 L -.202 .151 L .063 .101 L .088 .151 L -.051 .101 L .114 .113 L .012 .088 L -.037 .063 L -.126 .114 L .062 .088 L .025 .088 L -.075 .076 L -.29 .063 L -.14 .013 L .013 .114 L -.024 .126 L -.089 .088 L -.088 .063 L -.089 .025 L -.075 .013 L -.051 .063 L -.126 .063 L -.025 .113 L .063 .113 L 0 .088 L -.088 .114 L -.189 0 L -.113 -.013 L -.126 -.013 L -.102 .025 L -.055 .077 L -.03 .004 L -.062 -.237 L -.218 -.106 L .16 -.071 L -.021 -.267 L -.104 -.561 L .323 -.978 L .027 -.404 L -.353 -.856 L -.604 -.286 L -1.037 -1.119 L 460.567 93 l -.626 -.191 L -.225 .028 L
445.722 97.573 N .176 .002 L .264 -.103 L .724 -.047 L .361 -.16 L .753 -.567 L .63 -.84 L .968 -1.451 L .581 -.408 L 1.125 -.267 L .45 -.338 L .136 -.085 L .787 .121 L .241 -.107 L .958 .193 L 1.115 .066 L .363 -.045 L .025 .231 L .327 -.004 L .188 .227 L .339 -.06 L .243 -.119 L .186 -.215 L 1.992 -.191 L .278 -.178 L .151 -.311 L .634 -.08 L .225 -.028 L 460.567 93 l .767 1.17 L 1.037 1.119 L .604 .286 L .353 .856 L -.027 .404 L -.323 .978 L .104 .561 L .021 .267 L -.16 .071 L .218 .106 L .062 .237 L .03 -.004 L .15 -.02 L .119 .249 L .398 .166 L .609 .047 L .033 -.189 L .457 0 L .665 -.261 L .706 .131 L .149 .079 L .062 .259 L -.293 .446 L -.27 .316 L -.436 .044 L -.382 .043 L -.382 .245 L -.515 .617 L -.252 .645 L -.096 .787 L -.044 .223 L -.671 -.12 L -1.346 -.336 L -.514 -.226 L -.295 -.042 L -.671 -.369 L -.562 -.04 L -.618 .218 L -1.904 .771 L -.38 .059 L -1.385 -.35 L -.3 -.013 L -.69 .261 L -.34 .031 L -1.151 -.395 L -.506 -.002 L -.771 .189 L -.266 .023 L -.048 -.189 L .234 -.318 L -.352 -.106 L -.392 -.204 L -.418 -.186 L -.146 -.33 L .32 -.201 L .351 .012 L -.114 -.13 L -.625 -.248 L -.253 .13 L -.215 .283 L -.147 .118 L -.414 -.239 L -.194 -.139 L -.594 -.059 L -.02 -.189 L -.234 0 L -.245 -.036 L -.052 -.165 L .178 -.094 L .271 -.071 L -.239 -.083 L -.183 -.059 L .124 -.146 L .19 -.127 L -.069 -.142 L -.306 -.118 L -.555 -.141 L -.712 -.471 L .058 -.088 L -.104 -.119 L .075 -.356 L -.202 -.036 L -.19 -.237 L -.569 -.178 L -.054 -.309 L
420.177 113.472 N -.274 -.042 L -.253 -.155 L -.367 -.325 L -.096 -.213 L .202 -.738 L .097 -.681 L -.046 -.583 L -.133 -.569 L -.503 -.44 L -.094 -.271 L .181 -.157 L .366 -.015 L .801 -.001 L .339 -.172 L .861 -.543 L .633 .625 L .451 .754 L -.014 .271 L -.204 .285 L -.145 .484 L .149 .894 L -.11 .525 L -.377 .695 L -.405 -.198 L -.52 .03 L -.143 .1 L -.149 .27 L -.248 .17 L h 433.783 118.446 m -.712 -.084 L -.902 -.607 L -.772 -.239 L -1.904 -.817 L -.833 -.126 L -.232 -.127 L -.173 -.283 L .139 -.34 L .328 -.34 L .264 -.1 L .629 .112 L .569 -.341 L .68 .424 L .403 .141 L .722 -.016 L 1.403 -.187 L 1.38 -.329 L .148 .085 L .043 .127 L -.112 .127 L -.536 .823 L -.153 .497 L .009 .382 L .411 .509 L -.179 .128 L -.43 .567 L -.188 .015 L h 431.244 98.829 m -.281 -.329 L -.242 -.027 L -.281 .196 L -.156 -.125 L -.47 -.071 L -.114 .32 L -.458 .054 L -1.001 .364 L .078 -.151 L -.452 .133 L -.063 .249 L -.157 .044 L -.01 .125 L .303 .08 L .021 .302 L .193 .119 L .253 .236 L -.104 .213 L -.449 .254 L .016 .272 L .143 .554 L .783 .814 L 2.008 .889 L .29 .357 L .134 .558 L .274 .557 L .395 .585 L .694 .57 L .254 .274 L .446 .195 L .041 .21 L .408 .167 L 1.17 .255 L 1.254 -.105 L .388 .141 L .024 .212 L -.465 .247 L -.258 .294 L .262 .213 L .954 .283 L 1.168 .411 L .829 .366 L 1.589 .739 L .058 .185 L .719 .458 L .31 .475 L -.198 .435 L -.152 .337 L -.455 -.281 L -.318 -.167 L -.109 -.486 L -.263 -.17 L -.512 -.099 L -.483 -.009 L -.439 -.236 L .086 -.217 L -.353 -.065 L -.301 .098 L -.232 .262 L -.259 .399 L -.273 .208 L .043 .271 L -.197 .303 L -.007 .298 L .76 .342 L .611 .271 L -.093 .314 L .03 .432 L .133 .142 L -.191 .238 L -.659 -.024 L -.41 .219 L -.202 .228 L .11 .595 L -.536 .303 L -.617 .866 L -.595 .048 L -.167 -.071 L -.184 -.14 L -.002 -.508 L .364 -.141 L .317 -.542 L -.236 -.184 L .361 -.249 L .361 .074 L .133 -.17 L -.077 -.34 L -.211 -.181 L -.206 -.924 L -.367 -.516 L -.15 -.607 L -.201 -.352 L -.334 .058 L -.187 .171 L -.899 -.496 L -.286 -.065 L .208 -.291 L -.092 -.398 L -.461 -.34 L -.909 .247 L .034 -.109 L .322 -.194 L -.276 -.27 L -.29 -.003 L -.42 .19 L -.242 -.512 L -.198 -.207 L -.124 -.228 L -.663 -.241 L -.505 -.027 L -.654 -.127 L -.745 -.355 L -.548 -.441 L -.959 -.612 L -1.036 -.826 L -.872 -.384 L -.805 -.67 L -.566 -.856 L -.434 -1.043 L -.347 -.443 L -.505 -.457 L -.483 -.243 L -1.188 -.341 L -.579 -.142 L -.5 .044 L -1.078 .647 L -.46 .359 L -.646 .173 L -.303 .043 L .146 -.469 L -.062 -.281 L -.849 .07 L -.754 -.391 L -.193 -.442 L .315 -.371 L .175 -.01 L -.135 -.331 L -.616 -.191 L -.352 -.358 L .437 -.186 L .183 .111 L .541 -.353 L .199 -.272 L -.43 -.192 L -.025 -.292 L -.532 -.344 L .624 -.301 L .599 .062 L .627 -.204 L .629 .168 L .275 -.16 L .349 -.432 L -.103 -.212 L .777 -.404 L .016 .415 L .534 .363 L .311 .071 L -.098 .182 L .385 .312 L .285 -.151 L .018 -.535 L .425 -.384 L -.019 -.333 L .371 -.081 L .143 .354 L .23 .142 L .216 -.03 L .071 -.122 L .469 -.05 L .244 .333 L .228 -.415 L -.244 -.131 L .081 -.273 L .283 -.091 L .176 .162 L .315 .051 L .038 -.192 L -.112 -.212 L .126 -.309 L .631 .171 L .597 .034 L .329 -.411 L .366 -.096 L .183 .083 L .445 -.11 L .301 .103 L .856 -.227 L .023 .363 L .318 .096 L .32 .391 L 1.311 .247 L .894 .082 L .478 .112 L .116 .199 L -.614 .303 L .098 .151 L .297 .002 L .187 .185 L -.367 .285 L .336 .089 L -.127 .361 L .36 .11 L .284 .198 L -.056 .214 L
430.73 96.731 N 1.04 .065 L .179 .107 L .612 -.009 L .287 .152 L .646 -.5 L .566 -.107 L .85 .08 L .298 -.196 L .89 .116 L -.082 -.393 L .693 -.157 L .304 .59 L .364 .333 L -.035 -.009 L -.1 -.073 L -.145 -.036 L -.172 0 L -.145 .009 L -.055 .063 L 0 .072 L .019 .09 L .009 .082 L -.063 .009 L -.136 -.009 L -.108 -.036 L -.091 .063 L -.045 .082 L -.081 .063 L -.082 .045 L -.081 .009 L -.163 .036 L -.117 .036 L -.108 .036 L -.055 .045 L -.153 -.009 L -.127 .072 L -.063 .054 L -.018 .082 L .036 .072 L .081 .054 L .063 .055 L .045 .045 L .019 .063 L .018 .09 L -.036 .108 L -.018 .063 L -.046 .1 L -.108 0 L -.081 -.009 L -.091 .027 L -.108 .009 L -.117 .054 L -.091 .018 L -.081 .027 L -.1 .045 L -.055 .063 L -.036 .027 L .055 .018 L .063 .009 L .026 .027 L .037 .072 L -.046 .063 L -.027 .009 L -.081 .027 L -.009 .045 L .045 .081 L 0 .072 L .045 .1 L -.054 .072 L -.063 -.018 L -.1 .045 L -.117 .018 L -.127 -.036 L -.063 -.027 L -.1 -.063 L -.099 0 L -.063 -.027 L -.118 -.045 L -.018 .045 L -.027 .045 L -.1 .027 L -.136 0 L -.054 -.045 L -.072 -.063 L -.127 -.018 L -.019 -.09 L -.026 -.018 L -.063 -.054 L -.055 -.027 L -.018 -.054 L -.01 -.054 L -.036 -.009 L -.063 .018 L -.036 .054 L -.009 .027 L -.054 .063 L -.019 .018 L -.018 .081 L -.063 .045 L -.046 .018 L -.062 .054 L -.036 .009 L -.254 0 L -.108 -.027 L -.108 .027 L -.145 .009 L -.1 -.009 L -.1 -.036 L -.045 -.019 L -.055 0 L 0 .037 L 0 .036 L -.045 .027 L -.045 .018 L -.136 -.009 L -.027 -.036 L -.108 .018 L -.019 .018 L -.136 .018 L -.063 .018 L -.126 .018 L -.272 -.063 L .428 -.077 L .113 -.16 L .056 -.214 L -.284 -.198 L -.36 -.11 L .127 -.361 L -.336 -.089 L .367 -.285 L -.187 -.185 L -.297 -.002 L -.098 -.151 L .614 -.303 L -.116 -.199 L
439.573 104.709 N -1.051 -.672 L -.185 -.222 L -.783 -.149 L -.203 -.159 L -.403 -.115 L -.683 .177 L -.326 -.486 L -1.112 -.627 L -.584 -.678 L .277 .007 L .608 .016 L -.583 -.221 L -.659 -.469 L -.183 -.407 L .086 -.452 L -.289 -.336 L -.646 -.418 L -.378 -.126 L -.258 .579 L -.142 .116 L .03 .15 L -.284 .106 L -.154 .248 L -.213 .053 L -.496 -.647 L -.063 -.286 L -.259 -.612 L .065 -.012 L .272 .063 L .126 -.018 L .063 -.018 L .136 -.018 L .019 -.018 L .108 -.018 L .027 .036 L .136 .009 L .045 -.018 L .045 -.027 L 0 -.036 L 0 -.037 L .055 0 L .045 .019 L .1 .036 L .1 .009 L .145 -.009 L .108 -.027 L .108 .027 L .254 0 L .036 -.009 L .062 -.054 L .046 -.018 L .063 -.045 L .018 -.081 L .019 -.018 L .054 -.063 L .009 -.027 L .036 -.054 L .063 -.018 L .036 .009 L .01 .054 L .018 .054 L .055 .027 L .063 .054 L .026 .018 L .019 .09 L .127 .018 L .072 .063 L .054 .045 L .136 0 L .1 -.027 L .027 -.045 L .018 -.045 L .118 .045 L .063 .027 L .099 0 L .1 .063 L .063 .027 L .127 .036 L .117 -.018 L .1 -.045 L .063 .018 L .054 -.072 L -.045 -.1 L 0 -.072 L -.045 -.081 L .009 -.045 L .081 -.027 L .027 -.009 L .046 -.063 L -.037 -.072 L -.026 -.027 L -.063 -.009 L -.055 -.018 L .036 -.027 L .055 -.063 L .1 -.045 L .081 -.027 L .091 -.018 L .117 -.054 L .108 -.009 L .091 -.027 L .081 .009 L .108 0 L .046 -.1 L .018 -.063 L .036 -.108 L -.018 -.09 L -.019 -.063 L -.045 -.045 L -.063 -.055 L -.081 -.054 L -.036 -.072 L .018 -.082 L .063 -.054 L .127 -.072 L .153 .009 L .055 -.045 L .108 -.036 L .117 -.036 L .163 -.036 L .081 -.009 L .082 -.045 L .081 -.063 L .045 -.082 L .091 -.063 L .108 .036 L .136 .009 L .063 -.009 L -.009 -.082 L -.019 -.09 L 0 -.072 L .055 -.063 L .145 -.009 L .172 0 L .145 .036 L .1 .073 L .035 .009 L .215 .197 L 1.412 .612 L 1.116 .671 L .58 .098 L .668 -.047 L .433 -.031 L .589 -.203 L .201 .142 L .056 .089 L .022 .112 L -.022 .078 L .045 .044 L .011 .067 L -.078 .056 L -.011 .146 L .078 .067 L .145 -.034 L .101 .034 L .045 .089 L -.078 .011 L -.056 -.022 L -.022 .078 L .033 .1 L -.045 .034 L -.044 .022 L .066 .111 L .168 -.022 L .033 .078 L .123 .1 L .122 0 L .101 0 L .09 .078 L .122 .011 L .134 0 L .012 .078 L -.033 .056 L -.135 -.011 L -.089 -.034 L -.067 .022 L -.078 -.011 L -.066 -.045 L -.056 -.011 L -.045 .011 L .033 .067 L -.101 .089 L -.078 0 L 0 .156 L .045 .067 L -.033 .078 L .022 .078 L .011 .078 L -.089 .033 L -.09 -.033 L -.056 .067 L .078 .089 L -.078 .011 L -.189 .022 L -.201 -.022 L -.145 -.123 L .056 -.101 L -.045 -.089 L -.123 -.011 L -.022 -.112 L -.145 -.056 L -.146 -.045 L -.101 .089 L -.1 -.011 L -.156 -.078 L -.067 -.022 L -.146 0 L -.156 -.045 L -.111 .067 L -.134 .045 L -.134 -.045 L -.111 -.067 L -.112 0 L -.122 .089 L -.168 .078 L -.156 -.067 L -.268 -.089 L -.179 .011 L -.156 .011 L -.189 -.056 L -.168 -.011 L -.156 -.089 L -.089 .078 L -.111 .022 L -.057 -.056 L -.234 -.078 L -.156 -.056 L -.134 -.045 L -.089 -.011 L -.134 .123 L -.112 -.011 L -.223 -.022 L -.168 -.033 L -.212 .022 L -.101 .111 L -.145 .145 L -.123 .201 L -.201 -.022 L -.256 -.134 L -.156 -.19 L -.101 -.111 L -.312 -.034 L -.123 .044 L -.089 .179 L -.045 .167 L .045 .134 L 0 .078 L .033 .212 L -.123 .067 L .022 .089 L .134 .078 L .09 .089 L .122 .034 L .101 .033 L .179 .179 L .146 .234 L .089 .134 L .022 .123 L .156 .111 L -.078 .056 L -.012 .1 L .022 .146 L .168 -.011 L .089 .111 L .056 .123 L .112 .111 L .167 .045 L .167 .033 L .369 .357 L .021 .167 L .078 .044 L .213 .078 L .379 .357 L .224 .123 L .223 .067 L .101 .056 L 0 .112 L .078 .279 L .201 .078 L .189 .167 L .146 .112 L .245 .123 L .067 .212 L -.284 .083 L h 439.792 104.833 m .132 -.118 L .134 .011 L .123 .034 L .045 .078 L .066 .089 L .146 .089 L .179 .078 L .212 .011 L .312 .257 L .045 .067 L .134 -.033 L .123 .022 L .089 .034 L .062 .063 L .005 .004 L -.022 .089 L .033 .078 L .082 .072 L .029 .092 L -.002 .1 L -.589 -.367 L -.549 -.371 L -.789 -.378 L
451.009 101.725 N -.328 .346 L -.383 .374 L -.18 .302 L .056 .271 L 1.326 1.122 L .028 .2 L -.302 .302 L -.762 .333 L -.246 .301 L -.008 .514 L -.013 .208 L -.058 -.017 L -.072 .029 L -.16 .022 L -.145 .021 L -.116 .022 L -.058 .015 L -.102 -.051 L -.087 .043 L -.088 .021 L -.102 -.043 L -.064 -.021 L -.131 .116 L -.087 .08 L -.152 -.015 L -.196 -.007 L -.064 .007 L -.175 -.043 L -.152 .087 L -.151 .102 L -.109 .058 L .059 .072 L -.029 .058 L -.116 0 L -.094 -.109 L -.131 -.058 L -.087 -.073 L -.08 .065 L -.116 .058 L -.246 .058 L -.225 .058 L -.088 .058 L -.058 .167 L .029 .13 L -.029 .072 L -.072 .087 L -.188 0 L -.14 -.049 L -.018 -.109 L -.733 -.866 L -.382 -.369 L -.058 -.004 L .109 -.286 L 0 -.067 L -.078 -.067 L -.101 0 L -.056 -.056 L .022 -.089 L .111 -.033 L .146 .011 L .167 .033 L .057 -.033 L .021 -.067 L .09 -.044 L .134 -.022 L .089 -.011 L -.011 -.089 L -.101 -.101 L -.167 -.067 L -.134 -.045 L -.057 -.044 L -.111 .022 L -.078 -.045 L -.033 -.067 L -.123 -.101 L -.078 -.1 L -.066 -.022 L -.067 .044 L -.078 -.011 L -.101 -.056 L -.279 -.078 L -.078 -.022 L -.056 -.033 L -.167 -.134 L -.101 -.146 L -.111 -.111 L -.168 -.078 L -.156 -.101 L -.223 -.056 L 0 -.101 L .179 -.101 L .089 -.111 L .078 -.011 L .067 .034 L .078 .044 L .1 .022 L .045 -.022 L .012 -.134 L .011 -.19 L -.134 -.145 L -.179 -.19 L -.212 -.134 L -.101 -.145 L .101 .022 L .101 .011 L .145 .056 L .224 .044 L .134 -.078 L .089 -.056 L .067 -.078 L -.089 -.044 L -.135 -.022 L -.089 -.089 L -.123 -.078 L -.156 -.089 L -.033 -.101 L -.045 -.1 L -.212 .011 L -.167 -.056 L -.078 -.1 L -.022 -.134 L .078 -.067 L 0 -.089 L -.033 -.1 L .056 -.056 L .066 -.078 L .156 -.156 L .156 -.223 L .034 -.167 L .056 -.1 L -.022 -.067 L -.123 -.022 L -.179 -.011 L -.156 0 L -.212 .112 L -.078 -.089 L .056 -.067 L .09 .033 L .089 -.033 L -.011 -.078 L -.022 -.078 L .033 -.078 L -.045 -.067 L 0 -.156 L .078 0 L .101 -.089 L -.033 -.067 L .045 -.011 L .056 .011 L .066 .045 L .078 .011 L .067 -.022 L .089 .034 L .135 .011 L .033 -.056 L -.012 -.078 L -.134 0 L -.122 -.011 L -.09 -.078 L -.101 0 L -.122 0 L -.123 -.1 L -.033 -.078 L -.168 .022 L -.066 -.111 L .044 -.022 L .045 -.034 L -.033 -.1 L .022 -.078 L .056 .022 L .078 -.011 L -.045 -.089 L -.101 -.034 L -.145 .034 L -.078 -.067 L .011 -.146 L .078 -.056 L -.011 -.067 L -.045 -.044 L .022 -.078 L -.022 -.112 L -.056 -.089 L -.201 -.142 L 1.535 -.529 L .889 -.077 L .907 .067 L .054 .309 L .569 .178 L .19 .237 L .202 .036 L -.075 .356 L .104 .119 L -.058 .088 L .712 .471 L .555 .141 L .306 .118 L .069 .142 L -.19 .127 L -.124 .146 L .183 .059 L .239 .083 L -.271 .071 L -.178 .094 L .052 .165 L .245 .036 L .234 0 L .02 .189 L .594 .059 L .194 .139 L .414 .239 L .147 -.118 L .215 -.283 L .253 -.13 L .625 .248 L .114 .13 L -.351 -.012 L -.32 .201 L .146 .33 L .418 .186 L
551.198 117.997 N -.351 -.48 L -.236 -.126 L -1.217 -.05 L -.646 -.011 L -.096 -.016 L .091 -.726 L -.062 -.503 L .157 -.251 L .062 -.22 L -.503 -.094 L -.534 -.283 L -.566 -.189 L -.471 .063 L -.378 -.251 L -1.132 -.597 L -.565 -.22 L -.943 -.597 L -.314 .063 L -1.006 -.503 L -.377 -.44 L -1.194 -.597 L -1.384 -.975 L 0 -.283 L -.188 -.44 L -.283 -.188 L -.408 -.597 L -.126 -.566 L -.22 -.377 L -.881 -.251 L -.188 .157 L -.439 .063 L -.535 -.126 L -.439 .032 L -.503 .094 L -.314 -.157 L -.691 -.314 L .094 -.22 L .157 -.188 L -.188 -.22 L .031 -.188 L .188 -.157 L -.439 -.283 L 0 -.22 L -.032 -.22 L -.251 -.22 L -.534 -.094 L -.692 -.095 L -.22 -.314 L -.346 -.032 L -.629 -.377 L -.472 -.095 L -.188 .063 L -.565 .157 L .251 .251 L .188 .377 L -.597 -.283 L -.283 0 L -.126 .126 L -.22 .346 L -.283 .126 L -.629 0 L -.503 .251 L -.503 .409 L -.062 .628 L .314 .409 L -.126 .314 L -1.383 .032 L -1.03 -.063 L .056 -8.174 L 5.658 -1.289 L 5.722 2.986 L 2.012 1.666 L 2.578 -.346 L 2.767 .188 L 1.1 -.409 L .724 .723 L .597 .22 L .66 1.006 L .66 -.314 L -.031 1.038 L -.188 .409 L .031 .754 L 1.006 0 L .221 .817 L .346 1.069 L .503 .063 L .691 -.032 L 1.006 -.094 L .346 0 L .44 .314 L .062 .283 L -.062 .283 L .44 .346 L .66 0 L .125 -.188 L -.157 -.409 L .504 -.44 L .439 -.188 L .221 -.472 L .282 -.188 L .943 -.377 L .755 -.189 L .534 -.471 L .346 -.283 L .22 -.063 L .283 .126 L .377 -.377 L .322 -.031 L .349 -.126 L .441 .246 L -.368 .172 L -.368 .171 L -.221 .049 L -.073 .196 L -.295 .049 L -.294 .172 L -.196 .147 L -.441 .295 L -.172 .098 L -.024 .123 L .294 .049 L .295 .074 L .146 .123 L .418 -.147 L .098 .221 L .172 .221 L .368 .27 L .589 0 L .393 0 L .049 -.393 L .221 .049 L .196 -.196 L .024 -.245 L .196 .098 L .196 .172 L .172 .294 L .049 .147 L .393 .024 L .147 -.024 L .073 .246 L .025 .098 L .343 -.025 L .319 .147 L .245 .196 L .516 .074 L .466 .024 L .172 .123 L -.49 .221 L -.197 .147 L -.221 .147 L -.49 -.024 L -.245 -.049 L .049 .171 L 0 .147 L -.319 0 L -.172 .049 L -.343 .196 L -.221 .196 L -.271 .049 L -.221 .196 L -.245 -.147 L -.319 -.098 L -.294 -.098 L -.221 .025 L -.246 .073 L -.318 -.073 L -.042 .098 L -.345 -.005 L -.409 .031 L -.188 -.283 L -.251 -.063 L -.126 -.188 L .251 -.126 L .409 -.346 L .188 -.22 L -.252 -.251 L -.439 -.377 L -.221 .251 L -.471 .346 L -.692 .188 L -.22 .157 L -.252 -.22 L -.22 -.157 L -.346 0 L .031 .22 L -.283 .314 L .189 .314 L -.032 .346 L -.062 .126 L -.472 -.095 L -.565 .095 L -.503 .094 L .251 .125 L .534 -.031 L .126 .094 L -.251 .063 L -.188 .063 L -.032 .346 L -.188 0 L -.251 .157 L -.063 .409 L -.282 .188 L -1.069 -.094 L -.629 -.126 L -.472 .283 L -.125 .471 L .251 .283 L .346 .188 L .157 .157 L .44 .032 L .346 0 L .126 .22 L -.126 .22 L -.031 .472 L .126 .409 L .471 .314 L .126 .283 L -.157 .22 L -.503 .346 L -.283 .503 L -.377 .377 L .063 .377 L -.375 .843 L
439.792 104.833 N -.113 -.054 L -.105 -.07 L .284 -.083 L -.067 -.212 L -.245 -.123 L -.146 -.112 L -.189 -.167 L -.201 -.078 L -.078 -.279 L 0 -.112 L -.101 -.056 L -.223 -.067 L -.224 -.123 L -.379 -.357 L -.213 -.078 L -.078 -.044 L -.021 -.167 L -.369 -.357 L -.167 -.033 L -.167 -.045 L -.112 -.111 L -.056 -.123 L -.089 -.111 L -.168 .011 L -.022 -.146 L .012 -.1 L .078 -.056 L -.156 -.111 L -.022 -.123 L -.089 -.134 L -.146 -.234 L -.179 -.179 L -.101 -.033 L -.122 -.034 L -.09 -.089 L -.134 -.078 L -.022 -.089 L .123 -.067 L -.033 -.212 L 0 -.078 L -.045 -.134 L .045 -.167 L .089 -.179 L .123 -.044 L .312 .034 L .101 .111 L .156 .19 L .256 .134 L .201 .022 L .123 -.201 L .145 -.145 L .101 -.111 L .212 -.022 L .168 .033 L .223 .022 L .112 .011 L .134 -.123 L .089 .011 L .134 .045 L .156 .056 L .234 .078 L .057 .056 L .111 -.022 L .089 -.078 L .156 .089 L .168 .011 L .189 .056 L .156 -.011 L .179 -.011 L .268 .089 L .156 .067 L .168 -.078 L .122 -.089 L .112 0 L .111 .067 L .134 .045 L .134 -.045 L .111 -.067 L .156 .045 L .146 0 L .067 .022 L .156 .078 L .1 .011 L .101 -.089 L .146 .045 L .145 .056 L .022 .112 L .123 .011 L .045 .089 L -.056 .101 L .145 .123 L .201 .022 L .189 -.022 L .078 -.011 L .212 -.112 L .156 0 L .179 .011 L .123 .022 L .022 .067 L -.056 .1 L -.034 .167 L -.156 .223 L -.156 .156 L -.066 .078 L -.056 .056 L .033 .1 L 0 .089 L -.078 .067 L .022 .134 L .078 .1 L .167 .056 L .212 -.011 L .045 .1 L .033 .101 L .156 .089 L .123 .078 L .089 .089 L .135 .022 L .089 .044 L -.067 .078 L -.089 .056 L -.134 .078 L -.224 -.044 L -.145 -.056 L -.101 -.011 L -.101 -.022 L .101 .145 L .212 .134 L .179 .19 L .134 .145 L -.011 .19 L -.012 .134 L -.045 .022 L -.1 -.022 L -.078 -.044 L -.067 -.034 L -.078 .011 L -.089 .111 L -.179 .101 L -.056 -.033 L -.156 .056 L -.112 -.022 L -.066 -.044 L -.112 .033 L -.078 .056 L .012 .078 L .089 .1 L .123 .167 L .056 .101 L -.056 .101 L -.111 0 L -.09 -.056 L -.056 -.089 L -.056 -.044 L -.123 -.011 L -.122 .056 L -.168 .078 L -.045 .101 L -.044 .089 L -.112 .101 L .034 .089 L .011 .1 L 442 104.458 l -.134 .011 L -.111 .022 L -.101 .089 L -.012 .134 L .012 .112 L .011 .145 L .012 .044 L .066 .112 L .078 .089 L .045 .101 L -.09 .089 L -.183 .108 L -.062 -.063 L -.089 -.034 L -.123 -.022 L -.134 .033 L -.045 -.067 L -.312 -.257 L -.212 -.011 L -.179 -.078 L -.146 -.089 L -.066 -.089 L -.045 -.078 L -.123 -.034 L -.134 -.011 L -.132 .118 L
450.198 105.998 N .013 -.208 L .008 -.514 L .246 -.301 L .762 -.333 L .302 -.302 L -.028 -.2 L -1.326 -1.122 L -.056 -.271 L .18 -.302 L .383 -.374 L .328 -.346 L .392 .204 L .352 .106 L -.234 .318 L .048 .189 L .266 -.023 L .771 -.189 L .506 .002 L 1.151 .395 L .34 -.031 L .69 -.261 L .3 .013 L 1.385 .35 L .38 -.059 L 1.904 -.771 L .618 -.218 L .562 .04 L .671 .369 L .295 .042 L .514 .226 L 1.346 .336 L .671 .12 L -.066 .335 L -.077 .258 L -.261 .086 L -.313 -.028 L -.339 .129 L -.327 .73 L -.039 .586 L -.075 .143 L -.404 .115 L -.338 .372 L -.017 .257 L .252 -.036 L .255 .224 L .033 .154 L .391 .375 L .01 .223 L -1.333 -.005 L -.527 -.111 L -.497 .045 L -.629 .374 L -.498 .445 L -.363 -.026 L -.344 .216 L .097 .327 L -.086 .257 L -1.117 .277 L -.388 .031 L -.619 -.21 L -1.473 -.505 L -.584 .06 L -.799 .261 L -1.855 .195 L -.09 .029 L -.047 -.199 L .104 -.3 L .006 -.499 L -.225 -.469 L -.358 -.383 L -.666 -.296 L -.134 -.213 L .007 -.106 L
381.009 107 N -.121 -.278 L .138 -.4 L .343 -.5 L -.358 -.471 L -.304 -.428 L -.514 -.07 L -.164 -.1 L -.053 -.329 L .163 -.243 L .409 -.272 L .365 -.101 L .563 -.03 L .634 -.03 L .133 -.172 L .068 -.415 L .535 -.273 L .763 .042 L 1.078 .37 L .763 .07 L .756 -.087 L .577 -.173 L .508 -.144 L .354 -.001 L .629 .285 L .694 .156 L .939 .084 L 1.538 .04 L .583 .027 L .957 .141 L .491 -.158 L .419 -.229 L .531 .027 L .891 .47 L .67 -.016 L .335 .062 L .472 .243 L .469 -.03 L .058 .122 L -.205 .243 L .094 .106 L .15 .03 L .112 -.106 L 1.088 .334 L .15 -.061 L .507 .395 L .056 -.076 L .262 .03 L .131 -.076 L .431 .152 L .028 .038 L .084 .114 L .767 -.03 L .037 .122 L .337 -.061 L .542 .015 L -.017 -.319 L .355 0 L 1.252 .304 L .091 .213 L .035 .289 L .187 .076 L .374 -.076 L .206 -.03 L .335 .091 L .036 .152 L .261 .015 L .395 -.167 L .427 .197 L .485 .015 L .039 -.136 L .75 -.137 L .334 .091 L -.001 .088 L -.001 .463 L .156 .1 L -.062 .485 L -1.112 .528 L -.95 .385 L -.267 .328 L -1.046 .198 L -.664 .116 L -.96 .301 L -.323 .326 L -.053 .2 L .261 .128 L -.088 .157 L -.628 .143 L -.594 .783 L -.886 .787 L -.096 .192 L -.18 .361 L -.245 .45 L .353 .827 L .072 .111 L .084 .13 L .648 .295 L .103 .185 L -.621 .327 L -.215 .105 L -.515 .252 L -.286 .479 L -.224 .085 L -.461 .926 L .155 .322 L -.257 .099 L -.992 .049 L -.581 .242 L -.425 .327 L -.274 .757 L -.663 .496 L -.258 -.213 L -.599 .028 L -.305 .27 L -.342 0 L -.121 -.113 L -3.282 .042 L -.69 .524 L -1.021 .17 L -.35 .382 L -.028 .283 L -.083 .085 L -.073 -.212 L -.068 -.014 L .005 .241 L -.389 .127 L -.421 -.142 L -.788 -.467 L -.224 -.382 L .036 -.262 L -.345 -.113 L -.125 -.213 L .175 -.163 L -.468 -.51 L -.702 -.284 L 385 117.498 l -.484 -.135 L -.586 .039 L .008 -.018 L .304 -.951 L .242 -.37 L .884 -.643 L -.408 -.31 L -.812 -.123 L .17 -.455 L .506 -.655 L .347 -.371 L -.163 -.198 L -.455 -.551 L -.488 -.494 L .288 -.129 L .482 -.045 L .458 -.229 L .043 -.199 L -.057 -.938 L .132 -.983 L -.072 -.456 L .051 -.442 L .084 -.072 L 1.234 -.506 L .288 -.216 L -.062 -.242 L -.842 -.495 L -.15 -.242 L -.272 -.227 L -.335 -.055 L -.531 .26 L 382.981 107 l -.531 -.439 L -.55 .188 L 381.009 107 l
489.685 103.693 N .112 -.309 L .26 -.166 L .284 .047 L .07 .047 L .402 .023 L .449 .023 L .283 .095 L .284 .142 L .188 .094 L .189 .047 L .331 0 L .213 0 L .212 .166 L .261 .095 L .307 .071 L .355 .047 L .307 0 L .426 -.095 L .544 0 L .401 .166 L .189 0 L .283 -.047 L .354 .166 L .095 .142 L .284 .213 L .52 .118 L .354 .071 L .236 .118 L .308 .119 L -.142 .118 L -.048 .118 L .261 .118 L .212 .071 L .261 -.118 L .283 0 L .166 -.166 L .094 -.095 L .213 -.071 L .354 0 L .261 .071 L .188 .142 L .142 -.166 L .095 -.071 L .118 0 L .236 .118 L .143 .094 L .212 0 L .189 .118 L .213 .166 L .378 0 L .354 .024 L .118 .142 L -.118 .189 L -.118 .307 L .354 .284 L .284 .166 L .26 .094 L .284 .047 L .236 -.023 L .236 .071 L .126 .189 L -.268 .189 L -.143 .142 L -.095 .071 L .143 .26 L .213 .307 L .614 .166 L .118 .213 L -.095 .331 L -.236 .095 L -.236 .047 L -.26 -.189 L -.143 -.071 L -.188 -.023 L -.284 .047 L -.638 -.189 L -.189 -.213 L -.331 -.189 L -.473 -.024 L -.236 0 L -.418 .308 L -.291 .094 L -.378 .047 L -.591 .095 L -.592 -.047 L -.401 .118 L -.426 .023 L -.308 .095 L -.307 -.024 L -.377 .108 L -.031 -.028 L -1.326 -1.018 L -.41 -.041 L -.761 .36 L -.226 .072 L -.491 -.068 L -1.212 -.082 L .083 -.065 L .322 -.585 L .032 -.143 L -.064 -.728 L -.331 -1.084 L -.206 -.399 L -.639 -.513 L -.341 -.128 L -.916 -.155 L -.679 -.271 L -.341 -.243 L
443.617 107.095 N -.065 -.035 L -.435 -.156 L -.017 -.15 L -.501 -.485 L -.848 -.3 L -.033 -.021 L .002 -.1 L -.029 -.092 L -.082 -.072 L -.033 -.078 L .022 -.089 L -.005 -.004 L .183 -.108 L .09 -.089 L -.045 -.101 L -.078 -.089 L -.066 -.112 L -.012 -.044 L -.011 -.145 L -.012 -.112 L .012 -.134 L .101 -.089 L .111 -.022 L .134 -.011 L .056 -.056 L -.011 -.1 L -.034 -.089 L .112 -.101 L .044 -.089 L .045 -.101 L .168 -.078 L .122 -.056 L .123 .011 L .056 .044 L .056 .089 L .09 .056 L .111 0 L .056 -.101 L -.056 -.101 L -.123 -.167 L -.089 -.1 L -.012 -.078 L .078 -.056 L .112 -.033 L .066 .044 L .112 .022 L .156 -.056 L .056 .033 L 0 .101 L .223 .056 L .156 .101 L .168 .078 L .111 .111 L .101 .146 L .167 .134 L .056 .033 L .078 .022 L .279 .078 L .101 .056 L .078 .011 L .067 -.044 L .066 .022 L .078 .1 L .123 .101 L .033 .067 L .078 .045 L .111 -.022 L .057 .044 L .134 .045 L .167 .067 L .101 .101 L .011 .089 L -.089 .011 L -.134 .022 L -.09 .044 L -.021 .067 L -.057 .033 L -.167 -.033 L -.146 -.011 L -.111 .033 L -.022 .089 L .056 .056 L .101 0 L .078 .067 L 0 .067 L -.109 .286 L -.361 -.022 L -.727 -.11 L -.273 .273 L -.279 .515 L .133 .427 L -.002 .342 L
558.52 110.652 N .042 -.098 L .318 .073 L .246 -.073 L .221 -.025 L .294 .098 L .319 .098 L .245 .147 L .221 -.196 L .271 -.049 L .221 -.196 L .343 -.196 L .172 -.049 L .319 0 L 0 -.147 L -.049 -.171 L .245 .049 L .49 .024 L .221 -.147 L .197 -.147 L .49 -.221 L -.172 -.123 L -.466 -.024 L -.516 -.074 L -.245 -.196 L -.319 -.147 L -.343 .025 L -.025 -.098 L -.073 -.246 L -.147 .024 L -.393 -.024 L -.049 -.147 L -.172 -.294 L -.196 -.172 L -.196 -.098 L -.024 .245 L -.196 .196 L -.221 -.049 L -.049 .393 L -.393 0 L -.589 0 L -.368 -.27 L -.172 -.221 L -.098 -.221 L -.418 .147 L -.146 -.123 L -.295 -.074 L -.294 -.049 L .024 -.123 L .172 -.098 L .441 -.295 L .196 -.147 L .294 -.172 L .295 -.049 L .073 -.196 L .221 -.049 L .368 -.171 L .368 -.172 L -.441 -.246 L -.349 .126 L -.044 -.273 L .393 -.442 L .318 -.368 L .736 -.123 L .663 -.098 L .883 .147 L .883 .245 L .688 .196 L .81 .123 L .344 .123 L -.024 -.442 L .245 -.736 L .466 -.368 L .688 -.123 L .589 .074 L .761 .27 L .735 .246 L .908 .196 L .54 .098 L .441 -.27 L .858 -.024 L .761 0 L .785 -.147 L .712 .221 L .662 .098 L 1.35 .024 L .662 -.074 L .981 .246 L .564 -.049 L .147 .344 L .27 .147 L .196 .27 L .663 0 L .466 .098 L .41 .375 L .031 .194 L -.051 .157 L -.325 .187 L -.97 .219 L -1.338 .349 L -.445 .145 L -.405 .301 L -.638 .701 L -.646 .345 L -.478 .102 L -.459 .017 L -1.248 -.235 L -.238 .03 L -.467 .472 L -.463 .784 L -.268 .243 L -.885 .132 L -.507 .145 L -.344 -.055 L -.183 -.567 L -.06 -.071 L -.359 .03 L -1.737 .734 L -1.422 .704 L -.274 .186 L -.129 .213 L -.139 .739 L -.196 -.073 L -.344 .098 L -.344 .171 L -.539 0 L -.663 -.073 L -.834 .221 L -.172 .147 L -.196 0 L -.172 -.319 L -.368 .024 L -.318 .172 L -.074 -.221 L -.049 -.172 L -.122 .024 L -.319 -.123 L -.049 -.147 L -.221 -.024 L -.442 .123 L -.343 .049 L .024 .221 L -.295 .049 L -.393 -.074 L -.073 -.196 L -.147 -.123 L -.368 -.098 L -.49 .147 L -.196 -.073 L -.688 .024 L -.564 0 L -.589 .024 L -.122 -.098 L -.049 -.147 L -.099 -.27 L .099 -.245 L .196 -.196 L .098 .221 L .196 -.074 L -.049 -.196 L .098 -.27 L .123 0 L .981 -.196 L .515 .147 L .516 .196 L .099 .172 L .196 0 L .024 -.246 L .441 -.196 L .302 -.147 L
685.343 114.455 N -.571 .678 L -.309 .115 L -.511 -.096 L -.579 -.068 L -.595 -.011 L -.315 .157 L -.633 .738 L -.283 .256 L -.235 .171 L -.268 -.206 L -.35 .34 L -.319 .199 L -.373 -.608 L -.398 -.112 L -.649 .78 L -.195 -.382 L -.232 -.254 L -.683 -.367 L -.169 -.453 L .095 -.312 L .429 -.411 L .754 -.229 L .056 -.269 L -.591 -.282 L .407 -.879 L .189 -.34 L -.199 -.269 L -.632 -.296 L -.139 0 L -.381 .029 L -.312 .143 L -.234 -.07 L -.52 -.368 L -.167 -.233 L .379 -.528 L .415 -.442 L .52 -.329 L 1.533 -.604 L 1.032 -.545 L .636 -.543 L .686 -1.027 L .386 -.13 L .448 -.017 L .273 .396 L .493 .253 L .508 .153 L .975 -.048 L .527 -.159 L -.046 -.113 L -.508 -.765 L .025 -.342 L .273 -.243 L .392 -.059 L .333 .126 L .452 .054 L .538 -.017 L .62 -.259 L .955 -.532 L .23 -.713 L .383 -.358 L .253 -.129 L .247 -.001 L .579 .68 L .298 .439 L .167 .393 L -1.356 .923 L -.408 .457 L -.112 .414 L .09 .427 L -.154 .456 L -.187 .868 L -.668 .115 L -.36 .229 L -.497 .385 L -.766 .641 L -.468 .214 L -.678 .03 L -.577 .199 L -.265 .228 L -.248 .312 L -.364 .893 L .284 .326 L 1.225 .847 L .419 .354 L
536.625 121.017 N -.078 -.028 L -.15 -.692 L -.01 -.565 L -.038 -.848 L -.185 -.211 L -.787 .075 L -.696 -.01 L -.655 -.506 L -1.803 -1.362 L -.597 -.336 L -.66 -.167 L -.5 -.054 L -.788 -.066 L -.822 -.335 L -.708 -.251 L -.402 -.437 L -1.055 -.107 L -.519 -.054 L -.343 .129 L -.517 .343 L -.333 .03 L -.78 -.038 L -.609 .032 L -.413 .144 L -.476 .328 L -.621 .654 L -.466 .3 L -.562 .13 L -.441 -.025 L -.066 -.376 L -.128 -.681 L -.106 -.447 L .128 -.298 L 0 -.383 L 0 -.532 L .106 -.191 L .106 -.298 L .085 -.234 L -.085 -.212 L -.256 -.128 L -.319 -.191 L -.213 -.255 L -.042 -.149 L -.171 0 L -.191 -.042 L -.361 -.106 L -.191 .192 L -.086 -.234 L .086 -.106 L .148 -.255 L .128 .106 L .383 -.042 L .426 .085 L .128 .021 L .043 -.128 L -.319 -.213 L -.256 -.021 L -.085 -.277 L .17 -.255 L .213 -.191 L -.404 -.042 L -.319 .085 L -.383 0 L -.319 -.085 L -.128 .149 L -.17 -.255 L -.149 -.298 L 0 -.34 L -.042 -.298 L .17 -.213 L .106 -.319 L .043 -.255 L .105 -.277 L .086 -.234 L .213 .34 L .063 .128 L .17 .17 L .405 -.085 L .383 .128 L .106 -.149 L -.021 -.149 L .106 0 L .148 .021 L .064 .319 L .106 .191 L .298 -.021 L .298 -.063 L .256 -.106 L .233 .085 L .192 .064 L .085 -.128 L -.149 -.191 L -.042 -.213 L .191 -.042 L .106 .149 L .233 .085 L .256 -.085 L .213 -.064 L .021 -.234 L -.171 -.341 L -.34 -.234 L -.532 -.319 L -.426 -.213 L -.063 -.319 L -.043 -.34 L -.213 -.17 L 0 -.213 L 0 -.213 L -.085 -.127 L -.554 -.064 L -.617 .085 L -.426 .021 L -.446 .127 L -.192 .277 L -.085 .298 L .128 .192 L -.063 .276 L -.086 .405 L .064 .234 L .021 .298 L -.256 -.553 L -.361 -.319 L .042 -.17 L -.063 -.191 L -.274 -.143 L .529 -.453 L .937 -.532 L 1.277 -.298 L .979 -.085 L .512 .234 L .681 .383 L .617 .383 L .256 .511 L .638 .703 L .447 .255 L .489 -.043 L .341 -.106 L .158 .014 L 1.03 .063 L 1.383 -.032 L .126 -.314 L -.314 -.409 L .062 -.628 L .503 -.409 L .503 -.251 L .629 0 L .283 -.126 L .22 -.346 L .126 -.126 L .283 0 L .597 .283 L -.188 -.377 L -.251 -.251 L .565 -.157 L .188 -.063 L .472 .095 L .629 .377 L .346 .032 L .22 .314 L .692 .095 L .534 .094 L .251 .22 L .032 .22 L 0 .22 L .439 .283 L -.188 .157 L -.031 .188 L .188 .22 L -.157 .188 L -.094 .22 L .691 .314 L .314 .157 L .503 -.094 L .439 -.032 L .535 .126 L .439 -.063 L .188 -.157 L .881 .251 L .22 .377 L .126 .566 L .408 .597 L .283 .188 L .188 .44 L 0 .283 L 1.384 .975 L 1.194 .597 L .377 .44 L 1.006 .503 L .314 -.063 L .943 .597 L .565 .22 L 1.132 .597 L .378 .251 L .471 -.063 L .566 .189 L .534 .283 L .503 .094 L -.062 .22 L -.157 .251 L .062 .503 L -.091 .726 L -1.454 -.244 L -.565 -.294 L -.445 .356 L -.417 .2 L -1.135 .205 L -.432 .809 L -.203 .991 L -.103 .128 L -.508 .243 L -1.985 .689 L -.568 .159 L -.119 .199 L -.001 .466 L -.22 .199 L -.636 .3 L -.534 .031 L -.573 -.082 L -.999 -.348 L -.937 -.193 L -.193 -.112 L
445.294 112.196 N -.07 -.115 L -.138 -.469 L -.5 -.452 L -.966 -.541 L .024 -.141 L .23 .062 L .023 -.237 L -.345 -.414 L .418 -.616 L -.182 -.22 L .188 -.563 L -.251 -.282 L .182 -.396 L .268 -.079 L -.027 -.45 L -.331 -.081 L -.2 -.107 L .002 -.342 L -.133 -.427 L .279 -.515 L .273 -.273 L .727 .11 L .361 .022 L .058 .004 L .382 .369 L .733 .866 L .018 .109 L .035 .218 L -.132 .429 L .074 .641 L .298 .668 L .722 .608 L -.09 .029 L -.449 .842 L -.402 .386 L -.496 .472 L -.583 .884 L
451.512 108.463 N -.507 .16 L -.532 .245 L -.622 -.054 L -.361 -.041 L -.365 .159 L -.395 .429 L -.606 .146 L -.809 .076 L -.722 -.608 L -.298 -.668 L -.074 -.641 L .132 -.429 L -.035 -.218 L .14 .049 L .188 0 L .072 -.087 L .029 -.072 L -.029 -.13 L .058 -.167 L .088 -.058 L .225 -.058 L .246 -.058 L .116 -.058 L .08 -.065 L .087 .073 L .131 .058 L .094 .109 L .116 0 L .029 -.058 L -.059 -.072 L .109 -.058 L .151 -.102 L .152 -.087 L .175 .043 L .064 -.007 L .196 .007 L .152 .015 L .087 -.08 L .131 -.116 L .064 .021 L .102 .043 L .088 -.021 L .087 -.043 L .102 .051 L .058 -.015 L .116 -.022 L .145 -.021 L .16 -.022 L .072 -.029 L .058 .017 L -.007 .106 L .134 .213 L .666 .296 L .358 .383 L .225 .469 L -.006 .499 L -.104 .3 L .047 .199 L
383.93 117.402 N -.249 .101 L -.517 .291 L -.439 .052 L -.548 -.178 L -.58 0 L -.28 -.073 L -.719 .292 L -.058 -.177 L .389 -1.012 L -.021 -.856 L -.182 -.115 L .244 -.542 L -.054 -.397 L .13 -.114 L -.144 -.141 L -.375 .085 L -.476 .097 L -.108 -.449 L .48 -.052 L .283 -.22 L -.042 -.17 L -.178 -.226 L -.3 .417 L -.413 .136 L -.357 -.042 L -.059 -.188 L .198 -.397 L .138 -.616 L -.039 -.303 L .258 -.114 L .403 -.503 L .45 -1.098 L -.12 -.115 L .612 -1.783 L -.35 -.924 L -.007 -.42 L -.146 -.378 L .255 -.271 L .891 -.251 L .55 -.188 L .531 .439 L 1.822 .047 L .531 -.26 L .335 .055 L .272 .227 L .15 .242 L .842 .495 L .062 .242 L -.288 .216 L -1.234 .506 L -.084 .072 L -.051 .442 L .072 .456 L -.132 .983 L .057 .938 L -.043 .199 L -.458 .229 L -.482 .045 L -.288 .129 L .488 .494 L .455 .551 L .163 .198 L -.347 .371 L -.506 .655 L -.17 .455 L .812 .123 L .408 .31 L -.884 .643 L -.242 .37 L -.304 .951 L -.008 .018 L
500.121 117.572 N -.407 -.016 L -.433 .388 L -.164 .126 L -.318 -.105 L -.102 -.269 L .03 -.259 L -.274 -.151 L -.366 -.082 L -.244 .234 L -.343 -.023 L -.811 -.153 L -.364 .032 L -.304 -.16 L -.437 .094 L -.266 .143 L -.23 .043 L -.064 -.245 L -.207 -.023 L -.24 .292 L -.693 .304 L -1.185 .224 L -.711 -.039 L -.747 -.123 L -.439 .073 L -1.498 .673 L -.567 .13 L -1.104 .176 L -.556 -.153 L -1.532 -.444 L -.278 .03 L -.929 .373 L -.746 .075 L -.575 -.025 L -.777 -.166 L -.222 .001 L -.142 -.035 L -.055 .319 L .102 .452 L .243 .423 L -.627 .127 L -.156 .374 L -.2 .169 L -.171 -.041 L -.114 .127 L -.39 -.125 L -.311 .001 L -.245 -.459 L -.119 -.093 L .097 -.175 L .242 -.197 L .617 -.403 L .021 -.175 L -.049 -.134 L -.279 -.28 L -.146 -.053 L -.487 .368 L -.23 .041 L -.137 .064 L .092 .041 L -.118 .216 L -.172 .023 L -.063 -.047 L -.076 .088 L -.297 .058 L -.332 -.222 L -.447 -.198 L -.461 -.157 L -.395 .046 L -.849 .548 L -.337 .286 L .006 .204 L -.141 .046 L -.122 .07 L -.005 .082 L -.179 -.169 L -.604 .206 L -.689 .185 L -.594 -.013 L -.587 -.07 L -.678 -.267 L -.963 -.819 L -1.181 -.479 L -1.034 -.182 L -.692 .072 L -.119 .255 L -.097 .609 L -.053 .411 L -.173 .156 L -.256 0 L -.253 -.155 L -1.12 .243 L -.423 -.027 L -.386 -.183 L -.657 -1.159 L -.42 .354 L -.764 -.451 L -.451 .057 L -.562 .412 L -.227 -.382 L .066 -.127 L .242 -.17 L -.116 -.17 L -.989 -.012 L -.545 -.013 L -.088 -.269 L .571 -.199 L -.074 -.241 L -.284 -.198 L -.454 -.07 L -.084 -.297 L .041 -.34 L .087 -.284 L -.089 -.255 L -.396 -.126 L -.627 -.353 L -.371 .086 L -.265 -.084 L -.004 -.255 L .171 -.501 L .131 .059 L .478 .311 L .567 -.271 L -.396 -.283 L .021 -.124 L -.296 -.128 L .03 -.128 L .571 -.159 L .152 -.113 L -.068 -.142 L -.149 -.088 L -.337 -.035 L .01 -.187 L .18 -.07 L -.163 -.164 L -.198 -.117 L -.009 -.152 L -.227 -.012 L .263 -.181 L .296 -.275 L .161 -.035 L .07 -.16 L -.341 -.042 L -.573 .12 L -.905 .164 L -.166 -.035 L .046 -.33 L .127 -.125 L -.003 -.199 L -.029 -.286 L .13 -.264 L .299 .012 L .184 -.41 L .175 -.023 L .63 -.422 L .514 .012 L .133 -.129 L .479 -.047 L .128 .211 L .268 .102 L .169 .028 L .529 .022 L .147 -.129 L -.067 -.129 L -.269 -.129 L .286 -.094 L .324 .036 L .117 .082 L -.219 .223 L .213 -.026 L 1.053 -.073 L .619 .042 L .379 .046 L .279 .047 L .155 -.176 L -.086 -.094 L -.468 -.035 L -.212 -.118 L .275 -.212 L 1.386 -.151 L .417 -.012 L .377 -.117 L -.442 -.012 L -.592 .023 L -.215 0 L -.068 -.146 L -.611 -.382 L .325 -.528 L .926 .14 L 1.244 .048 L .264 -.117 L 1.086 .321 L 1.051 -.031 L .414 -.243 L -.041 -.27 L .624 -.244 L .455 -.214 L 1.218 -.573 L .598 -.215 L 1.039 -.23 L .889 -.073 L .758 .07 L .905 .126 L .798 .041 L .753 -.372 L .216 .527 L .416 .298 L .278 .099 L .592 .013 L .622 -.144 L .453 .74 L .492 .255 L .574 -.172 L .391 .056 L .968 .582 L 1.265 .04 L 1.094 .197 L .749 -.001 L 1.084 -.272 L .514 -.044 L .651 .141 L .764 .098 L .787 -.016 L .554 -.144 L 1.518 -.573 L .424 -.335 L 1.212 .082 L .491 .068 L .226 -.072 L .761 -.36 L .41 .041 L 1.326 1.018 L .031 .028 L .795 .722 L .026 .199 L -.421 .813 L .033 .412 L .284 .211 L 1.413 .12 L .492 .451 L -.072 .211 L -.409 -.023 L -.231 .141 L -.009 .433 L -.584 .267 L -.039 .27 L .264 .67 L -.122 .375 L .224 .492 L .09 .117 L .106 -.105 L .288 .203 L .039 .207 L -.229 .281 L -.287 .535 L -.06 .128 L .213 .14 L .424 .111 L -.145 .245 L .099 .421 L .42 .374 L .275 .035 L .023 .308 L h 462.617 106.804 m .241 .211 L -.019 .287 L .115 .285 L .077 .071 L .593 .355 L .819 .241 L .605 .155 L .152 .121 L 464.943 109 l -.304 .166 L -.515 -.072 L -.94 -.246 L -.326 .07 L -.209 .152 L -1.019 -.012 L -.357 .384 L -.109 .273 L -.833 .316 L -.612 .282 L -.222 .258 L -.307 .152 L -.268 .293 L -.255 .082 L .164 -.258 L .019 -.141 L -.062 -.176 L .584 -.293 L .22 -.141 L -.226 -.191 L -.082 .015 L -.653 -.056 L -.229 -.148 L .326 -.546 L .387 -.558 L .678 -.631 L -.127 -.227 L -.427 -.197 L -.105 0 L .498 -.445 L .629 -.374 L .497 -.045 L .527 .111 L 1.333 .005 L
509.077 114.955 N -.72 -.317 L -.268 .016 L -.356 -.433 L -.374 -.105 L -.13 -.363 L .532 -.27 L .095 -.222 L -.43 -.176 L -.027 -.188 L .63 -.129 L .094 -.155 L -.061 -.113 L -.487 -.21 L -.351 -.281 L -.306 -.166 L -.456 .234 L -1.058 .492 L -.374 .445 L -.642 .188 L -.254 .255 L -.014 -.027 L .094 -.118 L -.094 -.213 L -.189 -.071 L .26 -.095 L .166 -.047 L -.261 -.189 L -.236 -.236 L .236 -.118 L .095 -.189 L -.283 -.047 L -.354 -.024 L -.284 -.118 L -.213 -.212 L -.236 -.024 L -.26 -.354 L -.283 -.142 L -.048 -.094 L .166 0 L .378 0 L .165 -.236 L 0 -.236 L -.213 -.024 L -.188 -.142 L -.544 -.331 L -.283 -.354 L .047 -.284 L .402 -.142 L -.119 -.236 L -.212 -.166 L -.426 -.071 L -.284 -.095 L .071 -.094 L .071 -.118 L -.284 -.095 L -.087 -.212 L .418 -.308 L .236 0 L .473 .024 L .331 .189 L .189 .213 L .638 .189 L .284 -.047 L .188 .023 L .143 .071 L .26 .189 L .236 -.047 L .236 -.095 L .095 -.331 L -.118 -.213 L -.614 -.166 L -.213 -.307 L -.143 -.26 L .095 -.071 L .143 -.142 L .268 -.189 L .229 -.023 L .023 .166 L .213 -.047 L .189 0 L .142 .189 L .473 .284 L .095 .118 L .118 0 L .283 .284 L 0 .308 L .591 .094 L .449 .142 L .379 -.047 L .165 -.213 L .308 -.331 L .283 -.094 L .496 -.284 L .292 -.449 L .465 .331 L .236 .378 L .26 .189 L .284 .307 L .095 .52 L .142 .236 L .283 .26 L .284 .165 L 0 .166 L .449 .236 L .473 -.047 L .378 .071 L .284 .166 L .236 .189 L .095 .189 L 0 .142 L -.355 -.142 L -.401 -.047 L -.213 0 L -.26 .047 L -.142 .118 L -.402 .071 L -.213 .142 L -.047 .189 L -.023 .473 L -.118 .26 L -.095 .236 L -.095 .378 L .213 .236 L -.023 .189 L -.237 -.071 L -.094 .095 L -.071 .331 L -.071 .26 L -.118 -.047 L -.094 -.236 L -.143 -.095 L -.165 .095 L -.047 .307 L .07 .166 L -.118 .118 L -.118 .095 L .095 .26 L -.363 .91 L h 499.844 111.738 m .709 .061 L .142 -.047 L .26 -.071 L .236 .236 L .071 .166 L .378 .142 L .213 .071 L .308 -.118 L .52 0 L -.071 .213 L .024 .236 L .118 .023 L .331 .166 L -.071 .236 L .421 .763 L -.009 .001 L -.253 -.133 L -.416 .038 L -.512 -.025 L -.421 -.125 L -.335 -.211 L -.294 -.402 L -.551 -.223 L -.281 -.417 L -.265 -.381 L -.252 -.197 L
455.452 122.442 N .049 -.209 L -.057 -.128 L -.812 -.256 L -.691 -.006 L -.506 -.116 L -.484 .017 L -.121 -.046 L -.103 -.093 L .139 -.56 L .315 -.005 L -.005 -.088 L -.009 -.122 L .069 -.07 L .083 .157 L .021 .146 L .303 .021 L .172 .055 L .184 -.076 L -.014 -.082 L .108 -.029 L .157 .105 L -.037 .093 L -.099 .006 L -.04 .053 L .088 .023 L .144 .035 L .094 .046 L .021 .128 L .353 .041 L .846 -.122 L .509 .016 L .035 .13 L .192 .035 L .608 .064 L .307 .051 L .358 -.121 L .09 .05 L -.101 .312 L .163 .11 L .105 0 L .325 -.169 L .286 -.058 L .078 .052 L .154 -.07 L .232 -.146 L -.083 .187 L .015 .186 L -.183 .268 L -.582 -.046 L -.349 .081 L -.335 -.017 L -1.994 .169 L h 445.294 112.196 m .583 -.884 L .496 -.472 L .402 -.386 L .449 -.842 L .09 -.029 L .809 -.076 L .606 -.146 L .395 -.429 L .365 -.159 L .361 .041 L .622 .054 L .532 -.245 L .507 -.16 L .09 -.029 L 1.855 -.195 L .799 -.261 L .584 -.06 L 1.473 .505 L .619 .21 L .388 -.031 L 1.117 -.277 L .086 -.257 L -.097 -.327 L .344 -.216 L .363 .026 L .105 0 L .427 .197 L .127 .227 L -.678 .631 L -.387 .558 L -.326 .546 L -.062 -.407 L -.794 -.056 L -.743 -.041 L -.566 -.125 L -.062 -.144 L -.459 .186 L -.248 .123 L -.403 .012 L -.031 -.247 L -.335 .029 L -.301 .314 L -.431 .186 L -.31 .03 L -.306 -.159 L -.252 .07 L -.004 .133 L .169 .185 L .169 .34 L .308 .059 L .826 .609 L -.166 .07 L -.369 -.258 L -.015 -.105 L -.276 -.082 L -.331 -.105 L -.116 .099 L -.211 .007 L .069 .129 L -.016 .129 L .338 .164 L .145 -.012 L .114 .234 L -.03 .129 L -.245 .023 L -.445 -.457 L -.341 -.141 L -.207 -.059 L -.128 -.012 L .003 .094 L -.075 .035 L .138 .164 L .102 .105 L .154 .141 L .193 .059 L .153 .035 L .103 .094 L -.093 .058 L -.494 -.046 L -.253 -.035 L .035 -.176 L -.137 -.293 L -.164 -.188 L -.401 -.108 L -.472 -.373 L .258 -.118 L .025 -.136 L -.053 -.122 L -.182 -.035 L -.153 .199 L -.465 .176 L .245 .224 L -.25 .371 L -.05 .249 L .13 .121 L .065 .172 L .311 .338 L .133 .036 L .131 .479 L .579 .421 L .359 .467 L -.172 .14 L -.237 .082 L .106 -.187 L -.121 -.187 L -.142 -.128 L -.139 -.035 L -.151 -.047 L -.29 .175 L .102 .188 L .153 .081 L .08 .316 L -.193 .187 L -.652 .141 L .248 .046 L .27 .14 L .391 .058 L .188 .222 L .257 -.012 L .155 .012 L .048 .126 L .367 .269 L .306 .014 L .138 .292 L .282 .012 L .27 0 L .348 .303 L .015 .128 L -.193 .082 L .238 .782 L -.153 .175 L -.185 0 L -.226 -.385 L -.222 -.047 L -.207 -.278 L -.101 -.142 L -.17 0 L -.496 .14 L -.479 .105 L -.184 .128 L .315 .093 L .013 .188 L .007 .291 L .229 .117 L .153 -.026 L .225 -.079 L -.021 .198 L .235 .175 L -.519 .093 L .002 .117 L -.169 .062 L -.309 -.086 L .121 -.21 L -.186 -.086 L -.508 -.056 L -.158 -.092 L -.008 .206 L .194 .453 L .193 .17 L -.045 .163 L .209 .204 L .213 .96 L -.688 -.31 L -.331 .071 L -.298 .439 L -.442 -.735 L -.46 -.367 L -.452 .44 L -.428 -.353 L -.127 -.297 L .212 -.425 L -.028 -.241 L -.215 -.269 L -.491 -.424 L -.167 -.226 L .017 -.17 L .471 -.61 L .609 .098 L .425 -.298 L .202 .042 L 1.668 .663 L .337 -.1 L .483 -.355 L -.266 -.049 L -.27 -.056 L -1.204 -.493 L -1.127 -.083 L -.367 .058 L -.66 .058 L -.427 .143 L -.89 -1.118 L .269 -.1 L .253 .056 L .218 -.114 L .122 -.185 L -.339 -.24 L -.235 .114 L -.496 -.042 L -1.035 -.721 L -.199 -.325 L
504.136 113.458 N -.327 .328 L -.377 .03 L -.421 -.763 L .071 -.236 L -.331 -.166 L -.118 -.023 L -.024 -.236 L .071 -.213 L -.52 0 L -.308 .118 L -.213 -.071 L -.378 -.142 L -.071 -.166 L -.236 -.236 L -.26 .071 L -.142 .047 L -.709 -.061 L -.492 -.451 L -1.413 -.12 L -.284 -.211 L -.033 -.412 L .421 -.813 L -.026 -.199 L -.795 -.722 L .377 -.108 L .307 .024 L .308 -.095 L .426 -.023 L .401 -.118 L .592 .047 L .591 -.095 L .378 -.047 L .291 -.094 L .087 .212 L .284 .095 L -.071 .118 L -.071 .094 L .284 .095 L .426 .071 L .212 .166 L .119 .236 L -.402 .142 L -.047 .284 L .283 .354 L .544 .331 L .188 .142 L .213 .024 L 0 .236 L -.165 .236 L -.378 0 L -.166 0 L .048 .094 L .283 .142 L .26 .354 L .236 .024 L .213 .212 L .284 .118 L .354 .024 L .283 .047 L -.095 .189 L -.236 .118 L .236 .236 L .261 .189 L -.166 .047 L -.26 .095 L .189 .071 L .094 .213 L -.094 .118 L .014 .027 L
566.651 117.4 N -.565 -.153 L -.496 -.054 L -.264 -.151 L -.564 .227 L -.974 .147 L -.137 -.059 L .129 -.176 L -.198 -.077 L -.678 .03 L -.739 .315 L -.592 .486 L -.589 .064 L -.745 .495 L -.351 .03 L -.368 -.026 L -.128 -.084 L -.164 -.409 L -.199 -.521 L .185 -.444 L .099 -.775 L .029 -.255 L -.17 -.187 L -.484 .093 L .156 -.597 L -.576 -.45 L -.153 -.056 L -.384 .016 L -.286 .162 L -.134 .363 L -.435 .428 L -.049 .425 L .006 .255 L -.208 .228 L -.442 .158 L -.133 -.013 L -.587 -.152 L -.292 .058 L -.073 .185 L .007 .311 L -.3 .313 L -.21 .128 L -.381 .016 L -.63 -.237 L -.325 .001 L -.581 .286 L -.58 .343 L -.485 .144 L -.245 -.041 L -.129 -.141 L -.04 -.055 L .375 -.843 L -.063 -.377 L .377 -.377 L .283 -.503 L .503 -.346 L .157 -.22 L -.126 -.283 L -.471 -.314 L -.126 -.409 L .031 -.472 L .126 -.22 L -.126 -.22 L -.346 0 L -.44 -.032 L -.157 -.157 L -.346 -.188 L -.251 -.283 L .125 -.471 L .472 -.283 L .629 .126 L 1.069 .094 L .282 -.188 L .063 -.409 L .251 -.157 L .188 0 L .032 -.346 L .188 -.063 L .251 -.063 L -.126 -.094 L -.534 .031 L -.251 -.125 L .503 -.094 L .565 -.095 L .472 .095 L .062 -.126 L .032 -.346 L -.189 -.314 L .283 -.314 L -.031 -.22 L .346 0 L .22 .157 L .252 .22 L .22 -.157 L .692 -.188 L .471 -.346 L .221 -.251 L .439 .377 L .252 .251 L -.188 .22 L -.409 .346 L -.251 .126 L .126 .188 L .251 .063 L .188 .283 L .409 -.031 L .345 .005 L -.302 .147 L -.441 .196 L -.024 .246 L -.196 0 L -.099 -.172 L -.516 -.196 L -.515 -.147 L -.981 .196 L -.123 0 L -.098 .27 L .049 .196 L -.196 .074 L -.098 -.221 L -.196 .196 L -.099 .245 L .099 .27 L .049 .147 L .122 .098 L .589 -.024 L .564 0 L .688 -.024 L .196 .073 L .49 -.147 L .368 .098 L .147 .123 L .073 .196 L .393 .074 L .295 -.049 L -.024 -.221 L .343 -.049 L .442 -.123 L .221 .024 L .049 .147 L .319 .123 L .122 -.024 L .049 .172 L .074 .221 L .318 -.172 L .368 -.024 L .172 .319 L .196 0 L .172 -.147 L .834 -.221 L .663 .073 L .539 0 L .344 -.171 L .344 -.098 L .196 .073 L -.011 .069 L .023 1.031 L -.207 .223 L .077 .305 L .325 .394 L .463 -.045 L .229 -.162 L .22 .06 L .692 .039 L .273 .154 L .295 .494 L -.009 .284 L .028 .246 L .152 .012 L .049 .123 L -.126 .428 L .245 .237 L -.152 .36 L .2 .163 L -.181 .185 L -.08 .249 L -.354 .136 L
500.121 117.572 N -.023 -.308 L -.275 -.035 L -.42 -.374 L -.099 -.421 L .145 -.245 L -.424 -.111 L -.213 -.14 L .06 -.128 L .287 -.535 L .229 -.281 L -.039 -.207 L -.288 -.203 L -.106 .105 L -.09 -.117 L -.224 -.492 L .122 -.375 L -.264 -.67 L .039 -.27 L .584 -.267 L .009 -.433 L .231 -.141 L .409 .023 L .072 -.211 L .252 .197 L .265 .381 L .281 .417 L .551 .223 L .294 .402 L .335 .211 L .421 .125 L .512 .025 L .416 -.038 L .253 .133 L .009 -.001 L .377 -.03 L .327 -.328 L .254 -.255 L .642 -.188 L .374 -.445 L 1.058 -.492 L .456 -.234 L .306 .166 L .351 .281 L .487 .21 L .061 .113 L -.094 .155 L -.63 .129 L .027 .188 L .43 .176 L -.095 .222 L -.532 .27 L .13 .363 L .374 .105 L .356 .433 L .268 -.016 L .72 .317 L .015 .007 L -.05 .707 L -.143 .581 L .205 .48 L .494 .252 L .925 .235 L .827 .052 L .424 .097 L .162 .282 L .312 .451 L .687 .463 L 1.902 .513 L .841 .052 L .438 -.059 L 1.354 -.262 L 1.192 -.148 L 1.469 -.079 L .41 -.229 L .185 -.354 L -.131 -.905 L .015 0 L .441 .025 L .562 -.13 L .466 -.3 L .621 -.654 L .476 -.328 L .413 -.144 L .609 -.032 L .78 .038 L .333 -.03 L .517 -.343 L .343 -.129 L .519 .054 L 1.055 .107 L .402 .437 L .708 .251 L .822 .335 L .788 .066 L .5 .054 L .66 .167 L .597 .336 L 1.803 1.362 L .655 .506 L .696 .01 L .787 -.075 L .185 .211 L .038 .848 L .01 .565 L .15 .692 L .078 .028 L -.145 .241 L -.084 .339 L -.246 .807 L -.49 1.272 L -.222 .297 L -.596 .384 L -.016 .141 L .119 .663 L .096 .098 L .738 .235 L .026 .183 L -.661 .935 L -.034 .155 L .254 1.085 L .167 1.283 L .143 .775 L .191 .21 L .209 .041 L 1.198 .275 L .401 .167 L .144 .366 L .046 .437 L -.425 .553 L -.853 .795 L -.853 1.034 L .802 1.083 L .71 1.068 L .353 .464 L .695 .391 L 1.144 .388 L .409 .224 L .168 .38 L .111 1.34 L .185 .394 L .652 .053 L .186 .281 L -.036 .974 L -.188 .255 L -.209 .072 L -1 .077 L -.697 .258 L -.794 .47 L -.285 .383 L -.31 .792 L -.049 .354 L -.182 .954 L -.502 .028 L -1.079 -.153 L -.236 -.197 L -.605 -.253 L -.403 -.056 L -1.43 .003 L -.783 -.041 L -.602 .072 L -.475 -.38 L -.163 -.126 L -.835 -.026 L -.576 .001 L -.465 .014 L -.212 -.239 L -.756 -.125 L -.305 -.183 L -.162 -.014 L -.021 -.5 L -.295 -.128 L -.103 -.514 L -.292 -.349 L -.013 -.639 L -.309 -.493 L -.237 .012 L -.035 -.181 L -.526 -.126 L -.807 -.013 L -.374 .017 L -.209 .222 L -.329 .018 L -.517 .075 L -.188 .364 L -.538 .138 L -.383 .443 L -.368 .283 L -.253 .043 L -1.292 -.689 L -.958 -.104 L -.562 -.359 L -1.088 -.317 L -.247 -.301 L -.324 -.282 L -.497 -.592 L -.997 -.436 L -.584 -.083 L -.194 -.028 L -.58 -.465 L -.596 -1.058 L -.635 -1.114 L -.209 -.268 L .005 -.593 L -.767 -.761 L -.506 -.719 L -.921 .143 L -.46 -.042 L -.13 -.126 L -.291 -.056 L -.191 -.268 L -.029 -.565 L -.448 .1 L -.166 .099 L -.32 .678 L -.195 .184 L -.355 .012 L -.014 -.12 L -.351 -.224 L -.686 -.546 L .064 -.212 L -.007 -.395 L -.164 -.465 L -.215 -.013 L -.551 .003 L -.034 -.325 L .055 -.579 L .197 -.622 L .014 -.508 L -.112 -.239 L -.29 -.28 L -.774 -.603 L -.436 -.209 L -1.242 -.925 L -.533 -.025 L -.321 .115 L 503 127.106 l .033 -.819 L -1.02 -.954 L -.312 -.351 L -.002 -.184 L .133 -.875 L .235 -.763 L 1.142 -.98 L -.422 -.761 L .013 -.254 L .468 -.596 L -1.067 -.107 L -.761 -.208 L -.065 -.198 L -.563 -1.086 L -.69 -1.397 L
535.734 133.791 N .853 -1.034 L .853 -.795 L .425 -.553 L -.046 -.437 L -.144 -.366 L -.401 -.167 L -1.198 -.275 L -.209 -.041 L -.191 -.21 L -.143 -.775 L -.167 -1.283 L -.254 -1.085 L .034 -.155 L .661 -.935 L -.026 -.183 L -.738 -.235 L -.096 -.098 L -.119 -.663 L .016 -.141 L .596 -.384 L .222 -.297 L .49 -1.272 L .246 -.807 L .084 -.339 L .145 -.241 L .193 .112 L .937 .193 L .999 .348 L .573 .082 L .534 -.031 L .636 -.3 L .22 -.199 L .001 -.466 L .119 -.199 L .568 -.159 L 1.985 -.689 L .508 -.243 L .103 -.128 L .203 -.991 L .432 -.809 L 1.135 -.205 L .417 -.2 L .445 -.356 L .565 .294 L 1.454 .244 L .096 .016 L .646 .011 L 1.217 .05 L .236 .126 L .351 .48 L .04 .055 L .129 .141 L .245 .041 L .485 -.144 L .58 -.343 L .581 -.286 L .325 -.001 L .63 .237 L .381 -.016 L .21 -.128 L .3 -.313 L -.007 -.311 L .073 -.185 L .292 -.058 L .587 .152 L .133 .013 L .442 -.158 L .208 -.228 L -.006 -.255 L .049 -.425 L .435 -.428 L .134 -.363 L .286 -.162 L .384 -.016 L .153 .056 L .576 .45 L -.156 .597 L .484 -.093 L .17 .187 L -.029 .255 L -.099 .775 L -.185 .444 L .199 .521 L .164 .409 L .128 .084 L .368 .026 L .351 -.03 L .745 -.495 L .589 -.064 L .592 -.486 L .739 -.315 L .678 -.03 L .198 .077 L -.129 .176 L .137 .059 L .974 -.147 L .564 -.227 L .264 .151 L .496 .054 L .565 .153 L -.192 .145 L -.574 -.059 L .01 .269 L .236 .012 L .048 .088 L -.148 .142 L -.358 .004 L -.455 .297 L -.332 -.005 L -.338 .179 L -.647 -.144 L -1.345 .012 L -1.148 .152 L -.53 .292 L -.272 .19 L -.559 .395 L -.246 -.023 L -.258 .214 L -.464 .413 L .01 .32 L .411 .271 L .01 .336 L .232 .171 L -.119 .483 L .198 .477 L -.324 .426 L -.524 .355 L -.4 .341 L -.13 .283 L .223 .478 L .033 .31 L -.289 .255 L -.513 .215 L -.698 -.039 L -.997 -.122 L -.355 .129 L .35 .336 L .365 .407 L .129 .281 L .088 .437 L -.199 .255 L -.315 .115 L -.513 .031 L -.416 .115 L -.292 .228 L -.224 .424 L -.288 .834 L -.139 1.214 L -.021 .084 L -.34 .383 L -.237 .086 L -1.001 -.375 L -.562 -.025 L -.559 .243 L -.362 .271 L -.321 .693 L -.254 .086 L -.516 -.082 L -.644 -.039 L -.283 .072 L -.597 .441 L -.412 .369 L -.188 .34 L -.232 .876 L -.099 .903 L -.069 .184 L -.247 .156 L -1.066 .274 L -1.183 .19 L -.964 .175 L -1.234 .12 L -1.005 -.135 L -.349 .002 L -1.187 .218 L -.742 -.024 L -.541 -.039 L -.854 -.235 L -1.069 -.248 L -.63 -.194 L -.887 -.32 L
486.696 126.295 N 5.257 -2.711 L .589 -2.701 L -.024 -.467 L -.187 -.508 L .009 -.255 L .23 -.355 L .31 -.214 L .866 -.174 L .457 -.371 L .944 -.883 L -.059 -.24 L .23 -.043 L .266 -.143 L .437 -.094 L .304 .16 L .364 -.032 L .811 .153 L .343 .023 L .244 -.234 L .366 .082 L .274 .151 L -.03 .259 L .102 .269 L .318 .105 L .164 -.126 L .433 -.388 L .407 .016 L .69 1.397 L .563 1.086 L .065 .198 L .761 .208 L 1.067 .107 L -.468 .596 L -.013 .254 L .422 .761 L -1.142 .98 L -.235 .763 L -.133 .875 L .002 .184 L .312 .351 L 1.02 .954 L 503 127.106 l .075 .155 L .321 -.115 L .533 .025 L 1.242 .925 L .436 .209 L .774 .603 L .29 .28 L .112 .239 L -.014 .508 L -.197 .622 L -.055 .579 L .034 .325 L .551 -.003 L .215 .013 L .164 .465 L .007 .395 L -.064 .212 L .686 .546 L .351 .224 L .014 .12 L -.096 .003 L -.664 .101 L -.408 -.056 L -.157 .057 L -.103 .127 L -1.271 .044 L -.518 .13 L -.343 .693 L -.463 .609 L -.521 .568 L -4.048 -.132 L -1.557 -.697 L -.812 -.277 L -.118 -.253 L -.047 -.818 L .118 -.396 L -.135 -.366 L -.973 .048 L -.141 -.07 L -.399 -.633 L -.258 -.196 L -2.44 -1.101 L -1.14 -.473 L -2.034 -.934 L -.757 -.222 L -1.129 -.459 L -.093 -.056 L -.093 -.056 L -.311 -.69 L -.87 -1.632 L
479.916 127.377 N -.082 -.085 L .047 -.122 L -.021 -.183 L -.201 -.128 L -.183 -.346 L .398 -.209 L .041 -.099 L .526 -.396 L -.048 -.058 L -.223 -.099 L .077 -.151 L .298 -.25 L .599 -.006 L -.14 -.146 L -.035 -.046 L .078 -.111 L .177 -.163 L .169 -.116 L .299 -.239 L -.068 -.058 L .023 -.163 L -.09 -.047 L -.031 -.221 L -.241 -.157 L -.222 -.058 L .204 -.204 L -.125 -.052 L -.053 -.116 L -.12 .058 L -.335 .052 L -.388 -.023 L -.225 -.564 L .129 -.593 L .072 -.064 L -.1 -.507 L -.42 -.326 L .126 -.093 L .036 -.152 L .117 -.128 L -.093 -.222 L .107 -.012 L .259 -.32 L -.061 -.112 L .311 -.001 L .39 .125 L .114 -.127 L .171 .041 L .2 -.169 L .156 -.374 L .627 -.127 L -.243 -.423 L -.102 -.452 L .055 -.319 L .142 .035 L .222 -.001 L .777 .166 L .575 .025 L .746 -.075 L .929 -.373 L .278 -.03 L 1.532 .444 L .556 .153 L 1.104 -.176 L .567 -.13 L 1.498 -.673 L .439 -.073 L .747 .123 L .711 .039 L 1.185 -.224 L .693 -.304 L .24 -.292 L .207 .023 L .064 .245 L .059 .24 L -.944 .883 L -.457 .371 L -.866 .174 L -.31 .214 L -.23 .355 L -.009 .255 L .187 .508 L .024 .467 L -.589 2.701 L -5.257 2.711 L -.161 .071 L -2.96 1.541 L -1.139 .656 L -.253 .016 L -.365 -.167 L -1.902 -1.034 L
426.068 126.434 N -.093 .981 L .064 .564 L -.093 .269 L -.802 .428 L -.579 .314 L -1.473 1.138 L -.126 .354 L .274 .973 L -.147 .537 L -.155 .227 L -.864 .598 L -.22 .143 L -.564 -1.536 L -.699 -2.242 L -.323 -.464 L -.363 -.252 L -.432 -.181 L -.484 -.831 L -.225 -.465 L -.363 -.28 L -.452 -.097 L -.336 -.774 L -.301 -.888 L .112 -.509 L 1 -.853 L .414 -.355 L .163 -.411 L .048 -.537 L -.052 -.594 L -.026 -.892 L -.012 -1.429 L .114 -.439 L .685 -.627 L .012 -.184 L .508 -.185 L .633 -.455 L .591 -.228 L .703 -.016 L .643 .183 L .247 .212 L .059 .241 L .25 .538 L .27 .084 L .417 -.171 L .584 -.44 L .401 -.17 L .034 .354 L -.265 .567 L -.638 .511 L -.275 .468 L .005 .283 L .202 .438 L .508 .466 L .351 .127 L .303 .848 L -.094 .212 L -.541 .764 L -.59 .34 L -1.017 .92 L -.216 .339 L .287 .451 L .587 .55 L .528 .295 L .284 .056 L .396 -.227 L .316 .084 L .244 .635 L .582 .239 L
381.402 139.704 N -.027 -.876 L .069 -2.006 L .037 -.382 L .686 -.314 L 1.512 -.998 L .963 -.542 L 1.265 .078 L .397 -.059 L .181 -.693 L .864 -.033 L .777 -.174 L .527 -.229 L .524 -.356 L .484 -.652 L 1.109 -.332 L 1.52 -.701 L .129 -.227 L -.296 -.62 L -.025 -.396 L .079 -.227 L .265 -.114 L 1.186 -.12 L .381 -.186 L .309 -.553 L 1.022 .022 L .67 -.018 L 1.826 .004 L .34 -1.033 L -.07 -.211 L -.507 -.322 L 397 126.646 l -.158 -.465 L .016 -1.271 L .022 -.833 L -.165 -.889 L -.189 -.211 L -.563 -.279 L -.259 -.508 L .351 0 L .66 -.143 L .541 -.256 L .369 -.566 L .405 -.312 L .509 -.086 L .407 -.157 L .679 -.27 L .324 .226 L .176 .017 L .249 .024 L .238 -.142 L .407 -.51 L .613 -.426 L .682 -.355 L .614 -.171 L 1.16 -.116 L 1.587 -.06 L .513 -.072 L .634 -.312 L .578 .211 L .564 -.072 L .585 -.313 L .343 -.1 L .939 .012 L .513 -.015 L .307 .056 L .221 .042 L .322 .113 L .816 .168 L .529 -.015 L .772 -.171 L .705 -.2 L .612 -.554 L .994 .508 L .339 .099 L .312 -.143 L .314 -.241 L .228 -.156 L .528 .042 L .388 .197 L .162 .269 L .269 .126 L .516 -.086 L 1.093 -.158 L -.012 .184 L -.685 .627 L -.114 .439 L .012 1.429 L .026 .892 L .052 .594 L -.048 .537 L -.163 .411 L -.414 .355 L -1 .853 L -.112 .509 L .301 .888 L .336 .774 L .452 .097 L .363 .28 L .225 .465 L .484 .831 L .432 .181 L .363 .252 L .323 .464 L .699 2.242 L .564 1.536 L -.204 .156 L -.241 .383 L .88 1.605 L .147 .833 L .052 .691 L -.1 .862 L .101 .748 L -.16 .622 L -.158 .495 L .457 1.156 L -.061 .664 L -.086 .17 L -.666 .47 L -.249 .128 L -.152 .283 L 1.272 1.702 L .249 .917 L .562 .873 L .244 .154 L .544 -.201 L .702 .165 L 1.028 .347 L .178 .168 L .86 1.506 L .098 .07 L -.265 .186 L -1.632 .843 L -4.012 2.241 L -1.607 .956 L -2.308 1.454 L -.834 .655 L -3.084 2.617 L -1.82 .364 L -1.672 .321 L -2.176 .408 L -.146 -.564 L .161 -.679 L -.099 -.522 L -.277 -.352 L -.309 -.111 L -.748 -.024 L -.375 -.167 L -.588 -.562 L -.47 .314 L -.229 -.027 L -1.111 -1.039 L -.393 -.28 L -.082 -.183 L .096 -.396 L -.181 -.253 L -2.472 -1.469 L -.397 -.253 L -1.292 -.824 L -1.924 -1.26 L -3.283 -2.241 L -.811 -.575 L -2.054 -1.344 L -.895 -.531 L -.1 -.084 L -1.414 -.91 L -4.12 -2.42 L -2.829 -1.509 L
395.704 122.189 N .259 .508 L .563 .279 L .189 .211 L .165 .889 L -.022 .833 L -.016 1.271 L .158 .465 L .598 .788 L .507 .322 L .07 .211 L -.34 1.033 L -1.826 -.004 L -.67 .018 L -1.022 -.022 L -.309 .553 L -.381 .186 L -1.186 .12 L -.265 .114 L -.079 .227 L .025 .396 L .296 .62 L -.129 .227 L -1.52 .701 L -1.109 .332 L -.484 .652 L -.524 .356 L -.527 .229 L -.777 .174 L -.864 .033 L -.181 .693 L -.397 .059 L -1.265 -.078 L -.963 .542 L -1.512 .998 L -.686 .314 L -.037 .382 L -.069 2.006 L -1.42 .008 L -1.718 -.004 L -2.677 .001 L -2.511 0 L -1.635 .04 L .141 -.28 L .431 -.411 L .427 -.085 L 1.296 -.285 L 1.143 -.455 L .453 -.312 L 1.147 -.85 L 1.149 -.878 L 1.043 -1.104 L .46 -.693 L .133 -.509 L -.05 -.494 L -.427 -.776 L -.09 -.678 L .099 -.508 L .396 -.636 L .706 -.863 L .211 -.65 L -.063 -.367 L .071 -.353 L 1.285 -1.203 L .724 -.481 L .916 -.327 L 1.266 -.469 L .73 -.397 L .558 -.552 L .537 -.736 L .466 -.905 L .829 -1.925 L .269 -.128 L .54 -.171 L .19 .127 L .684 .848 L .138 .099 L 1.148 .507 L .661 -.001 L .595 .042 L 1.304 -.074 L .522 -.228 L .437 -.27 L .398 .551 L .256 .099 L .798 .097 L .361 0 L
480.248 123.437 N .388 .023 L .335 -.052 L .12 -.058 L .053 .116 L .125 .052 L -.204 .204 L .222 .058 L .241 .157 L .031 .221 L .09 .047 L -.023 .163 L .068 .058 L -.299 .239 L -.169 .116 L -.177 .163 L -.078 .111 L .035 .046 L .14 .146 L -.599 .006 L -.298 .25 L -.077 .151 L .223 .099 L .048 .058 L -.526 .396 L -.041 .099 L -.398 .209 L -.07 -.023 L -.088 .041 L -.067 .193 L -.009 .167 L -.355 .07 L -.07 -.099 L -.151 -.022 L -.372 .051 L .26 -.291 L .097 -.361 L .169 -.227 L .328 -.681 L -.017 -.232 L .181 0 L .138 -.192 L .072 -.32 L .018 -.32 L .409 -.431 L .232 -.07 L .116 -.174 L -.048 -.157 L
184.444 142.729 N -.367 .82 L -.518 .821 L -.186 .763 L -.179 1.159 L .017 1.851 L -.133 1.187 L -.016 1.13 L .564 1.737 L .275 .805 L .624 .945 L .76 .903 L .191 .452 L .481 .521 L .529 .974 L .729 1.228 L .375 .296 L .677 .069 L .436 -.015 L .577 .154 L .593 .451 L .503 .508 L .773 .069 L 1.016 -.242 L 1.55 -.456 L 1.396 -.3 L .803 -.157 L -.02 .542 L .838 .223 L .264 -.286 L .293 -.199 L -.104 -.247 L -.393 -.175 L 1.073 -.62 L .633 -.62 L .086 -.827 L .498 -.429 L -.094 -.477 L .092 -1.145 L .254 -.699 L .625 -.334 L .164 -.043 L .757 -.198 L .701 -.1 L 1.088 -.229 L 1.016 -.37 L .594 -.058 L .499 .056 L 1.139 .181 L .502 -.194 L .378 .093 L .62 .507 L .047 .297 L -.079 .424 L -.298 .382 L -.541 .496 L -.433 .425 L -.317 .445 L -.02 .7 L -.254 .297 L -.188 .354 L .155 .155 L .337 -.138 L -.101 .652 L -.262 1.196 L 205.356 159 l -.062 .24 L -.34 -.534 L -.167 -.452 L -.072 -.155 L -.386 .34 L -.02 .549 L -.437 .016 L -.178 .447 L -.599 .857 L -.386 -.27 L -.278 .095 L .025 .329 L -2.332 -.006 L -1.792 -.005 L -.04 1.24 L -.999 .032 L .396 .223 L .495 .541 L .624 .231 L .359 .69 L .532 .223 L -.211 .683 L -1.762 -.007 L -1.06 .007 L -1.076 1.812 L .305 .397 L -.207 .238 L .054 .553 L .044 .454 L -.704 -.555 L -.952 -.888 L -.956 -.761 L -1.069 -.859 L -.534 -.352 L -.053 -.071 L -.639 -.252 L -1.048 -.21 L -.657 .044 L -.817 .397 L -1.1 .567 L -.756 .256 L -.931 -.069 L -.724 -.21 L -.48 -.197 L -1.305 -.195 L -.588 -.267 L -.644 -.422 L -.935 -.521 L -.785 -.267 L -1.711 -.392 L -.963 -.365 L -.722 -.366 L -1.074 -.436 L -.592 -.352 L -1.123 -1 L -.207 -.07 L -.606 .058 L -.689 -.14 L -1.835 -.575 L -.565 -.536 L -.503 -.634 L -.495 -.395 L -1.049 -.577 L -.619 -.267 L -.5 -.494 L -.742 -.987 L -.363 -.55 L -.038 -.113 L .15 -.155 L .504 -.086 L .18 -.17 L .047 -.184 L -.331 -.367 L .457 -.679 L .041 -.381 L -.172 -.466 L -.744 -.959 L .121 -.297 L .146 -.17 L -.07 -.268 L -.665 -.62 L -1.495 -1.777 L -.546 -.493 L -.963 -1.058 L -.474 -.522 L -.815 -.578 L -.322 -.197 L -.158 -.268 L -.058 -.48 L -.144 -.183 L -.329 -.197 L -.609 -.197 L -.408 -.31 L -.366 -.522 L -.271 -.028 L -.414 .114 L -.238 -.155 L -.163 -.367 L -.005 -.325 L .459 -.736 L -.126 -.339 L -.751 -.62 L -.439 .255 L -.375 -.621 L -.118 -.353 L -.359 -.211 L -.61 -.168 L -.319 -.296 L -.125 -.254 L .05 -.381 L .084 -.269 L -.185 -.226 L -.561 -.21 L -.46 -.098 L -.46 -.253 L -.935 -.86 L -.478 -.706 L -.281 -.551 L -.646 -.832 L -.736 -1.073 L -.184 -.423 L -.38 -.678 L -.242 -.338 L -.152 -.452 L .042 -.509 L .032 -.311 L -.56 -.239 L -.795 -.196 L -.06 -.452 L -.128 -.155 L -.458 -.183 L -.289 .326 L -.251 .043 L -1.43 -.647 L -.285 1.004 L -.045 .438 L .033 .084 L .265 .339 L .264 .296 L .028 1.046 L .088 .509 L .51 .677 L .143 .169 L .643 .267 L .601 .536 L .525 .663 L .602 1.214 L .44 .282 L .328 .042 L .237 .169 L .325 1.398 L .102 .169 L .246 .155 L .497 .056 L .133 .056 L .215 .438 L .161 .65 L .445 .79 L .49 -.071 L .223 -.142 L .245 .452 L .344 1.469 L .531 1.059 L .649 1.2 L .069 .593 L -.014 .522 L .26 .353 L .378 .154 L .389 -.17 L .234 -.198 L .588 .804 L .258 .579 L .464 .253 L .281 .014 L .133 .311 L -.196 .537 L -.136 .127 L -.691 .595 L -.254 -.042 L -.251 -.409 L -.24 -.734 L -.617 -.578 L -.625 -.309 L -.516 -.479 L -.834 -.507 L -1.143 -.986 L -.416 -.451 L -.162 -.269 L .216 -.989 L -.035 -.254 L -.488 -1.002 L -.238 -.381 L -.327 -.282 L -.44 -.098 L -.5 -.31 L -.675 -.677 L -.305 .142 L -.363 -.056 L -1.262 -.746 L -.722 -.31 L -.896 -.973 L -.139 -.127 L -.246 -.254 L .679 .15 L .599 .013 L .588 -.284 L .244 -.326 L .093 -.636 L -.01 -.184 L -.458 -.635 L -.466 -.452 L -1.1 -.888 L -.986 -.493 L -.402 -.338 L -.203 -.522 L -.272 -.649 L -.091 -.155 L -.447 -.126 L -.15 -.353 L -.026 -.594 L -.203 -.395 L -.623 -.734 L -.434 -.706 L -.003 -.254 L .212 -.382 L -.777 -.62 L -.254 -.325 L -.22 -.485 L .34 -.017 L 2.367 -.155 L 2.381 -.084 L .316 .31 L .267 .154 L 1.186 .39 L 2.811 .933 L 3.516 1.112 L .338 .055 L 1.662 .019 L 1.544 .02 L .966 .037 L 1.867 -.011 L .213 -.101 L .096 -.892 L 1.858 .003 L 1.892 .046 L .209 .112 L .631 .662 L .766 .632 L .837 .519 L .708 .491 L .179 .226 L .284 .678 L .318 .847 L .445 .549 L 1.092 .659 L 1.104 .503 L .337 .069 L .501 .011 L .416 -.158 L .283 -.37 L .418 -.413 L .576 -.541 L .468 -.201 L .643 -.018 L .475 .082 L .783 .321 L .412 .252 L .363 .366 L .663 1.029 L .744 1.227 L .845 1.042 L .657 .576 L .268 .253 L .078 .467 L .332 .932 L .336 .592 L .375 .365 L .921 .32 L 1.029 .56 L .264 .069 L .416 -.116 L .296 -.001 L .816 .377 L .347 .119 L
507.047 133.665 N .055 .197 L .134 .691 L -.336 -.028 L -.513 .513 L .421 .194 L .418 -.206 L .306 .021 L .698 1.84 L -.644 .044 L -1.07 -.05 L -.185 -.239 L -.334 -.619 L -.408 -.054 L -1.657 -.259 L .521 -.568 L .463 -.609 L .343 -.693 L .518 -.13 L 1.271 -.044 L
606.155 150.953 N .595 .152 L .255 .14 L .25 -.129 L .273 -.368 L .015 -.678 L -.152 -.93 L .228 -.185 L .401 -.144 L .191 -.354 L -.146 -1.594 L .133 -.283 L .811 .32 L .391 .11 L .309 .013 L .17 -.128 L 1.148 -2.25 L 0 -.324 L -.192 -.408 L .045 -.212 L .938 -1.134 L .136 -.382 L -.057 -.761 L .197 -.354 L 1.446 -.883 L .719 -.512 L .312 -.129 L .558 .082 L .853 .221 L .295 -.058 L -.184 -.718 L .072 -.283 L .596 -.582 L .112 -.24 L .018 -.508 L .001 -.127 L .306 -.34 L .277 -.044 L .504 .279 L .397 .435 L .243 .901 L .217 .309 L .287 .041 L .504 -.031 L .146 .14 L .195 1.649 L .02 .875 L -.353 .862 L -.429 .722 L -.611 .525 L -.487 .271 L -.191 .198 L -.617 .85 L .075 .465 L .163 .705 L -.224 .58 L 0 .268 L .216 .069 L .312 -.086 L .819 -.442 L .771 -.089 L .479 -.017 L .156 .126 L .277 1.762 L .202 .324 L .554 -.074 L .521 .096 L .033 .268 L -.729 1.584 L .117 .352 L .228 .098 L .507 -.003 L .481 -.045 L .291 .379 L .341 .746 L .378 .266 L .246 .083 L .647 -.159 L .628 -.413 L .111 .38 L .153 .239 L -.502 .355 L -.53 .61 L -.442 .581 L -.582 .455 L -.193 .185 L -.08 .085 L -.158 .071 L -.645 .06 L -.436 .172 L -.528 .342 L -.394 .595 L -1.078 .316 L -.62 .018 L -.474 -.082 L -.362 .411 L -.143 .368 L -.036 .819 L -.114 .509 L .064 .409 L -.086 .24 L -.163 .001 L -.588 .131 L .739 .884 L .069 .183 L .112 .875 L .254 .14 L 1.091 .953 L .148 .324 L .646 1.041 L .163 .338 L -.194 .241 L -.451 .229 L -.128 .226 L .231 1.185 L -.171 .198 L -.812 .428 L .178 .38 L .6 1.436 L .54 .477 L .606 .604 L .203 .479 L .088 .663 L -.086 .636 L .006 .254 L .488 1.183 L .586 1.225 L -.077 .297 L -1.011 1.559 L -1.01 1.7 L -.098 .374 L -.359 -.181 L -.075 -.805 L .461 -.665 L .174 -.495 L .122 -.777 L .287 -.466 L -.512 -.027 L -.104 -.084 L -.004 -.282 L .195 -.509 L -.177 -1.524 L -.246 -.832 L -.639 -1.185 L -.488 -1.312 L -.347 -.846 L -.179 -.875 L -.174 -1.736 L -.117 -.677 L -.034 -.564 L -.051 -.212 L -.344 -.084 L -.148 -.098 L -.304 -.917 L -.516 -.677 L -.226 -.225 L -.247 .029 L -.081 .988 L -.158 .424 L -.43 .41 L -.59 .284 L -1.089 .511 L -.359 .622 L -.298 .297 L -.196 .142 L -.237 -.282 L -.007 -.438 L -.212 .015 L -.338 .354 L -.321 -.013 L -.166 -.211 L .147 -.495 L -.001 -.113 L -.621 .171 L -.276 .127 L -.247 .283 L -.355 -.126 L -.002 -.466 L .553 -1.54 L .162 -.791 L .001 -.889 L -.101 -1.059 L -.384 -.973 L -.431 -1.072 L -.196 -.296 L -.281 .537 L -.32 -.126 L -.526 -.366 L .482 -.17 L .312 -.015 L -.149 -.479 L -.054 -.268 L -.684 -.775 L -.182 -.183 L -.19 -.028 L -.407 .1 L -.38 -.267 L .086 -.438 L -.026 -.141 L -.209 -.112 L -.365 .043 L -.577 -.465 L -.504 -.606 L -.117 -.244 L .252 -.341 L .801 -.527 L -.194 -1.607 L
605.297 153.429 N -.126 -.264 L -.269 -.55 L -.223 -1.213 L -.611 -1.41 L -.357 -.395 L -.73 .354 L -.393 0 L -.034 -.084 L -.242 -.211 L -.356 -.592 L -.124 -.042 L -.152 .127 L -.026 .537 L .374 .79 L -.006 .424 L -.143 .169 L -.455 .086 L -.235 .537 L -.261 .1 L -.255 -.437 L -.311 -.395 L -.073 -.057 L -.163 .669 L -.28 .249 L -.203 .043 L -.271 -.536 L -.495 .636 L -.359 -.265 L -.147 -.532 L -.402 -1.775 L -.325 -1.409 L -.352 -.45 L -.04 -.254 L .505 -.765 L .029 -.269 L -.193 -.21 L -1.042 -.431 L -.339 -.323 L .548 -.61 L .4 -.299 L .502 -.13 L .382 -.101 L .047 -.155 L -.126 -.112 L -1.224 -.938 L -.494 -.237 L -.083 -.155 L .124 -.283 L .555 -.525 L .234 -.171 L 1.252 .303 L .339 .266 L .372 .266 L .489 -.06 L .417 .054 L .129 .324 L .053 .479 L .079 .719 L .095 .099 L .537 .109 L .547 .053 L .916 -.062 L .559 -.003 L 2.473 .198 L .111 .098 L .057 .127 L -.012 .79 L -.159 .34 L -.938 .767 L -.498 .13 L -.651 .356 L -.131 .283 L .009 .522 L .001 .381 L .23 .281 L .249 .267 L .529 .448 L .224 -.354 L .395 -1.159 L .281 -.115 L .4 -.044 L .064 .578 L .627 2.479 L .037 .466 L .194 1.607 L -.801 .527 L -.252 .341 L
627.408 186.411 N -.086 .337 L -.495 .35 L -.11 .575 L -.644 .089 L -.05 -.478 L -.309 -.163 L -.279 .28 L -.244 .394 L -.204 -.083 L -.118 -.239 L .213 -.398 L -.041 -.21 L -.055 -.226 L -.261 -.238 L -.447 -.119 L -.106 -.466 L -.571 .013 L -.448 .17 L .013 -.104 L .128 -.297 L -.15 -.183 L -.411 .212 L -.301 -.07 L -.38 -.38 L -.116 -.508 L .064 -.282 L -.151 -.438 L -.229 -.169 L -.388 .043 L -.39 -.719 L -.209 -.508 L -.3 -.324 L -.311 -.155 L -.456 -.395 L -.343 .1 L -.218 .142 L -.216 -.381 L -.04 -.607 L .163 -.749 L .559 -1.738 L .29 -.848 L -.087 -.044 L .098 -.374 L 1.01 -1.7 L 1.011 -1.559 L .077 -.297 L -.586 -1.225 L -.488 -1.183 L -.006 -.254 L .086 -.636 L -.088 -.663 L -.203 -.479 L -.606 -.604 L -.54 -.477 L -.6 -1.436 L -.178 -.38 L .812 -.428 L .171 -.198 L -.231 -1.185 L .128 -.226 L .451 -.229 L .194 -.241 L -.163 -.338 L -.646 -1.041 L -.148 -.324 L -1.091 -.953 L -.254 -.14 L -.112 -.875 L -.069 -.183 L -.739 -.884 L .588 -.131 L .163 -.001 L .086 -.24 L -.064 -.409 L .114 -.509 L .036 -.819 L .143 -.368 L .362 -.411 L .474 .082 L .62 -.018 L 1.078 -.316 L .394 -.595 L .528 -.342 L .436 -.172 L .645 -.06 L .158 -.071 L .08 -.085 L .541 .166 L .295 .182 L .118 .168 L .01 .423 L -.106 .805 L .066 .367 L .186 .154 L .423 -.003 L .489 -.2 L .414 -.045 L .045 .113 L .249 1.311 L -.085 .41 L -.528 1.569 L -.117 .438 L -.027 .494 L .145 .324 L .481 .138 L .37 -.411 L 1.173 -1.178 L .346 -.03 L .835 .348 L .59 .265 L .223 -.072 L .543 -.257 L .2 -.538 L .286 -.453 L .403 .012 L .893 .192 L .266 .153 L .052 .282 L .285 .535 L .688 .659 L .435 .632 L .058 1.524 L .107 .366 L .255 .464 L .979 1.279 L .419 .703 L .157 .507 L .002 .945 L -.121 .438 L -.808 .64 L -.301 -.167 L -.599 -.109 L -.575 -.039 L -.558 .074 L -.798 -.066 L -1.172 .091 L -.383 .101 L -.521 .441 L -.92 1.233 L -.146 .297 L -.076 .382 L .026 .635 L .219 .648 L .487 .717 L .16 .479 L -.146 .176 L -.026 -.063 L -.286 -.183 L -.458 -.084 L -.9 -.887 L -.434 -.154 L -.304 -.014 L -.572 .227 L -.391 -.112 L -.29 -.141 L -.337 -.014 L 0 -.282 L .19 -1.243 L -.107 -.184 L -.719 -.055 L -.248 -.084 L -.521 .043 L -.443 .212 L -.244 .297 L .207 .593 L -.103 .339 L -.318 .707 L .083 .579 L .054 .41 L -.293 .664 L -.583 1.187 L -.7 1.682 L -.255 1.314 L .104 1.171 L .172 .296 L .229 .169 L .55 -.072 L .396 -.142 L .252 .07 L .135 .353 L .009 .325 L -.08 .466 L .141 .282 L .178 .211 L .271 -.094 L .17 .46 L .209 .974 L -.032 .254 L .127 .737 L .434 .871 L .167 .155 L .801 .281 L .539 .112 L .467 -.058 L .294 .197 L .266 .612 L .664 .544 L .212 .145 L
204.31 158.989 N -.175 .412 L .612 -.173 L .026 .429 L -.419 1.241 L .178 .269 L -.237 .795 L .189 .318 L -.092 .397 L -.358 .875 L -.3 .35 L -.36 .032 L -.054 .286 L -.388 .238 L 0 .286 L -.69 .016 L .215 -4.297 L -.025 -.329 L .278 -.095 L .386 .27 L .599 -.857 L .178 -.447 L .437 -.016 L
200.276 169.481 N -.151 -.056 L -.928 -.342 L -.614 .032 L -.766 -.032 L -.608 -.239 L -.909 -.656 L -.513 -.419 L -.044 -.454 L -.054 -.553 L .207 -.238 L -.305 -.397 L 1.076 -1.812 L 1.06 -.007 L 1.762 .007 L .211 -.683 L -.532 -.223 L -.359 -.69 L -.624 -.231 L -.495 -.541 L -.396 -.223 L .999 -.032 L .04 -1.24 L 1.792 .005 L 2.332 .006 L -.215 4.297 L .69 -.016 L .303 .095 L .311 .302 L .14 -.191 L -.066 -.381 L .336 .157 L .458 .367 L -1.507 1.208 L -.499 .238 L -.177 .493 L .162 .604 L -.438 .302 L -.467 .048 L -.043 .254 L .164 .159 L -.351 .111 L -.184 .302 L -.22 -.016 L -.565 .461 L -.012 .223 L
204.413 165.093 N .312 -.03 L .612 -.27 L .639 -.058 L .743 .126 L .478 .069 L 1.443 .04 L .699 -.228 L .379 -.199 L .567 .267 L .788 -.03 L .763 -.101 L .63 -.001 L .5 .126 L .564 .253 L -.038 .353 L -.102 .226 L .228 .282 L .787 .238 L .557 .069 L .244 .524 L -1.425 .486 L -.424 .229 L -.248 .086 L -.463 -.097 L -.328 -.182 L -.259 -.013 L -.294 .242 L -.503 .794 L -1.207 .997 L -.725 -.42 L -.513 .583 L -.882 .034 L -.005 .961 L -.293 .412 L -.29 .143 L -1.001 .125 L -.311 -.661 L -.025 -.085 L -.478 -.3 L .085 -.731 L -.128 -.175 L -.272 0 L -.541 -.276 L -.433 .34 L -.365 -.016 L -.066 -.271 L -.565 -.35 L -.409 -.08 L -.208 -.418 L -.677 -.17 L .438 -.302 L -.162 -.604 L .177 -.493 L .499 -.238 L 1.507 -1.208 L
205.532 170.085 N .035 .076 L -.203 .057 L .01 .265 L -.237 .334 L -.68 -.046 L -.853 -.139 L -1.697 -.505 L -1.305 -.435 L -.325 -.21 L .012 -.223 L .565 -.461 L .22 .016 L .184 -.302 L .351 -.111 L -.164 -.159 L .043 -.254 L .467 -.048 L .677 .17 L .208 .418 L .409 .08 L .565 .35 L .066 .271 L .365 .016 L .433 -.34 L .541 .276 L .272 0 L .128 .175 L -.085 .731 L
242.38 173.617 N -.128 -.105 L -.84 .171 L -.534 .156 L -.414 .2 L -.056 .288 L .048 .497 L -.129 .396 L -.227 -.027 L -.381 .059 L -.99 1.758 L -.172 .722 L -.241 .722 L -.709 1.191 L .402 .025 L .234 -.1 L .384 -.017 L .31 .606 L .855 1.45 L .103 .395 L -.226 1.132 L .099 .353 L .401 .309 L .429 .548 L .397 .252 L .496 -.017 L 1.163 -.12 L 1.167 -.05 L .521 .181 L .64 .321 L .188 .253 L .847 .998 L .554 .576 L .144 0 L .522 -.13 L .76 -.174 L 1.99 -.224 L .644 .081 L -.409 .525 L -.085 1.004 L -.379 .511 L -.147 .326 L .026 .254 L .035 .438 L .048 .367 L .162 .804 L .447 .789 L .256 .437 L .486 .647 L .121 .282 L -.731 .612 L -.479 .526 L .51 .491 L .797 1.182 L -.52 .286 L -.834 .57 L -.412 .158 L -.463 .017 L -2.812 -.082 L -.64 -.024 L -.042 .325 L -.013 1.031 L .178 .154 L .896 .122 L .177 .084 L .293 .408 L .052 .367 L -.384 -.04 L -.417 -.11 L -.687 .032 L -.493 .187 L -.111 .085 L -.001 1.071 L 0 .554 L .192 .197 L .688 .363 L .192 .183 L -.031 .777 L .399 .562 L .031 .212 L -.326 1.428 L -.706 4.411 L -.073 .382 L -.133 .198 L -.156 -.14 L -.575 -.703 L -.237 -.126 L -.161 .058 L -.448 .031 L 1.155 -1.956 L .035 -.198 L -.127 -.069 L -1.299 -.84 L -.509 -.209 L -.708 .442 L -.397 -.182 L -.523 -.421 L -.452 .427 L -.337 .157 L -.496 .031 L -1.038 -.008 L -.573 -.152 L -.092 -.281 L .004 -.396 L -.173 -.296 L -.479 -.039 L -.366 -.14 L -.078 -.282 L -.251 -.761 L -.988 -.672 L -.526 -.364 L -.208 -.62 L -.208 -.324 L -.513 -.435 L -.897 -.418 L -.927 -.107 L -.081 -.112 L -.269 -.162 L -.197 -.118 L -.709 -.631 L -.128 -.056 L -.89 .401 L -.67 .061 L -.977 -.277 L -.355 -.309 L -.166 -.493 L -.227 -.225 L -1.432 -.656 L -1.496 -.803 L .033 -.068 L -.117 -.311 L -.181 -.282 L .108 -.212 L .509 -.114 L .465 .112 L .186 -.325 L -.348 -.564 L .086 -.424 L .314 -.227 L .878 -.058 L .193 .042 L .41 -.227 L .445 -.679 L .45 -.961 L .651 -1.061 L -.122 -.268 L -.56 -.408 L -.071 -.184 L .306 -.721 L .089 -.523 L -.149 -.861 L -.371 -.86 L .085 -.254 L .49 -.143 L .135 -.212 L -.088 -.198 L -.565 -.479 L -.042 -.226 L .103 -.198 L .242 -.326 L .036 -.254 L -.173 -.282 L -.739 -.719 L -.364 -.396 L .256 -.753 L .228 -.082 L -.045 -.45 L .19 .082 L .085 .307 L .584 -.409 L .094 -.43 L .322 -.062 L -.509 -1.038 L -.228 -.149 L -.084 -.327 L .142 .075 L .42 .338 L .397 .507 L .22 .508 L .235 .197 L .199 -.17 L .147 -.241 L -.332 -.776 L .02 -.212 L .176 -.297 L .445 -.34 L .399 -.297 L .501 -.736 L .327 -.156 L .684 -.101 L .217 -.382 L -.104 -.381 L .174 -.777 L .067 -.65 L .207 -.48 L .498 -.439 L .429 -.283 L .592 -.242 L .113 0 L .374 .206 L .22 .443 L .281 -.34 L .031 -.438 L .199 -.551 L .22 -.071 L .267 .126 L .855 .041 L .562 -.001 L .623 -.27 L .237 -.254 L .476 -.298 L .848 -.256 L .435 -.396 L .278 -.551 L .333 -.255 L .469 -.17 L .58 .013 L .526 .338 L .155 .126 L .155 .339 L -.285 .332 L
408.6 174.04 N -.062 .777 L .164 .762 L .388 .718 L -.316 .962 L -.19 .566 L -.223 .298 L -.656 .414 L -.095 .34 L .116 .592 L -.078 .368 L -.433 .13 L -.257 .03 L -.237 .397 L .002 .381 L .003 .48 L -.012 .876 L -.09 .989 L .217 1.439 L -.121 1.188 L .006 .234 L -.333 .015 L -1.232 .144 L -.669 .052 L -.106 -.205 L -.295 -1.072 L .188 -.708 L .026 -.833 L -.036 -.537 L -.135 -.974 L -.006 -.862 L -.035 -.522 L .013 -.579 L -.442 -1.311 L -.164 -.691 L -.403 -.323 L -.468 -.294 L -.18 -.395 L .141 -.594 L .046 -.424 L .062 -.142 L .24 -.157 L .366 -.553 L .415 -.271 L .418 -.045 L .739 .095 L .337 -.158 L .415 -.468 L .237 -.764 L -.131 -.367 L .577 -.3 L .321 -.073 L .339 .28 L .727 .589 L .902 .503 L
394.266 178.814 N .191 -.17 L -.02 -.41 L -.261 -1.934 L .125 -.34 L .271 -.157 L 2.119 -.041 L .867 .037 L 1.429 .006 L .976 -.458 L .161 .032 L .595 .119 L -.25 .849 L .05 .254 L .633 .915 L .244 .451 L -.188 .721 L .02 .396 L .265 1.114 L .181 .592 L .503 .788 L .032 .155 L -.286 .242 L -.174 .382 L .01 1.314 L -.011 .72 L .021 .551 L .18 .479 L .468 .577 L .752 .608 L -.503 .682 L -.304 .099 L -.593 -.013 L -.992 .144 L -.463 .185 L -.188 .098 L -.898 .469 L -1.263 .398 L -.942 .412 L -.958 .567 L -.578 -.324 L -.945 -.436 L -.074 -.124 L -.066 -.741 L -.554 -1.155 L -.263 -.747 L -.103 -.706 L .327 -1.005 L .437 -1.274 L .521 -.851 L .203 -.595 L -.334 -1.438 L -.189 -1.285 L -.178 -.154 L
400.72 175.499 N 1.013 .163 L .611 .166 L .29 .041 L -.046 .424 L -.141 .594 L .18 .395 L .468 .294 L .403 .323 L .164 .691 L .442 1.311 L -.013 .579 L .035 .522 L .006 .862 L .135 .974 L .036 .537 L -.026 .833 L -.188 .708 L .295 1.072 L .106 .205 L -.452 .035 L -.479 .128 L -.368 .212 L -.023 .04 L -.752 -.608 L -.468 -.577 L -.18 -.479 L -.021 -.551 L .011 -.72 L -.01 -1.314 L .174 -.382 L .286 -.242 L -.032 -.155 L -.503 -.788 L -.181 -.592 L -.265 -1.114 L -.02 -.396 L .188 -.721 L -.244 -.451 L -.633 -.915 L -.05 -.254 L .25 -.849 L
383.772 190.418 N .041 -.919 L .105 -.565 L .247 -.849 L .059 -.452 L -.131 -.282 L -1.264 -1.334 L -.592 .032 L -.369 -.097 L -.194 -.183 L -.05 -.183 L .501 -.865 L .059 -.438 L -.119 -.55 L .062 -.17 L .047 -.099 L .602 -.554 L .188 -.354 L -.179 -.21 L -.296 -.549 L .03 -.127 L .158 -.199 L .304 -.03 L .548 .223 L .304 .012 L .19 -.143 L -.051 -.226 L -.648 -.561 L -.309 -.351 L .332 -.37 L .125 -.283 L -.197 -.31 L -.695 -.405 L -.214 -.409 L .264 -.623 L .379 -.397 L .522 -.54 L .352 -.059 L .566 .321 L .455 .436 L .35 -.228 L .362 -.469 L .571 -.483 L .239 -.114 L .257 .041 L .147 .211 L .004 .297 L .117 .381 L .148 .239 L .352 -.059 L .604 -.399 L .159 -.1 L .259 .168 L .545 -.003 L .308 .252 L .15 .465 L .52 .562 L .452 .223 L .354 .083 L .368 -.115 L .446 -.257 L .608 -.159 L .769 -.075 L .644 .166 L .63 .434 L .178 .154 L .189 1.285 L .334 1.438 L -.203 .595 L -.521 .851 L -.437 1.274 L -.327 1.005 L .103 .706 L .263 .747 L .554 1.155 L .066 .741 L -.119 -.201 L -.289 -.197 L -.208 .015 L -.143 .24 L -.096 .042 L -.48 -.027 L -.705 -.167 L -.608 -.083 L -2.352 .062 L -1.279 .243 L -.575 .199 L -1.07 .369 L -1.739 .781 L -.701 .425 L -.256 -.013 L -.075 -.032 L
627.408 186.411 N .035 .024 L .523 .098 L 1.061 1.198 L .693 .916 L .506 .762 L .081 .579 L -.023 .805 L -.134 .862 L .07 1.073 L -.07 .636 L .097 .494 L .196 .381 L .53 .493 L .338 .536 L .705 1.608 L .062 .127 L -.366 -.069 L -.895 -.055 L -.401 .142 L -.175 -.07 L -.521 -.437 L -.885 -.605 L -.6 -.337 L -1.231 -.675 L -1.02 -.732 L -.217 -.254 L -.16 -.988 L -.438 -.691 L -.895 -.817 L -.195 -.663 L .039 -.494 L .03 -.283 L -.107 -.409 L -.399 -.634 L -.347 -1.849 L -.188 -.72 L .043 -.362 L .448 -.17 L .571 -.013 L .106 .466 L .447 .119 L .261 .238 L .055 .226 L .041 .21 L -.213 .398 L .118 .239 L .204 .083 L .244 -.394 L .279 -.28 L .309 .163 L .05 .478 L .644 -.089 L .11 -.575 L .495 -.35 L .086 -.337 L h 643.95 196.042 m .081 .044 L .375 .408 L .397 .141 L .861 .083 L .413 .168 L .761 .436 L .335 .042 L .337 -.1 L -.503 -.535 L .169 -.551 L .365 -.608 L .528 -1.258 L .584 -.27 L 1.481 -.342 L 1.018 -.299 L .428 -.326 L .524 -1.021 L .523 -.323 L .87 -1.117 L .22 -.212 L .244 -.147 L .112 -.068 L .084 .126 L .062 .37 L .234 -.012 L .111 .259 L .309 .271 L .383 -.271 L 1.234 -.42 L -.025 -.086 L -.197 -.197 L .013 -.247 L .024 -.111 L -.148 -.444 L -.11 -.174 L .167 -.042 L .188 .143 L .085 -.016 L .449 -.084 L .161 -.283 L -.036 -.24 L -.478 -.366 L .197 -.396 L .436 -.071 L .511 .041 L .154 -.605 L .408 -.313 L .284 -.48 L .531 -.58 L .498 -1.032 L .075 -.17 L .322 .465 L .33 .098 L .315 -.424 L .305 .494 L .351 .282 L .402 .211 L .075 .338 L -.182 .354 L -.234 .452 L .037 .198 L .631 -.128 L .472 -.128 L .115 .226 L -.349 .495 L .742 -.1 L .357 -.085 L .269 .056 L 1.035 .662 L .345 .14 L .1 .24 L -.158 .269 L -.201 .155 L -.44 .143 L -.594 .029 L -.683 -.083 L -.355 .311 L .096 .254 L .888 .69 L -.161 .311 L -.458 .199 L -.646 .1 L -.518 .114 L -.067 .15 L -.182 -.09 L -.753 -.292 L -.446 -.04 L -.624 .018 L -.651 -.081 L -.748 -.081 L -.464 .017 L -.247 .157 L -.381 .638 L -.119 .565 L .106 .988 L -.22 .383 L -.646 .244 L -.218 .34 L .076 .748 L -.928 1.785 L -.387 .299 L -.864 .175 L -.465 .172 L -.467 .356 L -.287 .03 L -.559 -.152 L -.524 -.223 L -.557 -.251 L -.431 -.11 L -.479 .074 L -.531 .441 L -.403 .525 L -.528 .342 L -.399 .172 L -.543 -.11 L -.526 -.223 L -.255 .001 L -.928 .416 L -.446 -.28 L -.304 -.083 L -1 -.983 L -.253 -.295 L -.288 -.792 L
274.556 195.884 N .06 -.212 L -.332 -.563 L -.49 -1.127 L -.246 -.832 L -.185 -.295 L -.561 -.067 L -.532 -.675 L -.571 -.831 L .328 -.694 L .095 -.467 L -.078 -.777 L .169 -.17 L 1.131 -.091 L .183 -.27 L .082 -.862 L .142 -.496 L .015 -.339 L .326 -.312 L .382 -.057 L 1.392 .463 L .465 .042 L .083 -.41 L .141 -.085 L .337 .027 L .833 .012 L .863 -.03 L .723 .069 L .63 .182 L .999 .427 L -.647 .876 L -.391 .751 L -.137 .594 L .094 .381 L .134 .635 L .086 .664 L .521 .844 L .029 .438 L -.424 1.472 L -.489 .963 L -1.05 -.488 L -.319 .001 L -.534 .385 L -.398 .059 L -.418 -.139 L -.642 -.124 L -.172 .156 L -.2 .326 L .611 1.014 L -.528 -.054 L -1.108 -.276 L -.4 -.04 L
285.859 190.719 N .015 .422 L -1.102 1.646 L -.427 .765 L -.439 .992 L -.464 .681 L -.299 .214 L -.56 -.025 L -1.11 -.389 L -.882 .613 L -.225 -.069 L -.649 -.505 L .489 -.963 L .424 -1.472 L -.029 -.438 L -.521 -.844 L -.086 -.664 L -.134 -.635 L -.094 -.381 L .137 -.594 L .391 -.751 L .647 -.876 L .218 .093 L 1.033 .294 L .55 .196 L .799 .549 L 1.264 1.084 L .545 .564 L .317 .465 L .193 .028 L
429.505 210.684 N -.695 -.533 L -.351 .13 L -.68 .513 L -.536 .414 L -.112 -.177 L -.392 -.86 L -1.381 -1.344 L .184 -.295 L .413 -.229 L .803 .307 L .343 -.681 L -.052 -.296 L -.274 -.253 L -.39 -.521 L -.116 -.366 L .058 -.495 L .127 -.1 L .909 -.146 L .604 -.243 L .125 -.213 L .167 -.807 L .174 -.185 L .239 -.029 L .193 .14 L .341 .479 L .405 .521 L .386 .195 L .287 -.016 L .188 -.228 L .362 -.482 L .29 .253 L .167 .578 L .146 .112 L .304 .068 L .255 -.114 L .184 -.68 L .243 -1.089 L .131 -1.229 L .229 -1.047 L -.114 -.338 L -.161 -.127 L -.384 -.082 L -.528 -.208 L -.242 -.31 L -.132 -.437 L .008 -.109 L .021 -.3 L .157 -.284 L .492 -.398 L .556 -.441 L .094 -.354 L -.389 -.902 L -.369 -.322 L -.592 -.067 L -.939 .5 L -.463 -.025 L -.146 -.253 L -.068 -.734 L .077 -.679 L .396 -.468 L .56 .109 L .863 .023 L .878 -.076 L .271 .055 L .479 .04 L .56 .124 L .576 .194 L .864 .334 L .863 .292 L .271 -.086 L -.1 -.861 L .159 -.185 L .303 -.312 L .365 -.497 L .158 -.523 L .222 -1.287 L .255 -.228 L .479 -.102 L .975 -.175 L .367 .054 L .624 .138 L .895 .093 L .751 -.287 L .128 .197 L -.031 .156 L -.398 1.203 L -.558 .837 L -.349 .821 L -.094 .551 L -.156 .764 L -.196 2.021 L -.254 1.342 L -.115 .61 L -.169 .708 L -.139 .523 L -.459 .427 L -.525 .229 L -.809 .599 L -.41 .454 L -.47 .836 L -.343 .751 L -.193 1.159 L -.074 .396 L .122 .72 L -.086 .706 L -1.025 .938 L -.364 .229 L -.931 .811 L -.554 .399 L -.57 .328 L -.147 -.211 L -.042 -.664 L -.054 -.424 L -1.495 .532 L -.327 .581 L -.443 .271 L -.177 -.013 L -.484 -.336 L
425.506 195.522 N .045 -.495 L .88 .093 L 1.773 .088 L .831 .038 L 1.022 .149 L -.396 .468 L -.077 .679 L .068 .734 L .146 .253 L .463 .025 L .939 -.5 L .592 .067 L .369 .322 L .389 .902 L -.094 .354 L -.556 .441 L -.492 .398 L -.157 .284 L -.021 .3 L -.008 .109 L .132 .437 L .242 .31 L .528 .208 L .384 .082 L .161 .127 L .114 .338 L -.229 1.047 L -.131 1.229 L -.243 1.089 L -.184 .68 L -.255 .114 L -.304 -.068 L -.146 -.112 L -.167 -.578 L -.29 -.253 L -.362 .482 L -.188 .228 L -.287 .016 L -.386 -.195 L -.405 -.521 L -.341 -.479 L -.193 -.14 L -.239 .029 L -.174 .185 L -.167 .807 L -.125 .213 L -.604 .243 L -.909 .146 L -.127 .1 L -.058 .495 L .116 .366 L .39 .521 L .274 .253 L .052 .296 L -.343 .681 L -.803 -.307 L -.413 .229 L -.184 .295 L -.038 -.037 L -.563 -.493 L -.532 -.55 L -.259 -.466 L -1.318 -1.169 L .286 -.312 L -.369 -.281 L -.528 -.056 L -.918 -1.438 L .382 -.297 L .111 -.1 L -.321 -.395 L -.464 -.14 L -.29 -.564 L -.369 -.451 L .319 -.17 L .541 -.411 L .223 -.396 L .291 -.976 L .089 -.295 L .415 .07 L .495 .013 L -.064 -.211 L -.56 -.352 L -.561 -.451 L .208 -.042 L .271 -.128 L .142 -.617 L .83 -.043 L .927 .008 L 1.245 .021 L .575 -.032 L -.001 -.155 L -.02 -.551 L -.026 -1.836 L
422.536 195.513 N 1.005 -.007 L 1.965 .017 L .026 1.836 L .02 .551 L .001 .155 L -.575 .032 L -1.245 -.021 L -.927 -.008 L -.83 .043 L .033 -.146 L -.049 -.297 L -.144 -.084 L -.416 -.098 L .287 -.467 L .447 -.523 L .335 -.58 L .066 -.403 L h 419.636 193.273 m -.484 -.049 L -.049 -.218 L .049 -.291 L .242 -.097 L .024 -.146 L 0 -.291 L .17 -.097 L .169 -.121 L .219 .048 L .218 .048 L .097 .194 L -.193 .169 L -.146 .243 L -.17 .339 L -.146 .267 L
222.291 207.801 N .188 -.126 L .264 -.312 L .585 -1.061 L .038 -.269 L -.209 -.733 L .058 -.391 L -.478 .617 L -.732 .623 L -.333 -.098 L -.601 -.324 L -.408 -.408 L .389 -.283 L .1 -.24 L -.167 -.579 L .005 -.438 L .133 -.466 L -.109 -.282 L -.362 -.649 L .193 -.17 L .48 -.198 L .721 -.454 L -.319 -.395 L 0 -.226 L .175 -.354 L .497 -.462 L .157 -.146 L .14 -.848 L -.116 -.452 L -.082 -.184 L .11 -.226 L .686 -.101 L .891 -.341 L .396 -.241 L .474 -.382 L .09 -.186 L 1.496 .803 L 1.432 .656 L .227 .225 L .166 .493 L .355 .309 L .977 .277 L .67 -.061 L .89 -.401 L .128 .056 L .709 .631 L .197 .118 L .269 .162 L .081 .112 L .387 .76 L .321 .789 L -.08 .255 L -.352 .384 L -.547 1.147 L -.533 .779 L -.71 .725 L -1.001 .755 L -.336 .087 L -1.028 .303 L -.901 .358 L -.809 .499 L -.59 .653 L -.284 .51 L -.987 2.506 L -.267 .312 L -.242 .072 L -.398 -.068 L -.398 -.491 L -.191 -.479 L -.312 -.252 L -.815 .005 L -.444 -.11 L -.105 -.197 L -.097 -.494 L .233 -.34 L .029 -.495 L .005 -.569 L
245.934 224.314 N 1.109 1.843 L .922 1.646 L .08 .24 L -.437 .736 L -.15 .523 L -.143 .848 L .057 .522 L .236 .902 L -.156 .34 L -.221 .34 L -.532 .582 L -.102 .452 L .347 .845 L -.21 .368 L -.159 .34 L .022 .48 L .604 1.168 L .015 .522 L -.285 .439 L -.723 .61 L -.12 .227 L .049 .48 L .132 .295 L .018 .142 L -.586 .187 L -.15 .199 L -.228 .933 L -.259 .298 L -.852 .275 L -.201 -.517 L -.289 -.31 L -1.422 -.618 L -.313 -.239 L -.233 -.678 L -.315 -.38 L -.559 -.225 L -.504 -.281 L -.489 -.254 L -.616 -.309 L -.873 -.464 L -.673 -.366 L -.866 -.379 L -.838 -.337 L -1.271 -.845 L -1.354 -.985 L -1.232 -1.099 L -.594 -.705 L -.42 -.677 L .008 -.438 L 0 -.903 L -.269 -.606 L -.781 -1.043 L -1.389 -2.778 L -.285 -.268 L -.467 -.211 L -.074 -.085 L .055 -.536 L -.02 -.396 L -.149 -.396 L -1.208 -2.199 L -.997 -1.961 L -.688 -1.27 L -1.365 -1.917 L -.272 -.353 L -.598 -.973 L -.462 -.423 L -.75 -.437 L -.914 -.365 L -.61 -.365 L .119 -.17 L .181 -.113 L .609 -.029 L .144 -.41 L -.118 -.282 L -.592 -.874 L -.353 -.437 L -.258 -.72 L .01 -.24 L .244 -.523 L .582 -.622 L 1.02 -.878 L .47 -.198 L .317 -.214 L -.005 .569 L -.029 .495 L -.233 .34 L .097 .494 L .105 .197 L .444 .11 L .815 -.005 L .312 .252 L .191 .479 L .398 .491 L .398 .068 L .242 -.072 L .267 -.312 L .987 -2.506 L .284 -.51 L .59 -.653 L .809 -.499 L .901 -.358 L 1.028 -.303 L .336 -.087 L 1.001 -.755 L .71 -.725 L .533 -.779 L .547 -1.147 L .352 -.384 L .08 -.255 L -.321 -.789 L -.387 -.76 L .927 .107 L .897 .418 L .513 .435 L .208 .324 L .208 .62 L .526 .364 L .988 .672 L .251 .761 L .078 .282 L .366 .14 L .479 .039 L .173 .296 L -.004 .396 L .092 .281 L .573 .152 L 1.038 .008 L .496 -.031 L .337 -.157 L .452 -.427 L .523 .421 L .397 .182 L .708 -.442 L .509 .209 L 1.299 .84 L .127 .069 L -.035 .198 L -1.155 1.956 L .448 -.031 L .161 -.058 L .237 .126 L .575 .703 L .156 .14 L .136 .324 L -.341 .186 L -.793 -.235 L -.493 -.096 L -.322 .072 L -.604 .441 L -.371 .115 L -.669 -.066 L -1.895 .773 L -.701 .442 L -.372 .172 L -.599 1.415 L -.319 .511 L -.021 .155 L .277 .86 L .012 .112 L -.625 .498 L -.62 .328 L -.349 .342 L -.247 .622 L .106 .564 L .619 .957 L 1.333 2.166 L .106 .127 L -.247 .495 L -.208 .312 L 1.085 .12 L .415 .04 L .312 .182 L .241 .323 L .096 .663 L 1.843 .032 L .762 -.499 L .648 -.484 L .326 -.114 L -.059 1.511 L -.098 1.173 L .108 .353 L .317 .337 L .285 .068 L .358 -.072 L .786 -.259 L .42 -.045 L
279.288 257.295 N -.063 -.423 L .027 -.777 L .222 -.819 L .298 -.835 L .321 -.75 L -.019 -.141 L -.491 -.336 L -.234 -.112 L -1.29 .445 L -.224 -.055 L -.254 -.563 L -.487 -2.524 L -.121 -.437 L -.843 -.404 L -.724 -.278 L -.115 .001 L -.709 .413 L -.346 .03 L -.925 -.221 L -.818 -.15 L -.372 -.04 L .006 -.72 L .086 -.721 L .132 -.862 L -.104 -.959 L -.521 -.872 L -.084 -.663 L -.253 -.408 L .421 -.666 L .38 -.765 L .238 -.834 L .185 -1.173 L -.022 -.494 L -.307 -.774 L -.316 -.479 L -.73 -.362 L -.436 -.407 L -.067 -.563 L .261 -.835 L -.042 -.296 L -.693 -.024 L -1.615 -.019 L -.5 -.012 L -.967 -.036 L -.153 -.112 L -.249 -.944 L -.138 -2.032 L -.03 -.706 L -.203 -1.029 L .038 -.565 L -.085 -.169 L -.403 -.237 L -.537 -.166 L -.636 -.123 L -1.148 .077 L -.22 -.084 L -.398 -.308 L -.385 -.774 L -.096 -.014 L -.882 -.037 L -.3 -.098 L -.75 -.603 L -.688 -.307 L -.676 -.25 L -.355 .03 L -.787 -.023 L -.316 -.097 L -1.1 -.939 L -.813 -.928 L -.335 -.591 L -.141 -.635 L -.036 -.818 L .064 -.622 L .079 -.621 L -.045 -.748 L -1.283 -.021 L -.934 .076 L -.36 .158 L -.874 .485 L -1.471 1.109 L -.415 .243 L -.48 -.025 L -.336 -.026 L -.946 .824 L -.355 .03 L -1.122 -.304 L -.939 -.136 L -.42 .045 L -.786 .259 L -.358 .072 L -.285 -.068 L -.317 -.337 L -.108 -.353 L .098 -1.173 L .059 -1.511 L -.326 .114 L -.648 .484 L -.762 .499 L -1.843 -.032 L -.096 -.663 L -.241 -.323 L -.312 -.182 L -.415 -.04 L -1.085 -.12 L .208 -.312 L .247 -.495 L -.106 -.127 L -1.333 -2.166 L -.619 -.957 L -.106 -.564 L .247 -.622 L .349 -.342 L .62 -.328 L .625 -.498 L -.012 -.112 L -.277 -.86 L .021 -.155 L .319 -.511 L .599 -1.415 L .372 -.172 L .701 -.442 L 1.895 -.773 L .669 .066 L .371 -.115 L .604 -.441 L .322 -.072 L .493 .096 L .793 .235 L .341 -.186 L -.136 -.324 L .133 -.198 L .073 -.382 L .706 -4.411 L .326 -1.428 L -.031 -.212 L -.399 -.562 L .031 -.777 L -.192 -.183 L -.688 -.363 L -.192 -.197 L 0 -.554 L .001 -1.071 L .111 -.085 L .493 -.187 L .687 -.032 L .417 .11 L .384 .04 L -.052 -.367 L -.293 -.408 L -.177 -.084 L -.896 -.122 L -.178 -.154 L .013 -1.031 L .042 -.325 L .64 .024 L 2.812 .082 L .463 -.017 L .412 -.158 L .834 -.57 L .52 -.286 L .148 .168 L .138 .437 L .161 .861 L .088 .452 L .199 .437 L .432 .054 L .694 .546 L .482 .223 L .414 -.073 L .757 -.697 L .083 .183 L .186 .776 L .271 -.016 L .645 -.739 L .74 -.654 L .554 -.286 L .652 -.173 L .235 -.213 L .259 -.666 L .203 -.199 L .652 -.131 L .569 -.272 L .265 -.27 L -.15 -.253 L -.434 -.125 L -.96 -.051 L -.166 -.239 L -.079 -.55 L -.302 -1.524 L -.391 -.69 L -.616 -.688 L .041 -.184 L .159 -.029 L .309 .125 L .896 .461 L .385 .04 L 1.149 -.035 L .344 .224 L .628 .618 L .348 -.115 L .232 -1.117 L .284 -.115 L .465 .054 L .557 -.074 L .807 -.23 L 1.74 -.9 L .592 -.385 L .163 -.326 L -.103 -.169 L .375 -.257 L .302 -.058 L .516 .124 L .26 .111 L .04 .212 L -.452 1.09 L .304 -.001 L .533 .138 L .435 .958 L -.179 .368 L -.547 1.416 L -.213 .962 L .156 .465 L .281 .394 L .167 .31 L -.072 .354 L .008 .396 L .15 .296 L 1.103 .897 L .613 .392 L .686 -.075 L .694 -.513 L .505 -.314 L 1 -.331 L .934 -.429 L .943 .022 L .4 .04 L 1.108 .276 L .528 .054 L -.611 -1.014 L .2 -.326 L .172 -.156 L .642 .124 L .418 .139 L .398 -.059 L .534 -.385 L .319 -.001 L 1.05 .488 L .649 .505 L .225 .069 L .882 -.613 L 1.11 .389 L .56 .025 L .299 -.214 L .464 -.681 L .439 -.992 L .427 -.765 L 1.102 -1.646 L -.015 -.422 L .409 -.241 L .276 .141 L .235 .423 L .164 .791 L .414 1.34 L .108 .607 L .472 1.383 L .296 .55 L .324 .324 L .978 .21 L .196 .338 L .038 .551 L -.045 .254 L -.524 .354 L -.933 1.414 L -.238 .325 L -.51 .411 L -.41 .231 L -.244 .138 L -.798 .778 L -.544 .947 L -.419 1.018 L -.402 .453 L .271 .112 L .512 -.072 L .497 -.198 L 1.202 -.709 L .112 -.028 L .299 .889 L .442 .818 L .255 .112 L .287 .07 L 1.135 -.031 L .592 -.058 L .737 -.298 L -.277 .679 L -.017 .584 L .448 -.557 L 1.254 -1.006 L .289 -.156 L .306 -.382 L .499 -.933 L .272 -.396 L .256 -.099 L 1.006 -.003 L .352 -.198 L .175 0 L .687 .549 L .654 .267 L .32 -.028 L .814 .28 L 1.069 .45 L .334 .281 L .269 .593 L .08 .028 L .176 -.015 L .402 -.354 L .319 .042 L .302 .254 L .538 .789 L .205 .396 L -.13 .254 L -.308 .41 L -.116 .424 L .091 .466 L .171 .396 L .825 -.821 L .369 -.156 L .609 -.156 L .995 -.454 L .224 -.028 L .367 .069 L .764 .38 L .907 .436 L .462 .098 L 1.117 .167 L 1.118 .083 L .464 -.058 L .48 -.029 L .577 -.171 L .416 -.016 L 1.131 .351 L .731 .408 L .762 .479 L .586 .437 L 1.595 1.395 L .742 .662 L .821 .605 L .41 .338 L .477 .196 L .734 .168 L 1.247 .097 L .912 .04 L .445 .197 L .265 .465 L .087 .607 L .592 2.004 L .268 1.143 L .062 .988 L -.076 .579 L -.179 .904 L -.243 .848 L -.559 1.301 L -.518 .849 L -1.347 1.175 L -1.388 1.288 L -.44 .198 L -.354 .043 L -.39 .637 L -.094 .396 L -.012 .353 L -.504 1.074 L -.6 .976 L -.8 1.104 L -.266 .212 L -.194 .015 L -.079 -.423 L -.278 -.296 L -.367 -.084 L -.064 .79 L -.538 1.64 L -.049 .734 L -.077 .607 L .318 2.738 L .078 .988 L -.577 2.543 L -.039 .663 L .14 .649 L .043 .085 L -.759 .495 L -.404 .51 L -.261 .791 L -.04 .367 L .245 1.468 L -.106 .367 L -.214 .283 L -.676 .608 L -.752 1.498 L -1.01 1.4 L -.201 .537 L -.055 .311 L .144 .945 L -1.203 .37 L -.544 .283 L -.355 .368 L -.084 .466 L .021 .367 L -.401 .114 L -.864 -.041 L -.979 .172 L -.654 .001 L -.764 -.055 L -.465 -.112 L -.922 .072 L -.736 .002 L -.214 .607 L -.295 .198 L -.795 .312 L -.481 .453 L -.21 .354 L -.747 -.267 L -.35 .071 L -.563 .255 L -1.864 1.232 L -.528 .396 L -.725 .383 L -.616 .438 L -.532 .679 L -.486 .241 L -.567 .072 L -.278 -.014 L .006 .24 L .336 .225 L .12 .536 L -.111 .537 L -.099 .282 L -.282 .156 L -.084 .155 L .384 .648 L .036 1.186 L .05 1.045 L -.057 .311 L -.11 .594 L -.198 .621 L -.464 .735 L -.566 .495 L -.788 .524 L -.866 1.046 L -.208 .396 L -.476 1.145 L -.499 .933 L -.75 1.004 L -.69 .623 L -.801 .78 L .321 -.808 L .436 -.594 L .629 -.566 L .605 -1.158 L -.06 -.254 L -.356 .142 L -.397 -.014 L -.633 -.21 L -.075 .155 L .002 .297 L -.401 1.215 L -.349 .48 L -.661 .438 L -.317 .283 L -.225 .424 L -.013 .354 L -.448 1.709 L -.481 .763 L -.787 .934 L -1.076 .979 L -.101 -.313 L -.258 -.746 L .103 -.269 L .634 -.766 L .017 -.269 L -.333 -.379 L -.163 -.027 L -.131 -.197 L -.853 -1.109 L -.474 -.435 L -.999 -.587 L -.55 -.194 L -.617 -.194 L -.432 -.576 L -.365 -.393 L -.693 .427 L -.27 .016 L -.232 -.38 L -.59 -.814 L -.379 -.407 L -.47 -.364 L -.266 -.098 L -.25 .101 L -1.042 .246 L -.55 .003 L .214 -.27 L .833 -.88 L 1.805 -1.816 L 1.435 -1.363 L 1.633 -1.448 L .348 -.242 L 1.754 -.744 L .521 -.313 L .161 -.467 L .094 -1.638 L -.517 -1.154 L -.206 -.196 L -.462 .017 L -.957 .161 L h 288.966 203.943 m -.558 -.125 L -.301 -.536 L -.078 -.382 L .16 -.197 L -.094 -.636 L .048 -.381 L .208 -1.018 L .176 -.099 L .479 -.058 L .879 .097 L 1.007 .11 L .479 -.199 L .368 .028 L .479 .168 L .479 .083 L .319 .155 L -.335 .538 L -.193 .946 L -.257 .494 L -.289 .312 L -.561 .326 L -.464 .171 L -.527 .015 L -.783 .016 L -.641 .171 L
732.92 214.323 N -.164 -.24 L -.225 -.197 L -.379 -.126 L -.416 .198 L -.399 -.38 L -.287 -.184 L -.659 -.238 L -.243 -.239 L .156 -.255 L .29 .027 L .731 -.058 L .538 .126 L .743 .083 L .523 -.058 L .258 -.185 L .232 -.509 L .056 .099 L .351 .395 L .286 .184 L .241 .014 L .961 -.2 L .366 -.227 L .361 -.722 L .241 -.212 L .653 -.029 L .263 -.128 L .04 -.282 L -.064 -.565 L -.043 -.536 L .495 .196 L .404 .056 L .324 -.354 L .318 .578 L .077 .353 L -.196 .495 L -.099 .184 L -.509 .044 L -.159 .226 L .061 .17 L .437 .479 L -.308 .354 L -.264 .113 L -.742 -.083 L -.416 .001 L -.091 .269 L -.408 .495 L -.275 .156 L -.973 .426 L -.484 .143 L -.798 .029 L -.807 .115 L h 713.795 220.696 m .031 -3.438 L -.046 -.805 L -.431 -1.368 L .44 -.822 L -.169 -7.966 L 2.581 .802 L .85 .337 L 1.04 .295 L 1.254 .378 L .848 .507 L .613 .323 L .597 .084 L .38 -.058 L .26 .508 L .274 .254 L .635 .352 L .687 .395 L .779 .718 L -.3 .947 L .033 .226 L .305 .226 L .665 .111 L 1.887 .787 L .354 .027 L .72 .183 L .181 .254 L .413 .535 L .211 .579 L -.166 .113 L -1.114 .073 L -.563 .156 L -.098 .155 L .047 .339 L .589 .987 L .5 .521 L 1.464 1 L .218 .847 L .725 1.044 L .288 .141 L .304 -.015 L .712 -.086 L .338 .013 L .087 .198 L -.354 .551 L .218 .212 L .401 .141 L .423 .041 L .63 .168 L .096 .127 L -.031 .142 L -.648 .213 L .287 .24 L 1.064 .28 L .538 .295 L .235 .763 L -.064 .226 L -1.094 -.012 L -.215 -.154 L -.146 -.466 L -.126 -.099 L -1.011 -.111 L -1.063 -.266 L -.644 -.126 L -.752 .016 L -.774 -.026 L -.573 -.211 L -.494 -.352 L -.223 -.522 L -.24 -.268 L -.726 -.31 L -.472 -.338 L -.135 -.197 L -1.089 -1.608 L -.613 -.817 L -.454 -.056 L -1.524 -.336 L -.671 -.31 L -.55 -.055 L -.415 .185 L -.394 .071 L -.78 -.45 L .282 .762 L -.027 .212 L -.249 .071 L -.382 -.126 L -.311 .1 L .296 .395 L -.116 .113 L -1.037 .045 L -1.125 -.182 L -.478 .029 L .237 .127 L .24 .154 L .642 .169 L .662 .352 L .404 .338 L .219 .395 L -.411 .199 L -.739 .425 L -.458 .213 L -.668 -.097 L -1.801 -.039 L -1.219 -.092 L
726.605 297.247 N -.479 -.229 L -1.179 -.471 L -.543 -.371 L -.508 -.715 L -.477 -.558 L -.216 -.414 L .264 -.044 L .169 .1 L .421 .171 L .129 -.143 L -.209 -.387 L -.703 -.699 L -.617 -.713 L -.149 -.257 L -.375 -.956 L -.008 -.67 L .177 -.044 L 1.004 .312 L 1.476 .354 L 1.089 .369 L .797 -.03 L .463 -.144 L .382 -.115 L .373 -.058 L .684 .027 L .306 -.301 L .716 -.244 L .475 .385 L -.009 .1 L .128 .8 L -.009 .686 L -.751 1.503 L -.124 .758 L -.245 .315 L -.943 .26 L -.553 .388 L -.49 .689 L -.189 .272 L -.274 .072 L h 716.883 224.344 m .682 .394 L .233 .509 L .047 .649 L .118 .678 L .256 .197 L .42 .013 L .102 .24 L -.45 .919 L .715 .338 L .175 .282 L .147 .593 L .08 1.3 L .144 .621 L .456 1.157 L .293 .268 L .422 .014 L .328 -.312 L .384 -.185 L .32 .663 L .363 .127 L .563 .408 L .385 .154 L .144 .155 L .002 .41 L .083 .96 L .275 .776 L -.046 1.06 L .279 .24 L .93 1.325 L .276 .706 L .055 .777 L -.209 .876 L .403 .649 L .275 .833 L .204 .353 L 1.395 .803 L .285 .154 L .744 .111 L .402 .649 L .843 .535 L .483 .169 L 1.141 .068 L .117 .197 L 731 245.42 l -.273 .565 L .309 .424 L .879 .479 L .22 .564 L .469 1.342 L .211 .748 L .112 .396 L .252 .311 L .771 .352 L -.021 -.127 L -.141 -.777 L .913 .507 L .567 .154 L .184 .127 L .136 .296 L .106 1.752 L .884 .762 L .573 .323 L .604 .154 L .287 .296 L .244 .579 L .229 .424 L .545 .168 L .176 .297 L .007 .269 L .19 .536 L .106 .113 L .506 .126 L .156 .112 L .162 .354 L .366 1.327 L .026 .876 L .013 .862 L -.132 .41 L -.181 .325 L .778 1.271 L .223 .48 L .181 .833 L .034 .749 L -.293 .708 L -.353 1.668 L -.585 1.755 L .137 .791 L -.065 .806 L -.306 .778 L -.661 .977 L -.203 .665 L -.598 .821 L -.45 .185 L -.465 .1 L -.423 .468 L -.466 .68 L -.328 1.527 L -.477 .638 L -.34 .495 L .014 .65 L -.208 .539 L -.331 .312 L -.601 .341 L -.27 .326 L -.3 1.021 L -.169 1.049 L -.079 .937 L .021 .666 L -.283 .64 L -.322 .354 L -.463 .3 L -.754 .101 L -1.158 .087 L -.82 .03 L -.527 .157 L -.516 .299 L -1.529 .94 L -.443 .129 L -.214 .284 L -.346 .071 L -.528 .059 L -.286 -.014 L .295 .368 L .209 .27 L -1.315 -.665 L -.885 -.353 L .003 -.469 L -.073 -.156 L -.56 -.467 L -.628 -.368 L -.421 -.014 L -.485 .172 L -.335 .242 L .748 .467 L -.97 .243 L -.929 .428 L -.953 .442 L -.222 .028 L -.604 -.226 L -.886 -.438 L -.67 -.226 L -1.086 -.311 L -.51 -.041 L -.239 .156 L -.044 .113 L -.716 -.169 L -.751 -.353 L -.522 -.298 L -.896 -.82 L -.526 -.34 L -.422 -.879 L .09 -1.035 L -.082 -.411 L -.184 -.495 L -.664 -.736 L -.141 -.523 L -.029 -.425 L -.534 -.014 L -.786 .398 L -.597 .114 L -.34 .058 L -.178 -.07 L -.167 -.17 L .517 -.454 L .233 -.567 L .073 -.821 L -.253 -.324 L -.536 -.593 L -.247 -.353 L -.485 .735 L -.443 1.431 L -.19 .113 L -.796 .002 L -.199 .156 L -.196 .015 L -.255 .028 L .198 -.396 L .081 -.396 L .079 -.1 L .634 .041 L .242 -.142 L .126 -.255 L -.105 -1.004 L .454 -.835 L .328 -.453 L .091 -.396 L .018 -.409 L .151 -.128 L .245 -.015 L .218 -.354 L -.052 -.227 L -.323 -.494 L -.338 -.494 L -.107 .707 L -.288 .255 L -.518 .299 L -.311 .467 L -.086 .155 L -.189 .467 L -.281 .326 L -.747 .242 L -.735 .481 L -.653 .567 L -.36 .693 L -.514 .808 L -.41 -.339 L -.38 -1.328 L -.263 -.579 L -.19 -.325 L -.688 -.79 L -.297 -.734 L -.176 -.212 L -.704 .072 L -.235 -.099 L -.139 -.24 L -.085 -.269 L .334 -.34 L -.047 -.297 L -.346 -.395 L -.543 -.494 L -.266 -.098 L -.83 .157 L -.486 -.07 L -.95 -.549 L -.274 -.014 L -.438 .17 L -.433 -.027 L -.421 -.183 L -.662 -.521 L -.921 -.437 L -.218 .001 L -.723 .213 L -1.282 .088 L -.669 .001 L -1.764 .061 L -.611 .129 L -.656 .213 L -.989 .44 L -.972 .256 L -1.039 .257 L -1.503 .088 L -.794 -.013 L -.383 .044 L -.927 .284 L -.993 .469 L -.773 .397 L -.538 .143 L -.431 .085 L -.361 .199 L -.615 .693 L -.774 1.02 L -.588 .284 L -.766 -.013 L -.547 -.013 L -.927 .143 L -.4 .185 L -.663 -.395 L -.294 -.084 L -.734 .016 L -1.572 .173 L -.938 .157 L -.459 -.041 L -.672 .044 L -.398 .227 L -.583 .793 L -.344 .128 L -.958 -.125 L -.158 .057 L -.57 .708 L -.465 .368 L -.919 .271 L -.586 .086 L -1.516 -.082 L -.638 -.055 L -.688 -.197 L -.633 -.366 L -.778 -.677 L -.74 -.353 L -.374 -.041 L -.151 -.07 L -.19 -1.229 L .055 -.255 L .489 .112 L .45 -.086 L .332 -.425 L .197 -.467 L .267 -1.357 L -.043 -1.215 L -.156 -.622 L -.258 -.593 L -1.117 -1.906 L -.208 -.635 L -.144 -.834 L .027 -.989 L -.16 -.692 L -.467 -1.072 L -.663 -.945 L -.603 -.734 L -.214 -.254 L .128 -.904 L -.215 -.536 L -.733 -1.115 L -.972 -1.018 L -.273 -.583 L .126 -.233 L .188 .187 L .152 .443 L .183 .163 L .235 .35 L .327 .188 L .354 .023 L -.348 -1.144 L -.437 -.396 L -.226 -.326 L .08 -.304 L .748 .84 L .495 .979 L .477 .065 L -.099 -.555 L .289 -.039 L .004 -.564 L -.282 -.48 L -1.03 -1.368 L -.354 -.691 L -.119 -.579 L -.038 -.734 L .355 -.595 L .323 -.523 L .21 -.664 L -.083 -1.031 L -.254 -.635 L .033 -.368 L .438 -.692 L .109 -.325 L .064 -.156 L .271 .649 L .011 .424 L .105 .184 L .35 .027 L .171 -.113 L .187 -.565 L .141 -.48 L .765 -.468 L 1.22 -.624 L .484 -.326 L .676 -.581 L .585 -.467 L .632 -.327 L .79 -.114 L .697 -.016 L .7 -.002 L .431 -.043 L .352 -.185 L .474 -.453 L .494 -.128 L .929 -.072 L .279 -.143 L .291 -.551 L .158 -.1 L .444 .027 L .877 .224 L .626 -.043 L .911 -.299 L 1.084 -.469 L .359 -.213 L .716 -.665 L .427 -.58 L .29 -.622 L .132 -.297 L .41 -.369 L .968 -.651 L .079 -.17 L -.067 -.409 L -.242 -.805 L -.016 -.495 L 1.063 -1.118 L .387 -.692 L .291 .169 L .341 .437 L .619 1.355 L .262 .253 L .177 -.579 L .021 -.466 L .436 .238 L .272 .07 L .189 -.607 L -.06 -.142 L -.563 -.238 L -.175 -.24 L .007 -.565 L .044 -.112 L .897 .04 L .661 .253 L .642 -.029 L .334 -.029 L .289 .074 L -.699 -.455 L -.431 -.141 L .128 -.537 L -.07 -.296 L .135 -.509 L .422 -.354 L .165 -.07 L .732 .394 L .202 -.043 L -.112 -.452 L .11 -.48 L .146 -.367 L -.041 -.522 L .358 -.171 L .4 -.113 L .813 .04 L .529 -1.088 L .371 -.298 L .35 .169 L .268 .451 L .265 -.552 L .222 -.227 L .197 -.48 L .695 .62 L .513 .084 L .293 .211 L .331 .536 L .632 .592 L .122 .706 L -.072 .594 L .181 .197 L .256 -.283 L .462 -.679 L .155 -.128 L 1.16 .082 L .479 .155 L .637 .492 L .332 .141 L .156 -.48 L .302 -.297 L .022 -.24 L -.266 -.324 L -.601 -.395 L -.079 -.184 L .008 -.24 L .145 -.099 L .604 -.538 L .007 -.452 L .191 -.213 L .518 -.283 L .268 -.241 L .151 -.269 L -.094 -.184 L .003 -.296 L .512 -.863 L .121 -.057 L .317 -.029 L .397 -.029 L .248 -.17 L -.205 -.409 L .377 -.396 L .344 -.071 L .793 .366 L .616 -.072 L 1.291 -.088 L .512 -.128 L .232 -.17 L .04 -.057 L -.077 -.197 L -.2 -.734 L -.248 -.282 L -.471 -.268 L -.374 .086 L -.244 -.141 L .035 -.212 L .367 -.143 L .396 -.043 L .617 .521 L .255 .099 L .34 -.1 L .364 .31 L .676 .465 L .36 .154 L 1.297 .294 L .591 .084 L .413 -.143 L .372 .014 L .396 .606 L .419 .112 L .141 -.029 L .562 -.438 L .454 .027 L .652 .38 L .331 .479 L .46 -.143 L .122 -.791 L .181 -.085 L .455 .465 L .337 .099 L .152 .154 L -.436 .411 L -.126 .424 L -.176 .212 L -.011 .438 L -.12 .255 L -.513 .015 L -.51 .228 L -.396 .34 L -.004 .551 L .301 .353 L -.187 .692 L -.381 .58 L -.559 .481 L -.155 .48 L .063 .17 L .469 .437 L 1.038 .619 L .81 .677 L .508 .606 L .246 .099 L .349 -.114 L .264 .027 L .782 .352 L .742 .465 L .434 .451 L .679 .535 L .335 .127 L .442 .027 L .784 .182 L .25 .184 L .218 .621 L .167 .169 L .507 .31 L .76 .423 L .537 .154 L .422 -.072 L .414 -.17 L .603 -.199 L .208 -.156 L .736 -1.344 L .403 -1.131 L .194 -1.314 L .259 -.721 L .43 -.679 L -.131 -.424 L -.409 -.621 L .022 -.311 L .236 -.637 L .187 -.48 L -.164 -.282 L -.183 -.395 L .088 -.692 L .104 -1.004 L .225 -.297 L .329 -.156 L .158 -.311 L -.534 -.521 L .033 -.198 L .576 -.947 L .312 -.934 L .072 -.833 L .191 -.241 L .279 -.297 L
270.934 276.123 N .054 -.338 L -.194 -.577 L .011 -.522 L .24 -.495 L .48 -.524 L .118 -.325 L -.168 -.986 L -.049 -.847 L .103 -.522 L .595 -2.359 L .065 -.452 L .443 -.524 L .55 -.003 L 1.042 -.246 L .25 -.101 L .266 .098 L .47 .364 L .379 .407 L .59 .814 L .232 .38 L .27 -.016 L .693 -.427 L .365 .393 L .432 .576 L .617 .194 L .55 .194 L .999 .587 L .474 .435 L .853 1.109 L .131 .197 L .163 .027 L .333 .379 L -.017 .269 L -.634 .766 L -.103 .269 L .258 .746 L .101 .313 L -.059 .053 L -.803 1.103 L -.625 .552 L -.775 .454 L -.441 .156 L -.818 .1 L -.874 -.337 L -.551 .044 L -.551 .114 L -.64 .283 L -.38 -.042 L -.846 -.676 L -.637 -.252 L -.76 -.154 L -.469 .128 L -.507 .072 L -.327 -.127 L -.548 -.563 L -.354 -.159 L
418.763 73.869 N .391 -.499 L .389 -.262 L .283 .081 L .663 -.062 L .762 -.075 L .324 -.137 L .891 -.787 L .979 -.2 L .224 .025 L .198 -.219 L .175 .032 L -.349 .531 L .11 .106 L .026 .481 L -.288 .156 L -.17 .368 L -1.675 .069 L -.376 -.106 L -.428 .031 L -.14 -.062 L -.239 .081 L -.275 .031 L -.153 .417 L -.249 .218 L -.353 .118 L -.08 .112 L -.229 -.155 L -.411 -.292 L h 421.68 78.002 m -1.839 .129 L -.116 -.016 L .064 -.404 L -.19 -.638 L -.174 .015 L -.36 -.293 L -.233 .184 L -.398 -.172 L .2 -.355 L .434 -.293 L -.007 -.181 L -.445 -.541 L .018 -.256 L .131 -.498 L .279 -.106 L .318 .15 L .495 .12 L .43 -.574 L .299 -.091 L .296 .437 L .391 -.046 L .022 -.528 L .107 -.363 L 1.032 -.017 L .848 .089 L .03 .544 L .187 .301 L 1.138 .058 L .14 .166 L -.307 .604 L -.565 .142 L -.119 -.261 L -.331 .031 L -.263 .136 L .121 .278 L -.184 .414 L -.312 .077 L -.069 .244 L -.635 .035 L .157 .229 L -.291 .094 L -.191 .24 L -.061 .285 L .003 .21 L -.215 .338 L .166 .084 L h 427.177 77.967 m -.139 -.149 L -.312 -.344 L -.405 .031 L -.665 -.059 L -.123 -.329 L -.285 -.66 L .433 -.091 L .603 -.467 L .356 .495 L .521 .179 L .2 -.271 L .078 -.586 L .333 -.046 L .459 .044 L .056 .571 L -.134 .36 L -.144 .09 L -.413 .286 L .603 .299 L -.285 .166 L -.499 .39 L -.238 .09 L
417.259 94.301 N -.135 -.233 L .216 -.701 L -.091 -.076 L .075 -.295 L .321 -.372 L .054 -.358 L .054 -.213 L .954 -.806 L -.605 -.193 L -.479 .014 L -.456 -.09 L -.095 -.186 L -.233 -.007 L -.072 .048 L -.689 .062 L -.045 -.145 L -.395 .055 L -.337 -.277 L -.428 -.319 L -.074 -.353 L .248 -.144 L .044 -.288 L -.466 -.096 L -.41 -.312 L -.062 -.301 L .422 -.376 L -.038 -.468 L -.282 -.365 L -.344 -.177 L .165 -.278 L -.143 -.217 L -.182 -.037 L .08 -.097 L .235 -.133 L .236 -.133 L -.193 -.121 L .201 -.275 L .095 -.148 L -.152 -.292 L -.082 -.265 L -.376 -.182 L .07 -.182 L .341 -.078 L .175 -.092 L .378 .134 L .664 -.151 L .32 -.152 L .128 -.376 L .412 -.207 L .003 -.328 L -.16 -.17 L -.188 .061 L -.44 -.134 L .029 -.184 L .113 -.181 L .571 .036 L .084 -.401 L .345 -.361 L -.151 -.438 L .066 -.147 L -.465 -.192 L .126 -.43 L .285 -.181 L .371 -.028 L 1.12 -.062 L .293 -.012 L .095 .16 L .195 .271 L -.155 .158 L .324 .113 L .148 -.068 L .042 -.192 L -.159 -.204 L .259 .012 L .437 .169 L -.163 -.362 L .247 -.419 L .687 .113 L .614 -.091 L -.596 -.17 L -.084 -.227 L .282 -.102 L -.252 -.114 L -.12 -.147 L .166 -.08 L .068 -.136 L -.675 .08 L -.06 -.182 L .664 -.125 L .218 -.193 L -.464 -.42 L -.324 -.341 L .045 -.28 L .116 .016 L 1.839 -.129 L .254 .13 L .565 .341 L .271 .297 L -.02 .228 L -.252 .175 L .445 -.05 L .171 .216 L .157 -.078 L .283 .021 L .235 .156 L .45 .073 L .866 -.121 L .077 .208 L -.07 .149 L -.057 .125 L -.665 .295 L .316 .193 L .649 -.136 L .113 .182 L .457 -.006 L .349 -.391 L 1.059 -.136 L .602 -.234 L .757 -.266 L .249 .113 L .396 -.17 L .184 .182 L .085 .159 L .634 .29 L .182 .074 L .526 -.12 L .156 .12 L .059 .34 L .036 .227 L .154 .102 L .354 .125 L .372 -.022 L .028 .13 L .201 .025 L .319 .835 L -.219 .52 L -.391 .147 L -.051 .328 L .391 .102 L .683 .429 L -.217 .395 L .094 .18 L .312 .146 L -.021 .304 L .131 .102 L -.118 .292 L -.214 .124 L -.007 .191 L .325 .27 L -.114 .258 L .468 .188 L .281 .485 L -.435 .698 L -.142 .115 L -.344 -.072 L -.031 -.278 L -.308 -.121 L -.436 .072 L .282 .218 L -.254 .084 L -.284 .097 L -.524 .048 L -.124 .169 L -.735 .024 L -.112 .217 L -.176 -.072 L -.358 .061 L -.097 .229 L -.382 .012 L -.078 .181 L -.442 0 L -.422 .201 L -.293 -.033 L -.26 .181 L -.243 .168 L .037 .056 L .258 .378 L .413 .098 L -.155 .25 L -.08 .406 L .159 .085 L .036 .233 L .244 .173 L .478 .265 L .188 -.072 L .573 .515 L .431 .17 L .184 .201 L .219 -.084 L .165 .18 L .207 .036 L .447 .633 L -.682 .26 L -.437 -.151 L -.132 .027 L -.039 .337 L -.162 .172 L -.968 .295 L -.364 .227 L .538 .571 L -.197 .295 L .334 .014 L .056 .158 L -.098 .343 L -.082 .055 L -.441 -.178 L .049 -.165 L -.146 -.117 L -.564 .062 L -.195 -.138 L -.433 .035 L -.092 .178 L -1.25 .035 L -.125 .171 L -.319 .014 L -.044 .13 L 425.4 94.7 l -.594 .021 L -.059 -.144 L -.093 -.145 L -.493 -.089 L -.262 .055 L -.237 -.041 L .032 .274 L -.452 .343 L -.215 0 L .078 -.195 L -.26 -.039 L .011 -.165 L -.194 -.048 L -.104 -.137 L -.249 -.007 L -.096 -.11 L -.164 .137 L -.368 -.014 L -.664 -.261 L -.852 -.007 L -.149 -.089 L -.199 .014 L -.017 -.151 L -.709 .199 L .179 .199 L -.354 .021 L -.278 -.11 L -.567 .158 L -.271 -.096 L -.272 .117 L -.271 -.089 L h 432.012 80.473 m -.171 -.038 L -.088 -.049 L -.447 .08 L -.111 -.264 L .002 -.213 L .647 .281 L .168 .203 L
450.734 91.05 N -.831 -.33 L -.424 -.101 L -.104 -.216 L -.703 -.186 L -.129 -.13 L -.561 .076 L -.508 -.041 L -.073 .137 L -.373 .18 L -.46 -.254 L -.483 .046 L -.168 -.056 L -.558 .204 L -.104 .177 L -.149 .135 L -.18 -.12 L -.389 .083 L -.003 -.204 L .026 -.083 L -.066 -.18 L -.331 .025 L -.073 -.169 L -.194 -.24 L -.261 .024 L -.062 .112 L -.193 -.016 L -.183 .24 L -.43 .048 L -.03 -.228 L -.285 -.041 L -.105 -.331 L -.382 -.096 L -.188 -.208 L .02 -.249 L -.802 -.132 L -.311 -.181 L -.368 .161 L -.293 -.013 L -.013 -.221 L .001 -.253 L -.329 .084 L .181 -.283 L -.709 .005 L -.258 -.121 L -.509 -.193 L -.286 -.024 L -.003 .145 L .282 .302 L -.41 .12 L -.22 .187 L -.318 -.072 L -.296 -.38 L -.55 -.247 L .224 -.211 L .208 -.024 L .099 -.121 L -.199 -.181 L -.257 -.024 L -.061 .066 L -.466 .066 L .005 -.169 L -.278 .037 L -.132 -.181 L -.568 -.054 L -.201 -.025 L -.363 -.163 L -.093 -.26 L -.211 -.091 L -.361 .018 L -.063 .084 L .062 .073 L -.024 .151 L -.375 0 L .435 -.698 L -.281 -.485 L -.468 -.188 L .114 -.258 L -.325 -.27 L .007 -.191 L .214 -.124 L .118 -.292 L -.131 -.102 L .021 -.304 L -.312 -.146 L -.094 -.18 L .217 -.395 L -.683 -.429 L -.391 -.102 L .051 -.328 L .391 -.147 L .219 -.52 L -.319 -.835 L .34 .043 L .23 .125 L -.093 -.193 L .156 -.153 L -.019 -.147 L -.166 -.13 L -.021 -.129 L -.012 -.075 L .93 -.154 L .431 -.051 L .516 -.152 L 1.304 -.128 L .48 -.158 L .797 -.479 L 1.117 -.298 L 1.515 -.303 L 1.382 -.086 L 1.067 .417 L -.882 -.294 L -.054 .147 L .256 .172 L .132 .466 L .355 .135 L .648 .061 L .645 -.11 L 1.063 -.409 L .054 .004 L -.978 .417 L -.19 .11 L -.004 .123 L .218 .012 L .286 -.123 L .613 -.208 L .543 -.253 L .842 .006 L 2.246 .115 L 2.96 -.101 L .641 -.021 L .04 .014 L .679 .243 L .284 .487 L .099 .186 L .016 .029 L .09 .171 L .16 .302 L .615 1.5 L .172 .502 L -.023 .236 L -.263 .208 L -.44 .03 L -.571 .244 L -.291 .328 L -.128 .292 L .289 .012 L .421 .146 L .149 .176 L .218 .146 L .013 .25 L -.315 .752 L .126 .137 L .161 .175 L -.074 .242 L .816 .835 L .316 .193 L -.298 .048 L -.085 .133 L .328 .302 L -.009 .314 L -.255 .24 L -.429 .013 L -.286 .181 L -.599 .398 L -1.509 1.218 L -.082 .306 L .044 .552 L .349 .383 L -.653 -.018 L h 431.844 80.27 m .232 .024 L .069 .208 L -.134 -.029 L -.168 -.203 L h 432.739 80.361 m -.03 .129 L -.278 -.024 L -.191 .03 L -.046 -.208 L .174 -.012 L .266 0 L .106 .085 L
416.488 81.945 N .151 .438 L -.345 .361 L -.084 .401 L -.571 -.036 L -.113 .181 L -.029 .184 L .44 .134 L .188 -.061 L .16 .17 L -.003 .328 L -.412 .207 L -.128 .376 L -.32 .152 L -.664 .151 L -.378 -.134 L -.175 .092 L -.341 .078 L -.07 .182 L .376 .182 L .082 .265 L .152 .292 L -.095 .148 L -.201 .275 L .193 .121 L -.236 .133 L -.235 .133 L -.08 .097 L .182 .037 L .143 .217 L -.165 .278 L -.672 .024 L -.001 -.338 L .172 -.097 L .11 -.423 L -.754 -.375 L -.535 .109 L -.292 -.375 L -.228 -.061 L -.173 .121 L -.313 -.242 L -.267 .182 L -.307 0 L -.307 -.012 L .025 .157 L -.52 .034 L -.407 -.042 L -.477 -.098 L -.07 -.162 L -.496 -.264 L .795 -.472 L .858 -.621 L .273 -.354 L .563 -1.167 L .173 -.104 L .644 -.12 L .367 .251 L .136 .268 L -.28 .203 L -.228 -.056 L .066 .496 L -.191 .124 L 1.163 .225 L .225 -.236 L .406 -.113 L .134 -.417 L -.458 -.022 L -.123 -.124 L -.02 -.203 L .236 -.158 L -.171 -.023 L -.558 -.067 L .072 -.328 L -.034 -.13 L -.023 -.034 L .128 -.283 L .572 -.198 L .709 -.238 L .654 .03 L 1.089 -.151 L .245 .275 L .329 .045 L .076 .181 L .259 0 L
431.57 91.965 N -.447 -.633 L -.207 -.036 L -.165 -.18 L -.219 .084 L 430.349 91 l -.431 -.17 L -.573 -.515 L -.188 .072 L -.478 -.265 L -.244 -.173 L -.036 -.233 L -.159 -.085 L .08 -.406 L .155 -.25 L -.413 -.098 L -.258 -.378 L -.037 -.056 L .243 -.168 L .26 -.181 L .293 .033 L .422 -.201 L .442 0 L .078 -.181 L .382 -.012 L .097 -.229 L .358 -.061 L .176 .072 L .112 -.217 L .735 -.024 L .124 -.169 L .524 -.048 L .284 -.097 L .254 -.084 L -.282 -.218 L .436 -.072 L .308 .121 L .031 .278 L .344 .072 L .142 -.115 L .375 0 L .024 -.151 L -.062 -.073 L .063 -.084 L .361 -.018 L .211 .091 L .093 .26 L .363 .163 L .201 .025 L .568 .054 L .132 .181 L .278 -.037 L -.005 .169 L .466 -.066 L .061 -.066 L .257 .024 L .199 .181 L -.099 .121 L -.208 .024 L -.224 .211 L .55 .247 L .296 .38 L .318 .072 L .22 -.187 L .41 -.12 L -.282 -.302 L .003 -.145 L .286 .024 L .509 .193 L .258 .121 L .709 -.005 L -.181 .283 L .329 -.084 L -.001 .253 L .013 .221 L .293 .013 L .368 -.161 L .311 .181 L .802 .132 L -.02 .249 L .188 .208 L .382 .096 L .105 .331 L -.071 -.012 L -.065 .066 L -.066 .04 L -.105 -.026 L 442 89.998 l -.119 .013 L -.065 .04 L -.132 .066 L -.053 .079 L -.118 .092 L -.119 .053 L -.132 .079 L -.105 .013 L -.118 .013 L -.053 .092 L -.026 .092 L -.026 .132 L -.053 .079 L -.053 .105 L -.145 .066 L -.105 .04 L -.092 -.026 L -.079 .079 L -.04 .092 L -.053 .079 L -.039 0 L -.105 .026 L -.066 .026 L -.079 .053 L -.118 .053 L -.132 0 L -.145 .04 L -.093 .026 L -.065 -.026 L -.065 -.026 L -.093 0 L -.065 .026 L -.158 0 L -.132 -.053 L -.092 -.053 L -.093 .026 L -.171 .053 L -.026 .04 L -.146 .119 L -.092 .066 L -.014 .131 L -.065 .105 L -.039 .044 L -.055 -.095 L -.545 -.2 L -1.332 .181 L -1.019 -.227 L -1.374 -.341 L -.746 .773 L -.598 .163 L -.483 -.099 L -.354 -.129 L -.145 -.014 L
421.683 94.397 N .368 .014 L .164 -.137 L .096 .11 L .249 .007 L .104 .137 L .194 .048 L -.011 .165 L .26 .039 L -.078 .195 L .215 0 L .452 -.343 L -.032 -.274 L .237 .041 L .262 -.055 L .493 .089 L .093 .145 L .059 .144 L 425.4 94.7 l .377 -.103 L .044 -.13 L .319 -.014 L .125 -.171 L 1.25 -.035 L .092 -.178 L .433 -.035 L .195 .138 L .564 -.062 L .146 .117 L -.049 .165 L .441 .178 L .082 -.055 L .098 -.343 L -.056 -.158 L -.334 -.014 L .197 -.295 L -.538 -.571 L .364 -.227 L .968 -.295 L .162 -.172 L .039 -.337 L .132 -.027 L .437 .151 L .682 -.26 L .145 .014 L .354 .129 L .483 .099 L .598 -.163 L .746 -.773 L 1.374 .341 L 1.019 .227 L 1.332 -.181 L .545 .2 L .055 .095 L .053 .093 L -.097 .581 L .155 .26 L .761 .547 L -.636 .291 L -.019 .367 L -.701 .054 L -.164 -.134 L -.325 0 L -.223 .197 L .452 .063 L .136 .196 L -.157 .206 L -.409 .062 L -.04 .375 L .204 .188 L -.154 .294 L -.346 .299 L -.693 .157 L .082 .393 L -.89 -.116 L -.298 .196 L -.85 -.08 L -.566 .107 L -.646 .5 L -.287 -.152 L -.612 .009 L -.179 -.107 L -1.04 -.065 L -.478 -.112 L -.894 -.082 L -1.311 -.247 L -.32 -.391 L -.318 -.096 L -.023 -.363 L -.856 .227 L -.301 -.103 L -.445 .11 L -.183 -.083 L -.366 .096 L -.329 .411 L -.597 -.034 L -.631 -.171 L .029 -.171 L -.215 -.117 L -.579 .332 L -.55 -.242 L -.008 -.144 L -.622 -.062 L .09 -.192 L -.214 -.288 L .266 -.274 L -.193 -.336 L
431.763 171.063 N -.067 .354 L .091 .72 L .108 .508 L .225 .168 L .562 .11 L .144 .183 L .077 .353 L -.089 1.116 L -.146 .227 L -.274 .171 L -.885 .217 L -.291 .256 L -.664 1.275 L -.503 1.203 L -.243 1.004 L -.354 .129 L -.369 .03 L -.129 .354 L -.146 1.229 L -.192 .312 L -.385 .045 L -.257 .284 L -.417 .836 L -.944 2.223 L -.304 .624 L -.352 .496 L -.368 .355 L -.239 .114 L -.145 -.056 L -.722 -.97 L -.145 -.14 L -1.104 -.05 L -.272 .03 L -1.31 1.265 L -.941 .839 L -.495 .526 L .02 .974 L -.189 .552 L -.376 .686 L -.188 -.119 L -.224 -.042 L -.176 -.127 L -.145 .212 L .144 .296 L -.063 .127 L -.353 .198 L -.56 .03 L -.977 .101 L -.607 -.267 L -.288 .043 L -.271 .368 L -.177 .113 L -.432 -.07 L -1.247 -.011 L -.528 -.225 L -.543 -.451 L -.416 -.72 L -.192 -.649 L .048 -.254 L .208 -.254 L -.144 -.296 L -.513 -.069 L -.128 -.254 L -.464 -.55 L -.561 -.465 L -.608 -.253 L -.641 -.253 L -.272 -.31 L -.513 .072 L -.24 .297 L -.336 .071 L -.881 .044 L -.659 .03 L -.006 -.234 L .121 -1.188 L -.217 -1.439 L .09 -.989 L .012 -.876 L -.003 -.48 L -.002 -.381 L .237 -.397 L .257 -.03 L .433 -.13 L .078 -.368 L -.116 -.592 L .095 -.34 L .656 -.414 L .223 -.298 L .19 -.566 L .316 -.962 L -.388 -.718 L -.164 -.762 L .062 -.777 L .092 -.961 L .158 -.849 L .353 -.482 L .687 -1.614 L .676 -.4 L 1.064 -.188 L 1.174 -.108 L 1.111 .121 L .821 .277 L 1.095 1.223 L .209 .098 L .37 -.002 L 1.337 -.544 L .467 -.116 L .354 .083 L 1.173 .742 L .965 .277 L .934 -.005 L .273 -.059 L .629 -.399 L .403 -.327 L .774 -.287 L .628 -.103 L .709 -.047 L .531 .04 L .884 .221 L .724 .193 L .609 .208 L .259 -.058 L .761 -.697 L .453 -.299 L .437 -.2 L .951 -.034 L .173 .394 L .575 .52 L .351 .407 L
425.506 195.522 N -1.965 -.017 L -1.005 .007 L .029 -.176 L -.208 -.536 L .271 -.989 L -.159 -.72 L -.191 -.522 L -.399 -.649 L .433 -.396 L -.287 -.367 L -.24 -.056 L -.576 .058 L -.559 -.268 L -.176 -.324 L -.063 -.537 L -.111 -.211 L -.527 -.14 L -.101 -.064 L .376 -.686 L .189 -.552 L -.02 -.974 L .495 -.526 L .941 -.839 L 1.31 -1.265 L .272 -.03 L 1.104 .05 L .145 .14 L .722 .97 L .145 .056 L .239 -.114 L .368 -.355 L .352 -.496 L .304 -.624 L .944 -2.223 L .417 -.836 L .257 -.284 L .385 -.045 L .192 -.312 L .146 -1.229 L .129 -.354 L .369 -.03 L .354 -.129 L .243 -1.004 L .503 -1.203 L .664 -1.275 L .291 -.256 L .885 -.217 L .274 -.171 L .146 -.227 L .089 -1.116 L -.077 -.353 L -.144 -.183 L -.562 -.11 L -.225 -.168 L -.108 -.508 L -.091 -.72 L .067 -.354 L .627 .109 L .208 .083 L .923 1.238 L .395 .887 L .119 1.2 L -.134 .651 L .169 1.228 L .205 .578 L .381 .633 L .208 .21 L .047 .127 L -.225 .143 L -.674 .032 L -1.187 -.191 L -.481 -.082 L -.24 .1 L -.29 .312 L -.323 .539 L 1.088 1.067 L 1.343 1.179 L .638 1.07 L .382 1.057 L .208 .183 L -.208 .114 L -.354 .327 L -.866 1.743 L -.4 .511 L -.528 .399 L -.144 .198 L -.064 .424 L .112 .776 L .273 1.185 L .207 .592 L .4 .661 L .432 .605 L .064 .791 L .112 .324 L 1.217 1.236 L .498 .802 L .194 .804 L .209 .451 L -.159 .185 L .1 .861 L -.271 .086 L -.863 -.292 L -.864 -.334 L -.576 -.194 L -.56 -.124 L -.479 -.04 L -.271 -.055 L -.878 .076 L -.863 -.023 L -.56 -.109 L -1.022 -.149 L -.831 -.038 L -1.773 -.088 L -.88 -.093 L -.045 .495 L
551.793 147.278 N -.788 -.111 L -.458 -.253 L -.379 -.367 L -.248 -1.101 L -.112 -.141 L -.342 -.141 L -.662 -.083 L -.105 -.07 L -.014 -.268 L .116 -.466 L -.178 -.451 L -.418 -.38 L -.294 -.013 L -1.181 .412 L -1.229 .087 L -.81 .143 L -.947 .073 L -.415 -.083 L -.263 -.226 L -.135 -.197 L -.909 .143 L -.548 .382 L -.856 .016 L -1.264 -.011 L -.691 .128 L -.723 .115 L -.541 .03 L .182 -.954 L .049 -.354 L .31 -.792 L .285 -.383 L .794 -.47 L .697 -.258 L 1 -.077 L .209 -.072 L .188 -.255 L .036 -.974 L -.186 -.281 L -.652 -.053 L -.185 -.394 L -.111 -1.34 L -.168 -.38 L -.409 -.224 L -1.144 -.388 L -.695 -.391 L -.353 -.464 L -.71 -1.068 L -.802 -1.083 L .887 .32 L .63 .194 L 1.069 .248 L .854 .235 L .541 .039 L .742 .024 L 1.187 -.218 L .349 -.002 L 1.005 .135 L 1.234 -.12 L .964 -.175 L 1.183 -.19 L 1.066 -.274 L .247 -.156 L .069 -.184 L .099 -.903 L .232 -.876 L .188 -.34 L .412 -.369 L .597 -.441 L .283 -.072 L .644 .039 L .516 .082 L .254 -.086 L .321 -.693 L .362 -.271 L .559 -.243 L .562 .025 L 1.001 .375 L .237 -.086 L .34 -.383 L .021 -.084 L .139 -1.214 L .288 -.834 L .224 -.424 L .292 -.228 L .416 -.115 L .513 -.031 L .315 -.115 L .199 -.255 L -.088 -.437 L -.129 -.281 L 556.193 125 l -.35 -.336 L .355 -.129 L .997 .122 L .698 .039 L .513 -.215 L .289 -.255 L -.033 -.31 L -.223 -.478 L .13 -.283 L .4 -.341 L .524 -.355 L .324 -.426 L -.198 -.477 L .119 -.483 L -.232 -.171 L -.01 -.336 L -.411 -.271 L -.01 -.32 L .464 -.413 L .258 -.214 L .246 .023 L .559 -.395 L .272 -.19 L .53 -.292 L 1.148 -.152 L 1.345 -.012 L .647 .144 L .338 -.179 L .332 .005 L .455 -.297 L .358 -.004 L .148 -.142 L .313 .14 L .105 .112 L .281 -.21 L .296 .047 L .554 .117 L .004 .456 L .282 -.128 L .625 -.009 L .373 .323 L .213 .247 L .007 .501 L -.312 .516 L .301 .07 L .198 .218 L .252 .281 L .52 -.196 L .239 0 L .104 .199 L .178 .09 L .565 .436 L 1.337 .104 L .305 .111 L .147 .126 L -.207 .084 L -.688 .37 L -.411 .232 L -.155 .43 L -.071 .479 L -.234 .116 L -.125 -.179 L -.621 -.102 L -.438 .132 L -.271 .298 L -.262 -.116 L -.557 .265 L -.928 -.149 L -.568 -.138 L -1.708 -.325 L -.894 .265 L -.38 .611 L .09 .166 L .336 0 L .047 .314 L -.202 .149 L .101 .199 L .598 -.017 L -.002 .347 L -.384 .099 L -.139 .413 L .389 .232 L -.116 .479 L -.215 .132 L .089 .248 L .606 .298 L -.003 .532 L .782 -.003 L -.039 .43 L .188 .248 L .702 -.05 L .668 .377 L .012 .211 L -.2 .255 L -.504 .2 L -.643 .196 L -.517 .248 L .032 .366 L .188 .377 L -.237 .977 L -1.512 1.503 L .261 .38 L -.358 .281 L -.609 .133 L -.353 .467 L -.509 1.216 L -.478 .547 L -1.193 .496 L -.177 .364 L -.277 .481 L -.563 .61 L -.076 .38 L -.71 .259 L -.734 -.011 L -.895 .314 L -.361 -.094 L -.158 -.518 L -.207 -.132 L -.404 .083 L -.535 .463 L -.144 .446 L -.979 .893 L -.186 .543 L -.079 .269 L .116 .38 L .541 .163 L .504 .085 L .425 .014 L -.114 .689 L -.154 .735 L .412 .411 L .33 .099 L .537 -.099 L .112 .441 L .216 .507 L .654 1.333 L -.232 .149 L .241 .463 L -.317 .066 L -.15 .248 L -.55 .083 L -.145 -.335 L -.183 -.062 L -.78 .215 L -.2 .331 L -.735 -.099 L -.229 -.149 L -.835 -.021 L -.835 -.009 L -.259 -.052 L .015 .728 L -.866 .017 L -.296 .431 L -.37 .036 L
606.155 150.953 N -.037 -.466 L -.627 -2.479 L -.064 -.578 L -.4 .044 L -.281 .115 L -.395 1.159 L -.224 .354 L -.529 -.448 L -.249 -.267 L -.23 -.281 L -.001 -.381 L -.009 -.522 L .131 -.283 L .651 -.356 L .498 -.13 L .938 -.767 L .159 -.34 L .012 -.79 L -.057 -.127 L -.111 -.098 L -2.473 -.198 L -.559 .003 L -.916 .062 L -.547 -.053 L -.537 -.109 L -.095 -.099 L -.079 -.719 L -.053 -.479 L -.129 -.324 L -.417 -.054 L -.489 .06 L -.372 -.266 L -.339 -.266 L -1.252 -.303 L -.234 .171 L -.555 .525 L -.124 .283 L .083 .155 L .494 .237 L 1.224 .938 L .126 .112 L -.047 .155 L -.382 .101 L -.502 .13 L -.4 .299 L -.548 .61 L .339 .323 L 1.042 .431 L .193 .21 L -.029 .269 L -.505 .765 L .04 .254 L .352 .45 L .325 1.409 L .402 1.775 L .147 .532 L -.172 .322 L .068 .183 L -.321 .071 L -.35 -.056 L -.148 -.706 L -.198 -.084 L -.253 .354 L -.171 .354 L -.172 .057 L -.115 -.099 L -.28 -.592 L -.152 -.169 L -.412 .537 L -.504 .298 L -.992 .397 L -.571 .213 L -.264 .226 L -.05 .113 L .106 .579 L .183 .409 L -.336 .495 L -.305 .332 L -.013 .257 L -.548 .415 L -.593 .467 L -.467 .185 L -.432 .057 L -.746 .206 L -.591 .362 L -.459 .58 L -.551 .552 L -.88 1.061 L -.611 .552 L -.673 .276 L -.675 .829 L -.676 .467 L -.728 .368 L -.452 .241 L -.427 .312 L -.192 .509 L -.073 .466 L -.341 .41 L -.649 .298 L -.428 .058 L -.506 -.098 L -.258 .269 L -.366 .887 L -.277 .23 L -.505 -.253 L -.614 .142 L -.354 .283 L -.304 .565 L -.165 .48 L -.005 .508 L .166 1.539 L .018 .805 L -.208 .495 L .227 .324 L .315 .423 L -.015 .508 L -.199 .607 L -.669 1.611 L -.341 .834 L -.13 .636 L .047 .649 L .21 1.764 L -.081 .24 L -.643 .001 L -.433 -.013 L -.186 .142 L -.334 .961 L -.324 .594 L .025 .127 L .493 .352 L -.805 .327 L -.306 .015 L -.77 .284 L -.295 .41 L -.101 .692 L -.157 .255 L -.367 .283 L -.526 .255 L -.099 .057 L -.066 .042 L -.231 .156 L -.145 0 L -.174 -.056 L -1.417 -1.451 L -.092 -.395 L -.276 -.522 L -.34 -1.397 L -.689 -1.792 L -.94 -1.933 L -.979 -1.508 L -.554 -1.722 L -.507 -1.792 L -.738 -1.636 L -.82 -1.42 L -.424 -.737 L -.598 -1.439 L -.363 -1.157 L -.767 -3.274 L -.469 -2.695 L -.157 -1.566 L -.051 -.24 L .232 -.565 L .546 -.834 L .007 -.311 L -.404 -.281 L -.367 -.437 L -.113 -.635 L -.108 -.917 L .065 -.622 L -.837 .03 L -.19 .212 L -.235 .424 L .009 .183 L .276 .254 L .074 .183 L -.073 .438 L -.301 .438 L -.503 .368 L -.812 .369 L -.504 .114 L -.617 .255 L -.377 .015 L -.861 -.281 L -.572 -.38 L -1.018 -1 L -1.391 -1.268 L -.516 -.705 L .267 -.043 L 1.062 .125 L .615 -.086 L .443 -.142 L .461 -.283 L .521 -.608 L -.067 -.24 L -.156 .071 L -.587 .114 L -.847 -.026 L -.607 -.112 L -.632 -.132 L -.5 -.218 L -.203 -.07 L -.929 -.661 L -.668 -.775 L -.057 -.197 L .37 -.036 L .296 -.431 L .866 -.017 L -.015 -.728 L .259 .052 L .835 .009 L .835 .021 L .229 .149 L .735 .099 L .2 -.331 L .78 -.215 L .183 .062 L .145 .335 L .55 -.083 L .15 -.248 L .317 -.066 L -.241 -.463 L .232 -.149 L -.654 -1.333 L -.216 -.507 L -.112 -.441 L 557 143.058 l -.33 -.099 L -.412 -.411 L .154 -.735 L .114 -.689 L -.425 -.014 L -.504 -.085 L -.541 -.163 L -.116 -.38 L .079 -.269 L .186 -.543 L .979 -.893 L .144 -.446 L .535 -.463 L .404 -.083 L .207 .132 L .158 .518 L .361 .094 L .895 -.314 L .734 .011 L .71 -.259 L .076 -.38 L .563 -.61 L .277 -.481 L .177 -.364 L 1.193 -.496 L .478 -.547 L .509 -1.216 L .353 -.467 L .609 -.133 L .358 -.281 L -.261 -.38 L 1.512 -1.503 L .237 -.977 L -.188 -.377 L -.032 -.366 L .517 -.248 L .643 -.196 L .504 -.2 L .2 -.255 L -.012 -.211 L -.668 -.377 L -.702 .05 L -.188 -.248 L .039 -.43 L -.782 .003 L .003 -.532 L -.606 -.298 L -.089 -.248 L .215 -.132 L .116 -.479 L -.389 -.232 L .139 -.413 L .384 -.099 L .002 -.347 L -.598 .017 L -.101 -.199 L .202 -.149 L -.047 -.314 L -.336 0 L -.09 -.166 L .38 -.611 L .894 -.265 L 1.708 .325 L .568 .138 L .928 .149 L .557 -.265 L .262 .116 L .271 -.298 L .438 -.132 L .621 .102 L .125 .179 L .234 -.116 L .071 -.479 L .155 -.43 L .411 -.232 L .688 -.37 L .207 -.084 L .502 -.152 L 0 .515 L .441 1.03 L .221 .515 L .81 .11 L .441 .405 L .221 .258 L -.331 .221 L -.184 .184 L .073 .589 L .037 .552 L .294 .221 L .718 .096 L .092 .078 L .044 .182 L .68 .099 L -.104 .414 L .367 .694 L -.578 .364 L -.376 .281 L -.368 .049 L -.337 -.264 L -.033 -.364 L -.785 .198 L .157 .694 L .579 .595 L -.104 .446 L .272 .364 L -.215 .215 L .099 .43 L .198 .066 L .477 -.314 L .383 .248 L .772 .843 L .363 -.116 L 1.078 .579 L -.116 .364 L .756 .248 L .154 -.066 L .859 .596 L -1.07 .909 L -.281 .116 L .008 .364 L -.221 .265 L .04 .396 L -.309 .397 L -.218 .43 L .039 .248 L .63 .38 L .466 -.083 L .665 .479 L .704 .149 L .305 .529 L 1.242 .678 L .231 -.166 L 1.027 .595 L .538 -.066 L .182 .397 L .835 .166 L .304 .198 L .15 -.066 L .087 -.215 L .503 0 L .482 .265 L .582 -.347 L .494 .298 L .643 .066 L .142 .231 L -.101 .446 L .663 .149 L .286 .281 L .618 .265 L .584 -.281 L .313 .066 L -.034 .331 L .312 .248 L .379 -.231 L .721 .148 L .847 .364 L .606 -.297 L .268 .364 L .399 .116 L .357 -.132 L .271 .083 L .687 -.132 L .336 .05 L .311 -.694 L -.429 -.827 L .07 -.876 L .318 -.761 L -.037 -.022 L .345 -.129 L .471 -.102 L .231 .069 L .139 .183 L -.052 .861 L .212 .662 L -.092 .113 L .235 .493 L .637 .18 L .559 .081 L .869 .214 L .085 .021 L .544 -.074 L .531 -.313 L .301 .055 L .335 .125 L 1.238 .063 L 1.036 -.062 L .624 -.06 L .217 -.58 L -.017 -.282 L -.258 -.238 L -.313 -.069 L -.326 -.294 L -.042 -.24 L .07 -.156 L .189 -.1 L .784 -.033 L .714 -.216 L .397 -.27 L 1.123 -1.107 L .543 -.37 L .829 -.258 L 1.105 -.726 L .546 -.299 L .355 -.087 L .286 .167 L .975 .319 L .377 -.044 L 1.377 -.84 L .455 .392 L .716 .715 L .046 .38 L -.354 .454 L -.138 .269 L .102 .056 L .3 .055 L .657 .081 L .73 .179 L .624 .081 L -.018 .508 L -.112 .24 L -.596 .582 L -.072 .283 L .184 .718 L -.295 .058 L -.853 -.221 L -.558 -.082 L -.312 .129 L -.719 .512 L -1.446 .883 L -.197 .354 L .057 .761 L -.136 .382 L -.938 1.134 L -.045 .212 L .192 .408 L 0 .324 L -1.148 2.25 L -.17 .128 L -.309 -.013 L -.391 -.11 L -.811 -.32 L -.133 .283 L .146 1.594 L -.191 .354 L -.401 .144 L -.228 .185 L .152 .93 L -.015 .678 L -.273 .368 L -.25 .129 L -.255 -.14 L -.595 -.152 L
478.516 135.173 N .052 -.292 L -.049 -.169 L -.197 -.107 L .107 -.175 L .292 -.919 L -.015 -.818 L .517 -1.09 L .3 -.891 L -.004 -.409 L .133 -.283 L .07 -.749 L .033 -.847 L .062 -.174 L .026 -.278 L -.065 -.411 L .037 -.119 L .102 -.063 L 1.902 1.034 L .365 .167 L .253 -.016 L 1.139 -.656 L 2.96 -1.541 L .161 -.071 L .87 1.632 L .311 .69 L .093 .056 L -.46 .44 L -.257 .171 L -.97 .26 L -2.586 .622 L -.646 .229 L 1.146 1.32 L .698 .885 L -.765 .724 L -.456 .37 L -.24 .072 L -1.249 .332 L -.462 .61 L -.975 .782 L -2.079 -.299 L -.154 -.017 L
456.028 151.46 N -.021 1.003 L .033 3.078 L -.088 .17 L -1.561 -.019 L -.52 -.011 L -.073 1.13 L -1.981 -.963 L -5.577 -2.792 L -4.941 -2.372 L -5.231 -2.554 L -.41 .059 L -1.818 .858 L -1.519 .729 L -.231 .157 L -1.192 -.911 L -.258 -.182 L -1.008 -.333 L -1.646 -.442 L -.832 -.137 L -.098 -.07 L -.86 -1.506 L -.178 -.168 L -1.028 -.347 L -.702 -.165 L -.544 .201 L -.244 -.154 L -.562 -.873 L -.249 -.917 L -1.272 -1.702 L .152 -.283 L .249 -.128 L .666 -.47 L .086 -.17 L .061 -.664 L -.457 -1.156 L .158 -.495 L .16 -.622 L -.101 -.748 L .1 -.862 L -.052 -.691 L -.147 -.833 L -.88 -1.605 L .241 -.383 L .204 -.156 L .22 -.143 L .864 -.598 L .155 -.227 L .147 -.537 L -.274 -.973 L .126 -.354 L 1.473 -1.138 L .579 -.314 L .802 -.428 L .093 -.269 L -.064 -.564 L .093 -.981 L 1.436 .59 L .995 .309 L .521 .013 L .863 -.129 L .604 .027 L 1.552 .223 L .614 .479 L .794 .224 L .486 -.001 L .342 .197 L .173 .226 L .26 .819 L .39 .564 L .688 .591 L .378 .126 L .678 .14 L 1.031 .083 L .447 .07 L .973 .224 L .639 .224 L .552 .281 L 1.289 .788 L .84 .464 L .465 .013 L .441 -.128 L .758 -.411 L .706 -.623 L .3 -.523 L 0 -.254 L -.276 -.621 L -.112 -.579 L .044 -.41 L .237 -.537 L .661 -.58 L .333 -.198 L .554 -.241 L .644 -.298 L 1.376 -.413 L 1.205 .054 L .728 .154 L .844 .365 L .188 .169 L .043 .508 L .281 .253 L .301 .014 L .945 .125 L .712 .309 L .45 .027 L 1.286 .04 L .302 .197 L .068 .381 L .276 .296 L -.099 .208 L -.369 .228 L -.21 .34 L .354 1.283 L -.231 .425 L -.322 .553 L -.056 .311 L .185 .945 L .388 .916 L .042 .367 L -.015 .988 L -.019 3.869 L -.016 1.468 L -.008 2.048 L -.001 .692 L .045 2.81 L -.021 1.342 L .011 2.612 L
478.212 134.714 N -.834 -1.746 L -.796 -1.944 L -.124 -.289 L .109 -.066 L .679 -.851 L .219 -.438 L .183 -.507 L .171 -.566 L .188 -.822 L .116 .018 L .137 -.093 L .006 -.204 L .028 -.315 L .372 -.051 L .151 .022 L .07 .099 L .355 -.07 L .009 -.167 L .067 -.193 L .088 -.041 L .07 .023 L .183 .346 L .201 .128 L .021 .183 L -.047 .122 L .082 .085 L -.102 .063 L -.037 .119 L .065 .411 L -.026 .278 L -.062 .174 L -.033 .847 L -.07 .749 L -.133 .283 L .004 .409 L -.3 .891 L -.517 1.09 L .015 .818 L -.292 .919 L -.107 .175 L -.067 .068 L -.042 .042 L
495.751 163.817 N -.03 -.184 L -.112 -.537 L -.508 -.945 L -.73 -.987 L -.438 -.493 L -.846 -.69 L -.51 -.875 L -.814 -1.876 L -.474 -.889 L -.28 -.409 L -.794 -.507 L -1.271 -.689 L -.527 -.634 L -.8 -1.17 L -.081 -.96 L -.061 -.776 L -.002 -.89 L -.104 -.381 L -.312 -.663 L -.944 -1.65 L -.357 -.494 L -.758 -.62 L -.459 -.225 L -.499 -.126 L -.308 -.282 L -.483 -.578 L .149 -.692 L -.111 -.437 L -.474 -.818 L -.747 -1.072 L -.793 -.902 L -1.069 -1.494 L -.525 -.931 L -.352 -.479 L -.722 -.761 L -.524 -.056 L -.248 0 L .077 -.296 L .193 -.283 L .311 -1.314 L .104 -.583 L .154 .017 L 2.079 .299 L .975 -.782 L .462 -.61 L 1.249 -.332 L .24 -.072 L .456 -.37 L .765 -.724 L -.698 -.885 L -1.146 -1.32 L .646 -.229 L 2.586 -.622 L .97 -.26 L .257 -.171 L .46 -.44 L .093 .056 L 1.129 .459 L .757 .222 L 2.034 .934 L 1.14 .473 L 2.44 1.101 L .258 .196 L .399 .633 L .141 .07 L .973 -.048 L .135 .366 L -.118 .396 L .047 .818 L .118 .253 L .812 .277 L 1.557 .697 L 4.048 .132 L 1.657 .259 L .408 .054 L .334 .619 L .185 .239 L 1.07 .05 L .644 -.044 L .043 .121 L .277 .648 L .365 .494 L .178 .663 L .052 .113 L .615 -.029 L .248 .126 L -.204 .237 L .194 .187 L .184 .282 L .234 .067 L .234 .27 L .886 .168 L .423 .437 L -.07 .28 L -.235 .035 L -.111 .25 L .316 .381 L -.188 .593 L -.122 .198 L .165 .268 L .302 .666 L .149 -.117 L .372 .282 L .105 .616 L .422 .696 L -.028 .423 L .222 .268 L .16 .197 L .287 .084 L .136 -.007 L .336 .083 L 1.043 2.198 L .548 1.154 L .261 .902 L 3.362 .375 L 3.387 .446 L .839 .108 L .584 -.469 L .152 -.057 L .581 .914 L .155 1.453 L -5.346 2.982 L -2.35 1.213 L -1.691 .815 L -.169 .085 L -1.148 .346 L -3.097 1.035 L -4.618 1.566 L -.484 .229 L -.041 .127 L -.383 .397 L -1.907 2.271 L -2.042 2.667 L -1.302 -2.703 L -1.211 -2.45 L -.452 -.012 L -.715 .047 L -.446 -.125 L -.671 -.151 L -.216 .1 L -.174 .185 L -.11 .495 L .041 .678 L -.113 .565 L -.692 .563 L
476.458 130.735 N .124 .289 L .796 1.944 L .834 1.746 L -.38 .381 L -.479 1.145 L -.334 1.413 L -.171 .593 L -.18 .156 L -.407 -.07 L -.448 -.521 L -.782 -.676 L -.386 -.494 L -.338 -.988 L -.521 -.45 L -.289 -.621 L -.17 -.479 L -.198 -.353 L -.466 .17 L -.267 .523 L .604 1.34 L .131 .381 L .634 .86 L .933 1.042 L .473 1.199 L .526 .973 L .277 .818 L .391 .465 L .912 1.735 L 1.072 1.904 L .428 .705 L .586 .549 L .451 .352 L .151 .183 L -.241 .17 L -.285 .1 L -.043 .155 L .238 1.087 L .252 .467 L .127 .238 L .812 .591 L .397 .168 L .406 .521 L .416 .38 L .311 .56 L -10.382 -.006 L -2.138 -.001 L -2.774 .002 L -2.513 .015 L -2.268 -.029 L -1.664 .01 L -1.241 .007 L -1.614 -.019 L -.914 .005 L -.819 .089 L -.011 -2.612 L .021 -1.342 L -.045 -2.81 L .001 -.692 L .008 -2.048 L .016 -1.468 L .019 -3.869 L .015 -.988 L -.042 -.367 L -.388 -.916 L -.185 -.945 L .056 -.311 L .322 -.553 L .231 -.425 L -.354 -1.283 L .21 -.34 L .369 -.228 L .099 -.208 L .337 .168 L .553 -.015 L .628 -.1 L .786 -.001 L 1.513 .293 L .587 .115 L .779 .122 L .721 .154 L .348 .409 L .4 0 L .928 .083 L .998 .394 L .628 .069 L .245 -.127 L .72 -.538 L .925 -.397 L .837 -.186 L .78 -.27 L .375 -.072 L .346 .056 L .535 -.001 L .723 .126 L .202 .465 L .596 .366 L .518 -.156 L .64 .267 L .382 .027 L .561 -.401 L .241 .179 L .277 .056 L .674 .13 L .338 -.062 L .46 -.165 L .51 -.308 L
580.625 132.873 N .24 .43 L .299 .05 L .276 -.314 L .134 -.513 L .275 .066 L .186 -.182 L 1.079 .199 L .132 .612 L .867 .264 L .726 .595 L .472 .215 L .15 -.132 L .454 .281 L .657 .794 L .158 -.166 L .71 -.116 L .289 .166 L .178 .38 L -.069 .281 L 1.451 .893 L .333 -.248 L .326 .017 L -.175 .396 L .014 .265 L .935 .066 L .365 -.066 L .54 .496 L .141 .463 L .237 -.099 L -.01 -.364 L .685 .38 L .271 -.083 L .08 -.331 L .407 0 L .63 .281 L .319 .364 L .849 -.066 L .341 .116 L .339 -.281 L .655 .159 L .037 .022 L -.318 .761 L -.07 .876 L .429 .827 L -.311 .694 L -.336 -.05 L -.687 .132 L -.271 -.083 L -.357 .132 L -.399 -.116 L -.268 -.364 L -.606 .297 L -.847 -.364 L -.721 -.148 L -.379 .231 L -.312 -.248 L .034 -.331 L -.313 -.066 L -.584 .281 L -.618 -.265 L -.286 -.281 L -.663 -.149 L .101 -.446 L -.142 -.231 L -.643 -.066 L -.494 -.298 L -.582 .347 L -.482 -.265 L -.503 0 L -.087 .215 L -.15 .066 L -.304 -.198 L -.835 -.166 L -.182 -.397 L -.538 .066 L -1.027 -.595 L -.231 .166 L -1.242 -.678 L -.305 -.529 L -.704 -.149 L -.665 -.479 L -.466 .083 L -.63 -.38 L -.039 -.248 L .218 -.43 L .309 -.397 L -.04 -.396 L .221 -.265 L -.008 -.364 L .281 -.116 L 1.07 -.909 L
374.125 167.166 N -1.41 -.924 L -.661 -.604 L -.537 -.788 L -.292 -.662 L -.15 -.183 L -.312 -.154 L -.567 -.053 L -.655 -.307 L -.695 -.561 L -.604 -.194 L -.567 -.025 L -1.209 .12 L -1.821 .194 L -.523 .417 L .06 -.502 L .563 -1.301 L .188 -.819 L .13 -1.13 L -.162 -1.101 L -.3 -.791 L -.624 -.747 L .267 -.283 L .182 -.424 L .067 -.975 L -.065 -.537 L -.174 -.353 L -.808 -.817 L -.297 -.112 L -.393 .438 L -.055 -.197 L -.013 -.381 L .08 -.689 L .474 .013 L 5.055 .056 L 2.396 .014 L .732 -.033 L .212 .027 L -.051 -1.102 L -.164 -1.539 L .01 -.707 L .249 -.383 L .575 -.427 L .726 -.315 L .809 -.287 L .144 -.128 L .099 -2.6 L .07 -2.261 L .047 -.509 L .557 -.074 L 6.005 .022 L .56 .011 L .104 -.396 L -.002 -.65 L .03 -1.752 L 2.829 1.509 L 4.12 2.42 L 1.414 .91 L -.523 .13 L -3.231 .089 L .049 .776 L .908 7.962 L .19 1.468 L .178 1.736 L .325 2.753 L .202 2.386 L .186 1.468 L .724 .787 L -.379 1.613 L -6.457 .01 L -1.953 .026 L -.945 .344 L -.387 .031 L -.485 -.054 L -.713 -.137 L -.535 -.124 L -.06 .212 L .055 .296 L -.107 .269 L -.454 -.082 L -.214 -.168 L -.568 -.83 L -.261 -.111 L -.402 .073 L -.252 .256 L -.181 .552 L -.018 .607 L -.332 .284 L
476.114 191.139 N -.563 .54 L -.626 .314 L -.367 .016 L -.303 -.196 L -.303 -.097 L -.88 .132 L -.881 .33 L -.911 .048 L -.942 -.234 L -.495 -.011 L -.464 .087 L -.496 .229 L -1.288 -1.32 L -1.032 -.926 L -.207 -.083 L -.258 .157 L -.436 .582 L -.16 .1 L -.684 -.631 L -.384 -.012 L -.529 .37 L -.258 .242 L -.352 .016 L -.366 -.195 L -.525 -.477 L -.348 -.493 L -.795 -.772 L -.143 -.239 L -.031 -.07 L .083 -.679 L -.157 -.352 L -.558 -.477 L -.814 -.165 L -.367 -.224 L -.285 -.436 L -.059 -.72 L -.206 -.366 L -.207 -.168 L -.717 -.434 L -.558 -.378 L -.445 -.351 L -.173 -.395 L .148 -.481 L -.223 -.267 L -.351 -.196 L -.799 -.235 L -.797 -.447 L -.223 -.225 L -.252 -.493 L -.207 -.126 L -.272 .001 L -.802 .019 L -.158 -.211 L -.01 -.664 L .416 -1.472 L -.122 -.536 L -.347 -.549 L -1.342 -1.673 L .15 -.425 L -.026 -.367 L -.266 -.465 L -.444 -.407 L -.155 -.295 L -.137 -.522 L -.221 -1.228 L -.141 -.225 L -.338 -.012 L -.517 .088 L -.219 -.352 L .316 -.609 L .542 -.596 L .087 -.34 L -.342 -.662 L .053 -.24 L .718 -.428 L .149 -.212 L -.131 -.677 L .122 -.438 L .583 -.809 L .417 -1.245 L .229 -.143 L 1.245 -.05 L .839 .009 L .04 -.283 L -.031 -1.229 L -.036 -1.002 L .038 -.749 L -.085 -2.5 L .036 -.636 L .016 -.946 L .02 -1.045 L .073 -1.13 L .52 .011 L 1.561 .019 L .088 -.17 L -.033 -3.078 L .021 -1.003 L .819 -.089 L .914 -.005 L 1.614 .019 L 1.241 -.007 L 1.664 -.01 L 2.268 .029 L 2.513 -.015 L 2.774 -.002 L 2.138 .001 L 10.382 .006 L .229 .414 L .499 1.115 L .281 3.501 L .319 1.637 L .182 .211 L .625 .394 L .595 .366 L .617 .507 L .491 .197 L .254 .223 L -.238 .199 L -.277 .327 L -.306 .566 L -.369 .242 L -.511 .172 L -.427 .116 L -.153 .142 L -.235 .496 L -.348 .171 L -.73 .033 L -.204 .552 L -.038 .452 L -.202 .862 L -.242 .722 L -.541 1.302 L -.068 .495 L .092 .903 L -.013 .679 L -.001 .083 L -.148 .947 L -.398 1.231 L -.214 1.061 L -1.04 .331 L -.414 .37 L -.693 1.134 L -.154 .34 L -.191 1.088 L -.141 1.074 L -.197 .185 L -.274 .044 L -.431 -.096 L -.259 .072 L -.163 .114 L -.187 1.103 L -.115 .933 L -.2 1.272 L .039 .522 L -.229 1.159 L -.469 .299 L -.288 -.012 L -.928 -.122 L -.321 .03 L -.188 .806 L -.054 .466 L .094 .141 L .479 .11 L .734 .123 L .334 .167 L .805 .913 L 1.06 1.067 L .751 1.464 L .345 .732 L .348 .421 L .462 .28 L .415 .097 L .269 .309 L .117 .988 L -.034 .17 L -.018 .141 L -.079 -.028 L -.464 .017 L -1.009 .133 L -.832 .005 L -.671 -.052 L -.291 .327 L -.678 .795 L
518.402 163.079 N -.282 .097 L -.538 .27 L -.656 .566 L -.265 .297 L -.166 .508 L -.062 .41 L -.41 .326 L -1.418 .652 L -2.27 .641 L -1.285 .412 L -.843 .312 L -.356 .297 L -.473 .622 L -.436 .269 L -.506 .114 L -.593 -.069 L -.521 .072 L -.83 .439 L -.65 .396 L -.956 .397 L -.752 .199 L -1.16 .003 L -.562 -.013 L -.297 .128 L -.386 .312 L -.272 .297 L -.45 .312 L -.511 .241 L -.389 .043 L -.239 -.042 L -.535 .411 L -.839 .058 L -.494 -.112 L -.623 -.437 L -.17 -.155 L -.317 -.437 L -.084 -.254 L .18 -.721 L -.081 -.635 L -.312 -.507 L -.341 -1.171 L -.572 -1.919 L -.072 -.438 L .268 -.707 L -.124 -.748 L .692 -.563 L .113 -.565 L -.041 -.678 L .11 -.495 L .174 -.185 L .216 -.1 L .671 .151 L .446 .125 L .715 -.047 L .452 .012 L 1.211 2.45 L 1.302 2.703 L 2.042 -2.667 L 1.907 -2.271 L .383 -.397 L .041 -.127 L .484 -.229 L 4.618 -1.566 L 3.097 -1.035 L 1.148 -.346 L .169 -.085 L .092 .663 L .226 .634 L .604 .971 L .933 1.364 L .127 .253 L -.006 .296 L .483 .689 L .241 .306 L
494.64 172.627 N -.261 -.166 L -.476 -.633 L -.475 -.159 L -.437 -.911 L -1.267 -.792 L -.277 -.594 L -.673 -.673 L -.594 -.119 L -.871 -.554 L -.555 .079 L -.158 -.158 L -.237 .04 L -.277 -.198 L -.356 .159 L -.476 .079 L -.277 -.436 L -.158 .237 L -.436 .198 L -.792 .079 L -.554 -.594 L -.238 0 L -.396 -.317 L -.832 1.663 L -.436 -.871 L -.475 .079 L -.277 .356 L -.396 -.08 L -.349 .041 L .013 -.679 L -.092 -.903 L .068 -.495 L .541 -1.302 L .242 -.722 L .202 -.862 L .038 -.452 L .204 -.552 L .73 -.033 L .348 -.171 L .235 -.496 L .153 -.142 L .427 -.116 L .511 -.172 L .369 -.242 L .306 -.566 L .277 -.327 L .238 -.199 L .098 .129 L .718 2.102 L .442 1.623 L .689 1.919 L .618 .832 L .205 -.212 L -.072 -.479 L .093 -.226 L .31 .253 L .4 .677 L .384 .395 L .534 -.043 L .242 .014 L 1.338 1.282 L .809 .916 L .124 .099 L .706 .055 L .618 .874 L .021 .24 L -.025 .198 L .118 .212 L .507 .182 L .915 .869 L -.075 .094 L -.529 .78 L -.331 -.182 L -.396 -.125 L -.214 .114 L -.055 .085 L
370.147 172.035 N -2.301 -.043 L -1.045 .006 L -.505 .384 L -.51 .187 L -.74 -.024 L -.819 .047 L -.463 .139 L -.009 -.003 L -.278 -.226 L -.169 -.409 L .104 -.424 L -.095 -.55 L -.018 -.198 L .001 -.046 L 1.695 .014 L 0 -.434 L .155 0 L .341 -.016 L .186 -.077 L .248 .062 L .294 -.046 L .124 -.093 L .016 -.263 L .077 -.078 L .14 -.016 L .155 .155 L .232 .124 L .356 .108 L .046 .108 L .139 .047 L .217 -.031 L .263 .108 L .186 .17 L .434 0 L .186 -.108 L .263 -.108 L .279 0 L .108 -.124 L .016 -.124 L -.155 -.217 L -.202 -.077 L -.201 .031 L -.294 .093 L -.108 .093 L -.248 .062 L -.279 -.186 L -.031 -.186 L -.186 -.108 L -.17 -.015 L -.186 .124 L -.139 -.108 L -.108 -.217 L -.155 -.108 L -.201 .031 L -.17 -.062 L -.387 .17 L -.108 -.108 L -.155 .046 L -.202 .124 L -.093 .294 L -1.664 0 L -.007 -.067 L -.028 -.269 L -.377 -.268 L -.068 -.155 L -.057 -.367 L -.386 -.635 L -.399 -.494 L -.379 -.31 L -.472 -.183 L .54 -.34 L .723 -.75 L .588 -1.004 L .334 -.82 L .099 -.826 L .523 -.417 L 1.821 -.194 L 1.209 -.12 L .567 .025 L .604 .194 L .695 .561 L .655 .307 L .567 .053 L .312 .154 L .15 .183 L .292 .662 L .537 .788 L .661 .604 L 1.41 .924 L -.506 .399 L -.057 .339 L .251 1.1 L .144 .663 L .22 .479 L .181 .197 L .554 .322 L .265 .337 L .082 .833 L -.004 .565 L -.062 .142 L -.146 -.042 L -.963 .091 L -.658 .074 L -.725 -.081 L -.503 -.209 L -.795 -.32 L -1.255 -.021 L
495.973 175.881 N -.363 .807 L .083 .409 L .428 .732 L .587 .844 L .732 .801 L .596 .547 L .634 .321 L .54 .209 L 4.26 1.443 L 1.447 .472 L 1.875 -.04 L .236 .154 L -4.087 4.205 L -1.562 1.69 L -.813 .909 L -.8 .004 L -1.693 -.046 L -.626 .088 L -.562 .215 L -.388 .214 L -.502 .497 L -.294 .426 L -.337 .115 L -1.216 .078 L -.305 .101 L -.453 .511 L -1.103 -.106 L -.461 -.181 L -.46 -.336 L -.271 -.098 L -.852 .358 L -.675 .343 L -.258 .199 L -.71 .753 L -.16 .114 L -.847 -.094 L -.67 -.193 L -1.373 -.133 L -.335 -.041 L -2.353 -1.525 L -.604 -.293 L -.749 -.193 L -1.054 -.149 L -.319 -.069 L .018 -.141 L .034 -.17 L -.117 -.988 L -.269 -.309 L -.415 -.097 L -.462 -.28 L -.348 -.421 L -.345 -.732 L -.751 -1.464 L -1.06 -1.067 L -.805 -.913 L -.334 -.167 L -.734 -.123 L -.479 -.11 L -.094 -.141 L .054 -.466 L .188 -.806 L .321 -.03 L .928 .122 L .288 .012 L .469 -.299 L .229 -1.159 L -.039 -.522 L .2 -1.272 L .115 -.933 L .187 -1.103 L .163 -.114 L .259 -.072 L .431 .096 L .274 -.044 L .197 -.185 L .141 -1.074 L .191 -1.088 L .154 -.34 L .693 -1.134 L .414 -.37 L 1.04 -.331 L .214 -1.061 L .398 -1.231 L .148 -.947 L .001 -.083 L .349 -.041 L .396 .08 L .277 -.356 L .475 -.079 L .436 .871 L .832 -1.663 L .396 .317 L .238 0 L .554 .594 L .792 -.079 L .436 -.198 L .158 -.237 L .277 .436 L .476 -.079 L .356 -.159 L .277 .198 L .237 -.04 L .158 .158 L .555 -.079 L .871 .554 L .594 .119 L .673 .673 L .277 .594 L 1.267 .792 L .437 .911 L .475 .159 L .476 .633 L .261 .166 L -.594 .921 L -.488 .61 L -.105 .254 L -.029 .396 L .202 1.157 L .5 -.074 L .892 -.246 L .4 .04 L .556 .195 L
364.011 169.929 N 1.664 0 L .093 -.294 L .202 -.124 L .155 -.046 L .108 .108 L .387 -.17 L .17 .062 L .201 -.031 L .155 .108 L .108 .217 L .139 .108 L .186 -.124 L .17 .015 L .186 .108 L .031 .186 L .279 .186 L .248 -.062 L .108 -.093 L .294 -.093 L .201 -.031 L .202 .077 L .155 .217 L -.016 .124 L -.108 .124 L -.279 0 L -.263 .108 L -.186 .108 L -.434 0 L -.186 -.17 L -.263 -.108 L -.217 .031 L -.139 -.047 L -.046 -.108 L -.356 -.108 L -.232 -.124 L -.155 -.155 L -.14 .016 L -.077 .078 L -.016 .263 L -.124 .093 L -.294 .046 L -.248 -.062 L -.186 .077 L -.341 .016 L -.155 0 L 0 .434 L -1.695 -.014 L .019 -.477 L .173 -.198 L .434 -.058 L .093 -.155 L -.006 -.059 L
495.973 175.881 N -.556 -.195 L -.4 -.04 L -.892 .246 L -.5 .074 L -.202 -1.157 L .029 -.396 L .105 -.254 L .488 -.61 L .594 -.921 L .055 -.085 L .214 -.114 L .396 .125 L .331 .182 L .529 -.78 L .075 -.094 L .627 .596 L .285 .465 L .036 .282 L -.118 .113 L -.361 .185 L -.438 .1 L -.56 .312 L -.566 .467 L .253 .127 L .645 -.058 L .321 .013 L .434 .124 L -.114 .26 L -.37 .468 L -.34 .567 L
363.763 172.732 N .463 -.139 L .819 -.047 L .74 .024 L .51 -.187 L .505 -.384 L 1.045 -.006 L 2.301 .043 L -.111 .792 L .115 .847 L -.186 .312 L -.333 .186 L -.513 .031 L -.401 .017 L -.381 .186 L -.789 .64 L -.321 .372 L -.047 -.126 L -.192 0 L -.501 -.14 L -.165 -.254 L .121 -.41 L .33 -.438 L .253 -.212 L -.131 -.141 L -.372 -.112 L -.498 .015 L -.415 .17 L -.161 0 L -.616 -.281 L -.36 -.296 L -.069 -.24 L -.323 -.084 L -.316 -.137 L
383.005 177.596 N -.379 .397 L -.264 .623 L .214 .409 L .695 .405 L .197 .31 L -.125 .283 L -.332 .37 L .309 .351 L .648 .561 L .051 .226 L -.19 .143 L -.304 -.012 L -.548 -.223 L -.304 .03 L -.158 .199 L -.03 .127 L .296 .549 L .179 .21 L -.188 .354 L -.602 .554 L -.047 .099 L -.339 -.224 L -.337 -.097 L -.143 .086 L -.756 .922 L -.321 -.026 L -.404 -.322 L -.277 -.323 L .044 -.283 L -.009 -.65 L -.22 -.846 L -.165 -.366 L -.338 -.097 L -.528 .046 L -.367 .143 L -.252 .242 L -.193 .376 L -.26 -.656 L -.165 -1.369 L -.252 -.761 L -.475 -.619 L -.456 -.421 L -.42 -.224 L -.466 -.04 L -1.137 .148 L -.594 -.039 L -.238 .157 L -.643 .866 L -1.088 1.235 L .051 -.392 L -.312 -.55 L -.764 -.775 L -.122 -.649 L -.84 -.366 L -.908 -.563 L -.277 -.296 L .09 -.396 L -.053 -.311 L -.547 -.041 L -.323 -.098 L -.115 -.155 L .059 -.311 L -.038 -.1 L .321 -.372 L .789 -.64 L .381 -.186 L .401 -.017 L .513 -.031 L .333 -.186 L .186 -.312 L -.115 -.847 L .111 -.792 L 1.255 .021 L .795 .32 L .503 .209 L .725 .081 L .658 -.074 L .963 -.091 L .146 .042 L .113 .028 L .18 .183 L .882 .715 L .536 .265 L .252 -.256 L .475 -.413 L .338 .026 L .356 .153 L .565 .152 L .43 -.243 L .3 -.327 L .684 -.428 L .323 .055 L .246 .281 L .022 .339 L .271 .832 L .265 .451 L .474 .478 L .349 .718 L .194 1.143 L .559 .901 L
266.015 188.956 N .103 .169 L -.163 .326 L -.592 .385 L -1.74 .9 L -.807 .23 L -.557 .074 L -.465 -.054 L -.284 .115 L -.232 1.117 L -.348 .115 L -.628 -.618 L -.344 -.224 L -1.149 .035 L -.385 -.04 L -.896 -.461 L -.309 -.125 L -.159 .029 L -.041 .184 L .616 .688 L .391 .69 L .302 1.524 L .079 .55 L .166 .239 L .96 .051 L .434 .125 L .15 .253 L -.265 .27 L -.569 .272 L -.652 .131 L -.203 .199 L -.259 .666 L -.235 .213 L -.652 .173 L -.554 .286 L -.74 .654 L -.645 .739 L -.271 .016 L -.186 -.776 L -.083 -.183 L -.757 .697 L -.414 .073 L -.482 -.223 L -.694 -.546 L -.432 -.054 L -.199 -.437 L -.088 -.452 L -.161 -.861 L -.138 -.437 L -.148 -.168 L -.797 -1.182 L -.51 -.491 L .479 -.526 L .731 -.612 L -.121 -.282 L -.486 -.647 L -.256 -.437 L -.447 -.789 L -.162 -.804 L -.048 -.367 L -.035 -.438 L -.026 -.254 L .147 -.326 L .379 -.511 L .085 -1.004 L .409 -.525 L -.644 -.081 L -1.99 .224 L -.76 .174 L -.522 .13 L -.144 0 L -.554 -.576 L -.847 -.998 L -.188 -.253 L -.64 -.321 L -.521 -.181 L -1.167 .05 L -1.163 .12 L -.496 .017 L -.397 -.252 L -.429 -.548 L -.401 -.309 L -.099 -.353 L .226 -1.132 L -.103 -.395 L -.855 -1.45 L -.31 -.606 L -.384 .017 L -.234 .1 L -.402 -.025 L .709 -1.191 L .241 -.722 L .172 -.722 L .99 -1.758 L .381 -.059 L .227 .027 L .129 -.396 L -.048 -.497 L .056 -.288 L .414 -.2 L .534 -.156 L .84 -.171 L .128 .105 L -.9 .151 L -.731 .312 L -.145 .212 L .19 .607 L .142 .407 L .224 .126 L -.043 .145 L .153 .579 L -.135 .367 L -.327 .364 L -.348 .824 L -.137 .368 L .253 .479 L .288 .253 L .25 .72 L .341 .353 L .523 -.114 L .184 -.156 L .419 -.255 L .12 -.142 L .066 -.523 L -.167 -.649 L -.21 -.282 L -.438 -.804 L -.136 -.135 L -.118 -.395 L -.247 -.18 L .239 -.099 L .095 -.251 L -.204 -.144 L 1 -.379 L 1.085 -.327 L .998 -.272 L .086 -.225 L .69 -.086 L .143 -.008 L -.042 -.157 L -.055 -.198 L -.125 -.036 L -.039 -.108 L -.128 -.072 L -.226 .071 L -.156 .027 L -.229 -.012 L -.315 -.55 L .109 -.254 L .337 -.213 L .367 -.043 L .09 .112 L .14 .368 L .186 .162 L -.001 .148 L .026 .193 L .068 .09 L .004 .198 L .253 .258 L .329 -.02 L .699 .111 L .455 .07 L .593 .196 L .323 .254 L .393 .564 L .156 .635 L .358 .324 L .359 .084 L 1.02 -.129 L .928 -.059 L .59 -.058 L .799 -.059 L .714 .125 L .4 .479 L .267 .169 L .578 .253 L .49 .14 L 1.094 .04 L .382 -.057 L .388 -.227 L 1.042 -.807 L .47 -.185 L .453 .042 L .959 -.073 L 1.152 -.073 L .919 .055 L .248 .112 L -.056 .141 L -.294 .185 L -.854 -.041 L -.433 .015 L -.083 .212 L .059 .184 L .593 .253 L .609 .535 L .195 .649 L .246 -.523 L .185 -.142 L .415 .253 L .483 .027 L .374 .098 L .258 .338 L .918 .394 L .464 .295 L -.729 .496 L -.161 .65 L -.214 .226 L -1.055 .417 L .5 .064 L .598 .098 L .368 -.029 L .33 -.142 L .929 -.03 L .725 .083 L .84 .274 L .095 .296 L -.061 .41 L -1.655 1.239 L -.101 .255 L .074 .212 L .62 .604 L .141 .282 L -.308 .299 L -.41 .144 L -1.032 .19 L -.061 .452 L .008 .58 L -.395 .539 L -.071 .212 L .324 .521 L .732 .745 L .503 .647 L
493.044 204.258 N -1.223 -1.771 L -.027 -.932 L -.03 -1.43 L -.042 -2.045 L -.003 -1.017 L 0 -.438 L .016 -.848 L .004 -1.215 L .002 -.508 L 1.649 -2.467 L .453 -.511 L .305 -.101 L 1.216 -.078 L .337 -.115 L .294 -.426 L .502 -.497 L .388 -.214 L .562 -.215 L .626 -.088 L 1.693 .046 L .8 -.004 L .813 -.909 L 1.562 -1.69 L 4.087 -4.205 L -.236 -.154 L -1.875 .04 L -1.447 -.472 L -4.26 -1.443 L -.54 -.209 L -.634 -.321 L -.596 -.547 L -.732 -.801 L -.587 -.844 L -.428 -.732 L -.083 -.409 L .363 -.807 L .34 -.567 L .37 -.468 L .114 -.26 L .154 .044 L .935 1.142 L .586 .62 L .243 .381 L .265 .211 L .372 -.071 L .417 -.001 L .465 .027 L .372 -.071 L .572 -.27 L .836 -.425 L .585 -.157 L .397 .098 L .76 .267 L .549 -.072 L .56 -.326 L .779 -.566 L .247 -.127 L .447 .041 L .479 .098 L .419 -.043 L 1.195 -.482 L .288 .027 L .682 .196 L .74 -.03 L .764 -.185 L .964 -.327 L .9 -.666 L .47 -.382 L .604 .154 L .391 .211 L .08 .014 L .147 .268 L -.414 .919 L .021 .564 L .132 .621 L -.165 .452 L -.375 .509 L -.028 .678 L -.047 .833 L -.163 .509 L -1.264 2.262 L -.842 .792 L -.122 .311 L .102 .353 L -.893 1.569 L -.834 1.272 L -.214 .947 L -.351 .636 L -.712 1.117 L -.874 1.188 L -1.159 1.498 L -.384 .439 L -2.274 2.504 L -1.82 1.557 L -2.164 1.121 L -.593 .382 L -1.28 1.09 L -1.74 1.755 L -.06 .061 L -1.055 1.1 L -1.235 1.569 L -.615 .835 L .1 .353 L -.094 .276 L
264.768 176.039 N -.128 .225 L -.115 .067 L -.029 .135 L .039 .25 L -.058 .086 L .125 .376 L -.039 .424 L -.453 .154 L -.135 -.01 L -.144 .039 L -.482 -.039 L -.192 .039 L -.087 -.048 L -.356 0 L -.02 -.058 L .039 -.067 L .202 -.029 L .222 -.135 L .019 -.087 L .106 .02 L .154 .01 L .135 -.145 L -.096 -.279 L .048 -.125 L .029 -.183 L -.067 -.125 L -.097 -.135 L -.279 -.048 L .116 -.096 L .164 -.019 L .231 -.029 L .115 -.087 L .385 .02 L .106 -.039 L .299 -.067 L .244 .006 L
654.075 190.187 N .206 -.125 L .63 -.114 L .656 -.938 L .241 -.07 L -.069 .268 L .122 .087 L .187 -.046 L .11 .174 L .148 .444 L -.024 .111 L -.013 .247 L .197 .197 L .025 .086 L -1.234 .42 L -.383 .271 L -.309 -.271 L -.111 -.259 L -.234 .012 L -.062 -.37 L -.084 -.126 L
493.044 204.258 N -.602 .389 L -.557 .171 L -.385 -.112 L -.086 .777 L -.282 .367 L -.67 .115 L -.394 .382 L -.088 .48 L .006 .353 L -.356 .622 L -.964 1.358 L .092 .536 L -.337 .65 L -.25 .255 L -.334 .1 L -.084 .152 L -1.067 -.807 L -2.427 -1.752 L -.07 -.239 L .116 -.552 L -.137 -.381 L -3.553 -1.984 L -4.663 -2.568 L -1.448 .033 L 1.144 -2.479 L .105 -.229 L .656 -.835 L .985 -.938 L .477 -.525 L .43 -.695 L .143 -.566 L -.048 -.664 L -.223 -.606 L -.224 -.352 L -.732 -1.069 L -.174 -.465 L -.027 -.861 L -.126 -.226 L -.477 -.463 L -.3 -.493 L .678 -.795 L .291 -.327 L .671 .052 L .832 -.005 L 1.009 -.133 L .464 -.017 L .079 .028 L .319 .069 L 1.054 .149 L .749 .193 L .604 .293 L 2.353 1.525 L .335 .041 L 1.373 .133 L .67 .193 L .847 .094 L .16 -.114 L .71 -.753 L .258 -.199 L .675 -.343 L .852 -.358 L .271 .098 L .46 .336 L .461 .181 L 1.103 .106 L -1.649 2.467 L -.002 .508 L -.004 1.215 L -.016 .848 L 0 .438 L .003 1.017 L .042 2.045 L .03 1.43 L .027 .932 L 1.223 1.771 L
466.196 203.275 N .188 -.298 L .076 -.27 L -.057 -.748 L .025 -.734 L -.021 -.593 L .107 -.507 L .217 -1.02 L .395 -.681 L .255 -.284 L 1.241 -.996 L 1.195 -1.066 L .191 -.453 L -.111 -.31 L -.271 -.182 L -.479 -.04 L -.191 -.027 L -.128 -.253 L .26 -1.88 L .018 -.424 L -.159 -.183 L -.063 -.028 L .496 -.229 L .464 -.087 L .495 .011 L .942 .234 L .911 -.048 L .881 -.33 L .88 -.132 L .303 .097 L .303 .196 L .367 -.016 L .626 -.314 L .563 -.54 L .3 .493 L .477 .463 L .126 .226 L .027 .861 L .174 .465 L .732 1.069 L .224 .352 L .223 .606 L .048 .664 L -.143 .566 L -.43 .695 L -.477 .525 L -.985 .938 L -.656 .835 L -.105 .229 L -1.144 2.479 L -4.659 0 L -1.277 .05 L -.319 .017 L -.554 .398 L -.458 .427 L -.431 .045 L -.546 -.223 L -.064 -.042 L
713.621 206.298 N .169 7.966 L -.44 .822 L .431 1.368 L .046 .805 L -.031 3.438 L -.515 -.512 L -.927 -.888 L -.716 -.902 L -.406 -.056 L -.776 .101 L -.739 .143 L -.434 -.013 L .091 -.382 L .435 -.65 L .006 -.283 L -.561 -.521 L -.565 -.775 L .028 -.226 L .442 .111 L .236 -.042 L .135 -.113 L -.467 -.409 L -.595 -.408 L -.287 -.381 L -.275 -.648 L -1.053 -1.693 L -.508 -.394 L -.467 -.282 L -.604 -.196 L -1.983 -.603 L -1.26 -.379 L -.613 -.069 L -.705 -.238 L -.63 -.323 L .072 -.34 L -.098 -.268 L -.193 -.028 L -.617 .101 L -.389 -.07 L -.412 -.196 L -.408 -.395 L -.209 -.579 L .133 -.494 L -.155 -.226 L -.187 .113 L -.234 .396 L -.122 .664 L -.251 .608 L -.334 .269 L -.696 .354 L -.155 -.169 L -.331 -.677 L .022 -.155 L .384 -.27 L -.152 -.424 L -.173 -.239 L -.564 -.395 L -.707 -.394 L -.338 -.056 L -.059 -.212 L .038 -.226 L .413 -.044 L .388 .084 L .603 .239 L .158 -.029 L .368 -.34 L .525 -.41 L .146 .056 L .3 .269 L 1.021 -.045 L .139 -.128 L .09 -.522 L -.063 -.409 L -.238 .028 L -.345 .199 L -.604 .071 L -.656 -.041 L -.766 .044 L -1.026 -.082 L -.411 -.31 L -.135 -.197 L -.148 -.664 L -.202 -.338 L -.42 -.155 L -1.249 -.124 L .265 -.297 L .058 -.255 L .004 -.593 L .463 -.029 L .92 -.411 L .49 -.383 L .444 -.283 L .352 .027 L .4 .069 L 1.494 .646 L .515 .169 L .913 .153 L .382 .705 L .138 .396 L -.283 .749 L -.067 .381 L .221 .381 L .115 .494 L .115 .48 L .215 .521 L .186 .197 L .197 .127 L .226 -.65 L .085 .113 L .087 .141 L .309 1.073 L .169 .169 L .234 .183 L .294 .112 L .354 .056 L .58 -.198 L .504 -.439 L 1.192 -1.853 L .352 -.015 L 1.078 -.215 L .378 -.142 L .045 -.085 L .014 -.509 L .219 -.17 L 1.1 -.609 L .335 -.043 L 1.732 .759 L 2.129 .941 L 1.54 .52 L 1.299 .404 L h 691.208 208.707 m -.388 -.069 L -.693 -.38 L -.852 -.647 L -.295 -.141 L -.414 .028 L -.059 .1 L .024 .452 L -.206 .028 L -1.014 -.407 L -.258 -.353 L -.582 .199 L -.289 .269 L -.326 .185 L -.186 -.184 L -.312 -.451 L -.245 -.451 L .246 -.198 L .303 -.029 L .274 .056 L 1.104 .04 L .574 .31 L .319 -.015 L .544 -.326 L .414 -.015 L .534 .126 L .857 .21 L .499 .395 L .293 .395 L .179 .621 L -.049 .254 L h 682.045 208.699 m -.419 -.056 L -.715 -.493 L -.232 -.451 L .146 -.283 L .603 -.1 L .766 -.044 L .246 .126 L .256 .311 L .313 .197 L .108 .226 L -.067 .226 L -.125 .057 L -.879 .285 L h 707.635 219.095 m -1.11 -.209 L .589 -1.032 L .56 -.708 L .407 -.269 L .427 -.072 L .527 .338 L .198 .24 L -.11 .184 L -.324 .637 L -.256 .17 L -.638 .693 L -.27 .028 L h 673.797 218.703 m -.562 .257 L .034 .233 L -.886 .326 L -.582 .274 L -.339 -.041 L -.453 .325 L -.504 -.069 L -.427 -.112 L -.378 .255 L -.3 .058 L -.358 -.07 L -.58 -.196 L -1.046 -.04 L -.316 .043 L -.211 -.564 L .027 -.24 L .383 -.198 L .672 -.199 L .528 -.016 L 1.142 .407 L .445 .324 L .338 .013 L .326 -.297 L .464 -.016 L .429 -.071 L .414 .187 L .467 -.116 L -.072 -.222 L .421 -.187 L .404 -.233 L .094 -.151 L -.076 -.117 L -.184 .023 L .116 -.198 L .16 .012 L .22 .094 L .177 .221 L .013 .304 L h 662.661 219.065 m -.312 -.099 L -.203 -.127 L -.062 -.169 L .03 -.212 L .256 -.198 L .315 -.036 L .17 .092 L .053 .212 L .182 .098 L .305 -.145 L .34 .105 L .104 .151 L -.012 .451 L .183 -.148 L .163 -.304 L .318 -.029 L .229 .226 L .021 .424 L .181 -.036 L .062 .104 L -.025 .397 L -.316 -.211 L -.311 -.058 L -.141 .058 L .072 .155 L -.852 .157 L -.143 -.091 L .097 -.268 L -.085 -.059 L -.308 .269 L -.229 .256 L -.296 -.046 L -.63 .225 L -.624 .199 L -.357 -.051 L -.31 .123 L -.392 -.07 L -.103 -.07 L -.202 -.123 L -.063 -.279 L .143 -.261 L -.08 -.253 L .193 -.115 L .23 -.113 L .233 -.156 L .224 .07 L .61 .013 L .4 .104 L .089 .28 L .291 .109 L .294 .056 L .189 -.259 L .29 -.012 L .051 -.187 L -.263 -.15 L h 656.294 219.602 m -.393 -.282 L -.855 -.449 L -.118 -.269 L .417 -.001 L .514 -.185 L .462 -.029 L .925 .521 L -.338 .17 L -.232 .1 L -.381 .425 L h 631.053 200.125 m -.061 .225 L -.413 .439 L -.204 .41 L -.381 .354 L .164 .353 L .162 .169 L .806 .493 L .832 .055 L .241 .112 L .151 .381 L .128 .763 L -.007 .409 L .267 .423 L .212 .127 L .544 .041 L -.45 .933 L .151 .212 L .703 -.453 L .824 .252 L .177 .042 L .265 .254 L .144 .438 L .698 .676 L -.515 1.979 L -.04 .452 L .23 .946 L -.021 .438 L .021 .664 L -.002 .268 L -.149 1.06 L -.087 .156 L -.107 .07 L -.367 -.253 L -.381 -.522 L -.261 -.084 L -.262 .481 L -.081 .268 L -1.043 -.619 L -.219 .086 L .394 .747 L -.163 .213 L -.204 -.197 L -1.343 -1.424 L -.775 -.761 L -1.011 -.859 L -1.348 -.958 L -.391 -.451 L -.199 -.493 L -.191 -.339 L -1.003 -.633 L -.697 -.677 L -1.186 -1.509 L -.074 -.353 L .039 -.339 L -.324 -.875 L -.841 -1.467 L -.667 -1.044 L -.612 -.775 L -.369 -.301 L -.287 -.234 L -.64 -.295 L -.254 -.748 L -.688 -1.806 L .067 -.24 L -.107 -.311 L -.157 -.197 L -.662 -.507 L -.711 -.394 L -.539 -.21 L -.317 -.099 L -.119 -.353 L -.077 -.734 L -.18 -.409 L -.386 -.479 L -.818 -.831 L -.368 -.423 L -.725 .128 L -.613 -.676 L -.646 -.606 L -.593 -.69 L -.562 -.945 L -.229 -.635 L -.032 -.367 L .057 -.198 L .149 -.113 L .401 -.043 L .364 .098 L .25 .126 L .632 .563 L .361 .155 L .922 .153 L .335 .027 L .548 -.1 L .454 -.142 L .4 -.015 L .323 .31 L .919 1.156 L .513 .31 L .058 .155 L -.12 .537 L 1.066 .916 L .749 .493 L 1.175 .689 L .678 .323 L .139 .169 L .03 .593 L -.02 .155 L .573 .055 L .745 .944 L .612 .55 L .271 -.015 L .004 -.198 L -.123 -.226 L .069 -.24 L .507 .21 L .479 .804 L .441 .38 L .446 .056 L .429 .197 L .314 .366 L .28 .734 L .316 .437 L .431 .268 L .511 .126 L .767 .083 L .431 .154 L .494 .38 L .576 .606 L -.019 .071 L h 684.201 200.125 m -.007 -.172 L -.414 -1.058 L .18 -.551 L -.078 -.141 L -.141 -.296 L .036 -.325 L .286 -.89 L .514 -.82 L .263 .367 L .152 .353 L -.054 .283 L -.246 .396 L -.361 .763 L .061 .325 L .19 .141 L .097 -.141 L .436 -.411 L .135 -.522 L .179 -.142 L .806 -.412 L .141 .141 L -.052 .254 L .104 .55 L -.354 .212 L -.467 .354 L -.162 .311 L .159 .099 L .446 .126 L .398 .211 L -.016 .141 L .159 .353 L -.688 -.154 L -.431 -.154 L -.367 -.042 L -.304 .156 L -.08 .438 L .049 .258 L .131 .688 L .341 .62 L .405 .438 L .196 .282 L -.156 .212 L -.26 -.211 L -.664 -.648 L -.55 -.733 L -.002 -.396 L -.011 -.251 L h 637.361 207.144 m -.863 -.394 L -.377 -.239 L -.205 -.367 L -.045 -.367 L -.156 -.395 L -.507 -.395 L -.291 -.099 L -.446 .029 L -.116 -.141 L .271 -.65 L .234 -.24 L .509 .55 L .148 -.467 L .313 -.269 L .072 .395 L .312 .89 L .648 .817 L .698 .31 L -.265 .184 L -.118 .283 L .183 .564 L h 634.321 215.345 m -.091 -.187 L .316 -.023 L .402 .093 L .369 -.129 L .068 -.524 L .018 -.14 L .309 .057 L -.043 -.5 L .222 -.235 L .093 -.277 L .202 .121 L .631 .112 L .474 -.047 L .237 .443 L .524 -.089 L .158 -.297 L .022 -.244 L .259 .116 L .618 .168 L .411 .438 L .338 -.046 L .204 .271 L .446 -.029 L .453 -.185 L .302 .211 L .369 .522 L .179 .521 L .884 .041 L .462 .188 L .49 -.077 L 1.435 .124 L .479 -.029 L .34 -.17 L .213 -.65 L .271 -.269 L .447 -.015 L .223 .211 L .289 .494 L .633 .125 L .53 .027 L .774 .083 L .796 .153 L .289 .24 L .293 .288 L -.08 .445 L .275 .466 L .119 .099 L .877 .352 L .422 .069 L .658 .013 L .45 -.185 L .415 -.015 L .628 .238 L .048 .197 L -.255 .425 L -.152 .494 L .578 .776 L -.499 -.211 L -.802 -.196 L -.599 -.253 L -.891 -.309 L -.528 .001 L -.589 .256 L -.348 .057 L -.714 -.098 L -1.454 -.138 L -1.47 -.138 L -.805 -.253 L -.839 -.479 L -1.099 -.336 L -1.125 -.267 L -.948 -.04 L -.556 .298 L -.445 .043 L -.957 -.153 L -.805 -.492 L -.357 -.07 L -1.606 -.066 L -.363 -.155 L .055 -.141 L .448 -.468 L -.402 -.267 L -.551 -.099 L -.506 -.14 L -.307 -.027 L -1.261 -.121 L h 675.004 223.092 m .249 -.494 L .023 -.537 L .113 -.312 L .674 -.481 L 1.447 -.624 L .662 -.454 L .36 -.607 L .466 -.157 L 1.578 -.102 L .91 -.214 L .541 -.044 L .869 -.143 L .118 .07 L .099 .197 L -.237 .212 L -.36 .256 L -1.609 .61 L -1.369 .44 L -.713 .256 L -.606 .354 L -1.09 .963 L -.653 .481 L -.439 .086 L -.552 .228 L -.48 .015 L h 667.866 223.149 m -.217 -.069 L -.917 -.605 L -.8 -.45 L -.347 -.099 L -.493 -.126 L -.292 -.197 L .108 -.212 L .371 -.142 L .992 -.03 L .502 -.114 L .35 .296 L 1.147 .746 L .265 .381 L -.125 .325 L -.246 .24 L -.299 .057 L h 661.819 191.241 m -.041 .09 L .319 .691 L -.23 .142 L -.546 .043 L -.579 .086 L .198 .226 L .115 .296 L -.169 .226 L .216 .211 L .235 .112 L .546 .832 L .536 .747 L .043 .198 L -.338 .721 L .075 .226 L .406 .465 L .743 .45 L .6 .493 L .551 .761 L -.465 .17 L -.75 -.026 L -.797 -.238 L -.337 .1 L -.387 .467 L -.354 .918 L -.08 .476 L -.046 .272 L .132 .649 L .116 .424 L -.133 .848 L -.256 0 L -.466 -.154 L -1.037 .963 L -.433 .65 L -.751 .608 L .443 .381 L .06 .396 L .17 .296 L -.685 .058 L .452 .578 L .009 .212 L -.103 .227 L -.547 .665 L -.206 .396 L -.127 .354 L -.529 .594 L -1.294 .61 L -.607 .284 L -.292 .198 L -.194 -.311 L .024 -.424 L -.33 -.804 L -.306 -.381 L -.265 -.184 L -.286 .029 L -.503 .523 L -.302 .029 L -.328 -.508 L -.313 -.197 L -.437 -.112 L -.387 -.451 L -.342 -.154 L -.35 .806 L -.135 .198 L -.381 .058 L -.356 -.112 L -.442 .128 L -.318 .354 L -.364 .071 L -.059 -.551 L .034 -.311 L -.314 -1.03 L -.336 .396 L -1.42 .44 L -.321 -.408 L -.639 .015 L -.281 .156 L -.303 .029 L -.058 -.649 L -.022 -.65 L -.267 -1.411 L -.012 -.48 L -.352 -.747 L -.406 -.409 L -.79 -.422 L -.146 -.141 L .555 -.354 L -.531 -.38 L -.258 -.296 L .188 -.735 L -.074 -.128 L -.278 -.478 L -.352 -.296 L .065 -.466 L -.125 -.593 L .182 -.65 L .133 -.353 L .424 -.58 L .303 -.806 L .318 .028 L .204 .11 L .288 .792 L .253 .295 L 1 .983 L .304 .083 L .446 .28 L .928 -.416 L .255 -.001 L .526 .223 L .543 .11 L .399 -.172 L .528 -.342 L .403 -.525 L .531 -.441 L .479 -.074 L .431 .11 L .557 .251 L .524 .223 L .559 .152 L .287 -.03 L .467 -.356 L .465 -.172 L .864 -.175 L .387 -.299 L .928 -1.785 L -.076 -.748 L .218 -.34 L .646 -.244 L .22 -.383 L -.106 -.988 L .119 -.565 L .381 -.638 L .247 -.157 L .464 -.017 L .748 .081 L .651 .081 L .624 -.018 L .446 .04 L .753 .292 L .182 .09 L h 666.561 200.125 m .012 -.049 L .48 -1.188 L .434 -.41 L .289 -.142 L .429 .338 L .29 -.311 L .162 -.325 L .293 -.481 L .496 -.058 L .605 .14 L .729 .535 L .447 .027 L .863 -.044 L .478 .168 L .749 .267 L .577 -.227 L 1.853 .081 L .72 -.128 L .627 -.354 L .211 -.283 L -.156 -.268 L .196 -.283 L .388 -.241 L .295 -.41 L .289 -.057 L .075 .24 L -.073 .537 L -.117 .311 L -.081 .127 L -.082 .127 L -.969 1.259 L -.416 .396 L -.464 .1 L -1.23 .229 L -.495 -.069 L -.591 -.422 L -1.149 -.068 L -1.151 .059 L -.878 -.041 L -1.039 .045 L -.575 -.083 L -.671 .029 L -.415 .1 L -.433 .368 L -.259 .461 L -.154 .274 L -.187 .721 L .068 .48 L .263 .494 L .194 .183 L .403 .226 L .259 .196 L .221 .607 L .179 .154 L .226 .042 L .815 .026 L .249 -.269 L .652 -.976 L .385 .056 L .307 .183 L .496 .041 L .363 -.227 L .669 -.156 L .62 -.143 L .268 -.298 L .271 -.057 L .466 .196 L .131 .212 L -.083 .734 L -.469 -.267 L -.544 -.042 L -.361 .298 L -.389 .523 L -.438 .425 L -1.059 .439 L -.214 .325 L -.143 .029 L -.241 -.042 L -.468 -.126 L -.03 .056 L .025 .312 L .212 .126 L .676 .578 L .467 .521 L .854 1.24 L -.097 .325 L -.156 .679 L .102 .409 L .447 .535 L .555 .438 L .062 .226 L -.045 .282 L -.436 -.056 L -.652 .059 L -.412 .297 L -.224 .692 L -.498 -.026 L -.461 -.183 L -.107 -.17 L .052 -.649 L .204 -.58 L -.978 -.845 L -.417 -.31 L -.174 -.269 L .036 -.24 L .284 -.396 L .116 -.579 L -.165 -.494 L -.737 -.055 L -.503 .213 L -.494 .396 L .16 .353 L .143 .932 L -.068 .509 L -.236 1.145 L .363 .903 L -.01 .311 L -.377 .636 L -.019 .227 L .275 .564 L -.726 .171 L -.513 .241 L -.476 .071 L -.245 -.324 L -.16 -.522 L .156 -.325 L .181 -.466 L .069 -.876 L .06 -1.073 L -.125 -.509 L .029 -.339 L -.213 -.395 L -.311 -.127 L -.391 .171 L -.574 .029 L .011 -.41 L -.25 -1.284 L .131 -.311 L .491 -.524 L .469 -.777 L .161 -.48 L -.089 -.918 L -.006 -.254 L .087 -.452 L .339 -.721 L .447 -.058 L -.043 -.861 L .254 -1.053 L
341.05 41.069 N 2.084 .272 L .344 .361 L -.869 .174 L -.541 .139 L -1.678 .106 L -1.159 .037 L -.689 .156 L -.372 .224 L -.308 .6 L -.361 .376 L 1.05 .39 L .971 .168 L 2.117 .064 L .601 -.001 L 1.775 -.242 L 1.93 -.038 L .866 .135 L .933 .219 L .417 .135 L .284 -.018 L 1.001 -.002 L 1.277 .032 L .615 .05 L -1.277 .626 L -1.583 .457 L -1.976 .523 L -.556 -.016 L -.695 -.116 L -.951 .671 L -1.061 .503 L -1.246 .452 L -1.125 .296 L -.211 .056 L -2.212 .054 L -.525 .134 L -.502 .001 L -.982 .201 L -.665 .167 L -.528 .051 L -.946 -.413 L -.375 .05 L -.69 .913 L -.958 .118 L -.631 -.065 L -.743 -.197 L -.622 -.463 L -.854 -.43 L -.647 -.215 L -.109 0 L .008 .2 L .707 1.043 L -.192 .249 L -.319 .017 L -.69 .249 L -.84 .249 L -.573 .38 L -1 .906 L -.657 .657 L -1.051 .851 L -.776 .262 L -1.034 .083 L -1.023 -.275 L -.148 .554 L -.438 .569 L -.783 .277 L -.992 -.095 L -.616 .05 L -1.18 .439 L .942 -1.723 L -.121 .017 L -.795 -.015 L -1.055 -.177 L .26 .423 L -.026 .455 L -.386 .407 L -.794 .39 L -1.16 .164 L -.973 .002 L -1.255 .083 L .467 .403 L .212 .403 L -.09 .387 L -.379 .097 L -.321 -.063 L -.47 .033 L -1.792 -.157 L .517 .32 L .765 .462 L .295 .351 L -.01 .224 L -.26 .176 L -1.197 .034 L -1.051 .129 L .844 .413 L .47 .126 L .448 .222 L .389 .333 L -.554 .461 L -.285 .111 L -.599 -.094 L -.478 .096 L .345 .474 L -.009 .127 L 308.501 60 l -.486 -.125 L -.583 -.062 L .026 .158 L .255 .457 L -.101 .347 L -.288 0 L -.656 -.093 L -.089 -.016 L -.979 .112 L -1.081 .018 L .682 .487 L 1.108 .391 L .331 .204 L -.077 1.035 L -.382 .938 L -.427 .094 L -.815 -.061 L .489 .591 L -.016 .498 L .156 .233 L -.068 .373 L -.316 .062 L -.495 -.03 L -.771 .079 L .762 .386 L .427 .603 L -.117 .447 L -.287 .031 L -.967 -.26 L -1.052 -.508 L -.498 .294 L -.425 .602 L -.635 -.599 L .158 -.573 L -.387 -.201 L -1.124 -.184 L -.577 -.309 L .04 -.187 L .253 -.249 L .066 -.218 L -.325 -.28 L -.366 -.186 L -.668 .359 L -.276 .016 L -.3 .141 L -.444 -.046 L -.98 .064 L -.417 .017 L -.571 .296 L -.476 .28 L -.426 -.403 L -.104 -.357 L -.222 -.217 L -.513 -.233 L -.817 -.232 L -.772 -.389 L -.517 -.781 L .07 -.737 L -.199 -.156 L -.434 -.094 L -.467 .048 L -.97 -.266 L -.108 -.094 L -.138 -.236 L .14 -.457 L .459 -.395 L .071 -.269 L -.258 -.062 L -.551 -.031 L -.542 -.094 L -.278 -.221 L -.058 -.633 L -.458 -.126 L -.616 .049 L -.589 -.57 L .023 -.191 L .198 -.254 L .618 -.367 L 1.22 -.337 L .405 -.304 L .476 -.128 L .051 -.383 L -.277 -.287 L -.473 .097 L -.921 .082 L -.493 .097 L -.635 .416 L -.538 .129 L -.63 .304 L -.339 -.318 L .038 -.623 L -.114 -.784 L -.206 -.451 L .015 -.355 L -.243 -.323 L -.504 .082 L -.271 -.032 L -.666 -.355 L -.594 -.485 L -.013 -.357 L .842 -.538 L .265 .019 L -.556 -.189 L -1.083 .064 L -.103 -.284 L .383 -.176 L .677 -.03 L .586 -.052 L .456 -.087 L .322 -.672 L -1.208 -.047 L -.572 .05 L -.362 -.032 L -.29 -.163 L -.116 -.197 L .223 -.28 L .218 -.008 L .18 -.16 L .427 -.055 L -.375 -.188 L -.552 .073 L -.22 -.248 L .057 -.188 L .073 -.132 L .259 0 L .309 -.099 L .827 -.25 L 1.218 .081 L .854 .163 L .776 .032 L .378 .131 L .927 .146 L 1.027 .097 L -.031 -.363 L .299 -.545 L -.298 -.182 L -1.02 -.263 L -1.356 -.312 L -.903 -.164 L -1.592 -.33 L -.354 -.116 L .336 -.35 L .788 -.001 L 1.462 .363 L 1.034 .048 L .463 -.067 L .114 -.067 L .088 -.6 L .088 -.301 L .595 -.034 L .528 .116 L .227 -.101 L -.027 -.351 L -.195 -.184 L -.891 -.317 L .162 -.437 L .528 -.455 L -.258 -.286 L -1.21 -.167 L -1.154 .002 L -1.178 -.286 L -1.649 -.49 L -.78 -.101 L -.903 -.05 L -.76 -.34 L -.811 -.477 L .156 -.035 L .323 -.155 L .605 -.001 L .572 -.019 L 2.085 .305 L .716 .033 L 1.249 .306 L 1.451 .458 L .729 .169 L .056 -.307 L -.311 -.426 L -.86 -.546 L -.172 -.446 L -.603 -.446 L -.485 -.051 L -.677 -.24 L .361 -.277 L .542 -.139 L 285.644 41 l -.704 -.241 L -1.101 -.015 L -.625 -.086 L -1.132 -.327 L -.88 .608 L -.324 .156 L -.274 .294 L -.875 .243 L -1.402 -.066 L -1.031 -.343 L -.306 -.242 L -.027 -.294 L .438 -.313 L .293 -.645 L -.152 -1.259 L .582 -.054 L .691 .192 L .372 -.124 L .151 -.334 L -.383 -.369 L -.933 -.545 L -.452 -.141 L -.946 -.796 L -.895 -.925 L -1.105 -1.289 L -.578 -.485 L -1.855 -.379 L -.667 -.255 L -.291 -.202 L -.052 -.701 L -.904 -.406 L -.962 -.109 L -1.589 -.165 L -1.928 -.425 L -1.903 -.333 L -2.133 -.183 L -.997 -.054 L -1.632 -.035 L -.785 .189 L -1.043 .096 L -.806 .188 L -1.419 .152 L -1.228 -.166 L -1.46 -.296 L .319 .747 L -.051 .093 L -1.051 -.017 L -1.294 -.184 L -3.168 -.611 L 1.538 -.566 L .463 -.114 L -.092 -.226 L -.423 -.169 L -1.067 -.017 L -2.21 -.015 L -.812 -.074 L -.629 -.018 L -1.238 -.434 L -.87 -.208 L .587 -.306 L 1.257 -.041 L 3.036 .147 L 2.025 .034 L 1.343 .017 L 2.117 -.157 L 1.055 -.212 L .292 -.096 L .054 -.345 L -.627 -.287 L -.82 -.21 L -1.217 .156 L -1.11 .252 L -1.31 .021 L -1.138 -.113 L -.753 .078 L -.879 .098 L -.68 -.056 L -.857 -.19 L -.664 -.365 L -.816 -.191 L -.662 -.057 L -.726 .059 L -.486 -.076 L -1.416 -.481 L -.044 -.35 L .36 -.45 L .81 -.119 L 1.235 -.1 L 1.517 -.14 L 2.074 -.161 L 1.29 -.081 L .951 -.396 L 1.089 -.259 L .843 -.081 L 2.478 -.005 L 1.101 -.101 L 1.942 .036 L .402 -.139 L .31 -.199 L .609 -.16 L .202 -.658 L .276 -.501 L .116 -.101 L -.89 -.228 L -1.947 -.039 L -1.155 .194 L -.959 -.125 L -1.243 -.383 L .595 -.781 L 1.38 -.332 L 2.845 -.359 L 1.407 -.225 L 1.962 -.249 L 2.112 -.162 L 1.163 .087 L 1.213 -.07 L 1.319 -.07 L .345 -.181 L .011 -.226 L -.357 -.753 L -.022 -.208 L .522 -.14 L 1.886 -.05 L 1.526 .205 L 2.141 .41 L 1.296 .226 L .802 .181 L .823 -.275 L -1.657 -.525 L -.697 -.509 L .167 -.047 L 2.2 -.122 L 1.166 -.12 L 1.854 -.216 L 2.52 -.195 L .73 .069 L 1.064 .116 L .232 1.738 L .913 -.162 L .539 -.322 L .432 -1 L 1.003 .021 L 2.004 .323 L 1.858 .414 L 1.529 .25 L .205 -.3 L -.644 -.3 L -.816 -.537 L -.894 -.4 L .295 -.287 L .742 .022 L 1.758 .02 L 1.136 .212 L 2.754 .373 L 1.284 .279 L 2.109 .322 L 1.878 .274 L 1.872 .204 L .8 -.209 L .816 -1.483 L -.326 -.191 L -1.292 -.334 L -1.176 -.533 L .708 -.247 L 2.404 -.005 L 2.962 -.328 L 1.329 -.077 L 1.527 .17 L 2.221 .488 L 1.567 .167 L 2.005 .142 L .3 -.761 L -.3 -.472 L 2.646 -.206 L 2.021 -.08 L 2.589 .095 L 1.989 .146 L 1.886 -.18 L 2.367 -.207 L 2.043 -.005 L 1.859 .223 L 1.825 -.055 L 1.315 .072 L .619 .099 L .55 -.102 L 1.946 .146 L 1.707 .046 L 1.673 .096 L 2.438 .761 L 1.368 .241 L 1.345 -.076 L 1.118 .168 L 2.594 .237 L .445 .408 L -.304 .12 L -.492 .192 L -1.683 .146 L -2.303 .124 L -1.152 .121 L -1.233 .05 L -1.469 -.068 L -2.831 -.064 L -2.22 -.066 L -1.389 .168 L -1.614 .027 L -1.933 .027 L -1.16 .026 L -1.485 .168 L -.444 .118 L -1.322 .213 L -.335 .464 L .743 .251 L 2.551 -.281 L 1.367 -.072 L 3.912 .038 L 2.223 -.12 L 2.331 -.005 L .997 -.025 L .93 .067 L 1.77 .434 L .671 .09 L 1.087 -.186 L 1.663 -.21 L 1.536 -.281 L 1.964 -.144 L .59 .462 L -.566 .482 L -2.316 .639 L -.973 .338 L -1.281 .734 L .12 .307 L .319 .152 L .796 -.089 L .477 -.044 L 1.616 -.553 L 1.766 -.537 L 1.413 -.385 L 1.706 -.32 L .775 -.207 L 1.662 -.163 L 1.618 .111 L 1.391 .065 L 1.497 -.3 L .703 -.324 L 1.129 -.234 L 2.148 -.004 L 1.672 .112 L 1.097 .044 L 1.197 .136 L 1.135 .228 L 1.107 .112 L .316 .25 L -.181 .273 L -1.97 .252 L -1.491 .138 L -1.245 .494 L -.557 .289 L -1.604 .355 L -1.57 .548 L -1.063 .089 L -.918 -.042 L -1.592 .047 L -2.213 -.039 L -1.491 .198 L -.731 .217 L -.495 .535 L .166 .322 L 1.949 -.305 L 1.581 -.046 L 1.856 .101 L .003 .42 L -.743 .241 L -2.388 .124 L -.463 .14 L -.213 .199 L -.156 .595 L -.471 .71 L -.678 .158 L -1.06 -.077 L -.742 .041 L -.837 .9 L -.987 1.087 L -.15 .347 L .454 .307 L .403 .095 L .602 -.481 L .743 -.368 L .856 -.041 L 2.345 .266 L .353 .096 L .262 .288 L -.059 .211 L -1.234 -.074 L -.673 -.018 L -.512 .097 L -.136 .191 L .29 .286 L 1.756 .188 L .557 .132 L 1.802 -.137 L .526 .208 L .214 .323 L -.049 .436 L -.256 .133 L -1.835 -.186 L -1.653 -.054 L -.781 -.074 L -1.295 .078 L -1.382 .475 L -.823 -.13 L -.49 -.15 L -1.06 .04 L -.283 .377 L 1.393 .599 L 1.187 .222 L 1.298 .128 L 1.665 .072 L .696 .148 L .551 .482 L .272 .444 L .014 .554 L -.434 .405 L -.384 .074 L -1.292 -.181 L -.82 -.109 L -.372 .111 L .023 .55 L .118 .236 L .426 .162 L .618 .089 L .723 .215 L .914 .142 L .752 .16 L .383 .376 L -.338 .233 L -.832 .145 L -.647 .126 L -1.747 -.032 L -1.176 -.087 L -1.624 -.086 L -.592 .448 L .551 .195 L 1.396 .051 L 1.052 .158 L .724 .248 L .088 .319 L -.035 .549 L -.13 -.005 L -1.092 -.045 L -1.247 .108 L -.596 .266 L -1.246 .02 L -1.225 -.139 L -1.497 -.404 L -.922 -.478 L -.373 -.07 L -1.094 .286 L 345 36.811 l -1.084 .09 L -.589 .178 L -1.451 -.033 L -.913 -.087 L -.969 .143 L -.395 .125 L -.174 .283 L .006 .141 L .354 .527 L .71 .245 L 1.284 .05 L 1.515 .26 L 1.567 -.056 L 1.323 .54 L .758 .226 L .482 .226 L 1.196 .329 L 1.252 .38 L .376 .276 L .483 .898 L .892 -.208 L .278 -.139 L .397 .207 L .298 .43 L .071 .344 L .198 1.164 L -.169 .205 L -.371 .12 L -.541 -.101 L -.546 -.119 L -.917 .002 L -1.041 .036 L -1.488 -.27 L -.637 -.409 L -.415 -.634 L -.354 -.274 L -1.17 -.566 L -.84 -.292 L -.748 -.137 L -1.095 -.084 L -.521 .14 L -.962 .105 L h 351.365 40.026 m -1.527 -.537 L -.96 -.225 L -.712 -.156 L -.159 -.069 L -.314 -.419 L 1.483 -.038 L .893 .139 L 1.064 .26 L .819 .296 L .162 .488 L -.215 .209 L -.533 .053 L h 281.574 46.135 m -.568 -.133 L -.707 -.318 L -.801 -.183 L -.197 -.101 L -.25 -.218 L -.08 -.844 L .287 -.34 L .368 -.018 L .646 .135 L 1.157 .066 L 1.287 .27 L .748 .269 L .595 .1 L .777 .217 L .603 .335 L -.144 .202 L -.112 .034 L -.543 .051 L -.774 .035 L -.77 .186 L -1.009 .153 L -.511 .102 L
105.98 81.688 N -.952 -.826 L -.198 -.342 L -.024 -.476 L .095 -.104 L .408 .044 L .312 -.045 L .781 .177 L .658 -.076 L .28 .119 L .138 .163 L -.234 .224 L -.173 .565 L -.028 .312 L -.581 .075 L -.483 .19 L h 125.24 92.375 m -1.312 -.288 L -1.345 -.434 L -.218 -.174 L .061 -.189 L .376 -.466 L -1.023 .002 L -.413 .248 L -.299 -.072 L -.416 -.188 L .166 -.452 L -.487 -.334 L -.269 -.014 L -.735 -.086 L -.226 -.262 L .317 -.292 L -.976 -.524 L -.556 .118 L -.386 -.102 L -.852 -.511 L -1.277 -.863 L -.219 -.235 L .02 -.117 L .962 -.12 L .337 .043 L 1.979 .598 L .981 .204 L 1.772 .202 L .385 .263 L .618 .526 L .426 .642 L .433 .422 L .362 .189 L 1.587 .536 L .316 .203 L .48 .756 L .116 .407 L -.279 .349 L -.407 .016 L h 271.379 92.089 m -1.202 -.23 L .641 -.743 L .358 -.161 L .279 .058 L .292 0 L .355 -.263 L -.697 -.653 L .079 -.219 L 272 89.003 l 1.121 -1.35 L 1.454 -1.31 L .725 -.442 L .496 -.192 L 1.315 -.194 L .198 .073 L .11 .221 L -.299 .221 L -.582 .03 L -.242 .133 L .349 .44 L -.755 .78 L -1.226 1.438 L -.271 .526 L .113 .291 L .11 0 L .428 -.176 L .483 -.555 L .458 -.191 L 1.115 .305 L -.896 .687 L .261 .203 L .229 .072 L 1.423 .565 L .758 -.03 L .325 -.408 L .309 -.059 L .718 .057 L .826 .202 L .616 .231 L -.297 .292 L -.373 .233 L -.708 .467 L .339 .333 L .477 .362 L .26 .014 L .417 -.161 L .464 -.132 L .278 .116 L .02 .16 L -.254 .262 L -.404 .248 L -.892 .104 L 280.84 93 l .273 .362 L .124 .405 L .28 .231 L .183 -.203 L .309 -.262 L .527 .159 L -.099 .449 L .149 .275 L .716 .028 L .085 -.015 L .015 .203 L -.168 .304 L -.25 .652 L -.34 .651 L -.222 -.072 L -.71 -.128 L -.301 -.144 L -.042 -.651 L -.601 .406 L -.374 .015 L -.095 -.274 L .497 -.652 L .011 -.333 L -.421 -.478 L -.279 -.072 L -.388 .392 L -.423 .291 L -.365 .146 L -.435 .204 L -.552 .536 L -.496 .334 L -.881 -.042 L -.222 -.217 L .165 -.145 L 1.229 -.408 L .466 -.522 L .632 -.363 L -.699 -.129 L -.601 -.057 L -.322 .464 L -.412 .015 L -.13 -.159 L .04 -.493 L -.757 .016 L -.148 .29 L -.41 .218 L -1.052 .045 L -.709 -.057 L -1.139 -.186 L -1.012 -.085 L -1.355 .061 L -1.014 .147 L -.145 -.188 L -.215 -.463 L .187 -.175 L .561 -.334 L .734 -.408 L .502 -.161 L .636 -.335 L h 265.435 98.655 m -.469 -.057 L -.497 -.273 L -.356 -.562 L .062 -.635 L .742 -.738 L .932 -1.043 L .816 .432 L -.375 .435 L -.112 .462 L -.233 .333 L -.262 .116 L -.58 .319 L -.244 .448 L .522 .244 L .168 -.029 L .279 -.26 L .42 -.362 L .617 -.319 L .309 .057 L .495 .461 L -.177 .347 L -.246 .159 L -1.134 .42 L -.682 .044 L h 211.34 59.677 m -.68 -.046 L .068 -.872 L -.375 -.333 L -.958 .161 L -2.375 .29 L .107 -.461 L .56 -.303 L 1.644 -.561 L -.302 -.478 L -.102 -.415 L .106 -.417 L .398 -.835 L .434 -.566 L .254 -.648 L .331 -.471 L 1.11 .566 L -.312 .518 L .791 .386 L .527 .047 L .402 -.469 L .67 .112 L .806 .289 L .917 .514 L .582 .255 L 2.168 .492 L .442 .271 L .176 .255 L -.09 .925 L .539 .047 L .57 -.065 L .934 .046 L .701 .142 L 1.019 .427 L -.419 .096 L -.269 .127 L -.46 .271 L -.949 -.046 L -.623 -.125 L -1.328 -.125 L -.438 -.126 L 217.259 58 l -.528 -.301 L -1.017 -.237 L -.528 .017 L -.203 .271 L .174 .588 L -.126 .096 L -1.314 .161 L -.673 .493 L -.588 .302 L -1.116 .287 L h 200.125 19.1 m -.862 -.015 L -1.085 -.195 L -.308 -.664 L .819 -.304 L .77 -.072 L .666 -.024 L 3.475 -.125 L 1.263 -.12 L 1.374 -.026 L 1.714 .324 L .397 -.094 L .397 -.377 L 1.303 -.287 L 1.759 -.099 L 1.975 .209 L .746 -.001 L 2.562 .137 L 2.621 .324 L 1.424 .09 L 1.461 .161 L .448 -.165 L -1.433 -.42 L -1.67 -.352 L -.816 -.429 L .293 -.242 L 1.361 -.148 L 1.101 -.246 L 1.431 -.101 L 2.382 -.201 L 1.666 .119 L 1.944 .191 L 1.009 .265 L 1.19 .456 L .354 .047 L .273 -.362 L -.959 -.508 L -.828 -.292 L .499 -.248 L 1.45 .121 L 1.832 .168 L 1.653 .07 L 1.639 .46 L .378 .023 L .062 -.195 L -.301 -.539 L 1.781 -.004 L 1.408 .046 L .832 .269 L .831 .34 L .618 -.001 L -.044 -.268 L -.331 -.467 L 1.075 -.077 L 3.691 .386 L 2.726 .288 L 1.937 -.077 L 2.987 .018 L .967 .047 L .757 .12 L .126 0 L 1.419 .094 L 1.089 .191 L .744 .095 L 1.685 .044 L 1.357 .357 L -.385 .358 L -1.237 .121 L -1.206 .356 L -1.849 .191 L -.978 -.045 L -2.191 -.159 L -2.284 .005 L -.776 .142 L -1.915 .168 L -.597 .465 L .75 .366 L .761 .044 L 1.03 -.048 L 1.705 -.279 L .79 .021 L .808 .434 L -.168 .114 L -1.246 .139 L -1.38 .207 L -1.174 .295 L -2.098 .518 L -1.316 .224 L -1.19 .355 L -.924 .286 L -2.252 .005 L .65 .906 L -.449 .193 L -2.297 .455 L -.768 -.019 L -1.587 -.037 L -1.462 -.218 L -2.386 -.164 L -.66 .33 L 2.591 .695 L -.662 .141 L -.967 -.038 L -1.297 .022 L -1.068 .022 L -2.58 -.214 L -2.009 .063 L -.134 .66 L 1.257 -.105 L 1.065 .018 L 2.312 .292 L .557 .157 L .12 .67 L -.33 .197 L -1.031 .12 L -.515 .705 L -1.073 .021 L -.448 -.058 L -.402 .176 L .297 .253 L .759 .25 L -.328 .136 L -1.615 .08 L -.867 -.037 L -1.71 -.171 L -.422 .078 L .41 .791 L -.08 .231 L -.649 .289 L -.767 .155 L -1.52 -.112 L -2.039 -.111 L -1.43 -.227 L -1.008 .079 L -1.219 .5 L 1.031 .112 L .368 .057 L 2.154 .11 L 1.759 .13 L 1.534 .168 L 2.001 .034 L .66 .34 L .045 .359 L -.907 .398 L -2.685 .268 L -.927 .115 L -1.054 .227 L -1.115 .077 L -.467 -.28 L -.797 -.638 L -.56 .039 L -.631 .001 L -1.453 -.318 L -.001 .17 L .331 .508 L -1.477 -.016 L -1.5 -.129 L -.875 -.319 L -1.033 -.471 L -.388 .058 L .527 .717 L -.24 .17 L -.821 .133 L -1.72 -.109 L -2.276 -.033 L -.972 -.073 L -1.382 -.394 L -.642 -.131 L -.282 .453 L -.619 .152 L -1.843 -.316 L .161 -.586 L .219 -.228 L 1.525 -.117 L .61 -.249 L .961 -.173 L 1.179 .036 L .499 -.172 L -1.073 -.4 L -1.043 -.651 L .052 -.154 L .479 -.117 L 1.316 .036 L 1.743 .093 L .888 .21 L 1.108 .517 L 1.35 .323 L 1.085 .093 L 1.667 -.022 L .829 -.136 L .086 -.268 L .514 -.304 L -3.019 .001 L -1.025 -.171 L -.156 -.85 L .211 -.154 L -1.74 -.153 L -1.963 -.152 L -.274 0 L -.631 .114 L .204 -.758 L 1.159 -.551 L 1.104 -.16 L 1.837 -.003 L 1.164 .037 L 1.37 .076 L 2.023 .311 L 1.342 .115 L .486 -.158 L 1.132 -.041 L -3.399 -.802 L -1.742 -.313 L -3.555 -1.27 L -.406 .242 L -1.398 -.878 L .025 -.258 L .313 -.108 L 1.747 .104 L 1.905 -.004 L 2.019 .06 L 1.6 .382 L 2.535 .784 L 1.448 -.043 L .833 .095 L -1.387 -.555 L -2.015 -.317 L 1.208 -.743 L 1.456 -.329 L 1.731 -.025 L 1.529 -.222 L 2.042 -.07 L 1.157 -.112 L 1.414 -.051 L -1.778 -.479 L -1.425 -.153 L -2.501 .027 L -1.243 .248 L -1.305 .158 L -1.425 .202 L -1.447 .047 L -.586 .067 L -1.532 -.438 L -.214 .111 L -.543 .156 L -2.16 -.018 L -1.58 .365 L .311 -.828 L .98 -.292 L .007 -.202 L -.606 -.247 L -1.375 -.156 L -1.39 .003 L -4.189 .505 L -2.031 .672 L -.408 -.11 L -.569 -.251 L .395 -.133 L .678 -.023 L -.117 -.316 L -.698 -.398 L -1.216 -.056 L -.216 -.003 L h 200.125 20.844 m .899 -.096 L .832 .196 L .339 .5 L .511 .495 L .427 .063 L 1.141 .041 L -.081 -.236 L .056 -.411 L .438 -.109 L .718 .194 L .718 .322 L .374 .3 L -.066 .171 L .056 .826 L .764 .442 L .953 -.017 L 1.276 -.074 L 1.646 .504 L -1.123 -.264 L -1.528 .34 L -1.599 .221 L -.83 .377 L -.287 .197 L -.265 .315 L -.448 .021 L -1.493 -.41 L -.656 .335 L .465 .43 L -.029 .235 L -.412 .196 L -.392 .04 L -1.086 -.31 L -.944 -.311 L -.26 .645 L -.117 .068 L -.083 .049 L -.888 .041 L -1.74 -.094 L -1.458 -.153 L -.888 -.154 L -.494 .021 L -3.115 -1.31 L -.191 -.276 L 1.971 -.241 L 3.32 .093 L .889 .097 L 1.573 .1 L -2.485 -.693 L -3.019 -.213 L -1.103 .122 L -1.43 -.017 L -.597 .18 L -1.008 .022 L -.606 -.198 L -1.066 -.517 L -1.425 -.479 L -.341 -.355 L 1.971 .124 L 2.278 -.175 L -1.255 -.249 L -.756 -.351 L .38 -.305 L .729 -.132 L .769 -.023 L .921 .042 L .156 -.219 L -1.799 -.793 L 1.053 -.114 L 1.213 -.182 L 1.13 .087 L .584 -.046 L .145 -.18 L -.514 -.475 L 1.362 .134 L .941 .066 L .83 .202 L 1.589 .869 L .653 .264 L .772 .24 L .674 -.001 L .36 -.039 L h 179.067 27.216 m -1.156 -.056 L -.604 -.173 L -.926 -.638 L -.621 -.193 L -3.102 -.091 L -1.487 .081 L -.622 .001 L -1.444 -.056 L -.767 -.154 L -1.019 -.37 L -.161 -.234 L .335 -.138 L .802 -.001 L 1.687 .232 L .867 -.021 L -.031 -.235 L -.252 -.275 L -1.344 -.49 L -.579 -.098 L -1.075 -.077 L -1.392 -.196 L .065 -.397 L 2.246 -.124 L 2.392 .155 L .77 .376 L .999 .453 L 1.979 .193 L 2.189 .114 L 1.178 .233 L .604 .254 L 1.123 .721 L .581 .446 L .168 .426 L -.481 .194 L -.919 .137 L h 185.907 26.758 m -1.078 -.037 L 184 26.529 l -1.029 -.484 L -1.144 -.76 L -.03 -.216 L .239 -.099 L 2.296 -.044 L 1.816 .311 L 3.101 .542 L -.047 .351 L -.254 .331 L -.436 .04 L -1.563 .177 L -1.043 .08 L h 156.886 26.865 m -1.573 .646 L -.558 .27 L -1.85 .042 L -1.019 .079 L -1.898 -.15 L -.577 -.114 L -.302 -.423 L .334 -.291 L 1.365 -.177 L .899 .056 L 2.351 -.102 L .496 0 L 2.331 .163 L h 132.902 31.305 m -.53 -.186 L -.95 -.466 L -.424 -.112 L -.33 .057 L -.56 .207 L -1.269 .059 L -.786 -.279 L -.283 -.319 L .23 -.264 L 1.13 -.097 L .503 -.133 L .771 -.134 L .977 -.399 L .848 -.211 L .726 -.172 L .548 -.344 L 1.083 -.231 L 1.277 -.079 L 2.532 -.158 L 1.68 .016 L .888 -.29 L 1.038 -.079 L 1.503 .438 L -.756 .097 L -.852 .231 L -.22 .268 L .12 .266 L .469 .474 L -.777 .001 L -.912 .115 L -.918 .662 L -1 -.017 L -.867 -.981 L -.694 -.15 L -.379 .02 L -.229 .285 L -.588 .342 L -.63 .623 L -.595 .151 L -.284 .375 L -.705 .356 L -.787 .058 L h 191.827 30.313 m -1.266 -.054 L -2.278 -.165 L -.426 .058 L -.332 -.094 L -.896 -.489 L -1.185 -.414 L .192 -.229 L 2.433 -.042 L 1.542 .263 L 1.472 .054 L .171 0 L .89 .358 L -.179 .246 L .123 .32 L -.263 .188 L h 144.688 31.739 m -2.222 -.395 L -.325 -.674 L .503 -.057 L .595 -.17 L .945 -.096 L .953 -.133 L 1.279 -.059 L .522 .187 L .65 .374 L .659 .186 L 1.55 -.209 L .617 .149 L 1.624 .762 L 1.016 .351 L .897 .036 L .96 -.058 L 1.418 .09 L .591 -.02 L 1.116 -.169 L .092 -.297 L -.557 -.559 L -.941 -.391 L -1.347 -.354 L .96 -.322 L .524 -.379 L .569 -.152 L 1.097 -.116 L .507 .17 L .773 .678 L -.017 .413 L .518 .654 L .565 .111 L .9 .036 L 1.805 .406 L -.334 -.465 L .151 -.28 L .409 -.076 L 1.495 .24 L .932 .39 L -.292 .409 L .039 .5 L -.358 .461 L -.573 .277 L -.755 .111 L -.782 .001 L -1.682 .095 L -1.156 -.071 L -1.757 -.18 L -.622 -.017 L -1.129 .277 L -1.132 .202 L -.76 .182 L -.977 .254 L -1.625 .292 L -1.338 .2 L 149.23 34.5 l -.748 -.07 L -1.445 -.286 L -.276 -.378 L .648 -.128 L 1.219 -.038 L .738 -.146 L .852 -.075 L 1.166 -.057 L .622 .017 L 1.09 -.149 L .483 -.553 L -2.768 -.087 L -.925 -.054 L -1.564 .28 L -1.625 .168 L -1.292 .04 L -.795 .093 L -1.681 -.347 L -.479 .167 L -.92 .075 L -.979 -.127 L -.854 -.33 L .023 -.111 L .863 -.427 L 1.098 -.058 L 2.047 -.022 L .96 -.159 L h 178.479 33.234 m -.984 -.219 L -.193 -.294 L .764 -.389 L .433 -.112 L .088 -.167 L -.447 -.333 L -1.161 -.054 L -2.13 .227 L -.939 .076 L -.331 .019 L -.854 -.276 L .039 -.335 L .739 -.02 L .542 -.244 L .587 -.057 L -.466 -.598 L .176 -.245 L .132 -.226 L .49 .018 L .859 .224 L 1.942 .746 L .426 .186 L .46 -.094 L -.101 -.243 L -.959 -.486 L -.371 -.131 L -.407 -.357 L .436 -.095 L .956 -.059 L .713 .131 L 1.033 .262 L .572 .168 L .27 .018 L .162 -.452 L .478 -.133 L .73 .112 L .717 .168 L .327 .168 L .367 .75 L -.034 .616 L -.247 .242 L -.831 .335 L -.017 .352 L .35 .625 L -.361 .147 L -1.648 -.089 L -.862 .112 L -1.446 .003 L h 200.125 30.572 m -.895 .045 L -.853 .17 L -.37 .467 L 1.133 .054 L .984 -.038 L .046 -.001 L .847 .11 L .463 .129 L .498 .463 L .727 .424 L .621 .091 L .213 -.074 L .043 -.314 L .286 -.056 L 1.075 -.002 L .883 -.187 L .766 .11 L .835 .239 L .665 .257 L .976 .053 L .775 -.463 L 1.393 -.281 L 1.704 -.114 L 1.951 -.246 L 1.533 .053 L 2.59 .014 L .381 .037 L .79 .314 L .911 .239 L 1.418 .146 L .653 .128 L .21 .037 L .361 .166 L .181 .257 L -.4 .148 L -1.833 .407 L -.135 .255 L .469 .666 L -2.486 .076 L -.592 .02 L -.651 .091 L -.768 -.053 L -.846 -.16 L -.405 -.125 L -.306 -.667 L -.833 -.218 L -.366 .129 L .072 .723 L -.536 .127 L -.747 -.053 L -.91 .109 L -.728 -.017 L -.495 .001 L -1.342 -.213 L -.593 -.197 L -.495 -.017 L -.209 .433 L -1.801 .111 L -.831 .074 L -1.453 -.069 L -.404 -.251 L -.144 -.686 L -1.237 .129 L -.389 .181 L -.326 .325 L -.955 .2 L -1.011 -.034 L -.112 -.027 L -.704 -.169 L -1.186 -.575 L -.675 .489 L -1.131 -.07 L -.666 -.688 L -.442 -.717 L .587 -.481 L .019 -.371 L -.292 -.316 L -1.249 -.651 L -.617 -.299 L -.047 -.338 L .636 -.133 L 1.226 -.078 L 2.472 -.023 L .763 .093 L 1.118 .261 L .188 .04 L .872 .184 L -.613 .189 L -.259 .013 L h 128.19 41.985 m -.926 -.016 L -1.059 -.102 L -.362 -.466 L -.549 -.467 L -.432 -.259 L -1.123 -.363 L -1.36 -.067 L -.951 -.138 L -.469 -.19 L -.168 -.174 L .537 -.106 L .589 -.298 L .481 -.211 L .08 -.386 L -.437 -.809 L .552 -.001 L .468 -.177 L .307 -.372 L 1.104 -.533 L .526 -.588 L -.121 -.32 L -.271 -.16 L -1.229 -.677 L -.375 -.448 L .869 -.001 L .823 -.056 L 1.455 .051 L .97 .016 L 1.515 -.092 L 1.284 -.146 L 1.242 -.074 L .495 .125 L 3.242 .801 L .918 .088 L .708 -.055 L 1.316 -.127 L 1.223 .016 L .771 .07 L 1.35 .373 L 2.389 .815 L -.242 .143 L -.432 .036 L -.26 .072 L -1.609 .322 L -1.073 .144 L -1.829 .428 L -1.069 .319 L -1.604 .725 L -1.025 .563 L -.549 .089 L -.974 .124 L .066 .924 L -.271 .504 L -.662 .278 L -1.215 .124 L -1.213 -.067 L -.521 .485 L -.898 .312 L h 190.483 39.666 m -1.146 -.208 L -.146 -.524 L -.941 -.806 L -.207 -.582 L .058 -.389 L .27 -.657 L .377 -.321 L 1.256 .033 L -.089 -.16 L -.416 -.266 L -.185 -.286 L .211 -.09 L .234 -.072 L 2.154 -.058 L 1.215 .087 L 1.464 .248 L 1.282 .051 L 1.316 -.146 L 1.051 .016 L .694 .105 L .639 .213 L -.007 .089 L -.224 .179 L -.824 .428 L -.874 .746 L -1.513 .92 L -1.386 .073 L -2.379 -.154 L -1.269 .055 L 1.392 .717 L -.188 .315 L -.855 .369 L -.964 .072 L h 181.204 41.523 m -.491 -.085 L -1.101 -.552 L -.952 -.641 L -1.014 -.468 L -.978 -.225 L -1.438 -.12 L -.55 -.174 L -2.255 -1.066 L .866 -.654 L .653 .14 L 1.032 .474 L 1.063 .227 L .46 .052 L .615 -.283 L .908 -.619 L .415 -.036 L .018 -.212 L -1.062 -.565 L -1.068 -.424 L -.177 -.231 L .132 -.107 L 1.683 .086 L .711 -.215 L .42 0 L .996 .39 L .56 .035 L .58 -.055 L .435 -.25 L 1.232 -.127 L 1.354 .069 L .912 .23 L -.324 .268 L -.58 .125 L -.323 .338 L -1.55 .375 L -.392 .16 L -.069 .194 L .253 .247 L .506 .105 L .692 -.089 L 1.08 .174 L .868 .245 L .391 .017 L .564 .262 L .186 .438 L -.681 .352 L -.156 .35 L -.271 .68 L -.457 .366 L -.508 .14 L -.658 .019 L -.582 -.103 L -.773 -.346 L -.653 -.103 L .013 .208 L 1.054 .553 L -.817 .399 L -.77 .036 L h 243.524 60.394 m -.234 -.208 L -1.199 -.235 L -.673 -.331 L -.154 -.269 L .346 -.064 L .616 -.461 L -1.378 -.521 L -1.132 -.125 L -.76 -.349 L -.929 -.731 L -.035 -.511 L -1.115 -.062 L -1.311 -.366 L -.675 -.031 L .284 .767 L -.155 .096 L -.409 -.015 L -1.704 -.332 L -.309 .033 L -.325 .304 L -.441 .288 L -1.312 .082 L -1.349 -.173 L -1.343 -.189 L -.813 -.254 L -.052 -.319 L .196 -.4 L .382 -.354 L 1.066 -.163 L .192 -.178 L -.128 -.516 L .206 -.033 L 1.357 .11 L 1.408 .175 L .517 .144 L .962 .626 L .051 -.386 L -.154 -.193 L .077 -.194 L .585 -.033 L .977 -.099 L .652 -.163 L .649 -.114 L .515 .063 L .785 .031 L .166 -.275 L -1.138 -.825 L -.773 -.356 L -.119 -.228 L .167 -.163 L .586 -.066 L .72 -.246 L 1.409 -.591 L .361 -.541 L .771 -.46 L .493 -.379 L -.109 -.593 L -.899 -.841 L -.407 -.496 L -.541 -.364 L -.414 .001 L -1.258 -.33 L -1.041 -.481 L -.244 -.467 L -.527 -.384 L -.442 .202 L -.551 .202 L -.825 -.015 L -.293 .117 L -.62 .018 L -1.255 .169 L -.214 -.667 L 1.032 -.052 L 1.23 -.103 L .163 -.269 L -1.604 -.618 L -1.552 -.67 L -.879 -.015 L -.567 -.185 L -.169 -.542 L -.677 -.339 L -.45 -.05 L -.918 -.306 L -.687 -.341 L -.385 -.119 L -.611 .155 L -.81 -.187 L -1.177 -.238 L -.489 -.085 L -.379 .138 L .529 .307 L .453 .05 L 2.838 .712 L .438 .271 L .069 .306 L -.505 .221 L -.669 .069 L -.541 -.033 L -.757 -.049 L -.818 -.252 L -1.153 -.27 L -.667 -.066 L -.323 .17 L .044 .204 L .426 .236 L .259 .438 L -1.703 -.553 L -.47 -.05 L -.396 .119 L -.63 .153 L -.767 -.218 L -.693 -.117 L -.859 .12 L -1.474 -.184 L -1.995 -.167 L -1.321 .037 L -1.146 -.032 L -.862 -.186 L -.003 -.597 L -.363 -.153 L -.904 -.049 L -.396 .342 L -.623 .086 L -1.214 -.049 L -1.076 -.168 L -1.303 -.477 L -.415 -.376 L .123 -.275 L .868 -.07 L 1.131 .067 L 1.212 .101 L .879 -.019 L .312 -.19 L -.934 -.463 L -.8 -.275 L -.905 -.102 L -1.106 -.119 L -.752 .036 L -.539 -.017 L -1.249 -.223 L .114 -.416 L .292 -.557 L .34 -.14 L .646 -.054 L .081 -.227 L -1.082 -.4 L -.044 -.175 L .449 -.79 L 1.197 -.919 L .565 -.284 L .918 -.321 L .74 -.374 L .423 -.037 L .37 -.178 L .698 -.001 L .481 -.125 L .71 -.09 L 1.436 -.109 L 1.348 .033 L .857 .194 L -.92 .393 L -.815 .48 L -1.394 .639 L -.43 .529 L .169 .369 L 1.256 .541 L -.444 .298 L -.076 .402 L .257 .313 L .862 .554 L 1.559 .621 L -.096 .121 L -1.272 .331 L -.072 .31 L .959 .033 L 1.504 .101 L .654 -.639 L -.103 -.415 L -.343 -.277 L -.724 -.103 L -.422 -.138 L -.884 -.538 L .101 -.157 L .506 -.245 L .473 -.193 L 1.001 .12 L .837 -.071 L -1.204 -.47 L -.703 -.034 L -.793 -.279 L -.056 -.193 L .053 -.545 L .886 -.319 L 1.207 .086 L 1.509 -.056 L -.939 -.281 L -1.233 -.351 L .793 -.303 L 1.288 -.198 L 1.044 -.126 L 1.688 -.323 L 1.114 .016 L .642 .052 L .833 .141 L .782 .478 L 1.536 .97 L .058 .141 L -.583 .687 L -.709 .632 L .038 .733 L .364 .086 L .65 .033 L 1.088 -.315 L .284 -.455 L .595 -.088 L .791 .034 L .454 .174 L -.006 .262 L .16 .47 L .875 .189 L .196 -.122 L -.204 -.854 L .218 -.123 L .456 -.474 L 1.038 -.265 L .98 -.054 L .748 .034 L .98 .174 L 1.172 .138 L 1.151 -.09 L .688 .139 L .327 .262 L .621 .331 L .574 .191 L 235.438 40 l 0 .191 L -.531 .088 L -.484 .279 L -.818 .262 L -.148 .225 L .45 .259 L .427 .068 L .897 -.417 L .652 -.174 L .502 .051 L .476 .242 L .365 .466 L .516 .413 L .342 -.242 L 1.304 -.798 L 1.935 .256 L .915 .361 L -.051 .069 L -.638 .346 L -.708 .517 L 1.167 -.054 L .455 -.173 L 1.078 -.105 L .033 .704 L .797 .324 L .523 -.069 L .831 -.207 L 1.316 -.088 L .816 .221 L .566 .273 L -.162 .154 L -.461 .223 L -1.87 .43 L -.238 .272 L .523 .253 L .456 -.068 L .747 -.171 L 1.235 -.122 L .406 -.29 L .361 -.103 L .479 .067 L .51 .187 L .544 .339 L .636 .522 L -1.019 .002 L -1.2 .053 L -.424 .135 L .059 .269 L .372 .134 L 1.333 .065 L .938 .183 L .543 .217 L .233 .301 L -.37 .034 L -.748 .001 L -1.011 -.082 L -.875 -.216 L -.824 -.065 L -.316 .185 L 1.23 .583 L -.216 .201 L -1.552 .12 L .245 .283 L .437 .166 L .551 .032 L 1.331 .364 L 1.312 .347 L .247 .182 L .039 .282 L .351 .38 L .75 -.217 L .536 .049 L 1.413 .295 L .298 -.067 L .649 -.15 L .61 .032 L .752 .379 L .862 .477 L .376 .346 L -.685 .1 L -.801 .117 L -.027 .444 L .795 -.001 L 1.405 -.052 L .51 -.132 L .895 .048 L -.386 .559 L .918 .179 L .514 -.001 L .943 -.379 L .685 .343 L 1.089 .407 L .194 .098 L -.275 .229 L -.254 .099 L -.103 .326 L -.819 .05 L -.718 -.21 L -.247 -.048 L -.794 .213 L .968 .454 L .279 .162 L .057 .276 L -1.057 .197 L -.356 .228 L -.312 .292 L -.372 -.113 L -.819 -.583 L -.29 1.103 L .354 .903 L -.419 .065 L -.677 -.257 L -.751 -.176 L -.205 -.177 L -.018 -.243 L -.315 -.274 L -.93 .276 L -.743 -.613 L .051 -.292 L .27 -.374 L -.304 -.129 L -.224 -.016 L -.992 -.08 L -.718 -.292 L -1.17 -.617 L -.769 -.292 L -.762 -.048 L -.452 .23 L -.645 .083 L 250 52.592 l .281 .179 L 1.05 .682 L -.321 .114 L -.686 .05 L -.359 -.259 L 249.277 53 l -.646 -.21 L .275 .488 L .859 .972 L .604 .015 L .587 .08 L .5 .581 L .612 .805 L .513 .432 L .615 -.321 L .285 .047 L .592 .399 L .585 .271 L 1.38 .396 L -.634 .113 L -.213 .208 L .254 .19 L .568 .286 L .962 .444 L .324 .237 L .242 .682 L -.112 .428 L -1.302 -1.155 L -.554 -.237 L -.027 .238 L .118 .27 L 1.055 1.281 L -.01 .3 L -.926 -.125 L .053 .205 L .432 .409 L .378 .519 L -.563 -.172 L -.615 -.313 L -.889 -.693 L -.145 -.031 L -.719 .064 L -.91 -.188 L -1.44 -.662 L -.319 -.285 L -1.062 -.665 L .187 .777 L -1.22 -.473 L -.567 -.158 L -.872 -.03 L .095 .222 L .799 .696 L .853 .426 L 1.842 .645 L 1.296 .644 L .774 .549 L .442 .486 L .429 .689 L -1.833 -.341 L -1.524 -.421 L -1.251 -.28 L -1.444 -.107 L -1.092 -.25 L -.898 -.644 L -1.146 -.14 L -.638 -.204 L -.635 -.141 L -.058 .145 L h 146.194 38.698 m .818 -.037 L .78 -.125 L 1.138 -.548 L .895 -.019 L 1.723 .243 L .939 .262 L -.188 .877 L .515 -.071 L .66 -.019 L .792 -.229 L .599 -.141 L .758 .016 L .334 -.071 L -.989 -.965 L .156 -.036 L 1.38 .138 L 1.208 .245 L .675 .245 L .259 .245 L .194 .508 L .965 1.063 L .638 .346 L 1.045 -.315 L .14 -.261 L -1.243 -1.361 L -.439 -1.321 L .228 -.354 L 1.91 .262 L 1.775 .156 L 2.031 .719 L .36 .175 L .3 .316 L .16 .701 L .511 .645 L .352 .26 L .856 .606 L .048 .19 L -.178 .243 L -.333 .605 L .179 .31 L .224 .12 L 1.4 .649 L .509 .171 L 1.151 .254 L 1.513 .1 L 2.056 .576 L 1.012 .39 L .364 .793 L -.168 .101 L -1.071 -.082 L -.811 -.234 L -.945 -.234 L -.551 .169 L -.665 .204 L -1.021 .036 L -.256 .118 L .208 .689 L 1.087 -.069 L .614 -.152 L .676 -.119 L .876 .536 L -.01 .235 L -.526 .151 L -.517 .252 L -.583 .102 L -1.417 .12 L -1.049 -.015 L -1.194 -.082 L -1.594 -.248 L -2.278 -.499 L -.553 -.217 L -.436 -.335 L -.482 -.033 L -.581 .102 L -.402 .37 L -1.114 .505 L -1.055 .019 L -1.411 .103 L -1.253 .42 L -2.753 .356 L -1.42 .019 L -1.205 .086 L -1.984 -.063 L -.483 .101 L -.916 -.015 L -1 -.282 L -.061 -.468 L .198 -.101 L .002 -.302 L -.395 -.2 L -.462 -.1 L -3.146 -.112 L -1.258 -.115 L -.864 -.167 L -.801 -.2 L -.753 -.504 L -1.274 -.554 L .303 -.069 L .531 -.222 L 1.572 -.054 L .603 -.188 L .558 .016 L .91 -.019 L .904 -.087 L 1.716 .031 L .935 -.002 L 2.14 .047 L 1.09 -.002 L 1.711 -.038 L .415 -.154 L -.681 -.221 L -2.312 -.492 L -1.942 -.202 L -4.059 -.061 L -1.569 -.014 L -1.694 .055 L -.955 .053 L -.604 .001 L -1.651 -.529 L .011 -.207 L .28 -.069 L .823 -.053 L 1.315 -.209 L .996 .032 L 1.78 -.141 L .931 -.105 L .5 -.277 L -.392 -.346 L -2.023 .073 L -1.578 .159 L -.393 -.051 L -.554 -.189 L -.677 -.346 L -.65 -.19 L -.692 .054 L -.709 -.242 L -.039 -.279 L 1.304 -.981 L 2.62 -.848 L .909 -.143 L .373 -.177 L 1.297 -.267 L 1.324 -.162 L .701 -.267 L 1.113 -.091 L 1.026 .246 L -.07 .212 L -.548 .354 L -.021 .81 L h 251.273 99.526 m -.188 .153 L -.16 -.291 L .192 -.077 L -.02 -.256 L .143 -.069 L -.042 -.154 L -.224 0 L -.606 -.231 L .077 -.229 L -.31 -2.819 L -.174 -.274 L -.488 -.288 L -.771 -.025 L -.41 .176 L -.381 -.085 L -.505 -.36 L -.273 -.085 L -.632 .526 L -.514 .626 L -1.139 2.22 L -1.139 1.45 L -1.161 -.124 L -.402 .06 L -.363 .435 L -.174 .375 L -1.093 -.095 L -1.855 -.004 L -2.508 -.029 L -1.76 .009 L -.968 .523 L -.534 .305 L -1.754 .814 L -.545 .164 L -.146 .434 L -.163 .512 L -.44 .275 L -1.156 .197 L -1.305 -.138 L -1.123 -.01 L -.93 .091 L -.47 .203 L -.162 .375 L .018 .319 L .16 .471 L .047 .362 L -.875 .427 L -1.464 .452 L -.944 .163 L -.919 .062 L -.88 .262 L -.939 .478 L -.925 .506 L -.524 .117 L -.573 -.068 L -.497 -.169 L -.371 -.427 L -.012 -.33 L .044 -.218 L .707 -.525 L .414 -.294 L .264 -.433 L .294 -.544 L .377 -.576 L .028 -.746 L -.054 -.545 L -.876 -3.16 L -2.529 -1.05 L -.26 -.33 L .11 -.318 L -.307 -.235 L -.916 -.181 L -.184 -.294 L -.178 -.135 L -.628 .024 L -.46 -.465 L -.101 -.429 L -2.15 -1.061 L -3.975 -1.576 L -.977 -.386 L -.797 -.227 L -.805 .189 L -1.469 .592 L -.707 -.074 L -.542 .049 L -.196 -.144 L -.156 -.115 L -.474 -.041 L -.855 .083 L -.197 -.116 L -.028 -.282 L -.373 .075 L -.412 .191 L -.219 .06 L -.573 .141 L -.506 -.098 L -.064 -.185 L -.469 -.086 L -.241 -.271 L -.502 -.013 L -.16 .247 L -.338 -.48 L -.271 .012 L -.02 -.185 L -1.425 -.208 L -.518 .076 L -.833 -.451 L -.468 -.46 L -.279 -.371 L -.896 -.748 L -.501 .036 L .131 .347 L .387 .588 L -.68 -.003 L -2.687 .029 L -2.798 -.029 L -1.348 .007 L -2.105 -.003 L -2.915 .016 L -2.781 -.029 L -2.131 .012 L -2.935 -.014 L -.601 .003 L -4.84 -.018 L -3.617 .004 L -.875 .005 L -3.821 -.023 L -1.089 .035 L -4.13 -.021 L -.74 -.011 L -5.117 .028 L -1.687 -.006 L -2.87 .001 L -3.938 -.008 L -4.588 .025 L -1.335 -.022 L -2.579 -.001 L -.194 -.013 L -.187 -.151 L -.509 -.305 L -.071 -.437 L .074 -.346 L -.708 .25 L -.373 -.029 L -.331 -.305 L -.162 -.496 L -.125 -.189 L -.385 .088 L -.23 .205 L -.483 .059 L -.721 -.495 L -.119 -.425 L -.201 -.821 L -1.051 .104 L -1.01 -.277 L -.487 -.087 L -.173 -.087 L -.143 -.396 L -.438 -.352 L -.591 .222 L -1.236 .046 L -.461 -.117 L -.383 -.249 L -.106 -.25 L .257 -.648 L .458 -.222 L -.227 -.294 L -1.24 -.086 L .617 -.518 L .398 -.281 L .547 -.149 L .605 -.508 L -.874 .006 L -.621 .149 L -.362 -.043 L 116 83.422 l -.039 -.978 L -.789 .002 L -1.015 -1.066 L .132 -.238 L .034 -.53 L -.547 .056 L -.83 .492 L -1.266 -.934 L -.384 -.521 L -.204 -.402 L -.068 -.432 L .419 -.404 L .161 -.254 L .436 -.3 L -.358 -.689 L -.393 -.777 L .163 -.788 L -.402 -.255 L -2.025 -.763 L -.98 -.314 L -.189 -.029 L -.512 -.393 L -1.67 -1.882 L -1.769 -1.768 L -.814 -.58 L -2.048 -1.175 L -.35 -.322 L -.371 -.492 L -.316 -.199 L -.832 -.073 L -.495 .126 L -.731 .498 L -1.225 .67 L -.848 .205 L -.238 .325 L -.945 -.673 L -2.162 -1.318 L -.348 -.292 L -.173 -.387 L -.332 -.388 L -.739 -.059 L -2.424 .122 L -.84 -.074 L -.196 -.279 L -.089 -1.046 L -.026 -2.167 L .043 -4.334 L .026 -2.183 L -.129 -2.796 L -.052 -2.335 L -.039 -2.259 L .003 -2.855 L -.102 -.483 L .71 .024 L .9 -.086 L .964 .116 L 2.012 .451 L 1.601 .518 L 1.214 .266 L 1.04 .115 L .731 .032 L 1.619 .164 L .888 .232 L .429 .149 L .254 -.034 L -.452 -.601 L -.357 -.2 L -.345 -.15 L -.064 -.419 L 1.344 -.423 L .745 .066 L .578 -.068 L .15 -.102 L 1.736 .148 L .771 -.001 L 1.125 -.373 L .309 -.186 L .442 0 L .656 -.221 L .759 -.069 L .866 -.086 L .734 -.086 L .469 -.239 L .392 -.188 L .771 -.104 L 1.045 -.002 L .872 .123 L -.445 .404 L -.352 .119 L -1.101 .137 L -1.092 .373 L -1.244 .171 L -1.22 .271 L -.699 .522 L -1.767 .255 L -.681 .487 L .846 .266 L 1.441 .748 L -.219 -.55 L .168 -.351 L 1.196 -.253 L .39 -.235 L .726 -.421 L 1.727 -.053 L .96 -.372 L 1.158 -.389 L 2.066 -.173 L .643 -.338 L .921 -.272 L .821 -.189 L .476 -.239 L -.178 -.272 L -.702 -.392 L -.655 -.444 L .899 .101 L .764 .272 L .701 .306 L .412 .324 L .376 .476 L .449 .523 L .393 .235 L 1.246 .486 L .186 .067 L 1.154 .216 L .394 -.018 L .199 -.151 L -.511 -.639 L .07 -.27 L .548 -.035 L .334 -.136 L .627 -.103 L .383 .354 L .059 .421 L -.205 .287 L .833 .133 L .938 -.069 L 1.136 -.457 L .536 -.49 L .479 -.069 L 1.131 .015 L 1.536 .267 L 1.745 .435 L 1.396 .334 L 2.095 .349 L 1.024 .216 L .619 .066 L 1.572 .282 L 1.121 .065 L 1.144 .148 L 1.096 .032 L 1.4 -.086 L .899 .099 L 1.008 .282 L .982 .349 L .434 .249 L .191 .333 L -.524 .134 L -.935 -.032 L -.566 .051 L -.849 .135 L -.354 .714 L 3.323 .358 L 1.726 .079 L 1.749 .014 L .868 -.068 L .738 -.051 L .94 -.167 L .895 -.118 L .938 -.101 L .886 .032 L 1.432 .477 L 1.452 .179 L .42 .115 L 1.225 .443 L -.013 .312 L -.504 .083 L -.35 .247 L .305 .147 L 1.823 .979 L -.162 -.392 L -.024 -.312 L .456 -.05 L .617 -.132 L -.062 -.181 L -.972 -.656 L -.128 -.198 L -.145 -.445 L .121 -.745 L .35 -.034 L 1.944 -.136 L .928 -.151 L .207 -.299 L .459 -.217 L .613 -.035 L 1.098 .281 L 1.528 .279 L .968 .064 L .969 -.102 L .612 .414 L .248 .082 L .962 .213 L 1.211 .13 L .678 .081 L 1.146 -.002 L .879 -.2 L 1.755 -.02 L 1.876 .029 L 1.07 -.052 L 1.18 -.267 L .959 .478 L .95 .296 L .522 -.018 L .243 -.314 L -.017 -.513 L -.666 -.231 L -.732 -.131 L -1.377 -.064 L .089 -.449 L 1.193 -.085 L .575 .065 L .804 .214 L .871 .198 L .858 .048 L .498 .198 L .088 .183 L -.095 .132 L -.287 .86 L .179 .51 L .304 .164 L .177 .065 L .792 .097 L .951 .311 L -.071 -.559 L -.466 -.989 L .137 -.48 L .258 -.266 L .712 .015 L .811 -.035 L 1.229 -.85 L .492 -.051 L .479 -.001 L .517 -.151 L .033 -.133 L -.15 -.367 L -.375 -.35 L -.307 .001 L -.81 .185 L -.988 -.082 L .535 -.52 L .806 -.069 L .435 -.168 L .572 -.001 L .739 .4 L .464 .167 L .065 -.268 L -.081 -.956 L -.744 .069 L -.897 -.032 L -.68 -.116 L -.859 -.318 L -.725 .085 L -1.245 -.183 L -.861 -.234 L -.956 -.218 L -.657 -.338 L -.092 -.136 L -.022 -.324 L .33 -.137 L .842 -.463 L -.486 -.221 L -1.188 -.375 L .09 -.207 L .58 -.604 L .593 -.294 L .387 -.035 L 1.032 .257 L .139 -.035 L .173 -.346 L -.709 -.362 L -.201 -.277 L .23 -.035 L .551 -.331 L .367 -.035 L 1.841 -.021 L .559 .086 L .728 .189 L 1.26 .449 L .432 .328 L .195 .38 L -.246 .603 L 1.261 .53 L .809 .495 L 1.134 .493 L -.377 .341 L -.985 .036 L -.474 .273 L -.416 .557 L .471 .067 L 1.071 .233 L .805 .049 L .387 -.136 L .597 -.001 L 1.477 .351 L -.335 .353 L -.563 .219 L .092 .151 L .796 .467 L .358 .601 L .025 .833 L .303 -.063 L .021 -.004 L .411 -.067 L .608 -.367 L .655 -1.137 L .668 -.42 L .523 .016 L .731 .284 L 1.064 .55 L .473 .383 L .209 .45 L -.159 .433 L -.336 .034 L -.796 -.098 L -.202 .299 L -.043 .415 L .35 .396 L 1.146 .659 L .61 .493 L .463 .279 L .595 -.166 L .896 -.167 L .369 -.132 L .208 -.66 L .764 -.398 L .599 -.416 L .249 -.664 L .363 -.75 L .237 -.184 L 1.394 .081 L .329 -.067 L .134 -.518 L -.985 -.333 L -.918 -.35 L .088 -.891 L .595 -.271 L .787 .032 L .42 -.068 L .571 .016 L 3.459 .616 L 1.325 .669 L .506 -.001 L .553 -.068 L .454 .201 L .244 1.036 L -.474 .268 L -.431 .101 L -.243 -.05 L -.718 -.532 L -.263 0 L -.799 .269 L .123 .316 L .309 .515 L .699 .729 L .855 .528 L 1.108 .576 L .024 .313 L -.478 .642 L -.439 .181 L -1.407 .772 L -.674 .083 L -1.123 .509 L -.763 -.276 L -1.654 -.962 L -.586 -.262 L -.497 -.048 L -.684 .281 L 1.364 .521 L 1.483 .896 L -.708 .067 L -.691 -.081 L -1.288 .084 L -.375 -.129 L -.596 -.62 L -1.147 -.014 L -1.857 .118 L -.253 .229 L .614 .244 L 1.311 .421 L -.159 .195 L -.611 .327 L -2.045 1.106 L -.657 .179 L -.527 .001 L -.859 -.241 L -.816 -.484 L -.225 -.081 L -1.189 -.225 L -.736 -.259 L -.598 -.112 L -.947 .014 L -.289 .004 L -1.214 .174 L 1.503 .278 L 1.136 .21 L 1.751 .774 L 1.629 .433 L 1.233 .126 L 1.02 .031 L -.618 1.091 L -1.237 .705 L -.856 .432 L -.728 .161 L -.829 .049 L -.928 -.126 L -1.062 -.38 L -.048 .351 L -.025 .287 L .321 .572 L -.02 .159 L -.741 .031 L -.058 .002 L -1.365 -.108 L -1.649 -.41 L -.884 -.078 L -2.962 -.322 L 2.146 .864 L 1.576 .156 L 1.367 .267 L .562 .205 L .33 .268 L -.011 .19 L -.642 .333 L -1.106 .207 L -1.429 -.076 L -.511 -.062 L -.367 .269 L 1.254 .423 L -.469 .426 L -1.06 .316 L -1.454 .662 L -.421 .252 L .218 .704 L -.313 .235 L -.909 .205 L -.31 .282 L -.529 .64 L -.276 .296 L -.241 .669 L -.274 .543 L -.323 .666 L .056 .416 L -.161 .554 L .123 .875 L .136 .536 L .598 .366 L .25 .015 L .257 .091 L .664 .014 L 1.164 -.094 L .276 .045 L .367 .29 L .413 .763 L .813 1.157 L .22 .668 L -.132 .91 L .673 .014 L 1.874 -.428 L 1.261 -.033 L .723 .074 L .535 .157 L 1.062 .311 L 2.129 .435 L 1.896 .903 L .993 .933 L 3.5 .67 L .644 .225 L .982 .403 L .986 .253 L .553 .104 L .702 -.091 L .453 .044 L .828 -.077 L 1.245 .163 L 1.407 .207 L .401 .194 L -.297 .702 L -.142 .85 L .154 .283 L .307 .342 L .07 .416 L -.115 1.025 L -.309 .593 L .022 .208 L .604 .266 L .481 .339 L .264 .354 L .046 .488 L -.076 .354 L .97 .116 L .963 .47 L .676 .588 L .392 .588 L .078 .162 L .64 .014 L .726 .41 L .907 .601 L -.349 -.66 L -.22 -.279 L .134 -.338 L .573 -.414 L .365 .176 L .381 .456 L .262 .353 L .165 -.354 L .107 -.545 L -.215 -.456 L .541 -.532 L .139 -.546 L -.183 -.517 L -.337 -.458 L -.261 -.754 L -.004 -.548 L -.205 -.593 L -.218 -.43 L .615 -.016 L -.097 -.476 L -.296 -.252 L -.657 -.163 L -.375 -.282 L -.326 -.923 L 1.252 -.271 L .872 -.241 L .625 -.271 L 1.758 -.949 L .629 -.302 L 1.043 -.935 L .434 -.544 L .237 -.665 L .054 -.529 L -.257 -1.045 L -.246 -.531 L -.239 -.319 L -.938 -.729 L -.467 -.274 L -1.105 -.532 L -.363 -.122 L -.453 -.274 L -.151 -.046 L -.293 -.351 L .08 -.107 L .868 -.522 L .553 -.875 L .293 -.416 L .25 -.092 L .447 -.017 L .295 -.277 L -.106 -.523 L -.18 -.355 L -.316 -.402 L -.048 -.202 L .258 -.357 L .005 -.264 L -1.751 -.105 L 1.084 -.92 L .503 -.704 L .007 -.125 L -.316 -.203 L -.609 -.265 L -.244 -.266 L -.043 -.533 L .305 -.425 L .554 -.315 L .57 -.19 L .827 .062 L 1.781 .374 L 1.097 .234 L .753 .077 L 1.44 .013 L 1.08 -.144 L .86 -.222 L .21 -.047 L .179 -.063 L .589 .078 L .991 .407 L .254 .125 L .754 .454 L .918 .375 L .796 .437 L -.294 .391 L .406 .233 L 1.698 .496 L 1.958 .354 L .725 -.033 L .368 -.203 L .339 .295 L -.013 .404 L -.577 .343 L -.123 .45 L .438 1.327 L .136 .722 L .23 .414 L -.049 .353 L -.248 .169 L -.445 -.014 L -.347 -.015 L -.138 .674 L .375 .274 L 1.137 -.415 L .366 -.047 L .781 -.047 L .286 .015 L .677 .32 L .378 .351 L .004 .259 L -.081 .123 L .277 .32 L .516 -.184 L .306 -.046 L 1.173 -.079 L .636 -.184 L .436 -.383 L .333 -.551 L .326 .015 L .194 .122 L .693 .717 L .042 -.062 L .108 -.764 L .317 -.583 L .475 -.262 L .539 -.385 L -.651 -.505 L .008 -.308 L .272 -.139 L .98 -.094 L .193 -.139 L .512 -.665 L .667 .37 L .607 .599 L .785 .506 L .596 .797 L 1.045 .764 L .264 .352 L -.344 .291 L .095 .335 L .573 -.031 L .365 .777 L .182 .183 L .324 .121 L .743 .136 L .281 .258 L .133 .38 L -.379 .092 L -.416 .168 L .411 .318 L .397 .227 L .77 .196 L .279 .227 L .034 .424 L -.056 .076 L -.409 .106 L -.676 -.029 L -.745 -.12 L -.316 .061 L .091 .166 L .273 .181 L .189 .241 L .333 .513 L .411 .226 L .634 .029 L .462 .18 L .838 .496 L .899 .435 L .246 .33 L -.035 .195 L -.447 .781 L .508 .059 L .663 -.166 L .786 -.077 L .79 .164 L .574 .194 L 1.162 .49 L .981 .132 L 1.517 .295 L -.184 .253 L -.718 .21 L -.736 .21 L -.663 .046 L -.834 .24 L -.583 .402 L -.65 .225 L -1.032 .061 L -.286 .075 L -.324 .268 L .029 .371 L -.271 .535 L 1.175 -.343 L .542 -.09 L .649 -.105 L 1.201 -.774 L 1.251 -.478 L 1.146 -.106 L .662 .237 L .35 .341 L -.398 .446 L .036 .119 L .307 .296 L .616 -.224 L .455 -.164 L .655 .192 L 1.051 .487 L .226 .251 L .022 .178 L -.299 .43 L -.05 .355 L -.406 .444 L 1.001 .929 L -.365 .37 L -.795 .282 L -1.078 .621 L -.662 .281 L -1.097 .046 L -.823 .119 L -1.548 .077 L -.433 .413 L -.916 .795 L -.686 .427 L -.612 .294 L -.938 .222 L -1.494 .172 L -1.845 .127 L -1.452 -.07 L -2.031 -.084 L -.355 .03 L -1.073 .075 L -1.058 -.012 L -1.873 -.099 L -.917 -.027 L -1.758 .106 L -.547 .206 L -.523 .294 L -.537 .585 L -.205 .554 L -.287 .335 L -.591 .19 L -1.07 .104 L -.537 .147 L -1.098 .555 L -.774 .54 L -.794 .612 L -.325 .363 L -.33 .233 L -.868 .843 L -.485 .566 L -.418 .276 L -.46 .58 L -.518 .968 L .749 -.737 L .375 -.131 L .688 -.479 L 1.059 -.944 L 1.097 -.785 L 2.028 -.948 L 1.245 -.395 L 1.797 -.512 L 1.065 -.235 L 1.03 -.235 L 1.473 -.148 L .922 .056 L .895 .289 L .509 .29 L .136 .189 L .144 .464 L -.125 .218 L -.326 .219 L -1.059 .292 L -.753 .452 L -.581 .044 L -.845 -.23 L -.726 .045 L -.645 .19 L .279 .08 L 1.13 .229 L .17 .122 L .256 .444 L .074 .095 L 1.299 -.485 L -.028 .216 L .479 -.148 L .372 .162 L -.36 .229 L -.231 .256 L .112 .27 L -.163 .014 L -.074 .229 L -.91 .444 L 1.216 .013 L .077 .188 L -.187 .282 L .091 .43 L .118 -.081 L .239 .134 L -.063 .134 L .048 .202 L .351 .457 L .009 .147 L .824 .054 L .154 .094 L .04 -.067 L .727 .147 L -.315 .134 L -.373 -.013 L -.047 .134 L .525 .147 L .211 .241 L .569 -.081 L .135 .134 L .212 -.014 L .134 .174 L .418 -.04 L -.075 -.107 L .843 .067 L .241 .107 L -.207 .201 L .242 -.107 L .26 .027 L .245 -.013 L .696 -.362 L .303 -.081 L .104 .362 L .377 .161 L .538 -.121 L .488 .416 L -.405 .254 L .089 .107 L .825 .027 L .164 .174 L -.521 .121 L -.161 -.121 L -.3 .134 L .118 .094 L -.515 0 L -.23 -.04 L .109 .161 L -.45 .04 L .056 .107 L -.443 .014 L -.128 .147 L -.45 .04 L -.368 .253 L -.09 -.106 L -.706 .28 L -.046 .053 L -.529 .133 L -.119 -.267 L -.274 .106 L -.163 .267 L -.188 -.187 L -.068 .253 L -.218 .08 L -.094 .187 L -.513 0 L -.081 -.08 L -.169 -.053 L .032 -.347 L -.242 .36 L -.202 .12 L -.131 -.253 L -.354 .027 L .043 .24 L -.233 .04 L .312 .08 L .033 .213 L -.103 .12 L -.174 -.067 L -.768 .453 L .127 .16 L -.235 .12 L -.194 .053 L .015 .213 L -.161 -.12 L .083 .173 L -.217 .08 L -.14 -.107 L .096 .253 L -.222 .066 L -.146 -.08 L -.148 0 L -.064 .133 L -.156 -.106 L -.243 .227 L -.086 .292 L -.201 -.226 L -.344 .133 L -.154 -.187 L -.349 -.479 L -.138 .24 L -.419 -.866 L .456 -.773 L .284 -.16 L .035 -.12 L -.35 .12 L -.357 .267 L -.076 -.106 L .924 -.507 L .125 .146 L .195 -.093 L -.258 -.107 L 1.103 -.52 L 1.109 -.562 L .658 -.361 L .336 .094 L -.067 .428 L .179 -.054 L .258 .281 L -.044 -.201 L -.017 -.174 L .632 -.214 L .73 -.134 L .192 .067 L .202 -.081 L -.152 -.094 L -.653 -.053 L -.595 .053 L -.42 -.053 L -.804 -.014 L -.306 .027 L -.251 .081 L -.246 .094 L .033 -.214 L 1.128 -.563 L .054 -.201 L .252 -.08 L -.052 -.174 L -.523 .281 L .097 -.134 L -.502 -.51 L .309 .443 L -.36 .482 L -.328 .013 L -1.974 .817 L -.284 .08 L -.362 -.201 L -.227 -.067 L .23 .201 L -.788 .401 L -.219 -.174 L -1.019 -.054 L -.124 .147 L -.38 -.241 L h 186.193 47.833 m -.713 -.032 L -.922 -.181 L -.882 -.065 L -1.25 -.314 L -.973 -.182 L -.604 -.049 L -1.083 -.199 L .43 -.335 L 1.542 -.405 L .385 -.186 L .115 -.673 L .305 -.236 L .831 -.069 L .743 .184 L 1.436 .603 L 1.287 .4 L .074 .285 L .315 .284 L 1.094 .516 L -.288 .117 L -1.263 .486 L -.578 .051 L h 231.09 50.646 m -1.319 -.03 L -.449 -.147 L -.232 -.247 L -.173 -.478 L .3 -.43 L .708 -.664 L .662 -.267 L 1.359 -.168 L .911 .197 L .79 .314 L -.021 .464 L -.039 .727 L -.362 .265 L -1.025 .348 L -1.108 .117 L
444.972 79.145 N .47 -.218 L .307 -.093 L -.294 -.024 L -.419 .061 L -.15 -.135 L -.125 .184 L -.108 -.012 L .066 -.491 L .177 -.218 L .41 .009 L 1.489 .062 L .417 .014 L .339 -.075 L .121 -.253 L -.175 -.288 L .246 -.05 L -.068 -.122 L -.068 -.123 L .353 -.096 L .12 -.034 L .051 .154 L .086 .052 L .24 0 L .223 .12 L .257 .069 L .514 .068 L .086 .103 L .223 -.051 L .445 0 L .257 0 L .223 -.017 L .086 .137 L .103 .103 L .188 .034 L .171 .069 L .018 .137 L .052 .12 L -.224 .12 L -.068 .154 L -.068 .206 L .018 .171 L .034 .137 L .029 .038 L -2.96 .101 L -2.246 -.115 L -.842 -.006 L h 717.633 81.109 m .42 .443 L .429 .62 L .183 .457 L .01 .767 L -.244 .442 L -.197 .78 L -.002 .764 L .29 .777 L .592 .849 L .65 1.446 L .899 1.614 L 1.115 1.679 L -1.26 -.677 L -.832 -.39 L -.99 -.056 L -.268 .088 L -.396 .204 L -.462 1.045 L -.266 1.101 L -.082 .579 L .277 .982 L .183 .216 L .659 .908 L .54 .201 L .463 .648 L -.314 1.246 L -.664 -1.258 L -.866 -.301 L -.224 .029 L -.415 .303 L -.311 .534 L -.643 .907 L -.422 -.5 L -.19 -.929 L .637 -1.146 L -.395 -.884 L .175 -.454 L .502 -.63 L -.131 -.723 L -.196 -.376 L -.27 -.55 L -.062 -.235 L .403 -.302 L .284 -.915 L .075 -.784 L .005 -1.326 L .15 -1.302 L -.09 -.732 L -.213 -.469 L -.83 -.85 L -.1 -.897 L .114 -.192 L .359 -.722 L .065 -.738 L -.336 -.457 L .172 -.237 L .374 -.03 L .62 -.031 L 1.023 -.534 L h 471.158 84.281 m -.002 -.142 L -.165 -.066 L -.082 -.115 L -.164 -.082 L .033 -.099 L -.033 -.23 L -.033 -.164 L .082 -.099 L -.147 -.131 L -.099 -.148 L .132 -.066 L 0 -.165 L -.296 -.164 L -.279 -.263 L -.017 -.164 L .099 -.131 L .131 -.165 L .362 -.017 L .328 .049 L .197 .132 L .51 .016 L .525 -.099 L .444 -.247 L .049 -.065 L .148 -.083 L .296 0 L .065 -.164 L -.033 -.131 L -.279 -.066 L -.296 -.148 L -.099 -.181 L .082 -.017 L .066 -.049 L .032 -.065 L -.263 -.066 L -.361 -.099 L -.378 -.066 L -.361 .066 L -.182 -.066 L .066 -.181 L .099 -.197 L -.066 -.148 L -.164 -.099 L -.279 -.082 L -.23 -.066 L -.443 -.213 L -.115 -.23 L -.164 -.263 L -.214 -.017 L -.017 -.099 L .066 -.131 L .099 -.115 L -.132 -.033 L -.181 .049 L -.082 -.115 L -.132 -.181 L -.345 -.049 L .049 -.147 L .033 -.165 L .099 -.049 L .115 -.082 L 0 -.083 L .114 0 L .066 -.131 L -.05 -.164 L -.147 -.099 L -.197 -.247 L .131 -.165 L .033 -.164 L 0 -.083 L .065 -.115 L -.049 -.115 L -.147 .033 L -.165 -.033 L -.147 -.099 L -.099 -.099 L -.279 -.099 L -.132 -.131 L -.542 -.115 L -.247 .049 L -.099 -.049 L -.131 -.049 L -.23 .083 L -.147 .099 L -.165 0 L -.279 .016 L -.214 .197 L -.197 0 L -.164 -.148 L -.065 -.148 L .017 -.099 L .164 -.099 L 0 -.115 L -.147 -.017 L -.296 -.065 L -.312 -.049 L -.361 .049 L -.214 .065 L -.197 .033 L -.082 -.148 L -.132 -.148 L -.312 -.033 L -.181 -.016 L -.197 .131 L -.229 -.066 L -.165 -.147 L .061 -.042 L .015 -.117 L .044 -.087 L -.088 -.233 L .015 -.189 L -.131 -.117 L .059 -.087 L -.16 -.043 L -.146 -.102 L -.029 -.16 L -.131 -.058 L -.116 -.102 L .043 -.073 L .059 -.087 L -.073 -.044 L -.087 -.014 L -.131 -.073 L -.146 .015 L -.204 .059 L .044 -.102 L .102 -.073 L .073 -.087 L -.029 -.117 L .072 -.131 L -.131 -.087 L .103 -.029 L .087 -.015 L .102 -.073 L .015 -.087 L .029 -.116 L .015 -.087 L -.204 -.058 L -.087 -.073 L -.204 -.087 L -.232 -.073 L 0 -.117 L .015 -.116 L -.37 .004 L -.081 -.106 L .116 -.058 L 461.402 72 l .029 -.117 L .131 0 L .087 -.116 L .059 -.102 L .16 -.058 L .262 -.043 L .175 -.073 L -.059 -.059 L -.175 -.043 L -.043 -.146 L -.015 -.087 L 0 -.073 L -.088 -.073 L -.203 -.087 L -.175 -.233 L 0 -.175 L .175 -.131 L -.029 -.16 L -.073 -.189 L -.131 -.437 L -.029 -.16 L .088 -.16 L .204 -.131 L .319 -.131 L .219 -.204 L .175 -.277 L .058 -.131 L .088 -.043 L .116 0 L .189 0 L .175 -.044 L .043 -.174 L -.16 -.131 L -.145 -.053 L -.089 -.13 L -.17 -.038 L .1 -.253 L .339 -.038 L .153 .165 L .229 .063 L .188 -.088 L -.094 -.139 L .301 -.154 L .485 .199 L .296 -.062 L .312 -.338 L .311 -.185 L .75 .106 L .781 .275 L .439 0 L .363 -.154 L -.386 -.399 L -.59 -.323 L -.393 -.03 L -1.204 .08 L -.616 -.091 L -.271 -.108 L -.299 -.309 L .258 -.434 L -.065 -.201 L -.199 .044 L .174 -.285 L 1.946 -1.145 L 1.983 -1.195 L 1.385 -.758 L .591 -.536 L .43 -.536 L .105 -.409 L -.161 -.346 L -.436 -.392 L -.703 -.265 L -1.357 -.499 L -.439 -.33 L .327 -.191 L .542 -.415 L .057 -.254 L -.151 -.253 L -1.286 -1.395 L -.37 -.509 L .029 -.37 L .187 -.403 L .44 -.535 L .196 -.356 L -.772 -1.195 L -1.402 -1.394 L .328 -.296 L 1.303 -.777 L .421 -.364 L -.543 -.392 L -.964 -.506 L -.872 -.194 L -.563 -.212 L -.116 -.529 L .258 -.465 L .024 -.283 L .689 -.303 L 1.013 -.672 L 1.023 -.49 L .77 -.121 L .824 -.021 L .514 -.204 L .404 -.288 L .617 -.051 L 1.002 -.254 L .643 -.237 L .01 .151 L .255 .386 L .358 .284 L .543 .2 L .919 .082 L .602 .1 L .078 .602 L .695 -.319 L .421 .049 L 1.083 .048 L .875 .015 L .522 .032 L 1.116 -.002 L 1.293 .281 L 2.728 .512 L .984 .364 L 1.595 .86 L .583 .214 L 1.48 .246 L 1.296 .212 L 2.018 .623 L .328 .279 L -.051 .444 L .147 .295 L .426 .294 L .104 .294 L -.24 .344 L -.69 .491 L -1.092 .54 L -.816 .262 L -1.75 .36 L -.907 .083 L -1.631 -.013 L -1.391 -.192 L -2.038 -.175 L -1.63 -.192 L -1.342 -.339 L -2.256 -.485 L -1.114 -.112 L -.476 -.048 L -.621 -.473 L -.371 -.163 L -.771 -.13 L -.943 .117 L .307 .163 L .149 .065 L .73 .538 L .482 .146 L 1.109 .601 L .832 .291 L .921 .161 L .634 .242 L .405 .453 L -.002 .405 L -.276 .291 L -.684 .195 L .086 .113 L .208 .531 L .771 .943 L .093 .494 L .155 .207 L .438 .174 L 1.203 .078 L .872 .125 L .499 .619 L .401 .095 L 1.26 .077 L .575 .126 L .364 .079 L .402 -.128 L .785 -.097 L .243 -.302 L -.001 -.318 L -.387 -.397 L -.471 -.079 L -.455 .096 L -.447 -.031 L -.589 -.206 L -.952 -.795 L .701 -.674 L .484 -.001 L 1.116 .479 L 1.441 .333 L 2.09 .427 L .952 .078 L .834 -.146 L .723 .174 L .261 -.224 L .05 -.415 L -.214 -.239 L -.858 -.656 L -.348 -.628 L .285 -.323 L .19 -.049 L 1.432 -.423 L 1.495 -.359 L .599 -.244 L 1.133 -.717 L .172 -.049 L .462 .064 L 1.829 .29 L 1.41 .533 L .341 -.001 L .052 -.065 L .154 -.503 L .581 -.767 L -.048 -.653 L -.317 -.408 L -.847 -.163 L -.3 -.229 L 1.139 -1.005 L .101 -.247 L -.205 -.594 L -.771 -.512 L .069 -.315 L .353 -.051 L 1.458 .23 L 2.025 -.12 L .631 .132 L .664 .611 L .616 .445 L .433 .461 L -1.045 .051 L -1.559 .085 L -.822 .215 L -.492 .51 L .191 .18 L .952 .293 L .732 .555 L .804 .194 L .723 .097 L 1.268 -.133 L 1.33 -.084 L .301 -.164 L .257 -.491 L .291 -.591 L .284 -.412 L 1.232 -.2 L 1.223 -.414 L .988 -.216 L 1.924 -.483 L 1.429 -.251 L 1.537 -.318 L .921 -.3 L .205 .464 L .278 .083 L .571 -.117 L .487 -.266 L .148 -.465 L .386 -.167 L .718 -.135 L .859 .065 L -.18 .399 L -.058 .597 L -.858 .084 L -.178 .149 L .002 .215 L .687 .197 L .507 -.083 L 1.169 -.167 L .436 -.001 L .161 .198 L .23 .049 L .278 -.133 L .264 -.216 L .29 -.431 L .464 -.183 L .861 -.118 L 1.049 -.068 L .768 .032 L 1.075 .23 L .755 -.018 L .36 -.083 L .963 -.467 L 1 -.285 L .803 -.052 L .952 .182 L .326 .166 L -.631 .45 L .129 .232 L .217 .099 L .632 .131 L .579 -.018 L .288 -.232 L .074 -.398 L .342 -.084 L .962 .065 L .543 -.184 L .395 -.316 L .115 -.417 L -1.37 -1.033 L .405 -.168 L .66 -.37 L .403 -.068 L .609 .016 L 2.171 .063 L 1.272 .199 L 1.241 .149 L 1.135 .199 L 2.111 .515 L 1.071 .098 L 1.712 .414 L 1.02 .248 L 1.305 .53 L 1.455 .611 L .864 .379 L .376 .049 L .229 -.1 L 1.145 -1.047 L .236 -.3 L -.927 .035 L -.4 -.049 L -.564 -.232 L -.365 -.433 L .027 -.652 L -.727 -.283 L -1.987 -.147 L -.19 -.268 L .064 -.168 L .305 -.303 L .693 -.255 L .236 -.153 L .085 -.187 L -.052 -.833 L -.251 -.238 L -1.135 -.066 L -.232 -.29 L .328 -.532 L .359 -.241 L .391 -.035 L 1.482 -.416 L 1.098 -.485 L .521 -.416 L .581 -.608 L .544 -1.22 L .637 -.421 L .374 .069 L 1.562 .155 L 1.613 -.125 L 1.605 -.091 L .695 .069 L 1.066 -.055 L .574 .122 L .309 .279 L -.018 .332 L -.423 .836 L -.348 .348 L -1.334 .833 L -.223 .345 L .752 .342 L .931 .667 L .277 .342 L .21 .818 L -.174 .222 L -.575 .375 L .254 1.179 L -.058 1.305 L .263 .583 L .45 .381 L 1.027 .264 L .19 .166 L -.001 .133 L -.485 .481 L -.417 .826 L -.333 .33 L -.784 .462 L -1.232 .625 L -.63 .198 L -.55 .263 L .321 .522 L -.433 .115 L 558 52.195 l -1.599 -.372 L -.731 -.08 L -.97 .034 L -.601 .115 L .195 .31 L .583 .276 L .738 .21 L 1.569 .208 L 1.133 .079 L .613 -.05 L 1.188 .144 L .922 -.034 L .472 -.358 L .303 -.358 L 1.352 -.328 L 1.166 -.492 L .268 -.278 L .386 -.606 L .818 -.313 L .864 -.626 L .064 -.362 L -.225 -.561 L -.609 -.545 L .244 -.548 L .237 -.1 L .677 -.151 L 1.38 -.152 L 1.757 -.003 L .74 .231 L .842 .463 L .151 .778 L -.34 1.023 L .302 .279 L .92 .212 L 1.298 .047 L .864 -.149 L .129 -.296 L -.514 -.18 L -.797 -.18 L -.571 .034 L -.457 -.098 L .068 -.379 L 1.03 -.382 L .065 -.249 L -.218 -.148 L -.166 -.331 L -.441 -.763 L -.511 -.266 L -.836 -.098 L -1.093 -.231 L -.801 -.116 L -1.288 -.165 L -.91 .186 L -.638 .101 L -1.297 -.181 L -.896 .019 L -.015 -.267 L -.564 -1.071 L .305 -.657 L .736 -.697 L .282 -.46 L -.134 -.221 L -1.092 -1.042 L -.949 -.514 L -.12 -.189 L .833 -.554 L 1.213 -.106 L .998 -.262 L .744 -.348 L .172 -.226 L .169 -.644 L -.13 -.663 L .23 .069 L .64 .051 L .466 .086 L .108 .471 L -.186 .54 L -.636 .608 L -.167 .554 L .14 .448 L .373 .274 L .485 .274 L 1.384 .134 L 1.574 .169 L 1.632 .083 L .819 .409 L .321 .017 L .799 -.036 L -.527 -.89 L -.521 -.274 L -1.893 -.1 L -.931 -.067 L -.576 -.154 L -.609 -.448 L .275 -.329 L 1.374 -.054 L .444 .172 L 1.145 .084 L .747 -.157 L -.09 -.728 L .408 -.088 L .84 -.105 L 1.278 -.02 L 1.067 .207 L 1.413 .379 L 1.088 .535 L 1.326 .343 L .547 .085 L 1.822 .014 L .727 -.174 L .138 .345 L -.781 .38 L -.696 .259 L -.248 .771 L -.129 .972 L .333 .136 L .68 -.785 L .387 -.292 L .285 .051 L .604 .528 L -.088 .749 L .743 -.205 L .681 -.273 L -.044 -.306 L -.191 -.119 L -.147 -.358 L -.748 -.821 L .188 -.223 L .686 -.759 L -.797 -.448 L -.772 -.258 L -.93 -.241 L -.257 -.382 L -.655 -.051 L -.979 -.242 L -1.34 -.207 L -.307 -.296 L .062 -.577 L -.096 -.386 L -.811 -.667 L .081 -.247 L .266 -.16 L .484 -.125 L 2.31 -.11 L 2.54 -.022 L 2.125 -.128 L 1.421 -.162 L .475 .317 L .382 .052 L .844 -.267 L 1.056 -.286 L 1.413 -.109 L .589 .194 L -.957 .338 L -.451 .407 L 1.737 -.233 L .521 -.107 L .955 -.374 L .27 -.284 L -.334 -.444 L -.326 -.177 L -.925 -.266 L -.365 -.303 L -.002 -.232 L .324 -.539 L 1.176 -.397 L .966 -.22 L 3.028 -.903 L .889 -.094 L .248 -.036 L .522 -.076 L 1.899 -.096 L 1.663 -.114 L 2.302 -.244 L 2.048 -.263 L 1.595 -.43 L .855 -.243 L 1.763 .034 L 1.065 -.002 L .383 .185 L -.351 .409 L 1.504 .108 L 1.018 -.039 L 1.261 -.188 L 1.345 -.225 L .95 -.039 L .982 .166 L .687 .073 L .693 -.206 L .12 -.335 L -.133 -.167 L .466 -.337 L .942 -.077 L .939 .036 L 1.243 -.377 L -.618 -.506 L .122 -.34 L 1.165 -.438 L 1.554 -.383 L 2.23 -.406 L 1.229 -.077 L .993 .056 L 1.486 -.003 L .86 .265 L .045 .266 L -1.528 .401 L -.66 .342 L .488 .15 L 1.83 -.117 L 1.588 .148 L 2.039 -.079 L .177 .113 L -.375 .283 L -1.187 .453 L -.296 .3 L 1.971 -.004 L .833 -.02 L .234 .093 L 1.052 -.545 L 1.366 -.002 L 1.771 -.097 L .631 .13 L 1.35 -.021 L 1.954 .165 L 1.4 .259 L 1.181 .427 L .52 .445 L .726 -.001 L .854 -.076 L .422 .5 L -1.354 .832 L .241 .128 L .896 .365 L -2.329 .859 L -1.035 .235 L -1.166 .11 L -3.404 1.061 L -3.018 .965 L -.793 .285 L -2.388 .375 L -2.35 .586 L -2.065 1.126 L .715 .017 L 1.081 -.247 L .922 -.458 L 1.663 -.161 L 1.231 -.02 L 2.101 -.268 L 1.879 -.286 L .879 -.107 L 1.004 -.284 L -.094 -.389 L -.492 -.123 L -.034 -.071 L .281 -.249 L .581 -.214 L .873 .211 L .603 .389 L .621 .052 L .593 .193 L .737 .052 L .853 -.055 L 1.155 -.268 L .499 .07 L .192 .3 L .009 .512 L .522 .404 L 1.422 -.778 L 1.66 -.021 L 1.506 -.145 L 2.354 .014 L 1.919 .155 L .854 .034 L 1.204 .033 L -.271 .74 L .354 .333 L 2.043 .154 L .848 .121 L .698 .069 L 1.035 .103 L 2.49 -.145 L 1.209 -.02 L 1.42 .348 L 1.405 -.932 L -.161 -.352 L -.038 -.229 L -.034 -.105 L 1.806 -.48 L .521 -.019 L .802 .104 L 1.148 .298 L .851 .281 L 1.711 .032 L 1.354 -.073 L 1.384 .033 L 1.323 .431 L .409 .181 L .058 .386 L -.52 .088 L -.268 .036 L -1.905 .406 L -2.438 .737 L -.233 .227 L .253 .069 L 1.033 .067 L .957 .016 L .659 .155 L .659 .293 L 1.014 .396 L .583 .172 L .78 .481 L 1.27 .805 L 1.814 .801 L 1.351 .305 L .612 -.018 L .795 -.394 L .843 -.72 L 1.093 -1.051 L .601 -.329 L .29 .017 L .236 .465 L .772 .308 L 1.346 .29 L 1.105 .135 L .848 -.087 L 1.973 -.468 L .778 -.07 L .813 .067 L 1.196 .239 L 1.921 .734 L .315 -.052 L .186 -.069 L .491 -.258 L .221 -.258 L -.137 -.051 L .013 -.189 L .726 -.312 L .509 -.018 L .5 .257 L .575 .188 L 1.302 .032 L .181 -.5 L -.194 -.466 L .15 -.363 L .093 -.521 L -1.131 .159 L -.643 .001 L -.179 -.104 L .442 -.296 L .318 -.087 L .986 -.089 L 1.021 -.02 L .832 -.141 L 1.566 -.648 L .254 0 L 1.76 .241 L 1.561 .137 L 2.036 .188 L .997 .068 L .654 .103 L 2.307 .065 L -1.732 .628 L .865 .051 L 1.011 -.089 L .335 .138 L -.305 .381 L -.926 .192 L -.846 .261 L -.177 .293 L .664 .033 L .52 -.122 L .916 -.14 L .978 -.33 L 1.62 -.799 L 2.766 .012 L 1.196 .067 L .903 .172 L .946 .137 L .205 .19 L .221 .104 L -2.247 .59 L .559 .137 L 1.674 .289 L 2.174 .202 L .946 .204 L .801 .375 L .367 .427 L .564 .357 L .522 .152 L 1.459 -.037 L 1.364 -.105 L 1.138 -.139 L 2.518 -.329 L 2.208 -.107 L 3.008 .131 L 1.515 .134 L .734 .118 L 1.168 .424 L .655 .169 L .525 .338 L .361 .39 L -.123 .491 L -.286 .521 L .509 .25 L .764 .065 L .835 .015 L .643 .083 L -.017 .685 L .419 .416 L .686 -.168 L .545 -.435 L 1.211 -.387 L .348 -.067 L .35 .049 L 1.696 -.02 L 1.521 -.288 L .736 .032 L .588 .434 L .707 .116 L 1.541 .014 L 2.176 .062 L .869 -.118 L 1.378 -.504 L .406 .2 L .93 .533 L .396 .216 L 1.095 .265 L .875 .332 L .282 .398 L .612 .148 L 1.556 -.136 L 1.653 -.319 L .16 -.25 L -.248 -.333 L -.805 -.833 L -.833 -.115 L .4 -.336 L .479 -.571 L 1.89 .098 L 1.214 .082 L 1.135 .065 L 1.221 .166 L .222 .318 L 1.396 -.153 L 2.084 -.054 L 2.304 .013 L 1.292 .148 L .786 .199 L 1.185 .199 L 1.391 .098 L .751 .182 L 1.302 .332 L .747 .065 L .703 .182 L 1.145 .505 L 0 2.126 L 0 2.222 L 0 2.222 L 0 1.292 L 0 .157 L 0 .576 L 0 .219 L -1.083 .371 L -.651 .03 L -.645 .37 L -.56 .065 L -1.044 .065 L -.355 -.079 L -.928 -.052 L -.118 -.343 L -.271 -.211 L -.501 .027 L .241 -.185 L -.938 .324 L -.846 .02 L -.337 -.211 L -.478 -.079 L .424 .501 L -.569 .29 L .32 .103 L .942 .205 L .634 -.36 L .395 .041 L .335 .079 L 0 .477 L .248 .206 L .76 .269 L 1.059 -.228 L -.439 .322 L .741 -.243 L .065 .336 L .247 .206 L .187 .363 L .068 .189 L -.722 .522 L .593 -.064 L .349 .172 L .473 .503 L .501 .157 L .145 .251 L -.162 .456 L .792 -.111 L -.125 .393 L .023 .25 L -.43 .299 L -.691 .205 L -.635 -.046 L -.448 -.14 L -1.243 -.154 L -.889 -.077 L -.347 -.14 L .123 -.267 L -.493 -.046 L -.304 .032 L -.559 .55 L -.069 .11 L -3.06 .913 L -1.155 .174 L -.245 0 L -.43 .203 L -.219 .188 L -.719 .22 L -.991 .033 L -.308 .11 L -.48 .405 L -.462 .203 L -.946 .033 L -.854 .622 L -.24 .279 L -1.67 .452 L -.392 .449 L -1.229 .25 L -.406 .14 L -.151 .293 L .01 .292 L -.473 .292 L -.406 .016 L -.586 -.306 L -.183 -.262 L -.169 -.37 L -.67 -.308 L -1.074 -.044 L -1.021 .048 L -1.159 .172 L -1.301 .188 L -.523 .217 L -1.333 .756 L -.536 .277 L -.184 -.138 L .575 -1.293 L -.55 .094 L -.392 -.097 L -.811 .531 L -.67 .186 L -.401 .155 L -.114 .506 L -.66 .154 L -.317 -.168 L -.253 -.49 L -.483 -.261 L -1.024 .636 L .261 -.204 L -.557 .062 L -.283 .092 L -.628 .522 L -.141 .261 L .126 .229 L .344 .152 L -.932 .521 L -.182 .199 L .342 .167 L -.647 .352 L -.88 .55 L -.626 .503 L -.298 .35 L -.01 .531 L .421 .317 L .477 .09 L 1.382 -.048 L .562 .166 L .11 .167 L -.436 .394 L -.752 .455 L -.181 .302 L .224 .512 L .292 .452 L .786 .089 L .165 .391 L -.014 .616 L -.349 .361 L -.528 .061 L -.481 -.209 L -.017 -.21 L .388 -.527 L -.444 -.014 L -.454 .242 L -1.014 .843 L -.56 .675 L -.237 .599 L .321 .672 L .647 .311 L .154 .237 L -.294 .387 L -.688 .313 L -.956 .031 L -.664 -.088 L -.344 .001 L -.619 .179 L -.837 .476 L -.214 .149 L -.525 .504 L -.137 .341 L .111 .281 L .492 .398 L .038 .221 L -.056 .133 L -.679 .238 L -.604 .016 L 753.44 82.4 l -.727 .296 L -.065 .251 L .067 .28 L -.161 .854 L -.293 .412 L -.8 .78 L -1.53 .971 L -.854 .5 L -.285 .103 L -.295 -.614 L -.198 -.821 L -.25 -.69 L -.064 -.794 L -.351 -.75 L -.305 -.383 L -.214 -.915 L -.514 -1.36 L -.008 -.578 L -.154 -.563 L -.017 -.327 L -.105 -.193 L -.262 -.817 L -.026 -.792 L .116 -.808 L .271 -1.396 L .167 -.226 L 1.185 -.86 L .716 -.424 L .57 -.695 L .14 -.227 L -.085 -.318 L -.139 -.166 L 1.632 -.367 L 1.001 -.305 L .811 -.32 L 1.729 -.884 L .641 -.412 L .431 -.428 L .14 -.335 L 1.784 -.889 L .872 -.445 L 1.535 -.861 L .368 -.293 L .26 -.433 L 1.252 -.435 L 2.106 -.514 L .257 -.434 L .773 -.528 L .086 -.233 L -.568 -.216 L .814 -.904 L -.036 -.483 L .183 -.391 L .598 -.204 L 1.729 -.082 L .513 -.063 L -.485 -.328 L -2.065 -.215 L -.71 .095 L -1.062 .174 L -.777 .189 L .042 .328 L -.664 .923 L .125 .202 L -.04 .14 L -.662 .11 L -.479 .11 L -1.555 .718 L -1.979 1.042 L -1.169 .342 L -.249 -.062 L .156 -.325 L .352 -.465 L -.933 -.076 L -.16 -.263 L .252 -.451 L .442 -.467 L .207 -.328 L -.069 -.202 L -.339 -.031 L -1.136 .454 L -.496 .032 L -.277 -.358 L -.589 -.17 L -1.606 .144 L -1.312 .111 L -.956 .08 L -.606 .157 L -.894 .359 L -.093 .436 L .082 .186 L -1.262 .53 L -.408 .233 L .149 .495 L -1.294 .357 L -1.019 .434 L -.84 .479 L -.496 .461 L -.332 .46 L .004 .383 L .527 .213 L 1.269 .043 L .278 .275 L .062 .122 L -1.152 .139 L -1.028 .262 L -1.045 -.059 L -.698 -.136 L -.382 .031 L -.311 .107 L -.721 .398 L -.695 -.35 L -1.112 .383 L -.747 .139 L -.487 -.09 L -.284 -.137 L .108 -.29 L .748 -.124 L .868 -.124 L .164 -.046 L -.741 -.64 L 736.444 68 l -1.06 .017 L -.854 .155 L -.353 -.061 L -.868 -.458 L -.775 -.029 L -.745 .047 L -.704 .246 L .042 .398 L -.26 .229 L -.477 .215 L -.695 -.243 L -.408 -.122 L -1.26 .063 L -.784 .093 L -.651 -.075 L -.887 -.136 L -.563 .078 L -.067 .122 L -.147 .474 L -.677 .017 L -.311 -.137 L -.038 -.382 L -.203 -.259 L -1.241 .094 L -1.014 -.059 L -1.257 .033 L -1.158 .063 L -.836 -.029 L -.18 .016 L -1.085 .292 L -.964 .444 L -.74 .474 L -.536 .504 L -.789 .245 L -.904 .336 L -.194 .152 L -1.047 1.17 L -1.634 .684 L -.949 .471 L -1.157 .711 L -1.653 1.253 L -.828 .572 L -1.573 .873 L -.893 .376 L -1.889 .871 L -.632 .388 L -.203 .298 L .018 .357 L .428 .281 L .485 .043 L .918 .013 L 1.046 -.15 L .656 .043 L -.329 1.261 L .016 .415 L .303 .103 L .63 -.09 L .601 -.371 L .761 .117 L -.127 .148 L 705.293 81 l -.112 .222 L .373 .073 L 1.645 -.018 L .566 -.238 L .39 -.519 L .017 -.638 L .763 .014 L .647 -.001 L .726 .014 L .951 .265 L .658 .354 L .486 .591 L .847 .575 L .426 .176 L .506 .324 L -.07 .148 L -.581 .355 L .453 .221 L .13 .309 L -.336 .723 L .491 .117 L .215 .235 L -.291 .515 L -.348 .397 L -.532 .559 L -.724 1.364 L -.181 .688 L .057 .219 L .24 .701 L -.188 .917 L -.098 .741 L -.403 1.408 L -.146 .493 L -1.928 1.538 L -.371 .435 L -.217 .65 L -.587 .42 L -.741 .579 L -.241 .361 L -.574 .981 L -.587 .606 L -.941 .778 L -1.784 1.512 L -.464 .474 L -.235 .458 L -.323 .33 L -.758 .388 L -.618 .416 L -.574 .702 L -.431 .458 L -.875 .673 L -.955 .487 L -1.838 .475 L -.798 .244 L -.278 -.427 L -.519 -.085 L -.243 .043 L -.337 -.185 L -.337 -.513 L -.663 .272 L -.464 .101 L .424 -.586 L -.624 .173 L -.506 .486 L -.649 .543 L -1.326 1.001 L -.072 .049 L -.167 -.393 L -.298 -.439 L .111 -.058 L 1.252 -.462 L .511 -.43 L .156 -.329 L -.112 -.299 L .097 -.128 L .025 -.385 L .006 -.613 L -.062 -.656 L -.332 -.897 L .048 -.557 L 1.664 -.982 L .396 .041 L .685 .24 L .679 .225 L .547 .098 L .47 -.347 L .551 -.69 L .329 -.432 L .627 -1.08 L .538 -1.066 L .278 -.893 L .291 -.707 L .66 -.393 L .566 -.407 L -.017 -.504 L -.116 -.389 L -.064 -.259 L -.246 -.114 L -.902 .034 L -1.181 .208 L -1.357 .31 L -.953 .308 L -.604 .22 L -1.657 .052 L -.649 .018 L -.68 .033 L -.261 -.446 L -.44 -1.283 L -.297 -.866 L -.205 -.144 L -2.659 -.839 L -1.523 -.253 L -1.247 -.341 L -.507 -.2 L -.436 -.389 L -.927 -1.903 L -.94 -1.588 L -1.087 -2.384 L -.742 -.952 L -.763 -.467 L -.539 -.026 L -1.386 .125 L -.683 -.188 L -1.037 -.481 L -1.148 -.215 L -.917 .049 L -1.203 .109 L -.836 .123 L -1.854 .143 L -.602 .136 L -.478 .165 L -1.193 .787 L -.375 .282 L -.119 .25 L .822 -.078 L .558 .026 L .465 .306 L .107 .249 L -.167 .794 L -1.371 .608 L -.599 .545 L -.667 .779 L -.416 .543 L -.422 .426 L -.103 .249 L .062 .146 L .35 .348 L .056 .306 L -.123 .233 L -.779 .339 L -2.44 .752 L -.438 .089 L -.343 .016 L -1.126 -.574 L -.452 -.172 L -.046 -.018 L -.431 -.168 L -.622 .018 L -1.228 .297 L -.86 -.169 L -.34 -.129 L -.751 -.506 L -.74 -.156 L -.609 .047 L -.333 .002 L -1.165 .487 L -.755 .498 L -.447 .394 L -.604 .264 L -.526 .163 L -1.147 .136 L -.867 .106 L -.532 .075 L -1.018 .063 L -1.602 .11 L -.739 -.039 L -.984 -.082 L -.905 -.241 L -1.318 -.254 L -.812 -.373 L -1.132 -.313 L -.623 -.331 L -1.333 -.75 L -.769 -.229 L -1.423 -.022 L -1.172 -.037 L -.796 .077 L -2.48 .538 L -.673 -.113 L -1.643 -.531 L -.421 -.333 L -.408 -.451 L -.182 -.481 L -.004 -.541 L -.145 -.204 L -.767 -.143 L -.989 -.317 L -.702 -.231 L -1.748 -.328 L -1.036 -.185 L -1.028 -.098 L -.84 -.201 L -1.269 .96 L -.905 .839 L -.098 .293 L .409 .86 L .396 .304 L .116 .204 L -.163 .526 L -.744 .572 L -.31 .162 L -.755 .28 L -.562 .018 L -.576 -.186 L -.312 -.114 L -.875 -.068 L -.85 .004 L -.719 -.083 L -1.458 .008 L -.699 -.113 L -.393 -.406 L -.694 -.755 L -.831 -.083 L -1.842 -.122 L -.932 -.156 L -.953 -.097 L -.84 .18 L -1.512 .476 L -1.143 .341 L -.787 .398 L -.971 .692 L -.017 .012 L -.727 .381 L -.603 .148 L -1.387 .08 L -.599 .207 L -.799 .425 L -.154 .044 L -.244 .074 L -.569 .003 L -.228 .014 L -.064 -.145 L -.589 0 L -.294 -.478 L -.441 -.331 L .073 -.331 L -.625 .184 L -.478 .368 L -.993 -.074 L -.882 -.073 L -.662 -.699 L -.588 -.552 L -.956 -.147 L -.331 -.625 L -.772 -.588 L -.698 -.441 L -.993 .037 L -.771 .221 L -.993 .221 L -.992 0 L -.589 0 L -.184 -.184 L -.258 -.257 L -.478 0 L 0 -.368 L -.367 -.331 L -.92 0 L -.367 .515 L -.331 .257 L -.515 .257 L -1.104 -1.434 L -.846 -.882 L -1.69 -2.133 L -1.066 -1.029 L -1.287 -.772 L -.809 -.294 L -1.104 -.588 L .11 -.368 L .515 -.11 L 0 -.441 L -.809 .074 L -.515 .22 L -.772 .221 L -.956 .515 L -1.103 .257 L -.772 .441 L -.294 .294 L -.552 -.184 L -.441 -.037 L -.771 .073 L -.441 .11 L -.331 -.184 L .331 -.441 L .441 -.184 L .146 -.294 L -.367 0 L -.441 .221 L -.478 -.11 L -.405 -.294 L -.478 -.037 L -.184 .147 L -.147 .147 L -.367 -.221 L -.295 -.368 L -.294 -.11 L -.331 .221 L -.367 -.074 L -.368 .147 L -.44 -.11 L -.295 .147 L -.478 -.074 L -.184 -.257 L .33 -.037 L -.073 -.331 L .147 -.257 L .11 -.331 L -.515 -.22 L -.147 -.221 L .037 -.331 L -.368 -.404 L -.882 .037 L -.625 .11 L -.772 -.257 L -.515 -.11 L -.919 -.147 L -.735 .037 L -.11 .221 L -.589 .184 L -.515 .037 L 0 .294 L -.367 .368 L -.625 .074 L -1.876 .073 L -2.021 .405 L -1.177 .037 L -.625 .331 L -.221 .331 L -.331 -.073 L -.588 .073 L -1.545 .11 L -.735 .11 L -1.029 .037 L -1.396 .405 L -.368 .184 L -.772 0 L -.515 0 L 537.304 80 l -.33 .074 L -.185 .515 L .074 .441 L .294 .221 L -.294 .074 L 0 .331 L 1.065 .11 L .956 .294 L -.11 .257 L -.515 .073 L -1.103 -.147 L -.698 .184 L -.662 .515 L .146 .257 L .441 .478 L -.331 .294 L -.588 .147 L -.735 .368 L -.467 .067 L .164 .274 L .239 0 L .377 .137 L -.068 .171 L .377 .137 L .651 .069 L .274 .308 L 1.165 .171 L .24 .24 L -.138 .686 L -.137 .309 L -1.577 .411 L -.959 -.034 L -.343 -.343 L -.24 0 L -.171 .309 L -.651 .343 L -.411 -.171 L -.754 -.137 L -.926 -.309 L -.274 -.548 L -.754 -.103 L -1.062 .103 L -.137 .412 L -.617 .068 L -.651 -.411 L -.65 -.035 L -.823 -.068 L -.514 .377 L -.377 .343 L -.274 .274 L -.686 .171 L -.411 -.24 L -.686 -.137 L -.582 -.548 L -.72 -.068 L .034 .24 L .205 .48 L -.239 .274 L -.274 -.137 L -.068 -.583 L -.411 -.274 L -.789 -.343 L -.582 -.206 L 0 -.343 L -.96 -.171 L -.617 .069 L -.788 -.035 L -.411 -.514 L -.411 -.069 L -.617 .24 L -.273 .137 L -.651 .137 L -.309 -.274 L -.479 0 L -.651 -.069 L -.515 .309 L -.548 .343 L -.788 .377 L -.549 .068 L -.514 .171 L -.309 .309 L -.172 .24 L 509.58 87.5 l -.479 .206 L .068 .445 L .171 .411 L -.068 .446 L -.411 .24 L -.651 0 L -.514 -.411 L -.48 -.548 L -.514 -.24 L -.411 .069 L -.103 .308 L -.343 .549 L -.823 .137 L -.205 1.303 L .343 .171 L .239 .274 L -.239 .206 L -.446 .274 L -.65 1.165 L 1.37 .343 L .138 .377 L -.068 .309 L .514 .514 L .103 -.343 L .583 .206 L .343 -.034 L .514 .034 L .515 .445 L .479 .206 L .343 .514 L .96 1.131 L -.138 .103 L -.445 -.103 L -.309 -.103 L -.343 .103 L .068 .308 L .857 .377 L .616 .19 L -.167 .2 L -.399 .28 L -.38 .12 L -.12 0 L 0 .14 L 0 .22 L -.14 .08 L -.3 -.2 L -.34 .2 L -.399 .26 L -.64 .12 L -.319 .08 L -.26 -.08 L -.181 -.08 L -.1 .04 L -.06 .16 L .12 .26 L -.221 .2 L -.18 .3 L -.18 .319 L -.319 .42 L -.18 .28 L -.32 .16 L -.34 .24 L -.14 .32 L .08 .2 L .34 .2 L .319 .04 L .18 .3 L .24 .04 L .239 .34 L .28 .419 L -.06 .38 L -.101 .2 L .061 .16 L .1 -.2 L .1 -.34 L .12 -.22 L .16 -.02 L -.141 .439 L -.22 .36 L .061 .4 L .12 .1 L -.16 .2 L -.04 .4 L .38 .24 L .119 .1 L .12 .52 L .28 .06 L .359 .42 L .2 .28 L .439 .419 L .18 .36 L .359 .06 L .047 .146 L -.292 .449 L -.496 .284 L -.283 .094 L -.308 .331 L -.165 .213 L -.379 .047 L -.449 -.142 L -.591 -.094 L 0 -.308 L -.283 -.284 L -.118 0 L -.095 -.118 L -.473 -.284 L -.142 -.189 L 504.5 H -.213 .047 L 504.264 107 l -.229 .023 L -.126 -.189 L -.236 -.071 L -.236 .023 L -.284 -.047 L -.26 -.094 L -.284 -.166 L -.354 -.284 L .118 -.307 L .118 -.189 L -.118 -.142 L -.354 -.024 L -.378 0 L -.213 -.166 L -.189 -.118 L -.212 0 L -.143 -.094 L -.236 -.118 L -.118 0 L -.095 .071 L -.142 .166 L -.188 -.142 L -.261 -.071 L -.354 0 L -.213 .071 L -.094 .095 L -.166 .166 L -.283 0 L -.261 .118 L -.212 -.071 L -.261 -.118 L .048 -.118 L .142 -.118 L -.308 -.119 L -.236 -.118 L -.354 -.071 L -.52 -.118 L -.284 -.213 L -.095 -.142 L -.354 -.166 L -.283 .047 L -.189 0 L -.401 -.166 L -.544 0 L -.426 .095 L -.307 0 L -.355 -.047 L -.307 -.071 L -.261 -.095 L -.212 -.166 L -.213 0 L -.331 0 L -.189 -.047 L -.188 -.094 L -.284 -.142 L -.283 -.095 L -.449 -.023 L -.402 -.023 L -.07 -.047 L -.284 -.047 L -.26 .166 L -.112 .309 L -1.421 -1.012 L -1.188 -.842 L -.817 -.385 L -.62 -.084 L -.373 -.157 L -.509 -.5 L -.236 -.057 L -.338 .159 L -.329 -.042 L -.347 -.515 L -.795 -.674 L .595 -.188 L .519 -.001 L .445 -.073 L .1 -.519 L .359 -.476 L 485 97.85 l .526 -.03 L .516 -.131 L -.432 -.532 L -.654 -.273 L -.474 -.36 L .243 -.116 L .367 -.03 L .82 -.117 L .715 -.348 L 1.244 -.436 L -.196 -.375 L -.076 -.058 L -.799 .088 L -1.312 .175 L .012 -.126 L .021 -.112 L 0 -.224 L .09 -.514 L .224 -.089 L .357 -.022 L .38 -.134 L .223 -.179 L .022 -.179 L .269 0 L .736 -.045 L .805 .157 L .335 -.134 L 0 -.156 L .156 -.291 L .156 -.491 L -.066 -.067 L -.09 -.201 L -.045 -.179 L -.044 -.134 L -.179 -.067 L -.156 -.067 L .044 -.224 L .045 -.179 L .246 0 L .312 0 L .134 -.156 L -.29 -.044 L -.269 -.089 L -.223 -.246 L .312 -.044 L .357 -.201 L .156 -.067 L .201 -.089 L .045 -.224 L -.09 -.179 L -.111 -.089 L .022 -.179 L .089 -.111 L -.156 -.089 L -.201 .089 L -.134 .044 L -.269 0 L -.357 -.156 L -.111 -.224 L -.469 -.022 L -.291 -.089 L -.201 -.179 L -.357 .067 L -.268 -.112 L -.469 -.112 L -.425 -.067 L -.29 -.268 L -.224 .067 L -.045 .157 L -.29 .134 L -.224 -.112 L -.179 -.179 L -.402 -.044 L -.022 -.134 L -.201 -.179 L 0 -.134 L -.268 -.179 L -.111 -.156 L -.357 .067 L -.536 .134 L -.269 0 L -.312 .112 L -.425 .112 L -.179 -.156 L -.179 -.022 L -.201 .067 L -.469 -.291 L -.268 -.067 L -.47 .067 L -.268 .179 L -.291 -.29 L -.179 -.089 L -.089 -.224 L .089 -.179 L -.089 -.246 L -.224 -.268 L 0 -.357 L -.402 0 L 0 -.312 L -.38 -.022 L -.514 .067 L -.156 -.112 L -.647 0 L -.269 -.29 L -.111 -.357 L -.134 -.291 L .312 -.134 L .312 .022 L 0 -.268 L -.312 -.156 L -.246 -.156 L -.134 -.201 L -.246 -.335 L -.312 -.134 L -.201 -.268 L -.514 .134 L -.692 -.112 L -.67 .223 L -.536 .022 L -.536 -.246 L -.134 .268 L -.179 .291 L -.313 .156 L -.469 -.022 L -.357 -.089 L h 527.156 37.071 m -.59 -.14 L -.955 -.21 L -1.128 -.139 L -.739 .054 L -.959 .037 L -.732 .143 L -.411 -.105 L -1.025 -.476 L .737 -.303 L 1.21 -.429 L .654 -.09 L 1.549 -.002 L .135 -.357 L -.728 -.338 L .351 -.269 L .419 -.144 L .676 -.02 L .852 -.181 L -.25 -.161 L -.526 -.233 L 1.539 -.895 L .513 -.129 L .226 .073 L .892 .017 L .981 -.535 L .863 -.333 L 1.02 -.261 L .975 -.15 L 1.305 -.113 L 1.274 .053 L .738 -.15 L .786 -.615 L .273 .018 L .873 -.132 L 1.722 .276 L .471 -.038 L 1.93 -.321 L .958 -.039 L 2.184 -.247 L 1.864 -.116 L .771 -.564 L .376 -.152 L 2.511 -.137 L 1.965 -.079 L .471 .131 L .442 .225 L .154 .357 L -.812 .47 L -.541 .169 L -1.346 .319 L -2.609 .433 L -4.329 .49 L -2.187 .281 L -2.122 .299 L -1.842 .316 L -2.102 .242 L -.941 .203 L -.288 .274 L .644 .216 L -.422 .217 L -.943 .361 L -.527 .037 L -2.047 -.068 L -.432 .18 L -.119 .233 L .621 .249 L -.331 .233 L -1.206 .448 L -.402 -.142 L -.752 -.087 L -.592 .304 L .877 .283 L .052 .319 L -1.094 .657 L -.822 .284 L h 517.491 38.443 m 1.041 -.37 L .512 -.299 L .428 -.212 L 1.426 -.021 L 1.316 -.249 L .987 -.02 L 1.412 -.091 L .551 .069 L .988 .227 L -.063 .176 L -.463 .528 L -.302 .158 L -.697 .071 L -.443 .228 L -.233 .385 L .006 .818 L .445 1.039 L .957 .826 L .505 .308 L .775 .307 L 1.162 .392 L -.028 .282 L -2.62 -.089 L -.844 .053 L -.917 .326 L -.596 .086 L -.676 -.494 L -.382 -.034 L -1.091 .088 L -.673 -.102 L -.031 -.359 L 1.347 -.362 L .073 -.24 L -.102 -.017 L -.944 -.273 L -1.442 -.411 L -1.519 -.17 L -.33 .156 L -.624 .122 L -.681 -.033 L -.625 -.396 L -.114 -.415 L .229 -.312 L .39 -.209 L .344 -.036 L .318 .104 L .65 .016 L .518 -.192 L 1.121 -.768 L .243 -.35 L -.322 0 L -.981 -.243 L h .125 56.089 m 0 -.562 L 0 -.576 L 0 -.157 L 0 -1.292 L 51.28 V 0 -2.222 L 0 -2.12 L 2.917 .61 L 1.693 .598 L .933 .181 L 3.819 .99 L 1.059 .395 L .204 .149 L .074 .214 L .445 .429 L .406 .789 L -.209 .428 L 1.034 .8 L .982 .26 L -.02 -.18 L .297 -.148 L -.051 -.196 L -.638 -.392 L .016 -.542 L .077 -.296 L 1.026 -.183 L .984 .278 L .573 .098 L .767 .064 L 1.003 -.117 L .933 .13 L .93 .425 L .694 .359 L 1.676 .684 L .32 .081 L .584 .179 L .43 .211 L .09 .13 L -.343 .033 L -1.026 -.096 L -.364 .034 L -.808 .798 L -1.539 -.468 L .138 .178 L .438 .227 L .465 .324 L -1.177 -.111 L -1.008 .05 L -1.202 -.387 L -.708 -.096 L .135 .129 L .289 .259 L .084 0 L .561 .259 L .205 .307 L .131 .453 L -.056 .339 L -.814 .05 L -.805 .065 L -.189 .161 L .5 .865 L -.115 .272 L -1.04 -.078 L -.397 .081 L -1.193 -.174 L -.264 -.352 L -1.795 -.51 L -.253 .273 L 9.85 55.79 l -.276 -.161 L -.265 -.403 L .174 -.178 L -.321 -.42 L -.87 -.339 L -.565 -.063 L -.762 .034 L -.858 .229 L -1.343 .084 L 3.57 54.443 l .059 -.325 L -.155 -.325 L -.618 -.487 L 1.958 53.43 l -.45 .409 L -.655 1.228 L -.166 .715 L -.562 .307 L
449.401 22.792 N -1.596 -.014 L -2.019 -.016 L -1.739 .063 L -.764 .061 L -1.972 -.316 L .812 -.456 L .826 -.172 L .735 -.453 L 1.148 -.588 L 1.354 .691 L .998 .105 L 1.116 -.088 L .9 .084 L .704 .341 L .865 -.323 L .53 -.454 L .868 -.306 L -.311 .823 L .086 .32 L .851 -.001 L .991 -.495 L 1.061 -.261 L .803 .128 L .559 .472 L .705 .041 L 2.007 -.111 L 1.543 .189 L .551 .376 L -.507 .201 L -2.004 .622 L -1.623 .38 L -1.069 .062 L -.976 .14 L -1.324 .366 L -6.271 -.097 L -.033 -.377 L 1.492 -.26 L .702 -.677 L h 430.027 22.752 m .068 .697 L .252 .119 L 1.694 .155 L .221 -.377 L .13 -.418 L .573 -.141 L .523 -.041 L .949 .477 L 1.192 .771 L .798 .235 L .568 -.218 L -.222 -.296 L -.46 -.356 L -.327 -.477 L -.04 -.22 L .91 -.407 L 1.001 .103 L .485 .18 L 1.278 .018 L .586 .179 L -.08 .419 L -.169 .298 L .104 .159 L .549 .118 L .743 -.338 L .44 -.1 L .662 .396 L .678 .335 L .785 .156 L .948 .117 L 1.672 .429 L .498 .234 L -1.305 .277 L -1.981 .218 L -.696 .293 L -.731 1.144 L -.885 .885 L -1.243 .117 L -.766 .535 L -.455 .589 L -.029 .378 L -.786 .209 L -.556 -.018 L -1.593 -.355 L -1.883 -.507 L -1.365 -.568 L .651 -.364 L 1.565 -.041 L 1.788 -.137 L .944 -.386 L -.652 -.249 L -1.822 .139 L -1.566 .118 L -1.694 .042 L -.502 -.519 L .959 -.06 L 1.371 -.215 L 2.149 -.314 L 1.547 -.45 L -2.525 -.405 L -.881 -.292 L -.589 .138 L -1.036 .646 L -1.069 .293 L -.562 .059 L -1.236 -.172 L -.338 -.174 L -1.05 -.368 L -.807 -.233 L -.698 -.41 L 1.698 -.396 L -.817 -.571 L -1.359 .319 L -.467 -.078 L -.924 -.751 L .812 -.36 L .516 -.021 L 1.075 -.122 L 1.017 .038 L .577 -.061 L 1.188 -.042 L h 425.42 68.82 m -.148 -.21 L -.629 .132 L -.134 -.026 L -.249 -.237 L -.239 -.343 L .188 -.158 L -.143 -.291 L -.361 .185 L -.062 .29 L .113 .237 L -.147 .105 L -.339 .316 L -.086 .185 L -.521 .105 L -.533 -.131 L -.781 .342 L .057 .131 L -.502 .289 L -.498 .263 L -1.658 .813 L 418.697 71 l -.274 .052 L -.271 0 L -2.111 .209 L -.188 -.236 L -.33 -.131 L -.183 .209 L 414.976 71 l .384 -.184 L -.935 -.236 L -.794 -.341 L -.574 -.052 L -.479 -.578 L .292 -.368 L -.126 -.21 L .34 .026 L .085 .316 L .284 -.21 L .667 .263 L -.244 -.197 L .127 -.145 L .5 -.092 L -.479 .026 L -.245 .105 L -.263 -.184 L -.111 -.132 L .579 -.276 L .455 -.185 L -.482 .066 L -.317 -.132 L .441 -.237 L .083 -.237 L -.661 .475 L -.036 -.264 L -.265 -.171 L .005 .211 L .076 .171 L -.419 .158 L -.41 0 L .014 -.277 L -.15 .264 L -.235 -.079 L -.2 -.448 L .658 -.449 L .08 .436 L .068 -.317 L .438 .158 L .211 -.092 L -.166 -.106 L .674 -.079 L .479 -.251 L -.611 .159 L -.48 0 L -.335 -.159 L .196 -.132 L .387 -.146 L .196 -.471 L -.821 -.014 L -.546 .094 L -.406 -.309 L .368 -.14 L .643 -.404 L -.212 -.186 L -.445 .063 L -.399 -.062 L -.211 -.217 L .284 -.482 L .619 -.265 L -.595 -.248 L -.225 -.374 L .272 -.188 L -.089 -.687 L .106 -.094 L .594 -.063 L .392 -.045 L .455 .044 L .082 -.11 L -.255 -.134 L -.425 -.118 L -.228 -.17 L .098 -.188 L .211 -.125 L .575 -.064 L .511 -.346 L .567 .109 L .498 -.111 L .179 -.55 L .835 .093 L .668 .125 L .571 -.252 L -.989 -.234 L -.266 -.314 L .236 -.143 L 1.151 .014 L .851 -.08 L .538 .219 L .06 -.473 L .477 -.27 L .297 -.333 L .78 -.175 L .438 .189 L .138 .079 L .5 -.476 L .869 -.413 L .084 -.429 L .437 -.398 L 1.497 -.735 L .335 -.192 L .235 -.048 L .481 .175 L .335 -.001 L .319 -.224 L -.225 -.223 L .141 -.128 L .488 -.224 L .457 -.305 L .481 -.483 L .245 .064 L .676 -.017 L -.067 -.612 L -.471 -.112 L .434 -.405 L .511 -.648 L .841 .063 L .047 -.341 L .096 -.228 L .954 -.116 L -.396 -.357 L -.327 -.097 L -.193 -.146 L .164 -.245 L .313 -.246 L .464 .048 L .888 -.067 L -.543 -.522 L .249 -.082 L .435 -.034 L .707 -.263 L .592 -.067 L .308 -.208 L -.358 -.064 L -.105 -.187 L .289 -.1 L .616 -.33 L .557 .032 L .351 .098 L .434 -.264 L .369 -.031 L .035 -.176 L -.421 -.321 L .627 -.232 L .146 -.275 L .336 .01 L .359 .297 L .397 .082 L .526 -.381 L -.281 -.656 L .438 .065 L .698 -.058 L .207 -.174 L -.604 -.315 L .411 -.224 L .816 -.251 L .093 -.257 L .261 -.194 L .73 -.135 L .074 .067 L .274 -.051 L .102 -.067 L .492 -.67 L .521 .25 L .96 -.153 L .411 .133 L .265 .1 L .646 .065 L .536 -.419 L .747 -.84 L .286 -.085 L .16 .168 L -.178 .286 L -.182 .587 L .791 -.454 L .403 -.572 L .819 -.085 L .688 -.439 L .437 .117 L .665 .353 L .567 -.643 L .318 -.272 L .976 .1 L 1.019 .506 L .197 -.152 L .479 -.595 L .709 -.444 L .283 -.052 L .562 .067 L .338 -.308 L .469 -.291 L .619 -.189 L 1.2 -.173 L .984 .015 L -1.337 .755 L -.24 .273 L -.107 .646 L .42 .084 L .691 -.579 L 1.53 -.941 L .764 -.275 L .028 .257 L -.004 .905 L .704 -.172 L .438 -.239 L .855 -.874 L .959 -.104 L .586 -.001 L .216 .154 L -.383 .257 L -.335 .257 L .074 .239 L -.319 .41 L .921 .118 L .221 -.443 L .902 -.651 L .421 .017 L 1.682 .561 L .667 .135 L .935 .015 L .649 .237 L .1 .272 L -1.216 .393 L -1.148 .036 L -2.233 -.047 L .193 .084 L .585 .304 L 1.058 .284 L .383 .302 L .728 -.052 L .679 -.102 L .831 .032 L .708 .25 L -.404 .288 L -.514 .204 L -.824 .021 L -.77 .121 L -1.023 .49 L -1.013 .672 L -.689 .303 L -.001 -.2 L .096 -.367 L .874 -.923 L -.044 -.268 L -.88 -.348 L -.672 -.114 L -1.125 -.431 L -.556 .003 L -.555 .07 L -2.004 .095 L -.865 .374 L -.567 .422 L -.26 .437 L -.079 .501 L -.188 .5 L -1.25 .472 L -.582 .368 L -.31 -.148 L -1.288 -.492 L -1.657 .225 L -1.411 -.042 L -.536 -.13 L -.861 -.595 L -.994 -.612 L -.486 -.082 L -.355 .103 L -1.012 .656 L -.114 -.063 L -.41 -.031 L -.865 .038 L -.281 1.066 L -.164 .449 L -.271 .25 L -.323 -.015 L -.67 -.129 L -.972 -.144 L -1.731 -.389 L -.168 .183 L -.021 .663 L -.083 .199 L -.318 .299 L -.695 .004 L -.871 -.095 L -.279 -.015 L -.465 .167 L -1.484 1.176 L .05 .213 L .171 .507 L -.188 .345 L -.615 .346 L -1.325 .919 L -.687 .442 L -.981 .021 L -.121 .244 L -.06 .971 L -.32 .598 L -.383 .469 L -.574 .499 L -.495 .545 L .339 .125 L .381 .269 L .252 .587 L -.17 .176 L -.44 .177 L -.733 .036 L -.932 -.027 L -.618 .114 L -.613 .257 L -.617 .479 L -.389 .492 L -.077 .664 L -.349 1.093 L .65 .729 L -.335 1.171 L .582 .39 L .715 .186 L .297 .243 L -.432 .67 L -.941 .16 L .571 .735 L .26 .427 L -.249 .346 L -.029 .532 L -.769 .384 L -.414 .013 L -.117 .423 L -.506 .224 L .22 .831 L -.324 .737 L -.41 .013 L -.15 -.342 L -.293 -.132 L
464.349 47.431 N -.024 .283 L -.258 .465 L .116 .529 L .563 .212 L .872 .194 L .964 .506 L .543 .392 L -.421 .364 L -1.303 .777 L -.328 .296 L 1.402 1.394 L .772 1.195 L -.196 .356 L -.44 .535 L -.187 .403 L -.029 .37 L .37 .509 L 1.286 1.395 L .151 .253 L -.057 .254 L -.542 .415 L -.327 .191 L .439 .33 L 1.357 .499 L .703 .265 L .436 .392 L .161 .346 L -.105 .409 L -.43 .536 L -.591 .536 L -1.385 .758 L -1.983 1.195 L -1.946 1.145 L -.174 .285 L -.935 .206 L -1.195 .188 L -.149 .181 L -.506 -.217 L -.518 .146 L -.052 .134 L -.688 -.07 L -.193 -.108 L .057 -.387 L -.241 .527 L -.268 .14 L -.633 .047 L -.328 .03 L -.1 .267 L -.589 -.326 L -.29 .275 L -.676 .064 L -.34 .178 L -.052 -.127 L -.504 .108 L -.504 .108 L -.211 .266 L -.311 -.152 L -.672 .126 L -.04 -.114 L -.658 .215 L -.547 .013 L -.482 .025 L -.487 -.253 L -.223 -.274 L .273 -.34 L -.846 .017 L -.517 .177 L .065 -.382 L -.446 .076 L -.644 -.271 L -.409 -.061 L -.415 -.231 L -.26 -.403 L -.036 -.714 L .158 -.374 L .05 -.436 L .09 -.234 L -.347 -.483 L -.431 -.375 L .3 -.658 L -.02 -.392 L -.305 -.204 L -.37 -.093 L .062 -.299 L .295 -.331 L .637 -.285 L .144 -.189 L -.113 -.331 L .382 -.143 L .633 .125 L .274 .063 L .483 -.222 L .303 -.427 L .104 -.459 L .207 -.27 L .301 .316 L .27 0 L 1.678 -1.114 L 1.142 -.654 L .835 -.576 L 1.026 -.401 L .874 .03 L .06 -.304 L -.13 -.144 L -.357 -.16 L .119 -.371 L .146 -.387 L -.329 -.274 L -1.139 -.095 L -.836 -.451 L -.594 -.024 L -.113 -.234 L -.327 -.307 L -.208 -.535 L .5 -.8 L -.028 -.392 L -.405 -.685 L -.507 -.637 L .004 -.526 L .062 -.413 L -.77 -.558 L -.508 -.229 L -1.583 -.207 L -1.085 -.292 L -1.286 -.658 L -.616 -.463 L -.146 -.033 L 1.012 -.656 L .355 -.103 L .486 .082 L .994 .612 L .861 .595 L .536 .13 L 1.411 .042 L 1.657 -.225 L 1.288 .492 L .31 .148 L .582 -.368 L 1.25 -.472 L .188 -.5 L .079 -.501 L .26 -.437 L .567 -.422 L .865 -.374 L 2.004 -.095 L .555 -.07 L .556 -.003 L 1.125 .431 L .672 .114 L .88 .348 L .044 .268 L -.874 .923 L -.096 .367 L .001 .2 L
453.795 53.873 N -.23 -.004 L -.975 .164 L -.447 .098 L -.902 -.387 L -.339 -.178 L -.347 .114 L -.641 .374 L -.542 .599 L -.309 .146 L -.658 .018 L -.545 .355 L .325 .241 L .146 .192 L -.355 .273 L -.907 .401 L .317 .271 L .385 .159 L .33 .302 L -.749 .367 L -.405 .43 L -.368 .461 L -1.591 .669 L -.699 .286 L -.456 -.205 L -.326 .08 L -.538 .539 L -.646 .144 L -.663 .348 L -.217 .284 L -.191 .142 L -.746 .033 L -.221 -.031 L .151 .535 L -.484 .425 L 439 61.33 l .216 .533 L .243 .25 L -.244 .955 L -.498 .063 L -.217 .204 L .189 .757 L -.009 .544 L .381 .444 L -.287 .175 L .926 .082 L .225 .187 L .499 -.082 L .652 .594 L .428 .314 L .86 .163 L .198 .406 L .32 .139 L .014 .335 L -.391 0 L -.508 .323 L -.861 .3 L -.492 .162 L -.521 -.012 L -.146 -.115 L -.805 -.115 L -.66 -.173 L -.634 -.069 L -.137 .104 L -.446 -.115 L -.257 .3 L .819 -.069 L .497 .265 L .591 .046 L .205 .208 L .481 .069 L .021 -.127 L .616 .069 L .258 -.196 L .297 .011 L .481 -.104 L .226 .081 L .026 -.15 L .164 0 L .214 .15 L -.029 .081 L -.722 .023 L .219 .288 L -.792 .265 L -.168 .288 L -.386 .08 L -.089 -.092 L .042 -.161 L -.014 -.276 L -.258 .023 L -.091 .46 L -.501 .333 L -.248 .058 L -.36 -.069 L -.005 .218 L -1.418 .035 L .156 .458 L .513 .258 L .066 .609 L -.109 .33 L -.281 .051 L -.308 -.064 L .038 .429 L .29 .081 L -.126 .268 L .24 .228 L -.365 .364 L -.222 .455 L -.041 .56 L -.766 1.043 L -.58 .71 L -.165 -.062 L -.442 -.236 L -.614 .193 L -1.262 -.089 L -.106 .311 L -.252 -.083 L -.518 .264 L -.295 .517 L .356 .336 L -.376 .374 L -.48 -.129 L -.173 -.037 L -1.158 .269 L -1.11 -.116 L -.001 -.142 L .19 -.078 L -.062 -.181 L .281 -.297 L -.638 -.53 L -.413 -.479 L -.22 -.272 L .529 -.116 L -.082 -.312 L .421 .077 L .147 -.245 L -.19 -.234 L -.285 .013 L -.292 -.377 L -.527 -.221 L -.63 -.99 L -.286 0 L .011 -.408 L -.256 -.364 L -.348 -.298 L .221 -.484 L .206 -.341 L -.418 -.154 L -.405 .102 L -.055 -.288 L -.412 .051 L -.18 -1.207 L -.225 -.131 L .311 -.355 L .293 .132 L .15 .342 L .41 -.013 L .324 -.737 L -.22 -.831 L .506 -.224 L .117 -.423 L .414 -.013 L .769 -.384 L .029 -.532 L .249 -.346 L -.26 -.427 L -.571 -.735 L .941 -.16 L .432 -.67 L -.297 -.243 L -.715 -.186 L -.582 -.39 L .335 -1.171 L -.65 -.729 L .349 -1.093 L .077 -.664 L .389 -.492 L .617 -.479 L .613 -.257 L .618 -.114 L .932 .027 L .733 -.036 L .44 -.177 L .17 -.176 L -.252 -.587 L -.381 -.269 L -.339 -.125 L .495 -.545 L .574 -.499 L .383 -.469 L .32 -.598 L .06 -.971 L .121 -.244 L .981 -.021 L .687 -.442 L 1.325 -.919 L .615 -.346 L .188 -.345 L -.171 -.507 L -.05 -.213 L 1.484 -1.176 L .465 -.167 L .279 .015 L .871 .095 L .695 -.004 L .318 -.299 L .083 -.199 L .021 -.663 L .168 -.183 L 1.731 .389 L .972 .144 L .67 .129 L .323 .015 L .271 -.25 L .164 -.449 L .281 -1.066 L .865 -.038 L .41 .031 L .114 .063 L .146 .033 L .616 .463 L 1.286 .658 L 1.085 .292 L 1.583 .207 L .508 .229 L .77 .558 L -.062 .413 L -.004 .526 L .507 .637 L .405 .685 L .028 .392 L -.5 .8 L .208 .535 L .327 .307 L .113 .234 L
238.107 361.753 N .515 -.688 L .859 0 L 1.202 -.515 L -.171 -.858 L -3.091 .344 L -2.061 .515 L -1.545 -.344 L -.515 -.858 L 1.374 -.515 L 1.202 -.172 L 3.091 -.172 L 1.374 -.515 L -.172 -1.03 L .859 -.516 L 0 -1.374 L -1.326 -1.054 L .982 -.491 L 1.202 -.344 L 1.545 -.172 L .858 .344 L .858 .858 L 1.03 1.374 L 1.374 1.202 L 1.03 1.373 L -.515 2.061 L -1.545 .516 L -1.545 .858 L -3.434 .172 L -3.435 0 L h 172.686 360.379 m 3.091 -.687 L 3.262 0 L 5.495 0 L 2.919 1.202 L -2.748 .687 L -3.759 -.337 L -5.169 -.35 L -3.091 -.516 L h 65.13 371.085 m 1.194 -.265 L 1.393 .133 L .796 .464 L -1.99 0 L -1.393 -.332 L h 277.944 379.954 m .515 -1.202 L 2.404 -1.03 L 2.748 -.172 L 2.061 -.171 L 1.545 -.859 L .343 -1.545 L 1.374 -.687 L 3.091 -.688 L 4.464 0 L 2.404 0 L 3.434 .688 L .687 1.889 L 0 1.202 L -2.061 1.201 L -11.848 1.03 L -11.161 .344 L h 36.004 376.434 m 1.202 -.858 L 2.061 -.343 L 4.121 .515 L 4.293 1.374 L -.887 .482 L -2.719 .204 L -4.293 -.515 L -3.777 -.859 L h 777.843 385.46 m 3.823 .391 L .899 .029 L .322 .234 L 1.202 .294 L 2.329 .088 L 2.126 -.003 L 5.218 .329 L 3.046 .348 L 1.144 -.059 L .762 .029 L 1.411 .37 L 0 2.175 L 0 2.223 L 0 2.222 L 0 2.223 L 0 2.222 L 0 1.551 L -.041 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.182 0 L -.041 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.223 0 L -2.182 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.223 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L -2.222 0 L 9.014 H 6.792 H 4.569 H 2.347 H .125 H 0 -1.544 L 0 -2.222 L 0 -2.223 L 0 -2.222 L 0 -2.223 L 0 -2.223 L 3.941 .297 L 10.131 0 L 7.898 .516 L 6.868 .172 L 8.586 .858 L 6.353 .515 L 8.757 .172 L 4.808 -.172 L 6.525 -.172 L 2.404 .344 L 3.606 -.858 L 16.312 .344 L 4.638 -.013 L 1.143 -.467 L -14.366 -.551 L -9.616 -.688 L -2.232 0 L -3.091 -.172 L -.858 -.171 L -1.545 -.344 L -.498 -.455 L .155 -1.434 L .687 -.858 L 1.889 -.688 L -3.263 -.687 L -2.232 -.344 L -.953 -.503 L 1.589 -.521 L -2.891 -.6 L -3.074 -.208 L -.104 -.261 L 2.857 -.312 L 2.748 0 L 6.525 .343 L 3.434 0 L 2.576 .344 L 4.636 -1.202 L 2.404 -.687 L -2.748 -1.03 L -3.778 -.858 L -4.391 -.405 L -2.649 -.625 L -3.262 -.172 L -2.919 0 L -2.919 -.858 L 2.576 -.516 L 1.28 -.342 L -1.28 -.517 L -2.919 .516 L 52.66 H -1.717 -.344 L 49.054 373 l .343 -1.202 L 1.956 -.07 L 1.65 -.273 L 4.98 0 L 4.626 .493 L 3.272 .709 L 1.374 .172 L 4.465 -.858 L 4.089 .243 L 0 -.729 L .066 -.597 L -2.255 -.73 L -2.93 -.075 L -2.576 -.344 L 2.404 -.687 L 4.121 .171 L 1.717 -.343 L 3.091 -.516 L 3.09 -.343 L 5.667 -.688 L 4.465 -.343 L 3.949 -.516 L 4.464 -.515 L 2.748 .343 L 5.667 0 L 4.464 .258 L 4.121 -.515 L 7.898 .343 L 7.555 -.687 L 3.091 .172 L 1.545 -.688 L 1.545 .516 L 5.323 -.172 L .121 -.87 L 1.758 -.293 L 1.433 .325 L .586 .554 L -.423 .813 L 2.364 .329 L 1.38 -.264 L -.006 -.938 L 1.438 -.267 L 1.48 .267 L .212 1.036 L -1.009 .423 L .521 .781 L 3.024 -.351 L 1.889 .343 L 3.434 .172 L 2.576 -.687 L 3.778 .086 L 4.868 .33 L 2.344 .013 L 1.449 .109 L .693 -.53 L -.611 -.285 L -2.202 -.122 L 1.305 -.285 L .041 -.408 L -.367 -.245 L -1.386 .123 L -.693 .04 L -.856 -.979 L -2.178 -.337 L -.676 -.193 L -.182 -.665 L 4.056 .462 L 3.874 -.245 L -1.224 -.489 L -6.035 -.163 L -.774 -.082 L -.653 -.489 L 0 -.815 L 2.301 .105 L .839 .67 L 5.301 -.204 L 7.253 .736 L 2.404 -.172 L 3.262 -.172 L 4.464 .172 L 3.263 .172 L 2.061 -.516 L .687 -.687 L 1.202 0 L .344 1.03 L 2.576 .343 L 2.404 -.343 L .858 .515 L 3.435 .688 L 3.777 .343 L 2.061 .172 L 1.03 -.515 L .687 -1.202 L 2.747 -.172 L 1.03 .515 L 1.717 .688 L 3.091 -.172 L 3.434 .258 L 4.121 -.344 L 4.979 -.516 L 5.495 -.858 L 3.091 -.515 L 1.202 -.688 L 0 -1.373 L -1.374 -1.202 L -.859 -1.545 L -1.202 -.688 L -.344 -1.03 L 1.202 -1.03 L 1.717 -.343 L .858 -1.202 L -.343 -.858 L -.172 -1.03 L -1.202 -.516 L .344 -1.545 L 1.889 -.172 L 2.404 -1.374 L 1.545 -.515 L .859 -.859 L 1.03 -.687 L 2.919 -1.202 L 3.606 -.515 L 2.404 -1.202 L 2.404 -.172 L 2.232 -1.03 L 1.545 -.343 L .343 1.03 L -1.374 .515 L -1.03 .344 L -1.202 .515 L -.858 0 L -1.202 0 L -2.919 1.202 L -1.03 .687 L -1.717 1.374 L -.172 1.202 L -.687 .687 L -1.374 -.344 L -1.03 0 L -1.202 .516 L -1.202 .687 L -1.03 .688 L -.687 1.201 L .515 .688 L .687 .687 L 1.374 .344 L 1.545 0 L .858 .515 L .687 1.202 L 1.545 1.546 L .687 .858 L 1.03 .687 L .687 1.374 L .858 1.373 L .344 1.546 L -.344 .858 L -.858 1.717 L -2.919 1.889 L -1.202 .172 L -1.03 .858 L -1.717 1.03 L -3.263 .344 L -4.979 .858 L -2.404 .344 L -2.919 .687 L -7.377 -.141 L -4.556 -.316 L -.773 -.401 L -1.717 -.344 L -1.717 -.343 L -1.374 0 L -.859 .515 L .515 .858 L 2.061 .688 L 4.121 1.202 L 4.995 .04 L 1.202 .759 L -3.278 .574 L -5.667 -.343 L -4.979 -.516 L -3.097 -.285 L -2.151 .253 L .823 .696 L 1.164 .538 L 3.262 .172 L 2.232 0 L 1.374 .343 L -.249 .402 L -.782 .113 L -2.232 .515 L -5.151 -.171 L -1.374 -.172 L -2.232 -1.202 L -2.404 0 L .128 .917 L 2.62 1.144 L 1.03 .172 L 1.202 -.172 L 1.374 .344 L 2.404 0 L 4.98 -.516 L 3.09 .687 L .385 .431 L -.041 .6 L -2.061 .172 L -3.263 .172 L -2.608 -.185 L 3.811 .871 L 3.656 -.238 L 1.324 .41 L 2.576 .687 L 6.869 .859 L 8.585 .858 L 10.646 1.373 L 6.525 .516 L 2.061 .858 L .687 1.03 L 3.091 -.344 L 5.323 -1.545 L 6.525 -.687 L 2.455 -.066 L 6.474 -.105 L 9.788 -.344 L 1.889 .344 L 2.576 -1.202 L 8.414 -1.03 L 11.333 -.172 L 8.929 -.858 L 1.202 -.858 L -1.202 -.516 L -.271 -1.07 L -1.184 -.338 L -5.071 .035 L -2.232 .172 L -4.808 -.344 L -3.091 0 L 0 -1.202 L 3.263 -1.545 L 3.949 -1.202 L 2.404 -.172 L 4.121 -1.03 L 9.444 -1.202 L 5.323 -.858 L 6.525 0 L 4.979 -.516 L 2.747 -2.061 L 6.039 -1.541 L -1.23 -.52 L -2.576 .516 L -2.061 -.344 L 1.545 -1.03 L 1.545 -.343 L 2.48 -.249 L .696 -.742 L 3.85 -.742 L 1.577 -.418 L .603 -.557 L -1.716 -.881 L -.093 -.604 L 1.252 -.231 L .464 .742 L 1.017 -.097 L 2.061 -.858 L 1.03 -.343 L .858 .171 L 1.203 1.544 L 2.403 -.342 L .242 -.91 L .96 -.807 L 1.889 -.516 L 1.374 .516 L -1.162 .574 L -.139 .604 L 3.189 -.319 L 4.808 .258 L 3.263 -.172 L 1.03 .858 L 1.545 -.344 L 1.717 -.515 L 5.839 -.858 L 7.212 -1.03 L 4.292 -.858 L 2.061 0 L 2.061 1.373 L 1.718 .344 L 1.889 -.344 L 1.545 -.858 L 7.556 -.344 L 3.434 -.171 L 4.293 .171 L 6.697 .945 L 2.575 0 L 4.293 -.516 L 6.01 -.687 L 5.151 -.688 L 2.404 -.515 L 2.231 -.344 L .615 -.959 L 1.148 -.835 L 1.671 -.095 L .938 .965 L 1.294 .409 L 1.732 1.052 L 1.009 .139 L 1.009 -.661 L 1.322 -.174 L .209 .522 L -.835 .312 L .661 .244 L .8 .278 L .383 -.383 L .313 -.383 L .312 .209 L -.174 .348 L 0 .521 L .592 -.174 L 1.913 -.557 L .418 -1.704 L 5.102 -1.137 L 1.374 -.687 L 3.605 -.172 L 1.363 -.646 L 2.758 -.126 L .21 -.27 L -.165 -.297 L .692 -.23 L 1.221 .165 L .197 .593 L .66 .231 L 2.165 -.536 L 1.265 -.223 L -.726 -.297 L -.561 -.264 L .099 -.362 L 1.451 -.1 L 1.562 .215 L .647 .28 L .692 -.132 L -.066 -.33 L -.527 -.33 L 0 -.561 L .297 -.23 L .846 -.242 L 4.292 -.858 L 2.92 -.172 L 3.058 .115 L 2.296 1.076 L 1.316 .023 L .741 .144 L .023 .383 L -.908 .096 L -.168 .454 L 1.723 .216 L 4.892 .646 L 5.571 .453 L 1.546 .172 L 1.717 -.172 L 7.556 .688 L 5.323 0 L .687 .687 L .2 1.075 L -.73 1.232 L -.672 .439 L -.425 1.113 L -.73 .319 L -.905 -.402 L -.83 .402 L -.73 .959 L 1.507 .457 L .594 .045 L .959 -.593 L .411 .365 L -.867 1.05 L -1.215 .062 L -1.717 1.374 L 0 .858 L 1.889 .688 L 2.919 0 L 1.718 -.859 L 1.889 -1.545 L 1.717 -1.717 L 1.374 -.688 L 4.121 -1.03 L 2.231 -.687 L 3.263 -.344 L 2.061 -1.03 L 1.03 -1.03 L 3.435 -1.03 L 2.403 -.687 L 2.061 -.687 L 2.061 -.172 L 6.182 -.687 L 3.778 .171 L 1.204 -.542 L .169 -.659 L .54 -.759 L .49 -.101 L .471 .776 L .305 .775 L 4.892 -.35 L 5.838 0 L 4.979 -.172 L 3.091 .344 L 2.112 -.214 L 1.328 .085 L 1.018 .594 L 1.188 -.764 L 2.714 -1.046 L 1.866 -.226 L .664 -.028 L .594 -.028 L .777 -.057 L 1.512 .311 L 1.166 -.172 L 3.606 .687 L 3.777 .344 L 1.03 0 L 1.064 .573 L .745 .088 L 2.149 -.088 L 1.271 -.263 L 1.315 -.438 L -.192 -.216 L .28 -.53 L 1.447 -.131 L .921 -.088 L .786 .062 L 2.195 -.501 L 2.097 .501 L .688 .687 L .373 .435 L 1.842 -.131 L .921 -.044 L .985 .255 L 1.889 .688 L 2.919 .515 L 2.919 -.343 L 4.121 -.258 L 2.232 -.344 L 2.404 0 L 3.521 .315 L .702 -.755 L 2.158 -.162 L .863 1.133 L 4.909 .323 L .917 -1.133 L 1.889 -.593 L 5.988 .013 L .756 -.283 L 1.996 .108 L -.432 -1.403 L .054 -.809 L 1.232 -.36 L .872 1.277 L -.647 1.079 L .805 .219 L 2.81 .482 L 5.262 .376 L 5.494 .344 L 2.278 .583 L 1.283 .14 L 1.396 -.167 L 2.204 .446 L 1.961 -.167 L .719 .278 L -.435 .431 L -.151 .351 L .293 .123 L 2.081 .331 L 1.078 .484 L 2.706 -.134 L .377 .595 L 1.038 .227 L 4.808 .515 L -.123 .536 L .567 .236 L 2.695 -.095 L 3.214 .181 L -.329 -.984 L .71 -.095 L .804 .426 L .331 .709 L 1.135 .284 L 2.672 .519 L 2.576 -.343 L 4.017 .999 L 1.626 .495 L 1.672 .871 L 1.626 .023 L .504 .187 L .532 -.021 L .754 -.047 L .777 .047 L .896 .589 L .541 .118 L .542 .07 L .142 -.259 L .471 0 L 1.484 -.048 L 1.416 .237 L 5.951 .535 L .729 .516 L 1.733 .323 L 2.979 .944 L .43 -.335 L .551 .191 L .454 .67 L -.741 .215 L -1.124 .167 L -.216 .359 L .168 .263 L .55 -.048 L -.024 .67 L -.43 -.048 L -.096 .287 L -.312 .071 L -.598 .622 L -.526 .12 L -.55 .287 L -.168 .669 L -1.603 .096 L -1.339 -.239 L -1.794 .359 L -2.153 .425 L -2.629 .764 L 1.271 1.103 L -1.907 .212 L -1.23 -.255 L -.763 .212 L -.043 .637 L -2.374 .169 L .136 .514 L .924 .632 L -.127 .763 L -.382 .085 L -.466 .467 L .551 .466 L .085 .764 L -.764 .424 L .637 .254 L .763 0 L .764 .255 L .339 .509 L .17 .721 L 1.284 -.187 L .836 .907 L 2.035 .297 L .339 .339 L 2.672 .552 L -4.113 0 L -2.799 .138 L -2.332 .541 L -1.823 -.085 L -.806 .212 L -1.611 .339 L -1.326 -.32 L -.546 .426 L 1.116 .529 L -.503 .447 L -.669 .195 L -1.117 .753 L -2.623 .642 L .475 .391 L 2.205 -.111 L .53 0 L .809 .307 L .168 .363 L .499 .18 L .422 .183 L .111 .894 L .209 .502 L 3.195 .279 L 2.874 .948 L 3.662 .801 L 5.151 1.202 L 1.456 .062 L 1.015 .17 L -.146 .234 L -1.67 .264 L -.47 .264 L 1.173 .088 L 2.198 -.293 L 1.988 .166 L

/target get (out.png) write-to-png pop
pop
