/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Subnet {
    private String subnetId;
    private String state;
    private String vpcId;
    private String cidrBlock;
    private Integer availableIpAddressCount;
    private String availabilityZone;
    private Boolean defaultForAz;
    private Boolean mapPublicIpOnLaunch;
    private List<Tag> tags;

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public Subnet withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Subnet withState(String state) {
        this.state = state;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public Subnet withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public Subnet withCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
        return this;
    }

    public Integer getAvailableIpAddressCount() {
        return this.availableIpAddressCount;
    }

    public void setAvailableIpAddressCount(Integer availableIpAddressCount) {
        this.availableIpAddressCount = availableIpAddressCount;
    }

    public Subnet withAvailableIpAddressCount(Integer availableIpAddressCount) {
        this.availableIpAddressCount = availableIpAddressCount;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public Subnet withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Boolean isDefaultForAz() {
        return this.defaultForAz;
    }

    public void setDefaultForAz(Boolean defaultForAz) {
        this.defaultForAz = defaultForAz;
    }

    public Subnet withDefaultForAz(Boolean defaultForAz) {
        this.defaultForAz = defaultForAz;
        return this;
    }

    public Boolean getDefaultForAz() {
        return this.defaultForAz;
    }

    public Boolean isMapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
        this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
    }

    public Subnet withMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
        this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        return this;
    }

    public Boolean getMapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Subnet withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Subnet withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnetId != null) {
            sb.append("SubnetId: " + this.subnetId + ", ");
        }
        if (this.state != null) {
            sb.append("State: " + this.state + ", ");
        }
        if (this.vpcId != null) {
            sb.append("VpcId: " + this.vpcId + ", ");
        }
        if (this.cidrBlock != null) {
            sb.append("CidrBlock: " + this.cidrBlock + ", ");
        }
        if (this.availableIpAddressCount != null) {
            sb.append("AvailableIpAddressCount: " + this.availableIpAddressCount + ", ");
        }
        if (this.availabilityZone != null) {
            sb.append("AvailabilityZone: " + this.availabilityZone + ", ");
        }
        if (this.defaultForAz != null) {
            sb.append("DefaultForAz: " + this.defaultForAz + ", ");
        }
        if (this.mapPublicIpOnLaunch != null) {
            sb.append("MapPublicIpOnLaunch: " + this.mapPublicIpOnLaunch + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getAvailableIpAddressCount() == null ? 0 : this.getAvailableIpAddressCount().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.isDefaultForAz() == null ? 0 : this.isDefaultForAz().hashCode());
        hashCode = 31 * hashCode + (this.isMapPublicIpOnLaunch() == null ? 0 : this.isMapPublicIpOnLaunch().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getAvailableIpAddressCount() == null ^ this.getAvailableIpAddressCount() == null) {
            return false;
        }
        if (other.getAvailableIpAddressCount() != null && !other.getAvailableIpAddressCount().equals(this.getAvailableIpAddressCount())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.isDefaultForAz() == null ^ this.isDefaultForAz() == null) {
            return false;
        }
        if (other.isDefaultForAz() != null && !other.isDefaultForAz().equals(this.isDefaultForAz())) {
            return false;
        }
        if (other.isMapPublicIpOnLaunch() == null ^ this.isMapPublicIpOnLaunch() == null) {
            return false;
        }
        if (other.isMapPublicIpOnLaunch() != null && !other.isMapPublicIpOnLaunch().equals(this.isMapPublicIpOnLaunch())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

