/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.net.URL;

import junit.framework.TestCase;

public class MessageHeadersTest extends TestCase {

	public void testAppend()
	{
		MessageHeaders hl = new MessageHeaders();
		MessageHeaders hl2 = new MessageHeaders();
		hl.add(MessageHeader.MH_TRANSFER_ENCODING_CHUNKED);
		hl2.add(MessageHeader.MH_TRANSFER_ENCODING_CHUNKED);
		assertEquals(1, hl2.count());
		hl = new MessageHeaders();
		hl2.set(MessageHeader.MH_TRANSFER_ENCODING_CHUNKED);
		assertEquals("" + hl2, 1, hl2.count());
		try {
			hl.add(null);
			fail("not valid");
		} catch (IllegalArgumentException e) { }
	}
	
	public void testAdd()
	{
		MessageHeaders hl = new MessageHeaders();
		hl.add(MessageHeader.MH_TRANSFER_ENCODING_CHUNKED);
		hl.add("trANSFER-enCODING", "boo");
		assertEquals(2, hl.asList().size());
		assertEquals(true, hl.remove("Transfer-Encoding"));
		assertEquals(0, hl.asList().size());
		assertEquals(false, hl.remove("Transfer-Encoding"));
	}

	public void testContains()
	{
		MessageHeaders hl = new MessageHeaders();
		hl.add(MessageHeader.MH_TRANSFER_ENCODING_CHUNKED);
		hl.add(MessageHeader.FN_CONTENT_TYPE, "text/xml");
		hl.set(MessageHeader.FN_CONTENT_TYPE, "text/xml2");
		boolean chunked = hl.contains(MessageHeader.MH_TRANSFER_ENCODING_CHUNKED);
		assertEquals("got chunked", true, chunked);
		String val = hl.getFieldContent(MessageHeader.FN_CONTENT_TYPE);
		assertEquals("got type", "text/xml2", val);
		String val2 = hl.getFieldContent(MessageHeader.FN_CONTENT_LENGTH);
		assertEquals("not here", null, val2);
	}

	public void testMakeHostHeader()
		throws Exception
	{
		MessageHeader mh;
		mh = MessageHeader.makeHostHeader(new URL("http://example.com"));
		assertEquals("example.com", mh.getFieldContent());
		mh = MessageHeader.makeHostHeader(new URL("http://example.com:123"));
		assertEquals("example.com:123", mh.getFieldContent());
	}

}
