/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.reflect.Invoke;
import gnu.mapping.Procedure2;
import kawa.standard.Scheme;

public class Convert
extends Procedure2
implements CanInline,
Inlineable {
    public static final Convert as = new Convert();
    static ClassType typeType;
    static Method coerceMethod;

    public static Convert getInstance() {
        return as;
    }

    public Object apply2(Object arg1, Object arg2) {
        Type type = (Type)arg1;
        return type.coerceFromObject(arg2);
    }

    public Expression inline(ApplyExp exp, ExpWalker walker) {
        return Invoke.inlineClassName(exp, 0, (InlineCalls)walker);
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        if (args.length != 2) {
            throw new Error("wrong number of arguments to " + this.getName());
        }
        CodeAttr code = comp.getCode();
        Type type = Scheme.getTypeValue(args[0]);
        if (type != null) {
            args[1].compile(comp, Target.pushValue(type));
            if (code.reachableHere()) {
                target.compileFromStack(comp, type);
            }
        } else {
            if (typeType == null) {
                typeType = ClassType.make("gnu.bytecode.Type");
                coerceMethod = typeType.addMethod("coerceFromObject", Compilation.apply1args, Type.pointer_type, 1);
            }
            args[0].compile(comp, typeType);
            args[1].compile(comp, Target.pushObject);
            code.emitInvokeVirtual(coerceMethod);
            target.compileFromStack(comp, Type.pointer_type);
        }
    }

    public Type getReturnType(Expression[] args) {
        Type type;
        if (args != null && args.length == 2 && (type = Scheme.getTypeValue(args[0])) != null) {
            return type;
        }
        return Type.pointer_type;
    }

    public static Expression makeCoercion(Expression value, Expression type) {
        Expression[] exps = new Expression[]{type, value};
        QuoteExp c = new QuoteExp(Convert.getInstance());
        return new ApplyExp(c, exps);
    }

    public static Expression makeCoercion(Expression value, Type type) {
        return Convert.makeCoercion(value, new QuoteExp(type));
    }

    public static void setCoercedReturnValue(LambdaExp lexp, Expression type, Language language) {
        Type rtype = language.getTypeFor(type);
        if (rtype != null) {
            Expression value = lexp.body;
            lexp.body = Convert.makeCoercion(value, type);
            lexp.body.setLine(value);
            lexp.setReturnType(rtype);
        }
    }

    static {
        as.setName("as");
    }
}

