/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cojen.util.BeanProperty;
import org.cojen.util.WeakIdentityMap;

public class BeanIntrospector {
    private static Map cPropertiesCache = new WeakIdentityMap();
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] args) throws Exception {
        System.out.println(BeanIntrospector.getAllProperties(Class.forName(args[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getAllProperties(Class clazz) {
        Map map = cPropertiesCache;
        synchronized (map) {
            Map properties;
            SoftReference ref = (SoftReference)cPropertiesCache.get(clazz);
            if (ref != null && (properties = (Map)ref.get()) != null) {
                return properties;
            }
            properties = BeanIntrospector.createProperties(clazz);
            cPropertiesCache.put(clazz, new SoftReference<Map>(properties));
            return properties;
        }
    }

    private static Map createProperties(Class clazz) {
        if (clazz == null || clazz.isPrimitive()) {
            return Collections.EMPTY_MAP;
        }
        HashMap properties = new HashMap();
        BeanIntrospector.fillInProperties(clazz, properties);
        if (clazz.isInterface()) {
            BeanIntrospector.fillInProperties(class$java$lang$Object == null ? (class$java$lang$Object = BeanIntrospector.class$("java.lang.Object")) : class$java$lang$Object, properties);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            BeanIntrospector.fillInProperties(interfaces[i], properties);
        }
        return Collections.unmodifiableMap(properties);
    }

    private static void fillInProperties(Class clazz, Map properties) {
        IndexedProperty indexedProperty;
        Class<?>[] params;
        SimpleProperty property;
        String name;
        Class<?> type;
        Method method;
        int i;
        Method[] methods = clazz.getMethods();
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) || (type = method.getReturnType()) == Void.TYPE || method.getParameterTypes().length > 0 || (name = BeanIntrospector.extractPropertyName(method, "get")) == null) continue;
            if (properties.containsKey(name)) {
                property = (SimpleProperty)properties.get(name);
                if (type != property.getType() || property.getReadMethod() != null) {
                    continue;
                }
            } else {
                property = new SimpleProperty(name, type);
                properties.put(name, property);
            }
            property.setReadMethod(method);
        }
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) || (type = method.getReturnType()) != Boolean.TYPE || method.getParameterTypes().length > 0 || (name = BeanIntrospector.extractPropertyName(method, "is")) == null) continue;
            if (properties.containsKey(name)) {
                property = (SimpleProperty)properties.get(name);
                if (type != property.getType() || property.getReadMethod() != null) {
                    continue;
                }
            } else {
                property = new SimpleProperty(name, type);
                properties.put(name, property);
            }
            property.setReadMethod(method);
        }
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE || (params = method.getParameterTypes()).length != 1 || (name = BeanIntrospector.extractPropertyName(method, "set")) == null) continue;
            type = params[0];
            if (properties.containsKey(name)) {
                property = (SimpleProperty)properties.get(name);
                if (type != property.getType() || property.getWriteMethod() != null) {
                    continue;
                }
            } else {
                property = new SimpleProperty(name, type);
                properties.put(name, property);
            }
            property.setWriteMethod(method);
        }
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) || (type = method.getReturnType()) == Void.TYPE || (params = method.getParameterTypes()).length != 1 || (name = BeanIntrospector.extractPropertyName(method, "get")) == null) continue;
            if (properties.containsKey(name)) {
                property = (SimpleProperty)properties.get(name);
                if (type != property.getType()) continue;
                if (property instanceof IndexedProperty) {
                    indexedProperty = (IndexedProperty)property;
                } else {
                    indexedProperty = new IndexedProperty(property);
                    properties.put(name, indexedProperty);
                }
            } else {
                indexedProperty = new IndexedProperty(name, type);
                properties.put(name, indexedProperty);
            }
            indexedProperty.addIndexedReadMethod(method);
        }
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE || (params = method.getParameterTypes()).length != 2 || (name = BeanIntrospector.extractPropertyName(method, "set")) == null) continue;
            type = params[1];
            if (properties.containsKey(name)) {
                property = (SimpleProperty)properties.get(name);
                if (type != property.getType()) continue;
                if (property instanceof IndexedProperty) {
                    indexedProperty = (IndexedProperty)property;
                } else {
                    indexedProperty = new IndexedProperty(property);
                    properties.put(name, indexedProperty);
                }
            } else {
                indexedProperty = new IndexedProperty(name, type);
                properties.put(name, indexedProperty);
            }
            indexedProperty.addIndexedWriteMethod(method);
        }
    }

    private static String extractPropertyName(Method method, String prefix) {
        String name = method.getName();
        if (!name.startsWith(prefix)) {
            return null;
        }
        if (name.length() == prefix.length()) {
            return "";
        }
        if (!Character.isUpperCase((name = name.substring(prefix.length())).charAt(0)) || name.indexOf(36) >= 0) {
            return null;
        }
        if (name.length() == 1 || !Character.isUpperCase(name.charAt(1))) {
            char[] chars = name.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            name = new String(chars);
        }
        return name.intern();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IndexedProperty
    extends SimpleProperty {
        private Method[] mIndexedReadMethods;
        private Method[] mIndexedWriteMethods;

        IndexedProperty(String name, Class type) {
            super(name, type);
        }

        IndexedProperty(BeanProperty property) {
            super(property.getName(), property.getType());
            this.setReadMethod(property.getReadMethod());
            this.setWriteMethod(property.getWriteMethod());
        }

        public int getIndexTypesCount() {
            Method[] methods = this.mIndexedReadMethods;
            if (methods != null) {
                return methods.length;
            }
            methods = this.mIndexedWriteMethods;
            return methods == null ? 0 : methods.length;
        }

        public Class getIndexType(int index) {
            Method method;
            Method[] methods = this.mIndexedReadMethods;
            if (methods != null && (method = methods[0]) != null) {
                return method.getParameterTypes()[0];
            }
            methods = this.mIndexedWriteMethods;
            if (methods != null && (method = methods[index]) != null) {
                return method.getParameterTypes()[0];
            }
            if (index >= this.getIndexTypesCount()) {
                throw new IndexOutOfBoundsException();
            }
            return null;
        }

        public Method getIndexedReadMethod(int index) {
            return this.mIndexedReadMethods[index];
        }

        public Method getIndexedWriteMethod(int index) {
            return this.mIndexedWriteMethods[index];
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("BeanProperty[name=");
            buf.append(this.getName());
            buf.append(", type=");
            buf.append(this.getType().getName());
            buf.append(", ");
            int count = this.getIndexTypesCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("indexType[");
                buf.append(i);
                buf.append("]=");
                buf.append(this.getIndexType(0));
            }
            buf.append(']');
            return buf.toString();
        }

        void addIndexedReadMethod(Method method) {
            int i;
            Class<?> indexType = method.getParameterTypes()[0];
            int count = this.getIndexTypesCount();
            for (i = 0; i < count && this.getIndexType(i) != indexType; ++i) {
            }
            if (i >= count) {
                this.expandCapactity();
            }
            if (this.mIndexedReadMethods[i] == null) {
                this.mIndexedReadMethods[i] = method;
            }
        }

        void addIndexedWriteMethod(Method method) {
            int i;
            Class<?> indexType = method.getParameterTypes()[0];
            int count = this.getIndexTypesCount();
            for (i = 0; i < count && this.getIndexType(i) != indexType; ++i) {
            }
            if (i >= count) {
                this.expandCapactity();
            }
            if (this.mIndexedWriteMethods[i] == null) {
                this.mIndexedWriteMethods[i] = method;
            }
        }

        private void expandCapactity() {
            int count = this.getIndexTypesCount();
            Method[] methods = new Method[count + 1];
            if (this.mIndexedReadMethods != null) {
                System.arraycopy(this.mIndexedReadMethods, 0, methods, 0, count);
            }
            this.mIndexedReadMethods = methods;
            methods = new Method[count + 1];
            if (this.mIndexedWriteMethods != null) {
                System.arraycopy(this.mIndexedWriteMethods, 0, methods, 0, count);
            }
            this.mIndexedWriteMethods = methods;
        }
    }

    private static class SimpleProperty
    implements BeanProperty {
        private final String mName;
        private final Class mType;
        private Method mReadMethod;
        private Method mWriteMethod;

        SimpleProperty(String name, Class type) {
            this.mName = name;
            this.mType = type;
        }

        public String getName() {
            return this.mName;
        }

        public Class getType() {
            return this.mType;
        }

        public Method getReadMethod() {
            return this.mReadMethod;
        }

        public Method getWriteMethod() {
            return this.mWriteMethod;
        }

        public int getIndexTypesCount() {
            return 0;
        }

        public Class getIndexType(int index) {
            throw new IndexOutOfBoundsException();
        }

        public Method getIndexedReadMethod(int index) {
            throw new IndexOutOfBoundsException();
        }

        public Method getIndexedWriteMethod(int index) {
            throw new IndexOutOfBoundsException();
        }

        public String toString() {
            return "BeanProperty[name=" + this.getName() + ", type=" + this.getType().getName() + ']';
        }

        void setReadMethod(Method method) {
            this.mReadMethod = method;
        }

        void setWriteMethod(Method method) {
            this.mWriteMethod = method;
        }
    }
}

