/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.common.sphgeom;

import cds.healpix.common.sphgeom.CooXYZ;
import java.util.Locale;

public final class Cone
extends CooXYZ {
    private final double r;

    public Cone(CooXYZ center, double radiusRad) {
        super(center.x(), center.y(), center.z());
        this.r = radiusRad;
    }

    public Cone(double lonRad, double latRad, double radiusRad) {
        super(lonRad, latRad);
        this.r = radiusRad;
    }

    public Cone(double x, double y, double z, double radiusRad) {
        super(x, y, z);
        this.r = radiusRad;
    }

    public double radiusRad() {
        return this.r;
    }

    public boolean contains(CooXYZ coo) {
        return Cone.spheDist(this, coo) <= this.r;
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "Center (%.6f\u00b0, %.6f\u00b0); Radius: %.6f arcmin", Math.toDegrees(this.lon()), Math.toDegrees(this.lat()), Math.toDegrees(this.r) * 60.0);
    }
}

