# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dependencymap import DependencyMapMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDependencyMapMgmtDiscoverySourcesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DependencyMapMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_discovery_sources_get(self, resource_group):
        response = self.client.discovery_sources.get(
            resource_group_name=resource_group.name,
            map_name="str",
            source_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_discovery_sources_begin_create_or_update(self, resource_group):
        response = self.client.discovery_sources.begin_create_or_update(
            resource_group_name=resource_group.name,
            map_name="str",
            source_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": "discovery_source_resource_properties",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_discovery_sources_begin_update(self, resource_group):
        response = self.client.discovery_sources.begin_update(
            resource_group_name=resource_group.name,
            map_name="str",
            source_name="str",
            properties={"tags": {"str": "str"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_discovery_sources_begin_delete(self, resource_group):
        response = self.client.discovery_sources.begin_delete(
            resource_group_name=resource_group.name,
            map_name="str",
            source_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_discovery_sources_list_by_maps_resource(self, resource_group):
        response = self.client.discovery_sources.list_by_maps_resource(
            resource_group_name=resource_group.name,
            map_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
