/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 * DO NOT EDIT, this is an Auto-generated file from:
 * buildscripts/semantic-convention/templates/registry/semantic_attributes-h.j2
 */

#pragma once

#include "opentelemetry/common/macros.h"
#include "opentelemetry/version.h"

OPENTELEMETRY_BEGIN_NAMESPACE
namespace semconv
{
namespace http
{

/**
 * HTTP request headers, @code <key> @endcode being the normalized HTTP Header name (lowercase), the
 * value being the header values. <p> Instrumentations SHOULD require an explicit configuration of
 * which headers are to be captured. Including all request headers can be a security risk - explicit
 * configuration helps avoid leaking sensitive information. The @code User-Agent @endcode header is
 * already captured in the @code user_agent.original @endcode attribute. Users MAY explicitly
 * configure instrumentations to capture them even though it is not recommended. The attribute value
 * MUST consist of either multiple header values as an array of strings or a single-item array
 * containing a possibly comma-concatenated string, depending on the way the HTTP library provides
 * access to headers.
 */
static constexpr const char *kHttpRequestHeader = "http.request.header";

/**
 * HTTP request method.
 * <p>
 * HTTP request method value SHOULD be "known" to the instrumentation.
 * By default, this convention defines "known" methods as the ones listed in <a
 * href="https://www.rfc-editor.org/rfc/rfc9110.html#name-methods">RFC9110</a> and the PATCH method
 * defined in <a href="https://www.rfc-editor.org/rfc/rfc5789.html">RFC5789</a>. <p> If the HTTP
 * request method is not known to instrumentation, it MUST set the @code http.request.method
 * @endcode attribute to @code _OTHER @endcode. <p> If the HTTP instrumentation could end up
 * converting valid HTTP request methods to @code _OTHER @endcode, then it MUST provide a way to
 * override the list of known HTTP methods. If this override is done via environment variable, then
 * the environment variable MUST be named OTEL_INSTRUMENTATION_HTTP_KNOWN_METHODS and support a
 * comma-separated list of case-sensitive known HTTP methods (this list MUST be a full override of
 * the default known method, it is not a list of known methods in addition to the defaults). <p>
 * HTTP method names are case-sensitive and @code http.request.method @endcode attribute value MUST
 * match a known HTTP method name exactly. Instrumentations for specific web frameworks that
 * consider HTTP methods to be case insensitive, SHOULD populate a canonical equivalent. Tracing
 * instrumentations that do so, MUST also set @code http.request.method_original @endcode to the
 * original value.
 */
static constexpr const char *kHttpRequestMethod = "http.request.method";

/**
 * Original HTTP method sent by the client in the request line.
 */
static constexpr const char *kHttpRequestMethodOriginal = "http.request.method_original";

/**
 * The ordinal number of request resending attempt (for any reason, including redirects).
 * <p>
 * The resend count SHOULD be updated each time an HTTP request gets resent by the client,
 * regardless of what was the cause of the resending (e.g. redirection, authorization failure, 503
 * Server Unavailable, network issues, or any other).
 */
static constexpr const char *kHttpRequestResendCount = "http.request.resend_count";

/**
 * HTTP response headers, @code <key> @endcode being the normalized HTTP Header name (lowercase),
 * the value being the header values. <p> Instrumentations SHOULD require an explicit configuration
 * of which headers are to be captured. Including all response headers can be a security risk -
 * explicit configuration helps avoid leaking sensitive information. Users MAY explicitly configure
 * instrumentations to capture them even though it is not recommended. The attribute value MUST
 * consist of either multiple header values as an array of strings or a single-item array containing
 * a possibly comma-concatenated string, depending on the way the HTTP library provides access to
 * headers.
 */
static constexpr const char *kHttpResponseHeader = "http.response.header";

/**
 * <a href="https://tools.ietf.org/html/rfc7231#section-6">HTTP response status code</a>.
 */
static constexpr const char *kHttpResponseStatusCode = "http.response.status_code";

/**
 * The matched route, that is, the path template in the format used by the respective server
 * framework. <p> MUST NOT be populated when this is not supported by the HTTP server framework as
 * the route attribute should have low-cardinality and the URI path can NOT substitute it. SHOULD
 * include the <a href="/docs/http/http-spans.md#http-server-definitions">application root</a> if
 * there is one.
 */
static constexpr const char *kHttpRoute = "http.route";

namespace HttpRequestMethodValues
{
/**
 * CONNECT method.
 */
static constexpr const char *kConnect = "CONNECT";

/**
 * DELETE method.
 */
static constexpr const char *kDelete = "DELETE";

/**
 * GET method.
 */
static constexpr const char *kGet = "GET";

/**
 * HEAD method.
 */
static constexpr const char *kHead = "HEAD";

/**
 * OPTIONS method.
 */
static constexpr const char *kOptions = "OPTIONS";

/**
 * PATCH method.
 */
static constexpr const char *kPatch = "PATCH";

/**
 * POST method.
 */
static constexpr const char *kPost = "POST";

/**
 * PUT method.
 */
static constexpr const char *kPut = "PUT";

/**
 * TRACE method.
 */
static constexpr const char *kTrace = "TRACE";

/**
 * Any HTTP method that the instrumentation has no prior knowledge of.
 */
static constexpr const char *kOther = "_OTHER";

}  // namespace HttpRequestMethodValues

}  // namespace http
}  // namespace semconv
OPENTELEMETRY_END_NAMESPACE
