#include <cstdlib>
#include <cstring>
#include <cstdio>
#include <vector>
#include "csutil.hxx"

using namespace std;

// strip strings into token based on single char delimiter
// acts like strsep() but only uses a delim char and not 
// a delim string

char * mystrsep(char ** stringp, const char delim)
{
  char * rv = NULL;
  char * mp = *stringp;
  int n = strlen(mp);
  if (n > 0) {
     char * dp = (char *)memchr(mp,(int)((unsigned char)delim),n);
     if (dp) {
        *stringp = dp+1;
        int nc = (int)((unsigned long)dp - (unsigned long)mp); 
        rv = (char *) malloc(nc+1);
        memcpy(rv,mp,nc);
        *(rv+nc) = '\0';
        return rv;
     } else {
       rv = (char *) malloc(n+1);
       memcpy(rv, mp, n);
       *(rv+n) = '\0';
       *stringp = mp + n;
       return rv;
     }
  }
  return NULL;
}


// replaces strdup with ansi version
char * mystrdup(const char * s)
{
  char * d = NULL;
  if (s) {
     int sl = strlen(s);
     d = (char *) malloc(((sl+1) * sizeof(char)));
     if (d) memcpy(d,s,((sl+1)*sizeof(char)));
  }
  return d;
}


// remove cross-platform text line end characters
void mychomp(char * s)
{
  int k = strlen(s);
  if ((k > 0) && ((*(s+k-1)=='\r') || (*(s+k-1)=='\n'))) *(s+k-1) = '\0';
  if ((k > 1) && (*(s+k-2) == '\r')) *(s+k-2) = '\0';
}


//  does an ansi strdup of the reverse of a string
char * myrevstrdup(const char * s)
{
    char * d = NULL;
    if (s) {
       int sl = strlen(s);
       d = (char *) malloc((sl+1) * sizeof(char));
       if (d) {
	 const char * p = s + sl - 1;
         char * q = d;
         while (p >= s) *q++ = *p--;
         *q = '\0';
       }
    }
    return d; 
}


// return 1 if s1 is a leading subset of s2
int isSubset(const char * s1, const char * s2)
{
  int l1 = strlen(s1);
  int l2 = strlen(s2);
  if (l1 > l2) return 0;
  if (strncmp(s2,s1,l1) == 0) return 1;
  return 0;
}



// convert null terminated string to all caps using encoding 
void enmkallcap(char * d, const char * p, const char * encoding)
{
  struct cs_info * csconv = get_current_cs(encoding);
  while (*p != '\0') { 
    *d++ = csconv[((unsigned char) *p)].cupper;
    p++;
  }
  *d = '\0';
}


// convert null terminated string to all little using encoding
void enmkallsmall(char * d, const char * p, const char * encoding)
{
  struct cs_info * csconv = get_current_cs(encoding);
  while (*p != '\0') { 
    *d++ = csconv[((unsigned char) *p)].clower;
    p++;
  }
  *d = '\0';
}


// convert null terminated string to have intial capital using encoding
void enmkinitcap(char * d, const char * p, const char * encoding)
{
  struct cs_info * csconv = get_current_cs(encoding);
  memcpy(d,p,(strlen(p)+1));
  if (*p != '\0') *d= csconv[((unsigned char)*p)].cupper;
}


// convert null terminated string to all caps 
void mkallcap(char * p, const struct cs_info * csconv)
{
  while (*p != '\0') { 
    *p = csconv[((unsigned char) *p)].cupper;
    p++;
  }
}


// convert null terminated string to all little
void mkallsmall(char * p, const struct cs_info * csconv)
{
  while (*p != '\0') { 
    *p = csconv[((unsigned char) *p)].clower;
    p++;
  }
}


// convert null terminated string to have intial capital
void mkinitcap(char * p, const struct cs_info * csconv)
{
  if (*p != '\0') *p = csconv[((unsigned char)*p)].cupper;
}




// these are simple character mappings for the 
// encodings supported
// supplying isupper, tolower, and toupper

struct cs_info iso1_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xb9 },
{ 0x00, 0xba, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x00, 0xbc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xbf },
{ 0x01, 0xe0, 0xc0 },
{ 0x01, 0xe1, 0xc1 },
{ 0x01, 0xe2, 0xc2 },
{ 0x01, 0xe3, 0xc3 },
{ 0x01, 0xe4, 0xc4 },
{ 0x01, 0xe5, 0xc5 },
{ 0x01, 0xe6, 0xc6 },
{ 0x01, 0xe7, 0xc7 },
{ 0x01, 0xe8, 0xc8 },
{ 0x01, 0xe9, 0xc9 },
{ 0x01, 0xea, 0xca },
{ 0x01, 0xeb, 0xcb },
{ 0x01, 0xec, 0xcc },
{ 0x01, 0xed, 0xcd },
{ 0x01, 0xee, 0xce },
{ 0x01, 0xef, 0xcf },
{ 0x01, 0xf0, 0xd0 },
{ 0x01, 0xf1, 0xd1 },
{ 0x01, 0xf2, 0xd2 },
{ 0x01, 0xf3, 0xd3 },
{ 0x01, 0xf4, 0xd4 },
{ 0x01, 0xf5, 0xd5 },
{ 0x01, 0xf6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x01, 0xf8, 0xd8 },
{ 0x01, 0xf9, 0xd9 },
{ 0x01, 0xfa, 0xda },
{ 0x01, 0xfb, 0xdb },
{ 0x01, 0xfc, 0xdc },
{ 0x01, 0xfd, 0xdd },
{ 0x01, 0xfe, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xc0 },
{ 0x00, 0xe1, 0xc1 },
{ 0x00, 0xe2, 0xc2 },
{ 0x00, 0xe3, 0xc3 },
{ 0x00, 0xe4, 0xc4 },
{ 0x00, 0xe5, 0xc5 },
{ 0x00, 0xe6, 0xc6 },
{ 0x00, 0xe7, 0xc7 },
{ 0x00, 0xe8, 0xc8 },
{ 0x00, 0xe9, 0xc9 },
{ 0x00, 0xea, 0xca },
{ 0x00, 0xeb, 0xcb },
{ 0x00, 0xec, 0xcc },
{ 0x00, 0xed, 0xcd },
{ 0x00, 0xee, 0xce },
{ 0x00, 0xef, 0xcf },
{ 0x00, 0xf0, 0xd0 },
{ 0x00, 0xf1, 0xd1 },
{ 0x00, 0xf2, 0xd2 },
{ 0x00, 0xf3, 0xd3 },
{ 0x00, 0xf4, 0xd4 },
{ 0x00, 0xf5, 0xd5 },
{ 0x00, 0xf6, 0xd6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xd8 },
{ 0x00, 0xf9, 0xd9 },
{ 0x00, 0xfa, 0xda },
{ 0x00, 0xfb, 0xdb },
{ 0x00, 0xfc, 0xdc },
{ 0x00, 0xfd, 0xdd },
{ 0x00, 0xfe, 0xde },
{ 0x00, 0xff, 0xff },
};


struct cs_info iso2_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x01, 0xb1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x01, 0xb3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x01, 0xb5, 0xa5 },
{ 0x01, 0xb6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x01, 0xb9, 0xa9 },
{ 0x01, 0xba, 0xaa },
{ 0x01, 0xbb, 0xab },
{ 0x01, 0xbc, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x01, 0xbe, 0xae },
{ 0x01, 0xbf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xa1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xa3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xa5 },
{ 0x00, 0xb6, 0xa6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xa9 },
{ 0x00, 0xba, 0xaa },
{ 0x00, 0xbb, 0xab },
{ 0x00, 0xbc, 0xac },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xae },
{ 0x00, 0xbf, 0xaf },
{ 0x01, 0xe0, 0xc0 },
{ 0x01, 0xe1, 0xc1 },
{ 0x01, 0xe2, 0xc2 },
{ 0x01, 0xe3, 0xc3 },
{ 0x01, 0xe4, 0xc4 },
{ 0x01, 0xe5, 0xc5 },
{ 0x01, 0xe6, 0xc6 },
{ 0x01, 0xe7, 0xc7 },
{ 0x01, 0xe8, 0xc8 },
{ 0x01, 0xe9, 0xc9 },
{ 0x01, 0xea, 0xca },
{ 0x01, 0xeb, 0xcb },
{ 0x01, 0xec, 0xcc },
{ 0x01, 0xed, 0xcd },
{ 0x01, 0xee, 0xce },
{ 0x01, 0xef, 0xcf },
{ 0x01, 0xf0, 0xd0 },
{ 0x01, 0xf1, 0xd1 },
{ 0x01, 0xf2, 0xd2 },
{ 0x01, 0xf3, 0xd3 },
{ 0x01, 0xf4, 0xd4 },
{ 0x01, 0xf5, 0xd5 },
{ 0x01, 0xf6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x01, 0xf8, 0xd8 },
{ 0x01, 0xf9, 0xd9 },
{ 0x01, 0xfa, 0xda },
{ 0x01, 0xfb, 0xdb },
{ 0x01, 0xfc, 0xdc },
{ 0x01, 0xfd, 0xdd },
{ 0x01, 0xfe, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xc0 },
{ 0x00, 0xe1, 0xc1 },
{ 0x00, 0xe2, 0xc2 },
{ 0x00, 0xe3, 0xc3 },
{ 0x00, 0xe4, 0xc4 },
{ 0x00, 0xe5, 0xc5 },
{ 0x00, 0xe6, 0xc6 },
{ 0x00, 0xe7, 0xc7 },
{ 0x00, 0xe8, 0xc8 },
{ 0x00, 0xe9, 0xc9 },
{ 0x00, 0xea, 0xca },
{ 0x00, 0xeb, 0xcb },
{ 0x00, 0xec, 0xcc },
{ 0x00, 0xed, 0xcd },
{ 0x00, 0xee, 0xce },
{ 0x00, 0xef, 0xcf },
{ 0x00, 0xf0, 0xd0 },
{ 0x00, 0xf1, 0xd1 },
{ 0x00, 0xf2, 0xd2 },
{ 0x00, 0xf3, 0xd3 },
{ 0x00, 0xf4, 0xd4 },
{ 0x00, 0xf5, 0xd5 },
{ 0x00, 0xf6, 0xd6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xd8 },
{ 0x00, 0xf9, 0xd9 },
{ 0x00, 0xfa, 0xda },
{ 0x00, 0xfb, 0xdb },
{ 0x00, 0xfc, 0xdc },
{ 0x00, 0xfd, 0xdd },
{ 0x00, 0xfe, 0xde },
{ 0x00, 0xff, 0xff },
};


struct cs_info iso3_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x01, 0xb1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x01, 0xb6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x01, 0x69, 0xa9 },
{ 0x01, 0xba, 0xaa },
{ 0x01, 0xbb, 0xab },
{ 0x01, 0xbc, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x01, 0xbf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xa1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xa6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0x49 },
{ 0x00, 0xba, 0xaa },
{ 0x00, 0xbb, 0xab },
{ 0x00, 0xbc, 0xac },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xaf },
{ 0x01, 0xe0, 0xc0 },
{ 0x01, 0xe1, 0xc1 },
{ 0x01, 0xe2, 0xc2 },
{ 0x00, 0xc3, 0xc3 },
{ 0x01, 0xe4, 0xc4 },
{ 0x01, 0xe5, 0xc5 },
{ 0x01, 0xe6, 0xc6 },
{ 0x01, 0xe7, 0xc7 },
{ 0x01, 0xe8, 0xc8 },
{ 0x01, 0xe9, 0xc9 },
{ 0x01, 0xea, 0xca },
{ 0x01, 0xeb, 0xcb },
{ 0x01, 0xec, 0xcc },
{ 0x01, 0xed, 0xcd },
{ 0x01, 0xee, 0xce },
{ 0x01, 0xef, 0xcf },
{ 0x00, 0xd0, 0xd0 },
{ 0x01, 0xf1, 0xd1 },
{ 0x01, 0xf2, 0xd2 },
{ 0x01, 0xf3, 0xd3 },
{ 0x01, 0xf4, 0xd4 },
{ 0x01, 0xf5, 0xd5 },
{ 0x01, 0xf6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x01, 0xf8, 0xd8 },
{ 0x01, 0xf9, 0xd9 },
{ 0x01, 0xfa, 0xda },
{ 0x01, 0xfb, 0xdb },
{ 0x01, 0xfc, 0xdc },
{ 0x01, 0xfd, 0xdd },
{ 0x01, 0xfe, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xc0 },
{ 0x00, 0xe1, 0xc1 },
{ 0x00, 0xe2, 0xc2 },
{ 0x00, 0xe3, 0xe3 },
{ 0x00, 0xe4, 0xc4 },
{ 0x00, 0xe5, 0xc5 },
{ 0x00, 0xe6, 0xc6 },
{ 0x00, 0xe7, 0xc7 },
{ 0x00, 0xe8, 0xc8 },
{ 0x00, 0xe9, 0xc9 },
{ 0x00, 0xea, 0xca },
{ 0x00, 0xeb, 0xcb },
{ 0x00, 0xec, 0xcc },
{ 0x00, 0xed, 0xcd },
{ 0x00, 0xee, 0xce },
{ 0x00, 0xef, 0xcf },
{ 0x00, 0xf0, 0xf0 },
{ 0x00, 0xf1, 0xd1 },
{ 0x00, 0xf2, 0xd2 },
{ 0x00, 0xf3, 0xd3 },
{ 0x00, 0xf4, 0xd4 },
{ 0x00, 0xf5, 0xd5 },
{ 0x00, 0xf6, 0xd6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xd8 },
{ 0x00, 0xf9, 0xd9 },
{ 0x00, 0xfa, 0xda },
{ 0x00, 0xfb, 0xdb },
{ 0x00, 0xfc, 0xdc },
{ 0x00, 0xfd, 0xdd },
{ 0x00, 0xfe, 0xde },
{ 0x00, 0xff, 0xff },
};

struct cs_info iso4_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x01, 0xb1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x01, 0xb3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x01, 0xb5, 0xa5 },
{ 0x01, 0xb6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x01, 0xb9, 0xa9 },
{ 0x01, 0xba, 0xaa },
{ 0x01, 0xbb, 0xab },
{ 0x01, 0xbc, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x01, 0xbe, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xa1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xa3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xa5 },
{ 0x00, 0xb6, 0xa6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xa9 },
{ 0x00, 0xba, 0xaa },
{ 0x00, 0xbb, 0xab },
{ 0x00, 0xbc, 0xac },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xae },
{ 0x00, 0xbf, 0xbf },
{ 0x01, 0xe0, 0xc0 },
{ 0x01, 0xe1, 0xc1 },
{ 0x01, 0xe2, 0xc2 },
{ 0x01, 0xe3, 0xc3 },
{ 0x01, 0xe4, 0xc4 },
{ 0x01, 0xe5, 0xc5 },
{ 0x01, 0xe6, 0xc6 },
{ 0x01, 0xe7, 0xc7 },
{ 0x01, 0xe8, 0xc8 },
{ 0x01, 0xe9, 0xc9 },
{ 0x01, 0xea, 0xca },
{ 0x01, 0xeb, 0xcb },
{ 0x01, 0xec, 0xcc },
{ 0x01, 0xed, 0xcd },
{ 0x01, 0xee, 0xce },
{ 0x01, 0xef, 0xcf },
{ 0x01, 0xf0, 0xd0 },
{ 0x01, 0xf1, 0xd1 },
{ 0x01, 0xf2, 0xd2 },
{ 0x01, 0xf3, 0xd3 },
{ 0x01, 0xf4, 0xd4 },
{ 0x01, 0xf5, 0xd5 },
{ 0x01, 0xf6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x01, 0xf8, 0xd8 },
{ 0x01, 0xf9, 0xd9 },
{ 0x01, 0xfa, 0xda },
{ 0x01, 0xfb, 0xdb },
{ 0x01, 0xfc, 0xdc },
{ 0x01, 0xfd, 0xdd },
{ 0x01, 0xfe, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xc0 },
{ 0x00, 0xe1, 0xc1 },
{ 0x00, 0xe2, 0xc2 },
{ 0x00, 0xe3, 0xc3 },
{ 0x00, 0xe4, 0xc4 },
{ 0x00, 0xe5, 0xc5 },
{ 0x00, 0xe6, 0xc6 },
{ 0x00, 0xe7, 0xc7 },
{ 0x00, 0xe8, 0xc8 },
{ 0x00, 0xe9, 0xc9 },
{ 0x00, 0xea, 0xca },
{ 0x00, 0xeb, 0xcb },
{ 0x00, 0xec, 0xcc },
{ 0x00, 0xed, 0xcd },
{ 0x00, 0xee, 0xce },
{ 0x00, 0xef, 0xcf },
{ 0x00, 0xf0, 0xd0 },
{ 0x00, 0xf1, 0xd1 },
{ 0x00, 0xf2, 0xd2 },
{ 0x00, 0xf3, 0xd3 },
{ 0x00, 0xf4, 0xd4 },
{ 0x00, 0xf5, 0xd5 },
{ 0x00, 0xf6, 0xd6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xd8 },
{ 0x00, 0xf9, 0xd9 },
{ 0x00, 0xfa, 0xda },
{ 0x00, 0xfb, 0xdb },
{ 0x00, 0xfc, 0xdc },
{ 0x00, 0xfd, 0xdd },
{ 0x00, 0xfe, 0xde },
{ 0x00, 0xff, 0xff },
};

struct cs_info iso5_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x01, 0xf1, 0xa1 },
{ 0x01, 0xf2, 0xa2 },
{ 0x01, 0xf3, 0xa3 },
{ 0x01, 0xf4, 0xa4 },
{ 0x01, 0xf5, 0xa5 },
{ 0x01, 0xf6, 0xa6 },
{ 0x01, 0xf7, 0xa7 },
{ 0x01, 0xf8, 0xa8 },
{ 0x01, 0xf9, 0xa9 },
{ 0x01, 0xfa, 0xaa },
{ 0x01, 0xfb, 0xab },
{ 0x01, 0xfc, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x01, 0xfe, 0xae },
{ 0x01, 0xff, 0xaf },
{ 0x01, 0xd0, 0xb0 },
{ 0x01, 0xd1, 0xb1 },
{ 0x01, 0xd2, 0xb2 },
{ 0x01, 0xd3, 0xb3 },
{ 0x01, 0xd4, 0xb4 },
{ 0x01, 0xd5, 0xb5 },
{ 0x01, 0xd6, 0xb6 },
{ 0x01, 0xd7, 0xb7 },
{ 0x01, 0xd8, 0xb8 },
{ 0x01, 0xd9, 0xb9 },
{ 0x01, 0xda, 0xba },
{ 0x01, 0xdb, 0xbb },
{ 0x01, 0xdc, 0xbc },
{ 0x01, 0xdd, 0xbd },
{ 0x01, 0xde, 0xbe },
{ 0x01, 0xdf, 0xbf },
{ 0x01, 0xe0, 0xc0 },
{ 0x01, 0xe1, 0xc1 },
{ 0x01, 0xe2, 0xc2 },
{ 0x01, 0xe3, 0xc3 },
{ 0x01, 0xe4, 0xc4 },
{ 0x01, 0xe5, 0xc5 },
{ 0x01, 0xe6, 0xc6 },
{ 0x01, 0xe7, 0xc7 },
{ 0x01, 0xe8, 0xc8 },
{ 0x01, 0xe9, 0xc9 },
{ 0x01, 0xea, 0xca },
{ 0x01, 0xeb, 0xcb },
{ 0x01, 0xec, 0xcc },
{ 0x01, 0xed, 0xcd },
{ 0x01, 0xee, 0xce },
{ 0x01, 0xef, 0xcf },
{ 0x00, 0xd0, 0xb0 },
{ 0x00, 0xd1, 0xb1 },
{ 0x00, 0xd2, 0xb2 },
{ 0x00, 0xd3, 0xb3 },
{ 0x00, 0xd4, 0xb4 },
{ 0x00, 0xd5, 0xb5 },
{ 0x00, 0xd6, 0xb6 },
{ 0x00, 0xd7, 0xb7 },
{ 0x00, 0xd8, 0xb8 },
{ 0x00, 0xd9, 0xb9 },
{ 0x00, 0xda, 0xba },
{ 0x00, 0xdb, 0xbb },
{ 0x00, 0xdc, 0xbc },
{ 0x00, 0xdd, 0xbd },
{ 0x00, 0xde, 0xbe },
{ 0x00, 0xdf, 0xbf },
{ 0x00, 0xe0, 0xc0 },
{ 0x00, 0xe1, 0xc1 },
{ 0x00, 0xe2, 0xc2 },
{ 0x00, 0xe3, 0xc3 },
{ 0x00, 0xe4, 0xc4 },
{ 0x00, 0xe5, 0xc5 },
{ 0x00, 0xe6, 0xc6 },
{ 0x00, 0xe7, 0xc7 },
{ 0x00, 0xe8, 0xc8 },
{ 0x00, 0xe9, 0xc9 },
{ 0x00, 0xea, 0xca },
{ 0x00, 0xeb, 0xcb },
{ 0x00, 0xec, 0xcc },
{ 0x00, 0xed, 0xcd },
{ 0x00, 0xee, 0xce },
{ 0x00, 0xef, 0xcf },
{ 0x00, 0xf0, 0xf0 },
{ 0x00, 0xf1, 0xa1 },
{ 0x00, 0xf2, 0xa2 },
{ 0x00, 0xf3, 0xa3 },
{ 0x00, 0xf4, 0xa4 },
{ 0x00, 0xf5, 0xa5 },
{ 0x00, 0xf6, 0xa6 },
{ 0x00, 0xf7, 0xa7 },
{ 0x00, 0xf8, 0xa8 },
{ 0x00, 0xf9, 0xa9 },
{ 0x00, 0xfa, 0xaa },
{ 0x00, 0xfb, 0xab },
{ 0x00, 0xfc, 0xac },
{ 0x00, 0xfd, 0xfd },
{ 0x00, 0xfe, 0xae },
{ 0x00, 0xff, 0xaf },
};

struct cs_info iso6_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xb9 },
{ 0x00, 0xba, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x00, 0xbc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xbf },
{ 0x00, 0xc0, 0xc0 },
{ 0x00, 0xc1, 0xc1 },
{ 0x00, 0xc2, 0xc2 },
{ 0x00, 0xc3, 0xc3 },
{ 0x00, 0xc4, 0xc4 },
{ 0x00, 0xc5, 0xc5 },
{ 0x00, 0xc6, 0xc6 },
{ 0x00, 0xc7, 0xc7 },
{ 0x00, 0xc8, 0xc8 },
{ 0x00, 0xc9, 0xc9 },
{ 0x00, 0xca, 0xca },
{ 0x00, 0xcb, 0xcb },
{ 0x00, 0xcc, 0xcc },
{ 0x00, 0xcd, 0xcd },
{ 0x00, 0xce, 0xce },
{ 0x00, 0xcf, 0xcf },
{ 0x00, 0xd0, 0xd0 },
{ 0x00, 0xd1, 0xd1 },
{ 0x00, 0xd2, 0xd2 },
{ 0x00, 0xd3, 0xd3 },
{ 0x00, 0xd4, 0xd4 },
{ 0x00, 0xd5, 0xd5 },
{ 0x00, 0xd6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x00, 0xd8, 0xd8 },
{ 0x00, 0xd9, 0xd9 },
{ 0x00, 0xda, 0xda },
{ 0x00, 0xdb, 0xdb },
{ 0x00, 0xdc, 0xdc },
{ 0x00, 0xdd, 0xdd },
{ 0x00, 0xde, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xe0 },
{ 0x00, 0xe1, 0xe1 },
{ 0x00, 0xe2, 0xe2 },
{ 0x00, 0xe3, 0xe3 },
{ 0x00, 0xe4, 0xe4 },
{ 0x00, 0xe5, 0xe5 },
{ 0x00, 0xe6, 0xe6 },
{ 0x00, 0xe7, 0xe7 },
{ 0x00, 0xe8, 0xe8 },
{ 0x00, 0xe9, 0xe9 },
{ 0x00, 0xea, 0xea },
{ 0x00, 0xeb, 0xeb },
{ 0x00, 0xec, 0xec },
{ 0x00, 0xed, 0xed },
{ 0x00, 0xee, 0xee },
{ 0x00, 0xef, 0xef },
{ 0x00, 0xf0, 0xf0 },
{ 0x00, 0xf1, 0xf1 },
{ 0x00, 0xf2, 0xf2 },
{ 0x00, 0xf3, 0xf3 },
{ 0x00, 0xf4, 0xf4 },
{ 0x00, 0xf5, 0xf5 },
{ 0x00, 0xf6, 0xf6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xf8 },
{ 0x00, 0xf9, 0xf9 },
{ 0x00, 0xfa, 0xfa },
{ 0x00, 0xfb, 0xfb },
{ 0x00, 0xfc, 0xfc },
{ 0x00, 0xfd, 0xfd },
{ 0x00, 0xfe, 0xfe },
{ 0x00, 0xff, 0xff },
};

struct cs_info iso7_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x01, 0xdc, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x01, 0xdd, 0xb8 },
{ 0x01, 0xde, 0xb9 },
{ 0x01, 0xdf, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x01, 0xfc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x01, 0xfd, 0xbe },
{ 0x01, 0xfe, 0xbf },
{ 0x00, 0xc0, 0xc0 },
{ 0x01, 0xe1, 0xc1 },
{ 0x01, 0xe2, 0xc2 },
{ 0x01, 0xe3, 0xc3 },
{ 0x01, 0xe4, 0xc4 },
{ 0x01, 0xe5, 0xc5 },
{ 0x01, 0xe6, 0xc6 },
{ 0x01, 0xe7, 0xc7 },
{ 0x01, 0xe8, 0xc8 },
{ 0x01, 0xe9, 0xc9 },
{ 0x01, 0xea, 0xca },
{ 0x01, 0xeb, 0xcb },
{ 0x01, 0xec, 0xcc },
{ 0x01, 0xed, 0xcd },
{ 0x01, 0xee, 0xce },
{ 0x01, 0xef, 0xcf },
{ 0x01, 0xf0, 0xd0 },
{ 0x01, 0xf1, 0xd1 },
{ 0x00, 0xd2, 0xd2 },
{ 0x01, 0xf3, 0xd3 },
{ 0x01, 0xf4, 0xd4 },
{ 0x01, 0xf5, 0xd5 },
{ 0x01, 0xf6, 0xd6 },
{ 0x01, 0xf7, 0xd7 },
{ 0x01, 0xf8, 0xd8 },
{ 0x01, 0xf9, 0xd9 },
{ 0x01, 0xfa, 0xda },
{ 0x01, 0xfb, 0xdb },
{ 0x00, 0xdc, 0xb6 },
{ 0x00, 0xdd, 0xb8 },
{ 0x00, 0xde, 0xb9 },
{ 0x00, 0xdf, 0xba },
{ 0x00, 0xe0, 0xe0 },
{ 0x00, 0xe1, 0xc1 },
{ 0x00, 0xe2, 0xc2 },
{ 0x00, 0xe3, 0xc3 },
{ 0x00, 0xe4, 0xc4 },
{ 0x00, 0xe5, 0xc5 },
{ 0x00, 0xe6, 0xc6 },
{ 0x00, 0xe7, 0xc7 },
{ 0x00, 0xe8, 0xc8 },
{ 0x00, 0xe9, 0xc9 },
{ 0x00, 0xea, 0xca },
{ 0x00, 0xeb, 0xcb },
{ 0x00, 0xec, 0xcc },
{ 0x00, 0xed, 0xcd },
{ 0x00, 0xee, 0xce },
{ 0x00, 0xef, 0xcf },
{ 0x00, 0xf0, 0xd0 },
{ 0x00, 0xf1, 0xd1 },
{ 0x00, 0xf2, 0xd3 },
{ 0x00, 0xf3, 0xd3 },
{ 0x00, 0xf4, 0xd4 },
{ 0x00, 0xf5, 0xd5 },
{ 0x00, 0xf6, 0xd6 },
{ 0x00, 0xf7, 0xd7 },
{ 0x00, 0xf8, 0xd8 },
{ 0x00, 0xf9, 0xd9 },
{ 0x00, 0xfa, 0xda },
{ 0x00, 0xfb, 0xdb },
{ 0x00, 0xfc, 0xbc },
{ 0x00, 0xfd, 0xbe },
{ 0x00, 0xfe, 0xbf },
{ 0x00, 0xff, 0xff },
};

struct cs_info iso8_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xb9 },
{ 0x00, 0xba, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x00, 0xbc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xbf },
{ 0x00, 0xc0, 0xc0 },
{ 0x00, 0xc1, 0xc1 },
{ 0x00, 0xc2, 0xc2 },
{ 0x00, 0xc3, 0xc3 },
{ 0x00, 0xc4, 0xc4 },
{ 0x00, 0xc5, 0xc5 },
{ 0x00, 0xc6, 0xc6 },
{ 0x00, 0xc7, 0xc7 },
{ 0x00, 0xc8, 0xc8 },
{ 0x00, 0xc9, 0xc9 },
{ 0x00, 0xca, 0xca },
{ 0x00, 0xcb, 0xcb },
{ 0x00, 0xcc, 0xcc },
{ 0x00, 0xcd, 0xcd },
{ 0x00, 0xce, 0xce },
{ 0x00, 0xcf, 0xcf },
{ 0x00, 0xd0, 0xd0 },
{ 0x00, 0xd1, 0xd1 },
{ 0x00, 0xd2, 0xd2 },
{ 0x00, 0xd3, 0xd3 },
{ 0x00, 0xd4, 0xd4 },
{ 0x00, 0xd5, 0xd5 },
{ 0x00, 0xd6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x00, 0xd8, 0xd8 },
{ 0x00, 0xd9, 0xd9 },
{ 0x00, 0xda, 0xda },
{ 0x00, 0xdb, 0xdb },
{ 0x00, 0xdc, 0xdc },
{ 0x00, 0xdd, 0xdd },
{ 0x00, 0xde, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xe0 },
{ 0x00, 0xe1, 0xe1 },
{ 0x00, 0xe2, 0xe2 },
{ 0x00, 0xe3, 0xe3 },
{ 0x00, 0xe4, 0xe4 },
{ 0x00, 0xe5, 0xe5 },
{ 0x00, 0xe6, 0xe6 },
{ 0x00, 0xe7, 0xe7 },
{ 0x00, 0xe8, 0xe8 },
{ 0x00, 0xe9, 0xe9 },
{ 0x00, 0xea, 0xea },
{ 0x00, 0xeb, 0xeb },
{ 0x00, 0xec, 0xec },
{ 0x00, 0xed, 0xed },
{ 0x00, 0xee, 0xee },
{ 0x00, 0xef, 0xef },
{ 0x00, 0xf0, 0xf0 },
{ 0x00, 0xf1, 0xf1 },
{ 0x00, 0xf2, 0xf2 },
{ 0x00, 0xf3, 0xf3 },
{ 0x00, 0xf4, 0xf4 },
{ 0x00, 0xf5, 0xf5 },
{ 0x00, 0xf6, 0xf6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xf8 },
{ 0x00, 0xf9, 0xf9 },
{ 0x00, 0xfa, 0xfa },
{ 0x00, 0xfb, 0xfb },
{ 0x00, 0xfc, 0xfc },
{ 0x00, 0xfd, 0xfd },
{ 0x00, 0xfe, 0xfe },
{ 0x00, 0xff, 0xff },
};

struct cs_info iso9_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0xfd, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0xdd },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xb9 },
{ 0x00, 0xba, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x00, 0xbc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xbf },
{ 0x01, 0xe0, 0xc0 },
{ 0x01, 0xe1, 0xc1 },
{ 0x01, 0xe2, 0xc2 },
{ 0x01, 0xe3, 0xc3 },
{ 0x01, 0xe4, 0xc4 },
{ 0x01, 0xe5, 0xc5 },
{ 0x01, 0xe6, 0xc6 },
{ 0x01, 0xe7, 0xc7 },
{ 0x01, 0xe8, 0xc8 },
{ 0x01, 0xe9, 0xc9 },
{ 0x01, 0xea, 0xca },
{ 0x01, 0xeb, 0xcb },
{ 0x01, 0xec, 0xcc },
{ 0x01, 0xed, 0xcd },
{ 0x01, 0xee, 0xce },
{ 0x01, 0xef, 0xcf },
{ 0x01, 0xf0, 0xd0 },
{ 0x01, 0xf1, 0xd1 },
{ 0x01, 0xf2, 0xd2 },
{ 0x01, 0xf3, 0xd3 },
{ 0x01, 0xf4, 0xd4 },
{ 0x01, 0xf5, 0xd5 },
{ 0x01, 0xf6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x01, 0xf8, 0xd8 },
{ 0x01, 0xf9, 0xd9 },
{ 0x01, 0xfa, 0xda },
{ 0x01, 0xfb, 0xdb },
{ 0x01, 0xfc, 0xdc },
{ 0x01, 0x69, 0xdd },
{ 0x01, 0xfe, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xc0 },
{ 0x00, 0xe1, 0xc1 },
{ 0x00, 0xe2, 0xc2 },
{ 0x00, 0xe3, 0xc3 },
{ 0x00, 0xe4, 0xc4 },
{ 0x00, 0xe5, 0xc5 },
{ 0x00, 0xe6, 0xc6 },
{ 0x00, 0xe7, 0xc7 },
{ 0x00, 0xe8, 0xc8 },
{ 0x00, 0xe9, 0xc9 },
{ 0x00, 0xea, 0xca },
{ 0x00, 0xeb, 0xcb },
{ 0x00, 0xec, 0xcc },
{ 0x00, 0xed, 0xcd },
{ 0x00, 0xee, 0xce },
{ 0x00, 0xef, 0xcf },
{ 0x00, 0xf0, 0xd0 },
{ 0x00, 0xf1, 0xd1 },
{ 0x00, 0xf2, 0xd2 },
{ 0x00, 0xf3, 0xd3 },
{ 0x00, 0xf4, 0xd4 },
{ 0x00, 0xf5, 0xd5 },
{ 0x00, 0xf6, 0xd6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xd8 },
{ 0x00, 0xf9, 0xd9 },
{ 0x00, 0xfa, 0xda },
{ 0x00, 0xfb, 0xdb },
{ 0x00, 0xfc, 0xdc },
{ 0x00, 0xfd, 0x49 },
{ 0x00, 0xfe, 0xde },
{ 0x00, 0xff, 0xff },
};

struct cs_info iso10_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xb9 },
{ 0x00, 0xba, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x00, 0xbc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xbf },
{ 0x00, 0xc0, 0xc0 },
{ 0x00, 0xc1, 0xc1 },
{ 0x00, 0xc2, 0xc2 },
{ 0x00, 0xc3, 0xc3 },
{ 0x00, 0xc4, 0xc4 },
{ 0x00, 0xc5, 0xc5 },
{ 0x00, 0xc6, 0xc6 },
{ 0x00, 0xc7, 0xc7 },
{ 0x00, 0xc8, 0xc8 },
{ 0x00, 0xc9, 0xc9 },
{ 0x00, 0xca, 0xca },
{ 0x00, 0xcb, 0xcb },
{ 0x00, 0xcc, 0xcc },
{ 0x00, 0xcd, 0xcd },
{ 0x00, 0xce, 0xce },
{ 0x00, 0xcf, 0xcf },
{ 0x00, 0xd0, 0xd0 },
{ 0x00, 0xd1, 0xd1 },
{ 0x00, 0xd2, 0xd2 },
{ 0x00, 0xd3, 0xd3 },
{ 0x00, 0xd4, 0xd4 },
{ 0x00, 0xd5, 0xd5 },
{ 0x00, 0xd6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x00, 0xd8, 0xd8 },
{ 0x00, 0xd9, 0xd9 },
{ 0x00, 0xda, 0xda },
{ 0x00, 0xdb, 0xdb },
{ 0x00, 0xdc, 0xdc },
{ 0x00, 0xdd, 0xdd },
{ 0x00, 0xde, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xe0 },
{ 0x00, 0xe1, 0xe1 },
{ 0x00, 0xe2, 0xe2 },
{ 0x00, 0xe3, 0xe3 },
{ 0x00, 0xe4, 0xe4 },
{ 0x00, 0xe5, 0xe5 },
{ 0x00, 0xe6, 0xe6 },
{ 0x00, 0xe7, 0xe7 },
{ 0x00, 0xe8, 0xe8 },
{ 0x00, 0xe9, 0xe9 },
{ 0x00, 0xea, 0xea },
{ 0x00, 0xeb, 0xeb },
{ 0x00, 0xec, 0xec },
{ 0x00, 0xed, 0xed },
{ 0x00, 0xee, 0xee },
{ 0x00, 0xef, 0xef },
{ 0x00, 0xf0, 0xf0 },
{ 0x00, 0xf1, 0xf1 },
{ 0x00, 0xf2, 0xf2 },
{ 0x00, 0xf3, 0xf3 },
{ 0x00, 0xf4, 0xf4 },
{ 0x00, 0xf5, 0xf5 },
{ 0x00, 0xf6, 0xf6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xf8 },
{ 0x00, 0xf9, 0xf9 },
{ 0x00, 0xfa, 0xfa },
{ 0x00, 0xfb, 0xfb },
{ 0x00, 0xfc, 0xfc },
{ 0x00, 0xfd, 0xfd },
{ 0x00, 0xfe, 0xfe },
{ 0x00, 0xff, 0xff },
};

struct cs_info koi8r_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xb3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x01, 0xa3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xb9 },
{ 0x00, 0xba, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x00, 0xbc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xbf },
{ 0x00, 0xc0, 0xe0 },
{ 0x00, 0xc1, 0xe1 },
{ 0x00, 0xc2, 0xe2 },
{ 0x00, 0xc3, 0xe3 },
{ 0x00, 0xc4, 0xe4 },
{ 0x00, 0xc5, 0xe5 },
{ 0x00, 0xc6, 0xe6 },
{ 0x00, 0xc7, 0xe7 },
{ 0x00, 0xc8, 0xe8 },
{ 0x00, 0xc9, 0xe9 },
{ 0x00, 0xca, 0xea },
{ 0x00, 0xcb, 0xeb },
{ 0x00, 0xcc, 0xec },
{ 0x00, 0xcd, 0xed },
{ 0x00, 0xce, 0xee },
{ 0x00, 0xcf, 0xef },
{ 0x00, 0xd0, 0xf0 },
{ 0x00, 0xd1, 0xf1 },
{ 0x00, 0xd2, 0xf2 },
{ 0x00, 0xd3, 0xf3 },
{ 0x00, 0xd4, 0xf4 },
{ 0x00, 0xd5, 0xf5 },
{ 0x00, 0xd6, 0xf6 },
{ 0x00, 0xd7, 0xf7 },
{ 0x00, 0xd8, 0xf8 },
{ 0x00, 0xd9, 0xf9 },
{ 0x00, 0xda, 0xfa },
{ 0x00, 0xdb, 0xfb },
{ 0x00, 0xdc, 0xfc },
{ 0x00, 0xdd, 0xfd },
{ 0x00, 0xde, 0xfe },
{ 0x00, 0xdf, 0xff },
{ 0x01, 0xc0, 0xe0 },
{ 0x01, 0xc1, 0xe1 },
{ 0x01, 0xc2, 0xe2 },
{ 0x01, 0xc3, 0xe3 },
{ 0x01, 0xc4, 0xe4 },
{ 0x01, 0xc5, 0xe5 },
{ 0x01, 0xc6, 0xe6 },
{ 0x01, 0xc7, 0xe7 },
{ 0x01, 0xc8, 0xe8 },
{ 0x01, 0xc9, 0xe9 },
{ 0x01, 0xca, 0xea },
{ 0x01, 0xcb, 0xeb },
{ 0x01, 0xcc, 0xec },
{ 0x01, 0xcd, 0xed },
{ 0x01, 0xce, 0xee },
{ 0x01, 0xcf, 0xef },
{ 0x01, 0xd0, 0xf0 },
{ 0x01, 0xd1, 0xf1 },
{ 0x01, 0xd2, 0xf2 },
{ 0x01, 0xd3, 0xf3 },
{ 0x01, 0xd4, 0xf4 },
{ 0x01, 0xd5, 0xf5 },
{ 0x01, 0xd6, 0xf6 },
{ 0x01, 0xd7, 0xf7 },
{ 0x01, 0xd8, 0xf8 },
{ 0x01, 0xd9, 0xf9 },
{ 0x01, 0xda, 0xfa },
{ 0x01, 0xdb, 0xfb },
{ 0x01, 0xdc, 0xfc },
{ 0x01, 0xdd, 0xfd },
{ 0x01, 0xde, 0xfe },
{ 0x01, 0xdf, 0xff },
};

struct cs_info cp1251_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xb9 },
{ 0x00, 0xba, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x00, 0xbc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xbf },
{ 0x00, 0xc0, 0xc0 },
{ 0x00, 0xc1, 0xc1 },
{ 0x00, 0xc2, 0xc2 },
{ 0x00, 0xc3, 0xc3 },
{ 0x00, 0xc4, 0xc4 },
{ 0x00, 0xc5, 0xc5 },
{ 0x00, 0xc6, 0xc6 },
{ 0x00, 0xc7, 0xc7 },
{ 0x00, 0xc8, 0xc8 },
{ 0x00, 0xc9, 0xc9 },
{ 0x00, 0xca, 0xca },
{ 0x00, 0xcb, 0xcb },
{ 0x00, 0xcc, 0xcc },
{ 0x00, 0xcd, 0xcd },
{ 0x00, 0xce, 0xce },
{ 0x00, 0xcf, 0xcf },
{ 0x00, 0xd0, 0xd0 },
{ 0x00, 0xd1, 0xd1 },
{ 0x00, 0xd2, 0xd2 },
{ 0x00, 0xd3, 0xd3 },
{ 0x00, 0xd4, 0xd4 },
{ 0x00, 0xd5, 0xd5 },
{ 0x00, 0xd6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x00, 0xd8, 0xd8 },
{ 0x00, 0xd9, 0xd9 },
{ 0x00, 0xda, 0xda },
{ 0x00, 0xdb, 0xdb },
{ 0x00, 0xdc, 0xdc },
{ 0x00, 0xdd, 0xdd },
{ 0x00, 0xde, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xe0 },
{ 0x00, 0xe1, 0xe1 },
{ 0x00, 0xe2, 0xe2 },
{ 0x00, 0xe3, 0xe3 },
{ 0x00, 0xe4, 0xe4 },
{ 0x00, 0xe5, 0xe5 },
{ 0x00, 0xe6, 0xe6 },
{ 0x00, 0xe7, 0xe7 },
{ 0x00, 0xe8, 0xe8 },
{ 0x00, 0xe9, 0xe9 },
{ 0x00, 0xea, 0xea },
{ 0x00, 0xeb, 0xeb },
{ 0x00, 0xec, 0xec },
{ 0x00, 0xed, 0xed },
{ 0x00, 0xee, 0xee },
{ 0x00, 0xef, 0xef },
{ 0x00, 0xf0, 0xf0 },
{ 0x00, 0xf1, 0xf1 },
{ 0x00, 0xf2, 0xf2 },
{ 0x00, 0xf3, 0xf3 },
{ 0x00, 0xf4, 0xf4 },
{ 0x00, 0xf5, 0xf5 },
{ 0x00, 0xf6, 0xf6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xf8 },
{ 0x00, 0xf9, 0xf9 },
{ 0x00, 0xfa, 0xfa },
{ 0x00, 0xfb, 0xfb },
{ 0x00, 0xfc, 0xfc },
{ 0x00, 0xfd, 0xfd },
{ 0x00, 0xfe, 0xfe },
{ 0x00, 0xff, 0xff },
};

struct cs_info iso14_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x01, 0xa2, 0xa1 },
{ 0x00, 0xa2, 0xa1 },
{ 0x00, 0xa3, 0xa3 },
{ 0x01, 0xa5, 0xa4 },
{ 0x00, 0xa5, 0xa4 },
{ 0x01, 0xa6, 0xab },
{ 0x00, 0xa7, 0xa7 },
{ 0x01, 0xb8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x01, 0xba, 0xaa },
{ 0x00, 0xab, 0xa6 },
{ 0x01, 0xbc, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x01, 0xff, 0xaf },
{ 0x01, 0xb1, 0xb0 },
{ 0x00, 0xb1, 0xb0 },
{ 0x01, 0xb3, 0xb2 },
{ 0x00, 0xb3, 0xb2 },
{ 0x01, 0xb5, 0xb4 },
{ 0x00, 0xb5, 0xb4 },
{ 0x00, 0xb6, 0xb6 },
{ 0x01, 0xb9, 0xb7 },
{ 0x00, 0xb8, 0xa8 },
{ 0x00, 0xb9, 0xb6 },
{ 0x00, 0xba, 0xaa },
{ 0x01, 0xbf, 0xbb },
{ 0x00, 0xbc, 0xac },
{ 0x01, 0xbe, 0xbd },
{ 0x00, 0xbe, 0xbd },
{ 0x00, 0xbf, 0xbb },
{ 0x01, 0xe0, 0xc0 },
{ 0x01, 0xe1, 0xc1 },
{ 0x01, 0xe2, 0xc2 },
{ 0x01, 0xe3, 0xc3 },
{ 0x01, 0xe4, 0xc4 },
{ 0x01, 0xe5, 0xc5 },
{ 0x01, 0xe6, 0xc6 },
{ 0x01, 0xe7, 0xc7 },
{ 0x01, 0xe8, 0xc8 },
{ 0x01, 0xe9, 0xc9 },
{ 0x01, 0xea, 0xca },
{ 0x01, 0xeb, 0xcb },
{ 0x01, 0xec, 0xcc },
{ 0x01, 0xed, 0xcd },
{ 0x01, 0xee, 0xce },
{ 0x01, 0xef, 0xcf },
{ 0x01, 0xf0, 0xd0 },
{ 0x01, 0xf1, 0xd1 },
{ 0x01, 0xf2, 0xd2 },
{ 0x01, 0xf3, 0xd3 },
{ 0x01, 0xf4, 0xd4 },
{ 0x01, 0xf5, 0xd5 },
{ 0x01, 0xf6, 0xd6 },
{ 0x01, 0xf7, 0xd7 },
{ 0x01, 0xf8, 0xd8 },
{ 0x01, 0xf9, 0xd9 },
{ 0x01, 0xfa, 0xda },
{ 0x01, 0xfb, 0xdb },
{ 0x01, 0xfc, 0xdc },
{ 0x01, 0xfd, 0xdd },
{ 0x01, 0xfe, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xc0 },
{ 0x00, 0xe1, 0xc1 },
{ 0x00, 0xe2, 0xc2 },
{ 0x00, 0xe3, 0xc3 },
{ 0x00, 0xe4, 0xc4 },
{ 0x00, 0xe5, 0xc5 },
{ 0x00, 0xe6, 0xc6 },
{ 0x00, 0xe7, 0xc7 },
{ 0x00, 0xe8, 0xc8 },
{ 0x00, 0xe9, 0xc9 },
{ 0x00, 0xea, 0xca },
{ 0x00, 0xeb, 0xcb },
{ 0x00, 0xec, 0xcc },
{ 0x00, 0xed, 0xcd },
{ 0x00, 0xee, 0xce },
{ 0x00, 0xef, 0xcf },
{ 0x00, 0xf0, 0xd0 },
{ 0x00, 0xf1, 0xd1 },
{ 0x00, 0xf2, 0xd2 },
{ 0x00, 0xf3, 0xd3 },
{ 0x00, 0xf4, 0xd4 },
{ 0x00, 0xf5, 0xd5 },
{ 0x00, 0xf6, 0xd6 },
{ 0x00, 0xf7, 0xd7 },
{ 0x00, 0xf8, 0xd8 },
{ 0x00, 0xf9, 0xd9 },
{ 0x00, 0xfa, 0xda },
{ 0x00, 0xfb, 0xdb },
{ 0x00, 0xfc, 0xdc },
{ 0x00, 0xfd, 0xdd },
{ 0x00, 0xfe, 0xde },
{ 0x00, 0xff, 0xff },
};


struct cs_info iscii_devanagari_tbl[] = {
{ 0x00, 0x00, 0x00 },
{ 0x00, 0x01, 0x01 },
{ 0x00, 0x02, 0x02 },
{ 0x00, 0x03, 0x03 },
{ 0x00, 0x04, 0x04 },
{ 0x00, 0x05, 0x05 },
{ 0x00, 0x06, 0x06 },
{ 0x00, 0x07, 0x07 },
{ 0x00, 0x08, 0x08 },
{ 0x00, 0x09, 0x09 },
{ 0x00, 0x0a, 0x0a },
{ 0x00, 0x0b, 0x0b },
{ 0x00, 0x0c, 0x0c },
{ 0x00, 0x0d, 0x0d },
{ 0x00, 0x0e, 0x0e },
{ 0x00, 0x0f, 0x0f },
{ 0x00, 0x10, 0x10 },
{ 0x00, 0x11, 0x11 },
{ 0x00, 0x12, 0x12 },
{ 0x00, 0x13, 0x13 },
{ 0x00, 0x14, 0x14 },
{ 0x00, 0x15, 0x15 },
{ 0x00, 0x16, 0x16 },
{ 0x00, 0x17, 0x17 },
{ 0x00, 0x18, 0x18 },
{ 0x00, 0x19, 0x19 },
{ 0x00, 0x1a, 0x1a },
{ 0x00, 0x1b, 0x1b },
{ 0x00, 0x1c, 0x1c },
{ 0x00, 0x1d, 0x1d },
{ 0x00, 0x1e, 0x1e },
{ 0x00, 0x1f, 0x1f },
{ 0x00, 0x20, 0x20 },
{ 0x00, 0x21, 0x21 },
{ 0x00, 0x22, 0x22 },
{ 0x00, 0x23, 0x23 },
{ 0x00, 0x24, 0x24 },
{ 0x00, 0x25, 0x25 },
{ 0x00, 0x26, 0x26 },
{ 0x00, 0x27, 0x27 },
{ 0x00, 0x28, 0x28 },
{ 0x00, 0x29, 0x29 },
{ 0x00, 0x2a, 0x2a },
{ 0x00, 0x2b, 0x2b },
{ 0x00, 0x2c, 0x2c },
{ 0x00, 0x2d, 0x2d },
{ 0x00, 0x2e, 0x2e },
{ 0x00, 0x2f, 0x2f },
{ 0x00, 0x30, 0x30 },
{ 0x00, 0x31, 0x31 },
{ 0x00, 0x32, 0x32 },
{ 0x00, 0x33, 0x33 },
{ 0x00, 0x34, 0x34 },
{ 0x00, 0x35, 0x35 },
{ 0x00, 0x36, 0x36 },
{ 0x00, 0x37, 0x37 },
{ 0x00, 0x38, 0x38 },
{ 0x00, 0x39, 0x39 },
{ 0x00, 0x3a, 0x3a },
{ 0x00, 0x3b, 0x3b },
{ 0x00, 0x3c, 0x3c },
{ 0x00, 0x3d, 0x3d },
{ 0x00, 0x3e, 0x3e },
{ 0x00, 0x3f, 0x3f },
{ 0x00, 0x40, 0x40 },
{ 0x01, 0x61, 0x41 },
{ 0x01, 0x62, 0x42 },
{ 0x01, 0x63, 0x43 },
{ 0x01, 0x64, 0x44 },
{ 0x01, 0x65, 0x45 },
{ 0x01, 0x66, 0x46 },
{ 0x01, 0x67, 0x47 },
{ 0x01, 0x68, 0x48 },
{ 0x01, 0x69, 0x49 },
{ 0x01, 0x6a, 0x4a },
{ 0x01, 0x6b, 0x4b },
{ 0x01, 0x6c, 0x4c },
{ 0x01, 0x6d, 0x4d },
{ 0x01, 0x6e, 0x4e },
{ 0x01, 0x6f, 0x4f },
{ 0x01, 0x70, 0x50 },
{ 0x01, 0x71, 0x51 },
{ 0x01, 0x72, 0x52 },
{ 0x01, 0x73, 0x53 },
{ 0x01, 0x74, 0x54 },
{ 0x01, 0x75, 0x55 },
{ 0x01, 0x76, 0x56 },
{ 0x01, 0x77, 0x57 },
{ 0x01, 0x78, 0x58 },
{ 0x01, 0x79, 0x59 },
{ 0x01, 0x7a, 0x5a },
{ 0x00, 0x5b, 0x5b },
{ 0x00, 0x5c, 0x5c },
{ 0x00, 0x5d, 0x5d },
{ 0x00, 0x5e, 0x5e },
{ 0x00, 0x5f, 0x5f },
{ 0x00, 0x60, 0x60 },
{ 0x00, 0x61, 0x41 },
{ 0x00, 0x62, 0x42 },
{ 0x00, 0x63, 0x43 },
{ 0x00, 0x64, 0x44 },
{ 0x00, 0x65, 0x45 },
{ 0x00, 0x66, 0x46 },
{ 0x00, 0x67, 0x47 },
{ 0x00, 0x68, 0x48 },
{ 0x00, 0x69, 0x49 },
{ 0x00, 0x6a, 0x4a },
{ 0x00, 0x6b, 0x4b },
{ 0x00, 0x6c, 0x4c },
{ 0x00, 0x6d, 0x4d },
{ 0x00, 0x6e, 0x4e },
{ 0x00, 0x6f, 0x4f },
{ 0x00, 0x70, 0x50 },
{ 0x00, 0x71, 0x51 },
{ 0x00, 0x72, 0x52 },
{ 0x00, 0x73, 0x53 },
{ 0x00, 0x74, 0x54 },
{ 0x00, 0x75, 0x55 },
{ 0x00, 0x76, 0x56 },
{ 0x00, 0x77, 0x57 },
{ 0x00, 0x78, 0x58 },
{ 0x00, 0x79, 0x59 },
{ 0x00, 0x7a, 0x5a },
{ 0x00, 0x7b, 0x7b },
{ 0x00, 0x7c, 0x7c },
{ 0x00, 0x7d, 0x7d },
{ 0x00, 0x7e, 0x7e },
{ 0x00, 0x7f, 0x7f },
{ 0x00, 0x80, 0x80 },
{ 0x00, 0x81, 0x81 },
{ 0x00, 0x82, 0x82 },
{ 0x00, 0x83, 0x83 },
{ 0x00, 0x84, 0x84 },
{ 0x00, 0x85, 0x85 },
{ 0x00, 0x86, 0x86 },
{ 0x00, 0x87, 0x87 },
{ 0x00, 0x88, 0x88 },
{ 0x00, 0x89, 0x89 },
{ 0x00, 0x8a, 0x8a },
{ 0x00, 0x8b, 0x8b },
{ 0x00, 0x8c, 0x8c },
{ 0x00, 0x8d, 0x8d },
{ 0x00, 0x8e, 0x8e },
{ 0x00, 0x8f, 0x8f },
{ 0x00, 0x90, 0x90 },
{ 0x00, 0x91, 0x91 },
{ 0x00, 0x92, 0x92 },
{ 0x00, 0x93, 0x93 },
{ 0x00, 0x94, 0x94 },
{ 0x00, 0x95, 0x95 },
{ 0x00, 0x96, 0x96 },
{ 0x00, 0x97, 0x97 },
{ 0x00, 0x98, 0x98 },
{ 0x00, 0x99, 0x99 },
{ 0x00, 0x9a, 0x9a },
{ 0x00, 0x9b, 0x9b },
{ 0x00, 0x9c, 0x9c },
{ 0x00, 0x9d, 0x9d },
{ 0x00, 0x9e, 0x9e },
{ 0x00, 0x9f, 0x9f },
{ 0x00, 0xa0, 0xa0 },
{ 0x00, 0xa1, 0xa1 },
{ 0x00, 0xa2, 0xa2 },
{ 0x00, 0xa3, 0xa3 },
{ 0x00, 0xa4, 0xa4 },
{ 0x00, 0xa5, 0xa5 },
{ 0x00, 0xa6, 0xa6 },
{ 0x00, 0xa7, 0xa7 },
{ 0x00, 0xa8, 0xa8 },
{ 0x00, 0xa9, 0xa9 },
{ 0x00, 0xaa, 0xaa },
{ 0x00, 0xab, 0xab },
{ 0x00, 0xac, 0xac },
{ 0x00, 0xad, 0xad },
{ 0x00, 0xae, 0xae },
{ 0x00, 0xaf, 0xaf },
{ 0x00, 0xb0, 0xb0 },
{ 0x00, 0xb1, 0xb1 },
{ 0x00, 0xb2, 0xb2 },
{ 0x00, 0xb3, 0xb3 },
{ 0x00, 0xb4, 0xb4 },
{ 0x00, 0xb5, 0xb5 },
{ 0x00, 0xb6, 0xb6 },
{ 0x00, 0xb7, 0xb7 },
{ 0x00, 0xb8, 0xb8 },
{ 0x00, 0xb9, 0xb9 },
{ 0x00, 0xba, 0xba },
{ 0x00, 0xbb, 0xbb },
{ 0x00, 0xbc, 0xbc },
{ 0x00, 0xbd, 0xbd },
{ 0x00, 0xbe, 0xbe },
{ 0x00, 0xbf, 0xbf },
{ 0x00, 0xc0, 0xc0 },
{ 0x00, 0xc1, 0xc1 },
{ 0x00, 0xc2, 0xc2 },
{ 0x00, 0xc3, 0xc3 },
{ 0x00, 0xc4, 0xc4 },
{ 0x00, 0xc5, 0xc5 },
{ 0x00, 0xc6, 0xc6 },
{ 0x00, 0xc7, 0xc7 },
{ 0x00, 0xc8, 0xc8 },
{ 0x00, 0xc9, 0xc9 },
{ 0x00, 0xca, 0xca },
{ 0x00, 0xcb, 0xcb },
{ 0x00, 0xcc, 0xcc },
{ 0x00, 0xcd, 0xcd },
{ 0x00, 0xce, 0xce },
{ 0x00, 0xcf, 0xcf },
{ 0x00, 0xd0, 0xd0 },
{ 0x00, 0xd1, 0xd1 },
{ 0x00, 0xd2, 0xd2 },
{ 0x00, 0xd3, 0xd3 },
{ 0x00, 0xd4, 0xd4 },
{ 0x00, 0xd5, 0xd5 },
{ 0x00, 0xd6, 0xd6 },
{ 0x00, 0xd7, 0xd7 },
{ 0x00, 0xd8, 0xd8 },
{ 0x00, 0xd9, 0xd9 },
{ 0x00, 0xda, 0xda },
{ 0x00, 0xdb, 0xdb },
{ 0x00, 0xdc, 0xdc },
{ 0x00, 0xdd, 0xdd },
{ 0x00, 0xde, 0xde },
{ 0x00, 0xdf, 0xdf },
{ 0x00, 0xe0, 0xe0 },
{ 0x00, 0xe1, 0xe1 },
{ 0x00, 0xe2, 0xe2 },
{ 0x00, 0xe3, 0xe3 },
{ 0x00, 0xe4, 0xe4 },
{ 0x00, 0xe5, 0xe5 },
{ 0x00, 0xe6, 0xe6 },
{ 0x00, 0xe7, 0xe7 },
{ 0x00, 0xe8, 0xe8 },
{ 0x00, 0xe9, 0xe9 },
{ 0x00, 0xea, 0xea },
{ 0x00, 0xeb, 0xeb },
{ 0x00, 0xec, 0xec },
{ 0x00, 0xed, 0xed },
{ 0x00, 0xee, 0xee },
{ 0x00, 0xef, 0xef },
{ 0x00, 0xf0, 0xf0 },
{ 0x00, 0xf1, 0xf1 },
{ 0x00, 0xf2, 0xf2 },
{ 0x00, 0xf3, 0xf3 },
{ 0x00, 0xf4, 0xf4 },
{ 0x00, 0xf5, 0xf5 },
{ 0x00, 0xf6, 0xf6 },
{ 0x00, 0xf7, 0xf7 },
{ 0x00, 0xf8, 0xf8 },
{ 0x00, 0xf9, 0xf9 },
{ 0x00, 0xfa, 0xfa },
{ 0x00, 0xfb, 0xfb },
{ 0x00, 0xfc, 0xfc },
{ 0x00, 0xfd, 0xfd },
{ 0x00, 0xfe, 0xfe },
{ 0x00, 0xff, 0xff },
};



struct enc_entry encds[] = {
{"ISO8859-1",iso1_tbl},
{"ISO8859-2",iso2_tbl},
{"ISO8859-3",iso3_tbl},
{"ISO8859-4",iso4_tbl},
{"ISO8859-5",iso5_tbl},
{"ISO8859-6",iso6_tbl},
{"ISO8859-7",iso7_tbl},
{"ISO8859-8",iso8_tbl},
{"ISO8859-9",iso9_tbl},
{"ISO8859-10",iso10_tbl},
{"KOI8-R",koi8r_tbl},
{"CP-1251",cp1251_tbl},
{"ISO8859-14", iso14_tbl},
{"ISCII-DEVANAGARI", iscii_devanagari_tbl},
};


struct cs_info * get_current_cs(const char * es) {
  struct cs_info * ccs = encds[0].cs_table;
  int n = sizeof(encds) / sizeof(encds[0]);
  for (int i = 0; i < n; i++) {
    if (strcmp(es,encds[i].enc_name) == 0) {
      ccs = encds[i].cs_table;
    }
  }
  return ccs;
};



struct lang_map lang2enc[] = {
  {"ca","ISO8859-1"},
  {"cs","ISO8859-2"},
  {"da","ISO8859-1"},
  {"de","ISO8859-1"},
  {"el","ISO8859-7"},
  {"en","ISO8859-1"},
  {"es","ISO8859-1"},
  {"fr","ISO8859-1"},
  {"hr","ISO8859-2"},
  {"hu","ISO8859-2"},
  {"it","ISO8859-1"},
  {"la","ISO8859-1"},
  {"nl","ISO8859-1"},
  {"pl","ISO8859-2"},
  {"pt","ISO8859-1"},
  {"sv","ISO8859-1"},
  {"ru","KOI8-R"},
};


const char * get_default_enc(const char * lang) {
  int n = sizeof(lang2enc) / sizeof(lang2enc[0]);
  for (int i = 0; i < n; i++) {
    if (strcmp(lang,lang2enc[i].lang) == 0) {
      return lang2enc[i].def_enc;
    }
  }
  return NULL;
};

