
/* $Header:   U:/engineer/sw/t2r/filelib/calcclk.c_v   1.0   05 Nov 1992 17:05:04   galen  $
 */

#include "needed.h"
#include "number9.h"

#undef  MIN
#define MIN(a, b)               (((a) < (b)) ? (a) : (b))
#undef  MAX
#define MAX(a, b)               (((a) > (b)) ? (a) : (b))
#define CRYSTAL_FREQUENCY       (14318180 * 2)
#define MIN_VCO_FREQUENCY       50000000
#define MAX_POST_SCALE          285000000
#define MAX_NUMERATOR           130
#define MAX_DENOMINATOR         MIN(129, CRYSTAL_FREQUENCY / 400000)
#define MIN_DENOMINATOR         MAX(3, CRYSTAL_FREQUENCY / 2000000)

int clock_m;
int clock_n;
int clock_p;

/* Index register frequency ranges for ICD2061A chip */
static long     vclk_range[16] = {
                0, /* should be MIN_VCO_FREQUENCY, but that causes problems. */
         51000000,
         53200000,
         58500000,
         60700000,
         64400000,
         66800000,
         73500000,
         75600000,
         80900000,
         83200000,
         91500000,
        100000000,
        120000000,
        MAX_POST_SCALE,
                0,
        };

long
n9calc_clock(frequency, select)
register long   frequency;               /* in Hz */
int select;
{
  register long         clock_value;        /* 7bits M, 7bits N, 2bits P */
  register long         index;
  long                  temp;
  long                  min_m, min_n, min_diff;
  long                  diff;

  min_diff = 0xFFFFFFF;
  min_n = 1;
  min_m = 1;

  /* Calculate 18 bit clock value */
  clock_p = 0;
  if (frequency < MIN_VCO_FREQUENCY)
    clock_p = 1;
  if (frequency < MIN_VCO_FREQUENCY / 2)
    clock_p = 2;
  if (frequency < MIN_VCO_FREQUENCY / 4)
    clock_p = 3;
  frequency <<= clock_p;
  for (clock_n = 4; clock_n <= MAX_NUMERATOR; clock_n++)
    {
      index = CRYSTAL_FREQUENCY / (frequency / clock_n);
      if (index > MAX_DENOMINATOR)
        index = MAX_DENOMINATOR;
      if (index < MIN_DENOMINATOR)
        index = MIN_DENOMINATOR;
      for (clock_m = index - 3; clock_m < index + 4; clock_m++)
        if (clock_m >= MIN_DENOMINATOR && clock_m <= MAX_DENOMINATOR)
          {
            diff = (CRYSTAL_FREQUENCY / clock_m) * clock_n - frequency;
            if (diff < 0)
              diff = -diff;
            if (min_m * n9gcd(clock_m, clock_n) / n9gcd(min_m, min_n) == clock_m &&
              min_n * n9gcd(clock_m, clock_n) / n9gcd(min_m, min_n) == clock_n)
            if (diff > min_diff)
              diff = min_diff;
            if (diff <= min_diff)
              {
                min_diff = diff;
                min_m = clock_m;
                min_n = clock_n;
              }
          }
    }
  clock_m = min_m;
  clock_n = min_n;

  /* Calculate the index */
  temp = (((CRYSTAL_FREQUENCY / 2) * clock_n) / clock_m) << 1;
  for (index = 0; vclk_range[index + 1] < temp && index < 15; index++)
    ;

  /* Pack the clock value for the frequency snthesizer */
  temp = (((long)clock_n - 3) << 11) + ((clock_m - 2) << 1)
                + (clock_p << 8) + (index << 18) + ((long)select << 22);

  return temp;
}
