# Maintenance Terms

> Last Updated: 27 June 2025

The code, text, and other materials in this repository are provided as-is under
the terms of the repository's [`LICENSE.md`][0] file, as a gift to the commons
and the common good. In providing this software as-is, its author(s) admit no
further obligations from anyone using the software for any reason, particularly
with respect to:

* Releases,
* Response time,
* Change review and integration,
* Disclosure schedules,
* Discretionary, proprietary or otherwise secretive communications, and
* Any other non-contractual obligations or conventions, regardless of their
  presumed urgency or severity.

Should anyone wish to make a contract with me (Gavin Howard) to ensure that work
he or she deems critical gets done, the terms are as follows:

* Compute time will be charged at \$25/hr.
* My time will be charged at \$100/hr.
* All issues deemed critical by either me or the requester, that also change the
  source code (anything in `gen`, `include`, or `src`) will require at least two
  weeks of fuzzing without error.
	* If errors are found, those hours will still be charged on top of the final
	  two weeks.
* All changes will require running the [release script][2] on Linux (GCC), Linux
  (Clang), FreeBSD, OpenBSD, macOS, Windows.
* Any hours spent on bugs or code that have been, or are suspected to have been,
  generated by "AI" will be charged double rates.

Compute time includes, but is not limited to:

* Fuzzing.
* Running my [release script][2].
* Running tests and my [release script][2] on macOS.

My time includes, but is not limited to:

* Code review.
* Reading bug reports.
* Design.
* Coding.
* Any compute time that interferes with my ability to do any other work:
	* Fuzzing makes my computer unusable, so fuzzing for the 8-12 hours of the
	  day that I could be working will be charged at \$100/hr.
	* Same with running my [release script][2] because I run two instances on my
	  machine and two in VMs at the same time.
	* Running my [release script][2] or any other compute time on Windows
	  because Windows blocks me from doing my main work on Linux.
	* Any other instances of blocking compute time.

All amounts will be billed by, and paid to, [Yzena, LLC][2]. Invoices will be
provided, including line items for what each hour was spent on.

It is suggested that the following amounts be budgeted:

* At least \$3000 for a non-critical issue or change.

  The release script takes about 10 hours, and I would need to run it once on
  Linux (and others at the same time) and once on Windows, which is 20 hours.
  Most of that won't be at the \$100/hr rate, but some probably will be. Then
  an extra \$1000 for other work.

* At least \$15,000 for a critical issue or change.

  The \$3000 above is the start, which leaves \$12,000. Fuzzing is expected to
  cost \$11,400 (6 days a week, 8 hours a day, at \$100, the rest at \$25), and
  rounded up to \$12,000 for good measure.

---

This document is inspired by [Mike Hoye's Maintenance Terms][1].

[0]: LICENSE.md
[1]: https://github.com/mhoye/maintenance-terms
[2]: scripts/release.sh
[3]: https://yzena.com/
