# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Logging
      module V2
        # An individual entry in a log.
        # @!attribute [rw] log_name
        #   @return [::String]
        #     Required. The resource name of the log to which this log entry belongs:
        #
        #         "projects/[PROJECT_ID]/logs/[LOG_ID]"
        #         "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
        #         "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
        #         "folders/[FOLDER_ID]/logs/[LOG_ID]"
        #
        #     A project number may be used in place of PROJECT_ID. The project number is
        #     translated to its corresponding PROJECT_ID internally and the `log_name`
        #     field will contain PROJECT_ID in queries and exports.
        #
        #     `[LOG_ID]` must be URL-encoded within `log_name`. Example:
        #     `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
        #
        #     `[LOG_ID]` must be less than 512 characters long and can only include the
        #     following characters: upper and lower case alphanumeric characters,
        #     forward-slash, underscore, hyphen, and period.
        #
        #     For backward compatibility, if `log_name` begins with a forward-slash, such
        #     as `/projects/...`, then the log entry is ingested as usual, but the
        #     forward-slash is removed. Listing the log entry will not show the leading
        #     slash and filtering for a log name with a leading slash will never return
        #     any results.
        # @!attribute [rw] resource
        #   @return [::Google::Api::MonitoredResource]
        #     Required. The monitored resource that produced this log entry.
        #
        #     Example: a log entry that reports a database error would be associated with
        #     the monitored resource designating the particular database that reported
        #     the error.
        # @!attribute [rw] proto_payload
        #   @return [::Google::Protobuf::Any]
        #     The log entry payload, represented as a protocol buffer. Some Google
        #     Cloud Platform services use this field for their log entry payloads.
        #
        #     The following protocol buffer types are supported; user-defined types
        #     are not supported:
        #
        #       "type.googleapis.com/google.cloud.audit.AuditLog"
        #       "type.googleapis.com/google.appengine.logging.v1.RequestLog"
        #
        #     Note: The following fields are mutually exclusive: `proto_payload`, `text_payload`, `json_payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_payload
        #   @return [::String]
        #     The log entry payload, represented as a Unicode string (UTF-8).
        #
        #     Note: The following fields are mutually exclusive: `text_payload`, `proto_payload`, `json_payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] json_payload
        #   @return [::Google::Protobuf::Struct]
        #     The log entry payload, represented as a structure that is
        #     expressed as a JSON object.
        #
        #     Note: The following fields are mutually exclusive: `json_payload`, `proto_payload`, `text_payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The time the event described by the log entry occurred. This time
        #     is used to compute the log entry's age and to enforce the logs retention
        #     period. If this field is omitted in a new log entry, then Logging assigns
        #     it the current time. Timestamps have nanosecond accuracy, but trailing
        #     zeros in the fractional seconds might be omitted when the timestamp is
        #     displayed.
        #
        #     Incoming log entries must have timestamps that don't exceed the
        #     [logs retention
        #     period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
        #     the past, and that don't exceed 24 hours in the future. Log entries outside
        #     those time boundaries aren't ingested by Logging.
        # @!attribute [r] receive_timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the log entry was received by Logging.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::Logging::Type::LogSeverity]
        #     Optional. The severity of the log entry. The default value is
        #     `LogSeverity.DEFAULT`.
        # @!attribute [rw] insert_id
        #   @return [::String]
        #     Optional. A unique identifier for the log entry. If you provide a value,
        #     then Logging considers other log entries in the same project, with the same
        #     `timestamp`, and with the same `insert_id` to be duplicates which are
        #     removed in a single query result. However, there are no guarantees of
        #     de-duplication in the export of logs.
        #
        #     If the `insert_id` is omitted when writing a log entry, the Logging API
        #     assigns its own unique identifier in this field.
        #
        #     In queries, the `insert_id` is also used to order log entries that have
        #     the same `log_name` and `timestamp` values.
        # @!attribute [rw] http_request
        #   @return [::Google::Cloud::Logging::Type::HttpRequest]
        #     Optional. Information about the HTTP request associated with this log
        #     entry, if applicable.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. A map of key, value pairs that provides additional information
        #     about the log entry. The labels can be user-defined or system-defined.
        #
        #     User-defined labels are arbitrary key, value pairs that you can use to
        #     classify logs.
        #
        #     System-defined labels are defined by GCP services for platform logs.
        #     They have two components - a service namespace component and the
        #     attribute name. For example: `compute.googleapis.com/resource_name`.
        #
        #     Cloud Logging truncates label keys that exceed 512 B and label
        #     values that exceed 64 KB upon their associated log entry being
        #     written. The truncation is indicated by an ellipsis at the
        #     end of the character string.
        # @!attribute [rw] operation
        #   @return [::Google::Cloud::Logging::V2::LogEntryOperation]
        #     Optional. Information about an operation associated with the log entry, if
        #     applicable.
        # @!attribute [rw] trace
        #   @return [::String]
        #     Optional. The REST resource name of the trace being written to
        #     [Cloud Trace](https://cloud.google.com/trace) in
        #     association with this log entry. For example, if your trace data is stored
        #     in the Cloud project "my-trace-project" and if the service that is creating
        #     the log entry receives a trace header that includes the trace ID "12345",
        #     then the service should use "projects/my-tracing-project/traces/12345".
        #
        #     The `trace` field provides the link between logs and traces. By using
        #     this field, you can navigate from a log entry to a trace.
        # @!attribute [rw] span_id
        #   @return [::String]
        #     Optional. The ID of the [Cloud Trace](https://cloud.google.com/trace) span
        #     associated with the current operation in which the log is being written.
        #     For example, if a span has the REST resource name of
        #     "projects/some-project/traces/some-trace/spans/some-span-id", then the
        #     `span_id` field is "some-span-id".
        #
        #     A
        #     [Span](https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
        #     represents a single operation within a trace. Whereas a trace may involve
        #     multiple different microservices running on multiple different machines,
        #     a span generally corresponds to a single logical operation being performed
        #     in a single instance of a microservice on one specific machine. Spans
        #     are the nodes within the tree that is a trace.
        #
        #     Applications that are [instrumented for
        #     tracing](https://cloud.google.com/trace/docs/setup) will generally assign a
        #     new, unique span ID on each incoming request. It is also common to create
        #     and record additional spans corresponding to internal processing elements
        #     as well as issuing requests to dependencies.
        #
        #     The span ID is expected to be a 16-character, hexadecimal encoding of an
        #     8-byte array and should not be zero. It should be unique within the trace
        #     and should, ideally, be generated in a manner that is uniformly random.
        #
        #     Example values:
        #
        #       - `000000000000004a`
        #       - `7a2190356c3fc94b`
        #       - `0000f00300090021`
        #       - `d39223e101960076`
        # @!attribute [rw] trace_sampled
        #   @return [::Boolean]
        #     Optional. The sampling decision of the trace associated with the log entry.
        #
        #     True means that the trace resource name in the `trace` field was sampled
        #     for storage in a trace backend. False means that the trace was not sampled
        #     for storage when this log entry was written, or the sampling decision was
        #     unknown at the time. A non-sampled `trace` value is still useful as a
        #     request correlation identifier. The default is False.
        # @!attribute [rw] source_location
        #   @return [::Google::Cloud::Logging::V2::LogEntrySourceLocation]
        #     Optional. Source code location information associated with the log entry,
        #     if any.
        # @!attribute [rw] split
        #   @return [::Google::Cloud::Logging::V2::LogSplit]
        #     Optional. Information indicating this LogEntry is part of a sequence of
        #     multiple log entries split from a single LogEntry.
        class LogEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Additional information about a potentially long-running operation with which
        # a log entry is associated.
        # @!attribute [rw] id
        #   @return [::String]
        #     Optional. An arbitrary operation identifier. Log entries with the same
        #     identifier are assumed to be part of the same operation.
        # @!attribute [rw] producer
        #   @return [::String]
        #     Optional. An arbitrary producer identifier. The combination of `id` and
        #     `producer` must be globally unique. Examples for `producer`:
        #     `"MyDivision.MyBigCompany.com"`, `"github.com/MyProject/MyApplication"`.
        # @!attribute [rw] first
        #   @return [::Boolean]
        #     Optional. Set this to True if this is the first log entry in the operation.
        # @!attribute [rw] last
        #   @return [::Boolean]
        #     Optional. Set this to True if this is the last log entry in the operation.
        class LogEntryOperation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional information about the source code location that produced the log
        # entry.
        # @!attribute [rw] file
        #   @return [::String]
        #     Optional. Source file name. Depending on the runtime environment, this
        #     might be a simple name or a fully-qualified name.
        # @!attribute [rw] line
        #   @return [::Integer]
        #     Optional. Line within the source file. 1-based; 0 indicates no line number
        #     available.
        # @!attribute [rw] function
        #   @return [::String]
        #     Optional. Human-readable name of the function or method being invoked, with
        #     optional context such as the class or package name. This information may be
        #     used in contexts such as the logs viewer, where a file and line number are
        #     less meaningful. The format can vary by language. For example:
        #     `qual.if.ied.Class.method` (Java), `dir/package.func` (Go), `function`
        #     (Python).
        class LogEntrySourceLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional information used to correlate multiple log entries. Used when a
        # single LogEntry would exceed the Google Cloud Logging size limit and is
        # split across multiple log entries.
        # @!attribute [rw] uid
        #   @return [::String]
        #     A globally unique identifier for all log entries in a sequence of split log
        #     entries. All log entries with the same |LogSplit.uid| are assumed to be
        #     part of the same sequence of split log entries.
        # @!attribute [rw] index
        #   @return [::Integer]
        #     The index of this LogEntry in the sequence of split log entries. Log
        #     entries are given |index| values 0, 1, ..., n-1 for a sequence of n log
        #     entries.
        # @!attribute [rw] total_splits
        #   @return [::Integer]
        #     The total number of log entries that the original LogEntry was split into.
        class LogSplit
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
