# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class EsimProfileTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.esim_profiles.create(eid="eid")

        values = {'Eid': "eid", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://supersim.twilio.com/v1/ESimProfiles',
            data=values,
        ))

    def test_create_default_smdp_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "sid": "HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "iccid": null,
                "sim_sid": null,
                "status": "reserving",
                "eid": "89049032005008882600033489aaaaaa",
                "smdp_plus_address": null,
                "error_code": null,
                "error_message": null,
                "date_created": "2020-09-01T20:00:00Z",
                "date_updated": "2020-09-01T20:00:00Z",
                "url": "https://supersim.twilio.com/v1/ESimProfiles/HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.supersim.v1.esim_profiles.create(eid="eid")

        self.assertIsNotNone(actual)

    def test_create_with_callback_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "sid": "HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "iccid": null,
                "sim_sid": null,
                "status": "reserving",
                "eid": "89049032005008882600033489aaaaaa",
                "smdp_plus_address": null,
                "error_code": null,
                "error_message": null,
                "date_created": "2020-09-01T20:00:00Z",
                "date_updated": "2020-09-01T20:00:00Z",
                "url": "https://supersim.twilio.com/v1/ESimProfiles/HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.supersim.v1.esim_profiles.create(eid="eid")

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.esim_profiles("HPXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://supersim.twilio.com/v1/ESimProfiles/HPXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "sid": "HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "iccid": "8988307aaaaaaaaaaaaa",
                "sim_sid": "HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "status": "available",
                "eid": "89049032005008882600033489aaaaaa",
                "smdp_plus_address": "https://sm-dp-plus.twilio.com",
                "error_code": null,
                "error_message": null,
                "date_created": "2020-09-01T20:00:00Z",
                "date_updated": "2020-09-01T20:00:00Z",
                "url": "https://supersim.twilio.com/v1/ESimProfiles/HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.supersim.v1.esim_profiles("HPXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.esim_profiles.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://supersim.twilio.com/v1/ESimProfiles',
        ))

    def test_read_all_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "esim_profiles": [
                    {
                        "sid": "HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "iccid": "8988307aaaaaaaaaaaaa",
                        "sim_sid": "HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "status": "available",
                        "eid": "89049032005008882600033489aaaaaa",
                        "smdp_plus_address": "https://sm-dp-plus.twilio.com",
                        "error_code": null,
                        "error_message": null,
                        "date_created": "2020-09-01T20:00:00Z",
                        "date_updated": "2020-09-01T20:00:00Z",
                        "url": "https://supersim.twilio.com/v1/ESimProfiles/HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "first_page_url": "https://supersim.twilio.com/v1/ESimProfiles?PageSize=50&Page=0",
                    "key": "esim_profiles",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/ESimProfiles?PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.esim_profiles.list()

        self.assertIsNotNone(actual)

    def test_read_by_eid_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "esim_profiles": [
                    {
                        "sid": "HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "iccid": "8988307aaaaaaaaaaaaa",
                        "sim_sid": "HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "status": "available",
                        "eid": "89049032005008882600033489aaaaaa",
                        "smdp_plus_address": "https://sm-dp-plus.twilio.com",
                        "error_code": null,
                        "error_message": null,
                        "date_created": "2020-09-01T20:00:00Z",
                        "date_updated": "2020-09-01T20:00:00Z",
                        "url": "https://supersim.twilio.com/v1/ESimProfiles/HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "first_page_url": "https://supersim.twilio.com/v1/ESimProfiles?Eid=89049032005008882600033489aaaaaa&PageSize=50&Page=0",
                    "key": "esim_profiles",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/ESimProfiles?Eid=89049032005008882600033489aaaaaa&PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.esim_profiles.list()

        self.assertIsNotNone(actual)

    def test_read_by_sim_sid_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "esim_profiles": [
                    {
                        "sid": "HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "iccid": "8988307aaaaaaaaaaaaa",
                        "sim_sid": "HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "status": "available",
                        "eid": "89049032005008882600033489aaaaaa",
                        "smdp_plus_address": "https://sm-dp-plus.twilio.com",
                        "error_code": null,
                        "error_message": null,
                        "date_created": "2020-09-01T20:00:00Z",
                        "date_updated": "2020-09-01T20:00:00Z",
                        "url": "https://supersim.twilio.com/v1/ESimProfiles/HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "first_page_url": "https://supersim.twilio.com/v1/ESimProfiles?SimSid=HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa&PageSize=50&Page=0",
                    "key": "esim_profiles",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/ESimProfiles?SimSid=HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa&PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.esim_profiles.list()

        self.assertIsNotNone(actual)

    def test_read_by_status_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "esim_profiles": [
                    {
                        "sid": "HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "iccid": "8988307aaaaaaaaaaaaa",
                        "sim_sid": "HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "status": "downloaded",
                        "eid": "89049032005008882600033489aaaaaa",
                        "smdp_plus_address": "https://sm-dp-plus.twilio.com",
                        "error_code": null,
                        "error_message": null,
                        "date_created": "2020-09-01T20:00:00Z",
                        "date_updated": "2020-09-01T20:00:00Z",
                        "url": "https://supersim.twilio.com/v1/ESimProfiles/HPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "first_page_url": "https://supersim.twilio.com/v1/ESimProfiles?Status=downloaded&PageSize=50&Page=0",
                    "key": "esim_profiles",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/ESimProfiles?Status=downloaded&PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.esim_profiles.list()

        self.assertIsNotNone(actual)
