# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import ApiManagementClientConfiguration
from .operations import (
    AllPoliciesOperations,
    ApiDiagnosticOperations,
    ApiExportOperations,
    ApiGatewayConfigConnectionOperations,
    ApiGatewayOperations,
    ApiIssueAttachmentOperations,
    ApiIssueCommentOperations,
    ApiIssueOperations,
    ApiManagementClientOperationsMixin,
    ApiManagementGatewaySkusOperations,
    ApiManagementOperationsOperations,
    ApiManagementServiceOperations,
    ApiManagementServiceSkusOperations,
    ApiManagementSkusOperations,
    ApiManagementWorkspaceLinkOperations,
    ApiManagementWorkspaceLinksOperations,
    ApiOperationOperations,
    ApiOperationPolicyOperations,
    ApiOperations,
    ApiPolicyOperations,
    ApiProductOperations,
    ApiReleaseOperations,
    ApiRevisionOperations,
    ApiSchemaOperations,
    ApiTagDescriptionOperations,
    ApiVersionSetOperations,
    ApiWikiOperations,
    ApiWikisOperations,
    AuthorizationAccessPolicyOperations,
    AuthorizationLoginLinksOperations,
    AuthorizationOperations,
    AuthorizationProviderOperations,
    AuthorizationServerOperations,
    BackendOperations,
    CacheOperations,
    CertificateOperations,
    ContentItemOperations,
    ContentTypeOperations,
    DelegationSettingsOperations,
    DeletedServicesOperations,
    DiagnosticOperations,
    DocumentationOperations,
    EmailTemplateOperations,
    GatewayApiOperations,
    GatewayCertificateAuthorityOperations,
    GatewayHostnameConfigurationOperations,
    GatewayOperations,
    GlobalSchemaOperations,
    GraphQLApiResolverOperations,
    GraphQLApiResolverPolicyOperations,
    GroupOperations,
    GroupUserOperations,
    IdentityProviderOperations,
    IssueOperations,
    LoggerOperations,
    NamedValueOperations,
    NetworkStatusOperations,
    NotificationOperations,
    NotificationRecipientEmailOperations,
    NotificationRecipientUserOperations,
    OpenIdConnectProviderOperations,
    OperationOperations,
    OperationStatusOperations,
    OperationsResultsOperations,
    OutboundNetworkDependenciesEndpointsOperations,
    PolicyDescriptionOperations,
    PolicyFragmentOperations,
    PolicyOperations,
    PolicyRestrictionOperations,
    PolicyRestrictionValidationsOperations,
    PortalConfigOperations,
    PortalRevisionOperations,
    PortalSettingsOperations,
    PrivateEndpointConnectionOperations,
    ProductApiLinkOperations,
    ProductApiOperations,
    ProductGroupLinkOperations,
    ProductGroupOperations,
    ProductOperations,
    ProductPolicyOperations,
    ProductSubscriptionsOperations,
    ProductWikiOperations,
    ProductWikisOperations,
    QuotaByCounterKeysOperations,
    QuotaByPeriodKeysOperations,
    RegionOperations,
    ReportsOperations,
    SignInSettingsOperations,
    SignUpSettingsOperations,
    SubscriptionOperations,
    TagApiLinkOperations,
    TagOperationLinkOperations,
    TagOperations,
    TagProductLinkOperations,
    TagResourceOperations,
    TenantAccessGitOperations,
    TenantAccessOperations,
    TenantConfigurationOperations,
    TenantSettingsOperations,
    UserConfirmationPasswordOperations,
    UserGroupOperations,
    UserIdentitiesOperations,
    UserOperations,
    UserSubscriptionOperations,
    WorkspaceApiDiagnosticOperations,
    WorkspaceApiExportOperations,
    WorkspaceApiOperationOperations,
    WorkspaceApiOperationPolicyOperations,
    WorkspaceApiOperations,
    WorkspaceApiPolicyOperations,
    WorkspaceApiReleaseOperations,
    WorkspaceApiRevisionOperations,
    WorkspaceApiSchemaOperations,
    WorkspaceApiVersionSetOperations,
    WorkspaceBackendOperations,
    WorkspaceCertificateOperations,
    WorkspaceDiagnosticOperations,
    WorkspaceGlobalSchemaOperations,
    WorkspaceGroupOperations,
    WorkspaceGroupUserOperations,
    WorkspaceLoggerOperations,
    WorkspaceNamedValueOperations,
    WorkspaceNotificationOperations,
    WorkspaceNotificationRecipientEmailOperations,
    WorkspaceNotificationRecipientUserOperations,
    WorkspaceOperations,
    WorkspacePolicyFragmentOperations,
    WorkspacePolicyOperations,
    WorkspaceProductApiLinkOperations,
    WorkspaceProductGroupLinkOperations,
    WorkspaceProductOperations,
    WorkspaceProductPolicyOperations,
    WorkspaceSubscriptionOperations,
    WorkspaceTagApiLinkOperations,
    WorkspaceTagOperationLinkOperations,
    WorkspaceTagOperations,
    WorkspaceTagProductLinkOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials_async import AsyncTokenCredential


class ApiManagementClient(ApiManagementClientOperationsMixin):  # pylint: disable=too-many-instance-attributes
    """ApiManagement Client.

    :ivar api_gateway: ApiGatewayOperations operations
    :vartype api_gateway: azure.mgmt.apimanagement.aio.operations.ApiGatewayOperations
    :ivar api_management_gateway_skus: ApiManagementGatewaySkusOperations operations
    :vartype api_management_gateway_skus:
     azure.mgmt.apimanagement.aio.operations.ApiManagementGatewaySkusOperations
    :ivar all_policies: AllPoliciesOperations operations
    :vartype all_policies: azure.mgmt.apimanagement.aio.operations.AllPoliciesOperations
    :ivar api: ApiOperations operations
    :vartype api: azure.mgmt.apimanagement.aio.operations.ApiOperations
    :ivar api_revision: ApiRevisionOperations operations
    :vartype api_revision: azure.mgmt.apimanagement.aio.operations.ApiRevisionOperations
    :ivar api_release: ApiReleaseOperations operations
    :vartype api_release: azure.mgmt.apimanagement.aio.operations.ApiReleaseOperations
    :ivar api_operation: ApiOperationOperations operations
    :vartype api_operation: azure.mgmt.apimanagement.aio.operations.ApiOperationOperations
    :ivar api_operation_policy: ApiOperationPolicyOperations operations
    :vartype api_operation_policy:
     azure.mgmt.apimanagement.aio.operations.ApiOperationPolicyOperations
    :ivar tag: TagOperations operations
    :vartype tag: azure.mgmt.apimanagement.aio.operations.TagOperations
    :ivar graph_ql_api_resolver: GraphQLApiResolverOperations operations
    :vartype graph_ql_api_resolver:
     azure.mgmt.apimanagement.aio.operations.GraphQLApiResolverOperations
    :ivar graph_ql_api_resolver_policy: GraphQLApiResolverPolicyOperations operations
    :vartype graph_ql_api_resolver_policy:
     azure.mgmt.apimanagement.aio.operations.GraphQLApiResolverPolicyOperations
    :ivar api_product: ApiProductOperations operations
    :vartype api_product: azure.mgmt.apimanagement.aio.operations.ApiProductOperations
    :ivar api_policy: ApiPolicyOperations operations
    :vartype api_policy: azure.mgmt.apimanagement.aio.operations.ApiPolicyOperations
    :ivar api_schema: ApiSchemaOperations operations
    :vartype api_schema: azure.mgmt.apimanagement.aio.operations.ApiSchemaOperations
    :ivar api_diagnostic: ApiDiagnosticOperations operations
    :vartype api_diagnostic: azure.mgmt.apimanagement.aio.operations.ApiDiagnosticOperations
    :ivar api_issue: ApiIssueOperations operations
    :vartype api_issue: azure.mgmt.apimanagement.aio.operations.ApiIssueOperations
    :ivar api_issue_comment: ApiIssueCommentOperations operations
    :vartype api_issue_comment: azure.mgmt.apimanagement.aio.operations.ApiIssueCommentOperations
    :ivar api_issue_attachment: ApiIssueAttachmentOperations operations
    :vartype api_issue_attachment:
     azure.mgmt.apimanagement.aio.operations.ApiIssueAttachmentOperations
    :ivar api_tag_description: ApiTagDescriptionOperations operations
    :vartype api_tag_description:
     azure.mgmt.apimanagement.aio.operations.ApiTagDescriptionOperations
    :ivar operation: OperationOperations operations
    :vartype operation: azure.mgmt.apimanagement.aio.operations.OperationOperations
    :ivar api_wiki: ApiWikiOperations operations
    :vartype api_wiki: azure.mgmt.apimanagement.aio.operations.ApiWikiOperations
    :ivar api_wikis: ApiWikisOperations operations
    :vartype api_wikis: azure.mgmt.apimanagement.aio.operations.ApiWikisOperations
    :ivar api_export: ApiExportOperations operations
    :vartype api_export: azure.mgmt.apimanagement.aio.operations.ApiExportOperations
    :ivar api_version_set: ApiVersionSetOperations operations
    :vartype api_version_set: azure.mgmt.apimanagement.aio.operations.ApiVersionSetOperations
    :ivar authorization_provider: AuthorizationProviderOperations operations
    :vartype authorization_provider:
     azure.mgmt.apimanagement.aio.operations.AuthorizationProviderOperations
    :ivar authorization: AuthorizationOperations operations
    :vartype authorization: azure.mgmt.apimanagement.aio.operations.AuthorizationOperations
    :ivar authorization_login_links: AuthorizationLoginLinksOperations operations
    :vartype authorization_login_links:
     azure.mgmt.apimanagement.aio.operations.AuthorizationLoginLinksOperations
    :ivar authorization_access_policy: AuthorizationAccessPolicyOperations operations
    :vartype authorization_access_policy:
     azure.mgmt.apimanagement.aio.operations.AuthorizationAccessPolicyOperations
    :ivar authorization_server: AuthorizationServerOperations operations
    :vartype authorization_server:
     azure.mgmt.apimanagement.aio.operations.AuthorizationServerOperations
    :ivar backend: BackendOperations operations
    :vartype backend: azure.mgmt.apimanagement.aio.operations.BackendOperations
    :ivar cache: CacheOperations operations
    :vartype cache: azure.mgmt.apimanagement.aio.operations.CacheOperations
    :ivar certificate: CertificateOperations operations
    :vartype certificate: azure.mgmt.apimanagement.aio.operations.CertificateOperations
    :ivar content_type: ContentTypeOperations operations
    :vartype content_type: azure.mgmt.apimanagement.aio.operations.ContentTypeOperations
    :ivar content_item: ContentItemOperations operations
    :vartype content_item: azure.mgmt.apimanagement.aio.operations.ContentItemOperations
    :ivar deleted_services: DeletedServicesOperations operations
    :vartype deleted_services: azure.mgmt.apimanagement.aio.operations.DeletedServicesOperations
    :ivar api_management_operations: ApiManagementOperationsOperations operations
    :vartype api_management_operations:
     azure.mgmt.apimanagement.aio.operations.ApiManagementOperationsOperations
    :ivar api_management_service_skus: ApiManagementServiceSkusOperations operations
    :vartype api_management_service_skus:
     azure.mgmt.apimanagement.aio.operations.ApiManagementServiceSkusOperations
    :ivar api_management_service: ApiManagementServiceOperations operations
    :vartype api_management_service:
     azure.mgmt.apimanagement.aio.operations.ApiManagementServiceOperations
    :ivar diagnostic: DiagnosticOperations operations
    :vartype diagnostic: azure.mgmt.apimanagement.aio.operations.DiagnosticOperations
    :ivar documentation: DocumentationOperations operations
    :vartype documentation: azure.mgmt.apimanagement.aio.operations.DocumentationOperations
    :ivar email_template: EmailTemplateOperations operations
    :vartype email_template: azure.mgmt.apimanagement.aio.operations.EmailTemplateOperations
    :ivar api_gateway_config_connection: ApiGatewayConfigConnectionOperations operations
    :vartype api_gateway_config_connection:
     azure.mgmt.apimanagement.aio.operations.ApiGatewayConfigConnectionOperations
    :ivar gateway: GatewayOperations operations
    :vartype gateway: azure.mgmt.apimanagement.aio.operations.GatewayOperations
    :ivar gateway_hostname_configuration: GatewayHostnameConfigurationOperations operations
    :vartype gateway_hostname_configuration:
     azure.mgmt.apimanagement.aio.operations.GatewayHostnameConfigurationOperations
    :ivar gateway_api: GatewayApiOperations operations
    :vartype gateway_api: azure.mgmt.apimanagement.aio.operations.GatewayApiOperations
    :ivar gateway_certificate_authority: GatewayCertificateAuthorityOperations operations
    :vartype gateway_certificate_authority:
     azure.mgmt.apimanagement.aio.operations.GatewayCertificateAuthorityOperations
    :ivar group: GroupOperations operations
    :vartype group: azure.mgmt.apimanagement.aio.operations.GroupOperations
    :ivar group_user: GroupUserOperations operations
    :vartype group_user: azure.mgmt.apimanagement.aio.operations.GroupUserOperations
    :ivar identity_provider: IdentityProviderOperations operations
    :vartype identity_provider: azure.mgmt.apimanagement.aio.operations.IdentityProviderOperations
    :ivar issue: IssueOperations operations
    :vartype issue: azure.mgmt.apimanagement.aio.operations.IssueOperations
    :ivar logger: LoggerOperations operations
    :vartype logger: azure.mgmt.apimanagement.aio.operations.LoggerOperations
    :ivar named_value: NamedValueOperations operations
    :vartype named_value: azure.mgmt.apimanagement.aio.operations.NamedValueOperations
    :ivar network_status: NetworkStatusOperations operations
    :vartype network_status: azure.mgmt.apimanagement.aio.operations.NetworkStatusOperations
    :ivar notification: NotificationOperations operations
    :vartype notification: azure.mgmt.apimanagement.aio.operations.NotificationOperations
    :ivar notification_recipient_user: NotificationRecipientUserOperations operations
    :vartype notification_recipient_user:
     azure.mgmt.apimanagement.aio.operations.NotificationRecipientUserOperations
    :ivar notification_recipient_email: NotificationRecipientEmailOperations operations
    :vartype notification_recipient_email:
     azure.mgmt.apimanagement.aio.operations.NotificationRecipientEmailOperations
    :ivar open_id_connect_provider: OpenIdConnectProviderOperations operations
    :vartype open_id_connect_provider:
     azure.mgmt.apimanagement.aio.operations.OpenIdConnectProviderOperations
    :ivar outbound_network_dependencies_endpoints: OutboundNetworkDependenciesEndpointsOperations
     operations
    :vartype outbound_network_dependencies_endpoints:
     azure.mgmt.apimanagement.aio.operations.OutboundNetworkDependenciesEndpointsOperations
    :ivar policy: PolicyOperations operations
    :vartype policy: azure.mgmt.apimanagement.aio.operations.PolicyOperations
    :ivar policy_description: PolicyDescriptionOperations operations
    :vartype policy_description:
     azure.mgmt.apimanagement.aio.operations.PolicyDescriptionOperations
    :ivar policy_fragment: PolicyFragmentOperations operations
    :vartype policy_fragment: azure.mgmt.apimanagement.aio.operations.PolicyFragmentOperations
    :ivar policy_restriction: PolicyRestrictionOperations operations
    :vartype policy_restriction:
     azure.mgmt.apimanagement.aio.operations.PolicyRestrictionOperations
    :ivar policy_restriction_validations: PolicyRestrictionValidationsOperations operations
    :vartype policy_restriction_validations:
     azure.mgmt.apimanagement.aio.operations.PolicyRestrictionValidationsOperations
    :ivar portal_config: PortalConfigOperations operations
    :vartype portal_config: azure.mgmt.apimanagement.aio.operations.PortalConfigOperations
    :ivar portal_revision: PortalRevisionOperations operations
    :vartype portal_revision: azure.mgmt.apimanagement.aio.operations.PortalRevisionOperations
    :ivar portal_settings: PortalSettingsOperations operations
    :vartype portal_settings: azure.mgmt.apimanagement.aio.operations.PortalSettingsOperations
    :ivar sign_in_settings: SignInSettingsOperations operations
    :vartype sign_in_settings: azure.mgmt.apimanagement.aio.operations.SignInSettingsOperations
    :ivar sign_up_settings: SignUpSettingsOperations operations
    :vartype sign_up_settings: azure.mgmt.apimanagement.aio.operations.SignUpSettingsOperations
    :ivar delegation_settings: DelegationSettingsOperations operations
    :vartype delegation_settings:
     azure.mgmt.apimanagement.aio.operations.DelegationSettingsOperations
    :ivar private_endpoint_connection: PrivateEndpointConnectionOperations operations
    :vartype private_endpoint_connection:
     azure.mgmt.apimanagement.aio.operations.PrivateEndpointConnectionOperations
    :ivar product: ProductOperations operations
    :vartype product: azure.mgmt.apimanagement.aio.operations.ProductOperations
    :ivar product_api: ProductApiOperations operations
    :vartype product_api: azure.mgmt.apimanagement.aio.operations.ProductApiOperations
    :ivar product_group: ProductGroupOperations operations
    :vartype product_group: azure.mgmt.apimanagement.aio.operations.ProductGroupOperations
    :ivar product_subscriptions: ProductSubscriptionsOperations operations
    :vartype product_subscriptions:
     azure.mgmt.apimanagement.aio.operations.ProductSubscriptionsOperations
    :ivar product_policy: ProductPolicyOperations operations
    :vartype product_policy: azure.mgmt.apimanagement.aio.operations.ProductPolicyOperations
    :ivar product_wiki: ProductWikiOperations operations
    :vartype product_wiki: azure.mgmt.apimanagement.aio.operations.ProductWikiOperations
    :ivar product_wikis: ProductWikisOperations operations
    :vartype product_wikis: azure.mgmt.apimanagement.aio.operations.ProductWikisOperations
    :ivar product_api_link: ProductApiLinkOperations operations
    :vartype product_api_link: azure.mgmt.apimanagement.aio.operations.ProductApiLinkOperations
    :ivar product_group_link: ProductGroupLinkOperations operations
    :vartype product_group_link: azure.mgmt.apimanagement.aio.operations.ProductGroupLinkOperations
    :ivar quota_by_counter_keys: QuotaByCounterKeysOperations operations
    :vartype quota_by_counter_keys:
     azure.mgmt.apimanagement.aio.operations.QuotaByCounterKeysOperations
    :ivar quota_by_period_keys: QuotaByPeriodKeysOperations operations
    :vartype quota_by_period_keys:
     azure.mgmt.apimanagement.aio.operations.QuotaByPeriodKeysOperations
    :ivar region: RegionOperations operations
    :vartype region: azure.mgmt.apimanagement.aio.operations.RegionOperations
    :ivar reports: ReportsOperations operations
    :vartype reports: azure.mgmt.apimanagement.aio.operations.ReportsOperations
    :ivar global_schema: GlobalSchemaOperations operations
    :vartype global_schema: azure.mgmt.apimanagement.aio.operations.GlobalSchemaOperations
    :ivar tenant_settings: TenantSettingsOperations operations
    :vartype tenant_settings: azure.mgmt.apimanagement.aio.operations.TenantSettingsOperations
    :ivar api_management_skus: ApiManagementSkusOperations operations
    :vartype api_management_skus:
     azure.mgmt.apimanagement.aio.operations.ApiManagementSkusOperations
    :ivar subscription: SubscriptionOperations operations
    :vartype subscription: azure.mgmt.apimanagement.aio.operations.SubscriptionOperations
    :ivar tag_resource: TagResourceOperations operations
    :vartype tag_resource: azure.mgmt.apimanagement.aio.operations.TagResourceOperations
    :ivar tag_api_link: TagApiLinkOperations operations
    :vartype tag_api_link: azure.mgmt.apimanagement.aio.operations.TagApiLinkOperations
    :ivar tag_operation_link: TagOperationLinkOperations operations
    :vartype tag_operation_link: azure.mgmt.apimanagement.aio.operations.TagOperationLinkOperations
    :ivar tag_product_link: TagProductLinkOperations operations
    :vartype tag_product_link: azure.mgmt.apimanagement.aio.operations.TagProductLinkOperations
    :ivar tenant_access: TenantAccessOperations operations
    :vartype tenant_access: azure.mgmt.apimanagement.aio.operations.TenantAccessOperations
    :ivar tenant_access_git: TenantAccessGitOperations operations
    :vartype tenant_access_git: azure.mgmt.apimanagement.aio.operations.TenantAccessGitOperations
    :ivar tenant_configuration: TenantConfigurationOperations operations
    :vartype tenant_configuration:
     azure.mgmt.apimanagement.aio.operations.TenantConfigurationOperations
    :ivar user: UserOperations operations
    :vartype user: azure.mgmt.apimanagement.aio.operations.UserOperations
    :ivar user_group: UserGroupOperations operations
    :vartype user_group: azure.mgmt.apimanagement.aio.operations.UserGroupOperations
    :ivar user_subscription: UserSubscriptionOperations operations
    :vartype user_subscription: azure.mgmt.apimanagement.aio.operations.UserSubscriptionOperations
    :ivar user_identities: UserIdentitiesOperations operations
    :vartype user_identities: azure.mgmt.apimanagement.aio.operations.UserIdentitiesOperations
    :ivar user_confirmation_password: UserConfirmationPasswordOperations operations
    :vartype user_confirmation_password:
     azure.mgmt.apimanagement.aio.operations.UserConfirmationPasswordOperations
    :ivar workspace_backend: WorkspaceBackendOperations operations
    :vartype workspace_backend: azure.mgmt.apimanagement.aio.operations.WorkspaceBackendOperations
    :ivar workspace_certificate: WorkspaceCertificateOperations operations
    :vartype workspace_certificate:
     azure.mgmt.apimanagement.aio.operations.WorkspaceCertificateOperations
    :ivar workspace_diagnostic: WorkspaceDiagnosticOperations operations
    :vartype workspace_diagnostic:
     azure.mgmt.apimanagement.aio.operations.WorkspaceDiagnosticOperations
    :ivar workspace_api_diagnostic: WorkspaceApiDiagnosticOperations operations
    :vartype workspace_api_diagnostic:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiDiagnosticOperations
    :ivar api_management_workspace_links: ApiManagementWorkspaceLinksOperations operations
    :vartype api_management_workspace_links:
     azure.mgmt.apimanagement.aio.operations.ApiManagementWorkspaceLinksOperations
    :ivar api_management_workspace_link: ApiManagementWorkspaceLinkOperations operations
    :vartype api_management_workspace_link:
     azure.mgmt.apimanagement.aio.operations.ApiManagementWorkspaceLinkOperations
    :ivar workspace_logger: WorkspaceLoggerOperations operations
    :vartype workspace_logger: azure.mgmt.apimanagement.aio.operations.WorkspaceLoggerOperations
    :ivar workspace: WorkspaceOperations operations
    :vartype workspace: azure.mgmt.apimanagement.aio.operations.WorkspaceOperations
    :ivar workspace_policy: WorkspacePolicyOperations operations
    :vartype workspace_policy: azure.mgmt.apimanagement.aio.operations.WorkspacePolicyOperations
    :ivar workspace_named_value: WorkspaceNamedValueOperations operations
    :vartype workspace_named_value:
     azure.mgmt.apimanagement.aio.operations.WorkspaceNamedValueOperations
    :ivar workspace_global_schema: WorkspaceGlobalSchemaOperations operations
    :vartype workspace_global_schema:
     azure.mgmt.apimanagement.aio.operations.WorkspaceGlobalSchemaOperations
    :ivar workspace_notification: WorkspaceNotificationOperations operations
    :vartype workspace_notification:
     azure.mgmt.apimanagement.aio.operations.WorkspaceNotificationOperations
    :ivar workspace_notification_recipient_user: WorkspaceNotificationRecipientUserOperations
     operations
    :vartype workspace_notification_recipient_user:
     azure.mgmt.apimanagement.aio.operations.WorkspaceNotificationRecipientUserOperations
    :ivar workspace_notification_recipient_email: WorkspaceNotificationRecipientEmailOperations
     operations
    :vartype workspace_notification_recipient_email:
     azure.mgmt.apimanagement.aio.operations.WorkspaceNotificationRecipientEmailOperations
    :ivar workspace_policy_fragment: WorkspacePolicyFragmentOperations operations
    :vartype workspace_policy_fragment:
     azure.mgmt.apimanagement.aio.operations.WorkspacePolicyFragmentOperations
    :ivar workspace_group: WorkspaceGroupOperations operations
    :vartype workspace_group: azure.mgmt.apimanagement.aio.operations.WorkspaceGroupOperations
    :ivar workspace_group_user: WorkspaceGroupUserOperations operations
    :vartype workspace_group_user:
     azure.mgmt.apimanagement.aio.operations.WorkspaceGroupUserOperations
    :ivar workspace_subscription: WorkspaceSubscriptionOperations operations
    :vartype workspace_subscription:
     azure.mgmt.apimanagement.aio.operations.WorkspaceSubscriptionOperations
    :ivar workspace_api_version_set: WorkspaceApiVersionSetOperations operations
    :vartype workspace_api_version_set:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiVersionSetOperations
    :ivar workspace_api: WorkspaceApiOperations operations
    :vartype workspace_api: azure.mgmt.apimanagement.aio.operations.WorkspaceApiOperations
    :ivar workspace_api_revision: WorkspaceApiRevisionOperations operations
    :vartype workspace_api_revision:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiRevisionOperations
    :ivar workspace_api_release: WorkspaceApiReleaseOperations operations
    :vartype workspace_api_release:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiReleaseOperations
    :ivar workspace_api_operation: WorkspaceApiOperationOperations operations
    :vartype workspace_api_operation:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiOperationOperations
    :ivar workspace_api_operation_policy: WorkspaceApiOperationPolicyOperations operations
    :vartype workspace_api_operation_policy:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiOperationPolicyOperations
    :ivar workspace_api_policy: WorkspaceApiPolicyOperations operations
    :vartype workspace_api_policy:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiPolicyOperations
    :ivar workspace_api_schema: WorkspaceApiSchemaOperations operations
    :vartype workspace_api_schema:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiSchemaOperations
    :ivar workspace_product: WorkspaceProductOperations operations
    :vartype workspace_product: azure.mgmt.apimanagement.aio.operations.WorkspaceProductOperations
    :ivar workspace_product_api_link: WorkspaceProductApiLinkOperations operations
    :vartype workspace_product_api_link:
     azure.mgmt.apimanagement.aio.operations.WorkspaceProductApiLinkOperations
    :ivar workspace_product_group_link: WorkspaceProductGroupLinkOperations operations
    :vartype workspace_product_group_link:
     azure.mgmt.apimanagement.aio.operations.WorkspaceProductGroupLinkOperations
    :ivar workspace_product_policy: WorkspaceProductPolicyOperations operations
    :vartype workspace_product_policy:
     azure.mgmt.apimanagement.aio.operations.WorkspaceProductPolicyOperations
    :ivar workspace_tag: WorkspaceTagOperations operations
    :vartype workspace_tag: azure.mgmt.apimanagement.aio.operations.WorkspaceTagOperations
    :ivar workspace_tag_api_link: WorkspaceTagApiLinkOperations operations
    :vartype workspace_tag_api_link:
     azure.mgmt.apimanagement.aio.operations.WorkspaceTagApiLinkOperations
    :ivar workspace_tag_operation_link: WorkspaceTagOperationLinkOperations operations
    :vartype workspace_tag_operation_link:
     azure.mgmt.apimanagement.aio.operations.WorkspaceTagOperationLinkOperations
    :ivar workspace_tag_product_link: WorkspaceTagProductLinkOperations operations
    :vartype workspace_tag_product_link:
     azure.mgmt.apimanagement.aio.operations.WorkspaceTagProductLinkOperations
    :ivar workspace_api_export: WorkspaceApiExportOperations operations
    :vartype workspace_api_export:
     azure.mgmt.apimanagement.aio.operations.WorkspaceApiExportOperations
    :ivar operation_status: OperationStatusOperations operations
    :vartype operation_status: azure.mgmt.apimanagement.aio.operations.OperationStatusOperations
    :ivar operations_results: OperationsResultsOperations operations
    :vartype operations_results:
     azure.mgmt.apimanagement.aio.operations.OperationsResultsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2024-05-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = ApiManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.api_gateway = ApiGatewayOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_management_gateway_skus = ApiManagementGatewaySkusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.all_policies = AllPoliciesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api = ApiOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_revision = ApiRevisionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_release = ApiReleaseOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_operation = ApiOperationOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_operation_policy = ApiOperationPolicyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.tag = TagOperations(self._client, self._config, self._serialize, self._deserialize)
        self.graph_ql_api_resolver = GraphQLApiResolverOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.graph_ql_api_resolver_policy = GraphQLApiResolverPolicyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_product = ApiProductOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_policy = ApiPolicyOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_schema = ApiSchemaOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_diagnostic = ApiDiagnosticOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_issue = ApiIssueOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_issue_comment = ApiIssueCommentOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_issue_attachment = ApiIssueAttachmentOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_tag_description = ApiTagDescriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operation = OperationOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_wiki = ApiWikiOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_wikis = ApiWikisOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_export = ApiExportOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_version_set = ApiVersionSetOperations(self._client, self._config, self._serialize, self._deserialize)
        self.authorization_provider = AuthorizationProviderOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.authorization = AuthorizationOperations(self._client, self._config, self._serialize, self._deserialize)
        self.authorization_login_links = AuthorizationLoginLinksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.authorization_access_policy = AuthorizationAccessPolicyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.authorization_server = AuthorizationServerOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.backend = BackendOperations(self._client, self._config, self._serialize, self._deserialize)
        self.cache = CacheOperations(self._client, self._config, self._serialize, self._deserialize)
        self.certificate = CertificateOperations(self._client, self._config, self._serialize, self._deserialize)
        self.content_type = ContentTypeOperations(self._client, self._config, self._serialize, self._deserialize)
        self.content_item = ContentItemOperations(self._client, self._config, self._serialize, self._deserialize)
        self.deleted_services = DeletedServicesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_management_operations = ApiManagementOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_management_service_skus = ApiManagementServiceSkusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_management_service = ApiManagementServiceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.diagnostic = DiagnosticOperations(self._client, self._config, self._serialize, self._deserialize)
        self.documentation = DocumentationOperations(self._client, self._config, self._serialize, self._deserialize)
        self.email_template = EmailTemplateOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_gateway_config_connection = ApiGatewayConfigConnectionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gateway = GatewayOperations(self._client, self._config, self._serialize, self._deserialize)
        self.gateway_hostname_configuration = GatewayHostnameConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gateway_api = GatewayApiOperations(self._client, self._config, self._serialize, self._deserialize)
        self.gateway_certificate_authority = GatewayCertificateAuthorityOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.group = GroupOperations(self._client, self._config, self._serialize, self._deserialize)
        self.group_user = GroupUserOperations(self._client, self._config, self._serialize, self._deserialize)
        self.identity_provider = IdentityProviderOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.issue = IssueOperations(self._client, self._config, self._serialize, self._deserialize)
        self.logger = LoggerOperations(self._client, self._config, self._serialize, self._deserialize)
        self.named_value = NamedValueOperations(self._client, self._config, self._serialize, self._deserialize)
        self.network_status = NetworkStatusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.notification = NotificationOperations(self._client, self._config, self._serialize, self._deserialize)
        self.notification_recipient_user = NotificationRecipientUserOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.notification_recipient_email = NotificationRecipientEmailOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.open_id_connect_provider = OpenIdConnectProviderOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.outbound_network_dependencies_endpoints = OutboundNetworkDependenciesEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy = PolicyOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_description = PolicyDescriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy_fragment = PolicyFragmentOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_restriction = PolicyRestrictionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy_restriction_validations = PolicyRestrictionValidationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.portal_config = PortalConfigOperations(self._client, self._config, self._serialize, self._deserialize)
        self.portal_revision = PortalRevisionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.portal_settings = PortalSettingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sign_in_settings = SignInSettingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sign_up_settings = SignUpSettingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.delegation_settings = DelegationSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connection = PrivateEndpointConnectionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.product = ProductOperations(self._client, self._config, self._serialize, self._deserialize)
        self.product_api = ProductApiOperations(self._client, self._config, self._serialize, self._deserialize)
        self.product_group = ProductGroupOperations(self._client, self._config, self._serialize, self._deserialize)
        self.product_subscriptions = ProductSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.product_policy = ProductPolicyOperations(self._client, self._config, self._serialize, self._deserialize)
        self.product_wiki = ProductWikiOperations(self._client, self._config, self._serialize, self._deserialize)
        self.product_wikis = ProductWikisOperations(self._client, self._config, self._serialize, self._deserialize)
        self.product_api_link = ProductApiLinkOperations(self._client, self._config, self._serialize, self._deserialize)
        self.product_group_link = ProductGroupLinkOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.quota_by_counter_keys = QuotaByCounterKeysOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.quota_by_period_keys = QuotaByPeriodKeysOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.region = RegionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.reports = ReportsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.global_schema = GlobalSchemaOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tenant_settings = TenantSettingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.api_management_skus = ApiManagementSkusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.subscription = SubscriptionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tag_resource = TagResourceOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tag_api_link = TagApiLinkOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tag_operation_link = TagOperationLinkOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.tag_product_link = TagProductLinkOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tenant_access = TenantAccessOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tenant_access_git = TenantAccessGitOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.tenant_configuration = TenantConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.user = UserOperations(self._client, self._config, self._serialize, self._deserialize)
        self.user_group = UserGroupOperations(self._client, self._config, self._serialize, self._deserialize)
        self.user_subscription = UserSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.user_identities = UserIdentitiesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.user_confirmation_password = UserConfirmationPasswordOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_backend = WorkspaceBackendOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_certificate = WorkspaceCertificateOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_diagnostic = WorkspaceDiagnosticOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api_diagnostic = WorkspaceApiDiagnosticOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_management_workspace_links = ApiManagementWorkspaceLinksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_management_workspace_link = ApiManagementWorkspaceLinkOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_logger = WorkspaceLoggerOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace = WorkspaceOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workspace_policy = WorkspacePolicyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_named_value = WorkspaceNamedValueOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_global_schema = WorkspaceGlobalSchemaOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_notification = WorkspaceNotificationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_notification_recipient_user = WorkspaceNotificationRecipientUserOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_notification_recipient_email = WorkspaceNotificationRecipientEmailOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_policy_fragment = WorkspacePolicyFragmentOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_group = WorkspaceGroupOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workspace_group_user = WorkspaceGroupUserOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_subscription = WorkspaceSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api_version_set = WorkspaceApiVersionSetOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api = WorkspaceApiOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workspace_api_revision = WorkspaceApiRevisionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api_release = WorkspaceApiReleaseOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api_operation = WorkspaceApiOperationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api_operation_policy = WorkspaceApiOperationPolicyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api_policy = WorkspaceApiPolicyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api_schema = WorkspaceApiSchemaOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_product = WorkspaceProductOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_product_api_link = WorkspaceProductApiLinkOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_product_group_link = WorkspaceProductGroupLinkOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_product_policy = WorkspaceProductPolicyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_tag = WorkspaceTagOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workspace_tag_api_link = WorkspaceTagApiLinkOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_tag_operation_link = WorkspaceTagOperationLinkOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_tag_product_link = WorkspaceTagProductLinkOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_api_export = WorkspaceApiExportOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operation_status = OperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations_results = OperationsResultsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
