# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessIdName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ACCESS = "access"

class AlwaysLog(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies for what type of messages sampling settings should not apply.
    """

    ALL_ERRORS = "allErrors"  #: Always log all erroneous request regardless of sampling settings.

class ApimIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes
    both an implicitly created identity and a set of user assigned identities. The type 'None' will
    remove any identities from the service.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"

class ApiType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of API.
    """

    HTTP = "http"
    SOAP = "soap"

class ApiVersionSetContractDetailsVersioningScheme(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An value that determines where the API Version identifer will be located in a HTTP request.
    """

    SEGMENT = "Segment"
    QUERY = "Query"
    HEADER = "Header"

class AppType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    PORTAL = "portal"  #: User create request was sent by legacy developer portal.
    DEVELOPER_PORTAL = "developerPortal"  #: User create request was sent by new developer portal.

class AsyncOperationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of an async operation.
    """

    STARTED = "Started"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class AuthorizationMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HEAD = "HEAD"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"
    GET = "GET"
    POST = "POST"
    PUT = "PUT"
    PATCH = "PATCH"
    DELETE = "DELETE"

class BackendProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Backend communication protocol.
    """

    HTTP = "http"  #: The Backend is a RESTful service.
    SOAP = "soap"  #: The Backend is a SOAP service.

class BearerTokenSendingMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    AUTHORIZATION_HEADER = "authorizationHeader"
    QUERY = "query"

class BearerTokenSendingMethods(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Form of an authorization grant, which the client uses to request the access token.
    """

    AUTHORIZATION_HEADER = "authorizationHeader"  #: Access token will be transmitted in the Authorization header using Bearer schema.
    QUERY = "query"  #: Access token will be transmitted as query parameters.

class CertificateConfigurationStoreName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only
    Root and CertificateAuthority are valid locations.
    """

    CERTIFICATE_AUTHORITY = "CertificateAuthority"
    ROOT = "Root"

class ClientAuthenticationMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    BASIC = "Basic"  #: Basic Client Authentication method.
    BODY = "Body"  #: Body based Authentication method.

class ConfigurationIdName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CONFIGURATION = "configuration"

class Confirmation(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Determines the type of confirmation e-mail that will be sent to the newly created user.
    """

    SIGNUP = "signup"  #: Send an e-mail to the user confirming they have successfully signed up.
    INVITE = "invite"  #: Send an e-mail inviting the user to sign-up and complete registration.

class ConnectivityStatusType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource Connectivity Status Type identifier.
    """

    INITIALIZING = "initializing"
    SUCCESS = "success"
    FAILURE = "failure"

class ContentFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Format of the Content in which the API is getting imported.
    """

    WADL_XML = "wadl-xml"  #: The contents are inline and Content type is a WADL document.
    WADL_LINK_JSON = "wadl-link-json"  #: The WADL document is hosted on a publicly accessible internet address.
    SWAGGER_JSON = "swagger-json"  #: The contents are inline and Content Type is a OpenApi 2.0 Document.
    SWAGGER_LINK_JSON = "swagger-link-json"  #: The Open Api 2.0 document is hosted on a publicly accessible internet address.
    WSDL = "wsdl"  #: The contents are inline and the document is a WSDL/Soap document.
    WSDL_LINK = "wsdl-link"  #: The WSDL document is hosted on a publicly accessible internet address.
    OPENAPI = "openapi"  #: The contents are inline and Content Type is a OpenApi 3.0 Document in YAML format.
    OPENAPI_JSON = "openapi+json"  #: The contents are inline and Content Type is a OpenApi 3.0 Document in JSON format.
    OPENAPI_LINK = "openapi-link"  #: The Open Api 3.0 document is hosted on a publicly accessible internet address.
    OPENAPI_JSON_LINK = "openapi+json-link"  #: The Open Api 3.0 Json document is hosted on a publicly accessible internet address.

class DataMaskingMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Data masking mode.
    """

    MASK = "Mask"  #: Mask the value of an entity.
    HIDE = "Hide"  #: Hide the presence of an entity.

class ExportApi(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    TRUE = "true"

class ExportFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    SWAGGER = "swagger-link"  #: Export the Api Definition in OpenApi Specification 2.0 format to the Storage Blob.
    WSDL = "wsdl-link"  #: Export the Api Definition in WSDL Schema to Storage Blob. This is only supported for APIs of Type ``soap``.
    WADL = "wadl-link"  #: Export the Api Definition in WADL Schema to Storage Blob.
    OPENAPI = "openapi-link"  #: Export the Api Definition in OpenApi Specification 3.0 to Storage Blob.
    OPENAPI_JSON = "openapi+json-link"  #: Export the Api Definition in OpenApi Specification 3.0 as JSON document to Storage Blob.

class ExportResultFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Format in which the Api Details are exported to the Storage Blob with Sas Key valid for 5
    minutes.
    """

    SWAGGER = "swagger-link-json"  #: The Api Definition is exported in OpenApi Specification 2.0 format to the Storage Blob.
    WSDL = "wsdl-link+xml"  #: The Api Definition is exported in WSDL Schema to Storage Blob. This is only supported for APIs of Type ``soap``.
    WADL = "wadl-link-json"  #: Export the Api Definition in WADL Schema to Storage Blob.
    OPEN_API = "openapi-link"  #: Export the Api Definition in OpenApi Specification 3.0 to Storage Blob.

class GrantType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    AUTHORIZATION_CODE = "authorizationCode"  #: Authorization Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.1.
    IMPLICIT = "implicit"  #: Implicit Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.2.
    RESOURCE_OWNER_PASSWORD = "resourceOwnerPassword"  #: Resource Owner Password Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.3.
    CLIENT_CREDENTIALS = "clientCredentials"  #: Client Credentials Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.4.

class GroupType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Group type.
    """

    CUSTOM = "custom"
    SYSTEM = "system"
    EXTERNAL = "external"

class HostnameType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Hostname type.
    """

    PROXY = "Proxy"
    PORTAL = "Portal"
    MANAGEMENT = "Management"
    SCM = "Scm"
    DEVELOPER_PORTAL = "DeveloperPortal"

class HttpCorrelationProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sets correlation protocol to use for Application Insights diagnostics.
    """

    NONE = "None"  #: Do not read and inject correlation headers.
    LEGACY = "Legacy"  #: Inject Request-Id and Request-Context headers with request correlation data. See https://github.com/dotnet/corefx/blob/master/src/System.Diagnostics.DiagnosticSource/src/HttpCorrelationProtocol.md.
    W3_C = "W3C"  #: Inject Trace Context headers. See https://w3c.github.io/trace-context.

class IdentityProviderType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    FACEBOOK = "facebook"  #: Facebook as Identity provider.
    GOOGLE = "google"  #: Google as Identity provider.
    MICROSOFT = "microsoft"  #: Microsoft Live as Identity provider.
    TWITTER = "twitter"  #: Twitter as Identity provider.
    AAD = "aad"  #: Azure Active Directory as Identity provider.
    AAD_B2_C = "aadB2C"  #: Azure Active Directory B2C as Identity provider.

class KeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The Key to be used to generate token for user.
    """

    PRIMARY = "primary"
    SECONDARY = "secondary"

class LoggerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Logger type.
    """

    AZURE_EVENT_HUB = "azureEventHub"  #: Azure Event Hub as log destination.
    APPLICATION_INSIGHTS = "applicationInsights"  #: Azure Application Insights as log destination.
    AZURE_MONITOR = "azureMonitor"  #: Azure Monitor.

class NameAvailabilityReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Invalid indicates the name provided does not match the resource provider’s naming requirements
    (incorrect length, unsupported characters, etc.)  AlreadyExists indicates that the name is
    already in use and is therefore unavailable.
    """

    VALID = "Valid"
    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class NotificationName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    REQUEST_PUBLISHER_NOTIFICATION_MESSAGE = "RequestPublisherNotificationMessage"  #: The following email recipients and users will receive email notifications about subscription requests for API products requiring approval.
    PURCHASE_PUBLISHER_NOTIFICATION_MESSAGE = "PurchasePublisherNotificationMessage"  #: The following email recipients and users will receive email notifications about new API product subscriptions.
    NEW_APPLICATION_NOTIFICATION_MESSAGE = "NewApplicationNotificationMessage"  #: The following email recipients and users will receive email notifications when new applications are submitted to the application gallery.
    BCC = "BCC"  #: The following recipients will receive blind carbon copies of all emails sent to developers.
    NEW_ISSUE_PUBLISHER_NOTIFICATION_MESSAGE = "NewIssuePublisherNotificationMessage"  #: The following email recipients and users will receive email notifications when a new issue or comment is submitted on the developer portal.
    ACCOUNT_CLOSED_PUBLISHER = "AccountClosedPublisher"  #: The following email recipients and users will receive email notifications when developer closes his account.
    QUOTA_LIMIT_APPROACHING_PUBLISHER_NOTIFICATION_MESSAGE = "QuotaLimitApproachingPublisherNotificationMessage"  #: The following email recipients and users will receive email notifications when subscription usage gets close to usage quota.

class OperationNameFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The format of the Operation Name for Application Insights telemetries. Default is Name.
    """

    NAME = "Name"  #: API_NAME;rev=API_REVISION - OPERATION_NAME.
    URL = "Url"  #: HTTP_VERB URL.

class PolicyContentFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Format of the policyContent.
    """

    XML = "xml"  #: The contents are inline and Content type is an XML document.
    XML_LINK = "xml-link"  #: The policy XML document is hosted on a http endpoint accessible from the API Management service.
    RAWXML = "rawxml"  #: The contents are inline and Content type is a non XML encoded policy document.
    RAWXML_LINK = "rawxml-link"  #: The policy document is not Xml encoded and is hosted on a http endpoint accessible from the API Management service.

class PolicyExportFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    XML = "xml"  #: The contents are inline and Content type is an XML document.
    RAWXML = "rawxml"  #: The contents are inline and Content type is a non XML encoded policy document.

class PolicyIdName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    POLICY = "policy"

class PolicyScopeContract(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    TENANT = "Tenant"
    PRODUCT = "Product"
    API = "Api"
    OPERATION = "Operation"
    ALL = "All"

class ProductState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """whether product is published or not. Published products are discoverable by users of developer
    portal. Non published products are visible only to administrators. Default state of Product is
    notPublished.
    """

    NOT_PUBLISHED = "notPublished"
    PUBLISHED = "published"

class Protocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HTTP = "http"
    HTTPS = "https"

class ResourceSkuCapacityScaleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scale type applicable to the sku.
    """

    AUTOMATIC = "automatic"  #: Supported scale type automatic.
    MANUAL = "manual"  #: Supported scale type manual.
    NONE = "none"  #: Scaling not supported.

class SamplingType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sampling type.
    """

    FIXED = "fixed"  #: Fixed-rate sampling.

class SkuType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name of the Sku.
    """

    DEVELOPER = "Developer"  #: Developer SKU of Api Management.
    STANDARD = "Standard"  #: Standard SKU of Api Management.
    PREMIUM = "Premium"  #: Premium SKU of Api Management.
    BASIC = "Basic"  #: Basic SKU of Api Management.
    CONSUMPTION = "Consumption"  #: Consumption SKU of Api Management.
    ISOLATED = "Isolated"  #: Isolated SKU of Api Management.

class SoapApiType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of Api to create.
    
    
    * ``http`` creates a SOAP to REST API
    * ``soap`` creates a SOAP pass-through API .
    """

    SOAP_TO_REST = "http"  #: Imports a SOAP API having a RESTful front end.
    SOAP_PASS_THROUGH = "soap"  #: Imports the Soap API having a SOAP front end.

class State(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the issue.
    """

    PROPOSED = "proposed"  #: The issue is proposed.
    OPEN = "open"  #: The issue is opened.
    REMOVED = "removed"  #: The issue was removed.
    RESOLVED = "resolved"  #: The issue is now resolved.
    CLOSED = "closed"  #: The issue was closed.

class SubscriptionState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Subscription state. Possible states are * active – the subscription is active, * suspended –
    the subscription is blocked, and the subscriber cannot call any APIs of the product, *
    submitted – the subscription request has been made by the developer, but has not yet been
    approved or rejected, * rejected – the subscription request has been denied by an
    administrator, * cancelled – the subscription has been cancelled by the developer or
    administrator, * expired – the subscription reached its expiration date and was deactivated.
    """

    SUSPENDED = "suspended"
    ACTIVE = "active"
    EXPIRED = "expired"
    SUBMITTED = "submitted"
    REJECTED = "rejected"
    CANCELLED = "cancelled"

class TemplateName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    APPLICATION_APPROVED_NOTIFICATION_MESSAGE = "applicationApprovedNotificationMessage"
    ACCOUNT_CLOSED_DEVELOPER = "accountClosedDeveloper"
    QUOTA_LIMIT_APPROACHING_DEVELOPER_NOTIFICATION_MESSAGE = "quotaLimitApproachingDeveloperNotificationMessage"
    NEW_DEVELOPER_NOTIFICATION_MESSAGE = "newDeveloperNotificationMessage"
    EMAIL_CHANGE_IDENTITY_DEFAULT = "emailChangeIdentityDefault"
    INVITE_USER_NOTIFICATION_MESSAGE = "inviteUserNotificationMessage"
    NEW_COMMENT_NOTIFICATION_MESSAGE = "newCommentNotificationMessage"
    CONFIRM_SIGN_UP_IDENTITY_DEFAULT = "confirmSignUpIdentityDefault"
    NEW_ISSUE_NOTIFICATION_MESSAGE = "newIssueNotificationMessage"
    PURCHASE_DEVELOPER_NOTIFICATION_MESSAGE = "purchaseDeveloperNotificationMessage"
    PASSWORD_RESET_IDENTITY_DEFAULT = "passwordResetIdentityDefault"
    PASSWORD_RESET_BY_ADMIN_NOTIFICATION_MESSAGE = "passwordResetByAdminNotificationMessage"
    REJECT_DEVELOPER_NOTIFICATION_MESSAGE = "rejectDeveloperNotificationMessage"
    REQUEST_DEVELOPER_NOTIFICATION_MESSAGE = "requestDeveloperNotificationMessage"

class UserState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Account state. Specifies whether the user is active or not. Blocked users are unable to sign
    into the developer portal or call any APIs of subscribed products. Default state is Active.
    """

    ACTIVE = "active"  #: User state is active.
    BLOCKED = "blocked"  #: User is blocked. Blocked users cannot authenticate at developer portal or call API.
    PENDING = "pending"  #: User account is pending. Requires identity confirmation before it can be made active.
    DELETED = "deleted"  #: User account is closed. All identities and related entities are removed.

class Verbosity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The verbosity level applied to traces emitted by trace policies.
    """

    VERBOSE = "verbose"  #: All the traces emitted by trace policies will be sent to the logger attached to this diagnostic instance.
    INFORMATION = "information"  #: Traces with 'severity' set to 'information' and 'error' will be sent to the logger attached to this diagnostic instance.
    ERROR = "error"  #: Only traces with 'severity' set to 'error' will be sent to the logger attached to this diagnostic instance.

class VersioningScheme(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An value that determines where the API Version identifer will be located in a HTTP request.
    """

    SEGMENT = "Segment"  #: The API Version is passed in a path segment.
    QUERY = "Query"  #: The API Version is passed in a query parameter.
    HEADER = "Header"  #: The API Version is passed in a HTTP header.

class VirtualNetworkType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of VPN in which API Management service needs to be configured in. None (Default Value)
    means the API Management service is not part of any Virtual Network, External means the API
    Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint,
    and Internal means that API Management deployment is setup inside a Virtual Network having an
    Intranet Facing Endpoint only.
    """

    NONE = "None"  #: The service is not part of any Virtual Network.
    EXTERNAL = "External"  #: The service is part of Virtual Network and it is accessible from Internet.
    INTERNAL = "Internal"  #: The service is part of Virtual Network and it is only accessible from within the virtual network.
