///
/// Wavelets coefficients, extracted from http://wavelets.pybytes.com
///

#include "filters.h"



DTYPE DB2_L[4] = {
    -0.12940952255092145,
    0.22414386804185735,
    0.836516303737469,
    0.48296291314469025
};

DTYPE DB2_H[4] = {
    -0.48296291314469025,
    0.836516303737469,
    -0.22414386804185735,
    -0.12940952255092145
};

DTYPE DB2_I_L[4] = {
    0.48296291314469025,
    0.836516303737469,
    0.22414386804185735,
    -0.12940952255092145
};

DTYPE DB2_I_H[4] = {
    -0.12940952255092145,
    -0.22414386804185735,
    0.836516303737469,
    -0.48296291314469025
};



DTYPE DB3_L[6] = {
    0.035226291882100656,
    -0.08544127388224149,
    -0.13501102001039084,
    0.4598775021193313,
    0.8068915093133388,
    0.3326705529509569
};

DTYPE DB3_H[6] = {
    -0.3326705529509569,
    0.8068915093133388,
    -0.4598775021193313,
    -0.13501102001039084,
    0.08544127388224149,
    0.035226291882100656
};

DTYPE DB3_I_L[6] = {
    0.3326705529509569,
    0.8068915093133388,
    0.4598775021193313,
    -0.13501102001039084,
    -0.08544127388224149,
    0.035226291882100656
};

DTYPE DB3_I_H[6] = {
    0.035226291882100656,
    0.08544127388224149,
    -0.13501102001039084,
    -0.4598775021193313,
    0.8068915093133388,
    -0.3326705529509569
};


DTYPE DB4_L[8] = {
    -0.010597401784997278,
    0.032883011666982945 ,
    0.030841381835986965 ,
    -0.18703481171888114 ,
    -0.02798376941698385 ,
    0.6308807679295904   ,
    0.7148465705525415   ,
    0.23037781330885523
};

DTYPE DB4_H[8] = {
    -0.23037781330885523 ,
    0.7148465705525415   ,
    -0.6308807679295904  ,
    -0.02798376941698385 ,
    0.18703481171888114  ,
    0.030841381835986965 ,
    -0.032883011666982945,
    -0.010597401784997278
};

DTYPE DB4_I_L[8] = {
    0.23037781330885523  ,
    0.7148465705525415   ,
    0.6308807679295904   ,
    -0.02798376941698385 ,
    -0.18703481171888114 ,
    0.030841381835986965 ,
    0.032883011666982945 ,
    -0.010597401784997278
};

DTYPE DB4_I_H[8] = {
    -0.010597401784997278,
    -0.032883011666982945,
    0.030841381835986965 ,
    0.18703481171888114  ,
    -0.02798376941698385 ,
    -0.6308807679295904  ,
    0.7148465705525415   ,
    -0.23037781330885523
};


DTYPE DB5_L[10] = {
    0.003335725285001549,
    -0.012580751999015526,
    -0.006241490213011705,
    0.07757149384006515,
    -0.03224486958502952,
    -0.24229488706619015,
    0.13842814590110342,
    0.7243085284385744,
    0.6038292697974729,
    0.160102397974125
};

DTYPE DB5_H[10] = {
    -0.160102397974125,
    0.6038292697974729,
    -0.7243085284385744,
    0.13842814590110342,
    0.24229488706619015,
    -0.03224486958502952,
    -0.07757149384006515,
    -0.006241490213011705,
    0.012580751999015526,
    0.003335725285001549
};

DTYPE DB5_I_L[10] = {
    0.160102397974125,
    0.6038292697974729,
    0.7243085284385744,
    0.13842814590110342,
    -0.24229488706619015,
    -0.03224486958502952,
    0.07757149384006515,
    -0.006241490213011705,
    -0.012580751999015526,
    0.003335725285001549
};

DTYPE DB5_I_H[10] = {
    0.003335725285001549,
    0.012580751999015526,
    -0.006241490213011705,
    -0.07757149384006515,
    -0.03224486958502952,
    0.24229488706619015,
    0.13842814590110342,
    -0.7243085284385744,
    0.6038292697974729,
    -0.160102397974125
};

DTYPE DB6_L[12] = {
    -0.00107730108499558,
    0.004777257511010651,
    0.0005538422009938016,
    -0.031582039318031156,
    0.02752286553001629,
    0.09750160558707936,
    -0.12976686756709563,
    -0.22626469396516913,
    0.3152503517092432,
    0.7511339080215775,
    0.4946238903983854,
    0.11154074335008017
};

DTYPE DB6_H[12] = {
    -0.11154074335008017,
    0.4946238903983854,
    -0.7511339080215775,
    0.3152503517092432,
    0.22626469396516913,
    -0.12976686756709563,
    -0.09750160558707936,
    0.02752286553001629,
    0.031582039318031156,
    0.0005538422009938016,
    -0.004777257511010651,
    -0.00107730108499558
};

DTYPE DB6_I_L[12] = {
    0.11154074335008017,
    0.4946238903983854,
    0.7511339080215775,
    0.3152503517092432,
    -0.22626469396516913,
    -0.12976686756709563,
    0.09750160558707936,
    0.02752286553001629,
    -0.031582039318031156,
    0.0005538422009938016,
    0.004777257511010651,
    -0.00107730108499558
};


DTYPE DB6_I_H[12] = {
    -0.00107730108499558,
    -0.004777257511010651,
    0.0005538422009938016,
    0.031582039318031156,
    0.02752286553001629,
    -0.09750160558707936,
    -0.12976686756709563,
    0.22626469396516913,
    0.3152503517092432,
    -0.7511339080215775,
    0.4946238903983854,
    -0.11154074335008017
};

DTYPE DB7_L[14] = {
    0.0003537138000010399,
    -0.0018016407039998328,
    0.00042957797300470274,
    0.012550998556013784,
    -0.01657454163101562,
    -0.03802993693503463,
    0.0806126091510659,
    0.07130921926705004,
    -0.22403618499416572,
    -0.14390600392910627,
    0.4697822874053586,
    0.7291320908465551,
    0.39653931948230575,
    0.07785205408506236,
};

DTYPE DB7_I_L[14] = {
    0.07785205408506236,
    0.39653931948230575,
    0.7291320908465551,
    0.4697822874053586,
    -0.14390600392910627,
    -0.22403618499416572,
    0.07130921926705004,
    0.0806126091510659,
    -0.03802993693503463,
    -0.01657454163101562,
    0.012550998556013784,
    0.00042957797300470274,
    -0.0018016407039998328,
    0.0003537138000010399,
};

DTYPE DB7_H[14] = {
    -0.07785205408506236,
    0.39653931948230575,
    -0.7291320908465551,
    0.4697822874053586,
    0.14390600392910627,
    -0.22403618499416572,
    -0.07130921926705004,
    0.0806126091510659,
    0.03802993693503463,
    -0.01657454163101562,
    -0.012550998556013784,
    0.00042957797300470274,
    0.0018016407039998328,
    0.0003537138000010399,
};

DTYPE DB7_I_H[14] = {
    0.0003537138000010399,
    0.0018016407039998328,
    0.00042957797300470274,
    -0.012550998556013784,
    -0.01657454163101562,
    0.03802993693503463,
    0.0806126091510659,
    -0.07130921926705004,
    -0.22403618499416572,
    0.14390600392910627,
    0.4697822874053586,
    -0.7291320908465551,
    0.39653931948230575,
    -0.07785205408506236,
};

DTYPE DB8_L[16] = {
    -0.00011747678400228192,
    0.0006754494059985568,
    -0.0003917403729959771,
    -0.00487035299301066,
    0.008746094047015655,
    0.013981027917015516,
    -0.04408825393106472,
    -0.01736930100202211,
    0.128747426620186,
    0.00047248457399797254,
    -0.2840155429624281,
    -0.015829105256023893,
    0.5853546836548691,
    0.6756307362980128,
    0.3128715909144659,
    0.05441584224308161,
};

DTYPE DB8_I_L[16] = {
    0.05441584224308161,
    0.3128715909144659,
    0.6756307362980128,
    0.5853546836548691,
    -0.015829105256023893,
    -0.2840155429624281,
    0.00047248457399797254,
    0.128747426620186,
    -0.01736930100202211,
    -0.04408825393106472,
    0.013981027917015516,
    0.008746094047015655,
    -0.00487035299301066,
    -0.0003917403729959771,
    0.0006754494059985568,
    -0.00011747678400228192,
};

DTYPE DB8_H[16] = {
    -0.05441584224308161,
    0.3128715909144659,
    -0.6756307362980128,
    0.5853546836548691,
    0.015829105256023893,
    -0.2840155429624281,
    -0.00047248457399797254,
    0.128747426620186,
    0.01736930100202211,
    -0.04408825393106472,
    -0.013981027917015516,
    0.008746094047015655,
    0.00487035299301066,
    -0.0003917403729959771,
    -0.0006754494059985568,
    -0.00011747678400228192,
};

DTYPE DB8_I_H[16] = {
    -0.00011747678400228192,
    -0.0006754494059985568,
    -0.0003917403729959771,
    0.00487035299301066,
    0.008746094047015655,
    -0.013981027917015516,
    -0.04408825393106472,
    0.01736930100202211,
    0.128747426620186,
    -0.00047248457399797254,
    -0.2840155429624281,
    0.015829105256023893,
    0.5853546836548691,
    -0.6756307362980128,
    0.3128715909144659,
    -0.05441584224308161,
};

DTYPE DB9_L[18] = {
    3.9347319995026124e-05,
    -0.0002519631889981789,
    0.00023038576399541288,
    0.0018476468829611268,
    -0.004281503681904723,
    -0.004723204757894831,
    0.022361662123515244,
    0.00025094711499193845,
    -0.06763282905952399,
    0.030725681478322865,
    0.14854074933476008,
    -0.09684078322087904,
    -0.29327378327258685,
    0.13319738582208895,
    0.6572880780366389,
    0.6048231236767786,
    0.24383467463766728,
    0.03807794736316728,
};

DTYPE DB9_I_L[18] = {
    0.03807794736316728,
    0.24383467463766728,
    0.6048231236767786,
    0.6572880780366389,
    0.13319738582208895,
    -0.29327378327258685,
    -0.09684078322087904,
    0.14854074933476008,
    0.030725681478322865,
    -0.06763282905952399,
    0.00025094711499193845,
    0.022361662123515244,
    -0.004723204757894831,
    -0.004281503681904723,
    0.0018476468829611268,
    0.00023038576399541288,
    -0.0002519631889981789,
    3.9347319995026124e-05,
};

DTYPE DB9_H[18] = {
    -0.03807794736316728,
    0.24383467463766728,
    -0.6048231236767786,
    0.6572880780366389,
    -0.13319738582208895,
    -0.29327378327258685,
    0.09684078322087904,
    0.14854074933476008,
    -0.030725681478322865,
    -0.06763282905952399,
    -0.00025094711499193845,
    0.022361662123515244,
    0.004723204757894831,
    -0.004281503681904723,
    -0.0018476468829611268,
    0.00023038576399541288,
    0.0002519631889981789,
    3.9347319995026124e-05,
};

DTYPE DB9_I_H[18] = {
    3.9347319995026124e-05,
    0.0002519631889981789,
    0.00023038576399541288,
    -0.0018476468829611268,
    -0.004281503681904723,
    0.004723204757894831,
    0.022361662123515244,
    -0.00025094711499193845,
    -0.06763282905952399,
    -0.030725681478322865,
    0.14854074933476008,
    0.09684078322087904,
    -0.29327378327258685,
    -0.13319738582208895,
    0.6572880780366389,
    -0.6048231236767786,
    0.24383467463766728,
    -0.03807794736316728,
};


DTYPE DB10_L[20] = {
    -1.326420300235487e-05,
    9.358867000108985e-05,
    -0.0001164668549943862,
    -0.0006858566950046825,
    0.00199240529499085,
    0.0013953517469940798,
    -0.010733175482979604,
    0.0036065535669883944,
    0.03321267405893324,
    -0.02945753682194567,
    -0.07139414716586077,
    0.09305736460380659,
    0.12736934033574265,
    -0.19594627437659665,
    -0.24984642432648865,
    0.2811723436604265,
    0.6884590394525921,
    0.5272011889309198,
    0.18817680007762133,
    0.026670057900950818,
};

DTYPE DB10_I_L[20] = {
    0.026670057900950818,
    0.18817680007762133,
    0.5272011889309198,
    0.6884590394525921,
    0.2811723436604265,
    -0.24984642432648865,
    -0.19594627437659665,
    0.12736934033574265,
    0.09305736460380659,
    -0.07139414716586077,
    -0.02945753682194567,
    0.03321267405893324,
    0.0036065535669883944,
    -0.010733175482979604,
    0.0013953517469940798,
    0.00199240529499085,
    -0.0006858566950046825,
    -0.0001164668549943862,
    9.358867000108985e-05,
    -1.326420300235487e-05,
};

DTYPE DB10_H[20] = {
    -0.026670057900950818,
    0.18817680007762133,
    -0.5272011889309198,
    0.6884590394525921,
    -0.2811723436604265,
    -0.24984642432648865,
    0.19594627437659665,
    0.12736934033574265,
    -0.09305736460380659,
    -0.07139414716586077,
    0.02945753682194567,
    0.03321267405893324,
    -0.0036065535669883944,
    -0.010733175482979604,
    -0.0013953517469940798,
    0.00199240529499085,
    0.0006858566950046825,
    -0.0001164668549943862,
    -9.358867000108985e-05,
    -1.326420300235487e-05,
};

DTYPE DB10_I_H[20] = {
    -1.326420300235487e-05,
    -9.358867000108985e-05,
    -0.0001164668549943862,
    0.0006858566950046825,
    0.00199240529499085,
    -0.0013953517469940798,
    -0.010733175482979604,
    -0.0036065535669883944,
    0.03321267405893324,
    0.02945753682194567,
    -0.07139414716586077,
    -0.09305736460380659,
    0.12736934033574265,
    0.19594627437659665,
    -0.24984642432648865,
    -0.2811723436604265,
    0.6884590394525921,
    -0.5272011889309198,
    0.18817680007762133,
    -0.026670057900950818,
};

DTYPE DB11_L[22] = {
    4.494274277236352e-06,
    -3.463498418698379e-05,
    5.443907469936638e-05,
    0.00024915252355281426,
    -0.0008930232506662366,
    -0.00030859285881515924,
    0.004928417656058778,
    -0.0033408588730145018,
    -0.015364820906201324,
    0.02084090436018004,
    0.03133509021904531,
    -0.06643878569502022,
    -0.04647995511667613,
    0.14981201246638268,
    0.06604358819669089,
    -0.27423084681792875,
    -0.16227524502747828,
    0.41196436894789695,
    0.6856867749161785,
    0.44989976435603013,
    0.1440670211506196,
    0.01869429776147044,
};

DTYPE DB11_I_L[22] = {
    0.01869429776147044,
    0.1440670211506196,
    0.44989976435603013,
    0.6856867749161785,
    0.41196436894789695,
    -0.16227524502747828,
    -0.27423084681792875,
    0.06604358819669089,
    0.14981201246638268,
    -0.04647995511667613,
    -0.06643878569502022,
    0.03133509021904531,
    0.02084090436018004,
    -0.015364820906201324,
    -0.0033408588730145018,
    0.004928417656058778,
    -0.00030859285881515924,
    -0.0008930232506662366,
    0.00024915252355281426,
    5.443907469936638e-05,
    -3.463498418698379e-05,
    4.494274277236352e-06,
};

DTYPE DB11_H[22] = {
    -0.01869429776147044,
    0.1440670211506196,
    -0.44989976435603013,
    0.6856867749161785,
    -0.41196436894789695,
    -0.16227524502747828,
    0.27423084681792875,
    0.06604358819669089,
    -0.14981201246638268,
    -0.04647995511667613,
    0.06643878569502022,
    0.03133509021904531,
    -0.02084090436018004,
    -0.015364820906201324,
    0.0033408588730145018,
    0.004928417656058778,
    0.00030859285881515924,
    -0.0008930232506662366,
    -0.00024915252355281426,
    5.443907469936638e-05,
    3.463498418698379e-05,
    4.494274277236352e-06,
};

DTYPE DB11_I_H[22] = {
    4.494274277236352e-06,
    3.463498418698379e-05,
    5.443907469936638e-05,
    -0.00024915252355281426,
    -0.0008930232506662366,
    0.00030859285881515924,
    0.004928417656058778,
    0.0033408588730145018,
    -0.015364820906201324,
    -0.02084090436018004,
    0.03133509021904531,
    0.06643878569502022,
    -0.04647995511667613,
    -0.14981201246638268,
    0.06604358819669089,
    0.27423084681792875,
    -0.16227524502747828,
    -0.41196436894789695,
    0.6856867749161785,
    -0.44989976435603013,
    0.1440670211506196,
    -0.01869429776147044,
};

DTYPE DB12_L[24] = {
    -1.5290717580684923e-06,
    1.2776952219379579e-05,
    -2.4241545757030318e-05,
    -8.850410920820318e-05,
    0.0003886530628209267,
    6.5451282125215034e-06,
    -0.0021795036186277044,
    0.0022486072409952287,
    0.006711499008795549,
    -0.012840825198299882,
    -0.01221864906974642,
    0.04154627749508764,
    0.010849130255828966,
    -0.09643212009649671,
    0.0053595696743599965,
    0.18247860592758275,
    -0.023779257256064865,
    -0.31617845375277914,
    -0.04476388565377762,
    0.5158864784278007,
    0.6571987225792911,
    0.3773551352142041,
    0.10956627282118277,
    0.013112257957229239,
};

DTYPE DB12_I_L[24] = {
    0.013112257957229239,
    0.10956627282118277,
    0.3773551352142041,
    0.6571987225792911,
    0.5158864784278007,
    -0.04476388565377762,
    -0.31617845375277914,
    -0.023779257256064865,
    0.18247860592758275,
    0.0053595696743599965,
    -0.09643212009649671,
    0.010849130255828966,
    0.04154627749508764,
    -0.01221864906974642,
    -0.012840825198299882,
    0.006711499008795549,
    0.0022486072409952287,
    -0.0021795036186277044,
    6.5451282125215034e-06,
    0.0003886530628209267,
    -8.850410920820318e-05,
    -2.4241545757030318e-05,
    1.2776952219379579e-05,
    -1.5290717580684923e-06,
};

DTYPE DB12_H[24] = {
    -0.013112257957229239,
    0.10956627282118277,
    -0.3773551352142041,
    0.6571987225792911,
    -0.5158864784278007,
    -0.04476388565377762,
    0.31617845375277914,
    -0.023779257256064865,
    -0.18247860592758275,
    0.0053595696743599965,
    0.09643212009649671,
    0.010849130255828966,
    -0.04154627749508764,
    -0.01221864906974642,
    0.012840825198299882,
    0.006711499008795549,
    -0.0022486072409952287,
    -0.0021795036186277044,
    -6.5451282125215034e-06,
    0.0003886530628209267,
    8.850410920820318e-05,
    -2.4241545757030318e-05,
    -1.2776952219379579e-05,
    -1.5290717580684923e-06,
};

DTYPE DB12_I_H[24] = {
    -1.5290717580684923e-06,
    -1.2776952219379579e-05,
    -2.4241545757030318e-05,
    8.850410920820318e-05,
    0.0003886530628209267,
    -6.5451282125215034e-06,
    -0.0021795036186277044,
    -0.0022486072409952287,
    0.006711499008795549,
    0.012840825198299882,
    -0.01221864906974642,
    -0.04154627749508764,
    0.010849130255828966,
    0.09643212009649671,
    0.0053595696743599965,
    -0.18247860592758275,
    -0.023779257256064865,
    0.31617845375277914,
    -0.04476388565377762,
    -0.5158864784278007,
    0.6571987225792911,
    -0.3773551352142041,
    0.10956627282118277,
    -0.013112257957229239,
};

DTYPE DB13_L[26] = {
    5.2200350984548e-07,
    -4.700416479360808e-06,
    1.0441930571407941e-05,
    3.067853757932436e-05,
    -0.0001651289885565057,
    4.9251525126285676e-05,
    0.000932326130867249,
    -0.0013156739118922766,
    -0.002761911234656831,
    0.007255589401617119,
    0.003923941448795577,
    -0.02383142071032781,
    0.002379972254052227,
    0.056139477100276156,
    -0.026488406475345658,
    -0.10580761818792761,
    0.07294893365678874,
    0.17947607942935084,
    -0.12457673075080665,
    -0.31497290771138414,
    0.086985726179645,
    0.5888895704312119,
    0.6110558511587811,
    0.3119963221604349,
    0.08286124387290195,
    0.009202133538962279,
};

DTYPE DB13_I_L[26] = {
    0.009202133538962279,
    0.08286124387290195,
    0.3119963221604349,
    0.6110558511587811,
    0.5888895704312119,
    0.086985726179645,
    -0.31497290771138414,
    -0.12457673075080665,
    0.17947607942935084,
    0.07294893365678874,
    -0.10580761818792761,
    -0.026488406475345658,
    0.056139477100276156,
    0.002379972254052227,
    -0.02383142071032781,
    0.003923941448795577,
    0.007255589401617119,
    -0.002761911234656831,
    -0.0013156739118922766,
    0.000932326130867249,
    4.9251525126285676e-05,
    -0.0001651289885565057,
    3.067853757932436e-05,
    1.0441930571407941e-05,
    -4.700416479360808e-06,
    5.2200350984548e-07,
};

DTYPE DB13_H[26] = {
    -0.009202133538962279,
    0.08286124387290195,
    -0.3119963221604349,
    0.6110558511587811,
    -0.5888895704312119,
    0.086985726179645,
    0.31497290771138414,
    -0.12457673075080665,
    -0.17947607942935084,
    0.07294893365678874,
    0.10580761818792761,
    -0.026488406475345658,
    -0.056139477100276156,
    0.002379972254052227,
    0.02383142071032781,
    0.003923941448795577,
    -0.007255589401617119,
    -0.002761911234656831,
    0.0013156739118922766,
    0.000932326130867249,
    -4.9251525126285676e-05,
    -0.0001651289885565057,
    -3.067853757932436e-05,
    1.0441930571407941e-05,
    4.700416479360808e-06,
    5.2200350984548e-07,
};

DTYPE DB13_I_H[26] = {
    5.2200350984548e-07,
    4.700416479360808e-06,
    1.0441930571407941e-05,
    -3.067853757932436e-05,
    -0.0001651289885565057,
    -4.9251525126285676e-05,
    0.000932326130867249,
    0.0013156739118922766,
    -0.002761911234656831,
    -0.007255589401617119,
    0.003923941448795577,
    0.02383142071032781,
    0.002379972254052227,
    -0.056139477100276156,
    -0.026488406475345658,
    0.10580761818792761,
    0.07294893365678874,
    -0.17947607942935084,
    -0.12457673075080665,
    0.31497290771138414,
    0.086985726179645,
    -0.5888895704312119,
    0.6110558511587811,
    -0.3119963221604349,
    0.08286124387290195,
    -0.009202133538962279,
};

DTYPE DB14_L[28] = {
    -1.7871399683109222e-07,
    1.7249946753674012e-06,
    -4.389704901780418e-06,
    -1.0337209184568496e-05,
    6.875504252695734e-05,
    -4.177724577037067e-05,
    -0.00038683194731287514,
    0.0007080211542354048,
    0.001061691085606874,
    -0.003849638868019787,
    -0.0007462189892638753,
    0.01278949326634007,
    -0.0056150495303375755,
    -0.030185351540353976,
    0.02698140830794797,
    0.05523712625925082,
    -0.0715489555039835,
    -0.0867484115681106,
    0.13998901658445695,
    0.13839521386479153,
    -0.2180335299932165,
    -0.27168855227867705,
    0.21867068775886594,
    0.6311878491047198,
    0.5543056179407709,
    0.25485026779256437,
    0.062364758849384874,
    0.0064611534600864905,
};

DTYPE DB14_I_L[28] = {
    0.0064611534600864905,
    0.062364758849384874,
    0.25485026779256437,
    0.5543056179407709,
    0.6311878491047198,
    0.21867068775886594,
    -0.27168855227867705,
    -0.2180335299932165,
    0.13839521386479153,
    0.13998901658445695,
    -0.0867484115681106,
    -0.0715489555039835,
    0.05523712625925082,
    0.02698140830794797,
    -0.030185351540353976,
    -0.0056150495303375755,
    0.01278949326634007,
    -0.0007462189892638753,
    -0.003849638868019787,
    0.001061691085606874,
    0.0007080211542354048,
    -0.00038683194731287514,
    -4.177724577037067e-05,
    6.875504252695734e-05,
    -1.0337209184568496e-05,
    -4.389704901780418e-06,
    1.7249946753674012e-06,
    -1.7871399683109222e-07,
};

DTYPE DB14_H[28] = {
    -0.0064611534600864905,
    0.062364758849384874,
    -0.25485026779256437,
    0.5543056179407709,
    -0.6311878491047198,
    0.21867068775886594,
    0.27168855227867705,
    -0.2180335299932165,
    -0.13839521386479153,
    0.13998901658445695,
    0.0867484115681106,
    -0.0715489555039835,
    -0.05523712625925082,
    0.02698140830794797,
    0.030185351540353976,
    -0.0056150495303375755,
    -0.01278949326634007,
    -0.0007462189892638753,
    0.003849638868019787,
    0.001061691085606874,
    -0.0007080211542354048,
    -0.00038683194731287514,
    4.177724577037067e-05,
    6.875504252695734e-05,
    1.0337209184568496e-05,
    -4.389704901780418e-06,
    -1.7249946753674012e-06,
    -1.7871399683109222e-07,
};

DTYPE DB14_I_H[28] = {
    -1.7871399683109222e-07,
    -1.7249946753674012e-06,
    -4.389704901780418e-06,
    1.0337209184568496e-05,
    6.875504252695734e-05,
    4.177724577037067e-05,
    -0.00038683194731287514,
    -0.0007080211542354048,
    0.001061691085606874,
    0.003849638868019787,
    -0.0007462189892638753,
    -0.01278949326634007,
    -0.0056150495303375755,
    0.030185351540353976,
    0.02698140830794797,
    -0.05523712625925082,
    -0.0715489555039835,
    0.0867484115681106,
    0.13998901658445695,
    -0.13839521386479153,
    -0.2180335299932165,
    0.27168855227867705,
    0.21867068775886594,
    -0.6311878491047198,
    0.5543056179407709,
    -0.25485026779256437,
    0.062364758849384874,
    -0.0064611534600864905,
};

DTYPE DB15_L[30] = {
    6.133359913303714e-08,
    -6.316882325879451e-07,
    1.8112704079399406e-06,
    3.3629871817363823e-06,
    -2.8133296266037558e-05,
    2.579269915531323e-05,
    0.00015589648992055726,
    -0.00035956524436229364,
    -0.0003734823541372647,
    0.0019433239803823459,
    -0.00024175649075894543,
    -0.0064877345603061454,
    0.005101000360422873,
    0.015083918027862582,
    -0.020810050169636805,
    -0.02576700732836694,
    0.054780550584559995,
    0.033877143923563204,
    -0.11112093603713753,
    -0.0396661765557336,
    0.19014671400708816,
    0.06528295284876569,
    -0.28888259656686216,
    -0.19320413960907623,
    0.33900253545462167,
    0.6458131403572103,
    0.4926317717079753,
    0.20602386398692688,
    0.04674339489275062,
    0.004538537361577376,
};

DTYPE DB15_I_L[30] = {
    0.004538537361577376,
    0.04674339489275062,
    0.20602386398692688,
    0.4926317717079753,
    0.6458131403572103,
    0.33900253545462167,
    -0.19320413960907623,
    -0.28888259656686216,
    0.06528295284876569,
    0.19014671400708816,
    -0.0396661765557336,
    -0.11112093603713753,
    0.033877143923563204,
    0.054780550584559995,
    -0.02576700732836694,
    -0.020810050169636805,
    0.015083918027862582,
    0.005101000360422873,
    -0.0064877345603061454,
    -0.00024175649075894543,
    0.0019433239803823459,
    -0.0003734823541372647,
    -0.00035956524436229364,
    0.00015589648992055726,
    2.579269915531323e-05,
    -2.8133296266037558e-05,
    3.3629871817363823e-06,
    1.8112704079399406e-06,
    -6.316882325879451e-07,
    6.133359913303714e-08,
};

DTYPE DB15_H[30] = {
    -0.004538537361577376,
    0.04674339489275062,
    -0.20602386398692688,
    0.4926317717079753,
    -0.6458131403572103,
    0.33900253545462167,
    0.19320413960907623,
    -0.28888259656686216,
    -0.06528295284876569,
    0.19014671400708816,
    0.0396661765557336,
    -0.11112093603713753,
    -0.033877143923563204,
    0.054780550584559995,
    0.02576700732836694,
    -0.020810050169636805,
    -0.015083918027862582,
    0.005101000360422873,
    0.0064877345603061454,
    -0.00024175649075894543,
    -0.0019433239803823459,
    -0.0003734823541372647,
    0.00035956524436229364,
    0.00015589648992055726,
    -2.579269915531323e-05,
    -2.8133296266037558e-05,
    -3.3629871817363823e-06,
    1.8112704079399406e-06,
    6.316882325879451e-07,
    6.133359913303714e-08,
};

DTYPE DB15_I_H[30] = {
    6.133359913303714e-08,
    6.316882325879451e-07,
    1.8112704079399406e-06,
    -3.3629871817363823e-06,
    -2.8133296266037558e-05,
    -2.579269915531323e-05,
    0.00015589648992055726,
    0.00035956524436229364,
    -0.0003734823541372647,
    -0.0019433239803823459,
    -0.00024175649075894543,
    0.0064877345603061454,
    0.005101000360422873,
    -0.015083918027862582,
    -0.020810050169636805,
    0.02576700732836694,
    0.054780550584559995,
    -0.033877143923563204,
    -0.11112093603713753,
    0.0396661765557336,
    0.19014671400708816,
    -0.06528295284876569,
    -0.28888259656686216,
    0.19320413960907623,
    0.33900253545462167,
    -0.6458131403572103,
    0.4926317717079753,
    -0.20602386398692688,
    0.04674339489275062,
    -0.004538537361577376,
};

DTYPE DB16_L[32] = {
    -2.1093396300980412e-08,
    2.3087840868545578e-07,
    -7.363656785441815e-07,
    -1.0435713423102517e-06,
    1.133660866126152e-05,
    -1.394566898819319e-05,
    -6.103596621404321e-05,
    0.00017478724522506327,
    0.00011424152003843815,
    -0.0009410217493585433,
    0.00040789698084934395,
    0.00312802338120381,
    -0.0036442796214883506,
    -0.006990014563390751,
    0.013993768859843242,
    0.010297659641009963,
    -0.036888397691556774,
    -0.007588974368642594,
    0.07592423604445779,
    -0.006239722752156254,
    -0.13238830556335474,
    0.027340263752899923,
    0.21119069394696974,
    -0.02791820813292813,
    -0.3270633105274758,
    -0.08975108940236352,
    0.44029025688580486,
    0.6373563320829833,
    0.43031272284545874,
    0.1650642834886438,
    0.03490771432362905,
    0.0031892209253436892,
};

DTYPE DB16_I_L[32] = {
    0.0031892209253436892,
    0.03490771432362905,
    0.1650642834886438,
    0.43031272284545874,
    0.6373563320829833,
    0.44029025688580486,
    -0.08975108940236352,
    -0.3270633105274758,
    -0.02791820813292813,
    0.21119069394696974,
    0.027340263752899923,
    -0.13238830556335474,
    -0.006239722752156254,
    0.07592423604445779,
    -0.007588974368642594,
    -0.036888397691556774,
    0.010297659641009963,
    0.013993768859843242,
    -0.006990014563390751,
    -0.0036442796214883506,
    0.00312802338120381,
    0.00040789698084934395,
    -0.0009410217493585433,
    0.00011424152003843815,
    0.00017478724522506327,
    -6.103596621404321e-05,
    -1.394566898819319e-05,
    1.133660866126152e-05,
    -1.0435713423102517e-06,
    -7.363656785441815e-07,
    2.3087840868545578e-07,
    -2.1093396300980412e-08,
};

DTYPE DB16_H[32] = {
    -0.0031892209253436892,
    0.03490771432362905,
    -0.1650642834886438,
    0.43031272284545874,
    -0.6373563320829833,
    0.44029025688580486,
    0.08975108940236352,
    -0.3270633105274758,
    0.02791820813292813,
    0.21119069394696974,
    -0.027340263752899923,
    -0.13238830556335474,
    0.006239722752156254,
    0.07592423604445779,
    0.007588974368642594,
    -0.036888397691556774,
    -0.010297659641009963,
    0.013993768859843242,
    0.006990014563390751,
    -0.0036442796214883506,
    -0.00312802338120381,
    0.00040789698084934395,
    0.0009410217493585433,
    0.00011424152003843815,
    -0.00017478724522506327,
    -6.103596621404321e-05,
    1.394566898819319e-05,
    1.133660866126152e-05,
    1.0435713423102517e-06,
    -7.363656785441815e-07,
    -2.3087840868545578e-07,
    -2.1093396300980412e-08,
};

DTYPE DB16_I_H[32] = {
    -2.1093396300980412e-08,
    -2.3087840868545578e-07,
    -7.363656785441815e-07,
    1.0435713423102517e-06,
    1.133660866126152e-05,
    1.394566898819319e-05,
    -6.103596621404321e-05,
    -0.00017478724522506327,
    0.00011424152003843815,
    0.0009410217493585433,
    0.00040789698084934395,
    -0.00312802338120381,
    -0.0036442796214883506,
    0.006990014563390751,
    0.013993768859843242,
    -0.010297659641009963,
    -0.036888397691556774,
    0.007588974368642594,
    0.07592423604445779,
    0.006239722752156254,
    -0.13238830556335474,
    -0.027340263752899923,
    0.21119069394696974,
    0.02791820813292813,
    -0.3270633105274758,
    0.08975108940236352,
    0.44029025688580486,
    -0.6373563320829833,
    0.43031272284545874,
    -0.1650642834886438,
    0.03490771432362905,
    -0.0031892209253436892,
};

DTYPE DB17_L[34] = {
    7.26749296856637e-09,
    -8.423948446008154e-08,
    2.9577009333187617e-07,
    3.0165496099963414e-07,
    -4.505942477225963e-06,
    6.990600985081294e-06,
    2.318681379876164e-05,
    -8.204803202458212e-05,
    -2.5610109566546042e-05,
    0.0004394654277689454,
    -0.00032813251941022427,
    -0.001436845304805,
    0.0023012052421511474,
    0.002967996691518064,
    -0.008602921520347815,
    -0.0030429899813869555,
    0.022733676583919053,
    -0.0032709555358783646,
    -0.04692243838937891,
    0.022312336178011833,
    0.08110598665408082,
    -0.05709141963185808,
    -0.12681569177849797,
    0.10113548917744287,
    0.19731058956508457,
    -0.12659975221599248,
    -0.32832074836418546,
    0.027314970403312946,
    0.5183157640572823,
    0.6109966156850273,
    0.3703507241528858,
    0.13121490330791097,
    0.025985393703623173,
    0.00224180700103879,
};

DTYPE DB17_I_L[34] = {
    0.00224180700103879,
    0.025985393703623173,
    0.13121490330791097,
    0.3703507241528858,
    0.6109966156850273,
    0.5183157640572823,
    0.027314970403312946,
    -0.32832074836418546,
    -0.12659975221599248,
    0.19731058956508457,
    0.10113548917744287,
    -0.12681569177849797,
    -0.05709141963185808,
    0.08110598665408082,
    0.022312336178011833,
    -0.04692243838937891,
    -0.0032709555358783646,
    0.022733676583919053,
    -0.0030429899813869555,
    -0.008602921520347815,
    0.002967996691518064,
    0.0023012052421511474,
    -0.001436845304805,
    -0.00032813251941022427,
    0.0004394654277689454,
    -2.5610109566546042e-05,
    -8.204803202458212e-05,
    2.318681379876164e-05,
    6.990600985081294e-06,
    -4.505942477225963e-06,
    3.0165496099963414e-07,
    2.9577009333187617e-07,
    -8.423948446008154e-08,
    7.26749296856637e-09,
};

DTYPE DB17_H[34] = {
    -0.00224180700103879,
    0.025985393703623173,
    -0.13121490330791097,
    0.3703507241528858,
    -0.6109966156850273,
    0.5183157640572823,
    -0.027314970403312946,
    -0.32832074836418546,
    0.12659975221599248,
    0.19731058956508457,
    -0.10113548917744287,
    -0.12681569177849797,
    0.05709141963185808,
    0.08110598665408082,
    -0.022312336178011833,
    -0.04692243838937891,
    0.0032709555358783646,
    0.022733676583919053,
    0.0030429899813869555,
    -0.008602921520347815,
    -0.002967996691518064,
    0.0023012052421511474,
    0.001436845304805,
    -0.00032813251941022427,
    -0.0004394654277689454,
    -2.5610109566546042e-05,
    8.204803202458212e-05,
    2.318681379876164e-05,
    -6.990600985081294e-06,
    -4.505942477225963e-06,
    -3.0165496099963414e-07,
    2.9577009333187617e-07,
    8.423948446008154e-08,
    7.26749296856637e-09,
};

DTYPE DB17_I_H[34] = {
    7.26749296856637e-09,
    8.423948446008154e-08,
    2.9577009333187617e-07,
    -3.0165496099963414e-07,
    -4.505942477225963e-06,
    -6.990600985081294e-06,
    2.318681379876164e-05,
    8.204803202458212e-05,
    -2.5610109566546042e-05,
    -0.0004394654277689454,
    -0.00032813251941022427,
    0.001436845304805,
    0.0023012052421511474,
    -0.002967996691518064,
    -0.008602921520347815,
    0.0030429899813869555,
    0.022733676583919053,
    0.0032709555358783646,
    -0.04692243838937891,
    -0.022312336178011833,
    0.08110598665408082,
    0.05709141963185808,
    -0.12681569177849797,
    -0.10113548917744287,
    0.19731058956508457,
    0.12659975221599248,
    -0.32832074836418546,
    -0.027314970403312946,
    0.5183157640572823,
    -0.6109966156850273,
    0.3703507241528858,
    -0.13121490330791097,
    0.025985393703623173,
    -0.00224180700103879,
};

DTYPE DB18_L[36] = {
    -2.507934454941929e-09,
    3.06883586303703e-08,
    -1.1760987670250871e-07,
    -7.691632689865049e-08,
    1.768712983622886e-06,
    -3.3326344788769603e-06,
    -8.520602537423464e-06,
    3.741237880730847e-05,
    -1.535917123021341e-07,
    -0.00019864855231101547,
    0.0002135815619103188,
    0.0006284656829644715,
    -0.0013405962983313922,
    -0.0011187326669886426,
    0.004943343605456594,
    0.00011863003387493042,
    -0.013051480946517112,
    0.006262167954438661,
    0.026670705926689853,
    -0.023733210395336858,
    -0.04452614190225633,
    0.05705124773905827,
    0.0648872162123582,
    -0.10675224665906288,
    -0.09233188415030412,
    0.16708131276294505,
    0.14953397556500755,
    -0.21648093400458224,
    -0.2936540407357981,
    0.14722311196952223,
    0.571801654887122,
    0.5718268077650818,
    0.31467894133619284,
    0.10358846582214751,
    0.01928853172409497,
    0.0015763102184365595,
};

DTYPE DB18_I_L[36] = {
    0.0015763102184365595,
    0.01928853172409497,
    0.10358846582214751,
    0.31467894133619284,
    0.5718268077650818,
    0.571801654887122,
    0.14722311196952223,
    -0.2936540407357981,
    -0.21648093400458224,
    0.14953397556500755,
    0.16708131276294505,
    -0.09233188415030412,
    -0.10675224665906288,
    0.0648872162123582,
    0.05705124773905827,
    -0.04452614190225633,
    -0.023733210395336858,
    0.026670705926689853,
    0.006262167954438661,
    -0.013051480946517112,
    0.00011863003387493042,
    0.004943343605456594,
    -0.0011187326669886426,
    -0.0013405962983313922,
    0.0006284656829644715,
    0.0002135815619103188,
    -0.00019864855231101547,
    -1.535917123021341e-07,
    3.741237880730847e-05,
    -8.520602537423464e-06,
    -3.3326344788769603e-06,
    1.768712983622886e-06,
    -7.691632689865049e-08,
    -1.1760987670250871e-07,
    3.06883586303703e-08,
    -2.507934454941929e-09,
};

DTYPE DB18_H[36] = {
    -0.0015763102184365595,
    0.01928853172409497,
    -0.10358846582214751,
    0.31467894133619284,
    -0.5718268077650818,
    0.571801654887122,
    -0.14722311196952223,
    -0.2936540407357981,
    0.21648093400458224,
    0.14953397556500755,
    -0.16708131276294505,
    -0.09233188415030412,
    0.10675224665906288,
    0.0648872162123582,
    -0.05705124773905827,
    -0.04452614190225633,
    0.023733210395336858,
    0.026670705926689853,
    -0.006262167954438661,
    -0.013051480946517112,
    -0.00011863003387493042,
    0.004943343605456594,
    0.0011187326669886426,
    -0.0013405962983313922,
    -0.0006284656829644715,
    0.0002135815619103188,
    0.00019864855231101547,
    -1.535917123021341e-07,
    -3.741237880730847e-05,
    -8.520602537423464e-06,
    3.3326344788769603e-06,
    1.768712983622886e-06,
    7.691632689865049e-08,
    -1.1760987670250871e-07,
    -3.06883586303703e-08,
    -2.507934454941929e-09,
};

DTYPE DB18_I_H[36] = {
    -2.507934454941929e-09,
    -3.06883586303703e-08,
    -1.1760987670250871e-07,
    7.691632689865049e-08,
    1.768712983622886e-06,
    3.3326344788769603e-06,
    -8.520602537423464e-06,
    -3.741237880730847e-05,
    -1.535917123021341e-07,
    0.00019864855231101547,
    0.0002135815619103188,
    -0.0006284656829644715,
    -0.0013405962983313922,
    0.0011187326669886426,
    0.004943343605456594,
    -0.00011863003387493042,
    -0.013051480946517112,
    -0.006262167954438661,
    0.026670705926689853,
    0.023733210395336858,
    -0.04452614190225633,
    -0.05705124773905827,
    0.0648872162123582,
    0.10675224665906288,
    -0.09233188415030412,
    -0.16708131276294505,
    0.14953397556500755,
    0.21648093400458224,
    -0.2936540407357981,
    -0.14722311196952223,
    0.571801654887122,
    -0.5718268077650818,
    0.31467894133619284,
    -0.10358846582214751,
    0.01928853172409497,
    -0.0015763102184365595,
};

DTYPE DB19_L[38] = {
    8.666848839034483e-10,
    -1.1164020670405678e-08,
    4.636937775802368e-08,
    1.447088298804088e-08,
    -6.86275565779811e-07,
    1.531931476697877e-06,
    3.0109643163099385e-06,
    -1.664017629722462e-05,
    5.105950487090694e-06,
    8.711270467250443e-05,
    -0.00012460079173506306,
    -0.0002606761356811995,
    0.0007358025205041731,
    0.00034180865344939543,
    -0.002687551800734441,
    0.0007689543592242488,
    0.007040747367080495,
    -0.005866922281112195,
    -0.013988388678695632,
    0.019375549889114482,
    0.021623767409452484,
    -0.04567422627778492,
    -0.026501236250778635,
    0.0869067555554507,
    0.02758435062488713,
    -0.14278569504021468,
    -0.03351854190320226,
    0.21234974330662043,
    0.07465226970806647,
    -0.28583863175723145,
    -0.22809139421653665,
    0.2608949526521201,
    0.6017045491300916,
    0.5244363774668862,
    0.26438843174202237,
    0.08127811326580564,
    0.01428109845082521,
    0.0011086697631864314,
};

DTYPE DB19_I_L[38] = {
    0.0011086697631864314,
    0.01428109845082521,
    0.08127811326580564,
    0.26438843174202237,
    0.5244363774668862,
    0.6017045491300916,
    0.2608949526521201,
    -0.22809139421653665,
    -0.28583863175723145,
    0.07465226970806647,
    0.21234974330662043,
    -0.03351854190320226,
    -0.14278569504021468,
    0.02758435062488713,
    0.0869067555554507,
    -0.026501236250778635,
    -0.04567422627778492,
    0.021623767409452484,
    0.019375549889114482,
    -0.013988388678695632,
    -0.005866922281112195,
    0.007040747367080495,
    0.0007689543592242488,
    -0.002687551800734441,
    0.00034180865344939543,
    0.0007358025205041731,
    -0.0002606761356811995,
    -0.00012460079173506306,
    8.711270467250443e-05,
    5.105950487090694e-06,
    -1.664017629722462e-05,
    3.0109643163099385e-06,
    1.531931476697877e-06,
    -6.86275565779811e-07,
    1.447088298804088e-08,
    4.636937775802368e-08,
    -1.1164020670405678e-08,
    8.666848839034483e-10,
};

DTYPE DB19_H[38] = {
    -0.0011086697631864314,
    0.01428109845082521,
    -0.08127811326580564,
    0.26438843174202237,
    -0.5244363774668862,
    0.6017045491300916,
    -0.2608949526521201,
    -0.22809139421653665,
    0.28583863175723145,
    0.07465226970806647,
    -0.21234974330662043,
    -0.03351854190320226,
    0.14278569504021468,
    0.02758435062488713,
    -0.0869067555554507,
    -0.026501236250778635,
    0.04567422627778492,
    0.021623767409452484,
    -0.019375549889114482,
    -0.013988388678695632,
    0.005866922281112195,
    0.007040747367080495,
    -0.0007689543592242488,
    -0.002687551800734441,
    -0.00034180865344939543,
    0.0007358025205041731,
    0.0002606761356811995,
    -0.00012460079173506306,
    -8.711270467250443e-05,
    5.105950487090694e-06,
    1.664017629722462e-05,
    3.0109643163099385e-06,
    -1.531931476697877e-06,
    -6.86275565779811e-07,
    -1.447088298804088e-08,
    4.636937775802368e-08,
    1.1164020670405678e-08,
    8.666848839034483e-10,
};

DTYPE DB19_I_H[38] = {
    8.666848839034483e-10,
    1.1164020670405678e-08,
    4.636937775802368e-08,
    -1.447088298804088e-08,
    -6.86275565779811e-07,
    -1.531931476697877e-06,
    3.0109643163099385e-06,
    1.664017629722462e-05,
    5.105950487090694e-06,
    -8.711270467250443e-05,
    -0.00012460079173506306,
    0.0002606761356811995,
    0.0007358025205041731,
    -0.00034180865344939543,
    -0.002687551800734441,
    -0.0007689543592242488,
    0.007040747367080495,
    0.005866922281112195,
    -0.013988388678695632,
    -0.019375549889114482,
    0.021623767409452484,
    0.04567422627778492,
    -0.026501236250778635,
    -0.0869067555554507,
    0.02758435062488713,
    0.14278569504021468,
    -0.03351854190320226,
    -0.21234974330662043,
    0.07465226970806647,
    0.28583863175723145,
    -0.22809139421653665,
    -0.2608949526521201,
    0.6017045491300916,
    -0.5244363774668862,
    0.26438843174202237,
    -0.08127811326580564,
    0.01428109845082521,
    -0.0011086697631864314,
};

DTYPE DB20_L[40] = {
    -2.998836489615753e-10,
    4.05612705554717e-09,
    -1.814843248297622e-08,
    2.0143220235374613e-10,
    2.633924226266962e-07,
    -6.847079596993149e-07,
    -1.0119940100181473e-06,
    7.241248287663791e-06,
    -4.376143862182197e-06,
    -3.710586183390615e-05,
    6.774280828373048e-05,
    0.00010153288973669777,
    -0.0003851047486990061,
    -5.349759844340453e-05,
    0.0013925596193045254,
    -0.0008315621728772474,
    -0.003581494259744107,
    0.00442054238676635,
    0.0067216273018096935,
    -0.013810526137727442,
    -0.008789324924555765,
    0.03229429953011916,
    0.0058746818113949465,
    -0.061722899624668884,
    0.005632246857685454,
    0.10229171917513397,
    -0.024716827337521424,
    -0.1554587507060453,
    0.039850246458519104,
    0.22829105082013823,
    -0.016727088308801888,
    -0.3267868004335376,
    -0.13921208801128787,
    0.36150229873889705,
    0.6104932389378558,
    0.4726961853103315,
    0.21994211355113222,
    0.06342378045900529,
    0.010549394624937735,
    0.0007799536136659112,
};

DTYPE DB20_I_L[40] = {
    0.0007799536136659112,
    0.010549394624937735,
    0.06342378045900529,
    0.21994211355113222,
    0.4726961853103315,
    0.6104932389378558,
    0.36150229873889705,
    -0.13921208801128787,
    -0.3267868004335376,
    -0.016727088308801888,
    0.22829105082013823,
    0.039850246458519104,
    -0.1554587507060453,
    -0.024716827337521424,
    0.10229171917513397,
    0.005632246857685454,
    -0.061722899624668884,
    0.0058746818113949465,
    0.03229429953011916,
    -0.008789324924555765,
    -0.013810526137727442,
    0.0067216273018096935,
    0.00442054238676635,
    -0.003581494259744107,
    -0.0008315621728772474,
    0.0013925596193045254,
    -5.349759844340453e-05,
    -0.0003851047486990061,
    0.00010153288973669777,
    6.774280828373048e-05,
    -3.710586183390615e-05,
    -4.376143862182197e-06,
    7.241248287663791e-06,
    -1.0119940100181473e-06,
    -6.847079596993149e-07,
    2.633924226266962e-07,
    2.0143220235374613e-10,
    -1.814843248297622e-08,
    4.05612705554717e-09,
    -2.998836489615753e-10,
};

DTYPE DB20_H[40] = {
    -0.0007799536136659112,
    0.010549394624937735,
    -0.06342378045900529,
    0.21994211355113222,
    -0.4726961853103315,
    0.6104932389378558,
    -0.36150229873889705,
    -0.13921208801128787,
    0.3267868004335376,
    -0.016727088308801888,
    -0.22829105082013823,
    0.039850246458519104,
    0.1554587507060453,
    -0.024716827337521424,
    -0.10229171917513397,
    0.005632246857685454,
    0.061722899624668884,
    0.0058746818113949465,
    -0.03229429953011916,
    -0.008789324924555765,
    0.013810526137727442,
    0.0067216273018096935,
    -0.00442054238676635,
    -0.003581494259744107,
    0.0008315621728772474,
    0.0013925596193045254,
    5.349759844340453e-05,
    -0.0003851047486990061,
    -0.00010153288973669777,
    6.774280828373048e-05,
    3.710586183390615e-05,
    -4.376143862182197e-06,
    -7.241248287663791e-06,
    -1.0119940100181473e-06,
    6.847079596993149e-07,
    2.633924226266962e-07,
    -2.0143220235374613e-10,
    -1.814843248297622e-08,
    -4.05612705554717e-09,
    -2.998836489615753e-10,
};

DTYPE DB20_I_H[40] = {
    -2.998836489615753e-10,
    -4.05612705554717e-09,
    -1.814843248297622e-08,
    -2.0143220235374613e-10,
    2.633924226266962e-07,
    6.847079596993149e-07,
    -1.0119940100181473e-06,
    -7.241248287663791e-06,
    -4.376143862182197e-06,
    3.710586183390615e-05,
    6.774280828373048e-05,
    -0.00010153288973669777,
    -0.0003851047486990061,
    5.349759844340453e-05,
    0.0013925596193045254,
    0.0008315621728772474,
    -0.003581494259744107,
    -0.00442054238676635,
    0.0067216273018096935,
    0.013810526137727442,
    -0.008789324924555765,
    -0.03229429953011916,
    0.0058746818113949465,
    0.061722899624668884,
    0.005632246857685454,
    -0.10229171917513397,
    -0.024716827337521424,
    0.1554587507060453,
    0.039850246458519104,
    -0.22829105082013823,
    -0.016727088308801888,
    0.3267868004335376,
    -0.13921208801128787,
    -0.36150229873889705,
    0.6104932389378558,
    -0.4726961853103315,
    0.21994211355113222,
    -0.06342378045900529,
    0.010549394624937735,
    -0.0007799536136659112,
};

DTYPE SYM2_L[4] = {
    -0.12940952255092145,
    0.22414386804185735,
    0.836516303737469,
    0.48296291314469025,
};

DTYPE SYM2_I_L[4] = {
    0.48296291314469025,
    0.836516303737469,
    0.22414386804185735,
    -0.12940952255092145,
};

DTYPE SYM2_H[4] = {
    -0.48296291314469025,
    0.836516303737469,
    -0.22414386804185735,
    -0.12940952255092145,
};

DTYPE SYM2_I_H[4] = {
    -0.12940952255092145,
    -0.22414386804185735,
    0.836516303737469,
    -0.48296291314469025,
};

DTYPE SYM3_L[6] = {
    0.035226291882100656,
    -0.08544127388224149,
    -0.13501102001039084,
    0.4598775021193313,
    0.8068915093133388,
    0.3326705529509569,
};

DTYPE SYM3_I_L[6] = {
    0.3326705529509569,
    0.8068915093133388,
    0.4598775021193313,
    -0.13501102001039084,
    -0.08544127388224149,
    0.035226291882100656,
};

DTYPE SYM3_H[6] = {
    -0.3326705529509569,
    0.8068915093133388,
    -0.4598775021193313,
    -0.13501102001039084,
    0.08544127388224149,
    0.035226291882100656,
};

DTYPE SYM3_I_H[6] = {
    0.035226291882100656,
    0.08544127388224149,
    -0.13501102001039084,
    -0.4598775021193313,
    0.8068915093133388,
    -0.3326705529509569,
};

DTYPE SYM4_L[8] = {
    -0.07576571478927333,
    -0.02963552764599851,
    0.49761866763201545,
    0.8037387518059161,
    0.29785779560527736,
    -0.09921954357684722,
    -0.012603967262037833,
    0.0322231006040427,
};

DTYPE SYM4_I_L[8] = {
    0.0322231006040427,
    -0.012603967262037833,
    -0.09921954357684722,
    0.29785779560527736,
    0.8037387518059161,
    0.49761866763201545,
    -0.02963552764599851,
    -0.07576571478927333,
};

DTYPE SYM4_H[8] = {
    -0.0322231006040427,
    -0.012603967262037833,
    0.09921954357684722,
    0.29785779560527736,
    -0.8037387518059161,
    0.49761866763201545,
    0.02963552764599851,
    -0.07576571478927333,
};

DTYPE SYM4_I_H[8] = {
    -0.07576571478927333,
    0.02963552764599851,
    0.49761866763201545,
    -0.8037387518059161,
    0.29785779560527736,
    0.09921954357684722,
    -0.012603967262037833,
    -0.0322231006040427,
};

DTYPE SYM5_L[10] = {
    0.027333068345077982,
    0.029519490925774643,
    -0.039134249302383094,
    0.1993975339773936,
    0.7234076904024206,
    0.6339789634582119,
    0.01660210576452232,
    -0.17532808990845047,
    -0.021101834024758855,
    0.019538882735286728,
};

DTYPE SYM5_I_L[10] = {
    0.019538882735286728,
    -0.021101834024758855,
    -0.17532808990845047,
    0.01660210576452232,
    0.6339789634582119,
    0.7234076904024206,
    0.1993975339773936,
    -0.039134249302383094,
    0.029519490925774643,
    0.027333068345077982,
};

DTYPE SYM5_H[10] = {
    -0.019538882735286728,
    -0.021101834024758855,
    0.17532808990845047,
    0.01660210576452232,
    -0.6339789634582119,
    0.7234076904024206,
    -0.1993975339773936,
    -0.039134249302383094,
    -0.029519490925774643,
    0.027333068345077982,
};

DTYPE SYM5_I_H[10] = {
    0.027333068345077982,
    -0.029519490925774643,
    -0.039134249302383094,
    -0.1993975339773936,
    0.7234076904024206,
    -0.6339789634582119,
    0.01660210576452232,
    0.17532808990845047,
    -0.021101834024758855,
    -0.019538882735286728,
};

DTYPE SYM6_L[12] = {
    0.015404109327027373,
    0.0034907120842174702,
    -0.11799011114819057,
    -0.048311742585633,
    0.4910559419267466,
    0.787641141030194,
    0.3379294217276218,
    -0.07263752278646252,
    -0.021060292512300564,
    0.04472490177066578,
    0.0017677118642428036,
    -0.007800708325034148,
};

DTYPE SYM6_I_L[12] = {
    -0.007800708325034148,
    0.0017677118642428036,
    0.04472490177066578,
    -0.021060292512300564,
    -0.07263752278646252,
    0.3379294217276218,
    0.787641141030194,
    0.4910559419267466,
    -0.048311742585633,
    -0.11799011114819057,
    0.0034907120842174702,
    0.015404109327027373,
};

DTYPE SYM6_H[12] = {
    0.007800708325034148,
    0.0017677118642428036,
    -0.04472490177066578,
    -0.021060292512300564,
    0.07263752278646252,
    0.3379294217276218,
    -0.787641141030194,
    0.4910559419267466,
    0.048311742585633,
    -0.11799011114819057,
    -0.0034907120842174702,
    0.015404109327027373,
};

DTYPE SYM6_I_H[12] = {
    0.015404109327027373,
    -0.0034907120842174702,
    -0.11799011114819057,
    0.048311742585633,
    0.4910559419267466,
    -0.787641141030194,
    0.3379294217276218,
    0.07263752278646252,
    -0.021060292512300564,
    -0.04472490177066578,
    0.0017677118642428036,
    0.007800708325034148,
};

DTYPE SYM7_L[14] = {
    0.002681814568257878,
    -0.0010473848886829163,
    -0.01263630340325193,
    0.03051551316596357,
    0.0678926935013727,
    -0.049552834937127255,
    0.017441255086855827,
    0.5361019170917628,
    0.767764317003164,
    0.2886296317515146,
    -0.14004724044296152,
    -0.10780823770381774,
    0.004010244871533663,
    0.010268176708511255,
};

DTYPE SYM7_I_L[14] = {
    0.010268176708511255,
    0.004010244871533663,
    -0.10780823770381774,
    -0.14004724044296152,
    0.2886296317515146,
    0.767764317003164,
    0.5361019170917628,
    0.017441255086855827,
    -0.049552834937127255,
    0.0678926935013727,
    0.03051551316596357,
    -0.01263630340325193,
    -0.0010473848886829163,
    0.002681814568257878,
};

DTYPE SYM7_H[14] = {
    -0.010268176708511255,
    0.004010244871533663,
    0.10780823770381774,
    -0.14004724044296152,
    -0.2886296317515146,
    0.767764317003164,
    -0.5361019170917628,
    0.017441255086855827,
    0.049552834937127255,
    0.0678926935013727,
    -0.03051551316596357,
    -0.01263630340325193,
    0.0010473848886829163,
    0.002681814568257878,
};

DTYPE SYM7_I_H[14] = {
    0.002681814568257878,
    0.0010473848886829163,
    -0.01263630340325193,
    -0.03051551316596357,
    0.0678926935013727,
    0.049552834937127255,
    0.017441255086855827,
    -0.5361019170917628,
    0.767764317003164,
    -0.2886296317515146,
    -0.14004724044296152,
    0.10780823770381774,
    0.004010244871533663,
    -0.010268176708511255,
};

DTYPE SYM8_L[16] = {
    -0.0033824159510061256,
    -0.0005421323317911481,
    0.03169508781149298,
    0.007607487324917605,
    -0.1432942383508097,
    -0.061273359067658524,
    0.4813596512583722,
    0.7771857517005235,
    0.3644418948353314,
    -0.05194583810770904,
    -0.027219029917056003,
    0.049137179673607506,
    0.003808752013890615,
    -0.01495225833704823,
    -0.0003029205147213668,
    0.0018899503327594609,
};

DTYPE SYM8_I_L[16] = {
    0.0018899503327594609,
    -0.0003029205147213668,
    -0.01495225833704823,
    0.003808752013890615,
    0.049137179673607506,
    -0.027219029917056003,
    -0.05194583810770904,
    0.3644418948353314,
    0.7771857517005235,
    0.4813596512583722,
    -0.061273359067658524,
    -0.1432942383508097,
    0.007607487324917605,
    0.03169508781149298,
    -0.0005421323317911481,
    -0.0033824159510061256,
};

DTYPE SYM8_H[16] = {
    -0.0018899503327594609,
    -0.0003029205147213668,
    0.01495225833704823,
    0.003808752013890615,
    -0.049137179673607506,
    -0.027219029917056003,
    0.05194583810770904,
    0.3644418948353314,
    -0.7771857517005235,
    0.4813596512583722,
    0.061273359067658524,
    -0.1432942383508097,
    -0.007607487324917605,
    0.03169508781149298,
    0.0005421323317911481,
    -0.0033824159510061256,
};

DTYPE SYM8_I_H[16] = {
    -0.0033824159510061256,
    0.0005421323317911481,
    0.03169508781149298,
    -0.007607487324917605,
    -0.1432942383508097,
    0.061273359067658524,
    0.4813596512583722,
    -0.7771857517005235,
    0.3644418948353314,
    0.05194583810770904,
    -0.027219029917056003,
    -0.049137179673607506,
    0.003808752013890615,
    0.01495225833704823,
    -0.0003029205147213668,
    -0.0018899503327594609,
};

DTYPE SYM9_L[18] = {
    0.0014009155259146807,
    0.0006197808889855868,
    -0.013271967781817119,
    -0.01152821020767923,
    0.03022487885827568,
    0.0005834627461258068,
    -0.05456895843083407,
    0.238760914607303,
    0.717897082764412,
    0.6173384491409358,
    0.035272488035271894,
    -0.19155083129728512,
    -0.018233770779395985,
    0.06207778930288603,
    0.008859267493400484,
    -0.010264064027633142,
    -0.0004731544986800831,
    0.0010694900329086053,
};

DTYPE SYM9_I_L[18] = {
    0.0010694900329086053,
    -0.0004731544986800831,
    -0.010264064027633142,
    0.008859267493400484,
    0.06207778930288603,
    -0.018233770779395985,
    -0.19155083129728512,
    0.035272488035271894,
    0.6173384491409358,
    0.717897082764412,
    0.238760914607303,
    -0.05456895843083407,
    0.0005834627461258068,
    0.03022487885827568,
    -0.01152821020767923,
    -0.013271967781817119,
    0.0006197808889855868,
    0.0014009155259146807,
};

DTYPE SYM9_H[18] = {
    -0.0010694900329086053,
    -0.0004731544986800831,
    0.010264064027633142,
    0.008859267493400484,
    -0.06207778930288603,
    -0.018233770779395985,
    0.19155083129728512,
    0.035272488035271894,
    -0.6173384491409358,
    0.717897082764412,
    -0.238760914607303,
    -0.05456895843083407,
    -0.0005834627461258068,
    0.03022487885827568,
    0.01152821020767923,
    -0.013271967781817119,
    -0.0006197808889855868,
    0.0014009155259146807,
};

DTYPE SYM9_I_H[18] = {
    0.0014009155259146807,
    -0.0006197808889855868,
    -0.013271967781817119,
    0.01152821020767923,
    0.03022487885827568,
    -0.0005834627461258068,
    -0.05456895843083407,
    -0.238760914607303,
    0.717897082764412,
    -0.6173384491409358,
    0.035272488035271894,
    0.19155083129728512,
    -0.018233770779395985,
    -0.06207778930288603,
    0.008859267493400484,
    0.010264064027633142,
    -0.0004731544986800831,
    -0.0010694900329086053,
};

DTYPE SYM10_L[20] = {
    0.0007701598091144901,
    9.563267072289475e-05,
    -0.008641299277022422,
    -0.0014653825813050513,
    0.0459272392310922,
    0.011609893903711381,
    -0.15949427888491757,
    -0.07088053578324385,
    0.47169066693843925,
    0.7695100370211071,
    0.38382676106708546,
    -0.03553674047381755,
    -0.0319900568824278,
    0.04999497207737669,
    0.005764912033581909,
    -0.02035493981231129,
    -0.0008043589320165449,
    0.004593173585311828,
    5.7036083618494284e-05,
    -0.0004593294210046588,
};

DTYPE SYM10_I_L[20] = {
    -0.0004593294210046588,
    5.7036083618494284e-05,
    0.004593173585311828,
    -0.0008043589320165449,
    -0.02035493981231129,
    0.005764912033581909,
    0.04999497207737669,
    -0.0319900568824278,
    -0.03553674047381755,
    0.38382676106708546,
    0.7695100370211071,
    0.47169066693843925,
    -0.07088053578324385,
    -0.15949427888491757,
    0.011609893903711381,
    0.0459272392310922,
    -0.0014653825813050513,
    -0.008641299277022422,
    9.563267072289475e-05,
    0.0007701598091144901,
};

DTYPE SYM10_H[20] = {
    0.0004593294210046588,
    5.7036083618494284e-05,
    -0.004593173585311828,
    -0.0008043589320165449,
    0.02035493981231129,
    0.005764912033581909,
    -0.04999497207737669,
    -0.0319900568824278,
    0.03553674047381755,
    0.38382676106708546,
    -0.7695100370211071,
    0.47169066693843925,
    0.07088053578324385,
    -0.15949427888491757,
    -0.011609893903711381,
    0.0459272392310922,
    0.0014653825813050513,
    -0.008641299277022422,
    -9.563267072289475e-05,
    0.0007701598091144901,
};

DTYPE SYM10_I_H[20] = {
    0.0007701598091144901,
    -9.563267072289475e-05,
    -0.008641299277022422,
    0.0014653825813050513,
    0.0459272392310922,
    -0.011609893903711381,
    -0.15949427888491757,
    0.07088053578324385,
    0.47169066693843925,
    -0.7695100370211071,
    0.38382676106708546,
    0.03553674047381755,
    -0.0319900568824278,
    -0.04999497207737669,
    0.005764912033581909,
    0.02035493981231129,
    -0.0008043589320165449,
    -0.004593173585311828,
    5.7036083618494284e-05,
    0.0004593294210046588,
};

DTYPE SYM11_L[22] = {
    0.00017172195069934854,
    -3.8795655736158566e-05,
    -0.0017343662672978692,
    0.0005883527353969915,
    0.00651249567477145,
    -0.009857934828789794,
    -0.024080841595864003,
    0.0370374159788594,
    0.06997679961073414,
    -0.022832651022562687,
    0.09719839445890947,
    0.5720229780100871,
    0.7303435490883957,
    0.23768990904924897,
    -0.2046547944958006,
    -0.1446023437053156,
    0.03526675956446655,
    0.04300019068155228,
    -0.0020034719001093887,
    -0.006389603666454892,
    0.00011053509764272153,
    0.0004892636102619239,
};

DTYPE SYM11_I_L[22] = {
    0.0004892636102619239,
    0.00011053509764272153,
    -0.006389603666454892,
    -0.0020034719001093887,
    0.04300019068155228,
    0.03526675956446655,
    -0.1446023437053156,
    -0.2046547944958006,
    0.23768990904924897,
    0.7303435490883957,
    0.5720229780100871,
    0.09719839445890947,
    -0.022832651022562687,
    0.06997679961073414,
    0.0370374159788594,
    -0.024080841595864003,
    -0.009857934828789794,
    0.00651249567477145,
    0.0005883527353969915,
    -0.0017343662672978692,
    -3.8795655736158566e-05,
    0.00017172195069934854,
};

DTYPE SYM11_H[22] = {
    -0.0004892636102619239,
    0.00011053509764272153,
    0.006389603666454892,
    -0.0020034719001093887,
    -0.04300019068155228,
    0.03526675956446655,
    0.1446023437053156,
    -0.2046547944958006,
    -0.23768990904924897,
    0.7303435490883957,
    -0.5720229780100871,
    0.09719839445890947,
    0.022832651022562687,
    0.06997679961073414,
    -0.0370374159788594,
    -0.024080841595864003,
    0.009857934828789794,
    0.00651249567477145,
    -0.0005883527353969915,
    -0.0017343662672978692,
    3.8795655736158566e-05,
    0.00017172195069934854,
};

DTYPE SYM11_I_H[22] = {
    0.00017172195069934854,
    3.8795655736158566e-05,
    -0.0017343662672978692,
    -0.0005883527353969915,
    0.00651249567477145,
    0.009857934828789794,
    -0.024080841595864003,
    -0.0370374159788594,
    0.06997679961073414,
    0.022832651022562687,
    0.09719839445890947,
    -0.5720229780100871,
    0.7303435490883957,
    -0.23768990904924897,
    -0.2046547944958006,
    0.1446023437053156,
    0.03526675956446655,
    -0.04300019068155228,
    -0.0020034719001093887,
    0.006389603666454892,
    0.00011053509764272153,
    -0.0004892636102619239,
};

DTYPE SYM12_L[24] = {
    0.00011196719424656033,
    -1.1353928041541452e-05,
    -0.0013497557555715387,
    0.00018021409008538188,
    0.007414965517654251,
    -0.0014089092443297553,
    -0.024220722675013445,
    0.0075537806116804775,
    0.04917931829966084,
    -0.03584883073695439,
    -0.022162306170337816,
    0.39888597239022,
    0.7634790977836572,
    0.46274103121927235,
    -0.07833262231634322,
    -0.17037069723886492,
    0.01530174062247884,
    0.05780417944550566,
    -0.0026043910313322326,
    -0.014589836449234145,
    0.00030764779631059454,
    0.002350297614183465,
    -1.8158078862617515e-05,
    -0.0001790665869750869,
};

DTYPE SYM12_I_L[24] = {
    -0.0001790665869750869,
    -1.8158078862617515e-05,
    0.002350297614183465,
    0.00030764779631059454,
    -0.014589836449234145,
    -0.0026043910313322326,
    0.05780417944550566,
    0.01530174062247884,
    -0.17037069723886492,
    -0.07833262231634322,
    0.46274103121927235,
    0.7634790977836572,
    0.39888597239022,
    -0.022162306170337816,
    -0.03584883073695439,
    0.04917931829966084,
    0.0075537806116804775,
    -0.024220722675013445,
    -0.0014089092443297553,
    0.007414965517654251,
    0.00018021409008538188,
    -0.0013497557555715387,
    -1.1353928041541452e-05,
    0.00011196719424656033,
};

DTYPE SYM12_H[24] = {
    0.0001790665869750869,
    -1.8158078862617515e-05,
    -0.002350297614183465,
    0.00030764779631059454,
    0.014589836449234145,
    -0.0026043910313322326,
    -0.05780417944550566,
    0.01530174062247884,
    0.17037069723886492,
    -0.07833262231634322,
    -0.46274103121927235,
    0.7634790977836572,
    -0.39888597239022,
    -0.022162306170337816,
    0.03584883073695439,
    0.04917931829966084,
    -0.0075537806116804775,
    -0.024220722675013445,
    0.0014089092443297553,
    0.007414965517654251,
    -0.00018021409008538188,
    -0.0013497557555715387,
    1.1353928041541452e-05,
    0.00011196719424656033,
};

DTYPE SYM12_I_H[24] = {
    0.00011196719424656033,
    1.1353928041541452e-05,
    -0.0013497557555715387,
    -0.00018021409008538188,
    0.007414965517654251,
    0.0014089092443297553,
    -0.024220722675013445,
    -0.0075537806116804775,
    0.04917931829966084,
    0.03584883073695439,
    -0.022162306170337816,
    -0.39888597239022,
    0.7634790977836572,
    -0.46274103121927235,
    -0.07833262231634322,
    0.17037069723886492,
    0.01530174062247884,
    -0.05780417944550566,
    -0.0026043910313322326,
    0.014589836449234145,
    0.00030764779631059454,
    -0.002350297614183465,
    -1.8158078862617515e-05,
    0.0001790665869750869,
};

DTYPE SYM13_L[26] = {
    6.820325263075319e-05,
    -3.573862364868901e-05,
    -0.0011360634389281183,
    -0.0001709428585302221,
    0.0075262253899681,
    0.005296359738725025,
    -0.02021676813338983,
    -0.017211642726299048,
    0.013862497435849205,
    -0.0597506277179437,
    -0.12436246075153011,
    0.19770481877117801,
    0.6957391505614964,
    0.6445643839011856,
    0.11023022302137217,
    -0.14049009311363403,
    0.008819757670420546,
    0.09292603089913712,
    0.017618296880653084,
    -0.020749686325515677,
    -0.0014924472742598532,
    0.0056748537601224395,
    0.00041326119884196064,
    -0.0007213643851362283,
    3.690537342319624e-05,
    7.042986690694402e-05,
};

DTYPE SYM13_I_L[26] = {
    7.042986690694402e-05,
    3.690537342319624e-05,
    -0.0007213643851362283,
    0.00041326119884196064,
    0.0056748537601224395,
    -0.0014924472742598532,
    -0.020749686325515677,
    0.017618296880653084,
    0.09292603089913712,
    0.008819757670420546,
    -0.14049009311363403,
    0.11023022302137217,
    0.6445643839011856,
    0.6957391505614964,
    0.19770481877117801,
    -0.12436246075153011,
    -0.0597506277179437,
    0.013862497435849205,
    -0.017211642726299048,
    -0.02021676813338983,
    0.005296359738725025,
    0.0075262253899681,
    -0.0001709428585302221,
    -0.0011360634389281183,
    -3.573862364868901e-05,
    6.820325263075319e-05,
};

DTYPE SYM13_H[26] = {
    -7.042986690694402e-05,
    3.690537342319624e-05,
    0.0007213643851362283,
    0.00041326119884196064,
    -0.0056748537601224395,
    -0.0014924472742598532,
    0.020749686325515677,
    0.017618296880653084,
    -0.09292603089913712,
    0.008819757670420546,
    0.14049009311363403,
    0.11023022302137217,
    -0.6445643839011856,
    0.6957391505614964,
    -0.19770481877117801,
    -0.12436246075153011,
    0.0597506277179437,
    0.013862497435849205,
    0.017211642726299048,
    -0.02021676813338983,
    -0.005296359738725025,
    0.0075262253899681,
    0.0001709428585302221,
    -0.0011360634389281183,
    3.573862364868901e-05,
    6.820325263075319e-05,
};

DTYPE SYM13_I_H[26] = {
    6.820325263075319e-05,
    3.573862364868901e-05,
    -0.0011360634389281183,
    0.0001709428585302221,
    0.0075262253899681,
    -0.005296359738725025,
    -0.02021676813338983,
    0.017211642726299048,
    0.013862497435849205,
    0.0597506277179437,
    -0.12436246075153011,
    -0.19770481877117801,
    0.6957391505614964,
    -0.6445643839011856,
    0.11023022302137217,
    0.14049009311363403,
    0.008819757670420546,
    -0.09292603089913712,
    0.017618296880653084,
    0.020749686325515677,
    -0.0014924472742598532,
    -0.0056748537601224395,
    0.00041326119884196064,
    0.0007213643851362283,
    3.690537342319624e-05,
    -7.042986690694402e-05,
};

DTYPE SYM14_L[28] = {
    -2.5879090265397886e-05,
    1.1210865808890361e-05,
    0.00039843567297594335,
    -6.286542481477636e-05,
    -0.002579441725933078,
    0.0003664765736601183,
    0.01003769371767227,
    -0.002753774791224071,
    -0.029196217764038187,
    0.004280520499019378,
    0.03743308836285345,
    -0.057634498351326995,
    -0.03531811211497973,
    0.39320152196208885,
    0.7599762419610909,
    0.4753357626342066,
    -0.05811182331771783,
    -0.15999741114652205,
    0.02589858753104667,
    0.06982761636180755,
    -0.002365048836740385,
    -0.019439314263626713,
    0.0010131419871842082,
    0.004532677471945648,
    -7.321421356702399e-05,
    -0.0006057601824664335,
    1.9329016965523917e-05,
    4.4618977991475265e-05,
};

DTYPE SYM14_I_L[28] = {
    4.4618977991475265e-05,
    1.9329016965523917e-05,
    -0.0006057601824664335,
    -7.321421356702399e-05,
    0.004532677471945648,
    0.0010131419871842082,
    -0.019439314263626713,
    -0.002365048836740385,
    0.06982761636180755,
    0.02589858753104667,
    -0.15999741114652205,
    -0.05811182331771783,
    0.4753357626342066,
    0.7599762419610909,
    0.39320152196208885,
    -0.03531811211497973,
    -0.057634498351326995,
    0.03743308836285345,
    0.004280520499019378,
    -0.029196217764038187,
    -0.002753774791224071,
    0.01003769371767227,
    0.0003664765736601183,
    -0.002579441725933078,
    -6.286542481477636e-05,
    0.00039843567297594335,
    1.1210865808890361e-05,
    -2.5879090265397886e-05,
};

DTYPE SYM14_H[28] = {
    -4.4618977991475265e-05,
    1.9329016965523917e-05,
    0.0006057601824664335,
    -7.321421356702399e-05,
    -0.004532677471945648,
    0.0010131419871842082,
    0.019439314263626713,
    -0.002365048836740385,
    -0.06982761636180755,
    0.02589858753104667,
    0.15999741114652205,
    -0.05811182331771783,
    -0.4753357626342066,
    0.7599762419610909,
    -0.39320152196208885,
    -0.03531811211497973,
    0.057634498351326995,
    0.03743308836285345,
    -0.004280520499019378,
    -0.029196217764038187,
    0.002753774791224071,
    0.01003769371767227,
    -0.0003664765736601183,
    -0.002579441725933078,
    6.286542481477636e-05,
    0.00039843567297594335,
    -1.1210865808890361e-05,
    -2.5879090265397886e-05,
};

DTYPE SYM14_I_H[28] = {
    -2.5879090265397886e-05,
    -1.1210865808890361e-05,
    0.00039843567297594335,
    6.286542481477636e-05,
    -0.002579441725933078,
    -0.0003664765736601183,
    0.01003769371767227,
    0.002753774791224071,
    -0.029196217764038187,
    -0.004280520499019378,
    0.03743308836285345,
    0.057634498351326995,
    -0.03531811211497973,
    -0.39320152196208885,
    0.7599762419610909,
    -0.4753357626342066,
    -0.05811182331771783,
    0.15999741114652205,
    0.02589858753104667,
    -0.06982761636180755,
    -0.002365048836740385,
    0.019439314263626713,
    0.0010131419871842082,
    -0.004532677471945648,
    -7.321421356702399e-05,
    0.0006057601824664335,
    1.9329016965523917e-05,
    -4.4618977991475265e-05,
};

DTYPE SYM15_L[30] = {
    9.712419737963348e-06,
    -7.35966679891947e-06,
    -0.00016066186637495343,
    5.512254785558665e-05,
    0.0010705672194623959,
    -0.0002673164464718057,
    -0.0035901654473726417,
    0.003423450736351241,
    0.01007997708790567,
    -0.01940501143093447,
    -0.03887671687683349,
    0.021937642719753955,
    0.04073547969681068,
    -0.04108266663538248,
    0.11153369514261872,
    0.5786404152150345,
    0.7218430296361812,
    0.2439627054321663,
    -0.1966263587662373,
    -0.1340562984562539,
    0.06839331006048024,
    0.06796982904487918,
    -0.008744788886477952,
    -0.01717125278163873,
    0.0015261382781819983,
    0.003481028737064895,
    -0.00010815440168545525,
    -0.00040216853760293483,
    2.171789015077892e-05,
    2.866070852531808e-05,
};

DTYPE SYM15_I_L[30] = {
    2.866070852531808e-05,
    2.171789015077892e-05,
    -0.00040216853760293483,
    -0.00010815440168545525,
    0.003481028737064895,
    0.0015261382781819983,
    -0.01717125278163873,
    -0.008744788886477952,
    0.06796982904487918,
    0.06839331006048024,
    -0.1340562984562539,
    -0.1966263587662373,
    0.2439627054321663,
    0.7218430296361812,
    0.5786404152150345,
    0.11153369514261872,
    -0.04108266663538248,
    0.04073547969681068,
    0.021937642719753955,
    -0.03887671687683349,
    -0.01940501143093447,
    0.01007997708790567,
    0.003423450736351241,
    -0.0035901654473726417,
    -0.0002673164464718057,
    0.0010705672194623959,
    5.512254785558665e-05,
    -0.00016066186637495343,
    -7.35966679891947e-06,
    9.712419737963348e-06,
};

DTYPE SYM15_H[30] = {
    -2.866070852531808e-05,
    2.171789015077892e-05,
    0.00040216853760293483,
    -0.00010815440168545525,
    -0.003481028737064895,
    0.0015261382781819983,
    0.01717125278163873,
    -0.008744788886477952,
    -0.06796982904487918,
    0.06839331006048024,
    0.1340562984562539,
    -0.1966263587662373,
    -0.2439627054321663,
    0.7218430296361812,
    -0.5786404152150345,
    0.11153369514261872,
    0.04108266663538248,
    0.04073547969681068,
    -0.021937642719753955,
    -0.03887671687683349,
    0.01940501143093447,
    0.01007997708790567,
    -0.003423450736351241,
    -0.0035901654473726417,
    0.0002673164464718057,
    0.0010705672194623959,
    -5.512254785558665e-05,
    -0.00016066186637495343,
    7.35966679891947e-06,
    9.712419737963348e-06,
};

DTYPE SYM15_I_H[30] = {
    9.712419737963348e-06,
    7.35966679891947e-06,
    -0.00016066186637495343,
    -5.512254785558665e-05,
    0.0010705672194623959,
    0.0002673164464718057,
    -0.0035901654473726417,
    -0.003423450736351241,
    0.01007997708790567,
    0.01940501143093447,
    -0.03887671687683349,
    -0.021937642719753955,
    0.04073547969681068,
    0.04108266663538248,
    0.11153369514261872,
    -0.5786404152150345,
    0.7218430296361812,
    -0.2439627054321663,
    -0.1966263587662373,
    0.1340562984562539,
    0.06839331006048024,
    -0.06796982904487918,
    -0.008744788886477952,
    0.01717125278163873,
    0.0015261382781819983,
    -0.003481028737064895,
    -0.00010815440168545525,
    0.00040216853760293483,
    2.171789015077892e-05,
    -2.866070852531808e-05,
};

DTYPE SYM16_L[32] = {
    6.230006701220761e-06,
    -3.113556407621969e-06,
    -0.00010943147929529757,
    2.8078582128442894e-05,
    0.0008523547108047095,
    -0.0001084456223089688,
    -0.0038809122526038786,
    0.0007182119788317892,
    0.012666731659857348,
    -0.0031265171722710075,
    -0.031051202843553064,
    0.004869274404904607,
    0.032333091610663785,
    -0.06698304907021778,
    -0.034574228416972504,
    0.39712293362064416,
    0.7565249878756971,
    0.47534280601152273,
    -0.054040601387606135,
    -0.15959219218520598,
    0.03072113906330156,
    0.07803785290341991,
    -0.003510275068374009,
    -0.024952758046290123,
    0.001359844742484172,
    0.0069377611308027096,
    -0.00022211647621176323,
    -0.0013387206066921965,
    3.656592483348223e-05,
    0.00016545679579108483,
    -5.396483179315242e-06,
    -1.0797982104319795e-05,
};

DTYPE SYM16_I_L[32] = {
    -1.0797982104319795e-05,
    -5.396483179315242e-06,
    0.00016545679579108483,
    3.656592483348223e-05,
    -0.0013387206066921965,
    -0.00022211647621176323,
    0.0069377611308027096,
    0.001359844742484172,
    -0.024952758046290123,
    -0.003510275068374009,
    0.07803785290341991,
    0.03072113906330156,
    -0.15959219218520598,
    -0.054040601387606135,
    0.47534280601152273,
    0.7565249878756971,
    0.39712293362064416,
    -0.034574228416972504,
    -0.06698304907021778,
    0.032333091610663785,
    0.004869274404904607,
    -0.031051202843553064,
    -0.0031265171722710075,
    0.012666731659857348,
    0.0007182119788317892,
    -0.0038809122526038786,
    -0.0001084456223089688,
    0.0008523547108047095,
    2.8078582128442894e-05,
    -0.00010943147929529757,
    -3.113556407621969e-06,
    6.230006701220761e-06,
};

DTYPE SYM16_H[32] = {
    1.0797982104319795e-05,
    -5.396483179315242e-06,
    -0.00016545679579108483,
    3.656592483348223e-05,
    0.0013387206066921965,
    -0.00022211647621176323,
    -0.0069377611308027096,
    0.001359844742484172,
    0.024952758046290123,
    -0.003510275068374009,
    -0.07803785290341991,
    0.03072113906330156,
    0.15959219218520598,
    -0.054040601387606135,
    -0.47534280601152273,
    0.7565249878756971,
    -0.39712293362064416,
    -0.034574228416972504,
    0.06698304907021778,
    0.032333091610663785,
    -0.004869274404904607,
    -0.031051202843553064,
    0.0031265171722710075,
    0.012666731659857348,
    -0.0007182119788317892,
    -0.0038809122526038786,
    0.0001084456223089688,
    0.0008523547108047095,
    -2.8078582128442894e-05,
    -0.00010943147929529757,
    3.113556407621969e-06,
    6.230006701220761e-06,
};

DTYPE SYM16_I_H[32] = {
    6.230006701220761e-06,
    3.113556407621969e-06,
    -0.00010943147929529757,
    -2.8078582128442894e-05,
    0.0008523547108047095,
    0.0001084456223089688,
    -0.0038809122526038786,
    -0.0007182119788317892,
    0.012666731659857348,
    0.0031265171722710075,
    -0.031051202843553064,
    -0.004869274404904607,
    0.032333091610663785,
    0.06698304907021778,
    -0.034574228416972504,
    -0.39712293362064416,
    0.7565249878756971,
    -0.47534280601152273,
    -0.054040601387606135,
    0.15959219218520598,
    0.03072113906330156,
    -0.07803785290341991,
    -0.003510275068374009,
    0.024952758046290123,
    0.001359844742484172,
    -0.0069377611308027096,
    -0.00022211647621176323,
    0.0013387206066921965,
    3.656592483348223e-05,
    -0.00016545679579108483,
    -5.396483179315242e-06,
    1.0797982104319795e-05,
};

DTYPE SYM17_L[34] = {
    4.297343327345983e-06,
    2.7801266938414138e-06,
    -6.293702597554192e-05,
    -1.3506383399901165e-05,
    0.0004759963802638669,
    -0.000138642302680455,
    -0.0027416759756816018,
    0.0008567700701915741,
    0.010482366933031529,
    -0.004819212803176148,
    -0.03329138349235933,
    0.01790395221434112,
    0.10475461484223211,
    0.0172711782105185,
    -0.11856693261143636,
    0.1423983504146782,
    0.6507166292045456,
    0.681488995344925,
    0.18053958458111286,
    -0.15507600534974825,
    -0.08607087472073338,
    0.016158808725919346,
    -0.007261634750928767,
    -0.01803889724191924,
    0.009952982523509598,
    0.012396988366648726,
    -0.001905407689852666,
    -0.003932325279797902,
    5.8400428694052584e-05,
    0.0007198270642148971,
    2.520793314082878e-05,
    -7.607124405605129e-05,
    -2.4527163425833e-06,
    3.7912531943321266e-06,
};

DTYPE SYM17_I_L[34] = {
    3.7912531943321266e-06,
    -2.4527163425833e-06,
    -7.607124405605129e-05,
    2.520793314082878e-05,
    0.0007198270642148971,
    5.8400428694052584e-05,
    -0.003932325279797902,
    -0.001905407689852666,
    0.012396988366648726,
    0.009952982523509598,
    -0.01803889724191924,
    -0.007261634750928767,
    0.016158808725919346,
    -0.08607087472073338,
    -0.15507600534974825,
    0.18053958458111286,
    0.681488995344925,
    0.6507166292045456,
    0.1423983504146782,
    -0.11856693261143636,
    0.0172711782105185,
    0.10475461484223211,
    0.01790395221434112,
    -0.03329138349235933,
    -0.004819212803176148,
    0.010482366933031529,
    0.0008567700701915741,
    -0.0027416759756816018,
    -0.000138642302680455,
    0.0004759963802638669,
    -1.3506383399901165e-05,
    -6.293702597554192e-05,
    2.7801266938414138e-06,
    4.297343327345983e-06,
};

DTYPE SYM17_H[34] = {
    -3.7912531943321266e-06,
    -2.4527163425833e-06,
    7.607124405605129e-05,
    2.520793314082878e-05,
    -0.0007198270642148971,
    5.8400428694052584e-05,
    0.003932325279797902,
    -0.001905407689852666,
    -0.012396988366648726,
    0.009952982523509598,
    0.01803889724191924,
    -0.007261634750928767,
    -0.016158808725919346,
    -0.08607087472073338,
    0.15507600534974825,
    0.18053958458111286,
    -0.681488995344925,
    0.6507166292045456,
    -0.1423983504146782,
    -0.11856693261143636,
    -0.0172711782105185,
    0.10475461484223211,
    -0.01790395221434112,
    -0.03329138349235933,
    0.004819212803176148,
    0.010482366933031529,
    -0.0008567700701915741,
    -0.0027416759756816018,
    0.000138642302680455,
    0.0004759963802638669,
    1.3506383399901165e-05,
    -6.293702597554192e-05,
    -2.7801266938414138e-06,
    4.297343327345983e-06,
};

DTYPE SYM17_I_H[34] = {
    4.297343327345983e-06,
    -2.7801266938414138e-06,
    -6.293702597554192e-05,
    1.3506383399901165e-05,
    0.0004759963802638669,
    0.000138642302680455,
    -0.0027416759756816018,
    -0.0008567700701915741,
    0.010482366933031529,
    0.004819212803176148,
    -0.03329138349235933,
    -0.01790395221434112,
    0.10475461484223211,
    -0.0172711782105185,
    -0.11856693261143636,
    -0.1423983504146782,
    0.6507166292045456,
    -0.681488995344925,
    0.18053958458111286,
    0.15507600534974825,
    -0.08607087472073338,
    -0.016158808725919346,
    -0.007261634750928767,
    0.01803889724191924,
    0.009952982523509598,
    -0.012396988366648726,
    -0.001905407689852666,
    0.003932325279797902,
    5.8400428694052584e-05,
    -0.0007198270642148971,
    2.520793314082878e-05,
    7.607124405605129e-05,
    -2.4527163425833e-06,
    -3.7912531943321266e-06,
};

DTYPE SYM18_L[36] = {
    2.6126125564836423e-06,
    1.354915761832114e-06,
    -4.5246757874949856e-05,
    -1.4020992577726755e-05,
    0.00039616840638254753,
    7.021273459036268e-05,
    -0.002313871814506099,
    -0.00041152110923597756,
    0.009502164390962365,
    0.001642986397278216,
    -0.030325091089369604,
    -0.005077085160757053,
    0.08421992997038655,
    0.03399566710394736,
    -0.15993814866932407,
    -0.052029158983952786,
    0.47396905989393956,
    0.7536291401017928,
    0.40148386057061813,
    -0.032480573290138676,
    -0.07379920729060717,
    0.028529597039037808,
    0.006277944554311694,
    -0.03171268473181454,
    -0.0032607442000749834,
    0.015012356344250213,
    0.001087784789595693,
    -0.005239789683026608,
    -0.00018877623940755607,
    0.0014280863270832796,
    4.741614518373667e-05,
    -0.0002658301102424104,
    -9.858816030140058e-06,
    2.955743762093081e-05,
    7.847298055831765e-07,
    -1.5131530692371587e-06,
};

DTYPE SYM18_I_L[36] = {
    -1.5131530692371587e-06,
    7.847298055831765e-07,
    2.955743762093081e-05,
    -9.858816030140058e-06,
    -0.0002658301102424104,
    4.741614518373667e-05,
    0.0014280863270832796,
    -0.00018877623940755607,
    -0.005239789683026608,
    0.001087784789595693,
    0.015012356344250213,
    -0.0032607442000749834,
    -0.03171268473181454,
    0.006277944554311694,
    0.028529597039037808,
    -0.07379920729060717,
    -0.032480573290138676,
    0.40148386057061813,
    0.7536291401017928,
    0.47396905989393956,
    -0.052029158983952786,
    -0.15993814866932407,
    0.03399566710394736,
    0.08421992997038655,
    -0.005077085160757053,
    -0.030325091089369604,
    0.001642986397278216,
    0.009502164390962365,
    -0.00041152110923597756,
    -0.002313871814506099,
    7.021273459036268e-05,
    0.00039616840638254753,
    -1.4020992577726755e-05,
    -4.5246757874949856e-05,
    1.354915761832114e-06,
    2.6126125564836423e-06,
};

DTYPE SYM18_H[36] = {
    1.5131530692371587e-06,
    7.847298055831765e-07,
    -2.955743762093081e-05,
    -9.858816030140058e-06,
    0.0002658301102424104,
    4.741614518373667e-05,
    -0.0014280863270832796,
    -0.00018877623940755607,
    0.005239789683026608,
    0.001087784789595693,
    -0.015012356344250213,
    -0.0032607442000749834,
    0.03171268473181454,
    0.006277944554311694,
    -0.028529597039037808,
    -0.07379920729060717,
    0.032480573290138676,
    0.40148386057061813,
    -0.7536291401017928,
    0.47396905989393956,
    0.052029158983952786,
    -0.15993814866932407,
    -0.03399566710394736,
    0.08421992997038655,
    0.005077085160757053,
    -0.030325091089369604,
    -0.001642986397278216,
    0.009502164390962365,
    0.00041152110923597756,
    -0.002313871814506099,
    -7.021273459036268e-05,
    0.00039616840638254753,
    1.4020992577726755e-05,
    -4.5246757874949856e-05,
    -1.354915761832114e-06,
    2.6126125564836423e-06,
};

DTYPE SYM18_I_H[36] = {
    2.6126125564836423e-06,
    -1.354915761832114e-06,
    -4.5246757874949856e-05,
    1.4020992577726755e-05,
    0.00039616840638254753,
    -7.021273459036268e-05,
    -0.002313871814506099,
    0.00041152110923597756,
    0.009502164390962365,
    -0.001642986397278216,
    -0.030325091089369604,
    0.005077085160757053,
    0.08421992997038655,
    -0.03399566710394736,
    -0.15993814866932407,
    0.052029158983952786,
    0.47396905989393956,
    -0.7536291401017928,
    0.40148386057061813,
    0.032480573290138676,
    -0.07379920729060717,
    -0.028529597039037808,
    0.006277944554311694,
    0.03171268473181454,
    -0.0032607442000749834,
    -0.015012356344250213,
    0.001087784789595693,
    0.005239789683026608,
    -0.00018877623940755607,
    -0.0014280863270832796,
    4.741614518373667e-05,
    0.0002658301102424104,
    -9.858816030140058e-06,
    -2.955743762093081e-05,
    7.847298055831765e-07,
    1.5131530692371587e-06,
};

DTYPE SYM19_L[38] = {
    5.487732768215838e-07,
    -6.463651303345963e-07,
    -1.1880518269823984e-05,
    8.873312173729286e-06,
    0.0001155392333357879,
    -4.612039600210587e-05,
    -0.000635764515004334,
    0.00015915804768084938,
    0.0021214250281823303,
    -0.0011607032572062486,
    -0.005122205002583014,
    0.007968438320613306,
    0.01579743929567463,
    -0.02265199337824595,
    -0.046635983534938946,
    0.0070155738571741596,
    0.008954591173043624,
    -0.06752505804029409,
    0.10902582508127781,
    0.578144945338605,
    0.7195555257163943,
    0.2582661692372836,
    -0.17659686625203097,
    -0.11624173010739675,
    0.09363084341589714,
    0.08407267627924504,
    -0.016908234861345205,
    -0.02770989693131125,
    0.004319351874894969,
    0.008262236955528255,
    -0.0006179223277983108,
    -0.0017049602611649971,
    0.00012930767650701415,
    0.0002762187768573407,
    -1.6821387029373716e-05,
    -2.8151138661550245e-05,
    2.0623170632395688e-06,
    1.7509367995348687e-06,
};

DTYPE SYM19_I_L[38] = {
    1.7509367995348687e-06,
    2.0623170632395688e-06,
    -2.8151138661550245e-05,
    -1.6821387029373716e-05,
    0.0002762187768573407,
    0.00012930767650701415,
    -0.0017049602611649971,
    -0.0006179223277983108,
    0.008262236955528255,
    0.004319351874894969,
    -0.02770989693131125,
    -0.016908234861345205,
    0.08407267627924504,
    0.09363084341589714,
    -0.11624173010739675,
    -0.17659686625203097,
    0.2582661692372836,
    0.7195555257163943,
    0.578144945338605,
    0.10902582508127781,
    -0.06752505804029409,
    0.008954591173043624,
    0.0070155738571741596,
    -0.046635983534938946,
    -0.02265199337824595,
    0.01579743929567463,
    0.007968438320613306,
    -0.005122205002583014,
    -0.0011607032572062486,
    0.0021214250281823303,
    0.00015915804768084938,
    -0.000635764515004334,
    -4.612039600210587e-05,
    0.0001155392333357879,
    8.873312173729286e-06,
    -1.1880518269823984e-05,
    -6.463651303345963e-07,
    5.487732768215838e-07,
};

DTYPE SYM19_H[38] = {
    -1.7509367995348687e-06,
    2.0623170632395688e-06,
    2.8151138661550245e-05,
    -1.6821387029373716e-05,
    -0.0002762187768573407,
    0.00012930767650701415,
    0.0017049602611649971,
    -0.0006179223277983108,
    -0.008262236955528255,
    0.004319351874894969,
    0.02770989693131125,
    -0.016908234861345205,
    -0.08407267627924504,
    0.09363084341589714,
    0.11624173010739675,
    -0.17659686625203097,
    -0.2582661692372836,
    0.7195555257163943,
    -0.578144945338605,
    0.10902582508127781,
    0.06752505804029409,
    0.008954591173043624,
    -0.0070155738571741596,
    -0.046635983534938946,
    0.02265199337824595,
    0.01579743929567463,
    -0.007968438320613306,
    -0.005122205002583014,
    0.0011607032572062486,
    0.0021214250281823303,
    -0.00015915804768084938,
    -0.000635764515004334,
    4.612039600210587e-05,
    0.0001155392333357879,
    -8.873312173729286e-06,
    -1.1880518269823984e-05,
    6.463651303345963e-07,
    5.487732768215838e-07,
};

DTYPE SYM19_I_H[38] = {
    5.487732768215838e-07,
    6.463651303345963e-07,
    -1.1880518269823984e-05,
    -8.873312173729286e-06,
    0.0001155392333357879,
    4.612039600210587e-05,
    -0.000635764515004334,
    -0.00015915804768084938,
    0.0021214250281823303,
    0.0011607032572062486,
    -0.005122205002583014,
    -0.007968438320613306,
    0.01579743929567463,
    0.02265199337824595,
    -0.046635983534938946,
    -0.0070155738571741596,
    0.008954591173043624,
    0.06752505804029409,
    0.10902582508127781,
    -0.578144945338605,
    0.7195555257163943,
    -0.2582661692372836,
    -0.17659686625203097,
    0.11624173010739675,
    0.09363084341589714,
    -0.08407267627924504,
    -0.016908234861345205,
    0.02770989693131125,
    0.004319351874894969,
    -0.008262236955528255,
    -0.0006179223277983108,
    0.0017049602611649971,
    0.00012930767650701415,
    -0.0002762187768573407,
    -1.6821387029373716e-05,
    2.8151138661550245e-05,
    2.0623170632395688e-06,
    -1.7509367995348687e-06,
};

DTYPE SYM20_L[40] = {
    3.695537474835221e-07,
    -1.9015675890554106e-07,
    -7.919361411976999e-06,
    3.025666062736966e-06,
    7.992967835772481e-05,
    -1.928412300645204e-05,
    -0.0004947310915672655,
    7.215991188074035e-05,
    0.002088994708190198,
    -0.0003052628317957281,
    -0.006606585799088861,
    0.0014230873594621453,
    0.01700404902339034,
    -0.003313857383623359,
    -0.031629437144957966,
    0.008123228356009682,
    0.025579349509413946,
    -0.07899434492839816,
    -0.02981936888033373,
    0.4058314443484506,
    0.75116272842273,
    0.47199147510148703,
    -0.0510883429210674,
    -0.16057829841525254,
    0.03625095165393308,
    0.08891966802819956,
    -0.0068437019650692274,
    -0.035373336756604236,
    0.0019385970672402002,
    0.012157040948785737,
    -0.0006111263857992088,
    -0.0034716478028440734,
    0.0001254409172306726,
    0.0007476108597820572,
    -2.6615550335516086e-05,
    -0.00011739133516291466,
    4.525422209151636e-06,
    1.22872527779612e-05,
    -3.2567026420174407e-07,
    -6.329129044776395e-07,
};

DTYPE SYM20_I_L[40] = {
    -6.329129044776395e-07,
    -3.2567026420174407e-07,
    1.22872527779612e-05,
    4.525422209151636e-06,
    -0.00011739133516291466,
    -2.6615550335516086e-05,
    0.0007476108597820572,
    0.0001254409172306726,
    -0.0034716478028440734,
    -0.0006111263857992088,
    0.012157040948785737,
    0.0019385970672402002,
    -0.035373336756604236,
    -0.0068437019650692274,
    0.08891966802819956,
    0.03625095165393308,
    -0.16057829841525254,
    -0.0510883429210674,
    0.47199147510148703,
    0.75116272842273,
    0.4058314443484506,
    -0.02981936888033373,
    -0.07899434492839816,
    0.025579349509413946,
    0.008123228356009682,
    -0.031629437144957966,
    -0.003313857383623359,
    0.01700404902339034,
    0.0014230873594621453,
    -0.006606585799088861,
    -0.0003052628317957281,
    0.002088994708190198,
    7.215991188074035e-05,
    -0.0004947310915672655,
    -1.928412300645204e-05,
    7.992967835772481e-05,
    3.025666062736966e-06,
    -7.919361411976999e-06,
    -1.9015675890554106e-07,
    3.695537474835221e-07,
};

DTYPE SYM20_H[40] = {
    6.329129044776395e-07,
    -3.2567026420174407e-07,
    -1.22872527779612e-05,
    4.525422209151636e-06,
    0.00011739133516291466,
    -2.6615550335516086e-05,
    -0.0007476108597820572,
    0.0001254409172306726,
    0.0034716478028440734,
    -0.0006111263857992088,
    -0.012157040948785737,
    0.0019385970672402002,
    0.035373336756604236,
    -0.0068437019650692274,
    -0.08891966802819956,
    0.03625095165393308,
    0.16057829841525254,
    -0.0510883429210674,
    -0.47199147510148703,
    0.75116272842273,
    -0.4058314443484506,
    -0.02981936888033373,
    0.07899434492839816,
    0.025579349509413946,
    -0.008123228356009682,
    -0.031629437144957966,
    0.003313857383623359,
    0.01700404902339034,
    -0.0014230873594621453,
    -0.006606585799088861,
    0.0003052628317957281,
    0.002088994708190198,
    -7.215991188074035e-05,
    -0.0004947310915672655,
    1.928412300645204e-05,
    7.992967835772481e-05,
    -3.025666062736966e-06,
    -7.919361411976999e-06,
    1.9015675890554106e-07,
    3.695537474835221e-07,
};

DTYPE SYM20_I_H[40] = {
    3.695537474835221e-07,
    1.9015675890554106e-07,
    -7.919361411976999e-06,
    -3.025666062736966e-06,
    7.992967835772481e-05,
    1.928412300645204e-05,
    -0.0004947310915672655,
    -7.215991188074035e-05,
    0.002088994708190198,
    0.0003052628317957281,
    -0.006606585799088861,
    -0.0014230873594621453,
    0.01700404902339034,
    0.003313857383623359,
    -0.031629437144957966,
    -0.008123228356009682,
    0.025579349509413946,
    0.07899434492839816,
    -0.02981936888033373,
    -0.4058314443484506,
    0.75116272842273,
    -0.47199147510148703,
    -0.0510883429210674,
    0.16057829841525254,
    0.03625095165393308,
    -0.08891966802819956,
    -0.0068437019650692274,
    0.035373336756604236,
    0.0019385970672402002,
    -0.012157040948785737,
    -0.0006111263857992088,
    0.0034716478028440734,
    0.0001254409172306726,
    -0.0007476108597820572,
    -2.6615550335516086e-05,
    0.00011739133516291466,
    4.525422209151636e-06,
    -1.22872527779612e-05,
    -3.2567026420174407e-07,
    6.329129044776395e-07,
};

DTYPE COIF1_L[6] = {
    -0.01565572813546454,
    -0.0727326195128539,
    0.38486484686420286,
    0.8525720202122554,
    0.3378976624578092,
    -0.0727326195128539,
};

DTYPE COIF1_I_L[6] = {
    -0.0727326195128539,
    0.3378976624578092,
    0.8525720202122554,
    0.38486484686420286,
    -0.0727326195128539,
    -0.01565572813546454,
};

DTYPE COIF1_H[6] = {
    0.0727326195128539,
    0.3378976624578092,
    -0.8525720202122554,
    0.38486484686420286,
    0.0727326195128539,
    -0.01565572813546454,
};

DTYPE COIF1_I_H[6] = {
    -0.01565572813546454,
    0.0727326195128539,
    0.38486484686420286,
    -0.8525720202122554,
    0.3378976624578092,
    0.0727326195128539,
};

DTYPE COIF2_L[12] = {
    -0.0007205494453645122,
    -0.0018232088707029932,
    0.0056114348193944995,
    0.023680171946334084,
    -0.0594344186464569,
    -0.0764885990783064,
    0.41700518442169254,
    0.8127236354455423,
    0.3861100668211622,
    -0.06737255472196302,
    -0.04146493678175915,
    0.016387336463522112,
};

DTYPE COIF2_I_L[12] = {
    0.016387336463522112,
    -0.04146493678175915,
    -0.06737255472196302,
    0.3861100668211622,
    0.8127236354455423,
    0.41700518442169254,
    -0.0764885990783064,
    -0.0594344186464569,
    0.023680171946334084,
    0.0056114348193944995,
    -0.0018232088707029932,
    -0.0007205494453645122,
};

DTYPE COIF2_H[12] = {
    -0.016387336463522112,
    -0.04146493678175915,
    0.06737255472196302,
    0.3861100668211622,
    -0.8127236354455423,
    0.41700518442169254,
    0.0764885990783064,
    -0.0594344186464569,
    -0.023680171946334084,
    0.0056114348193944995,
    0.0018232088707029932,
    -0.0007205494453645122,
};

DTYPE COIF2_I_H[12] = {
    -0.0007205494453645122,
    0.0018232088707029932,
    0.0056114348193944995,
    -0.023680171946334084,
    -0.0594344186464569,
    0.0764885990783064,
    0.41700518442169254,
    -0.8127236354455423,
    0.3861100668211622,
    0.06737255472196302,
    -0.04146493678175915,
    -0.016387336463522112,
};

DTYPE COIF3_L[18] = {
    -3.459977283621256e-05,
    -7.098330313814125e-05,
    0.0004662169601128863,
    0.0011175187708906016,
    -0.0025745176887502236,
    -0.00900797613666158,
    0.015880544863615904,
    0.03455502757306163,
    -0.08230192710688598,
    -0.07179982161931202,
    0.42848347637761874,
    0.7937772226256206,
    0.4051769024096169,
    -0.06112339000267287,
    -0.0657719112818555,
    0.023452696141836267,
    0.007782596427325418,
    -0.003793512864491014,
};

DTYPE COIF3_I_L[18] = {
    -0.003793512864491014,
    0.007782596427325418,
    0.023452696141836267,
    -0.0657719112818555,
    -0.06112339000267287,
    0.4051769024096169,
    0.7937772226256206,
    0.42848347637761874,
    -0.07179982161931202,
    -0.08230192710688598,
    0.03455502757306163,
    0.015880544863615904,
    -0.00900797613666158,
    -0.0025745176887502236,
    0.0011175187708906016,
    0.0004662169601128863,
    -7.098330313814125e-05,
    -3.459977283621256e-05,
};

DTYPE COIF3_H[18] = {
    0.003793512864491014,
    0.007782596427325418,
    -0.023452696141836267,
    -0.0657719112818555,
    0.06112339000267287,
    0.4051769024096169,
    -0.7937772226256206,
    0.42848347637761874,
    0.07179982161931202,
    -0.08230192710688598,
    -0.03455502757306163,
    0.015880544863615904,
    0.00900797613666158,
    -0.0025745176887502236,
    -0.0011175187708906016,
    0.0004662169601128863,
    7.098330313814125e-05,
    -3.459977283621256e-05,
};

DTYPE COIF3_I_H[18] = {
    -3.459977283621256e-05,
    7.098330313814125e-05,
    0.0004662169601128863,
    -0.0011175187708906016,
    -0.0025745176887502236,
    0.00900797613666158,
    0.015880544863615904,
    -0.03455502757306163,
    -0.08230192710688598,
    0.07179982161931202,
    0.42848347637761874,
    -0.7937772226256206,
    0.4051769024096169,
    0.06112339000267287,
    -0.0657719112818555,
    -0.023452696141836267,
    0.007782596427325418,
    0.003793512864491014,
};

DTYPE COIF4_L[24] = {
    -1.7849850030882614e-06,
    -3.2596802368833675e-06,
    3.1229875865345646e-05,
    6.233903446100713e-05,
    -0.00025997455248771324,
    -0.0005890207562443383,
    0.0012665619292989445,
    0.003751436157278457,
    -0.00565828668661072,
    -0.015211731527946259,
    0.025082261844864097,
    0.03933442712333749,
    -0.09622044203398798,
    -0.06662747426342504,
    0.4343860564914685,
    0.782238930920499,
    0.41530840703043026,
    -0.05607731331675481,
    -0.08126669968087875,
    0.026682300156053072,
    0.016068943964776348,
    -0.0073461663276420935,
    -0.0016294920126017326,
    0.0008923136685823146,
};

DTYPE COIF4_I_L[24] = {
    0.0008923136685823146,
    -0.0016294920126017326,
    -0.0073461663276420935,
    0.016068943964776348,
    0.026682300156053072,
    -0.08126669968087875,
    -0.05607731331675481,
    0.41530840703043026,
    0.782238930920499,
    0.4343860564914685,
    -0.06662747426342504,
    -0.09622044203398798,
    0.03933442712333749,
    0.025082261844864097,
    -0.015211731527946259,
    -0.00565828668661072,
    0.003751436157278457,
    0.0012665619292989445,
    -0.0005890207562443383,
    -0.00025997455248771324,
    6.233903446100713e-05,
    3.1229875865345646e-05,
    -3.2596802368833675e-06,
    -1.7849850030882614e-06,
};

DTYPE COIF4_H[24] = {
    -0.0008923136685823146,
    -0.0016294920126017326,
    0.0073461663276420935,
    0.016068943964776348,
    -0.026682300156053072,
    -0.08126669968087875,
    0.05607731331675481,
    0.41530840703043026,
    -0.782238930920499,
    0.4343860564914685,
    0.06662747426342504,
    -0.09622044203398798,
    -0.03933442712333749,
    0.025082261844864097,
    0.015211731527946259,
    -0.00565828668661072,
    -0.003751436157278457,
    0.0012665619292989445,
    0.0005890207562443383,
    -0.00025997455248771324,
    -6.233903446100713e-05,
    3.1229875865345646e-05,
    3.2596802368833675e-06,
    -1.7849850030882614e-06,
};

DTYPE COIF4_I_H[24] = {
    -1.7849850030882614e-06,
    3.2596802368833675e-06,
    3.1229875865345646e-05,
    -6.233903446100713e-05,
    -0.00025997455248771324,
    0.0005890207562443383,
    0.0012665619292989445,
    -0.003751436157278457,
    -0.00565828668661072,
    0.015211731527946259,
    0.025082261844864097,
    -0.03933442712333749,
    -0.09622044203398798,
    0.06662747426342504,
    0.4343860564914685,
    -0.782238930920499,
    0.41530840703043026,
    0.05607731331675481,
    -0.08126669968087875,
    -0.026682300156053072,
    0.016068943964776348,
    0.0073461663276420935,
    -0.0016294920126017326,
    -0.0008923136685823146,
};

DTYPE COIF5_L[30] = {
    -9.517657273819165e-08,
    -1.6744288576823017e-07,
    2.0637618513646814e-06,
    3.7346551751414047e-06,
    -2.1315026809955787e-05,
    -4.134043227251251e-05,
    0.00014054114970203437,
    0.00030225958181306315,
    -0.0006381313430451114,
    -0.0016628637020130838,
    0.0024333732126576722,
    0.006764185448053083,
    -0.009164231162481846,
    -0.01976177894257264,
    0.03268357426711183,
    0.0412892087501817,
    -0.10557420870333893,
    -0.06203596396290357,
    0.4379916261718371,
    0.7742896036529562,
    0.4215662066908515,
    -0.05204316317624377,
    -0.09192001055969624,
    0.02816802897093635,
    0.023408156785839195,
    -0.010131117519849788,
    -0.004159358781386048,
    0.0021782363581090178,
    0.00035858968789573785,
    -0.00021208083980379827,
};

DTYPE COIF5_I_L[30] = {
    -0.00021208083980379827,
    0.00035858968789573785,
    0.0021782363581090178,
    -0.004159358781386048,
    -0.010131117519849788,
    0.023408156785839195,
    0.02816802897093635,
    -0.09192001055969624,
    -0.05204316317624377,
    0.4215662066908515,
    0.7742896036529562,
    0.4379916261718371,
    -0.06203596396290357,
    -0.10557420870333893,
    0.0412892087501817,
    0.03268357426711183,
    -0.01976177894257264,
    -0.009164231162481846,
    0.006764185448053083,
    0.0024333732126576722,
    -0.0016628637020130838,
    -0.0006381313430451114,
    0.00030225958181306315,
    0.00014054114970203437,
    -4.134043227251251e-05,
    -2.1315026809955787e-05,
    3.7346551751414047e-06,
    2.0637618513646814e-06,
    -1.6744288576823017e-07,
    -9.517657273819165e-08,
};

DTYPE COIF5_H[30] = {
    0.00021208083980379827,
    0.00035858968789573785,
    -0.0021782363581090178,
    -0.004159358781386048,
    0.010131117519849788,
    0.023408156785839195,
    -0.02816802897093635,
    -0.09192001055969624,
    0.05204316317624377,
    0.4215662066908515,
    -0.7742896036529562,
    0.4379916261718371,
    0.06203596396290357,
    -0.10557420870333893,
    -0.0412892087501817,
    0.03268357426711183,
    0.01976177894257264,
    -0.009164231162481846,
    -0.006764185448053083,
    0.0024333732126576722,
    0.0016628637020130838,
    -0.0006381313430451114,
    -0.00030225958181306315,
    0.00014054114970203437,
    4.134043227251251e-05,
    -2.1315026809955787e-05,
    -3.7346551751414047e-06,
    2.0637618513646814e-06,
    1.6744288576823017e-07,
    -9.517657273819165e-08,
};

DTYPE COIF5_I_H[30] = {
    -9.517657273819165e-08,
    1.6744288576823017e-07,
    2.0637618513646814e-06,
    -3.7346551751414047e-06,
    -2.1315026809955787e-05,
    4.134043227251251e-05,
    0.00014054114970203437,
    -0.00030225958181306315,
    -0.0006381313430451114,
    0.0016628637020130838,
    0.0024333732126576722,
    -0.006764185448053083,
    -0.009164231162481846,
    0.01976177894257264,
    0.03268357426711183,
    -0.0412892087501817,
    -0.10557420870333893,
    0.06203596396290357,
    0.4379916261718371,
    -0.7742896036529562,
    0.4215662066908515,
    0.05204316317624377,
    -0.09192001055969624,
    -0.02816802897093635,
    0.023408156785839195,
    0.010131117519849788,
    -0.004159358781386048,
    -0.0021782363581090178,
    0.00035858968789573785,
    0.00021208083980379827,
};


///
/// -----
///

DTYPE BIOR1_3_L[6] = {
    -0.08838834764831845,
    0.08838834764831845,
    0.7071067811865476,
    0.7071067811865476,
    0.08838834764831845,
    -0.08838834764831845,
};

DTYPE BIOR1_3_I_L[6] = {
    0.0,
    0.0,
    0.7071067811865476,
    0.7071067811865476,
    0.0,
    0.0,
};

DTYPE BIOR1_3_H[6] = {
    0.0,
    0.0,
    -0.7071067811865476,
    0.7071067811865476,
    0.0,
    0.0,
};

DTYPE BIOR1_3_I_H[6] = {
    -0.08838834764831845,
    -0.08838834764831845,
    0.7071067811865476,
    -0.7071067811865476,
    0.08838834764831845,
    0.08838834764831845,
};

DTYPE BIOR1_5_L[10] = {
    0.01657281518405971,
    -0.01657281518405971,
    -0.12153397801643787,
    0.12153397801643787,
    0.7071067811865476,
    0.7071067811865476,
    0.12153397801643787,
    -0.12153397801643787,
    -0.01657281518405971,
    0.01657281518405971,
};

DTYPE BIOR1_5_I_L[10] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.7071067811865476,
    0.7071067811865476,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR1_5_H[10] = {
    0.0,
    0.0,
    0.0,
    0.0,
    -0.7071067811865476,
    0.7071067811865476,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR1_5_I_H[10] = {
    0.01657281518405971,
    0.01657281518405971,
    -0.12153397801643787,
    -0.12153397801643787,
    0.7071067811865476,
    -0.7071067811865476,
    0.12153397801643787,
    0.12153397801643787,
    -0.01657281518405971,
    -0.01657281518405971,
};

DTYPE BIOR2_2_L[6] = {
    0.0,
    -0.1767766952966369,
    0.3535533905932738,
    1.0606601717798214,
    0.3535533905932738,
    -0.1767766952966369,
};

DTYPE BIOR2_2_I_L[6] = {
    0.0,
    0.3535533905932738,
    0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
};

DTYPE BIOR2_2_H[6] = {
    0.0,
    0.3535533905932738,
    -0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
};

DTYPE BIOR2_2_I_H[6] = {
    0.0,
    0.1767766952966369,
    0.3535533905932738,
    -1.0606601717798214,
    0.3535533905932738,
    0.1767766952966369,
};

DTYPE BIOR2_4_L[10] = {
    0.0,
    0.03314563036811942,
    -0.06629126073623884,
    -0.1767766952966369,
    0.4198446513295126,
    0.9943689110435825,
    0.4198446513295126,
    -0.1767766952966369,
    -0.06629126073623884,
    0.03314563036811942,
};

DTYPE BIOR2_4_I_L[10] = {
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR2_4_H[10] = {
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    -0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR2_4_I_H[10] = {
    0.0,
    -0.03314563036811942,
    -0.06629126073623884,
    0.1767766952966369,
    0.4198446513295126,
    -0.9943689110435825,
    0.4198446513295126,
    0.1767766952966369,
    -0.06629126073623884,
    -0.03314563036811942,
};

DTYPE BIOR2_6_L[14] = {
    0.0,
    -0.006905339660024878,
    0.013810679320049757,
    0.046956309688169176,
    -0.10772329869638811,
    -0.16987135563661201,
    0.4474660099696121,
    0.966747552403483,
    0.4474660099696121,
    -0.16987135563661201,
    -0.10772329869638811,
    0.046956309688169176,
    0.013810679320049757,
    -0.006905339660024878,
};

DTYPE BIOR2_6_I_L[14] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR2_6_H[14] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    -0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR2_6_I_H[14] = {
    0.0,
    0.006905339660024878,
    0.013810679320049757,
    -0.046956309688169176,
    -0.10772329869638811,
    0.16987135563661201,
    0.4474660099696121,
    -0.966747552403483,
    0.4474660099696121,
    0.16987135563661201,
    -0.10772329869638811,
    -0.046956309688169176,
    0.013810679320049757,
    0.006905339660024878,
};

DTYPE BIOR2_8_L[18] = {
    0.0,
    0.0015105430506304422,
    -0.0030210861012608843,
    -0.012947511862546647,
    0.02891610982635418,
    0.052998481890690945,
    -0.13491307360773608,
    -0.16382918343409025,
    0.4625714404759166,
    0.9516421218971786,
    0.4625714404759166,
    -0.16382918343409025,
    -0.13491307360773608,
    0.052998481890690945,
    0.02891610982635418,
    -0.012947511862546647,
    -0.0030210861012608843,
    0.0015105430506304422,
};

DTYPE BIOR2_8_I_L[18] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR2_8_H[18] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    -0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR2_8_I_H[18] = {
    0.0,
    -0.0015105430506304422,
    -0.0030210861012608843,
    0.012947511862546647,
    0.02891610982635418,
    -0.052998481890690945,
    -0.13491307360773608,
    0.16382918343409025,
    0.4625714404759166,
    -0.9516421218971786,
    0.4625714404759166,
    0.16382918343409025,
    -0.13491307360773608,
    -0.052998481890690945,
    0.02891610982635418,
    0.012947511862546647,
    -0.0030210861012608843,
    -0.0015105430506304422,
};

DTYPE BIOR3_1_L[4] = {
    -0.3535533905932738,
    1.0606601717798214,
    1.0606601717798214,
    -0.3535533905932738,
};

DTYPE BIOR3_1_I_L[4] = {
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
};

DTYPE BIOR3_1_H[4] = {
    -0.1767766952966369,
    0.5303300858899107,
    -0.5303300858899107,
    0.1767766952966369,
};

DTYPE BIOR3_1_I_H[4] = {
    -0.3535533905932738,
    -1.0606601717798214,
    1.0606601717798214,
    0.3535533905932738,
};

DTYPE BIOR3_3_L[8] = {
    0.06629126073623884,
    -0.19887378220871652,
    -0.15467960838455727,
    0.9943689110435825,
    0.9943689110435825,
    -0.15467960838455727,
    -0.19887378220871652,
    0.06629126073623884,
};

DTYPE BIOR3_3_I_L[8] = {
    0.0,
    0.0,
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
};

DTYPE BIOR3_3_H[8] = {
    0.0,
    0.0,
    -0.1767766952966369,
    0.5303300858899107,
    -0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
};

DTYPE BIOR3_3_I_H[8] = {
    0.06629126073623884,
    0.19887378220871652,
    -0.15467960838455727,
    -0.9943689110435825,
    0.9943689110435825,
    0.15467960838455727,
    -0.19887378220871652,
    -0.06629126073623884,
};

DTYPE BIOR3_5_L[12] = {
    -0.013810679320049757,
    0.04143203796014927,
    0.052480581416189075,
    -0.26792717880896527,
    -0.07181553246425874,
    0.966747552403483,
    0.966747552403483,
    -0.07181553246425874,
    -0.26792717880896527,
    0.052480581416189075,
    0.04143203796014927,
    -0.013810679320049757,
};

DTYPE BIOR3_5_I_L[12] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR3_5_H[12] = {
    0.0,
    0.0,
    0.0,
    0.0,
    -0.1767766952966369,
    0.5303300858899107,
    -0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR3_5_I_H[12] = {
    -0.013810679320049757,
    -0.04143203796014927,
    0.052480581416189075,
    0.26792717880896527,
    -0.07181553246425874,
    -0.966747552403483,
    0.966747552403483,
    0.07181553246425874,
    -0.26792717880896527,
    -0.052480581416189075,
    0.04143203796014927,
    0.013810679320049757,
};

DTYPE BIOR3_7_L[16] = {
    0.0030210861012608843,
    -0.009063258303782653,
    -0.01683176542131064,
    0.074663985074019,
    0.03133297870736289,
    -0.301159125922835,
    -0.026499240945345472,
    0.9516421218971786,
    0.9516421218971786,
    -0.026499240945345472,
    -0.301159125922835,
    0.03133297870736289,
    0.074663985074019,
    -0.01683176542131064,
    -0.009063258303782653,
    0.0030210861012608843,
};

DTYPE BIOR3_7_I_L[16] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR3_7_H[16] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    -0.1767766952966369,
    0.5303300858899107,
    -0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR3_7_I_H[16] = {
    0.0030210861012608843,
    0.009063258303782653,
    -0.01683176542131064,
    -0.074663985074019,
    0.03133297870736289,
    0.301159125922835,
    -0.026499240945345472,
    -0.9516421218971786,
    0.9516421218971786,
    0.026499240945345472,
    -0.301159125922835,
    -0.03133297870736289,
    0.074663985074019,
    0.01683176542131064,
    -0.009063258303782653,
    -0.0030210861012608843,
};

DTYPE BIOR3_9_L[20] = {
    -0.000679744372783699,
    0.002039233118351097,
    0.005060319219611981,
    -0.020618912641105536,
    -0.014112787930175846,
    0.09913478249423216,
    0.012300136269419315,
    -0.32019196836077857,
    0.0020500227115698858,
    0.9421257006782068,
    0.9421257006782068,
    0.0020500227115698858,
    -0.32019196836077857,
    0.012300136269419315,
    0.09913478249423216,
    -0.014112787930175846,
    -0.020618912641105536,
    0.005060319219611981,
    0.002039233118351097,
    -0.000679744372783699,
};

DTYPE BIOR3_9_I_L[20] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR3_9_H[20] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    -0.1767766952966369,
    0.5303300858899107,
    -0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE BIOR3_9_I_H[20] = {
    -0.000679744372783699,
    -0.002039233118351097,
    0.005060319219611981,
    0.020618912641105536,
    -0.014112787930175846,
    -0.09913478249423216,
    0.012300136269419315,
    0.32019196836077857,
    0.0020500227115698858,
    -0.9421257006782068,
    0.9421257006782068,
    -0.0020500227115698858,
    -0.32019196836077857,
    -0.012300136269419315,
    0.09913478249423216,
    0.014112787930175846,
    -0.020618912641105536,
    -0.005060319219611981,
    0.002039233118351097,
    0.000679744372783699,
};

DTYPE BIOR4_4_L[10] = {
    0.0,
    0.03782845550726404,
    -0.023849465019556843,
    -0.11062440441843718,
    0.37740285561283066,
    0.8526986790088938,
    0.37740285561283066,
    -0.11062440441843718,
    -0.023849465019556843,
    0.03782845550726404,
};

DTYPE BIOR4_4_I_L[10] = {
    0.0,
    -0.06453888262869706,
    -0.04068941760916406,
    0.41809227322161724,
    0.7884856164055829,
    0.41809227322161724,
    -0.04068941760916406,
    -0.06453888262869706,
    0.0,
    0.0,
};

DTYPE BIOR4_4_H[10] = {
    0.0,
    -0.06453888262869706,
    0.04068941760916406,
    0.41809227322161724,
    -0.7884856164055829,
    0.41809227322161724,
    0.04068941760916406,
    -0.06453888262869706,
    0.0,
    0.0,
};

DTYPE BIOR4_4_I_H[10] = {
    0.0,
    -0.03782845550726404,
    -0.023849465019556843,
    0.11062440441843718,
    0.37740285561283066,
    -0.8526986790088938,
    0.37740285561283066,
    0.11062440441843718,
    -0.023849465019556843,
    -0.03782845550726404,
};


DTYPE BIOR5_5_L[12] = {
    0.0,
    0.0,
    0.03968708834740544,
    0.007948108637240322,
    -0.05446378846823691,
    0.34560528195603346,
    0.7366601814282105,
    0.34560528195603346,
    -0.05446378846823691,
    0.007948108637240322,
    0.03968708834740544,
    0.0
};

DTYPE BIOR5_5_H[12] = {
    -0.013456709459118716,
    -0.002694966880111507,
    0.13670658466432914,
    -0.09350469740093886,
    -0.47680326579848425,
    0.8995061097486484,
    -0.47680326579848425,
    -0.09350469740093886,
    0.13670658466432914,
    -0.002694966880111507,
    -0.013456709459118716,
    0.0
};

DTYPE BIOR5_5_I_L[12] = {
    0.013456709459118716,
    -0.002694966880111507,
    -0.13670658466432914,
    -0.09350469740093886,
    0.47680326579848425,
    0.8995061097486484,
    0.47680326579848425,
    -0.09350469740093886,
    -0.13670658466432914,
    -0.002694966880111507,
    0.013456709459118716,
    0.0
};

DTYPE BIOR5_5_I_H[12] = {
    0.0,
    0.0,
    0.03968708834740544,
    -0.007948108637240322,
    -0.05446378846823691,
    -0.34560528195603346,
    0.7366601814282105,
    -0.34560528195603346,
    -0.05446378846823691,
    -0.007948108637240322,
    0.03968708834740544,
    0.0
};



DTYPE BIOR6_8_L[18] = {
    0.0,
    0.0019088317364812906,
    -0.0019142861290887667,
    -0.016990639867602342,
    0.01193456527972926,
    0.04973290349094079,
    -0.07726317316720414,
    -0.09405920349573646,
    0.4207962846098268,
    0.8259229974584023,
    0.4207962846098268,
    -0.09405920349573646,
    -0.07726317316720414,
    0.04973290349094079,
    0.01193456527972926,
    -0.016990639867602342,
    -0.0019142861290887667,
    0.0019088317364812906
};


DTYPE BIOR6_8_H[18] = {
    0.0,
    0.0,
    0.0,
    0.014426282505624435,
    -0.014467504896790148,
    -0.07872200106262882,
    0.04036797903033992,
    0.41784910915027457,
    -0.7589077294536541,
    0.41784910915027457,
    0.04036797903033992,
    -0.07872200106262882,
    -0.014467504896790148,
    0.014426282505624435,
    0.0,
    0.0,
    0.0,
    0.0
};

DTYPE BIOR6_8_I_L[18] = {
    0.0,
    0.0,
    0.0,
    0.014426282505624435,
    0.014467504896790148,
    -0.07872200106262882,
    -0.04036797903033992,
    0.41784910915027457,
    0.7589077294536541,
    0.41784910915027457,
    -0.04036797903033992,
    -0.07872200106262882,
    0.014467504896790148,
    0.014426282505624435,
    0.0,
    0.0,
    0.0,
    0.0
};

DTYPE BIOR6_8_I_H[18] = {
    0.0,
    -0.0019088317364812906,
    -0.0019142861290887667,
    0.016990639867602342,
    0.01193456527972926,
    -0.04973290349094079,
    -0.07726317316720414,
    0.09405920349573646,
    0.4207962846098268,
    -0.8259229974584023,
    0.4207962846098268,
    0.09405920349573646,
    -0.07726317316720414,
    -0.04973290349094079,
    0.01193456527972926,
    0.016990639867602342,
    -0.0019142861290887667,
    -0.0019088317364812906,
};


DTYPE RBIOR1_3_L[6] = {
    0.0,
    0.0,
    0.7071067811865476,
    0.7071067811865476,
    0.0,
    0.0,
};

DTYPE RBIOR1_3_I_L[6] = {
    -0.08838834764831845,
    0.08838834764831845,
    0.7071067811865476,
    0.7071067811865476,
    0.08838834764831845,
    -0.08838834764831845,
};

DTYPE RBIOR1_3_H[6] = {
    0.08838834764831845,
    0.08838834764831845,
    -0.7071067811865476,
    0.7071067811865476,
    -0.08838834764831845,
    -0.08838834764831845,
};

DTYPE RBIOR1_3_I_H[6] = {
    0.0,
    0.0,
    0.7071067811865476,
    -0.7071067811865476,
    0.0,
    0.0,
};

DTYPE RBIOR1_5_L[10] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.7071067811865476,
    0.7071067811865476,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR1_5_I_L[10] = {
    0.01657281518405971,
    -0.01657281518405971,
    -0.12153397801643787,
    0.12153397801643787,
    0.7071067811865476,
    0.7071067811865476,
    0.12153397801643787,
    -0.12153397801643787,
    -0.01657281518405971,
    0.01657281518405971,
};

DTYPE RBIOR1_5_H[10] = {
    -0.01657281518405971,
    -0.01657281518405971,
    0.12153397801643787,
    0.12153397801643787,
    -0.7071067811865476,
    0.7071067811865476,
    -0.12153397801643787,
    -0.12153397801643787,
    0.01657281518405971,
    0.01657281518405971,
};

DTYPE RBIOR1_5_I_H[10] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.7071067811865476,
    -0.7071067811865476,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR2_2_L[6] = {
    0.0,
    0.0,
    0.3535533905932738,
    0.7071067811865476,
    0.3535533905932738,
    0.0,
};

DTYPE RBIOR2_2_I_L[6] = {
    -0.1767766952966369,
    0.3535533905932738,
    1.0606601717798214,
    0.3535533905932738,
    -0.1767766952966369,
    0.0,
};

DTYPE RBIOR2_2_H[6] = {
    0.1767766952966369,
    0.3535533905932738,
    -1.0606601717798214,
    0.3535533905932738,
    0.1767766952966369,
    0.0,
};

DTYPE RBIOR2_2_I_H[6] = {
    0.0,
    0.0,
    0.3535533905932738,
    -0.7071067811865476,
    0.3535533905932738,
    0.0,
};

DTYPE RBIOR2_4_L[10] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR2_4_I_L[10] = {
    0.03314563036811942,
    -0.06629126073623884,
    -0.1767766952966369,
    0.4198446513295126,
    0.9943689110435825,
    0.4198446513295126,
    -0.1767766952966369,
    -0.06629126073623884,
    0.03314563036811942,
    0.0,
};

DTYPE RBIOR2_4_H[10] = {
    -0.03314563036811942,
    -0.06629126073623884,
    0.1767766952966369,
    0.4198446513295126,
    -0.9943689110435825,
    0.4198446513295126,
    0.1767766952966369,
    -0.06629126073623884,
    -0.03314563036811942,
    0.0,
};

DTYPE RBIOR2_4_I_H[10] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    -0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR2_6_L[14] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR2_6_I_L[14] = {
    -0.006905339660024878,
    0.013810679320049757,
    0.046956309688169176,
    -0.10772329869638811,
    -0.16987135563661201,
    0.4474660099696121,
    0.966747552403483,
    0.4474660099696121,
    -0.16987135563661201,
    -0.10772329869638811,
    0.046956309688169176,
    0.013810679320049757,
    -0.006905339660024878,
    0.0,
};

DTYPE RBIOR2_6_H[14] = {
    0.006905339660024878,
    0.013810679320049757,
    -0.046956309688169176,
    -0.10772329869638811,
    0.16987135563661201,
    0.4474660099696121,
    -0.966747552403483,
    0.4474660099696121,
    0.16987135563661201,
    -0.10772329869638811,
    -0.046956309688169176,
    0.013810679320049757,
    0.006905339660024878,
    0.0,
};

DTYPE RBIOR2_6_I_H[14] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    -0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR2_8_L[18] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR2_8_I_L[18] = {
    0.0015105430506304422,
    -0.0030210861012608843,
    -0.012947511862546647,
    0.02891610982635418,
    0.052998481890690945,
    -0.13491307360773608,
    -0.16382918343409025,
    0.4625714404759166,
    0.9516421218971786,
    0.4625714404759166,
    -0.16382918343409025,
    -0.13491307360773608,
    0.052998481890690945,
    0.02891610982635418,
    -0.012947511862546647,
    -0.0030210861012608843,
    0.0015105430506304422,
    0.0,
};

DTYPE RBIOR2_8_H[18] = {
    -0.0015105430506304422,
    -0.0030210861012608843,
    0.012947511862546647,
    0.02891610982635418,
    -0.052998481890690945,
    -0.13491307360773608,
    0.16382918343409025,
    0.4625714404759166,
    -0.9516421218971786,
    0.4625714404759166,
    0.16382918343409025,
    -0.13491307360773608,
    -0.052998481890690945,
    0.02891610982635418,
    0.012947511862546647,
    -0.0030210861012608843,
    -0.0015105430506304422,
    0.0,
};

DTYPE RBIOR2_8_I_H[18] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.3535533905932738,
    -0.7071067811865476,
    0.3535533905932738,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR3_1_L[4] = {
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
};

DTYPE RBIOR3_1_I_L[4] = {
    -0.3535533905932738,
    1.0606601717798214,
    1.0606601717798214,
    -0.3535533905932738,
};

DTYPE RBIOR3_1_H[4] = {
    0.3535533905932738,
    1.0606601717798214,
    -1.0606601717798214,
    -0.3535533905932738,
};

DTYPE RBIOR3_1_I_H[4] = {
    0.1767766952966369,
    -0.5303300858899107,
    0.5303300858899107,
    -0.1767766952966369,
};

DTYPE RBIOR3_3_L[8] = {
    0.0,
    0.0,
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
};

DTYPE RBIOR3_3_I_L[8] = {
    0.06629126073623884,
    -0.19887378220871652,
    -0.15467960838455727,
    0.9943689110435825,
    0.9943689110435825,
    -0.15467960838455727,
    -0.19887378220871652,
    0.06629126073623884,
};

DTYPE RBIOR3_3_H[8] = {
    -0.06629126073623884,
    -0.19887378220871652,
    0.15467960838455727,
    0.9943689110435825,
    -0.9943689110435825,
    -0.15467960838455727,
    0.19887378220871652,
    0.06629126073623884,
};

DTYPE RBIOR3_3_I_H[8] = {
    0.0,
    0.0,
    0.1767766952966369,
    -0.5303300858899107,
    0.5303300858899107,
    -0.1767766952966369,
    0.0,
    0.0,
};

DTYPE RBIOR3_5_L[12] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR3_5_I_L[12] = {
    -0.013810679320049757,
    0.04143203796014927,
    0.052480581416189075,
    -0.26792717880896527,
    -0.07181553246425874,
    0.966747552403483,
    0.966747552403483,
    -0.07181553246425874,
    -0.26792717880896527,
    0.052480581416189075,
    0.04143203796014927,
    -0.013810679320049757,
};

DTYPE RBIOR3_5_H[12] = {
    0.013810679320049757,
    0.04143203796014927,
    -0.052480581416189075,
    -0.26792717880896527,
    0.07181553246425874,
    0.966747552403483,
    -0.966747552403483,
    -0.07181553246425874,
    0.26792717880896527,
    0.052480581416189075,
    -0.04143203796014927,
    -0.013810679320049757,
};

DTYPE RBIOR3_5_I_H[12] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    -0.5303300858899107,
    0.5303300858899107,
    -0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR3_7_L[16] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR3_7_I_L[16] = {
    0.0030210861012608843,
    -0.009063258303782653,
    -0.01683176542131064,
    0.074663985074019,
    0.03133297870736289,
    -0.301159125922835,
    -0.026499240945345472,
    0.9516421218971786,
    0.9516421218971786,
    -0.026499240945345472,
    -0.301159125922835,
    0.03133297870736289,
    0.074663985074019,
    -0.01683176542131064,
    -0.009063258303782653,
    0.0030210861012608843,
};

DTYPE RBIOR3_7_H[16] = {
    -0.0030210861012608843,
    -0.009063258303782653,
    0.01683176542131064,
    0.074663985074019,
    -0.03133297870736289,
    -0.301159125922835,
    0.026499240945345472,
    0.9516421218971786,
    -0.9516421218971786,
    -0.026499240945345472,
    0.301159125922835,
    0.03133297870736289,
    -0.074663985074019,
    -0.01683176542131064,
    0.009063258303782653,
    0.0030210861012608843,
};

DTYPE RBIOR3_7_I_H[16] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    -0.5303300858899107,
    0.5303300858899107,
    -0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR3_9_L[20] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    0.5303300858899107,
    0.5303300858899107,
    0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR3_9_I_L[20] = {
    -0.000679744372783699,
    0.002039233118351097,
    0.005060319219611981,
    -0.020618912641105536,
    -0.014112787930175846,
    0.09913478249423216,
    0.012300136269419315,
    -0.32019196836077857,
    0.0020500227115698858,
    0.9421257006782068,
    0.9421257006782068,
    0.0020500227115698858,
    -0.32019196836077857,
    0.012300136269419315,
    0.09913478249423216,
    -0.014112787930175846,
    -0.020618912641105536,
    0.005060319219611981,
    0.002039233118351097,
    -0.000679744372783699,
};

DTYPE RBIOR3_9_H[20] = {
    0.000679744372783699,
    0.002039233118351097,
    -0.005060319219611981,
    -0.020618912641105536,
    0.014112787930175846,
    0.09913478249423216,
    -0.012300136269419315,
    -0.32019196836077857,
    -0.0020500227115698858,
    0.9421257006782068,
    -0.9421257006782068,
    0.0020500227115698858,
    0.32019196836077857,
    0.012300136269419315,
    -0.09913478249423216,
    -0.014112787930175846,
    0.020618912641105536,
    0.005060319219611981,
    -0.002039233118351097,
    -0.000679744372783699,
};

DTYPE RBIOR3_9_I_H[20] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.1767766952966369,
    -0.5303300858899107,
    0.5303300858899107,
    -0.1767766952966369,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR4_4_L[10] = {
    0.0,
    0.0,
    -0.06453888262869706,
    -0.04068941760916406,
    0.41809227322161724,
    0.7884856164055829,
    0.41809227322161724,
    -0.04068941760916406,
    -0.06453888262869706,
    0.0,
};

DTYPE RBIOR4_4_I_L[10] = {
    0.03782845550726404,
    -0.023849465019556843,
    -0.11062440441843718,
    0.37740285561283066,
    0.8526986790088938,
    0.37740285561283066,
    -0.11062440441843718,
    -0.023849465019556843,
    0.03782845550726404,
    0.0,
};

DTYPE RBIOR4_4_H[10] = {
    -0.03782845550726404,
    -0.023849465019556843,
    0.11062440441843718,
    0.37740285561283066,
    -0.8526986790088938,
    0.37740285561283066,
    0.11062440441843718,
    -0.023849465019556843,
    -0.03782845550726404,
    0.0,
};

DTYPE RBIOR4_4_I_H[10] = {
    0.0,
    0.0,
    -0.06453888262869706,
    0.04068941760916406,
    0.41809227322161724,
    -0.7884856164055829,
    0.41809227322161724,
    0.04068941760916406,
    -0.06453888262869706,
    0.0,
};

DTYPE RBIOR5_5_L[12] = {
    0.0,
    0.013456709459118716,
    -0.002694966880111507,
    -0.13670658466432914,
    -0.09350469740093886,
    0.47680326579848425,
    0.8995061097486484,
    0.47680326579848425,
    -0.09350469740093886,
    -0.13670658466432914,
    -0.002694966880111507,
    0.013456709459118716,
};

DTYPE RBIOR5_5_I_L[12] = {
    0.0,
    0.03968708834740544,
    0.007948108637240322,
    -0.05446378846823691,
    0.34560528195603346,
    0.7366601814282105,
    0.34560528195603346,
    -0.05446378846823691,
    0.007948108637240322,
    0.03968708834740544,
    0.0,
    0.0,
};

DTYPE RBIOR5_5_H[12] = {
    0.0,
    0.03968708834740544,
    -0.007948108637240322,
    -0.05446378846823691,
    -0.34560528195603346,
    0.7366601814282105,
    -0.34560528195603346,
    -0.05446378846823691,
    -0.007948108637240322,
    0.03968708834740544,
    0.0,
    0.0,
};

DTYPE RBIOR5_5_I_H[12] = {
    0.0,
    -0.013456709459118716,
    -0.002694966880111507,
    0.13670658466432914,
    -0.09350469740093886,
    -0.47680326579848425,
    0.8995061097486484,
    -0.47680326579848425,
    -0.09350469740093886,
    0.13670658466432914,
    -0.002694966880111507,
    -0.013456709459118716,
};

DTYPE RBIOR6_8_L[18] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.014426282505624435,
    0.014467504896790148,
    -0.07872200106262882,
    -0.04036797903033992,
    0.41784910915027457,
    0.7589077294536541,
    0.41784910915027457,
    -0.04036797903033992,
    -0.07872200106262882,
    0.014467504896790148,
    0.014426282505624435,
    0.0,
    0.0,
    0.0,
};

DTYPE RBIOR6_8_I_L[18] = {
    0.0019088317364812906,
    -0.0019142861290887667,
    -0.016990639867602342,
    0.01193456527972926,
    0.04973290349094079,
    -0.07726317316720414,
    -0.09405920349573646,
    0.4207962846098268,
    0.8259229974584023,
    0.4207962846098268,
    -0.09405920349573646,
    -0.07726317316720414,
    0.04973290349094079,
    0.01193456527972926,
    -0.016990639867602342,
    -0.0019142861290887667,
    0.0019088317364812906,
    0.0,
};

DTYPE RBIOR6_8_H[18] = {
    -0.0019088317364812906,
    -0.0019142861290887667,
    0.016990639867602342,
    0.01193456527972926,
    -0.04973290349094079,
    -0.07726317316720414,
    0.09405920349573646,
    0.4207962846098268,
    -0.8259229974584023,
    0.4207962846098268,
    0.09405920349573646,
    -0.07726317316720414,
    -0.04973290349094079,
    0.01193456527972926,
    0.016990639867602342,
    -0.0019142861290887667,
    -0.0019088317364812906,
    0.0,
};

DTYPE RBIOR6_8_I_H[18] = {
    0.0,
    0.0,
    0.0,
    0.0,
    0.014426282505624435,
    -0.014467504896790148,
    -0.07872200106262882,
    0.04036797903033992,
    0.41784910915027457,
    -0.7589077294536541,
    0.41784910915027457,
    0.04036797903033992,
    -0.07872200106262882,
    -0.014467504896790148,
    0.014426282505624435,
    0.0,
    0.0,
    0.0,
};

// The Haar transform has efficient dedicated kernel, since the boundary extension is not needed.
// When performing SWT, however, the filters are extended, so the boundary extension is required.
DTYPE HAAR_L[4] = {
    0.7071067811865476,
    0.7071067811865476
};
DTYPE HAAR_H[4] = {
    -0.7071067811865476,
    0.7071067811865476
};
DTYPE HAAR_I_L[4] = {
    0.7071067811865476,
    0.7071067811865476
};
DTYPE HAAR_I_H[4] = {
    0.7071067811865476,
    -0.7071067811865476
};



///
/// Structure containing the filters pointers
///


wfilter all_filters[72] = {

    // aggregate initialization cannot be used here
    // { .wname = "db2", .hlen = 4, DB2_L, DB2_H, DB2_I_L, DB2_I_H },

    { "db2", 4, DB2_L, DB2_H, DB2_I_L, DB2_I_H },
    { "db3", 6, DB3_L, DB3_H, DB3_I_L, DB3_I_H },
    { "db4", 8, DB4_L, DB4_H, DB4_I_L, DB4_I_H },
    { "db5", 10, DB5_L, DB5_H, DB5_I_L, DB5_I_H },
    { "db6", 12, DB6_L, DB6_H, DB6_I_L, DB6_I_H },
    { "db7", 14, DB7_L, DB7_H, DB7_I_L, DB7_I_H },
    { "db8", 16, DB8_L, DB8_H, DB8_I_L, DB8_I_H },
    { "db9", 18, DB9_L, DB9_H, DB9_I_L, DB9_I_H },
    { "db10", 20, DB10_L, DB10_H, DB10_I_L, DB10_I_H },
    { "db11", 22, DB11_L, DB11_H, DB11_I_L, DB11_I_H },
    { "db12", 24, DB12_L, DB12_H, DB12_I_L, DB12_I_H },
    { "db13", 26, DB13_L, DB13_H, DB13_I_L, DB13_I_H },
    { "db14", 28, DB14_L, DB14_H, DB14_I_L, DB14_I_H },
    { "db15", 30, DB15_L, DB15_H, DB15_I_L, DB15_I_H },
    { "db16", 32, DB16_L, DB16_H, DB16_I_L, DB16_I_H },
    { "db17", 34, DB17_L, DB17_H, DB17_I_L, DB17_I_H },
    { "db18", 36, DB18_L, DB18_H, DB18_I_L, DB18_I_H },
    { "db19", 38, DB19_L, DB19_H, DB19_I_L, DB19_I_H },
    { "db20", 40, DB20_L, DB20_H, DB20_I_L, DB20_I_H },

    { "sym2", 4, SYM2_L, SYM2_H, SYM2_I_L, SYM2_I_H },
    { "sym3", 6, SYM3_L, SYM3_H, SYM3_I_L, SYM3_I_H },
    { "sym4", 8, SYM4_L, SYM4_H, SYM4_I_L, SYM4_I_H },
    { "sym5", 10, SYM5_L, SYM5_H, SYM5_I_L, SYM5_I_H },
    { "sym6", 12, SYM6_L, SYM6_H, SYM6_I_L, SYM6_I_H },
    { "sym7", 14, SYM7_L, SYM7_H, SYM7_I_L, SYM7_I_H },
    { "sym8", 16, SYM8_L, SYM8_H, SYM8_I_L, SYM8_I_H },
    { "sym9", 18, SYM9_L, SYM9_H, SYM9_I_L, SYM9_I_H },
    { "sym10", 20, SYM10_L, SYM10_H, SYM10_I_L, SYM10_I_H },
    { "sym11", 22, SYM11_L, SYM11_H, SYM11_I_L, SYM11_I_H },
    { "sym12", 24, SYM12_L, SYM12_H, SYM12_I_L, SYM12_I_H },
    { "sym13", 26, SYM13_L, SYM13_H, SYM13_I_L, SYM13_I_H },
    { "sym14", 28, SYM14_L, SYM14_H, SYM14_I_L, SYM14_I_H },
    { "sym15", 30, SYM15_L, SYM15_H, SYM15_I_L, SYM15_I_H },
    { "sym16", 32, SYM16_L, SYM16_H, SYM16_I_L, SYM16_I_H },
    { "sym17", 34, SYM17_L, SYM17_H, SYM17_I_L, SYM17_I_H },
    { "sym18", 36, SYM18_L, SYM18_H, SYM18_I_L, SYM18_I_H },
    { "sym19", 38, SYM19_L, SYM19_H, SYM19_I_L, SYM19_I_H },
    { "sym20", 40, SYM20_L, SYM20_H, SYM20_I_L, SYM20_I_H },

    { "coif1", 6, COIF1_L, COIF1_H, COIF1_I_L, COIF1_I_H },
    { "coif2", 12, COIF2_L, COIF2_H, COIF2_I_L, COIF2_I_H },
    { "coif3", 18, COIF3_L, COIF3_H, COIF3_I_L, COIF3_I_H },
    { "coif4", 24, COIF4_L, COIF4_H, COIF4_I_L, COIF4_I_H },
    { "coif5", 30, COIF5_L, COIF5_H, COIF5_I_L, COIF5_I_H },

    { "bior1.3", 6, BIOR1_3_L, BIOR1_3_H, BIOR1_3_I_L, BIOR1_3_I_H },
    { "bior1.5", 10, BIOR1_5_L, BIOR1_5_H, BIOR1_5_I_L, BIOR1_5_I_H },
    { "bior2.2", 6, BIOR2_2_L, BIOR2_2_H, BIOR2_2_I_L, BIOR2_2_I_H },
    { "bior2.4", 10, BIOR2_4_L, BIOR2_4_H, BIOR2_4_I_L, BIOR2_4_I_H },
    { "bior2.6", 14, BIOR2_6_L, BIOR2_6_H, BIOR2_6_I_L, BIOR2_6_I_H },
    { "bior2.8", 18, BIOR2_8_L, BIOR2_8_H, BIOR2_8_I_L, BIOR2_8_I_H },
    { "bior3.1", 4, BIOR3_1_L, BIOR3_1_H, BIOR3_1_I_L, BIOR3_1_I_H },
    { "bior3.3", 8, BIOR3_3_L, BIOR3_3_H, BIOR3_3_I_L, BIOR3_3_I_H },
    { "bior3.5", 12, BIOR3_5_L, BIOR3_5_H, BIOR3_5_I_L, BIOR3_5_I_H },
    { "bior3.7", 16, BIOR3_7_L, BIOR3_7_H, BIOR3_7_I_L, BIOR3_7_I_H },
    { "bior3.9", 20, BIOR3_9_L, BIOR3_9_H, BIOR3_9_I_L, BIOR3_9_I_H },
    { "bior4.4", 10, BIOR4_4_L, BIOR4_4_H, BIOR4_4_I_L, BIOR4_4_I_H },
    { "bior5.5", 12, BIOR5_5_L, BIOR5_5_H, BIOR5_5_I_L, BIOR5_5_I_H },
    { "bior6.8", 18, BIOR6_8_L, BIOR6_8_H, BIOR6_8_I_L, BIOR6_8_I_H },

    { "rbio1.3", 6, RBIOR1_3_L, RBIOR1_3_H, RBIOR1_3_I_L, RBIOR1_3_I_H },
    { "rbio1.5", 10, RBIOR1_5_L, RBIOR1_5_H, RBIOR1_5_I_L, RBIOR1_5_I_H },
    { "rbio2.2", 6, RBIOR2_2_L, RBIOR2_2_H, RBIOR2_2_I_L, RBIOR2_2_I_H },
    { "rbio2.4", 10, RBIOR2_4_L, RBIOR2_4_H, RBIOR2_4_I_L, RBIOR2_4_I_H },
    { "rbio2.6", 14, RBIOR2_6_L, RBIOR2_6_H, RBIOR2_6_I_L, RBIOR2_6_I_H },
    { "rbio2.8", 18, RBIOR2_8_L, RBIOR2_8_H, RBIOR2_8_I_L, RBIOR2_8_I_H },
    { "rbio3.1", 4, RBIOR3_1_L, RBIOR3_1_H, RBIOR3_1_I_L, RBIOR3_1_I_H },
    { "rbio3.3", 8, RBIOR3_3_L, RBIOR3_3_H, RBIOR3_3_I_L, RBIOR3_3_I_H },
    { "rbio3.5", 12, RBIOR3_5_L, RBIOR3_5_H, RBIOR3_5_I_L, RBIOR3_5_I_H },
    { "rbio3.7", 16, RBIOR3_7_L, RBIOR3_7_H, RBIOR3_7_I_L, RBIOR3_7_I_H },
    { "rbio3.9", 20, RBIOR3_9_L, RBIOR3_9_H, RBIOR3_9_I_L, RBIOR3_9_I_H },
    { "rbio4.4", 10, RBIOR4_4_L, RBIOR4_4_H, RBIOR4_4_I_L, RBIOR4_4_I_H },
    { "rbio5.5", 12, RBIOR5_5_L, RBIOR5_5_H, RBIOR5_5_I_L, RBIOR5_5_I_H },
    { "rbio6.8", 18, RBIOR6_8_L, RBIOR6_8_H, RBIOR6_8_I_L, RBIOR6_8_I_H },

    { "haar", 2, HAAR_L, HAAR_H, HAAR_I_L, HAAR_I_H },

};







