#!/usr/bin/perl

package eBay::API::XML::Call::ReviseItem::ReviseItemRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ReviseItemRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::ReviseItem::ReviseItemRequestType

=head1 DESCRIPTION

Enables a seller to change the properties of a currently active listing. Inputs
are the item ID of the ended item being re-listed and any properties that are
being changed for the revision.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::ReviseItem::ReviseItemRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemType;


my @gaProperties = ( [ 'DeletedField', 'xs:string', '1', '', '' ]
	, [ 'Item', 'ns:ItemType', ''
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDeletedField()

Specifies the name of a field to delete from a listing.
You cannot delete required fields from a listing.<br><br>
Some fields are optional when you first list an item (e.g., ListingEnhancement),
but once they are set they cannot be deleted when you revise an item.
Some optional fields cannot be deleted if the item has bids and/or ends within 12 hours.
Some optional fields cannot be deleted if other fields depend on them.
For example, if GalleryType was already set for the item you are revising,
you cannot remove it. Therefore, you still need to include at least one picture URL, a gallery URL,
or a catalog stock photo in your revised listing.
See the eBay Web Services guide for rules on removing values when revising items.
Also see the relevant field descriptions for details on when to use DeletedField
(and potential consequences).<br><br>
The request can contain zero, one, or many instances of DeletedField (one for each field to be deleted).
DeletedField accepts the following path names, which delete the corresponding nodes:<br><br>
Item.ApplicationData<br>
Item.AttributeSetArray<br>
Item.BuyItNowPrice<br>
Item.ItemSpecifics<br>
Item.ListingCheckoutRedirectPreference.ProStoresStoreName<br>
Item.ListingCheckoutRedirectPreference.SellerThirdPartyUsername<br>
Item.ListingDesigner.LayoutID<br>
Item.ListingDesigner.ThemeID<br>
Item.ListingDetails.MinimumBestOfferMessage<br>
Item.ListingDetails.MinimumBestOfferPrice<br>
Item.PayPalEmailAddress<br>
Item.PictureDetails.GalleryURL<br>
Item.PictureDetails.PictureURL<br>
Item.PostalCode<br>
Item.ProductListingDetails<br>
Item.SellerContactDetails<br>
Item.SellerContactDetails.CompanyName<br>
Item.SellerContactDetails.County<br>
Item.SellerContactDetails.InternationalStreet<br>
Item.SellerContactDetails.Phone2AreaOrCityCode<br>
Item.SellerContactDetails.Phone2CountryCode<br>
Item.SellerContactDetails.Phone2CountryPrefix<br>
Item.SellerContactDetails.Phone2LocalNumber<br>
Item.SellerContactDetails.PhoneAreaOrCityCode<br>
Item.SellerContactDetails.PhoneCountryCode<br>
Item.SellerContactDetails.PhoneCountryPrefix<br>
Item.SellerContactDetails.PhoneLocalNumber<br>
Item.SellerContactDetails.Street<br>
Item.SellerContactDetails.Street2<br>
Item.ShippingDetails.PaymentInstructions<br>
Item.SKU<br>
These values are case-sensitive. Use values that match the case of the
schema element names (Item.PictureDetails.GalleryURL) or make the initial
letter of each field name lowercase (item.pictureDetails.galleryURL).
However, do not change the case of letters in the middle of a field name.
For example, item.picturedetails.galleryUrl is not allowed.

  RequiredInput: Conditionally
#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setDeletedField {
  my $self = shift;
  $self->{'DeletedField'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDeletedField()

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getDeletedField {
  my $self = shift;
  return $self->_getDataTypeArray('DeletedField');
}


=head2 setItem()

Required. Child elements hold the values for properties that are changing.
The Item.ItemID property must always be set to the ID of the item listing being changed. Set values in the Item object only for those properties that are changing. Use DeletedField to remove a property. Also applicable to Half.com.

  RequiredInput: Yes
#    Argument: 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = shift
}

=head2 getItem()

#    Returns: 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Item'
		,'eBay::API::XML::DataType::ItemType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
