package Daje::Workflow::GenerateSQL::Script::Sql;
use Mojo::Base 'Daje::Workflow::GenerateSQL::Base::Common', -base, -signatures;

#use v5.30;

use Syntax::Keyword::Match qw(match);

has 'tablename' => "";

sub create_sql($self) {
    my $sql = "";
    my $json = $self->json->{sql};
    my $length = scalar @{$json};
    for (my $i = 0; $i < $length; $i++) {
        my $type = $self->templates->get_section(@{$json}[$i]->{type});
        my $template = $self->templates->get_section($type);

        match ($type : eq) {
            case('insert') {
                $template =~ s/<<tablename>>/$self->tablename/ig;
                $template =~ s/<<fields>>/@{$json}[$i]->{fields}/ig;
                $template =~ s/<<values>>/@{$json}[$i]->{values}/ig;
            }
            default { $template = "" }
        }
        $sql .= $template . '\n';
    }
    $self->set_sql($sql);
    return;
}

1;







#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::GenerateSQL::Script::Sql


=head1 DESCRIPTION

use v5.30;


=head1 REQUIRES

L<v5.30> 

L<Syntax::Keyword::Match> 

L<Mojo::Base> 


=head1 METHODS

=head2 create_sql($self)

 create_sql($self)();


=cut

