package Daje::Workflow::FileChanged::Activity;
use Mojo::Base 'Daje::Workflow::Common::Activity::Base', -base, -signatures;

use Daje::Config;
use Daje::Tools::Filechanged;
use Daje::Workflow::FileChanged::Database::Model::FileHashes;

# NAME
#
# Daje::Workflow::FileChanged::Activity - It's new $module
#
# SYNOPSIS
# ========
#    use Daje::Workflow::FileChanged::Activity;
#
#    my $activity = Daje::Workflow::FileChanged::Activity->new(
#           db => $db,
#           context => $context,
#           error => $error,
#    );
#
#    $activity->changed_files();
#
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::FileChanged::Activity is ...
#
# LICENSE
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#


our $VERSION = "0.03";

sub changed_files($self) {

    my @changed_files;
    my $filelist = Daje::Config->new(
        path => $self->context->{context}->{source_dir}
    )->load_list();

    $self->model->insert_history(
        $filelist->size . " files found", "Daje::Workflow::FileChanged::Activity", 0
    );

    my $filehash = Daje::Workflow::FileChanged::Database::Model::FileHashes->new(
        db => $self->db
    );
    my $changed = Daje::Tools::Filechanged->new();
    $filelist->each(sub ($file, $num) {
        my $hash_data = $filehash->load_hash($file);
        unless (defined $hash_data) {
            my $hash = $changed->load_new_hash($file);
            $filehash->save_hash($file, $hash);
            push (@changed_files, $file);
        } else {
            if($changed->is_file_changed($file, $hash_data)) {
                push (@changed_files, $file);
            }
        }
    });

    $self->model->insert_history(
        scalar(@changed_files) . " changed files found", "Daje::Workflow::FileChanged::Activity", 0
    );

    if (@changed_files > 0) {
        $self->context->{context}->{changed_files} = \@changed_files;
    }
}

1;
__END__




#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::FileChanged::Activity


=head1 SYNOPSIS

   use Daje::Workflow::FileChanged::Activity;

   my $activity = Daje::Workflow::FileChanged::Activity->new(
          db => $db,
          context => $context,
          error => $error,
   );

   $activity->changed_files();




=head1 DESCRIPTION

NAME

Daje::Workflow::FileChanged::Activity - It's new $module


Daje::Workflow::FileChanged::Activity is ...

LICENSE

Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.




=head1 REQUIRES

L<Daje::Tools::Filechanged> 

L<Daje::Config> 

L<Mojo::Base> 


=head1 METHODS

=head2 changed_files($self)

 changed_files($self)();


=head1 AUTHOR

janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

