


package DataCube::Cube::Style::HTML;

use strict;
use warnings;

use DateTime;
use DataCube::Cube::Style::HTML::CSS;


sub new {
    my($class,%opts) = @_;
    bless { %opts }, ref($class) || $class;
}

sub html {
    my($self,$cube) = @_;
    my $html = "";
    $html .= $self->start_html($cube);
    $html .= $self->start_body($cube);
    $html .= $self->top_section($cube);
    
    $html .= $self->start_details($cube);
    $html .= $self->details($cube);    
    $html .= $self->end_details($cube);

    $html .= $self->end_body($cube);
    $html .= $self->end_html($cube);
    return $html;
}

sub html_from_table {
    my($self,$cube,@table) = @_;
    
    my $html = "";
    
    $html .= $self->start_html($cube);
    $html .= $self->start_body($cube);
    $html .= $self->top_section($cube,@table);
    
    $html .= $self->start_details($cube);
    $html .= $self->details_from_table($cube,@table);    
    $html .= $self->end_details($cube);

    $html .= $self->end_body($cube);
    $html .= $self->end_html($cube);

    return $html;

}

sub start_html {
    my($self,$cube) = @_;
    my $style = DataCube::Cube::Style::HTML::CSS->new;

    my $html = '
        <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> 
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf8" /> 
            <title>Cube Report</title>';
    
    $html .= $style->css;
    $html .= '</head>';
    return $html;
}

sub end_html {
    my($self,$cube) = @_;
    my $html = '</html>';
    return $html;
}

sub start_body {
    my($self,$cube) = @_;
    my $html = '<body>';
    return $html;
}

sub end_body {
    my($self,$cube) = @_;
    my $dt = DateTime->now;
    my $year = $dt->year;
    my $html = '
        <br />
        <h2>
            <div style="font-size:80%;">
                Cube Report Generated by Project Codenamed "Blackbear"
                <br />
                Copyright (C) 2009-' . $year . ' David Williams
            </div>
        </h2>
    </body>';
    return $html;
}

sub top_section {
    my($self,$cube,@table) = @_;
    my $time   = scalar(localtime());
    my $rows   = @table ? $#table : scalar(keys %{$cube->{cube}});
    my $schema = $cube->schema;
    my $dim_count = $schema->field_count;
    my $mea_count = $schema->measure_count;
    my $html = "
        <h1>Cube Report</h1> 
        <p>
            <span class='note'>
                <strong>Report Generated at: $time</strong>
                <br>
            </span>
        </p>";
        
    $html .=  "
        <table cellpadding='2' cellspacing='0' width='98%' border='1' bordercolor='white' class='infotable'> 
            <tr>
                <td class='header' colspan='2'>Cube Report Summary</td>
            </tr> 
            <tr>
                <td class='content' width='50%'>&nbsp;</td>
                <td class='content'>&nbsp;</td>
            </tr> 
            <tr>
                
                <td class='footr' align='right'>Rows&nbsp;</td>
                <td class='foot'  align='left'>&nbsp;$rows</td>
            </tr>
            <tr>
                <td class='footr' align='right'>Measures&nbsp;</td>
                <td class='foot'  align='left'>&nbsp;$mea_count</td>
            </tr>
            <tr>
                <td class='footr' align='right'>Dimensions&nbsp;</td>
                <td class='foot'  align='left'>&nbsp;$dim_count</td>
            </tr>
            
        </table>
        <br>";
    return $html;
}

sub start_details {
    my($self,$cube) = @_;
    my $schema = $cube->schema;
    my $fields = $schema->field_count + $schema->measure_count;
    my $html = "
        <table cellpadding='2' cellspacing='0' width='98%' border='1' bordercolor='white' class='infotable'> 
        <tr><td class='header' colspan='$fields'>Cube Report Details</td></tr>";
    
    my @measures    = $schema->measures;
    my @field_names = $schema->field_names;
    for(@measures) {
        $_->[2] = 'count' if $_->[0] eq 'key_count'
    }
    @measures = sort {$a->[2] cmp $b->[2]} @measures;
    
    header_row: {
        $html .= "\n<tr>\n";
        $html .= "\t<td class='content' width='5%'>$_</td>\n"      for @field_names;
        $html .= "\t<td class='content' width='5%'>$_->[2]</td>\n" for @measures;
        $html .= "</tr>\n";
    }
    
    return $html;
}

sub end_details {
    my($self,$cube) = @_;
    my $html = '</table>';
    return $html;
}

sub details_from_table {
    my($self,$cube,@table) = @_;
    my $html = "";
    shift @table;
    @table = sort { join("\t",@$a) cmp join("\t",@$b)} @table;
    my $offset = $cube->schema->field_count;
    for(@table){
        my $row = $_;
        $html .= "\n<tr>\n";
        for(my $i = $offset; $i < @$row; ++$i){
            $row->[$i] = sprintf("%20.2f",$row->[$i]) if $row->[$i] =~ /^-?\d+\.\d*$/
        }
        $html .= "\t<td class='foot' align='center'>$_</td>\n" for @$row;
        $html .= "\n</tr>\n";
    }
    return $html;
}

sub details {
    my($self,$cube) = @_;
    my $data = $cube->{cube};
    my $html = "";
    my $schema   = $cube->schema;
    my @measures = $schema->measures;
    my @table = $cube->to_table;
    return $self->details_from_table($cube,@table);
}



1;






__DATA__

 





