package Db::Access;

use strict;
use warnings;

our $VERSION =  '0.01_03';



1;

=encoding utf8

=head1 NAME

Db::Access - Placeholder namespace for the D distribution

=head1 SYNOPSIS

=head1 SYNOPSIS

  use D;

  my $schema =  D::db;      # DBIx::Class::Schema
  my $dbh    =  D::dbh;     # DBI handle

  my $users  =  D::S  User => { active => 1 };
  my $user   =  D::SS User => 1;

  my $count  =  D::q00 'SELECT count(*) FROM "User"';

  # Find by ID, another PK or set of conditions
  my $row =  D::T User =>  7;
  my $row =  D::T User =>  { id => 7 };
  my $row =  D::T User =>  { email => 'a@example.com' };
  my $row =  D::T User =>  [ { f1 => 'v1' }, { f2 => 'v2' } ]; # See SQL::Abstract
  my $row =  D::T User =>  { field1 => 'cond1', field2 => 'cond2' };

  # Find existing or create by merging COND and DATA. COND merged only if it is a HASH.
  # The create dies if user will try to use custom values for PKs
  my $row =  D::T User =>  { email => 'a@example.com' }, { name => 'Alice' };
  my $row =  D::T User =>  undef, { name => 'Alice' }  # Same as D::C User => { name => 'Alice' };

  # Find and update. If not found `{ f2 => 'v2' }` will be created.
  # NOTE: It is still not clear should we create when nothing was found and 'update'
  # flag is true. Or should we return `undef`.
  my $row =  D::T User =>  { f1 => 'value1' }, { f2 => 'v2' }, 'update';


  # Update $row
  D::RU $row, { f1 => 'v1' };

  # Delete $row
  D::RD $row;


  # Work with transaction
  my $atomic =  D::txn;        # ->txn_scope_guard
  ...
  if( ... ) { return; }        # transaction will be rolled back automatically
  $atomic->commit;


  # All methods from DBIx::Class::Storage are available
  my $db =  D::db;
  $db->txn_begin;
  $db->svp_begin;
  $db->txn_do( $coderef );
  $db->svp_release;
  $db->svp_rollback;
  $db->txn_rollback;
  $db->txn_commit;


=head1 DESCRIPTION

The main public API of this distribution is L<D>.

This package exists as a reserved namespace and may gain functionality in
future releases.

=head1 EXAMPLES

  my $ar_cpu =  D::T Resource => {
         resource_type_id      => $od->resource_type_id,
         resource_uuid         => $cpu_uuid,
  }, {
         parent_id             => $ar_parent_id,
         resource_container_id => $r_zone->id,
         amount                => $cpu_desc,
         description           => $cpu_desc,
  };




  # Store info
  my $zone =  D::T Zone          => { name => $name };
  my $str  =  D::T ResourceType  => { name => 'str' };
  my $nic  =  D::T Resource      => {
      resource_uuid    => $uuid,
  },{
      zone_id          => $zone->id,
      parent_id        => $parent_id,
      resource_type_id => $str->id,
      description      => $desc,
  };


  $D::SECURE = 0;
  D::T Dictionary => { -or => [
          name    =>  $order->{ desc },
          display =>  $order->{ desc },
  ]}

  Update contract set comment = $: where agreement_id = $: and ....
  my $xap =  D::T Contract => {
      agreement_id =>  $contract->id,
      person_id    =>  $person->id,
      type         =>  $type,
  },{
      comment      =>  $comment,
  }, 'update';


Dialog with DB becomes easy.

  D::T User undef, { email => $email, department_id => 777 }
  L::warn '';
  L::info '';


  $data->{ department_id => C::C->{ department_id } }
  $rs->(      )


=head1 SEE ALSO

L<D>

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2026 Eugen Konkov.

This program is free software, you can redistribute it and/or modify it under
the terms of the MIT License.

=cut
