package Local::Schema::Result::Cd;
use base qw/DBIx::Class::Core/;

__PACKAGE__->table('cd');
__PACKAGE__->add_columns(
  'cd_id' => {
    data_type => 'integer',
    is_auto_increment => 1,
  },
  'title' => {
    data_type => 'varchar',
    size => '96',
  },
  'order' => {
    # use SQL word to exercise quoting
    data_type => 'varchar',
    size => '96',
    is_nullable => 1,
  });

__PACKAGE__->set_primary_key('cd_id');
__PACKAGE__->has_many('tracks' => "Local::Schema::Result::Track");

__PACKAGE__->has_many(
  'artist_cd_rs' => 'Local::Schema::Result::ArtistCd',
  {'foreign.cd_fk'=>'self.cd_id'});

__PACKAGE__->many_to_many(artists_cd => artist_cd_rs => 'artist');

1;
