package Daje::Database::Model::Super::ToolsObjectIndex;
use Mojo::Base 'Daje::Database::Model::Super::Common::Base', -base, -signatures, -async_await;;
use v5.42;

has 'fields' => 'tools_object_index_pkey, editnum, insby, insdatetime, modby, moddatetime, tools_version_fkey, tools_objects_fkey, table_name, fields, index_unique';
has 'primary_key_name' => "tools_object_index_pkey";
has 'table_name' => "tools_object_index";

async sub load_tools_object_fkey_p($self, $tools_objects_fkey) {
    return $self->load_tools_objects_fkey($tools_objects_fkey);
}

async sub load_tools_object_index_pkey_p($self, $tools_object_index_pkey) {
    return $self->load_tools_object_index_pkey($tools_object_index_pkey)
}

sub load_tools_object_index_pkey($self, $tools_object_index_pkey) {
    return $self->load_pk(
        $self->table_name, $self->fields(), $self->primary_key_name(), $tools_object_index_pkey
    );
}

sub load_tools_objects_index_fkey($self, $foregin_key_name, $tools_objects_fkey) {
    return $self->load_fkey(
        $self->table_name, $self->fields(), $foregin_key_name, $tools_objects_fkey
    );
}

sub insert($self, $data) {
    my $result = $self->SUPER::insert($self->table_name, $data, $self->primary_key_name);
    return $result;
}


sub update($self, $data) {
    return $self->SUPER::update($self->table_name, $data, { $self->primary_key_name() => $data->{$self->primary_key_name()}});
}


1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Database::Model::Super::ToolsObjectIndex


=head1 REQUIRES

L<Mojo::Base> 


=head1 METHODS

=head2 insert($self,

 insert($self,();

=head2 load_tools_object_index_pkey($self,

 load_tools_object_index_pkey($self,();

=head2 load_tools_objects_index_fkey($self,

 load_tools_objects_index_fkey($self,();

=head2 update($self,

 update($self,();


=cut

