# This file was automatically generated by SWIG
package Schedule::DRMAAc;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
package Schedule::DRMAAcc;
bootstrap Schedule::DRMAAc;
package Schedule::DRMAAc;
@EXPORT = qw( $DRMAA_ATTR_BUFFER $DRMAA_CONTACT_BUFFER $DRMAA_DRM_SYSTEM_BUFFER $DRMAA_ERROR_STRING_BUFFER $DRMAA_JOBNAME_BUFFER $DRMAA_SIGNAL_BUFFER $DRMAA_TIMEOUT_WAIT_FOREVER $DRMAA_TIMEOUT_NO_WAIT $DRMAA_JOB_IDS_SESSION_ANY $DRMAA_JOB_IDS_SESSION_ALL $DRMAA_SUBMISSION_STATE_ACTIVE $DRMAA_SUBMISSION_STATE_HOLD $DRMAA_PLACEHOLDER_INCR $DRMAA_PLACEHOLDER_HD $DRMAA_PLACEHOLDER_WD $DRMAA_REMOTE_COMMAND $DRMAA_JS_STATE $DRMAA_WD $DRMAA_JOB_CATEGORY $DRMAA_NATIVE_SPECIFICATION $DRMAA_BLOCK_EMAIL $DRMAA_START_TIME $DRMAA_JOB_NAME $DRMAA_INPUT_PATH $DRMAA_OUTPUT_PATH $DRMAA_ERROR_PATH $DRMAA_JOIN_FILES $DRMAA_TRANSFER_FILES $DRMAA_DEADLINE_TIME $DRMAA_WCT_HLIMIT $DRMAA_WCT_SLIMIT $DRMAA_DURATION_HLIMIT $DRMAA_DURATION_SLIMIT $DRMAA_V_ARGV $DRMAA_V_ENV $DRMAA_V_EMAIL $DRMAA_ERRNO_SUCCESS $DRMAA_ERRNO_INTERNAL_ERROR $DRMAA_ERRNO_DRM_COMMUNICATION_FAILURE $DRMAA_ERRNO_AUTH_FAILURE $DRMAA_ERRNO_INVALID_ARGUMENT $DRMAA_ERRNO_NO_ACTIVE_SESSION $DRMAA_ERRNO_NO_MEMORY $DRMAA_ERRNO_INVALID_CONTACT_STRING $DRMAA_ERRNO_DEFAULT_CONTACT_STRING_ERROR $DRMAA_ERRNO_DRMS_INIT_FAILED $DRMAA_ERRNO_ALREADY_ACTIVE_SESSION $DRMAA_ERRNO_DRMS_EXIT_ERROR $DRMAA_ERRNO_INVALID_ATTRIBUTE_FORMAT $DRMAA_ERRNO_INVALID_ATTRIBUTE_VALUE $DRMAA_ERRNO_CONFLICTING_ATTRIBUTE_VALUES $DRMAA_ERRNO_TRY_LATER $DRMAA_ERRNO_DENIED_BY_DRM $DRMAA_ERRNO_INVALID_JOB $DRMAA_ERRNO_RESUME_INCONSISTENT_STATE $DRMAA_ERRNO_SUSPEND_INCONSISTENT_STATE $DRMAA_ERRNO_HOLD_INCONSISTENT_STATE $DRMAA_ERRNO_RELEASE_INCONSISTENT_STATE $DRMAA_ERRNO_EXIT_TIMEOUT $DRMAA_ERRNO_NO_RUSAGE $DRMAA_NO_ERRNO $DRMAA_PS_UNDETERMINED $DRMAA_PS_QUEUED_ACTIVE $DRMAA_PS_SYSTEM_ON_HOLD $DRMAA_PS_USER_ON_HOLD $DRMAA_PS_USER_SYSTEM_ON_HOLD $DRMAA_PS_RUNNING $DRMAA_PS_SYSTEM_SUSPENDED $DRMAA_PS_USER_SUSPENDED $DRMAA_PS_USER_SYSTEM_SUSPENDED $DRMAA_PS_DONE $DRMAA_PS_FAILED $DRMAA_CONTROL_SUSPEND $DRMAA_CONTROL_RESUME $DRMAA_CONTROL_HOLD $DRMAA_CONTROL_RELEASE $DRMAA_CONTROL_TERMINATE drmaa_get_next_attr_name drmaa_get_next_attr_value drmaa_get_next_job_id drmaa_release_attr_names drmaa_release_attr_values drmaa_release_job_ids drmaa_init drmaa_exit drmaa_allocate_job_template drmaa_delete_job_template drmaa_set_attribute drmaa_get_attribute drmaa_set_vector_attribute drmaa_get_vector_attribute drmaa_get_attribute_names drmaa_get_vector_attribute_names drmaa_run_job drmaa_run_bulk_jobs drmaa_control drmaa_synchronize drmaa_wait drmaa_wifexited drmaa_wexitstatus drmaa_wifsignaled drmaa_wtermsig drmaa_wcoredump drmaa_wifaborted drmaa_job_ps drmaa_strerror drmaa_get_contact drmaa_version drmaa_get_DRM_system drmaa_get_DRMAA_implementation );
##############################################################################
#  Copyright (c) 2004, The Regents of the University of California.
#  Produced at the Lawrence Livermore National Laboratory.
#  Written by Tim Harsch <harsch1@llnl.gov>
#  UCRL-CODE-155918
#  All rights reserved.
#
#  This file is part of Schedule::DRMAAc. For details, see CPAN
#  Please also read LICENSE.txt which is found in this source distribution.
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (as published by the
#  Free Software Foundation) version 2, dated June 1991.
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY
#  OF MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#  See the terms and conditions of the GNU General Public License for more
#  details.
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
##############################################################################
#  $Id: Schedule_DRMAAc_ext.pm,v 1.2 2004/04/27 20:50:30 harsch Exp $
##############################################################################

package Schedule::DRMAAc;
require Exporter;

@ISA = qw( Exporter );

$DRMAA::revision = '$Id: Schedule_DRMAAc_ext.pm,v 1.2 2004/04/27 20:50:30 harsch Exp $';
$DRMAA::VERSION = '0.8';

@EXPORT_OK = @EXPORT;
@EXPORT = ();
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

=head1 NAME

Schedule::DRMAAc - Perl wrapper of the C binding of the DRMAA
(Distributed Resource Managment Application API) specification.

=head1 SYNOPSIS

	This module is a Perl wrapper for the C binding of the DRMAA
specification, which allows for the submission and control of jobs to one
or more Distributed Resource Management (DRM) systems (eg. SGE, Condor,
etc. ).

use DRMAA qw/ :all /;

( $error, $diagnosis ) = drmaa_init( undef );
die drmaa_strerror( $error ) . "\n" . $diagnosis if $error;

( $error, $jt, $diagnosis ) = drmaa_allocate_job_template();
die drmaa_strerror( $error ) . "\n" . $diagnosis if $error;

( $error, $diagnosis ) = drmaa_set_attribute( $jt, $DRMAA_REMOTE_COMMAND, '/bin/sleep' );
die drmaa_strerror( $error ) . "\n" . $diagnosis if $error;

( $error, $diagnosis ) = drmaa_set_vector_attribute( $jt, $DRMAA_V_ARGV, [ "1" ] );  # 1st argv param = 1 (to run for 1 second)
die drmaa_strerror( $error ) . "\n" . $diagnosis if $error;

( $error, $jobid, $diagnosis ) = drmaa_run_job( $jt );
die drmaa_strerror( $error ) . "\n" . $diagnosis if $error;

my @job_constant = ( $DRMAA_JOB_IDS_SESSION_ALL );
( $error, $diagnosis ) = drmaa_synchronize( \@job_constant , $DRMAA_TIMEOUT_WAIT_FOREVER, 0 );
die drmaa_strerror( $error ) . "\n" . $diagnosis if $error;

( $error, $diagnosis ) = drmaa_delete_job_template( $jt );
die drmaa_strerror( $error ) . "\n" . $diagnosis if $error;

=head1 AUTHOR

Tim Harsch harsch1@llnl.gov

=head1 NOTES

This module was created using SWIG on the drmaa.h file provided in SGE
version 6.0.  As such, certain behaviours of the module were decided by
either the unerlying DRMAA library, or by SWIG's method of generating Perl
to C wrapping functionality.  Needless, to say the design of this Perl
module's API is somewhat constrained by the underlying C library.

Nearly every function listed below has an $error and a $diagnosis
returned from it.  In nearly all cases $error will be
$DRMAA_ERRNO_SUCCESS, and an error otherwise.  The $error can be looked up
via the drmaa_strerror function.  And, $diagnosis provides further
problem hints.

A useful line for checking the success of most of these functions is:

die drmaa_strerror( $error ) . "\n$diagnosis" if $error;

Because $error and $diagnosis are trivial they will not be mentioned again
unless special meaning needs to be clarified.

This documentation was created using the DRMAA spec, SGE drmma.h and
drmaa.c source files as a reference.  Any ambiguities here can be cleared
up by visiting those.

=head1 DESCRIPTION

=head2 vector attributes ( to be used with drmaa_set_vector_attribute and
related functions )

$DRMAA_V_ARGV				( vector of strings )

These parameters are passed as arguments to the job.

$DRMAA_V_ENV				( vector of strings )

The environment values that define the remote environment. Each string
complies with the format <name>=<value>.  The values override the remote
environment values if there are collisions.
If the above is not possible, it is implementation dependent.

$DRMAA_V_EMAIL				( vector of strings )

The email address(es) used to report the job completion and status.

=head2 non-vector attributes ( to be used with drmaa_set_attribute and
related functions )

$DRMAA_REMOTE_COMMAND         ( String )

	The name (and optional path) of the job.  If a relative path is used,
it should be relative to $DRMAA_WD.

$DRMAA_JS_STATE               ( "drmaa_active" or "drmaa_hold" )

	A beginning state for the job to start as on the exec host
	
$DRMAA_WD                     ( String )

	The directory where the job is executed
	
$DRMAA_JOB_CATEGORY           ( String )

	DRM specific value for site-specific policies
	
$DRMAA_NATIVE_SPECIFICATION	( String )

	DRM specific value for site-specific policies"
	
$DRMAA_BLOCK_EMAIL			( 0 or 1 )

	Send or Block email notifications from the DRM
	
$DRMAA_START_TIME	[[[[CC]YY/]MM/]DD] hh:mm[:ss] [{-|+}UU:uu]

	The earliest time when the job may be eligible to be run.  The time
format is as follows:

	[[[[CC]YY/]MM/]DD] hh:mm[:ss] [{-|+}UU:uu]
	
	CC is the first two digits of the year (century-1)
	
	YY is the last two digits of the year

	MM is the two digits of the month [01,12]
	
	DD is the two-digit day of the month [01,31]
	
	hh is the two-digit hour of the day [00,23]
	
	mm is the two-digit minute of the day [00,59]
	
	ss is the two-digit second of the minute [00,61]
	
	UU is the two-digit hours since (before) UTC
	
	uu is the two-digit minutes since (before) UTC
	
	If the optional UTC-offset is not specified, the offset
associated with the local timezone will be used. If the day (DD) is not
specified, the current day will be used unless the specified hour:mm:ss
has already elapsed, in which case the next day will be used. Similarly
for month (MM), year (YY), and century-1 (CC).  Example: The time: Sep 3
4:47:27 PM PDT 2002, could be represented as: 2002/09/03 16:47:27 -07:00

$DRMAA_JOB_NAME               ( String )

	The name of the job, used by the DRM to track the job.

$DRMAA_INPUT_PATH             ( String )

Specifies the jobs' standard input. Unless set elsewhere, if not
explicitly set in the job template, the job is started with an empty input
stream. If set, specifies the network path of the jobs input stream file
of the form [hostname]:file_path When the drmaa_transfer_files job
template attribute is supported and contains the character 'i', the input
file will be fetched by the underlying DRM system from the specified host
or from the submit host if no hostname is specified. When the
$DRMAA_TRANSFER_FILES job template attribute is not supported or does not
contain the character 'i', the input file is always expected at the host
where the job is executed, irrespective of whether hostname is specified.
The $DRMAA_PLACEHOLDER_INC placeholder can be used at any position within
the file_path of parametric job templates and will be substituted by the
underlying DRM system with the parametric jobs' index. A $DRMAA_PLACEHOLDER_HD
placeholder at the begin of the file_path denotes the remaining portion of
the file_path as a relative file specification resolved relative to the
job users home directory at the host where the file is located. A
$DRMAA_PLACEHOLDER_WD placeholder at the begin of the file_path denotes
the remaining portion of the file_path as a relative file specification
resolved relative to the jobs working directory at the host where the file
is located. The file_path must be specified in a syntax that is common at
the host where the file is located. If set, and the file can't be read,
the job enters the state $DRMAA_PS_FAILED.

e.g.	( $error, $diagnosis ) = drmaa_set_attribute( $jt, $DRMAA_INPUT_PATH,
"myhost:$DRMAA_PLACEHOLDER_WD.i$DRMAA_PLACEHOLDER_INC" );

$DRMAA_OUTPUT_PATH            ( String )

Specifies how to direct the jobs' standard output.  If not explicitly set
in the job template, the whereabouts of the jobs output stream is not
defined.  If set, specifies the network path of the jobs output stream
file of the form [hostname]:file_path.  When the drmaa_transfer_files job
template attribute is supported and contains the character 'o', the output
file is transferred by the underlying DRM system to the specified host or
to the submit host if no hostname is specified.  When the
$DRMAA_TRANSFER_FILES job template attribute is not supported or does not
contain the character 'o', the output file is always kept at the host
where the job is executed irrespectively whether hostname is specified.
The $DRMAA_PLACEHOLDER_INC placeholder can be used at any position within
the file_path of parametric job templates and SHALL be substituted by the
underlying DRM system with the parametric jobs' index.  A
$DRMAA_PLACEHOLDER_HD placeholder at the begin of the file_path denotes
the remaining portion of the file_path as a relative file specification
resolved relative to the job users home directory at the host where the
file is located.  A $DRMAA_PLACEHOLDER_WD placeholder at the begin of the
file_path denotes the remaining portion of the file_path as a relative
file specification resolved relative to the jobs working directory at the
host where the file is located. The file_path must be specified in a
syntax that is common at the host where the file is located. If set and
the file can't be written before execution the job enters the state
$DRMAA_PS_FAILED.

$DRMAA_ERROR_PATH             ( String )

Specifies how to direct the jobs' standard error.  If not explicitly set
in the job template, the whereabouts of the jobs error stream is not
defined.  If set, specifies the network path of the jobs error stream file
of the form [hostname]:file_path.  When the drmaa_transfer_files job
template attribute is supported and contains the character 'e', the output
file will be transferred by the underlying DRM system to the specified
host or to the submit host if no hostname is specified.  When the
$DRMAA_TRANSFER_FILES job template attribute is not supported
or does not contain the character 'e', the error file is always kept at the
host where the job is executed irrespectively of a possibly hostname specified.
The $DRMAA_PLACEHOLDER_INC placeholder can be used at any position within the
file_path of parametric job templates and SHALL be substituted by the
underlying DRM system with the parametric jobs' index.  A
$DRMAA_PLACEHOLDER_HD placeholder at the begin of the file_path denotes
the remaining portion of the file_path as a relative file specification
resolved relative to the job users home directory at the host where the
file is located.  A $DRMAA_PLACEHOLDER_WD placeholder at the begin of the
file_path denotes the remaining portion of the file_path as a relative
file specification resolved relative to the jobs working directory at the
host where the file is located.  The file_path must be specified in a
syntax that is common at the host where the file is located.  If set and
the file can't be written before execution the job enters the state
$DRMAA_PS_FAILED.

$DRMAA_JOIN_FILES             ( "y" or "n" )

Specifies if the error stream should be intermixed with the output stream.
If not explicitly set in the job template the attribute defaults to 'n'.
If 'y' is specified the underlying DRM system shall ignore the value of
the drmaa_error_path attribute and intermix the standard error stream with
the standard output stream as specified with $DRMAA_OUTPUT_PATH.

$DRMAA_TRANSFER_FILES         ( any of 'e', 'i' and/or 'o' )

Specifies how to transfer files between hosts.  If not explicitly set in
the job template the attribute defaults to ''.  Any combination of 'e',
'i' and 'o' MAY be specified.  'e' impacts the behavior of the
$DRMAA_ERROR_PATH attribute.  'i' impacts the behavior of the
$DRMAA_INPUT_PATH attribute. 'o' impacts the behavior of the
$DRMAA_OUTPUT_PATH attribute.

$DRMAA_DEADLINE_TIME	[[[[CC]YY/]MM/]DD] hh:mm[:ss] [{-|+}UU:uu]

(OPTIONAL: may not be supported by the DRM)

Specifies a deadline after which the DRMS will terminate a job.  See
$DRMAA_START_TIME for an explanation of the time format.  If optional
portions of the time specifications are omitted the start time is used for
calculate, rather than the current day.

$DRMAA_WCT_HLIMIT             [[h:]m:]s

(OPTIONAL: may not be supported by the DRM)

This attribute specifies how long the job may be in a running state before
its limit has been exceeded, and therefore is terminated by the DRMS.
The value of the attribute is of the form: [[h:]m:]s, where
h is one or more digits representing hours
m is one or more digits representing minutes
s is one or more digits representing seconds

$DRMAA_WCT_SLIMIT             [[h:]m:]s

(OPTIONAL: may not be supported by the DRM)

Like $DRMAA_WCT_SLIMIT, but this attribute is intended to assist the
scheduler. If the time specified in insufficient, the drmaa-implementation
may impose a scheduling penalty.

$DRMAA_DURATION_HLIMIT        [[h:]m:]s

(OPTIONAL: may not be supported by the DRM)

This attribute specifies how long the job may be in a running state
before its limit has been exceeded, and therefore is terminated by the
DRMS.  Suspended time does not count against this time.
See $DRMAA_WCT_HLIMIT for time format.

$DRMAA_DURATION_SLIMIT        [[h:]m:]s

(OPTIONAL: may not be supported by the DRM)

Like $DRMAA_DURATION_HLIMIT, but this attribute is intended to assist the
scheduler. If the time specified in insufficient, the drmaa-implementation
may impose a scheduling penalty.

=item B<drmaa_allocate_job_template>

( $error, $jt, $diagnosis ) = drmaa_allocate_job_template();

$jt	A variable to contain the job template.

purpose:  Allocates a new job template.  The job template can be altered
via setting or clearing job attributes and then jobs launched using the
template in $jt will inherit those behaviours.

=item B<drmaa_control>

( $error, $diagnosis ) = drmaa_control( $job_id, $action );

$job_id	The job ID of the job to control

$action	The action to perform on the job

The legal values for $action and their meanings are:
$DRMAA_CONTROL_SUSPEND     stop the job,
$DRMAA_CONTROL_RESUME      (re)start the job,
$DRMAA_CONTROL_HOLD        put the job on-hold,
$DRMAA_CONTROL_RELEASE     release the hold on the job
$DRMAA_CONTROL_TERMINATE   kill the job.

purpose: Start, stop, restart, or kill the job identified by $job_id. If
$job_id is $DRMAA_JOB_IDS_SESSION_ALL, then this routine acts on all
jobs *submitted* during this DRMAA session.

This routine will return once the action has been acknowledged by the DRM
system, but does not necessarily wait until the action has been
completed.

=item B<drmaa_delete_job_template>

( $error, $diagnosis ) = drmaa_delete_job_template( $jt );

$jt	The variable tracking the job template to be deleted.

purpose: Deallocate a job template. This routine has no effect on jobs.

=item B<drmaa_exit>

( $error, $diagnosis ) = drmaa_exit();

purpose:	Disengage from DRMAA library and allow the DRMAA library to
perform * any necessary internal clean up. This routine will end the
current DRMAA Session, but will not effect any jobs (e.g., queued and
running jobs will remain queued and running).

=item B<drmaa_get_attribute>

( $error, $value, $diagnosis ) = drmaa_get_attribute( $jt, $name );

$jt		The job template containing attributes

$name	The name of the attribute you want a value for.

purpose:	If $name is an existing non-vector attribute name in the
job template $jt, then the value of the attribute called $name is
returned.

see also:	non-vector attributes section above.  drmaa_get_attribute_names,
drmaa_set_attribute, drmaa_get_next_attr_name and
drmaa_release_attr_names.

=item B<drmaa_get_attribute_names>

( $error, $names, $daignosis ) = drmaa_get_attribute_names()

$names	A variable to track the $names iterator

purpose:	Returns the set of supported attribute names ( in the iterator $names ).
This set will include supported DRMAA reserved attribute names *and* underlying
DRM native attribute names.

see also: non-vector attributes section above.  drmaa_set_attribute,
drmaa_release_attr_names, drmaa_get_next_attr_name and drmaa_get_attribute

=item B<drmaa_get_contact>

( $error, $contact, $diagnosis ) = drmaa_get_contact();

$contact	A comma separated list of contacts

purpose:	If called before drmaa_init(), it will return a comma delimited
default DRMAA implementation contacts string, one per each DRM system
provided implementation. If called after drmaa_init(), it will return the
selected contact string. The output string is Implementation dependent.

=item B<drmaa_get_DRM_system>

( $error, $DRM_system, $diagnosis ) = drmaa_version();

$DRM_system	A comma separated list of DRM systems.

purpose:  If called before drmaa_init(), it will
return a comma delimited DRM systems string, one per each DRM system
provided implementation.  If called after drmaa_init(), it will return
the selected DRM system. This string is implementation dependent.

=item B<drmaa_get_DRMAA_implementation>

( $error, $DRMAA_impl, $diagnosis ) = drmaa_get_DRMAA_implementation();

$DRMAA_impl	The DRMAA implementation.

purpose:  Returns the DRMAA_implementation.  If called before
drmaa_init(), it returns a comma delimited DRMAA implementations string,
one per each DRM system provided implementation. If called after
drmaa_init(), it returns the selected DRMAA implementation.  The output
string is implementation dependent.

=item B<drmaa_get_next_attr_name>

( $error, $name ) = drmaa_get_next_attr_name( $names );

$names	The names iterator

purpose:  Retrieves the next attribute name from the $names iterator.
Returns $DRMAA_ERRNO_SUCCESS on success.  Otherwise, the $names
iterator has no more names to return.

see also:	non-vector attributes section above.  drmaa_set_attribute,
drmaa_get_attribute_names, drmaa_release_attr_names and
drmaa_get_attribute.

=item B<drmaa_get_next_attr_value>

( $error, $value ) = drmaa_get_next_attr_value( $values );

$values	The iterator containing the vector attribute values

$value	The next value in the iterator

purpose: Get next attribute value from vector attributes iterator

see also:	vector attributes section above.  drmaa_set_vector_attribute,
drmaa_get_vector_attribute, drmaa_get_vector_attribute_names and
drmaa_release_attr_values

=item B<drmaa_get_next_job_id>

( $error, $jobid ) = drmaa_get_next_job_id( $jobids );

$jobids	The structure containing a list of jobids.

$jobid	The next job id.

purpose: Returns the next job id in the $jobids structure.  $jobids is
usually built up via successive calls to drmaa_run_job or via
drmaa_run_bulk_jobs.

=item B<drmaa_get_vector_attribute>

( $error, $values, $diagnosis ) = drmaa_get_vector_attribute( $jt, $name );

$jt		The job template containing the vector attributes you are querying

$name	The vector attribute you want the values of

$values	The vector attributes iterator, contains all the values associated
with the vector attribute $name

purpose:  If $name is an existing vector attribute name in the job template $jt,
then the values of $name are returned in $values and $error =
$DRMAA_ERRNO_SUCCESS; otherwise, undef is returned for $values and $error =
$DRMAA_ERRNO_INVALID_ATTRIBUTE_VALUE

see also:	vector attributes section above.  drmaa_set_vector_attribute,
drmaa_get_vector_attribute_names, drmaa_get_next_attr_value and
drmaa_release_attr_values

=item B<drmaa_get_vector_attribute_names>

( $error, $names, $diagnosis ) = drmaa_get_vector_attribute_names();

$names	names iterator ( use drmaa_get_next_attr_name to iterate )

purpose:	Will return the set of supported attribute names who contain
vector attributes.  This set will include supported DRMAA reserved
attribute names and DRM native attribute names.

see also:	vector attributes section above.  drmaa_set_vector_attribute,
drmaa_get_vector_attribute, drmaa_get_next_attr_value and
drmaa_release_attr_values

=item B<drmaa_init>

( $error, $diagnosis ) = drmaa_init( $contact );

$contact	The DRM system to be used.  If $contact is undef, the default
DRM system will be used provided there is only one DRMAA implementation.

purpose: Initialize DRMAA API library and create a new DRMAA Session.

=item B<drmaa_job_ps>

( $error, $remoteps, $diagnosis ) = drmaa_job_ps( $jobid );

$remoteps	The process state of the job.  One of the following states:

$DRMAA_PS_UNDETERMINED          process status cannot be determined

$DRMAA_PS_QUEUED_ACTIVE         job is queued and active

$DRMAA_PS_SYSTEM_ON_HOLD        job is queued and in system hold

$DRMAA_PS_USER_ON_HOLD          job is queued and in user hold

$DRMAA_PS_USER_SYSTEM_ON_HOLD   job is queued and in user and system hold

$DRMAA_PS_RUNNING               job is running

$DRMAA_PS_SYSTEM_SUSPENDED      job is system suspended

$DRMAA_PS_USER_SUSPENDED        job is user suspended

$DRMAA_PS_USER_SYSTEM_SUSPENDED job is user and system suspended

$DRMAA_PS_DONE                  job finished normally

$DRMAA_PS_FAILED                job finished, but failed (or terminated)

purpose:  Get the program status of the job identified by $job_id.

=item B<drmaa_release_attr_names>

drmaa_release_attr_names( $names );

purpose:  Releases the $names iterator.  The $names iterator can be used
without restriction until it has been formerly released using this
method, which also frees the memory of the iterator.  It is good idea to
coincide garbage collection of the $names scalar in Perl at the same
time as releasing it via this method, to prevent possible illegal actions
with the freed memory.

see also:  non-vector attributes section above.  drmaa_set_attribute,
drmaa_get_attribute_names, drmaa_get_next_attr_name and
drmaa_get_attribute.

=item B<drmaa_release_attr_values>

drmaa_release_attr_values( $values )

$values	The values iterator to be released.

purpose: Releases the $values iterator.  The $values iterator can be used
without restriction until it has been formerly released using this
method, which also frees the memory of the iterator.  It is good idea to
coincide garbage collection of the $values scalar in Perl at the same
time as releasing it via this method, to prevent possible illegal actions
with the freed memory.

see also:	vector attributes section above.  drmaa_set_vector_attribute,
drmaa_get_vector_attribute, drmaa_get_vector_attribute_names and
drmaa_get_next_attr_value.

=item B<drmaa_release_job_ids>

drmaa_release_job_ids( $jobids );

$jobids	The structure containing a list of jobids.

purpose:  This function releases the underlying structure $jobids.  It
does not affect any running jobs, but merely frees the $jobids structure.

=item B<drmaa_run_bulk_jobs>

( $error, $jobids, $diagnosis ) = drmaa_run_bulk_jobs( $jobids, $jt, $start, $end, $incr )

$jobids	A variable to contain a structure that will be filled with
the job ids of the jobs that were created as result of calling this
function.

$jt		The job template containing the attributes to be used when
running this set of parametric jobs.

$start	The parametric job index to begin with.

$end		The parametric job index to end with.

$incr	The amount to increase the parametric job index, for each job
created.

purpose:	Submit a set of parametric jobs, dependent on the implied loop
index, each with attributes defined in the job template $jt.

=item B<drmaa_run_job>

( $error, $jobid, $diagnosis ) = drmaa_run_job( $jt )

$jt		The variable that is the job template structure

$jobid	The job ID returned by the DRM, ie an SGE array job can be of the form 123.4

The job identifier $job_id is string identical to that returned by the
underlying DRM system.

=item B<drmaa_set_attribute>

( $error, $diagnosis ) = drmaa_set_attribute( $jt, $name, $value );

$jt		The variable that is the job template structure

$name	The attribute name:

$value	The value the attribute will be set to.

purpose:	Adds ( $name, $value ) pair to non-vector attributes in job
template $jt. Only non-vector attributes can be passed.

drmaa_set_attribute() returns $DRMAA_ERRNO_SUCCESS on success, otherwise:
$DRMAA_ERRNO_INVALID_ATTRIBUTE_FORMAT,
$DRMAA_ERRNO_INVALID_ARGUMENT, $DRMAA_ERRNO_NO_MEMORY,
$DRMAA_ERRNO_INVALID_ATTRIBUTE_VALUE or
$DRMAA_ERRNO_CONFLICTING_ATTRIBUTE_VALUES.

see also:  non-vector attributes section above. drmaa_get_attribute_names,
drmaa_get_next_attr_name, drmaa_get_attribute and
drmaa_release_attr_names.

=item B<drmaa_strerror>

$errstr = drmaa_strerror( $error );

$error	Returned by most drmaa_* functions

$errstr	A text representation of the $error value.

purpose: Returns the error message text associated with the error number.
Returns undef if called with an invalid error number.

=item B<drmaa_set_vector_attribute>

( $error, $diagnosis ) = drmaa_set_vector_attribute( $jt, $name, $values )

e.g.  # put this script's first two ARGV values into $jt
	( $error, $diagnosis ) = drmaa_set_vector_attribute( $jt, $DRMAA_V_ARGV, [ $ARGV[0], $ARGV[1] ] )

$jt		The job template to set vector attributes on

$name	The vector attribute name

$values	A reference to an array of values to associate to $name

purpose: Adds the vector attribute $name and its list of values in the
$values array reference, to the vector attributes of the job template
$jt. drmaa_set_vector_attribute() returns $DRMAA_ERRNO_SUCCESS on success.

see also:  vector attributes section above.  drmaa_get_next_attr_value,
drmaa_get_vector_attribute, drmaa_get_vector_attribute_names and
drmaa_release_attr_values

=item B<drmaa_synchronize>

( $error, $diagnosis ) = drmaa_synchronize( $job_ids, $timeout, $dispose );

e.g.	my @job_constant = ( $DRMAA_JOB_IDS_SESSION_ALL );
	( $error, $diagnosis ) = drmaa_synchronize( \@job_constant, $DRMAA_ERRNO_EXIT_TIMEOUT, 0 );

$job_ids	The list of jobs ids to synchronize with (or constant)

$timeout	The amount of time to wait before returning

$dispose	specifies how to treat reaping information:  0 do not reap, 1
"fake reap", i.e. dispose of the rusage data

Wait until all jobs specified by $job_ids have finished execution. If
$job_ids is $DRMAA_JOB_IDS_SESSION_ALL, then this routine  waits for all
jobs *submitted* during this DRMAA session. The $timeout value is used to
specify the number of seconds to wait for the job to fail finish before
returning if a result is not immediately available.  The value
$DRMAA_TIMEOUT_WAIT_FOREVER can be used to specify that routine should
wait indefinitely for a result. The value $DRMAA_TIMEOUT_NO_WAIT can be
used to specify that the routine should return immediately if no result
is available. If the call exits before $timeout, all the jobs have been
waited on or there was an interrupt.  If the invocation exits on
$timeout, the return code is $DRMAA_ERRNO_EXIT_TIMEOUT.  The caller should
check system time before and after this call in order to check how much
time has passed.

drmaa_synchronize() returns $DRMAA_ERRNO_SUCCESS on success, otherwise:
$DRMAA_ERRNO_DRM_COMMUNICATION_FAILURE, $DRMAA_ERRNO_AUTH_FAILURE,
$DRMAA_ERRNO_NO_MEMORY, $DRMAA_ERRNO_EXIT_TIMEOUT or
$DRMAA_ERRNO_INVALID_JOB.


=item B<drmaa_wait>

( $error, $job_id_out, $stat, $rusage, $diagnosis ) = drmaa_wait( $job_id, $timeout );

$job_id		The job to wait and/or reap

$timeout		The number of seconds to wait before returning

$job_id_out	The job id which was waited, might be same as $job_id

$stat		A value given to drmaa_w* funcs for more info

$rusage		A values iterator, provides resources used info

purpose:	This routine will wait for a job with $job_id to fail or finish
execution. If the special string, $DRMAA_JOB_IDS_SESSION_ANY, is provided
as the job_id, this routine will wait for any job from the session. This
routine is modeled on the wait3 POSIX routine.  The $timeout value is used
to specify the number of seconds to wait for the job to fail or finish
before returning if a result is not immediately available.  The value
$DRMAA_TIMEOUT_WAIT_FOREVER can be used to specify that routine should
wait indefinitely for a result.  The value $DRMAA_TIMEOUT_NO_WAIT may be
specified that the routine should return immediately if no result is
available.  If the call exits before $timeout, the job has been waited on
successfully or there was an interrupt.  If the invocation exits on
$timeout, the return code is $DRMAA_ERRNO_EXIT_TIMEOUT.  The routine reaps
jobs on a successful call, so any subsequent calls to drmaa_wait will
fail returning $DRMAA_ERRNO_INVALID_JOB meaning that the job has already
been reaped.  This error is the same as if the job was unknown.  Failing
due to an elapsed $timeout has an effect that it is possible to issue
drmaa_wait multiple times for the same job_id.

drmaa_wait() returns $DRMAA_ERRNO_SUCCESS on success, otherwise:
$DRMAA_ERRNO_DRM_COMMUNICATION_FAILURE, $DRMAA_ERRNO_AUTH_FAILURE,
$DRMAA_ERRNO_NO_RUSAGE, $DRMAA_ERRNO_NO_MEMORY, $DRMAA_ERRNO_EXIT_TIMEOUT
or $DRMAA_ERRNO_INVALID_JOB.

  When successful, the rusage information SHALL be provided as an array of
strings, where each string complies with the format <name>=<value>. The
string portion <value> contains the amount of resources consumed by the
job and is opaque.

The $stat drmaa_wait parameter is used in the drmaa_w* functions for
providing more detailed information about job termination if available. An
analogous set of macros is defined in POSIX for analyzing the wait3(2) OUT
parameter 'stat'.

drmaa_synchronize() returns DRMAA_ERRNO_SUCCESS on success, otherwise:
DRMAA_ERRNO_DRM_COMMUNICATION_FAILURE, DRMAA_ERRNO_AUTH_FAILURE,
DRMAA_ERRNO_NO_RUSAGE, DRMAA_ERRNO_NO_MEMORY, DRMAA_ERRNO_EXIT_TIMEOUT or
DRMAA_ERRNO_INVALID_JOB.

=item B<drmaa_wcoredump>

( $error, $core_dumped, $diagnosis ) = drmaa_wcoredump( $stat );

$stat		from $stat parameter of drmaa_wait

$core_dumped	non-zero if core image of job was created


If the $signaled parameter of drmaa_wifsignaled( $stat ) is
non-zero, this function evaluates into $core_dumped a non-zero value
if a core image of the terminated job was created.

=item B<drmaa_wifaborted>

	( $error, $aborted, $diagnosis ) = drmaa_wifaborted( $stat );
	
$stat		from $stat parameter of drmaa_wait

$aborted		non-zero if the job aborted

Evaluates into $aborted a non-zero value, if drmaa_wait returned a
non-zero value for $stat, indicating a job ended before entering the
running state.

=item B<drmaa_wexitstatus>

( $error, $exit_status, $diagnosis ) = drmaa_wexitstatus( $stat )

$stat		from $stat parameter of drmaa_wait

$exit_status	The exit code of the job

purpose:	If the $exited parameter of drmaa_wifexited() is non-zero, this
function evaluates into $exit_code the exit code that the job returned.

=item B<drmaa_wifexited>

( $error, $exited, $diagnosis ) = drmaa_wifexited( $stat );

$stat		from $stat parameter of drmaa_wait

$exited		non-zero if a problem was determined with the job

purpose:  Evaluates into $exited a non-zero value if $stat was returned
for a job that terminated normally.  A zero value can also indicate that
although the job has terminated normally an exit status is not available
or that it is not known whether the job terminated normally. In both
cases drmaa_wexitstatus will not provide exit status information.
A non-zero $exited value indicates more detailed diagnosis can be
provided by means of drmaa_wifsignaled(), drmaa_wtermsig() and
drmaa_wcoredump().

=item B<drmaa_wifsignaled>

( $error, $signaled, $diagnosis ) = drmaa_wifsignaled( $stat );

$stat	from $stat parameter of drmaa_wait

$signaled	true if job died due to a signal

purpose:  Evaluates into $signaled a non-zero value, if $stat from
drmaa_wait returned non-zero, for a job that terminated due to the receipt
of a signal. A zero value can also indicate that although the job has
terminated due to the receipt of a signal the signal is not available or
that it is not known whether the job terminated due to the receipt of a
signal. In both cases drmaa_wtermsig() doesn't provide signal information.

=item B<drmaa_wtermsig>

( $error, $termsig, $diagnosis ) = drmaa_wtermsig( $stat );

$stat	from $stat parameter of drmaa_wait

$termsig	the symbolic name of the signal

purpose:  If $signaled of drmaa_wifsignaled( $stat ) is non-zero, this
function evaluates into $termsig a string representation of the signal
that caused the termination of the job.  For signals declared by POSIX,
the symbolic names are returned (e.g., SIGABRT, SIGALRM).  For signals not
declared by POSIX, any other string may be returned.

=item B<drmaa_version>

( $error, $major, $minor, $diagnosis ) = drmaa_version();

$major	major version number (non-negative integer)

$minor	minor version number (non-negative integer)

purpose:  Returns the major and minor version numbers of the DRMAA
library; for DRMAA 1.0, $major is 1 and $minor is 0.

=head1 SEE ALSO

http://www.drmaa.org

http://gridengine.sunsource.net

http://www.swig.org

=head1 ACKNOWLEDGEMENTS

Special thanks to the Grid Engine development team for their tireless
assistance with SGE technical issues and even the occasional C
programming guidance. Special thanks to Andreas Haas and Daniel Templeton
of SGE and DRMAA-WG who helped me with understanding the DRMAA spec and
SGE technical issues. Thanks to the SWIG users list for their help.

=head1 COPYRIGHT

Copyright (c) 2004, The Regents of the University of California.
Produced at the Lawrence Livermore National Laboratory.
Written by Tim Harsch <harsch1@llnl.gov>
UCRL-CODE-155918
All rights reserved.

This file is part of Schedule::DRMAAc. For details, see CPAN
Please also read LICENSE.txt which is found in this source distribution.

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License (as published by the
Free Software Foundation) version 2, dated June 1991.
This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY
OF MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the terms and conditions of the GNU General Public License for more
details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

=cut


# ---------- BASE METHODS -------------

package Schedule::DRMAAc;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Schedule::DRMAAc;

*drmaa_get_next_attr_name = *Schedule::DRMAAcc::drmaa_get_next_attr_name;
*drmaa_get_next_attr_value = *Schedule::DRMAAcc::drmaa_get_next_attr_value;
*drmaa_get_next_job_id = *Schedule::DRMAAcc::drmaa_get_next_job_id;
*drmaa_release_attr_names = *Schedule::DRMAAcc::drmaa_release_attr_names;
*drmaa_release_attr_values = *Schedule::DRMAAcc::drmaa_release_attr_values;
*drmaa_release_job_ids = *Schedule::DRMAAcc::drmaa_release_job_ids;
*drmaa_init = *Schedule::DRMAAcc::drmaa_init;
*drmaa_exit = *Schedule::DRMAAcc::drmaa_exit;
*drmaa_allocate_job_template = *Schedule::DRMAAcc::drmaa_allocate_job_template;
*drmaa_delete_job_template = *Schedule::DRMAAcc::drmaa_delete_job_template;
*drmaa_set_attribute = *Schedule::DRMAAcc::drmaa_set_attribute;
*drmaa_get_attribute = *Schedule::DRMAAcc::drmaa_get_attribute;
*drmaa_set_vector_attribute = *Schedule::DRMAAcc::drmaa_set_vector_attribute;
*drmaa_get_vector_attribute = *Schedule::DRMAAcc::drmaa_get_vector_attribute;
*drmaa_get_attribute_names = *Schedule::DRMAAcc::drmaa_get_attribute_names;
*drmaa_get_vector_attribute_names = *Schedule::DRMAAcc::drmaa_get_vector_attribute_names;
*drmaa_run_job = *Schedule::DRMAAcc::drmaa_run_job;
*drmaa_run_bulk_jobs = *Schedule::DRMAAcc::drmaa_run_bulk_jobs;
*drmaa_control = *Schedule::DRMAAcc::drmaa_control;
*drmaa_synchronize = *Schedule::DRMAAcc::drmaa_synchronize;
*drmaa_wait = *Schedule::DRMAAcc::drmaa_wait;
*drmaa_wifexited = *Schedule::DRMAAcc::drmaa_wifexited;
*drmaa_wexitstatus = *Schedule::DRMAAcc::drmaa_wexitstatus;
*drmaa_wifsignaled = *Schedule::DRMAAcc::drmaa_wifsignaled;
*drmaa_wtermsig = *Schedule::DRMAAcc::drmaa_wtermsig;
*drmaa_wcoredump = *Schedule::DRMAAcc::drmaa_wcoredump;
*drmaa_wifaborted = *Schedule::DRMAAcc::drmaa_wifaborted;
*drmaa_job_ps = *Schedule::DRMAAcc::drmaa_job_ps;
*drmaa_strerror = *Schedule::DRMAAcc::drmaa_strerror;
*drmaa_get_contact = *Schedule::DRMAAcc::drmaa_get_contact;
*drmaa_version = *Schedule::DRMAAcc::drmaa_version;
*drmaa_get_DRM_system = *Schedule::DRMAAcc::drmaa_get_DRM_system;
*drmaa_get_DRMAA_implementation = *Schedule::DRMAAcc::drmaa_get_DRMAA_implementation;

# ------- VARIABLE STUBS --------

package Schedule::DRMAAc;

*DRMAA_ATTR_BUFFER = *Schedule::DRMAAcc::DRMAA_ATTR_BUFFER;
*DRMAA_CONTACT_BUFFER = *Schedule::DRMAAcc::DRMAA_CONTACT_BUFFER;
*DRMAA_DRM_SYSTEM_BUFFER = *Schedule::DRMAAcc::DRMAA_DRM_SYSTEM_BUFFER;
*DRMAA_ERROR_STRING_BUFFER = *Schedule::DRMAAcc::DRMAA_ERROR_STRING_BUFFER;
*DRMAA_JOBNAME_BUFFER = *Schedule::DRMAAcc::DRMAA_JOBNAME_BUFFER;
*DRMAA_SIGNAL_BUFFER = *Schedule::DRMAAcc::DRMAA_SIGNAL_BUFFER;
*DRMAA_TIMEOUT_WAIT_FOREVER = *Schedule::DRMAAcc::DRMAA_TIMEOUT_WAIT_FOREVER;
*DRMAA_TIMEOUT_NO_WAIT = *Schedule::DRMAAcc::DRMAA_TIMEOUT_NO_WAIT;
*DRMAA_JOB_IDS_SESSION_ANY = *Schedule::DRMAAcc::DRMAA_JOB_IDS_SESSION_ANY;
*DRMAA_JOB_IDS_SESSION_ALL = *Schedule::DRMAAcc::DRMAA_JOB_IDS_SESSION_ALL;
*DRMAA_SUBMISSION_STATE_ACTIVE = *Schedule::DRMAAcc::DRMAA_SUBMISSION_STATE_ACTIVE;
*DRMAA_SUBMISSION_STATE_HOLD = *Schedule::DRMAAcc::DRMAA_SUBMISSION_STATE_HOLD;
*DRMAA_PLACEHOLDER_INCR = *Schedule::DRMAAcc::DRMAA_PLACEHOLDER_INCR;
*DRMAA_PLACEHOLDER_HD = *Schedule::DRMAAcc::DRMAA_PLACEHOLDER_HD;
*DRMAA_PLACEHOLDER_WD = *Schedule::DRMAAcc::DRMAA_PLACEHOLDER_WD;
*DRMAA_REMOTE_COMMAND = *Schedule::DRMAAcc::DRMAA_REMOTE_COMMAND;
*DRMAA_JS_STATE = *Schedule::DRMAAcc::DRMAA_JS_STATE;
*DRMAA_WD = *Schedule::DRMAAcc::DRMAA_WD;
*DRMAA_JOB_CATEGORY = *Schedule::DRMAAcc::DRMAA_JOB_CATEGORY;
*DRMAA_NATIVE_SPECIFICATION = *Schedule::DRMAAcc::DRMAA_NATIVE_SPECIFICATION;
*DRMAA_BLOCK_EMAIL = *Schedule::DRMAAcc::DRMAA_BLOCK_EMAIL;
*DRMAA_START_TIME = *Schedule::DRMAAcc::DRMAA_START_TIME;
*DRMAA_JOB_NAME = *Schedule::DRMAAcc::DRMAA_JOB_NAME;
*DRMAA_INPUT_PATH = *Schedule::DRMAAcc::DRMAA_INPUT_PATH;
*DRMAA_OUTPUT_PATH = *Schedule::DRMAAcc::DRMAA_OUTPUT_PATH;
*DRMAA_ERROR_PATH = *Schedule::DRMAAcc::DRMAA_ERROR_PATH;
*DRMAA_JOIN_FILES = *Schedule::DRMAAcc::DRMAA_JOIN_FILES;
*DRMAA_TRANSFER_FILES = *Schedule::DRMAAcc::DRMAA_TRANSFER_FILES;
*DRMAA_DEADLINE_TIME = *Schedule::DRMAAcc::DRMAA_DEADLINE_TIME;
*DRMAA_WCT_HLIMIT = *Schedule::DRMAAcc::DRMAA_WCT_HLIMIT;
*DRMAA_WCT_SLIMIT = *Schedule::DRMAAcc::DRMAA_WCT_SLIMIT;
*DRMAA_DURATION_HLIMIT = *Schedule::DRMAAcc::DRMAA_DURATION_HLIMIT;
*DRMAA_DURATION_SLIMIT = *Schedule::DRMAAcc::DRMAA_DURATION_SLIMIT;
*DRMAA_V_ARGV = *Schedule::DRMAAcc::DRMAA_V_ARGV;
*DRMAA_V_ENV = *Schedule::DRMAAcc::DRMAA_V_ENV;
*DRMAA_V_EMAIL = *Schedule::DRMAAcc::DRMAA_V_EMAIL;
*DRMAA_ERRNO_SUCCESS = *Schedule::DRMAAcc::DRMAA_ERRNO_SUCCESS;
*DRMAA_ERRNO_INTERNAL_ERROR = *Schedule::DRMAAcc::DRMAA_ERRNO_INTERNAL_ERROR;
*DRMAA_ERRNO_DRM_COMMUNICATION_FAILURE = *Schedule::DRMAAcc::DRMAA_ERRNO_DRM_COMMUNICATION_FAILURE;
*DRMAA_ERRNO_AUTH_FAILURE = *Schedule::DRMAAcc::DRMAA_ERRNO_AUTH_FAILURE;
*DRMAA_ERRNO_INVALID_ARGUMENT = *Schedule::DRMAAcc::DRMAA_ERRNO_INVALID_ARGUMENT;
*DRMAA_ERRNO_NO_ACTIVE_SESSION = *Schedule::DRMAAcc::DRMAA_ERRNO_NO_ACTIVE_SESSION;
*DRMAA_ERRNO_NO_MEMORY = *Schedule::DRMAAcc::DRMAA_ERRNO_NO_MEMORY;
*DRMAA_ERRNO_INVALID_CONTACT_STRING = *Schedule::DRMAAcc::DRMAA_ERRNO_INVALID_CONTACT_STRING;
*DRMAA_ERRNO_DEFAULT_CONTACT_STRING_ERROR = *Schedule::DRMAAcc::DRMAA_ERRNO_DEFAULT_CONTACT_STRING_ERROR;
*DRMAA_ERRNO_DRMS_INIT_FAILED = *Schedule::DRMAAcc::DRMAA_ERRNO_DRMS_INIT_FAILED;
*DRMAA_ERRNO_ALREADY_ACTIVE_SESSION = *Schedule::DRMAAcc::DRMAA_ERRNO_ALREADY_ACTIVE_SESSION;
*DRMAA_ERRNO_DRMS_EXIT_ERROR = *Schedule::DRMAAcc::DRMAA_ERRNO_DRMS_EXIT_ERROR;
*DRMAA_ERRNO_INVALID_ATTRIBUTE_FORMAT = *Schedule::DRMAAcc::DRMAA_ERRNO_INVALID_ATTRIBUTE_FORMAT;
*DRMAA_ERRNO_INVALID_ATTRIBUTE_VALUE = *Schedule::DRMAAcc::DRMAA_ERRNO_INVALID_ATTRIBUTE_VALUE;
*DRMAA_ERRNO_CONFLICTING_ATTRIBUTE_VALUES = *Schedule::DRMAAcc::DRMAA_ERRNO_CONFLICTING_ATTRIBUTE_VALUES;
*DRMAA_ERRNO_TRY_LATER = *Schedule::DRMAAcc::DRMAA_ERRNO_TRY_LATER;
*DRMAA_ERRNO_DENIED_BY_DRM = *Schedule::DRMAAcc::DRMAA_ERRNO_DENIED_BY_DRM;
*DRMAA_ERRNO_INVALID_JOB = *Schedule::DRMAAcc::DRMAA_ERRNO_INVALID_JOB;
*DRMAA_ERRNO_RESUME_INCONSISTENT_STATE = *Schedule::DRMAAcc::DRMAA_ERRNO_RESUME_INCONSISTENT_STATE;
*DRMAA_ERRNO_SUSPEND_INCONSISTENT_STATE = *Schedule::DRMAAcc::DRMAA_ERRNO_SUSPEND_INCONSISTENT_STATE;
*DRMAA_ERRNO_HOLD_INCONSISTENT_STATE = *Schedule::DRMAAcc::DRMAA_ERRNO_HOLD_INCONSISTENT_STATE;
*DRMAA_ERRNO_RELEASE_INCONSISTENT_STATE = *Schedule::DRMAAcc::DRMAA_ERRNO_RELEASE_INCONSISTENT_STATE;
*DRMAA_ERRNO_EXIT_TIMEOUT = *Schedule::DRMAAcc::DRMAA_ERRNO_EXIT_TIMEOUT;
*DRMAA_ERRNO_NO_RUSAGE = *Schedule::DRMAAcc::DRMAA_ERRNO_NO_RUSAGE;
*DRMAA_NO_ERRNO = *Schedule::DRMAAcc::DRMAA_NO_ERRNO;
*DRMAA_PS_UNDETERMINED = *Schedule::DRMAAcc::DRMAA_PS_UNDETERMINED;
*DRMAA_PS_QUEUED_ACTIVE = *Schedule::DRMAAcc::DRMAA_PS_QUEUED_ACTIVE;
*DRMAA_PS_SYSTEM_ON_HOLD = *Schedule::DRMAAcc::DRMAA_PS_SYSTEM_ON_HOLD;
*DRMAA_PS_USER_ON_HOLD = *Schedule::DRMAAcc::DRMAA_PS_USER_ON_HOLD;
*DRMAA_PS_USER_SYSTEM_ON_HOLD = *Schedule::DRMAAcc::DRMAA_PS_USER_SYSTEM_ON_HOLD;
*DRMAA_PS_RUNNING = *Schedule::DRMAAcc::DRMAA_PS_RUNNING;
*DRMAA_PS_SYSTEM_SUSPENDED = *Schedule::DRMAAcc::DRMAA_PS_SYSTEM_SUSPENDED;
*DRMAA_PS_USER_SUSPENDED = *Schedule::DRMAAcc::DRMAA_PS_USER_SUSPENDED;
*DRMAA_PS_USER_SYSTEM_SUSPENDED = *Schedule::DRMAAcc::DRMAA_PS_USER_SYSTEM_SUSPENDED;
*DRMAA_PS_DONE = *Schedule::DRMAAcc::DRMAA_PS_DONE;
*DRMAA_PS_FAILED = *Schedule::DRMAAcc::DRMAA_PS_FAILED;
*DRMAA_CONTROL_SUSPEND = *Schedule::DRMAAcc::DRMAA_CONTROL_SUSPEND;
*DRMAA_CONTROL_RESUME = *Schedule::DRMAAcc::DRMAA_CONTROL_RESUME;
*DRMAA_CONTROL_HOLD = *Schedule::DRMAAcc::DRMAA_CONTROL_HOLD;
*DRMAA_CONTROL_RELEASE = *Schedule::DRMAAcc::DRMAA_CONTROL_RELEASE;
*DRMAA_CONTROL_TERMINATE = *Schedule::DRMAAcc::DRMAA_CONTROL_TERMINATE;
1;
