# Generated by default/object.tt
package Paws::CloudWatchEvents::RetryPolicy;
  use Moose;
  has MaximumEventAgeInSeconds => (is => 'ro', isa => 'Int');
  has MaximumRetryAttempts => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::RetryPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::RetryPolicy object:

  $service_obj->Method(Att1 => { MaximumEventAgeInSeconds => $value, ..., MaximumRetryAttempts => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::RetryPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->MaximumEventAgeInSeconds

=head1 DESCRIPTION

A C<RetryPolicy> object that includes information about the retry
policy settings.

=head1 ATTRIBUTES


=head2 MaximumEventAgeInSeconds => Int

The maximum amount of time, in seconds, to continue to make retry
attempts.


=head2 MaximumRetryAttempts => Int

The maximum number of retry attempts to make before the request fails.
Retry attempts continue until either the maximum number of attempts is
made or until the duration of the C<MaximumEventAgeInSeconds> is met.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

